
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQComboBox.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QComboBox>
#include <QAbstractItemDelegate>
#include <QAbstractItemModel>
#include <QAbstractItemView>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QCompleter>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEnterEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLineEdit>
#include <QLocale>
#include <QMargins>
#include <QMetaMethod>
#include <QModelIndex>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QPointF>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QScreen>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOptionComboBox>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QValidator>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QComboBox

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QComboBox::staticMetaObject);
}


// void QComboBox::addItem(const QString &text, const QVariant &userData)


static void _init_f_addItem_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("userData", true, "QVariant()");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addItem_4036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg2 = args ? gsi::arg_reader<const QVariant & >() (args, heap) : gsi::arg_maker<const QVariant & >() (QVariant(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->addItem (arg1, arg2);
}


// void QComboBox::addItem(const QIcon &icon, const QString &text, const QVariant &userData)


static void _init_f_addItem_5715 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("userData", true, "QVariant()");
  decl->add_arg<const QVariant & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_addItem_5715 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg3 = args ? gsi::arg_reader<const QVariant & >() (args, heap) : gsi::arg_maker<const QVariant & >() (QVariant(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->addItem (arg1, arg2, arg3);
}


// void QComboBox::addItems(const QStringList &texts)


static void _init_f_addItems_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("texts");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addItems_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->addItems (arg1);
}


// void QComboBox::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->clear ();
}


// void QComboBox::clearEditText()


static void _init_f_clearEditText_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearEditText_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->clearEditText ();
}


// QCompleter *QComboBox::completer()


static void _init_f_completer_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCompleter * > ();
}

static void _call_f_completer_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCompleter * > ((QCompleter *)((QComboBox *)cls)->completer ());
}


// int QComboBox::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QComboBox *)cls)->count ());
}


// QVariant QComboBox::currentData(int role)


static void _init_f_currentData_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("role", true, "Qt::UserRole");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_currentData_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::UserRole, heap);
  ret.write<QVariant > ((QVariant)((QComboBox *)cls)->currentData (arg1));
}


// int QComboBox::currentIndex()


static void _init_f_currentIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QComboBox *)cls)->currentIndex ());
}


// QString QComboBox::currentText()


static void _init_f_currentText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_currentText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QComboBox *)cls)->currentText ());
}


// bool QComboBox::duplicatesEnabled()


static void _init_f_duplicatesEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_duplicatesEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QComboBox *)cls)->duplicatesEnabled ());
}


// bool QComboBox::event(QEvent *event)


static void _init_f_event_1217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_event_1217 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = gsi::arg_reader<QEvent * >() (args, heap);
  ret.write<bool > ((bool)((QComboBox *)cls)->event (arg1));
}


// int QComboBox::findData(const QVariant &data, int role, QFlags<Qt::MatchFlag> flags)


static void _init_f_findData_c4986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QVariant & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role", true, "Qt::UserRole");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "static_cast<Qt::MatchFlags>(Qt::MatchExactly|Qt::MatchCaseSensitive)");
  decl->add_arg<QFlags<Qt::MatchFlag> > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_findData_c4986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = gsi::arg_reader<const QVariant & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::UserRole, heap);
  QFlags<Qt::MatchFlag> arg3 = args ? gsi::arg_reader<QFlags<Qt::MatchFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::MatchFlag> >() (static_cast<Qt::MatchFlags>(Qt::MatchExactly|Qt::MatchCaseSensitive), heap);
  ret.write<int > ((int)((QComboBox *)cls)->findData (arg1, arg2, arg3));
}


// int QComboBox::findText(const QString &text, QFlags<Qt::MatchFlag> flags)


static void _init_f_findText_c4233 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "static_cast<Qt::MatchFlags>(Qt::MatchExactly|Qt::MatchCaseSensitive)");
  decl->add_arg<QFlags<Qt::MatchFlag> > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_findText_c4233 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QFlags<Qt::MatchFlag> arg2 = args ? gsi::arg_reader<QFlags<Qt::MatchFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::MatchFlag> >() (static_cast<Qt::MatchFlags>(Qt::MatchExactly|Qt::MatchCaseSensitive), heap);
  ret.write<int > ((int)((QComboBox *)cls)->findText (arg1, arg2));
}


// bool QComboBox::hasFrame()


static void _init_f_hasFrame_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasFrame_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QComboBox *)cls)->hasFrame ());
}


// void QComboBox::hidePopup()


static void _init_f_hidePopup_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_hidePopup_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->hidePopup ();
}


// QSize QComboBox::iconSize()


static void _init_f_iconSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_iconSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QComboBox *)cls)->iconSize ());
}


// QVariant QComboBox::inputMethodQuery(Qt::InputMethodQuery)


static void _init_f_inputMethodQuery_c2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_inputMethodQuery_c2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QComboBox *)cls)->inputMethodQuery (qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref()));
}


// QVariant QComboBox::inputMethodQuery(Qt::InputMethodQuery query, const QVariant &argument)


static void _init_f_inputMethodQuery_c4431 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("argument");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_inputMethodQuery_c4431 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QComboBox *)cls)->inputMethodQuery (qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref(), arg2));
}


// void QComboBox::insertItem(int index, const QString &text, const QVariant &userData)


static void _init_f_insertItem_4695 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("userData", true, "QVariant()");
  decl->add_arg<const QVariant & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_insertItem_4695 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg3 = args ? gsi::arg_reader<const QVariant & >() (args, heap) : gsi::arg_maker<const QVariant & >() (QVariant(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->insertItem (arg1, arg2, arg3);
}


// void QComboBox::insertItem(int index, const QIcon &icon, const QString &text, const QVariant &userData)


static void _init_f_insertItem_6374 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("icon");
  decl->add_arg<const QIcon & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("userData", true, "QVariant()");
  decl->add_arg<const QVariant & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_insertItem_6374 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QIcon &arg2 = gsi::arg_reader<const QIcon & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg4 = args ? gsi::arg_reader<const QVariant & >() (args, heap) : gsi::arg_maker<const QVariant & >() (QVariant(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->insertItem (arg1, arg2, arg3, arg4);
}


// void QComboBox::insertItems(int index, const QStringList &texts)


static void _init_f_insertItems_3096 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("texts");
  decl->add_arg<const QStringList & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertItems_3096 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QStringList &arg2 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->insertItems (arg1, arg2);
}


// QComboBox::InsertPolicy QComboBox::insertPolicy()


static void _init_f_insertPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QComboBox::InsertPolicy>::target_type > ();
}

static void _call_f_insertPolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QComboBox::InsertPolicy>::target_type > ((qt_gsi::Converter<QComboBox::InsertPolicy>::target_type)qt_gsi::CppToQtAdaptor<QComboBox::InsertPolicy>(((QComboBox *)cls)->insertPolicy ()));
}


// void QComboBox::insertSeparator(int index)


static void _init_f_insertSeparator_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertSeparator_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->insertSeparator (arg1);
}


// bool QComboBox::isEditable()


static void _init_f_isEditable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEditable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QComboBox *)cls)->isEditable ());
}


// QVariant QComboBox::itemData(int index, int role)


static void _init_f_itemData_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role", true, "Qt::UserRole");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_itemData_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::UserRole, heap);
  ret.write<QVariant > ((QVariant)((QComboBox *)cls)->itemData (arg1, arg2));
}


// QAbstractItemDelegate *QComboBox::itemDelegate()


static void _init_f_itemDelegate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemDelegate * > ();
}

static void _call_f_itemDelegate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractItemDelegate * > ((QAbstractItemDelegate *)((QComboBox *)cls)->itemDelegate ());
}


// QIcon QComboBox::itemIcon(int index)


static void _init_f_itemIcon_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QIcon > ();
}

static void _call_f_itemIcon_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QIcon > ((QIcon)((QComboBox *)cls)->itemIcon (arg1));
}


// QString QComboBox::itemText(int index)


static void _init_f_itemText_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_itemText_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)((QComboBox *)cls)->itemText (arg1));
}


// QLineEdit *QComboBox::lineEdit()


static void _init_f_lineEdit_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLineEdit * > ();
}

static void _call_f_lineEdit_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLineEdit * > ((QLineEdit *)((QComboBox *)cls)->lineEdit ());
}


// int QComboBox::maxCount()


static void _init_f_maxCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maxCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QComboBox *)cls)->maxCount ());
}


// int QComboBox::maxVisibleItems()


static void _init_f_maxVisibleItems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maxVisibleItems_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QComboBox *)cls)->maxVisibleItems ());
}


// int QComboBox::minimumContentsLength()


static void _init_f_minimumContentsLength_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minimumContentsLength_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QComboBox *)cls)->minimumContentsLength ());
}


// QSize QComboBox::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QComboBox *)cls)->minimumSizeHint ());
}


// QAbstractItemModel *QComboBox::model()


static void _init_f_model_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemModel * > ();
}

static void _call_f_model_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractItemModel * > ((QAbstractItemModel *)((QComboBox *)cls)->model ());
}


// int QComboBox::modelColumn()


static void _init_f_modelColumn_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_modelColumn_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QComboBox *)cls)->modelColumn ());
}


// QString QComboBox::placeholderText()


static void _init_f_placeholderText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_placeholderText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QComboBox *)cls)->placeholderText ());
}


// void QComboBox::removeItem(int index)


static void _init_f_removeItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeItem_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->removeItem (arg1);
}


// QModelIndex QComboBox::rootModelIndex()


static void _init_f_rootModelIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QModelIndex > ();
}

static void _call_f_rootModelIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QModelIndex > ((QModelIndex)((QComboBox *)cls)->rootModelIndex ());
}


// void QComboBox::setCompleter(QCompleter *c)


static void _init_f_setCompleter_1642 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<QCompleter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCompleter_1642 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCompleter *arg1 = gsi::arg_reader<QCompleter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setCompleter (arg1);
}


// void QComboBox::setCurrentIndex(int index)


static void _init_f_setCurrentIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentIndex_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setCurrentIndex (arg1);
}


// void QComboBox::setCurrentText(const QString &text)


static void _init_f_setCurrentText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setCurrentText (arg1);
}


// void QComboBox::setDuplicatesEnabled(bool enable)


static void _init_f_setDuplicatesEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDuplicatesEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setDuplicatesEnabled (arg1);
}


// void QComboBox::setEditText(const QString &text)


static void _init_f_setEditText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEditText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setEditText (arg1);
}


// void QComboBox::setEditable(bool editable)


static void _init_f_setEditable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEditable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setEditable (arg1);
}


// void QComboBox::setFrame(bool)


static void _init_f_setFrame_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFrame_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setFrame (arg1);
}


// void QComboBox::setIconSize(const QSize &size)


static void _init_f_setIconSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIconSize_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setIconSize (arg1);
}


// void QComboBox::setInsertPolicy(QComboBox::InsertPolicy policy)


static void _init_f_setInsertPolicy_2679 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<QComboBox::InsertPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInsertPolicy_2679 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QComboBox::InsertPolicy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QComboBox::InsertPolicy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setInsertPolicy (qt_gsi::QtToCppAdaptor<QComboBox::InsertPolicy>(arg1).cref());
}


// void QComboBox::setItemData(int index, const QVariant &value, int role)


static void _init_f_setItemData_3437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::UserRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setItemData_3437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::UserRole, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setItemData (arg1, arg2, arg3);
}


// void QComboBox::setItemDelegate(QAbstractItemDelegate *delegate)


static void _init_f_setItemDelegate_2717 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("delegate");
  decl->add_arg<QAbstractItemDelegate * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemDelegate_2717 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemDelegate *arg1 = gsi::arg_reader<QAbstractItemDelegate * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setItemDelegate (arg1);
}


// void QComboBox::setItemIcon(int index, const QIcon &icon)


static void _init_f_setItemIcon_2446 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("icon");
  decl->add_arg<const QIcon & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setItemIcon_2446 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QIcon &arg2 = gsi::arg_reader<const QIcon & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setItemIcon (arg1, arg2);
}


// void QComboBox::setItemText(int index, const QString &text)


static void _init_f_setItemText_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setItemText_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setItemText (arg1, arg2);
}


// void QComboBox::setLineEdit(QLineEdit *edit)


static void _init_f_setLineEdit_1485 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("edit");
  decl->add_arg<QLineEdit * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLineEdit_1485 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLineEdit *arg1 = gsi::arg_reader<QLineEdit * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setLineEdit (arg1);
}


// void QComboBox::setMaxCount(int max)


static void _init_f_setMaxCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("max");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaxCount_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setMaxCount (arg1);
}


// void QComboBox::setMaxVisibleItems(int maxItems)


static void _init_f_setMaxVisibleItems_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxItems");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaxVisibleItems_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setMaxVisibleItems (arg1);
}


// void QComboBox::setMinimumContentsLength(int characters)


static void _init_f_setMinimumContentsLength_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("characters");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumContentsLength_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setMinimumContentsLength (arg1);
}


// void QComboBox::setModel(QAbstractItemModel *model)


static void _init_f_setModel_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModel_2419 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setModel (arg1);
}


// void QComboBox::setModelColumn(int visibleColumn)


static void _init_f_setModelColumn_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visibleColumn");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModelColumn_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setModelColumn (arg1);
}


// void QComboBox::setPlaceholderText(const QString &placeholderText)


static void _init_f_setPlaceholderText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("placeholderText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlaceholderText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setPlaceholderText (arg1);
}


// void QComboBox::setRootModelIndex(const QModelIndex &index)


static void _init_f_setRootModelIndex_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRootModelIndex_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setRootModelIndex (arg1);
}


// void QComboBox::setSizeAdjustPolicy(QComboBox::SizeAdjustPolicy policy)


static void _init_f_setSizeAdjustPolicy_3080 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<QComboBox::SizeAdjustPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSizeAdjustPolicy_3080 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QComboBox::SizeAdjustPolicy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QComboBox::SizeAdjustPolicy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setSizeAdjustPolicy (qt_gsi::QtToCppAdaptor<QComboBox::SizeAdjustPolicy>(arg1).cref());
}


// void QComboBox::setValidator(const QValidator *v)


static void _init_f_setValidator_2332 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("v");
  decl->add_arg<const QValidator * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setValidator_2332 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QValidator *arg1 = gsi::arg_reader<const QValidator * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setValidator (arg1);
}


// void QComboBox::setView(QAbstractItemView *itemView)


static void _init_f_setView_2333 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("itemView");
  decl->add_arg<QAbstractItemView * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setView_2333 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemView *arg1 = gsi::arg_reader<QAbstractItemView * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->setView (arg1);
}


// void QComboBox::showPopup()


static void _init_f_showPopup_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showPopup_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->showPopup ();
}


// QComboBox::SizeAdjustPolicy QComboBox::sizeAdjustPolicy()


static void _init_f_sizeAdjustPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QComboBox::SizeAdjustPolicy>::target_type > ();
}

static void _call_f_sizeAdjustPolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QComboBox::SizeAdjustPolicy>::target_type > ((qt_gsi::Converter<QComboBox::SizeAdjustPolicy>::target_type)qt_gsi::CppToQtAdaptor<QComboBox::SizeAdjustPolicy>(((QComboBox *)cls)->sizeAdjustPolicy ()));
}


// QSize QComboBox::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QComboBox *)cls)->sizeHint ());
}


// void QComboBox::textActivated(const QString &)


static void _init_f_textActivated_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_textActivated_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->textActivated (arg1);
}


// void QComboBox::textHighlighted(const QString &)


static void _init_f_textHighlighted_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_textHighlighted_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox *)cls)->textHighlighted (arg1);
}


// const QValidator *QComboBox::validator()


static void _init_f_validator_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QValidator * > ();
}

static void _call_f_validator_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QValidator * > ((const QValidator *)((QComboBox *)cls)->validator ());
}


// QAbstractItemView *QComboBox::view()


static void _init_f_view_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemView * > ();
}

static void _call_f_view_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractItemView * > ((QAbstractItemView *)((QComboBox *)cls)->view ());
}


// static QString QComboBox::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QComboBox::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QComboBox () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addItem", "@brief Method void QComboBox::addItem(const QString &text, const QVariant &userData)\n", false, &_init_f_addItem_4036, &_call_f_addItem_4036);
  methods += new qt_gsi::GenericMethod ("addItem", "@brief Method void QComboBox::addItem(const QIcon &icon, const QString &text, const QVariant &userData)\n", false, &_init_f_addItem_5715, &_call_f_addItem_5715);
  methods += new qt_gsi::GenericMethod ("addItems", "@brief Method void QComboBox::addItems(const QStringList &texts)\n", false, &_init_f_addItems_2437, &_call_f_addItems_2437);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QComboBox::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("clearEditText", "@brief Method void QComboBox::clearEditText()\n", false, &_init_f_clearEditText_0, &_call_f_clearEditText_0);
  methods += new qt_gsi::GenericMethod (":completer", "@brief Method QCompleter *QComboBox::completer()\n", true, &_init_f_completer_c0, &_call_f_completer_c0);
  methods += new qt_gsi::GenericMethod (":count", "@brief Method int QComboBox::count()\n", true, &_init_f_count_c0, &_call_f_count_c0);
  methods += new qt_gsi::GenericMethod ("currentData", "@brief Method QVariant QComboBox::currentData(int role)\n", true, &_init_f_currentData_c767, &_call_f_currentData_c767);
  methods += new qt_gsi::GenericMethod (":currentIndex", "@brief Method int QComboBox::currentIndex()\n", true, &_init_f_currentIndex_c0, &_call_f_currentIndex_c0);
  methods += new qt_gsi::GenericMethod (":currentText", "@brief Method QString QComboBox::currentText()\n", true, &_init_f_currentText_c0, &_call_f_currentText_c0);
  methods += new qt_gsi::GenericMethod (":duplicatesEnabled", "@brief Method bool QComboBox::duplicatesEnabled()\n", true, &_init_f_duplicatesEnabled_c0, &_call_f_duplicatesEnabled_c0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Method bool QComboBox::event(QEvent *event)\nThis is a reimplementation of QWidget::event", false, &_init_f_event_1217, &_call_f_event_1217);
  methods += new qt_gsi::GenericMethod ("findData", "@brief Method int QComboBox::findData(const QVariant &data, int role, QFlags<Qt::MatchFlag> flags)\n", true, &_init_f_findData_c4986, &_call_f_findData_c4986);
  methods += new qt_gsi::GenericMethod ("findText", "@brief Method int QComboBox::findText(const QString &text, QFlags<Qt::MatchFlag> flags)\n", true, &_init_f_findText_c4233, &_call_f_findText_c4233);
  methods += new qt_gsi::GenericMethod ("hasFrame|:frame", "@brief Method bool QComboBox::hasFrame()\n", true, &_init_f_hasFrame_c0, &_call_f_hasFrame_c0);
  methods += new qt_gsi::GenericMethod ("hidePopup", "@brief Method void QComboBox::hidePopup()\n", false, &_init_f_hidePopup_0, &_call_f_hidePopup_0);
  methods += new qt_gsi::GenericMethod (":iconSize", "@brief Method QSize QComboBox::iconSize()\n", true, &_init_f_iconSize_c0, &_call_f_iconSize_c0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Method QVariant QComboBox::inputMethodQuery(Qt::InputMethodQuery)\nThis is a reimplementation of QWidget::inputMethodQuery", true, &_init_f_inputMethodQuery_c2420, &_call_f_inputMethodQuery_c2420);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Method QVariant QComboBox::inputMethodQuery(Qt::InputMethodQuery query, const QVariant &argument)\n", true, &_init_f_inputMethodQuery_c4431, &_call_f_inputMethodQuery_c4431);
  methods += new qt_gsi::GenericMethod ("insertItem", "@brief Method void QComboBox::insertItem(int index, const QString &text, const QVariant &userData)\n", false, &_init_f_insertItem_4695, &_call_f_insertItem_4695);
  methods += new qt_gsi::GenericMethod ("insertItem", "@brief Method void QComboBox::insertItem(int index, const QIcon &icon, const QString &text, const QVariant &userData)\n", false, &_init_f_insertItem_6374, &_call_f_insertItem_6374);
  methods += new qt_gsi::GenericMethod ("insertItems", "@brief Method void QComboBox::insertItems(int index, const QStringList &texts)\n", false, &_init_f_insertItems_3096, &_call_f_insertItems_3096);
  methods += new qt_gsi::GenericMethod (":insertPolicy", "@brief Method QComboBox::InsertPolicy QComboBox::insertPolicy()\n", true, &_init_f_insertPolicy_c0, &_call_f_insertPolicy_c0);
  methods += new qt_gsi::GenericMethod ("insertSeparator", "@brief Method void QComboBox::insertSeparator(int index)\n", false, &_init_f_insertSeparator_767, &_call_f_insertSeparator_767);
  methods += new qt_gsi::GenericMethod ("isEditable?|:editable", "@brief Method bool QComboBox::isEditable()\n", true, &_init_f_isEditable_c0, &_call_f_isEditable_c0);
  methods += new qt_gsi::GenericMethod ("itemData", "@brief Method QVariant QComboBox::itemData(int index, int role)\n", true, &_init_f_itemData_c1426, &_call_f_itemData_c1426);
  methods += new qt_gsi::GenericMethod (":itemDelegate", "@brief Method QAbstractItemDelegate *QComboBox::itemDelegate()\n", true, &_init_f_itemDelegate_c0, &_call_f_itemDelegate_c0);
  methods += new qt_gsi::GenericMethod ("itemIcon", "@brief Method QIcon QComboBox::itemIcon(int index)\n", true, &_init_f_itemIcon_c767, &_call_f_itemIcon_c767);
  methods += new qt_gsi::GenericMethod ("itemText", "@brief Method QString QComboBox::itemText(int index)\n", true, &_init_f_itemText_c767, &_call_f_itemText_c767);
  methods += new qt_gsi::GenericMethod (":lineEdit", "@brief Method QLineEdit *QComboBox::lineEdit()\n", true, &_init_f_lineEdit_c0, &_call_f_lineEdit_c0);
  methods += new qt_gsi::GenericMethod (":maxCount", "@brief Method int QComboBox::maxCount()\n", true, &_init_f_maxCount_c0, &_call_f_maxCount_c0);
  methods += new qt_gsi::GenericMethod (":maxVisibleItems", "@brief Method int QComboBox::maxVisibleItems()\n", true, &_init_f_maxVisibleItems_c0, &_call_f_maxVisibleItems_c0);
  methods += new qt_gsi::GenericMethod (":minimumContentsLength", "@brief Method int QComboBox::minimumContentsLength()\n", true, &_init_f_minimumContentsLength_c0, &_call_f_minimumContentsLength_c0);
  methods += new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QComboBox::minimumSizeHint()\nThis is a reimplementation of QWidget::minimumSizeHint", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
  methods += new qt_gsi::GenericMethod (":model", "@brief Method QAbstractItemModel *QComboBox::model()\n", true, &_init_f_model_c0, &_call_f_model_c0);
  methods += new qt_gsi::GenericMethod (":modelColumn", "@brief Method int QComboBox::modelColumn()\n", true, &_init_f_modelColumn_c0, &_call_f_modelColumn_c0);
  methods += new qt_gsi::GenericMethod ("placeholderText", "@brief Method QString QComboBox::placeholderText()\n", true, &_init_f_placeholderText_c0, &_call_f_placeholderText_c0);
  methods += new qt_gsi::GenericMethod ("removeItem", "@brief Method void QComboBox::removeItem(int index)\n", false, &_init_f_removeItem_767, &_call_f_removeItem_767);
  methods += new qt_gsi::GenericMethod (":rootModelIndex", "@brief Method QModelIndex QComboBox::rootModelIndex()\n", true, &_init_f_rootModelIndex_c0, &_call_f_rootModelIndex_c0);
  methods += new qt_gsi::GenericMethod ("setCompleter|completer=", "@brief Method void QComboBox::setCompleter(QCompleter *c)\n", false, &_init_f_setCompleter_1642, &_call_f_setCompleter_1642);
  methods += new qt_gsi::GenericMethod ("setCurrentIndex|currentIndex=", "@brief Method void QComboBox::setCurrentIndex(int index)\n", false, &_init_f_setCurrentIndex_767, &_call_f_setCurrentIndex_767);
  methods += new qt_gsi::GenericMethod ("setCurrentText|currentText=", "@brief Method void QComboBox::setCurrentText(const QString &text)\n", false, &_init_f_setCurrentText_2025, &_call_f_setCurrentText_2025);
  methods += new qt_gsi::GenericMethod ("setDuplicatesEnabled|duplicatesEnabled=", "@brief Method void QComboBox::setDuplicatesEnabled(bool enable)\n", false, &_init_f_setDuplicatesEnabled_864, &_call_f_setDuplicatesEnabled_864);
  methods += new qt_gsi::GenericMethod ("setEditText", "@brief Method void QComboBox::setEditText(const QString &text)\n", false, &_init_f_setEditText_2025, &_call_f_setEditText_2025);
  methods += new qt_gsi::GenericMethod ("setEditable|editable=", "@brief Method void QComboBox::setEditable(bool editable)\n", false, &_init_f_setEditable_864, &_call_f_setEditable_864);
  methods += new qt_gsi::GenericMethod ("setFrame|frame=", "@brief Method void QComboBox::setFrame(bool)\n", false, &_init_f_setFrame_864, &_call_f_setFrame_864);
  methods += new qt_gsi::GenericMethod ("setIconSize|iconSize=", "@brief Method void QComboBox::setIconSize(const QSize &size)\n", false, &_init_f_setIconSize_1805, &_call_f_setIconSize_1805);
  methods += new qt_gsi::GenericMethod ("setInsertPolicy|insertPolicy=", "@brief Method void QComboBox::setInsertPolicy(QComboBox::InsertPolicy policy)\n", false, &_init_f_setInsertPolicy_2679, &_call_f_setInsertPolicy_2679);
  methods += new qt_gsi::GenericMethod ("setItemData", "@brief Method void QComboBox::setItemData(int index, const QVariant &value, int role)\n", false, &_init_f_setItemData_3437, &_call_f_setItemData_3437);
  methods += new qt_gsi::GenericMethod ("setItemDelegate|itemDelegate=", "@brief Method void QComboBox::setItemDelegate(QAbstractItemDelegate *delegate)\n", false, &_init_f_setItemDelegate_2717, &_call_f_setItemDelegate_2717);
  methods += new qt_gsi::GenericMethod ("setItemIcon", "@brief Method void QComboBox::setItemIcon(int index, const QIcon &icon)\n", false, &_init_f_setItemIcon_2446, &_call_f_setItemIcon_2446);
  methods += new qt_gsi::GenericMethod ("setItemText", "@brief Method void QComboBox::setItemText(int index, const QString &text)\n", false, &_init_f_setItemText_2684, &_call_f_setItemText_2684);
  methods += new qt_gsi::GenericMethod ("setLineEdit|lineEdit=", "@brief Method void QComboBox::setLineEdit(QLineEdit *edit)\n", false, &_init_f_setLineEdit_1485, &_call_f_setLineEdit_1485);
  methods += new qt_gsi::GenericMethod ("setMaxCount|maxCount=", "@brief Method void QComboBox::setMaxCount(int max)\n", false, &_init_f_setMaxCount_767, &_call_f_setMaxCount_767);
  methods += new qt_gsi::GenericMethod ("setMaxVisibleItems|maxVisibleItems=", "@brief Method void QComboBox::setMaxVisibleItems(int maxItems)\n", false, &_init_f_setMaxVisibleItems_767, &_call_f_setMaxVisibleItems_767);
  methods += new qt_gsi::GenericMethod ("setMinimumContentsLength|minimumContentsLength=", "@brief Method void QComboBox::setMinimumContentsLength(int characters)\n", false, &_init_f_setMinimumContentsLength_767, &_call_f_setMinimumContentsLength_767);
  methods += new qt_gsi::GenericMethod ("setModel|model=", "@brief Method void QComboBox::setModel(QAbstractItemModel *model)\n", false, &_init_f_setModel_2419, &_call_f_setModel_2419);
  methods += new qt_gsi::GenericMethod ("setModelColumn|modelColumn=", "@brief Method void QComboBox::setModelColumn(int visibleColumn)\n", false, &_init_f_setModelColumn_767, &_call_f_setModelColumn_767);
  methods += new qt_gsi::GenericMethod ("setPlaceholderText", "@brief Method void QComboBox::setPlaceholderText(const QString &placeholderText)\n", false, &_init_f_setPlaceholderText_2025, &_call_f_setPlaceholderText_2025);
  methods += new qt_gsi::GenericMethod ("setRootModelIndex|rootModelIndex=", "@brief Method void QComboBox::setRootModelIndex(const QModelIndex &index)\n", false, &_init_f_setRootModelIndex_2395, &_call_f_setRootModelIndex_2395);
  methods += new qt_gsi::GenericMethod ("setSizeAdjustPolicy|sizeAdjustPolicy=", "@brief Method void QComboBox::setSizeAdjustPolicy(QComboBox::SizeAdjustPolicy policy)\n", false, &_init_f_setSizeAdjustPolicy_3080, &_call_f_setSizeAdjustPolicy_3080);
  methods += new qt_gsi::GenericMethod ("setValidator|validator=", "@brief Method void QComboBox::setValidator(const QValidator *v)\n", false, &_init_f_setValidator_2332, &_call_f_setValidator_2332);
  methods += new qt_gsi::GenericMethod ("setView|view=", "@brief Method void QComboBox::setView(QAbstractItemView *itemView)\n", false, &_init_f_setView_2333, &_call_f_setView_2333);
  methods += new qt_gsi::GenericMethod ("showPopup", "@brief Method void QComboBox::showPopup()\n", false, &_init_f_showPopup_0, &_call_f_showPopup_0);
  methods += new qt_gsi::GenericMethod (":sizeAdjustPolicy", "@brief Method QComboBox::SizeAdjustPolicy QComboBox::sizeAdjustPolicy()\n", true, &_init_f_sizeAdjustPolicy_c0, &_call_f_sizeAdjustPolicy_c0);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QComboBox::sizeHint()\nThis is a reimplementation of QWidget::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod ("textActivated", "@brief Method void QComboBox::textActivated(const QString &)\n", false, &_init_f_textActivated_2025, &_call_f_textActivated_2025);
  methods += new qt_gsi::GenericMethod ("textHighlighted", "@brief Method void QComboBox::textHighlighted(const QString &)\n", false, &_init_f_textHighlighted_2025, &_call_f_textHighlighted_2025);
  methods += new qt_gsi::GenericMethod (":validator", "@brief Method const QValidator *QComboBox::validator()\n", true, &_init_f_validator_c0, &_call_f_validator_c0);
  methods += new qt_gsi::GenericMethod (":view", "@brief Method QAbstractItemView *QComboBox::view()\n", true, &_init_f_view_c0, &_call_f_view_c0);
  methods += gsi::qt_signal<int > ("activated(int)", "activated", gsi::arg("index"), "@brief Signal declaration for QComboBox::activated(int index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("currentIndexChanged(int)", "currentIndexChanged", gsi::arg("index"), "@brief Signal declaration for QComboBox::currentIndexChanged(int index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("currentTextChanged(const QString &)", "currentTextChanged", gsi::arg("arg1"), "@brief Signal declaration for QComboBox::currentTextChanged(const QString &)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QComboBox::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QComboBox::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("editTextChanged(const QString &)", "editTextChanged", gsi::arg("arg1"), "@brief Signal declaration for QComboBox::editTextChanged(const QString &)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("highlighted(int)", "highlighted", gsi::arg("index"), "@brief Signal declaration for QComboBox::highlighted(int index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QComboBox::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QComboBox::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QComboBox::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QComboBox::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QComboBox::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QWidget> &qtdecl_QWidget ();

qt_gsi::QtNativeClass<QComboBox> decl_QComboBox (qtdecl_QWidget (), "QtWidgets", "QComboBox_Native",
  methods_QComboBox (),
  "@hide\n@alias QComboBox");

GSI_QTWIDGETS_PUBLIC gsi::Class<QComboBox> &qtdecl_QComboBox () { return decl_QComboBox; }

}


class QComboBox_Adaptor : public QComboBox, public qt_gsi::QtObjectBase
{
public:

  virtual ~QComboBox_Adaptor();

  //  [adaptor ctor] QComboBox::QComboBox(QWidget *parent)
  QComboBox_Adaptor() : QComboBox()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QComboBox::QComboBox(QWidget *parent)
  QComboBox_Adaptor(QWidget *parent) : QComboBox(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QComboBox::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QComboBox_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QComboBox::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QComboBox::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QComboBox_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QComboBox::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QComboBox::focusNextChild()
  bool fp_QComboBox_focusNextChild_0 () {
    return QComboBox::focusNextChild();
  }

  //  [expose] bool QComboBox::focusPreviousChild()
  bool fp_QComboBox_focusPreviousChild_0 () {
    return QComboBox::focusPreviousChild();
  }

  //  [expose] bool QComboBox::isSignalConnected(const QMetaMethod &signal)
  bool fp_QComboBox_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QComboBox::isSignalConnected(signal);
  }

  //  [expose] int QComboBox::receivers(const char *signal)
  int fp_QComboBox_receivers_c1731 (const char *signal) const {
    return QComboBox::receivers(signal);
  }

  //  [expose] QObject *QComboBox::sender()
  QObject * fp_QComboBox_sender_c0 () const {
    return QComboBox::sender();
  }

  //  [expose] int QComboBox::senderSignalIndex()
  int fp_QComboBox_senderSignalIndex_c0 () const {
    return QComboBox::senderSignalIndex();
  }

  //  [expose] void QComboBox::updateMicroFocus(Qt::InputMethodQuery query)
  void fp_QComboBox_updateMicroFocus_2420 (const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) {
    QComboBox::updateMicroFocus(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  //  [emitter impl] void QComboBox::activated(int index)
  void emitter_QComboBox_activated_767(int index)
  {
    emit QComboBox::activated(index);
  }

  //  [emitter impl] void QComboBox::currentIndexChanged(int index)
  void emitter_QComboBox_currentIndexChanged_767(int index)
  {
    emit QComboBox::currentIndexChanged(index);
  }

  //  [emitter impl] void QComboBox::currentTextChanged(const QString &)
  void emitter_QComboBox_currentTextChanged_2025(const QString &arg1)
  {
    emit QComboBox::currentTextChanged(arg1);
  }

  //  [emitter impl] void QComboBox::customContextMenuRequested(const QPoint &pos)
  void emitter_QComboBox_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QComboBox::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QComboBox::destroyed(QObject *)
  void emitter_QComboBox_destroyed_1302(QObject *arg1)
  {
    emit QComboBox::destroyed(arg1);
  }

  //  [emitter impl] void QComboBox::editTextChanged(const QString &)
  void emitter_QComboBox_editTextChanged_2025(const QString &arg1)
  {
    emit QComboBox::editTextChanged(arg1);
  }

  //  [adaptor impl] bool QComboBox::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QComboBox::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QComboBox_Adaptor, bool, QEvent *>(&QComboBox_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QComboBox::event(_event);
    }
  }

  //  [adaptor impl] bool QComboBox::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QComboBox::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QComboBox_Adaptor, bool, QObject *, QEvent *>(&QComboBox_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QComboBox::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QComboBox::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QComboBox::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QComboBox_Adaptor, bool>(&QComboBox_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QComboBox::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QComboBox::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QComboBox::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QComboBox_Adaptor, int, int>(&QComboBox_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QComboBox::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::hidePopup()
  void cbs_hidePopup_0_0()
  {
    QComboBox::hidePopup();
  }

  virtual void hidePopup()
  {
    if (cb_hidePopup_0_0.can_issue()) {
      cb_hidePopup_0_0.issue<QComboBox_Adaptor>(&QComboBox_Adaptor::cbs_hidePopup_0_0);
    } else {
      QComboBox::hidePopup();
    }
  }

  //  [emitter impl] void QComboBox::highlighted(int index)
  void emitter_QComboBox_highlighted_767(int index)
  {
    emit QComboBox::highlighted(index);
  }

  //  [adaptor impl] QVariant QComboBox::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QComboBox::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QComboBox_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QComboBox_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QComboBox::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QComboBox::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QComboBox::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QComboBox_Adaptor, QSize>(&QComboBox_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QComboBox::minimumSizeHint();
    }
  }

  //  [emitter impl] void QComboBox::objectNameChanged(const QString &objectName)
  void emitter_QComboBox_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QComboBox::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QPaintEngine *QComboBox::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QComboBox::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QComboBox_Adaptor, QPaintEngine *>(&QComboBox_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QComboBox::paintEngine();
    }
  }

  //  [adaptor impl] void QComboBox::setModel(QAbstractItemModel *model)
  void cbs_setModel_2419_0(QAbstractItemModel *model)
  {
    QComboBox::setModel(model);
  }

  virtual void setModel(QAbstractItemModel *model)
  {
    if (cb_setModel_2419_0.can_issue()) {
      cb_setModel_2419_0.issue<QComboBox_Adaptor, QAbstractItemModel *>(&QComboBox_Adaptor::cbs_setModel_2419_0, model);
    } else {
      QComboBox::setModel(model);
    }
  }

  //  [adaptor impl] void QComboBox::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QComboBox::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QComboBox_Adaptor, bool>(&QComboBox_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QComboBox::setVisible(visible);
    }
  }

  //  [adaptor impl] void QComboBox::showPopup()
  void cbs_showPopup_0_0()
  {
    QComboBox::showPopup();
  }

  virtual void showPopup()
  {
    if (cb_showPopup_0_0.can_issue()) {
      cb_showPopup_0_0.issue<QComboBox_Adaptor>(&QComboBox_Adaptor::cbs_showPopup_0_0);
    } else {
      QComboBox::showPopup();
    }
  }

  //  [adaptor impl] QSize QComboBox::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QComboBox::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QComboBox_Adaptor, QSize>(&QComboBox_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QComboBox::sizeHint();
    }
  }

  //  [emitter impl] void QComboBox::windowIconChanged(const QIcon &icon)
  void emitter_QComboBox_windowIconChanged_1787(const QIcon &icon)
  {
    emit QComboBox::windowIconChanged(icon);
  }

  //  [emitter impl] void QComboBox::windowIconTextChanged(const QString &iconText)
  void emitter_QComboBox_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QComboBox::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QComboBox::windowTitleChanged(const QString &title)
  void emitter_QComboBox_windowTitleChanged_2025(const QString &title)
  {
    emit QComboBox::windowTitleChanged(title);
  }

  //  [adaptor impl] void QComboBox::actionEvent(QActionEvent *event)
  void cbs_actionEvent_1823_0(QActionEvent *event)
  {
    QComboBox::actionEvent(event);
  }

  virtual void actionEvent(QActionEvent *event)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QComboBox_Adaptor, QActionEvent *>(&QComboBox_Adaptor::cbs_actionEvent_1823_0, event);
    } else {
      QComboBox::actionEvent(event);
    }
  }

  //  [adaptor impl] void QComboBox::changeEvent(QEvent *e)
  void cbs_changeEvent_1217_0(QEvent *e)
  {
    QComboBox::changeEvent(e);
  }

  virtual void changeEvent(QEvent *e)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QComboBox_Adaptor, QEvent *>(&QComboBox_Adaptor::cbs_changeEvent_1217_0, e);
    } else {
      QComboBox::changeEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QComboBox::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QComboBox_Adaptor, QChildEvent *>(&QComboBox_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QComboBox::childEvent(event);
    }
  }

  //  [adaptor impl] void QComboBox::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QComboBox::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QComboBox_Adaptor, QCloseEvent *>(&QComboBox_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QComboBox::closeEvent(event);
    }
  }

  //  [adaptor impl] void QComboBox::contextMenuEvent(QContextMenuEvent *e)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *e)
  {
    QComboBox::contextMenuEvent(e);
  }

  virtual void contextMenuEvent(QContextMenuEvent *e)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QComboBox_Adaptor, QContextMenuEvent *>(&QComboBox_Adaptor::cbs_contextMenuEvent_2363_0, e);
    } else {
      QComboBox::contextMenuEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QComboBox::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QComboBox_Adaptor, QEvent *>(&QComboBox_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QComboBox::customEvent(event);
    }
  }

  //  [adaptor impl] void QComboBox::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QComboBox::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QComboBox_Adaptor, const QMetaMethod &>(&QComboBox_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QComboBox::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QComboBox::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QComboBox::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QComboBox_Adaptor, QDragEnterEvent *>(&QComboBox_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QComboBox::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QComboBox::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QComboBox::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QComboBox_Adaptor, QDragLeaveEvent *>(&QComboBox_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QComboBox::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QComboBox::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QComboBox::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QComboBox_Adaptor, QDragMoveEvent *>(&QComboBox_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QComboBox::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QComboBox::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QComboBox::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QComboBox_Adaptor, QDropEvent *>(&QComboBox_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QComboBox::dropEvent(event);
    }
  }

  //  [adaptor impl] void QComboBox::enterEvent(QEnterEvent *event)
  void cbs_enterEvent_1727_0(QEnterEvent *event)
  {
    QComboBox::enterEvent(event);
  }

  virtual void enterEvent(QEnterEvent *event)
  {
    if (cb_enterEvent_1727_0.can_issue()) {
      cb_enterEvent_1727_0.issue<QComboBox_Adaptor, QEnterEvent *>(&QComboBox_Adaptor::cbs_enterEvent_1727_0, event);
    } else {
      QComboBox::enterEvent(event);
    }
  }

  //  [adaptor impl] void QComboBox::focusInEvent(QFocusEvent *e)
  void cbs_focusInEvent_1729_0(QFocusEvent *e)
  {
    QComboBox::focusInEvent(e);
  }

  virtual void focusInEvent(QFocusEvent *e)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QComboBox_Adaptor, QFocusEvent *>(&QComboBox_Adaptor::cbs_focusInEvent_1729_0, e);
    } else {
      QComboBox::focusInEvent(e);
    }
  }

  //  [adaptor impl] bool QComboBox::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QComboBox::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QComboBox_Adaptor, bool, bool>(&QComboBox_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QComboBox::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QComboBox::focusOutEvent(QFocusEvent *e)
  void cbs_focusOutEvent_1729_0(QFocusEvent *e)
  {
    QComboBox::focusOutEvent(e);
  }

  virtual void focusOutEvent(QFocusEvent *e)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QComboBox_Adaptor, QFocusEvent *>(&QComboBox_Adaptor::cbs_focusOutEvent_1729_0, e);
    } else {
      QComboBox::focusOutEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::hideEvent(QHideEvent *e)
  void cbs_hideEvent_1595_0(QHideEvent *e)
  {
    QComboBox::hideEvent(e);
  }

  virtual void hideEvent(QHideEvent *e)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QComboBox_Adaptor, QHideEvent *>(&QComboBox_Adaptor::cbs_hideEvent_1595_0, e);
    } else {
      QComboBox::hideEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QComboBox::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QComboBox_Adaptor, QPainter *>(&QComboBox_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QComboBox::initPainter(painter);
    }
  }

  //  [adaptor impl] void QComboBox::initStyleOption(QStyleOptionComboBox *option)
  void cbs_initStyleOption_c2658_0(QStyleOptionComboBox *option) const
  {
    QComboBox::initStyleOption(option);
  }

  virtual void initStyleOption(QStyleOptionComboBox *option) const
  {
    if (cb_initStyleOption_c2658_0.can_issue()) {
      cb_initStyleOption_c2658_0.issue<QComboBox_Adaptor, QStyleOptionComboBox *>(&QComboBox_Adaptor::cbs_initStyleOption_c2658_0, option);
    } else {
      QComboBox::initStyleOption(option);
    }
  }

  //  [adaptor impl] void QComboBox::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QComboBox::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QComboBox_Adaptor, QInputMethodEvent *>(&QComboBox_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QComboBox::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::keyPressEvent(QKeyEvent *e)
  void cbs_keyPressEvent_1514_0(QKeyEvent *e)
  {
    QComboBox::keyPressEvent(e);
  }

  virtual void keyPressEvent(QKeyEvent *e)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QComboBox_Adaptor, QKeyEvent *>(&QComboBox_Adaptor::cbs_keyPressEvent_1514_0, e);
    } else {
      QComboBox::keyPressEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::keyReleaseEvent(QKeyEvent *e)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *e)
  {
    QComboBox::keyReleaseEvent(e);
  }

  virtual void keyReleaseEvent(QKeyEvent *e)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QComboBox_Adaptor, QKeyEvent *>(&QComboBox_Adaptor::cbs_keyReleaseEvent_1514_0, e);
    } else {
      QComboBox::keyReleaseEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::leaveEvent(QEvent *event)
  void cbs_leaveEvent_1217_0(QEvent *event)
  {
    QComboBox::leaveEvent(event);
  }

  virtual void leaveEvent(QEvent *event)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QComboBox_Adaptor, QEvent *>(&QComboBox_Adaptor::cbs_leaveEvent_1217_0, event);
    } else {
      QComboBox::leaveEvent(event);
    }
  }

  //  [adaptor impl] int QComboBox::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QComboBox::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QComboBox_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QComboBox_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QComboBox::metric(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QComboBox::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QComboBox_Adaptor, QMouseEvent *>(&QComboBox_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QComboBox::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QComboBox::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QComboBox::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QComboBox_Adaptor, QMouseEvent *>(&QComboBox_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QComboBox::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QComboBox::mousePressEvent(QMouseEvent *e)
  void cbs_mousePressEvent_1738_0(QMouseEvent *e)
  {
    QComboBox::mousePressEvent(e);
  }

  virtual void mousePressEvent(QMouseEvent *e)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QComboBox_Adaptor, QMouseEvent *>(&QComboBox_Adaptor::cbs_mousePressEvent_1738_0, e);
    } else {
      QComboBox::mousePressEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::mouseReleaseEvent(QMouseEvent *e)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *e)
  {
    QComboBox::mouseReleaseEvent(e);
  }

  virtual void mouseReleaseEvent(QMouseEvent *e)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QComboBox_Adaptor, QMouseEvent *>(&QComboBox_Adaptor::cbs_mouseReleaseEvent_1738_0, e);
    } else {
      QComboBox::mouseReleaseEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::moveEvent(QMoveEvent *event)
  void cbs_moveEvent_1624_0(QMoveEvent *event)
  {
    QComboBox::moveEvent(event);
  }

  virtual void moveEvent(QMoveEvent *event)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QComboBox_Adaptor, QMoveEvent *>(&QComboBox_Adaptor::cbs_moveEvent_1624_0, event);
    } else {
      QComboBox::moveEvent(event);
    }
  }

  //  [adaptor impl] bool QComboBox::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  bool cbs_nativeEvent_6949_0(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    return QComboBox::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    if (cb_nativeEvent_6949_0.can_issue()) {
      return cb_nativeEvent_6949_0.issue<QComboBox_Adaptor, bool, const QByteArray &, void *, QIntegerForSizeof<void *>::Signed *>(&QComboBox_Adaptor::cbs_nativeEvent_6949_0, eventType, message, result);
    } else {
      return QComboBox::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QComboBox::paintEvent(QPaintEvent *e)
  void cbs_paintEvent_1725_0(QPaintEvent *e)
  {
    QComboBox::paintEvent(e);
  }

  virtual void paintEvent(QPaintEvent *e)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QComboBox_Adaptor, QPaintEvent *>(&QComboBox_Adaptor::cbs_paintEvent_1725_0, e);
    } else {
      QComboBox::paintEvent(e);
    }
  }

  //  [adaptor impl] QPaintDevice *QComboBox::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QComboBox::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QComboBox_Adaptor, QPaintDevice *, QPoint *>(&QComboBox_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QComboBox::redirected(offset);
    }
  }

  //  [adaptor impl] void QComboBox::resizeEvent(QResizeEvent *e)
  void cbs_resizeEvent_1843_0(QResizeEvent *e)
  {
    QComboBox::resizeEvent(e);
  }

  virtual void resizeEvent(QResizeEvent *e)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QComboBox_Adaptor, QResizeEvent *>(&QComboBox_Adaptor::cbs_resizeEvent_1843_0, e);
    } else {
      QComboBox::resizeEvent(e);
    }
  }

  //  [adaptor impl] QPainter *QComboBox::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QComboBox::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QComboBox_Adaptor, QPainter *>(&QComboBox_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QComboBox::sharedPainter();
    }
  }

  //  [adaptor impl] void QComboBox::showEvent(QShowEvent *e)
  void cbs_showEvent_1634_0(QShowEvent *e)
  {
    QComboBox::showEvent(e);
  }

  virtual void showEvent(QShowEvent *e)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QComboBox_Adaptor, QShowEvent *>(&QComboBox_Adaptor::cbs_showEvent_1634_0, e);
    } else {
      QComboBox::showEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::tabletEvent(QTabletEvent *event)
  void cbs_tabletEvent_1821_0(QTabletEvent *event)
  {
    QComboBox::tabletEvent(event);
  }

  virtual void tabletEvent(QTabletEvent *event)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QComboBox_Adaptor, QTabletEvent *>(&QComboBox_Adaptor::cbs_tabletEvent_1821_0, event);
    } else {
      QComboBox::tabletEvent(event);
    }
  }

  //  [adaptor impl] void QComboBox::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QComboBox::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QComboBox_Adaptor, QTimerEvent *>(&QComboBox_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QComboBox::timerEvent(event);
    }
  }

  //  [adaptor impl] void QComboBox::wheelEvent(QWheelEvent *e)
  void cbs_wheelEvent_1718_0(QWheelEvent *e)
  {
    QComboBox::wheelEvent(e);
  }

  virtual void wheelEvent(QWheelEvent *e)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QComboBox_Adaptor, QWheelEvent *>(&QComboBox_Adaptor::cbs_wheelEvent_1718_0, e);
    } else {
      QComboBox::wheelEvent(e);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_hidePopup_0_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setModel_2419_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_showPopup_0_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1727_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_initStyleOption_c2658_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_6949_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QComboBox_Adaptor::~QComboBox_Adaptor() { }

//  Constructor QComboBox::QComboBox(QWidget *parent) (adaptor class)

static void _init_ctor_QComboBox_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QComboBox_Adaptor> ();
}

static void _call_ctor_QComboBox_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QComboBox_Adaptor *> (new QComboBox_Adaptor (arg1));
}


// void QComboBox::actionEvent(QActionEvent *event)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// emitter void QComboBox::activated(int index)

static void _init_emitter_activated_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_activated_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QComboBox_Adaptor *)cls)->emitter_QComboBox_activated_767 (arg1);
}


// void QComboBox::changeEvent(QEvent *e)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QComboBox::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QComboBox::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QComboBox::contextMenuEvent(QContextMenuEvent *e)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QComboBox::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->fp_QComboBox_create_2208 (arg1, arg2, arg3);
}


// emitter void QComboBox::currentIndexChanged(int index)

static void _init_emitter_currentIndexChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentIndexChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QComboBox_Adaptor *)cls)->emitter_QComboBox_currentIndexChanged_767 (arg1);
}


// emitter void QComboBox::currentTextChanged(const QString &)

static void _init_emitter_currentTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QComboBox_Adaptor *)cls)->emitter_QComboBox_currentTextChanged_2025 (arg1);
}


// emitter void QComboBox::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QComboBox_Adaptor *)cls)->emitter_QComboBox_customContextMenuRequested_1916 (arg1);
}


// void QComboBox::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QComboBox::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->fp_QComboBox_destroy_1620 (arg1, arg2);
}


// emitter void QComboBox::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QComboBox_Adaptor *)cls)->emitter_QComboBox_destroyed_1302 (arg1);
}


// void QComboBox::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QComboBox::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QComboBox::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QComboBox::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QComboBox::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// emitter void QComboBox::editTextChanged(const QString &)

static void _init_emitter_editTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_editTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QComboBox_Adaptor *)cls)->emitter_QComboBox_editTextChanged_2025 (arg1);
}


// void QComboBox::enterEvent(QEnterEvent *event)

static void _init_cbs_enterEvent_1727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEnterEvent *arg1 = args.read<QEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_enterEvent_1727_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1727_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_enterEvent_1727_0 = cb;
}


// bool QComboBox::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QComboBox_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QComboBox::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QComboBox_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QComboBox::focusInEvent(QFocusEvent *e)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QComboBox::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QComboBox_Adaptor *)cls)->fp_QComboBox_focusNextChild_0 ());
}


// bool QComboBox::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QComboBox_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QComboBox::focusOutEvent(QFocusEvent *e)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QComboBox::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QComboBox_Adaptor *)cls)->fp_QComboBox_focusPreviousChild_0 ());
}


// bool QComboBox::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QComboBox_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QComboBox::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QComboBox_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QComboBox::hideEvent(QHideEvent *e)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QComboBox::hidePopup()

static void _init_cbs_hidePopup_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_hidePopup_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_hidePopup_0_0 ();
}

static void _set_callback_cbs_hidePopup_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_hidePopup_0_0 = cb;
}


// emitter void QComboBox::highlighted(int index)

static void _init_emitter_highlighted_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_highlighted_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QComboBox_Adaptor *)cls)->emitter_QComboBox_highlighted_767 (arg1);
}


// void QComboBox::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// void QComboBox::initStyleOption(QStyleOptionComboBox *option)

static void _init_cbs_initStyleOption_c2658_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionComboBox * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initStyleOption_c2658_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOptionComboBox *arg1 = args.read<QStyleOptionComboBox * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_initStyleOption_c2658_0 (arg1);
}

static void _set_callback_cbs_initStyleOption_c2658_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_initStyleOption_c2658_0 = cb;
}


// void QComboBox::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QComboBox::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QComboBox_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// exposed bool QComboBox::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QComboBox_Adaptor *)cls)->fp_QComboBox_isSignalConnected_c2394 (arg1));
}


// void QComboBox::keyPressEvent(QKeyEvent *e)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QComboBox::keyReleaseEvent(QKeyEvent *e)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QComboBox::leaveEvent(QEvent *event)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QComboBox::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QComboBox_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QComboBox::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QComboBox_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QComboBox::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QComboBox::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QComboBox::mousePressEvent(QMouseEvent *e)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QComboBox::mouseReleaseEvent(QMouseEvent *e)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QComboBox::moveEvent(QMoveEvent *event)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QComboBox::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)

static void _init_cbs_nativeEvent_6949_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<QIntegerForSizeof<void *>::Signed * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_6949_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  QIntegerForSizeof<void *>::Signed *arg3 = args.read<QIntegerForSizeof<void *>::Signed * > (heap);
  ret.write<bool > ((bool)((QComboBox_Adaptor *)cls)->cbs_nativeEvent_6949_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_6949_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_nativeEvent_6949_0 = cb;
}


// emitter void QComboBox::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QComboBox_Adaptor *)cls)->emitter_QComboBox_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QComboBox::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QComboBox_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QComboBox::paintEvent(QPaintEvent *e)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QComboBox::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QComboBox_Adaptor *)cls)->fp_QComboBox_receivers_c1731 (arg1));
}


// QPaintDevice *QComboBox::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QComboBox_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QComboBox::resizeEvent(QResizeEvent *e)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QComboBox::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QComboBox_Adaptor *)cls)->fp_QComboBox_sender_c0 ());
}


// exposed int QComboBox::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QComboBox_Adaptor *)cls)->fp_QComboBox_senderSignalIndex_c0 ());
}


// void QComboBox::setModel(QAbstractItemModel *model)

static void _init_cbs_setModel_2419_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setModel_2419_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_setModel_2419_0 (arg1);
}

static void _set_callback_cbs_setModel_2419_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_setModel_2419_0 = cb;
}


// void QComboBox::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// QPainter *QComboBox::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QComboBox_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QComboBox::showEvent(QShowEvent *e)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// void QComboBox::showPopup()

static void _init_cbs_showPopup_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_showPopup_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_showPopup_0_0 ();
}

static void _set_callback_cbs_showPopup_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_showPopup_0_0 = cb;
}


// QSize QComboBox::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QComboBox_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QComboBox::tabletEvent(QTabletEvent *event)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QComboBox::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QComboBox::updateMicroFocus(Qt::InputMethodQuery query)

static void _init_fp_updateMicroFocus_2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query", true, "Qt::ImQueryAll");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::InputMethodQuery>(heap, Qt::ImQueryAll), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->fp_QComboBox_updateMicroFocus_2420 (arg1);
}


// void QComboBox::wheelEvent(QWheelEvent *e)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QComboBox_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QComboBox::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QComboBox_Adaptor *)cls)->emitter_QComboBox_windowIconChanged_1787 (arg1);
}


// emitter void QComboBox::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QComboBox_Adaptor *)cls)->emitter_QComboBox_windowIconTextChanged_2025 (arg1);
}


// emitter void QComboBox::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QComboBox_Adaptor *)cls)->emitter_QComboBox_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QComboBox> &qtdecl_QComboBox ();

static gsi::Methods methods_QComboBox_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QComboBox::QComboBox(QWidget *parent)\nThis method creates an object of class QComboBox.", &_init_ctor_QComboBox_Adaptor_1315, &_call_ctor_QComboBox_Adaptor_1315);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QComboBox::actionEvent(QActionEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("emit_activated", "@brief Emitter for signal void QComboBox::activated(int index)\nCall this method to emit this signal.", false, &_init_emitter_activated_767, &_call_emitter_activated_767);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QComboBox::changeEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QComboBox::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QComboBox::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QComboBox::contextMenuEvent(QContextMenuEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QComboBox::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_currentIndexChanged", "@brief Emitter for signal void QComboBox::currentIndexChanged(int index)\nCall this method to emit this signal.", false, &_init_emitter_currentIndexChanged_767, &_call_emitter_currentIndexChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_currentTextChanged", "@brief Emitter for signal void QComboBox::currentTextChanged(const QString &)\nCall this method to emit this signal.", false, &_init_emitter_currentTextChanged_2025, &_call_emitter_currentTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QComboBox::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QComboBox::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QComboBox::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QComboBox::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QComboBox::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QComboBox::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QComboBox::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QComboBox::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QComboBox::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("emit_editTextChanged", "@brief Emitter for signal void QComboBox::editTextChanged(const QString &)\nCall this method to emit this signal.", false, &_init_emitter_editTextChanged_2025, &_call_emitter_editTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QComboBox::enterEvent(QEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0, &_set_callback_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QComboBox::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QComboBox::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QComboBox::focusInEvent(QFocusEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QComboBox::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QComboBox::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QComboBox::focusOutEvent(QFocusEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QComboBox::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QComboBox::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QComboBox::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QComboBox::hideEvent(QHideEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("hidePopup", "@brief Virtual method void QComboBox::hidePopup()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hidePopup_0_0, &_call_cbs_hidePopup_0_0);
  methods += new qt_gsi::GenericMethod ("hidePopup", "@hide", false, &_init_cbs_hidePopup_0_0, &_call_cbs_hidePopup_0_0, &_set_callback_cbs_hidePopup_0_0);
  methods += new qt_gsi::GenericMethod ("emit_highlighted", "@brief Emitter for signal void QComboBox::highlighted(int index)\nCall this method to emit this signal.", false, &_init_emitter_highlighted_767, &_call_emitter_highlighted_767);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QComboBox::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Virtual method void QComboBox::initStyleOption(QStyleOptionComboBox *option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initStyleOption_c2658_0, &_call_cbs_initStyleOption_c2658_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@hide", true, &_init_cbs_initStyleOption_c2658_0, &_call_cbs_initStyleOption_c2658_0, &_set_callback_cbs_initStyleOption_c2658_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QComboBox::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QComboBox::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QComboBox::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QComboBox::keyPressEvent(QKeyEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QComboBox::keyReleaseEvent(QKeyEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QComboBox::leaveEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QComboBox::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QComboBox::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QComboBox::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QComboBox::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QComboBox::mousePressEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QComboBox::mouseReleaseEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QComboBox::moveEvent(QMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QComboBox::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0, &_set_callback_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QComboBox::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QComboBox::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QComboBox::paintEvent(QPaintEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QComboBox::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QComboBox::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QComboBox::resizeEvent(QResizeEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QComboBox::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QComboBox::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setModel", "@brief Virtual method void QComboBox::setModel(QAbstractItemModel *model)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setModel_2419_0, &_call_cbs_setModel_2419_0);
  methods += new qt_gsi::GenericMethod ("setModel", "@hide", false, &_init_cbs_setModel_2419_0, &_call_cbs_setModel_2419_0, &_set_callback_cbs_setModel_2419_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QComboBox::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QComboBox::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QComboBox::showEvent(QShowEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("showPopup", "@brief Virtual method void QComboBox::showPopup()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showPopup_0_0, &_call_cbs_showPopup_0_0);
  methods += new qt_gsi::GenericMethod ("showPopup", "@hide", false, &_init_cbs_showPopup_0_0, &_call_cbs_showPopup_0_0, &_set_callback_cbs_showPopup_0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QComboBox::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QComboBox::tabletEvent(QTabletEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QComboBox::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QComboBox::updateMicroFocus(Qt::InputMethodQuery query)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_2420, &_call_fp_updateMicroFocus_2420);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QComboBox::wheelEvent(QWheelEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QComboBox::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QComboBox::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QComboBox::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QComboBox_Adaptor> decl_QComboBox_Adaptor (qtdecl_QComboBox (), "QtWidgets", "QComboBox",
  methods_QComboBox_Adaptor (),
  "@qt\n@brief Binding of QComboBox");

}


//  Implementation of the enum wrapper class for QComboBox::InsertPolicy
namespace qt_gsi
{

static gsi::Enum<QComboBox::InsertPolicy> decl_QComboBox_InsertPolicy_Enum ("QtWidgets", "QComboBox_InsertPolicy",
    gsi::enum_const ("NoInsert", QComboBox::NoInsert, "@brief Enum constant QComboBox::NoInsert") +
    gsi::enum_const ("InsertAtTop", QComboBox::InsertAtTop, "@brief Enum constant QComboBox::InsertAtTop") +
    gsi::enum_const ("InsertAtCurrent", QComboBox::InsertAtCurrent, "@brief Enum constant QComboBox::InsertAtCurrent") +
    gsi::enum_const ("InsertAtBottom", QComboBox::InsertAtBottom, "@brief Enum constant QComboBox::InsertAtBottom") +
    gsi::enum_const ("InsertAfterCurrent", QComboBox::InsertAfterCurrent, "@brief Enum constant QComboBox::InsertAfterCurrent") +
    gsi::enum_const ("InsertBeforeCurrent", QComboBox::InsertBeforeCurrent, "@brief Enum constant QComboBox::InsertBeforeCurrent") +
    gsi::enum_const ("InsertAlphabetically", QComboBox::InsertAlphabetically, "@brief Enum constant QComboBox::InsertAlphabetically"),
  "@qt\n@brief This class represents the QComboBox::InsertPolicy enum");

static gsi::QFlagsClass<QComboBox::InsertPolicy > decl_QComboBox_InsertPolicy_Enums ("QtWidgets", "QComboBox_QFlags_InsertPolicy",
  "@qt\n@brief This class represents the QFlags<QComboBox::InsertPolicy> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QComboBox> inject_QComboBox_InsertPolicy_Enum_in_parent (decl_QComboBox_InsertPolicy_Enum.defs ());
static gsi::ClassExt<QComboBox> decl_QComboBox_InsertPolicy_Enum_as_child (decl_QComboBox_InsertPolicy_Enum, "InsertPolicy");
static gsi::ClassExt<QComboBox> decl_QComboBox_InsertPolicy_Enums_as_child (decl_QComboBox_InsertPolicy_Enums, "QFlags_InsertPolicy");

}


//  Implementation of the enum wrapper class for QComboBox::SizeAdjustPolicy
namespace qt_gsi
{

static gsi::Enum<QComboBox::SizeAdjustPolicy> decl_QComboBox_SizeAdjustPolicy_Enum ("QtWidgets", "QComboBox_SizeAdjustPolicy",
    gsi::enum_const ("AdjustToContents", QComboBox::AdjustToContents, "@brief Enum constant QComboBox::AdjustToContents") +
    gsi::enum_const ("AdjustToContentsOnFirstShow", QComboBox::AdjustToContentsOnFirstShow, "@brief Enum constant QComboBox::AdjustToContentsOnFirstShow") +
    gsi::enum_const ("AdjustToMinimumContentsLengthWithIcon", QComboBox::AdjustToMinimumContentsLengthWithIcon, "@brief Enum constant QComboBox::AdjustToMinimumContentsLengthWithIcon"),
  "@qt\n@brief This class represents the QComboBox::SizeAdjustPolicy enum");

static gsi::QFlagsClass<QComboBox::SizeAdjustPolicy > decl_QComboBox_SizeAdjustPolicy_Enums ("QtWidgets", "QComboBox_QFlags_SizeAdjustPolicy",
  "@qt\n@brief This class represents the QFlags<QComboBox::SizeAdjustPolicy> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QComboBox> inject_QComboBox_SizeAdjustPolicy_Enum_in_parent (decl_QComboBox_SizeAdjustPolicy_Enum.defs ());
static gsi::ClassExt<QComboBox> decl_QComboBox_SizeAdjustPolicy_Enum_as_child (decl_QComboBox_SizeAdjustPolicy_Enum, "SizeAdjustPolicy");
static gsi::ClassExt<QComboBox> decl_QComboBox_SizeAdjustPolicy_Enums_as_child (decl_QComboBox_SizeAdjustPolicy_Enums, "QFlags_SizeAdjustPolicy");

}

