ITK Release 3.18
================

This release covers the period September 16, 2009 through April 16, 2010

New Classes in this Release
---------------------------


    Code/Common/itkInternationalizationIOHelpers
    Code/Common/itkMath
    Code/Common/itkMathDetail
    Code/Common/itkNumericTraitsDiffusionTensor3DPixel
    Code/Common/itkNumericTraitsFixedArrayPixel2
    Code/Common/itkNumericTraitsTensorPixel2

    Code/Review/itkGaborImageSource
    Code/Review/itkGaborKernelFunction
    Code/Review/itkLabelGeometryImageFilter

New Tests in this Release
-------------------------

    Testing/Code/Common/itkBSplineDeformableTransformTest3
    Testing/Code/Common/itkIntTypesTest
    Testing/Code/Common/itkMathCastWithRangeCheck
    Testing/Code/Common/itkMathRoundTest2
    Testing/Code/Common/itkMathTest
    Testing/Code/Common/itkSimpleFilterWatcherTest

    Testing/Code/BasicFilters/itkAtan2ImageFilterTest
    Testing/Code/BasicFilters/itkBSplineDownsampleImageFilterTest
    Testing/Code/BasicFilters/itkBSplineUpsampleImageFilterTest
    Testing/Code/BasicFilters/itkJoinSeriesImageFilterStreamingTest

    Testing/Code/IO/itkImageFileReaderStreamingTest2
    Testing/Code/IO/itkUnicodeIOTest

    Testing/Code/Algorithms/itkLevelSetMotionRegistrationFilterTest

    Testing/Code/Review/itkDiscreteGaussianDerivativeImageFilterTest
    Testing/Code/Review/itkGaborImageSourceTest
    Testing/Code/Review/itkLabelGeometryImageFilterTest
    Testing/Code/Review/itkOptImageToImageMetricsTest2
    Testing/Code/Review/itkReviewTests5
    Testing/Code/Review/itkReviewTests6
    Testing/Code/Review/itkScalarChanAndVeseDenseLevelSetImageFilterTest3
    Testing/Code/Review/itkScalarChanAndVeseDenseLevelSetImageFilterTest4
    Testing/Code/Review/Statistics/itkImageToHistogramFilterTest3

New Examples in this Release
----------------------------


    Examples/Registration/ImageRegistration19
    Examples/Registration/ImageRegistration20

    Examples/SpatialObjects/BoundingBoxFromImageMaskSpatialObject

New Utilities in this Release
-----------------------------

    Utilities/itkExtHdrs/fdstream.hpp
    Utilities/NrrdIO/biff
    Utilities/NrrdIO/biffmsg
    Utilities/vxl/v3p/netlib/linalg/CMakeLists.txt
    Utilities/vxl/v3p/netlib/linalg/lsqrBase

This release covers the period September 16, 2009 through April 16, 2010

Changes in this Release
-----------------------


    CMakeLists.txt
        ENH: Updating ITK_VERSION_MINOR to "18" in preparation for the release of ITK 3.18.
    insight-users/2010-January/034822.html
        BUG: had detection of HAVE_FENV_H after generation of itkConfigure.h, which produced an incorrect configuration file the first time cmake was run
        ENH: added checking of rounding mode in itk::Math rounding methods, added cmake check for fenv.h

    CTestConfig.cmake

    ITKConfig.cmake.in

    itkConfigure.h.in
    insight-users/2010-January/034822.html
        BUG: removing just added support for __int64, since no compiler seems to support it correctly, the Borland compiler could not correctly handle the zero and one values in the numeric traits class
        COMP: fixed comp error when HAVE_INCLUDE_H variables are replaced with ""
        ENH: moved detection of long long and __int64 to itkTestType.cmake based on VTK version. Added cmake defines for these types

    CMake/FindNUMARRAY.cmake
        ENH: numarray is deprecated, numpyu provide backward compatible API

    CMake/InsightValgrind.supp
        ENH: suppressions added for Tcl potential memory leaks during dynamic analysis on clownfish.megason-lab.hms
        ENH: new suppression for Tcl error on big fish dynamic analysis
        ENH: new suppressions for tcl memory leaks detected on BigFish-Dynamic analysis
        ENH: suppressions added to remove tcl error during dynamic analysis and last version of ctest on BigFish
        ENH: Adding suppresions for Tcl that showed up when doing PrintSelf tests.

    CMake/itkTestCStyleIOWCharFilename
        ENH: Using cmake try_compile instead of hardcoded compiler switches to make itkUnicodeIOTest cleaner (and hopefully more scalable)

    CMake/itkTestCompareTypes
        ENH: moved detection of long long and __int64 to itkTestType.cmake based on VTK version. Added cmake defines for these types

    CMake/itkTestConvertTypes
        ENH: moved detection of long long and __int64 to itkTestType.cmake based on VTK version. Added cmake defines for these types

    CMake/itkTestFDStream
        ENH: Using cmake try_compile instead of hardcoded compiler switches to make itkUnicodeIOTest cleaner (and hopefully more scalable)

    CMake/itkTestIOStreamsWCharFilenameConstructors
        ENH: Using cmake try_compile instead of hardcoded compiler switches to make itkUnicodeIOTest cleaner (and hopefully more scalable)

    CMake/itkTestTypes.cmake
        BUG: removing just added support for __int64, since no compiler seems to support it correctly, the Borland compiler could not correctly handle the zero and one values in the numeric traits class
        ENH: moved detection of long long and __int64 to itkTestType.cmake based on VTK version. Added cmake defines for these types

    Code/Algorithms/CMakeLists.txt

    Code/Algorithms/itkBalloonForceFilter

    Code/Algorithms/itkBalloonForceFilter

    Code/Algorithms/itkBayesianClassifierImageFilter
        BUG: 10205. Inconsistent types for the images of Priors. Lack of const-correctness.

    Code/Algorithms/itkBayesianClassifierImageFilter
        BUG: 10205. Inconsistent types for the images of Priors. Lack of const-correctness.
        BUG: Add a SetPriors convenience method that sets the second input to the prior image and more importantly turns on the flag m_UserProvidedPriors. This flag was always off, making this feature useless.

    Code/Algorithms/itkBinaryMask3DMeshSource
        BUG: changed default of ObjectValue to 1, matching the documentation

    Code/Algorithms/itkBioCellBase
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Algorithms/itkConnectedRegionsMeshFilter

    Code/Algorithms/itkConnectedRegionsMeshFilter

    Code/Algorithms/itkDeformableMesh3DFilter

    Code/Algorithms/itkDeformableMesh3DFilter

    Code/Algorithms/itkDeformableSimplexMesh3DFilter
        ENH: PrintSelf now uses Get's.

    Code/Algorithms/itkDeformableSimplexMesh3DFilter
        ENH: PrintSelf now uses Get's.

    Code/Algorithms/itkFEMRegistrationFilter
        DOC: fix doxygen comments
        COMP: according to KWStyle.

    Code/Algorithms/itkFEMRegistrationFilter

    Code/Algorithms/itkFFTComplexConjugateToRealImageFilter
        BUG: FFTComplexConjugateToRealImageFilter subclasses are producing the full output but are not enlarging the output requested region.

    Code/Algorithms/itkFFTComplexConjugateToRealImageFilter
        BUG: FFTComplexConjugateToRealImageFilter subclasses are producing the full output but are not enlarging the output requested region.

    Code/Algorithms/itkFFTWComplexConjugateToRealImageFilter
        BUG: FFT filters were not reporting any progress

    Code/Algorithms/itkFFTWRealToComplexConjugateImageFilter
        DOC: fix doxygen comments

    Code/Algorithms/itkFFTWRealToComplexConjugateImageFilter
        BUG: FFT filters were not reporting any progress

    Code/Algorithms/itkFastMarchingImageFilter
    insight-users/2010-January/034822.html

    Code/Algorithms/itkFastMarchingImageFilter
    insight-users/2010-January/034822.html

    Code/Algorithms/itkIsolatedWatershedImageFilter
        DOC: fix doxygen comments

    Code/Algorithms/itkLevelSetMotionRegistrationFilter

    Code/Algorithms/itkLevelSetMotionRegistrationFunction

    Code/Algorithms/itkLevelSetMotionRegistrationFunction

    Code/Algorithms/itkMRFImageFilter
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Code/Algorithms/itkMattesMutualInformationImageToImageMetric
        BUG: Number of histogram bins for Mattes must be at least 5 to allow for padding of the Parzen window.

    Code/Algorithms/itkMattesMutualInformationImageToImageMetr

    Code/Algorithms/itkMinMaxCurvatureFlowFunction
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Code/Algorithms/itkPDEDeformableRegistrationFilter
        COMP: The argument of the SetInitialDeformationField() must be a "const" pointer.

    Code/Algorithms/itkRegularSphereMeshSource

    Code/Algorithms/itkScalarImageKmeansImageFilter
        ENH: Let the user change the output image type. This should make it usable in wrapitk even when 'unsigned char' pixel type is not wrapped.

    Code/Algorithms/itkScalarImageKmeansImageFilter
        ENH: Let the user change the output image type. This should make it usable in wrapitk even when 'unsigned char' pixel type is not wrapped.

    Code/Algorithms/itkThresholdSegmentationLevelSetFunction
        COMP: according to KWStyle.

    Code/Algorithms/itkVnlFFTComplexConjugateToRealImageFilter
        BUG: FFT filters were not reporting any progress

    Code/Algorithms/itkVnlFFTRealToComplexConjugateImageFilter
        BUG: FFT filters were not reporting any progress

    Code/Algorithms/itkVoronoiSegmentationImageFilterBase
        DOC: fix doxygen comments

    Code/Algorithms/itkWatershedMiniPipelineProgressCommand

    Code/Algorithms/itkWatershedMiniPipelineProgressCommand

    Code/Algorithms/itkWatershedSegmentTreeGenerator
        DOC: fix doxygen comments

    Code/Algorithms/itkWatershedSegmenter
        DOC: fix doxygen comments

    Code/BasicFilters/CMakeLists.txt

    Code/BasicFilters/itkBSplineDecompositionImageFilter
        ENH: enable instanciation of BSplineDecompositionImageFilter with complex pixel type

    Code/BasicFilters/itkBSplineDecompositionImageFilter
        ENH: enable instanciation of BSplineDecompositionImageFilter with complex pixel type

    Code/BasicFilters/itkBSplineInterpolateImageFunction
        BUG: SetInputIMage(0) did not delete the data.

    Code/BasicFilters/itkBilateralImageFilter
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Code/BasicFilters/itkDeformationFieldSource

    Code/BasicFilters/itkDeformationFieldSource

    Code/BasicFilters/itkHoughTransform2DCirclesImageFilter
        COMP: copy constructor and operator= must be private and non implemented.

    Code/BasicFilters/itkHoughTransform2DLinesImageFilter
        COMP: copy constructor and operator= must be private and non implemented.

    Code/BasicFilters/itkInteriorExteriorMeshFilter

    Code/BasicFilters/itkIterativeInverseDeformationFieldImageFilter
        COMP: Removing declaration of "Report" methods that were not implemented. The m_Report member variable didn't exit.

    Code/BasicFilters/itkIterativeInverseDeformationFieldImageFilter
        BUG: For progress, the number of pixels to be processed should not be multiplied by the number of iterations.

    Code/BasicFilters/itkLabelStatisticsImageFilter
        COMP: Fixing lack of const-correctness in SetInputLabel() and GetInputLabel() methods.

    Code/BasicFilters/itkParallelSparseFieldLevelSetImageFilter
        BUG: 7114 itkParallelSparseFieldLevelSetImageFilter dismisses image information (spacing...).

    Code/BasicFilters/itkParametricSpaceToImageSpaceMeshFilter

    Code/BasicFilters/itkPolylineMask2DImageFilter

    Code/BasicFilters/itkRescaleIntensityImageFilter
        STYLE: Added filter equation in the description.

    Code/BasicFilters/itkSimplexMeshAdaptTopologyFilter

    Code/BasicFilters/itkSimplexMeshToTriangleMeshFilter

    Code/BasicFilters/itkSimplexMeshToTriangleMeshFilter

    Code/BasicFilters/itkStreamingImageFilter
        DOC: fixing typeo

    Code/BasicFilters/itkTransformMeshFilter

    Code/BasicFilters/itkTriangleMeshToSimplexMeshFilter

    Code/BasicFilters/itkTriangleMeshToSimplexMeshFilter

    Code/BasicFilters/itkUnaryFunctorImageFilter
        BUG: backed out last commit. A better solution to passing the meta data dictionary through the pipeline is under investigation.

    Code/BasicFilters/itkVectorConnectedComponentImageFilter
        DOC: fix doxygen comments

    Code/BasicFilters/itkVotingBinaryHoleFillingImageFilter

    Code/BasicFilters/itkVotingBinaryHoleFillingImageFilter

    Code/BasicFilters/itkWarpImageFilter
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/BasicFilters/itkWarpImageFilter
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/BasicFilters/itkWarpMeshFilter

    Code/Common/CMakeLists.txt

    Code/Common/itkAbsImageAdaptor
        DOC: spelling correction.

    Code/Common/itkAcosImageAdaptor
        DOC: spelling correction.

    Code/Common/itkAnnulusOperator

    Code/Common/itkArray

    Code/Common/itkAsinImageAdaptor
        DOC: spelling correction.

    Code/Common/itkAtanImageAdaptor
        DOC: spelling correction.

    Code/Common/itkBSplineDeformableTransform
        BUG: 10251. Cloning of BSplineDeformableTransform, including BulkTransform, for threaded applications. Includes a test that checks each clone based on known number of threads.

    Code/Common/itkBSplineDeformableTransform
        BUG: corrected declaration of copyPtr, which was not compiling on Mac.
        DOC: replaced vcl_floor by floor in a comment

    Code/Common/itkBSplineInterpolationWeightFunction
        COMP: replaced typename template parameter with typedef types for vs6
        COMP: #including itkMath.h that is needed for Math::Floor().

    Code/Common/itkByteSwapper
        DOC: ByteSwapper can handle 8-byte types

    Code/Common/itkCenteredAffineTransform
        COMP: Fixing warnings about shadowing typedef declarations from base classes.

    Code/Common/itkCenteredAffineTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkCenteredEuler3DTransform
        DOC: typo
        COMP: Fixing warnings about shadowing typedef declarations from base classes.

    Code/Common/itkCenteredEuler3DTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkCenteredRigid2DTransform
        COMP: Fixing warnings about shadowing typedef declarations from base classes.

    Code/Common/itkCenteredRigid2DTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkCenteredSimilarity2DTransform
        COMP: Fixing warnings about shadowing typedef declarations from base classes.

    Code/Common/itkCenteredSimilarity2DTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkComplexToImaginaryImageAdaptor
        DOC: spelling correction.

    Code/Common/itkComplexToModulusImageAdaptor
        DOC: spelling correction.

    Code/Common/itkComplexToPhaseImageAdaptor
        DOC: spelling correction.

    Code/Common/itkComplexToRealImageAdaptor
        DOC: spelling correction.

    Code/Common/itkCosImageAdaptor
        DOC: spelling correction.

    Code/Common/itkDiffusionTensor3D

    Code/Common/itkDiffusionTensor3D

    Code/Common/itkElasticBodySplineKernelTransform
        DOC: fix doxygen comments

    Code/Common/itkEllipsoidInteriorExteriorSpatialFunction

    Code/Common/itkEuler3DTransform

    Code/Common/itkEuler3DTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkExceptionObject
        DOC: Added more accurate information about the implementation of ExceptionObject assignment operator.

    Code/Common/itkExpImageAdaptor
        DOC: spelling correction.

    Code/Common/itkExpNegativeImageAdaptor
        DOC: spelling correction.

    Code/Common/itkFiniteCylinderSpatialFunction

    Code/Common/itkFiniteDifferenceImageFilter
        STYLE: Moving implementations from the Header to the txx file.

    Code/Common/itkFiniteDifferenceImageFilter
        STYLE: Moving implementations from the Header to the txx file.

    Code/Common/itkFixedArray

    Code/Common/itkFixedArray

    Code/Common/itkFrustumSpatialFunction

    Code/Common/itkImage
        STYLE: Removing unnecessary semicolon after the closing bracket of the destructor method.

    Code/Common/itkImageBase
        BUG: 10008 added check to determin if the requested region was zero, if so then the filter is not called to be updated since no data is being requested. This enables streaming of JoinSeriesImageFilter with out having all of it's inputs being updated.

    Code/Common/itkImageBase
        BUG: Failure on my part to correctly apply: !(A || B) => !A && !B to disable warnings int UpdateOutputData
        BUG: 10008 added check to determin if the requested region was zero, if so then the filter is not called to be updated since no data is being requested. This enables streaming of JoinSeriesImageFilter with out having all of it's inputs being updated.

    Code/Common/itkImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Common/itkImageFunction
        COMP: Fixing shadowed typedef for IndexValueType

    Code/Common/itkImageRegion
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Code/Common/itkImageRegionMultidimensionalSplitter

    Code/Common/itkImageRegionSplitter

    Code/Common/itkImageSource

    Code/Common/itkImageTransformHelper
        COMP: replaced nested typename typedefs with a more direct typedef for IndexValueType to hopefully please VS6
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Code/Common/itkIndex
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Code/Common/itkIntTypes

        ENH: Changed itkIntTypes to define ITK_HAVE_INT_64, bug fix for test for VS6 which required template parameter to be passed as argument

    Code/Common/itkInternationalizationIOHelpers
        COMP: itkMacro.h must be included in order to use itkNotUsed().
        ENH: Moved unicode io helpers from itkUnicodeIOTest to a new itkInternationalizationIOHelpers header + moved fdstream code into itk namespace to avoid any potential clashes with a user copy of the fdstream header

    Code/Common/itkInterpolateImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Common/itkLevelSetFunction

    Code/Common/itkLevelSetFunction
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkLightProcessObject

    Code/Common/itkLinearInterpolateImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Common/itkLinearInterpolateImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Common/itkLog10ImageAdaptor
        DOC: spelling correction.

    Code/Common/itkLogImageAdaptor
        DOC: spelling correction.

    Code/Common/itkMacro
        COMP: can not include itkMath at the end if itkMacro due to circular dependencies created by other include in itkMathDetail

    Code/Common/itkMapContainer
        COMP: according to KWStyle.

    Code/Common/itkMath
        COMP: concept checking must be conditional to ITK_USE_CONCEPT_CHECKING

        DOC: enabled comments to be parsed by doxygen, and other doxygen improvements
        BUG: accidental commit of concept checking for rounding methods when not portable
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.
        ENH: added numeric constants and changed preprocessor directive to use a feature based test instead of a compiler version test
        COMP: work around for vs6 not correctly supporting function overloading DOC: copied some documentation for VNL methods and refined
        BUG: 6558 commiting Tom Vercauteren contribution to implement rounding methods which can support long integer types ( which is the pixel's coordinates type)

    Code/Common/itkMathDetail
        ENH: Changed to use itkIntTypes from vxl integer types
        BUG: Sun Studio compiler needs to include stdio.h before fenv when cstdio is included
        ENH: added checking of rounding mode in itk::Math rounding methods, added cmake check for fenv.h
        COMP: utilizing NumericTraits for comparisons to zero, to avoid compiler warnings for unsigned integers
        COMP: Error in previous commit. It really is too late for me to be checking in code.
        COMP: can not use SSE2 64-bit rounding on gcc<4.0 due to intrinsic methods not being defined. BUG:RoundHalfIntegerToEven_base had missing parentheses, producing wrong results
        BUG: 6558 commiting Tom Vercauteren contribution to implement rounding methods which can support long integer types ( which is the pixel's coordinates type)

    Code/Common/itkMatrixOffsetTransformBase

    Code/Common/itkMatrixOffsetTransformBase
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkMersenneTwisterRandomVariateGenerator
        BUG: 9426 added an implementation of stdint types into the itk namespace along with test to verify correct size, signness and numeric traits

    Code/Common/itkMesh

    Code/Common/itkMe

    Code/Common/itkMeshToMeshFilter

    Code/Common/itkMeshToMeshFilter

    Code/Common/itkMultiThreader
        COMP: according to KWStyle.

    Code/Common/itkNearestNeighborExtrapolateImageFunction
        COMP: Fixing shadowed typedef for IndexValueType

    Code/Common/itkNonUniformBSpline

    Code/Common/itkNumericTraits
        BUG: removing just added support for __int64, since no compiler seems to support it correctly, the Borland compiler could not correctly handle the zero and one values in the numeric traits class

    Code/Common/itkNumericTraits
        BUG:  NumericTraits<unsigned short>::IsPositive should return bool and not unsigned short
        BUG: removing just added support for __int64, since no compiler seems to support it correctly, the Borland compiler could not correctly handle the zero and one values in the numeric traits class
        COMP: added ITK_ prefix to HAVE_HEADER defines
        ENH: adding numeric traits for long long and __int64

    Code/Common/itkNumericTraitsCovariantVectorPixel
        ENH: added configure define for enabling partial template specializaion of numeric traits, added partial specialization and long long support to pixel types derived from fixed array and tensor

    Code/Common/itkNumericTraitsCovariantVectorPixel
        ENH: added configure define for enabling partial template specializaion of numeric traits, added partial specialization and long long support to pixel types derived from fixed array and tensor

    Code/Common/itkNumericTraitsDiffusionTensor3DPixel
        BUG: Fixed  support for compilers without NUMERIC_TRAITS_PARTIAL_SPECIALIZATION

    Code/Common/itkNumericTraitsDiffusionTensor3DPixel
        ENH: Removed unnecessary dependency on the header of the SymmetricSecondRankTensor.

    Code/Common/itkNumericTraitsFixedArrayPixel
        ENH: added configure define for enabling partial template specializaion of numeric traits, added partial specialization and long long support to pixel types derived from fixed array and tensor

    Code/Common/itkNumericTraitsFixedArrayPixel
        BUG: Readd min(), max() and NonpositiveMin() methods to the vector-like traits.
        COMP: NumericTraits<FixedArray< X, 10> > must be defined to build wrapitk with dim=4

    Code/Common/itkNumericTraitsFixedArrayPixel2

    Code/Common/itkNumericTraitsRGBAPixel
        BUG: fix PrintType NumericTraits for RGBPixel and RGBAPixel
        BUG: corrected the NonpositiveMin to be the correct value in stead of min. STYLE: converted manually filling array to using a constructor in some methods

    Code/Common/itkNumericTraitsRGBPixel
        BUG: fix PrintType NumericTraits for RGBPixel and RGBAPixel
        BUG: corrected the NonpositiveMin to be the correct value in stead of min. STYLE: converted manually filling array to using a constructor in some methods

    Code/Common/itkNumericTraitsTensorPixel
        ENH: added configure define for enabling partial template specializaion of numeric traits, added partial specialization and long long support to pixel types derived from fixed array and tensor

    Code/Common/itkNumericTraitsTensorPixel
        ENH: Removed unnecessary dependency on the header file of the DiffusionTensor3D class.

    Code/Common/itkNumericTraitsTensorPixel2

    Code/Common/itkNumericTraitsVariableLengthVectorPixel
        ENH: added configure define for enabling partial template specializaion of numeric traits, added partial specialization and long long support to pixel types derived from fixed array and tensor

    Code/Common/itkNumericTraitsVectorPixel
        ENH: added configure define for enabling partial template specializaion of numeric traits, added partial specialization and long long support to pixel types derived from fixed array and tensor

    Code/Common/itkNumericTraitsVectorPixel
        ENH: added configure define for enabling partial template specializaion of numeric traits, added partial specialization and long long support to pixel types derived from fixed array and tensor

    Code/Common/itkObjectFactoryBase
        BUG: 10023 Enables a single ObjectFactory to override multiple object of the same kind and use CreateAllInstances to create all instances of the object. This is useful for itk's Plugin IO mechanisms, to that a singe object factory can create multiple ImageIOBase object.

    Code/Common/itkObjectFactoryBase
        BUG: 10023 Enables a single ObjectFactory to override multiple object of the same kind and use CreateAllInstances to create all instances of the object. This is useful for itk's Plugin IO mechanisms, to that a singe object factory can create multiple ImageIOBase object.

    Code/Common/itkPoint
        BUG: the optimal location was not stable enough in the case of singular matrices, instead the new location is x = \hat{x}+\bar{A}^{-1}\cdot \hat{x}; where \hat{x} is the middle of the considered edge. \bar{A} is the recomposed matrix (truncated during the svd decomposition). PERF: reduce the size of used maps when deleting edges. COMP: remove one warning in the computation of the squared euclidean distance in itk::Point.

    Code/Common/itkProgressReporter

    Code/Common/itkQuaternionRigidTransform
        COMP: Fixing warnings about shadowing typedef declarations from base classes.

    Code/Common/itkQuaternionRigidTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkRGBToLuminanceImageAdaptor
        DOC: spelling correction.

    Code/Common/itkRigid2DTransform
        COMP: Fixing warnings about shadowing typedef declarations from base classes.

    Code/Common/itkRigid2DTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkRigid3DPerspectiveTransform

    Code/Common/itkRigid3DPerspectiveTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkRigid3DTransform

    Code/Common/itkRigid3DTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkScalableAffineTransform

    Code/Common/itkScalableAffineTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkScaleLogarithmicTransform

    Code/Common/itkScaleLogarithmicTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkScaleSkewVersor3DTransform
        COMP: Fixing warnings about shadowed declaration of types.

    Code/Common/itkScaleSkewVersor3DTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkScaleTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkSimilarity2DTransform

    Code/Common/itkSimilarity2DTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkSimpleFilterWatcher
        COMP: unitialized ivar.

    Code/Common/itkSimpleFilterWatcher
        DOC: typo

    Code/Common/itkSinImageAdaptor
        DOC: spelling correction.

    Code/Common/itkSmapsFileParser

    Code/Common/itkSobelOperator
        DOC: fix doxygen comments

    Code/Common/itkSphereSpatialFunction

    Code/Common/itkSqrtImageAdaptor
        DOC: spelling correction.

    Code/Common/itkSymmetricSecondRankTensor

    Code/Common/itkSymmetricSecondRankTensor

    Code/Common/itkTanImageAdaptor
        DOC: spelling correction.

    Code/Common/itkTransform

    Code/Common/itkTransformBase

    Code/Common/itkTranslationTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkTriangleCell

    Code/Common/itkVectorInterpolateImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Common/itkVectorLinearInterpolateImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Common/itkVectorLinearInterpolateImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Common/itkVersor
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkVersorRigid3DTransform
        COMP: Fixing warnings about shadowed declaration of types.

    Code/Common/itkVersorRigid3DTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkVersorTransform

    Code/Common/itkVersorTransform
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Common/itkWindowedSincInterpolateImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Common/itkWindowedSincInterpolateImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/IO/CMakeLists.txt

    Code/IO/itkAnalyzeImageIO
        BUG: it should be an error to try and a write an Analyze file where an image dimension is > than the max value for short
        COMP: Fixed float to unsigned long conversion warning.
        COMP: Fixing warnings about shadowing typedef from base classes.

    Code/IO/itkAnalyzeImageIO
        BUG:10135 added loop for reading and writing files so as not to overflow 32-bit integer to support large files, corrected some size types, converted manual exceptions to macro, fix bug to re-enable writing to compressed img.gz files, corrected maximum dimensions size along a single dimension to match the correct integer type

    Code/IO/itkBMPImageIO
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Code/IO/itkConvertPixelBuffer
        COMP: Fix some warnings 'Converting an int into a 64-bit integer causes sign extension.' while building with -xport64=implicit and sun studio.

    Code/IO/itkGDCMImageIO
        BUG: 0009622 reverting proposed patch until fixed by original bug reporter. ITK behavior is to simply discard 3D direction information when writing a Series of 2D images out of a 3D image. This cannot be seen in other format than DICOM, since other format are ok with 2D raster image in 2D world, while DICOM wants 2D raster in 3D world.
        BUG: 0009622 Thanks to Daniele E. Domenichelli for providing the patch
        BUG: FIX 0009129: Can't read private tags in dicom files using gdcm version 2.0. Thanks to Richard Beare for patch

        BUG: Fix 0007748: itk::GDCMImageIO::Write() Image Orientation (Patient)

    Code/IO/itkGDCMImageIO
        ENH: Added GetInternalComponentType.  This differs from ComponentType which may change as a function of rescale slope and intercept

    Code/IO/itkGDCMSeriesFileNames
        BUG: 10330. The implementation of the SetUseSeriesDetails() method must be moved from the header to the .cxx file in order to avoid a warning when building shared libraries in windows.

    Code/IO/itkGDCMSeriesFileNames
        BUG: 10330. The implementation of the SetUseSeriesDetails() method must be moved from the header to the .cxx file in order to avoid a warning when building shared libraries in windows.

    Code/IO/itkIOCommon
        BUG: 0009622 reverting proposed patch until fixed by original bug reporter. ITK behavior is to simply discard 3D direction information when writing a Series of 2D images out of a 3D image. This cannot be seen in other format than DICOM, since other format are ok with 2D raster image in 2D world, while DICOM wants 2D raster in 3D world.
        BUG: 0009622 Thanks to Daniele E. Domenichelli for providing the patch

    Code/IO/itkIOCommon
        BUG: 0009622 reverting proposed patch until fixed by original bug reporter. ITK behavior is to simply discard 3D direction information when writing a Series of 2D images out of a 3D image. This cannot be seen in other format than DICOM, since other format are ok with 2D raster image in 2D world, while DICOM wants 2D raster in 3D world.
        BUG: 0009622 Thanks to Daniele E. Domenichelli for providing the patch

    Code/IO/itkImageFileReader
        BUG: 10529 With a non-streaming imageIO, when converting pixel typesand  then source file is higher dimensions then the templated image type, the wrong image size was used. This may results in a crash. This includes the fix to ImageFileReader and additional testing.

    Code/IO/itkImageIOBase
        BUG: 10124 methods ReadBufferAsASCII and WriteBufferAsASCII do not handle signed and unsigned chars correctly. The methods were reading and writing binary. The values are cast to numeric trait's print typ.
        BUG: Attempt to fix segfault. Indeed ITK_Direction comes in lexical order before ITK_NumberOfDimensions. So changed the name to ITK_ZDirection. Modify the tricky part of itkImageIOBase.cxx where a 3D images was filled from a 2D image, we cannot copy more value in SetDirection than what is stored in 'direction'.

    Code/IO/itkImageIOBase

    Code/IO/itkImageSeriesReader
        BUG: 10456 Restoring performance for ImageSeriesReader (DICOM was especially affected) . Returned the update of the MetaDataDictionaryArray to the UpdateData method. Added timestamp check to avoid excessively updating when streaming, and added flag to diable update of the MDDA aswell.

    Code/IO/itkImageSeriesReader
        BUG: 10456 Restoring performance for ImageSeriesReader (DICOM was especially affected) . Returned the update of the MetaDataDictionaryArray to the UpdateData method. Added timestamp check to avoid excessively updating when streaming, and added flag to diable update of the MDDA aswell.

    Code/IO/itkImageSeriesWriter
        BUG: 0009622 reverting proposed patch until fixed by original bug reporter. ITK behavior is to simply discard 3D direction information when writing a Series of 2D images out of a 3D image. This cannot be seen in other format than DICOM, since other format are ok with 2D raster image in 2D world, while DICOM wants 2D raster in 3D world.
        BUG: 0009622 Thanks to Daniele E. Domenichelli for providing the patch

    Code/IO/itkJPEGImageIO
        BUG: 10035 Use of m_IORegion member variable, this has not always been requred to be set. Changed code to not use said variable.

    Code/IO/itkMetaImageIO
        BUG: 10035 MetaImage::ElementByteOrderFix used the m_IORegion member variable, this has not always been requred to be set. Changed code to only use said variable when streaming and we know that m_IORegion has been set.

    Code/IO/itkNiftiImageIO
        COMP: memory leak.

    Code/IO/itkNiftiImageIO
        ENH: Added header metadata to the metadata dictionary

    Code/IO/itkRawImageIO
        DOC: bug 3503, grammar mistake

    Code/IO/itkTransformFileReader
        BUG: deal with Mac line end conventions in TXT transforms

    Code/IO/itkVTKImageIO
        COMP: Fixing warnings about shadowing typedef from base classes.

    Code/Numerics/CMakeLists.txt

    Code/Numerics/itkCumulativeGaussianOptimizer
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Code/Numerics/itkLBFGSBOptimizer
        ENH:  Added ability to set tracing on the itkLBFGSBOptimizer to make it more consistent with other Optimizer filters.

    Code/Numerics/itkLBFGSBOptimizer
        ENH:  Added ability to set tracing on the itkLBFGSBOptimizer to make it more consistent with other Optimizer filters.

    Code/Numerics/itkLBFGSOptimizer
        BUG: 7810. LBFGSOptimizer::GetValue() not valid until after optimization. Added code to return cached value.

    Code/Numerics/itkLBFGSOptimizer
        BUG: 7810. LBFGSOptimizer::GetValue() not valid until after optimization. Added code to return cached value.

    Code/Numerics/itkOnePlusOneEvolutionaryOptimizer
        BUG: 9583 OnePLusOneEvolutionatyOptimizer: Missing get method for maximize property. ENH: Added Minimize methods. ENH: PrintSelf now uses Get methods.

    Code/Numerics/itkOnePlusOneEvolutionaryOptimizer
        COMP: Get methods must be const.

    Code/Numerics/itkPowellOptimizer
        COMP: Get methods must be const.

    Code/Numerics/itkSPSAOptimizer
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Code/Numerics/itkSymmetricEigenSystem
        COMP: according to KWStyle.

    Code/Numerics/FEM/CMakeLists.txt

    Code/Numerics/FEM/dsrc2c
        COMP: Fixing warning messages, most of them related to lack of cast for (real) type.

    Code/Numerics/FEM/itkFEMLinearSystemWrapperDenseVNL

    Code/Numerics/FEM/itkFEMLoadImplementationGenericLandmarkLoad

    Code/Numerics/FEM/itkFEMSolver
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Numerics/FEM/itkFEMSolverCrankNicolson
        ENH: Removed CastWithRangeCheck for conversion of float to doubles. The apple "shorten-64-to-32" flag unfortunetly warns for this conversion. The CastWithRangeCheck function will be implemented to work with only integer types.

    Code/Numerics/FEM/itkFEMSolverCrankNicolson
        DOC: fix doxygen comments

    Code/Numerics/NeuralNetworks/CMakeLists.txt

    Code/Numerics/NeuralNetworks/itkTransferFunctionBase
        ENH: typedef bug in itk::Statistics::TransferFunctionBase. Pointed out by Stephan Schmitt on the Insight-users mailing list.

    Code/Numerics/Statistics/CMakeLists.txt

    Code/Numerics/Statistics/itkDistanceMetric
        COMP: missing Pointer and ConstPointer typedefs

    Code/Numerics/Statistics/itkExpectationMaximizationMixtureModelEstimator
        BUG: 9551 ExpectationMaximizationMixtureModelEstimator::GetInitialProportions() fails to compile. Changed return to a pointer.

    Code/Numerics/Statistics/itkKdTree
        DOC: This class is not thread safe. State it explicitly.

    Code/Numerics/Statistics/itkListSampleBase
        COMP: missing Pointer and ConstPointer typedefs

    Code/Numerics/Statistics/itkStatisticsAlgorithm
        BUG: The construction of calling GetMeasurementVectorByIndex() and accessing directly one of its components is an error-prone practice. Most of these expressions should be rewritten. In the current form, it was failing in Gcc 3.4 and Visual Studio 9.

    Code/Numerics/Statistics/itkSubsample

    Code/Numerics/Statistics/itkSubsample

    Code/Patented/CMakeLists.txt

    Code/Patented/itkSimpleFuzzyConnectednessImageFilterBase
        BUG: 7372 GetFuzzyScene() return image without correct origin or spacing.

    Code/Review/CMakeLists.txt
        ENH: New classes from the Insight Journal.

    Code/Review/itkAnchorUtilities
        DOC: fix doxygen comments

    Code/Review/itkBSplineScatteredDataPointSetToImageFilter
        DOC: fix doxygen comments
        ENH:  Reconfigured the code to be partly multi-threaded.  Specifically, I threaded the function GenerateControlPointLattice() which originally iterated through all the input points in series at each of the multi-resolution levels.  However, as this can be parallelized, the majority of this function is now in ThreadedGenerateData() which gives a significant speed-up for large B-spline fitting problems.  I also changed some of the documentation for readability and completeness.

    Code/Review/itkBSplineScatteredDataPointSetToImageFilter
        COMP: unused variable warning.
        ENH:  Reconfigured the code to be partly multi-threaded.  Specifically, I threaded the function GenerateControlPointLattice() which originally iterated through all the input points in series at each of the multi-resolution levels.  However, as this can be parallelized, the majority of this function is now in ThreadedGenerateData() which gives a significant speed-up for large B-spline fitting problems.  I also changed some of the documentation for readability and completeness.

    Code/Review/itkBinaryImageToLabelMapFilter
        COMP: Fix missing includes - reported by Christian Werner in ITK users mailing list.

    Code/Review/itkBinaryImageToLabelMapFilter
        ENH: Change the order of the test for a better code coverage. STYLE: Indentation enhancement.
        BUG: Fix progress report.

    Code/Review/itkBruker2DSEQImageIO

    Code/Review/itkBruker2DSEQImageIO
        COMP: FileNameToWrite is not really a param for doxygen

    Code/Review/itkChangeLabelLabelMapFilter
        BUG: Progress was broken. Splitting big methods in smaller ones is usually a good practice. Unfortunatly, it's often difficult to do it right in ITK without breaking the progress report.

    Code/Review/itkChangeLabelLabelMapFilter
        COMP: Removing unnecessary "typename" keyword, that produced compilation error in VS6.

    Code/Review/itkConformalFlatteningMeshFilter

    Code/Review/itkConformalFlatteningMeshFilter

    Code/Review/itkConvolutionImageFilter

    Code/Review/itkCustomColormapFunctor

    Code/Review/itkDiffeomorphicDemonsRegistrationFilter

    Code/Review/itkDirectFourierReconstructionImageToImageFilter

    Code/Review/itkDiscreteGaussianDerivativeImageFilter

    Code/Review/itkDiscreteGaussianDerivativeImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Review/itkDiscreteGaussianDerivativeImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Review/itkDiscreteGradientMagnitudeGaussianImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Review/itkDiscreteGradientMagnitudeGaussianImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Review/itkDiscreteHessianGaussianImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Review/itkDiscreteHessianGaussianImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Review/itkFFTWComplexToComplexImageFilter
        DOC: fix doxygen comments

    Code/Review/itkFlatStructuringElement
        COMP: Fix uninitialized variable warning when dim is greater than 3.

    Code/Review/itkGaborImageSource
        ENH: New classes from the Insight Journal.

    Code/Review/itkGaborImageSource
        ENH: New classes from the Insight Journal.

    Code/Review/itkGaborKernelFunction
        ENH: New classes from the Insight Journal.

    Code/Review/itkGaborKernelFunction
        COMP: Bad export.

    Code/Review/itkGridForwardWarpImageFilter
        COMP: replaced typename template parameter with typedef types for vs6

    Code/Review/itkGridImageSource

    Code/Review/itkHessianToObjectnessMeasureImageFilter
        BUG: Runtime information was wrong, as reported by wrapitk's test PythonGetNameOfClass.

    Code/Review/itkKernelImageFilter
        COMP: Intel compiler was confused by overload method and required conversion, therefore explicitly declare 1 as unsigned long which is the coordiante index component type

    Code/Review/itkLabelGeometryImageFilter
        COMP: std::pow replaced with vcl_pow:  all math functions should use "vcl_" in order to be portable.

    Code/Review/itkLabelGeometryImageFilter
        COMP: VS6 issues resolved.
        COMP: variable assigned a value that is not used Borland warning.
        COMP: Fix build errors and warnings found while adding this class in WrapITK.
        COMP: Templated method inside template code would not compile on VS6. Moved these methods outside of class as helper functions. COMP: GetStaticConstMacro must be used to access static const for Borland.
        COMP: Fixing PrintSelf method. Four member variables were missing.

    Code/Review/itkLabelMap
        ENH: Add Optimize() in LabelMap to run Optimize() on all the referenced LabelObjects

    Code/Review/itkLabelMap
        ENH: Add Optimize() in LabelMap to run Optimize() on all the referenced LabelObjects
        BUG: ClearLabels() and Initialize() must call Modified()

    Code/Review/itkLabelObject
        BUG: Remove wrong check - it must be possible to add the same pixel several times without throwing an exception

    Code/Review/itkMovingHistogramMorphologicalGradientImageFilter
        ENH: Avoid calling typeid() repetively because it scales very badely with high number of threads with sun studio. On my 8 core (and 16 threads) host, performances are enhanced approximately by 15.

    Code/Review/itkMovingHistogramMorphologyImageFilter
        ENH: Avoid calling typeid() repetively because it scales very badely with high number of threads with sun studio. On my 8 core (and 16 threads) host, performances are enhanced approximately by 15.

    Code/Review/itkMultiScaleHessianBasedMeasureImageFilter
        BUG: Missing runtime information, as shown by failing wrapitk's test PythonGetNameOfClass.

    Code/Review/itkMultiphaseDenseFiniteDifferenceImageFilter
        ENH: Add missing PrintSelf method

    Code/Review/itkMultiphaseDenseFiniteDifferenceImageFilter
        ENH: Add missing PrintSelf method
    insight-users/2010-February/035412.html

    Code/Review/itkMultiphaseSparseFiniteDifferenceImageFilter
    insight-users/2010-February/035412.html

    Code/Review/itkOptAdaptiveHistogramEqualizationImageFilter
        DOC: fix doxygen comments

    Code/Review/itkOptImageToImageMetric
        BUG: 10251. Missing header file and test for previous commit for this bug.
        ENH: made SynchronizeTransforms virtual

    Code/Review/itkOptImageToImageMetr

    Code/Review/itkOptLinearInterpolateImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor
        COMP: replaced typename template parameter with typedef types for vs6

    Code/Review/itkOptLinearInterpolateImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Review/itkOptMatchCardinalityImageToImageMetr

    Code/Review/itkOptMattesMutualInformationImageToImageMetric
        BUG: Number of histogram bins for Mattes must be at least 5 to allow for padding of the Parzen window.

    Code/Review/itkOptMattesMutualInformationImageToImageMetr
        BUG: 9745. Fixing integer types involved in the computation of histogram bin locations.

    Code/Review/itkOptResampleImageFilter
        BUG: itkOptResampleImageFilter did not set the start index in SetOutputParametersFromImage.  Also make the API more consistent with itkResampleImageFilter.

    Code/Review/itkOptResampleImageFilter
        BUG: itkOptResampleImageFilter did not set the start index in SetOutputParametersFromImage.  Also make the API more consistent with itkResampleImageFilter.

    Code/Review/itkPhilipsPAR
        COMP: according to KWStyle.

    Code/Review/itkPhilipsRECImageIO

    Code/Review/itkPhilipsRECImageIO
        COMP: FileNameToWrite is not really a param for doxygen

    Code/Review/itkQuadEdgeMeshBorderTransform

    Code/Review/itkQuadEdgeMeshBorderTransform
        ENH: fix memory leaks in itk::QuadEdgeMeshBorderTransform and itk::QuadEdgeMeshTopologyChecker. Note that one list is allocated in QuadEdgeMeshBundaryEdgesMeshFunction and must be deallocated whereever it is used.

    Code/Review/itkQuadEdgeMeshDecimationQuadricElementHelper
        BUG: the optimal location was not stable enough in the case of singular matrices, instead the new location is x = \hat{x}+\bar{A}^{-1}\cdot \hat{x}; where \hat{x} is the middle of the considered edge. \bar{A} is the recomposed matrix (truncated during the svd decomposition). PERF: reduce the size of used maps when deleting edges. COMP: remove one warning in the computation of the squared euclidean distance in itk::Point.
        ENH: Following Peter Lindstrom's paper SVD absolute threshold is set to 10^-6 and relative one to 10^-3.

    Code/Review/itkQuadEdgeMeshDiscreteCurvatureEstimator
        BUG: fix bug in the computation of the mean curvature (as pointed by Sebastien Postaire): H = LaplaceBeltrami * normal.

    Code/Review/itkQuadEdgeMeshDiscreteMeanCurvatureEstimator
        BUG: fix bug in the computation of the mean curvature (as pointed by Sebastien Postaire): H = LaplaceBeltrami * normal.

    Code/Review/itkQuadEdgeMeshDiscretePrincipalCurvaturesEstimator
        BUG: fix bug in the computation of principal curvatures (as pointed by Sebastien Postaire). The computation of principal curvatures require to compute mean and gaussian curvatures (there was one bug in the computation of the mean curvature).

    Code/Review/itkQuadEdgeMeshEdgeMergeDecimationFilter
        BUG: the optimal location was not stable enough in the case of singular matrices, instead the new location is x = \hat{x}+\bar{A}^{-1}\cdot \hat{x}; where \hat{x} is the middle of the considered edge. \bar{A} is the recomposed matrix (truncated during the svd decomposition). PERF: reduce the size of used maps when deleting edges. COMP: remove one warning in the computation of the squared euclidean distance in itk::Point.

    Code/Review/itkQuadEdgeMeshFrontIterator
        ENH: delete m_Front in the destructor. STYLE: fix typo

    Code/Review/itkQuadEdgeMeshFrontIterator
        ENH: delete m_Front in the destructor. STYLE: fix typo

    Code/Review/itkQuadEdgeMeshLineCell
        BUG: memory was only released in one case.

    Code/Review/itkQuadEdgeMeshNormalFilter
        DOC: Following discussion on itk-users list, update the doxygen documentation for references.

    Code/Review/itkQuadEdgeMeshNormalFilter
    insight-users/2010-March/035787.html (Reported by Andriy Fedorov).

    Code/Review/itkQuadEdgeMeshParam

    Code/Review/itkQuadEdgeMeshParamMatrixCoefficients

    Code/Review/itkQuadEdgeMeshPoint
        ENH: Adding a SetPoint() method to allow modifying the point coordinates without having to erase the value of the m_Edge pointer.

    Code/Review/itkQuadEdgeMeshPoint
        ENH: Adding a SetPoint() method to allow modifying the point coordinates without having to erase the value of the m_Edge pointer.

    Code/Review/itkQuadEdgeMeshQuadricDecimation
        BUG: the optimal location was not stable enough in the case of singular matrices, instead the new location is x = \hat{x}+\bar{A}^{-1}\cdot \hat{x}; where \hat{x} is the middle of the considered edge. \bar{A} is the recomposed matrix (truncated during the svd decomposition). PERF: reduce the size of used maps when deleting edges. COMP: remove one warning in the computation of the squared euclidean distance in itk::Point.

    Code/Review/itkQuadEdgeMeshSmoothing
        BUG: need to copy input mesh to current mesh. ENH: Added CopyMeshToMesh method.

    Code/Review/itkQuadEdgeMeshToQuadEdgeMeshFilter
        BUG: need to copy input mesh to current mesh. ENH: Added CopyMeshToMesh method.

    Code/Review/itkQuadEdgeMeshToQuadEdgeMeshFilter
        BUG: need to copy input mesh to current mesh. ENH: Added CopyMeshToMesh method.

    Code/Review/itkQuadEdgeMeshTopologyChecker
        ENH: fix memory leaks in itk::QuadEdgeMeshBorderTransform and itk::QuadEdgeMeshTopologyChecker. Note that one list is allocated in QuadEdgeMeshBundaryEdgesMeshFunction and must be deallocated whereever it is used.

    Code/Review/itkRegionBasedLevelSetFunction
        ENH: Made the compute update function as virtual

    Code/Review/itkRegionBasedLevelSetFunction
    insight-users/2010-February/035412.html

    Code/Review/itkScalarChanAndVeseDenseLevelSetImageFilter
        STYLE: Fix the doxygen documentation and the encoding to make the doc usable in wrapitk.
        ENH: Add default template parameters to Chan and Vese filters in order to make them easier to use and to wrap.

    Code/Review/itkScalarChanAndVeseLevelSetFunction
        ENH: Add default template parameters to Chan and Vese filters in order to make them easier to use and to wrap.

    Code/Review/itkScalarChanAndVeseSparseLevelSetImageFilter
        STYLE: Fix the doxygen documentation and the encoding to make the doc usable in wrapitk.
        ENH: Add default template parameters to Chan and Vese filters in order to make them easier to use and to wrap.

    Code/Review/itkScalarRegionBasedLevelSetFunction
        COMP: missing include

    Code/Review/itkShapeLabelMapFilter
        BUG: Calculating the Feret Diameter on the 0 label results in _very_ long run times.  Added check for zero label.

    Code/Review/itkShapeLabelObject
        BUG: BinaryElongation was printed instead of BinaryFlatness.

    Code/Review/itkSharedMorphologyUtilities

    Code/Review/itkStatisticsUniqueLabelMapFilter
        COMP: Missing include.

    Code/Review/itkStochasticFractalDimensionImageFilter
        STYLE: fix encoding.

    Code/Review/itkTxtTransformIO
        BUG: deal with Mac line end conventions in TXT transforms

    Code/Review/itkVTKPolyDataReader
        BUG: 9548: itkVTKPolyDataReader does not throw an error with some binary vtk files. ENH: added several additional error checks along with a slew of bad vtk polydata files.

    Code/Review/itkVTKPolyDataReader

        BUG: 9548: itkVTKPolyDataReader does not throw an error with some binary vtk files. ENH: added several additional error checks along with a slew of bad vtk polydata files.

    Code/Review/itkVTKPolyDataWriter

    Code/Review/itkVectorLinearInterpolateNearestNeighborExtrapolateImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Review/itkVectorLinearInterpolateNearestNeighborExtrapolateImageFunction
        ENH: Changed some signed long to a cleaner IndexValueType + replaced some hand constructed floor by itk::Math::Floor

    Code/Review/itkVoxBoCUBImageIO

    Code/Review/itkVoxBoCUBImageIO

    Code/Review/Statistics/CMakeLists.txt

    Code/Review/Statistics/itkEuclideanDistanceMetr
        COMP: Improving expression in order to track Valgrind issues, about jump controlled by uninitialized variable.

    Code/Review/Statistics/itkKdTree

    Code/Review/Statistics/itkMeasurementVectorTraits

    Code/Review/Statistics/itkScalarImageToHistogramGenerator
        BUG:010025:  Upon request, changed the way the size was set for the classes to SetLength.

    Code/Review/Statistics/itkStatisticsAlgorithm
        COMP: The construction of calling GetMeasurementVectorByIndex() and accessing directly one of its components is an error-prone practice. Most of these expressions should be rewritten. In the current form, it was failing in Gcc 3.4 and Visual Studio 9.

    Code/Review/Statistics/itkSubsample

    Code/Review/Statistics/itkSubsample

    Code/SpatialObject/CMakeLists.txt

    Code/SpatialObject/itkDTITubeSpatialObject
        COMP: missing private and non implemented copy constructor and operator=

    Code/SpatialObject/itkImageMaskSpatialObject
        COMP: Fixed shadowed typedef warning

    Code/SpatialObject/itkImageMaskSpatialObject
        COMP: Fixed shadowed typedef warning

    Code/SpatialObject/itkImageSpatialObject
        COMP: Fixing warning about unreachable code.

    Code/SpatialObject/itkPolygonSpatialObject
        ENH: Fix more bugs in orientation in the spatial object.
        ENH: Planes should be computed only if the image dimension is greater than or equal to 3

    Code/SpatialObject/itkTubeSpatialObject
        COMP: missing private constructor and operator=

    Code/SpatialObject/itkTubeSpatialObjectPoint
        COMP: missing GetNumDimensions implementation

    Code/SpatialObject/itkVesselTubeSpatialObject
        COMP: missing private and non implemented copy constructor and operator=

    Documentation/Doxygen/DoxygenHeader.html
        STYLE: minor style

    Examples/SearchScript.

    Examples/DataRepresentation/Image/Image2
        STYLE: Fixed typo in documentation. Pointed out by Francois Bertel.

    Examples/Filtering/CMakeLists.txt
        BUG: FFT examples were using the same temp files, and thus were breaking parallel tests.

    Examples/Filtering/FFTImageFilter
        BUG: FFT examples were using the same temp files, and thus were breaking parallel tests.

    Examples/IO/CMakeLists.txt
        BUG: VisibleHuman tests now run in serial

    Examples/Patented/CMakeLists.txt

    Examples/Patented/Attic/IterativeClosestPoint1

    Examples/Patented/Attic/IterativeClosestPoint2

    Examples/Patented/Attic/IterativeClosestPoint3

    Examples/Patented/PatentedExamples
        BUG: IterativeClosestPoint example was removed, but include flies remained.

    Examples/Registration/BSplineWarping1
        ENH: Added itkTransformFileWriter to save the bspline transform.

    Examples/Registration/BSplineWarping2
        ENH: Added itkTransformFileWriter to save the BSpline deformable transform in a file.

    Examples/Registration/CMakeLists.txt
        ENH: Added itkTransformFileWriter to save the BSpline deformable transform in a file.
        ENH: big memory registration tests now run in serial, since running these in parallel can result in too much memory being used and thrashing
        BUG: Number of histogram bins for Mattes must be at least 5 to allow for padding of the Parzen window.

    Examples/Registration/ChangeInformationImageFilter
        DOC: typeo fix

    Examples/Registration/DeformableRegistration1

    Examples/Registration/DeformableRegistration10

    Examples/Registration/DeformableRegistration16

    Examples/Registration/DeformableRegistration17

    Examples/Registration/DeformableRegistration2

    Examples/Registration/DeformableRegistration3

    Examples/Registration/DeformableRegistration5

    Examples/Registration/DeformableRegistration9

    Examples/Registration/DeformationFieldInitialization

    Examples/Registration/ImageRegistration19

    Examples/Registration/ImageRegistration20

    Examples/Registration/IterativeClosestPoint1

    Examples/Registration/IterativeClosestPoint2

    Examples/Registration/IterativeClosestPoint3

    Examples/Registration/LandmarkWarping2

    Examples/Registration/RegistrationExamples14

    Examples/Review/itkScalarSinglePhaseDense2DTest
        BUG: moved using namespace itk to inside function to hopefully prevent namespace collisions on certain systems

    Examples/Review/itkScalarSinglePhaseSparse2DTest
        BUG: moved using namespace itk to inside function to hopefully prevent namespace collisions on certain systems

    Examples/SpatialObjects/BoundingBoxFromImageMaskSpatialObject

    Examples/SpatialObjects/CMakeLists.txt

    Examples/SpatialObjects/MeshSpatialObject
        COMP: Rearranged includes to avoid VS6 internal compiler error.

    Examples/SpatialObjects/ReadWriteSpatialObject
        COMP: Rearranged includes to avoid VS6 internal compiler error.

    Testing/Code/Algorithms/CMakeLists.txt
        ENH: Adding a first test for the LevelSetMotionRegistrationFilter.

    Testing/Code/Algorithms/itkAlgorithmsTests4
        ENH: Adding a first test for the LevelSetMotionRegistrationFilter.

    Testing/Code/Algorithms/itkBayesianClassifierImageFilterTest
        BUG: 10205. Inconsistent types for the images of Priors. Lack of const-correctness.
        ENH: Adding a code for exercising the SetPriors() method.

    Testing/Code/Algorithms/itkKappaStatisticImageToImageMetricTest
        ENH: more coverage

    Testing/Code/Algorithms/itkLevelSetMotionRegistrationFilterTest
        ENH: Adding a first test for the LevelSetMotionRegistrationFilter.

    Testing/Code/BasicFilters/CMakeLists.txt
        ENH: Adding unit tests for the itkBSplineUpsampleImageFilter and itkBSplineDownsampleImageFilter.
        BUG: 10008 Enabling test for streaming JoinSeriesImageFilter. The test verifies the correct execution of the pipeline, when tring to minimize memory usage with ReleaseDataFlagOn
        ENH: Adding unit test for the itkAtan2ImagFilter.
        BUG: 7114 itkParallelSparseFieldLevelSetImageFilter dismisses image information (spacing...). ENH: Test is now a regression test.

    Testing/Code/BasicFilters/itkAtan2ImageFilterTest
        ENH: Adding unit test for the itkAtan2ImagFilter.

    Testing/Code/BasicFilters/itkBSplineDecompositionImageFilterTest
        ENH: enable instanciation of BSplineDecompositionImageFilter with complex pixel type

    Testing/Code/BasicFilters/itkBSplineDownsampleImageFilterTest
        ENH: Adding unit tests for the itkBSplineUpsampleImageFilter and itkBSplineDownsampleImageFilter.

    Testing/Code/BasicFilters/itkBSplineUpsampleImageFilterTest
        ENH: Adding unit tests for the itkBSplineUpsampleImageFilter and itkBSplineDownsampleImageFilter.

    Testing/Code/BasicFilters/itkBasicFiltersTests
        ENH: Adding unit test for the itkAtan2ImagFilter.

    Testing/Code/BasicFilters/itkBasicFiltersTests2
        BUG: 10008 A test which streams the JoinSeriesImageFilter

    Testing/Code/BasicFilters/itkBasicFiltersTests5
        ENH: Adding unit tests for the itkBSplineUpsampleImageFilter and itkBSplineDownsampleImageFilter.

    Testing/Code/BasicFilters/itkDeformationFieldSourceTest

    Testing/Code/BasicFilters/itkDiscreteGaussianImageFilterTest
        ENH: more coverage

    Testing/Code/BasicFilters/itkFlipImageFilterTest
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Testing/Code/BasicFilters/itkImportImageTest
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Testing/Code/BasicFilters/itkInteriorExteriorMeshFilterTest

    Testing/Code/BasicFilters/itkJoinSeriesImageFilterStreamingTest
        BUG: 10008 Enabling test for streaming JoinSeriesImageFilter. The test verifies the correct execution of the pipeline, when tring to minimize memory usage with ReleaseDataFlagOn

    Testing/Code/BasicFilters/itkNonThreadedShrinkImageTest
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Testing/Code/BasicFilters/itkParallelSparseFieldLevelSetImageFilterTest
        BUG: 7114 itkParallelSparseFieldLevelSetImageFilter dismisses image information (spacing...). ENH: Test is now a regression test.

    Testing/Code/BasicFilters/itkPolylineMask2DImageFilterTest

    Testing/Code/BasicFilters/itkShrinkImageTest
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Testing/Code/BasicFilters/itkSimplexMeshAdaptTopologyFilterTest

    Testing/Code/BasicFilters/itkSimplexMeshToTriangleMeshFilterTest

    Testing/Code/BasicFilters/itkSimplexMeshWithFloatCoordRepTest

    Testing/Code/BasicFilters/itkStreamingImageFilterTest2
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Testing/Code/BasicFilters/itkWarpMeshFilterTest

    Testing/Code/Common/CMakeLists.txt
        ENH: adding test for Math::CastWithRangeCheck, with temporary implementation in test file ( which will be moved to itkMath.h )
        BUG: The FactoryTestLib library should be build using SHARED instead of MODULE, for it to work in Macs.
        COMP: Run itkObjectFactoryTest2 in serial mode. See if this resolves problems on hooperlab machines.
        ENH: adding test for templeted itk Math rounding methods
        ENH: adding test for the SimpleFilterWatcher

    Testing/Code/Common/itkBSplineDeformableTransformTest3
        BUG: Corrected an implementation bug in itkBSplineDeformableTransformTest3.cxx, with respect to spline order, and test data for it.

    Testing/Code/Common/itkCenteredVersorTransformInitializerTest
        ENH: Print out the transform, in order to give more confidence to the output.

    Testing/Code/Common/itkCommonTests2
        ENH: adding test for Math::CastWithRangeCheck, with temporary implementation in test file ( which will be moved to itkMath.h )
        BUG: 9426 added an implementation of stdint types into the itk namespace along with test to verify correct size, signness and numeric traits
        ENH: adding test for the SimpleFilterWatcher

    Testing/Code/Common/itkDiffusionTensor3DTest

    Testing/Code/Common/itkFixedCenterOfRotationAffineTransformTest
        STYLE: Fixing brackets indentations.

    Testing/Code/Common/itkIntTypesTest
        ENH: Changed itkIntTypes to define ITK_HAVE_INT_64, bug fix for test for VS6 which required template parameter to be passed as argument
        BUG: errouneous type of uint16_t used in test, shameful remnants of testing the failing case
        COMP: corrected namespace of inttypes to itk

    Testing/Code/Common/itkMathCastWithRangeCheck
        COMP: another attempt to fix icc warning about -1
        COMP: Borland compilation issues. COMP: Borland warnings. COMP: Not all platforms have long long.
        ENH: adding test for Math::CastWithRangeCheck, with temporary implementation in test file ( which will be moved to itkMath.h )

    Testing/Code/Common/itkMathRoundProfileTest1
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Testing/Code/Common/itkMathRoundTest
        BUG: 6558 Changed testing methods to use templated versions and added testing of legacy rounding methods

    Testing/Code/Common/itkMathRoundTest2
        ENH: Changed to use ITK_HAS_INT_64
        BUG: must convert chars to int to print
        COMP: remove 64bit-32bit truncation warnings.
        COMP: including cstdlib for definition of EXIT_SUCCESS and EXIT_FAILURE

    Testing/Code/Common/itkMathTest
        ENH: Rounding test have been moved to MathRoundingTest, this test now tests numeric constants
        COMP: help for vs6 which is appearing to have problems with function overloading
        COMP: need to use brackets instead of quotes for std lib header files

    Testing/Code/Common/itkMeshSourceGraftOutputTest

    Testing/Code/Common/itkNearestNeighborExtrapolateImageFunctionTest
        BUG: 6558 changing rounding methods to use the templated rounding methods in itkMath, this enables the support of the full size of typename itk::Index::ValueType regaurdless of its size.

    Testing/Code/Common/itkNumericTraitsTest
        BUG: removing just added support for __int64, since no compiler seems to support it correctly, the Borland compiler could not correctly handle the zero and one values in the numeric traits class
        ENH: adding more testing of NumericTraits, include the new long long and __int64 types along with addional traits which should be expected

    Testing/Code/Common/itkSimpleFilterWatcherTest
        COMP: Improper use of default constructor.
        ENH: adding test for the SimpleFilterWatcher

    Testing/Code/Common/itkSymmetricSecondRankTensorTest

    Testing/Code/IO/CMakeLists.txt
        BUG:10135 adding tests for large Analyze files

        BUG: 9766 enabling additional testing of stream reading for MHD files
        ENH: Adding a small test to try and move forward on unicode filenames, see bug 9623
        BUG: Don't use hard coded filenames in programs used in several tests, to be able to run the tests in parallel
        BUG: Remove duplicated tests which were breaking parallel testing.
        BUG: ReadWriteSpatialObjectTest and MeshSpatialObjectIOTest were using the same temporary file for internal tests.

    Testing/Code/IO/itkAnalyzeImageIOTest
        BUG: Fix the broken loop made to test both NiftiImageIOFactory and AnalyzeImageIOFactory - it was always running the internal tests for Analyze, and thus wasn't exercising the read capabilities. The mistake has been highlted by some failing parallel test which were all trying to write the output files of the internal tests at the same time.

    Testing/Code/IO/itkIOTests
        BUG: 9766 adding test designed to stream read different regions

    Testing/Code/IO/itkImageFileReaderDimensionsTest
        BUG: 10529 With a non-streaming imageIO, when converting pixel typesand  then source file is higher dimensions then the templated image type, the wrong image size was used. This may results in a crash. This includes the fix to ImageFileReader and additional testing.

    Testing/Code/IO/itkImageFileReaderStreamingTest2
        COMP: Borland had trouble with type in routine signature.

    Testing/Code/IO/itkLargeImageWriteConvertReadTest
        ENH: free the written image buffer before reading to reduce memory usage

    Testing/Code/IO/itkLargeImageWriteReadTest

    Testing/Code/IO/itkMeshSpatialObjectIOTest
        COMP: Rearranged includes to avoid VS6 internal compiler error.

    Testing/Code/IO/itkNiftiImageIOTest
        COMP: VS7 compiler limit.
        BUG: Don't use hard coded filenames in programs used in several tests, to be able to run the tests in parallel

    Testing/Code/IO/itkNiftiImageIOTest2
        BUG: More parallel test fixes, this time for Gipl and Nifti tests

    Testing/Code/IO/itkPNGImageIOTest

    Testing/Code/IO/itkReadWriteSpatialObjectTest
        COMP: Rearranged includes to avoid VS6 internal compiler error.

    Testing/Code/IO/itkTIFFImageIOTest
        ENH: Added additional image types.

    Testing/Code/IO/itkTransformIOTest

    Testing/Code/IO/itkUnicodeIOTest
        ENH: Moved unicode io helpers from itkUnicodeIOTest to a new itkInternationalizationIOHelpers header + moved fdstream code into itk namespace to avoid any potential clashes with a user copy of the fdstream header
        COMP: trying to resolve SUN CC compiler issue with strcmp() missing prototype.
        COMP: trying to fix sun issues
        COMP: Trying to fix vs9+win64 compilation warnings
        COMP:  Fixing msvc warning
        COMP: Tentative fix of itkUnicodeIOTest for borland

    Testing/Code/IO/testMetaArray

    Testing/Code/IO/testMetaBlob

    Testing/Code/IO/testMetaGroup

    Testing/Code/IO/testMetaLandmark

    Testing/Code/IO/testMetaLine

    Testing/Code/IO/testMetaMe

    Testing/Code/IO/testMetaObject

    Testing/Code/IO/testMetaScene

    Testing/Code/IO/testMetaSurface

    Testing/Code/IO/testMetaTube

    Testing/Code/IO/testMetaUtils

    Testing/Code/Numerics/itkLBFGSOptimizerTest
        BUG: 7810. LBFGSOptimizer::GetValue() not valid until after optimization. Added code to return cached value.

    Testing/Code/Numerics/itkSPSAOptimizerTest
        ENH: more coverage

    Testing/Code/Numerics/Statistics/CMakeLists.txt
        BUG: itkKdTreeTest?Plot tests are reusing the output of itkKdTreeTest?, so they must be run in order.

    Testing/Code/Numerics/Statistics/itkExpectationMaximizationMixtureModelEstimatorTest
        BUG: 9551 ExpectationMaximizationMixtureModelEstimator::GetInitialProportions() fails to compile. Changed return to a pointer.

    Testing/Code/Numerics/Statistics/itkKdTreeTest1

    Testing/Code/Numerics/Statistics/itkWeightedCentroidKdTreeGeneratorTest1

    Testing/Code/Patented/itkSimpleFuzzyConnectednessScalarImageFilterTest
        BUG: 7372 GetFuzzyScene() return image without correct origin or spacing.

    Testing/Code/Review/CMakeLists.txt
        BUG: fixed CMakeLists.txt and itkReviewTests.cxx to allow error-free build when ITK_USE_OPTIMIZED_REGISTRATION_METHODS set to OFF.
        COMP: Added new tests for itkTransform IO
        ENH: Add code to TransformFileWriter and TransformToDeformationFieldSource tests to improve coverage
        ENH: several tests and related baseline images for DiscreteGaussianDerivativeImageFilter - contributed by Ivan Macia
        BUG: LabelGeometryImageFilterTest2 has been moved to ReviewTests5
        ENH: Hopefully, full code coverage for BinaryImageToLabelMapFilter.
        ENH: Add an artificial image to exercise all the line configurations in BinaryImageToLabelMapFilter.
        ENH: Test a wrong method type in MergeLabelMapFilter - coverage should reach 100% in that class.
        ENH: New tests for GaborImageSource.
        ENH: Another test case for bad vtk polydata.
        BUG: Remove new tests that are failing on Borland until I return from trip.

    Testing/Code/Review/itkBinaryImageToLabelMapFilterTest
        ENH: Hopefully, full code coverage for BinaryImageToLabelMapFilter.

    Testing/Code/Review/itkCropLabelMapFilterTest1
        ENH: Full test coverage of CropLabelMapFilter. STYLE: better filter name.

    Testing/Code/Review/itkDiscreteGaussianDerivativeImageFilterTest
        COMP: oops, wrong position of [].
        ENH: Add itkDiscreteGaussianDerivativeImageFilterTest contributed by Ivan Macia

    Testing/Code/Review/itkDiscreteGaussianDerivativeImageFunctionTest
        ENH: more coverage

    Testing/Code/Review/itkDiscreteGradientMagnitudeGaussianImageFunctionTest
        ENH: more coverage

    Testing/Code/Review/itkDiscreteHessianGaussianImageFunctionTest
        ENH: more coverage

    Testing/Code/Review/itkGaborImageSourceTest
        COMP: unused variable warnings.

    Testing/Code/Review/itkGeometricalQuadEdgeTest1
        ENH: (memory leaks) delete allocated elements.

    Testing/Code/Review/itkLabelGeometryImageFilterTest
        COMP: VS6 issues resolved.

    Testing/Code/Review/itkLabelMapTest
        ENH: Add Optimize() in LabelMap to run Optimize() on all the referenced LabelObjects

    Testing/Code/Review/itkOptImageToImageMetricsTest2
        BUG: 10251. Missing header file and test for previous commit for this bug.

    Testing/Code/Review/itkOptImageToImageMetricsTest2
        BUG: 10251. Missing header file and test for previous commit for this bug.

    Testing/Code/Review/itkPriorityQueueTest

    Testing/Code/Review/itkQuadEdgeMeshCellInterfaceTest
        BUG: fix memory leaks (missing delete) in the test itself

    Testing/Code/Review/itkQuadEdgeMeshEulerOperatorJoinVertexTest
        BUG: fix memory leak in itkQuadEdgeMeshEulerOperatorJoinVertexTest (missing delete for IsolatedLineCell).

    Testing/Code/Review/itkQuadEdgeMeshGaussianCurvatureTest

    Testing/Code/Review/itkQuadEdgeMeshLinearParameterizationTest

    Testing/Code/Review/itkQuadEdgeMeshMaxCurvatureTest

    Testing/Code/Review/itkQuadEdgeMeshMeanCurvatureTest

    Testing/Code/Review/itkQuadEdgeMeshMinCurvatureTest

    Testing/Code/Review/itkQuadEdgeMeshPointTest1
        ENH: Adding a SetPoint() method to allow modifying the point coordinates without having to erase the value of the m_Edge pointer.

    Testing/Code/Review/itkQuadEdgeMeshQuadricDecimationTest

    Testing/Code/Review/itkQuadEdgeMeshSmoothingTest

    Testing/Code/Review/itkQuadEdgeMeshSquaredEdgeLengthDecimationTest

    Testing/Code/Review/itkReviewTests
        BUG: fixed CMakeLists.txt and itkReviewTests.cxx to allow error-free build when ITK_USE_OPTIMIZED_REGISTRATION_METHODS set to OFF.

    Testing/Code/Review/itkReviewTests2
        COMP: Rearranged tests to avoid Borland linker errors.

    Testing/Code/Review/itkReviewTests3
        ENH: Add itkDiscreteGaussianDerivativeImageFilterTest contributed by Ivan Macia

    Testing/Code/Review/itkReviewTests4
        COMP: Moved itkLabelGeometryImageFilterTest into itkReviewTests5. itkReviewTests4 contains tests that cannot be built on Borland.

    Testing/Code/Review/itkReviewTests5
        COMP: Moved itkLabelGeometryImageFilterTest into itkReviewTests5. itkReviewTests4 contains tests that cannot be built on Borland.

    Testing/Code/Review/itkReviewTests6
        COMP: Rearranged tests to avoid Borland linker errors.

    Testing/Code/Review/itkScalarChanAndVeseDenseLevelSetImageFilterTest2
        ENH: Add default template parameters to Chan and Vese filters in order to make them easier to use and to wrap.

    Testing/Code/Review/itkScalarChanAndVeseDenseLevelSetImageFilterTest3
        ENH: New test using the UnconstrainedRegionBasedLevelSetFunctionSharedData classes

    Testing/Code/Review/itkScalarChanAndVeseDenseLevelSetImageFilterTest4
        ENH: New test using the UnconstrainedRegionBasedLevelSetFunctionSharedData classes

    Testing/Code/Review/itkTransformFileReaderWriterTest
        COMP: Added new tests for itkTransform IO

    Testing/Code/Review/itkTransformToDeformationFieldSourceTest
        ENH: Add code to TransformFileWriter and TransformToDeformationFieldSource tests to improve coverage

    Testing/Code/Review/Statistics/CMakeLists.txt
        BUG: itkKdTreeTest?Plot tests are reusing the output of itkKdTreeTest?, so they must be run in order.

    Testing/Code/Review/Statistics/itkCovarianceSampleFilterTest
        BUG: Bug pointed out by Ricardo Ferrari on the ITK mailing list.

    Testing/Code/Review/Statistics/itkImageToHistogramFilterTest3
        BUG:010025:  A class was not being properly tested, and a segmentation fault was occuring. A new test was added to exercise this bit of code.

    Testing/Code/Review/Statistics/itkStatisticsTests
        BUG:010025:  A class was not being properly tested, and a segmentation fault was occuring. A new test was added to exercise this bit of code.

    Testing/Data/Baseline/BasicFilters/ParallelSparseFieldLevelSetImageFilterTest.mha
        BUG: 7114 itkParallelSparseFieldLevelSetImageFilter dismisses image information (spacing...). ENH: Test is now a regression test.

    Testing/Data/Baseline/Common/itkBSplineDeformableTransformTest5.png
        BUG: Corrected an implementation bug in itkBSplineDeformableTransformTest3.cxx, with respect to spline order, and test data for it.

    Testing/Data/Baseline/Common/itkBSplineDeformableTransformTest5PixelCentered.png
        BUG: 10251. Committed a test that reproduces the bug, featuring 3 loops: no invocation of multithreader, invocation of multithreader with 1 thread, and again with 2 threads. The first two parts of the test are successful, but the test fails on the implementation with 2 threads.

    Testing/Data/Baseline/Review/GaborImageSourceTest0.mha
        ENH: Baselines for new tests.

    Testing/Data/Baseline/Review/GaborImageSourceTest1.mha
        ENH: Baselines for new tests.

    Testing/Data/Baseline/Review/connected0lines-0.png
        ENH: Add an artificial image to exercise all the line configurations in BinaryImageToLabelMapFilter.

    Testing/Data/Baseline/Review/connected0lines-1.png
        ENH: Add an artificial image to exercise all the line configurations in BinaryImageToLabelMapFilter.

    Testing/Data/Baseline/Review/cthead1-label-changed3.png
        ENH: test the case where an object must be removed to free the label for the background - coverage should reach 100% in ChangeLabelLabelMapFilter.

    Testing/Data/Baseline/Review/itkBSplineScatteredDataPointSetToImageFilterTest01.mha
        ENH: Baseline for new regression test.

    Testing/Data/Baseline/Review/itkDiscreteGaussianDerivativeImageFilterTest01.png
        ENH: several tests and related baseline images for DiscreteGaussianDerivativeImageFilter - contributed by Ivan Macia

    Testing/Data/Baseline/Review/itkDiscreteGaussianDerivativeImageFilterTest02.png
        ENH: several tests and related baseline images for DiscreteGaussianDerivativeImageFilter - contributed by Ivan Macia

    Testing/Data/Baseline/Review/itkDiscreteGaussianDerivativeImageFilterTest03.png
        ENH: several tests and related baseline images for DiscreteGaussianDerivativeImageFilter - contributed by Ivan Macia

    Testing/Data/Baseline/Review/itkDiscreteGaussianDerivativeImageFilterTest10.png
        ENH: several tests and related baseline images for DiscreteGaussianDerivativeImageFilter - contributed by Ivan Macia

    Testing/Data/Baseline/Review/itkDiscreteGaussianDerivativeImageFilterTest11.png
        ENH: several tests and related baseline images for DiscreteGaussianDerivativeImageFilter - contributed by Ivan Macia

    Testing/Data/Baseline/Review/itkDiscreteGaussianDerivativeImageFilterTest12.png
        ENH: several tests and related baseline images for DiscreteGaussianDerivativeImageFilter - contributed by Ivan Macia

    Testing/Data/Baseline/Review/itkDiscreteGaussianDerivativeImageFilterTest20.png
        ENH: several tests and related baseline images for DiscreteGaussianDerivativeImageFilter - contributed by Ivan Macia

    Testing/Data/Baseline/Review/itkDiscreteGaussianDerivativeImageFilterTest21.png
        ENH: several tests and related baseline images for DiscreteGaussianDerivativeImageFilter - contributed by Ivan Macia

    Testing/Data/Baseline/Review/itkDiscreteGaussianDerivativeImageFilterTest30.png
        ENH: several tests and related baseline images for DiscreteGaussianDerivativeImageFilter - contributed by Ivan Macia

    Testing/Data/Baseline/Review/itkLabelGeometryImageFilterTest2Image.png

    Testing/Data/Baseline/Review/nonConnected3DLines-0.tif
        ENH: Hopefully, full code coverage for BinaryImageToLabelMapFilter.

    Testing/Data/Input/289.png

    Testing/Data/Input/BinaryImageWithVariousShapes01.png

    Testing/Data/Input/GrayscaleImageWithVariousShapes01.png

    Testing/Data/Input/connected0lines.png
        ENH: Add an artificial image to exercise all the line configurations in BinaryImageToLabelMapFilter.

    Testing/Data/Input/itkBSplineTransform00.txt
        BUG: more formatting damage in transform txt file
        ENH: Added Transform text file with bspline transform in it

    Testing/Data/Input/nonConnected3DLines.tif
        ENH: Hopefully, full code coverage for BinaryImageToLabelMapFilter.

    Testing/Data/Input/sphereBinary.vtk
        ENH: more test data for itkVTKPolyDataReader.

    Testing/Data/Input/vtkPolyDataBad0.vtk
        ENH: Another polydata test file.

    Testing/Data/Input/vtkPolyDataBad1.vtk
        ENH: more test data for itkVTKPolyDataReader.

    Testing/Data/Input/vtkPolyDataBad10.vtk
        ENH: Header describes the reason the file is bad.

    Testing/Data/Input/vtkPolyDataBad11.vtk
        ENH: Header describes the reason the file is bad.

    Testing/Data/Input/Attic/vtkPolyDataBad11.vtk~
        BUG: should not add the backup files.

    Testing/Data/Input/vtkPolyDataBad12.vtk
        ENH: Header describes the reason the file is bad.

    Testing/Data/Input/Attic/vtkPolyDataBad12.vtk~
        BUG: should not add the backup files.

    Testing/Data/Input/vtkPolyDataBad13.vtk
        ENH: Extensive invalid data testng for vtkITKPolyDataReader.

    Testing/Data/Input/Attic/vtkPolyDataBad13.vtk~
        BUG: should not add the backup files.

    Testing/Data/Input/vtkPolyDataBad14.vtk
        ENH: Header describes the reason the file is bad.

    Testing/Data/Input/Attic/vtkPolyDataBad14.vtk~
        BUG: should not add the backup files.

    Testing/Data/Input/vtkPolyDataBad15.vtk
        ENH: Header describes the reason the file is bad.

    Testing/Data/Input/Attic/vtkPolyDataBad15.vtk~
        BUG: should not add the backup files.

    Testing/Data/Input/vtkPolyDataBad16.vtk
        ENH: Header describes the reason the file is bad.

    Testing/Data/Input/Attic/vtkPolyDataBad16.vtk~
        BUG: should not add the backup files.

    Testing/Data/Input/vtkPolyDataBad17.vtk
        ENH: Extensive invalid data testng for vtkITKPolyDataReader.

    Testing/Data/Input/Attic/vtkPolyDataBad17.vtk~
        BUG: should not add the backup files.

    Testing/Data/Input/vtkPolyDataBad2.vtk
        ENH: Header describes the reason the file is bad.

    Testing/Data/Input/vtkPolyDataBad3.vtk
        ENH: Extensive invalid data testng for vtkITKPolyDataReader.

    Testing/Data/Input/vtkPolyDataBad4.vtk
        ENH: Header describes the reason the file is bad.
        ENH: more test data for itkVTKPolyDataReader.

    Testing/Data/Input/vtkPolyDataBad5.vtk
        ENH: Extensive invalid data testng for vtkITKPolyDataReader.

    Testing/Data/Input/vtkPolyDataBad6.vtk
        ENH: Header describes the reason the file is bad.

    Testing/Data/Input/vtkPolyDataBad7.vtk
        ENH: Header describes the reason the file is bad.

    Testing/Data/Input/vtkPolyDataBad8.vtk
        ENH: Header describes the reason the file is bad.

    Testing/Data/Input/vtkPolyDataBad9.vtk
        ENH: Header describes the reason the file is bad.

    Testing/Data/Input/whiteSpot.png
        ENH: Add itkDiscreteGaussianDerivativeImageFilterTest contributed by Ivan Macia

    Utilities/CMakeLists.txt
        BUG: 9757. Flattening directory structure of the installation tree.

    Utilities/DICOMParser/CMakeLists.txt
        BUG: 9757. Flattening directory structure of the installation tree.

    Utilities/DICOMParser/DICOMAppHelper

    Utilities/DICOMParser/DICOMSource

    Utilities/Dart/PrintSelfCheck.tcl
        ENH: Recognize GetFoo() in PrintSelf.

    Utilities/Doxygen/doxygen.config.in
        DOC: fix for itkTemplateFloatingToIntegerMacro
        ENH: added itkMathDetail.h to the exclude list

    Utilities/KWStyle/ITKOverwrite.txt
        ENH: adding exclusion of itkIntTypes.h for stdint style typedefs

    Utilities/MetaIO/.svnrev
        ENH: subversion revision 1641 commited to CVS
        ENH: subversion revision 963 commited to CVS
        ENH: subversion revision 905 commited to CVS
        ENH: subversion revision 883 commited to CVS
        ENH: subversion revision 880 commited to CVS

    Utilities/MetaIO/metaArray

    Utilities/MetaIO/metaArray

    Utilities/MetaIO/metaBlob

    Utilities/MetaIO/metaContour

    Utilities/MetaIO/metaContour

    Utilities/MetaIO/metaImage

    Utilities/MetaIO/metaImage

    Utilities/MetaIO/metaLandmark

    Utilities/MetaIO/metaLine

    Utilities/MetaIO/metaMe

    Utilities/MetaIO/metaObject

    Utilities/MetaIO/metaObject

    Utilities/MetaIO/metaSurface

    Utilities/MetaIO/metaTube

    Utilities/MetaIO/metaUtils

    Utilities/MetaIO/metaUtils

    Utilities/MetaIO/metaVesselTube

    Utilities/NrrdIO/754
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.
        ENH: gradual reconciliation with Sourceforge-Teem repository.
        COMP: Fixing compilation warnings about local variables shadowing others.

    Utilities/NrrdIO/CMakeLists.txt
        BUG: fix for endianness, as relates to ppc-Mac.
        ENH: Update to Nrrd library 2009 (Teem 1.10). No change to IO ctest.
        BUG: problem with cross-compiled Mac platforms, reverting back to pre-January version.
        BUG: 9757. Flattening directory structure of the installation tree.

    Utilities/NrrdIO/NrrdConfigure.h.in
        BUG: fix for endianness, as relates to ppc-Mac.

    Utilities/NrrdIO/NrrdIO
        BUG: fixes "warning: array subscript is below array bounds" on build.
        ENH: Update to Nrrd library 2009 (Teem 1.10). No change to IO ctest.
        ENH: Update to Nrrd library 2009 (Teem 1.10). No change to IO ctest.
        ENH: Update to Nrrd library 2009 (Teem 1.10). Many files needed to be committed together for build. Also, NrrdIO.h updated to deal with build warnings. No change to IO ctest.
        ENH: the previous commit was demonstrated to be the culprit causing failing NrrdIO-related tests on Mac cross-compiled builds. Revert back to old versions.
        ENH: another installment of gradual reconciliation with Sourceforge-Teem repository, done 1 .c file at a time because of Mac cross-compiler build problems.
        ENH: very gradual conversion to new Teem library, starting with minimally different NrrdIO.h.
        BUG: revert to old sanity logic in view of failings tests in Mac cross-compiled code.
        ENH: Update to Nrrd library 2009 (Teem 1.10). No change to IO ctest.
        ENH: Update to Nrrd library 2009 (Teem 1.10). No change to IO ctest.

    Utilities/NrrdIO/accessors
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/array
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.
        BUG: problem with cross-compiled Mac platforms, reverting back to pre-January version.

    Utilities/NrrdIO/arraysNrrd
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/axis
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/biff
        ENH: Update to Nrrd library 2009 (Teem 1.10). No change to IO ctest.

    Utilities/NrrdIO/biffbiff
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.
        BUG: problem with cross-compiled Mac platforms, reverting back to pre-January version.

    Utilities/NrrdIO/biffmsg
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/comment
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/defaultsNrrd
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/dio
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.
        BUG: problem with cross-compiled Mac platforms, reverting back to pre-January version.

    Utilities/NrrdIO/encoding
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/encodingAscii
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/encodingBzip2
        ENH: revise recent changes to NrrdIO based on script-based procedure in wiki, and in particular NEED_NOT and TEEM_HDRS files as in pre-GNUmakefile, which in turn is modified to work with practical "tail" options.

    Utilities/NrrdIO/encodingGzip
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/encodingHex
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/encodingRaw
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.
        ENH: Update to Nrrd library 2009 (Teem 1.10). No change to IO ctest.

    Utilities/NrrdIO/endianAir
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.
        BUG: problem with cross-compiled Mac platforms, reverting back to pre-January version.

    Utilities/NrrdIO/endianNrrd
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/enum
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.
        BUG: problem with cross-compiled Mac platforms, reverting back to pre-January version.

    Utilities/NrrdIO/enumsNrrd
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.
        BUG: problem with cross-compiled Mac platforms, reverting back to pre-January version.

    Utilities/NrrdIO/format
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/formatEPS
        ENH: revise recent changes to NrrdIO based on script-based procedure in wiki, and in particular NEED_NOT and TEEM_HDRS files as in pre-GNUmakefile, which in turn is modified to work with practical "tail" options.

    Utilities/NrrdIO/formatNRRD
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/formatPNG
        ENH: revise recent changes to NrrdIO based on script-based procedure in wiki, and in particular NEED_NOT and TEEM_HDRS files as in pre-GNUmakefile, which in turn is modified to work with practical "tail" options.

    Utilities/NrrdIO/formatPNM
        ENH: revise recent changes to NrrdIO based on script-based procedure in wiki, and in particular NEED_NOT and TEEM_HDRS files as in pre-GNUmakefile, which in turn is modified to work with practical "tail" options.

    Utilities/NrrdIO/formatText
        ENH: revise recent changes to NrrdIO based on script-based procedure in wiki, and in particular NEED_NOT and TEEM_HDRS files as in pre-GNUmakefile, which in turn is modified to work with practical "tail" options.

    Utilities/NrrdIO/formatVTK
        ENH: revise recent changes to NrrdIO based on script-based procedure in wiki, and in particular NEED_NOT and TEEM_HDRS files as in pre-GNUmakefile, which in turn is modified to work with practical "tail" options.

    Utilities/NrrdIO/gzio
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/itk_NrrdIO_mangle

        BUG: Updated mangled symbols so that ITK-based applications can be built with Teem
        BUG: problem with cross-compiled Mac platforms, reverting back to pre-January version.

    Utilities/NrrdIO/keyvalue
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/mangle.pl

    Utilities/NrrdIO/methodsNrrd
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/miscAir
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.
        ENH: Input one more file consistent with Sourceforge-Teem repository, to incrementally build error-free on Mac cross-platform.
        ENH: Update to Nrrd library 2009 (Teem 1.10). No change to IO ctest.

    Utilities/NrrdIO/mop
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.
        BUG: problem with cross-compiled Mac platforms, reverting back to pre-January version.

    Utilities/NrrdIO/parseAir
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.
        BUG: problem with cross-compiled Mac platforms, reverting back to pre-January version.

    Utilities/NrrdIO/parseNrrd
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/pre-GNUmakefile
        BUG: wiki procedure was not working properly due to need for itk_zlib.h in build process.

    Utilities/NrrdIO/preamble
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/privateAir
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.
        BUG: problem with cross-compiled Mac platforms, reverting back to pre-January version.

    Utilities/NrrdIO/privateNrrd
        ENH: provide explanatory comment in context of procedure for updating NrrdIO within ITK.
        ENH: Update to Nrrd library 2009 (Teem 1.10). No change to IO ctest.

    Utilities/NrrdIO/Attic/randMT
        ENH: revise recent changes to NrrdIO based on script-based procedure in wiki, and in particular NEED_NOT and TEEM_HDRS files as in pre-GNUmakefile, which in turn is modified to work with practical "tail" options.

    Utilities/NrrdIO/read
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/reorder
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.
        BUG: Re-inserted pragma that deals with build warnings that occur on some Linux builds, which was present prior to previous commit based on Sourceforge-Teem repository.

    Utilities/NrrdIO/sample-GNUmakefile
        BUG: wiki procedure was not working properly due to need for itk_zlib.h in build process.

    Utilities/NrrdIO/sampleIO
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/sane
        BUG: previous bug fix for Mac cross-compiled was wrong.
        BUG: disabled for all platforms the line that is problematic on cross-compiled Macs. Will disable for Macs shortly.
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.
        ENH: the previous commit was demonstrated to be the culprit causing failing NrrdIO-related tests on Mac cross-compiled builds. Revert back to old versions.
        BUG: problem with cross-compiled Mac platforms, reverting back to pre-January version.
        BUG: revert to old sanity logic in view of failings tests in Mac cross-compiled code.

    Utilities/NrrdIO/simple
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/string
        COMP: warning: subscript has type char.
        ENH: gradual reconciliation with Sourceforge-teem, one file at a time, in attempt to track down problems with Mac cross-compile builds.
        ENH: Update to Nrrd library 2009 (Teem 1.10). No change to IO ctest.

    Utilities/NrrdIO/subset
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.
        ENH: Update to Nrrd library 2009 (Teem 1.10). No change to IO ctest.

    Utilities/NrrdIO/teem32bit
        ENH: revise recent changes to NrrdIO based on script-based procedure in wiki, and in particular NEED_NOT and TEEM_HDRS files as in pre-GNUmakefile, which in turn is modified to work with practical "tail" options.

    Utilities/NrrdIO/teemDio
        ENH: revise recent changes to NrrdIO based on script-based procedure in wiki, and in particular NEED_NOT and TEEM_HDRS files as in pre-GNUmakefile, which in turn is modified to work with practical "tail" options.

    Utilities/NrrdIO/teemEndian
        ENH: revise recent changes to NrrdIO based on script-based procedure in wiki, and in particular NEED_NOT and TEEM_HDRS files as in pre-GNUmakefile, which in turn is modified to work with practical "tail" options.

    Utilities/NrrdIO/teemPng
        ENH: revise recent changes to NrrdIO based on script-based procedure in wiki, and in particular NEED_NOT and TEEM_HDRS files as in pre-GNUmakefile, which in turn is modified to work with practical "tail" options.

    Utilities/NrrdIO/teemQnanhibit
        ENH: revise recent changes to NrrdIO based on script-based procedure in wiki, and in particular NEED_NOT and TEEM_HDRS files as in pre-GNUmakefile, which in turn is modified to work with practical "tail" options.

    Utilities/NrrdIO/unteem.pl
        ENH: updated NrrdIO files based on 11-step process of wiki procedure. May have to tweak sane.c.

    Utilities/NrrdIO/write
        BUG: return to previous bug fix for airSinglePrintf suggested in rev 1.12.
        ENH: Update to Nrrd library 2009 (Teem 1.10). No change to IO ctest.

    Utilities/expat/CMakeLists.txt
        BUG: 9757. Flattening directory structure of the installation tree.

    Utilities/gdcm/src/CMakeLists.txt
        BUG: 9757. Flattening directory structure of the installation tree.

    Utilities/gdcm/src/gdcmDicomDir

    Utilities/gdcm/src/gdcmDocument

    Utilities/gdcm/src/gdcmElementSet
        BUG: 0009882 This is an attempt to fix the issue. Thanks to Emmanuel Olart to the bisection search

    Utilities/gdcm/src/gdcmFile
        BUG: 10115 itkGDCMImageIO fails to compute proper orientation and origin for Enhanced MR Image Storage dicom images. Methods were added to extract the orientation amd origin from the sequence if present.

    Utilities/gdcm/src/gdcmFile
        BUG: 10115 itkGDCMImageIO fails to compute proper orientation and origin for Enhanced MR Image Storage dicom images. Methods were added to extract the orientation amd origin from the sequence if present.

    Utilities/itkExtHdrs/CMakeLists.txt
        ENH: Using cmake try_compile instead of hardcoded compiler switches to make itkUnicodeIOTest cleaner (and hopefully more scalable)

    Utilities/itkExtHdrs/fdstream.hpp
        ENH: Moved unicode io helpers from itkUnicodeIOTest to a new itkInternationalizationIOHelpers header + moved fdstream code into itk namespace to avoid any potential clashes with a user copy of the fdstream header
        COMP: Trying to fix vs9+win64 compilation warnings
        ENH: Adding a small test to try and move forward on unicode filenames, see bug 9623

    Utilities/itkjpeg/jcdiffct
        COMP: Fixing warning messages about local variables shadowing others.

    Utilities/itkjpeg/jcmarker
        COMP: Fixing warning messages about local variables shadowing others.

    Utilities/itkjpeg/jdmarker
        COMP: Fixing warning messages about local variables shadowing others.

    Utilities/itkpng/CMakeLists.txt
        BUG: 9757. Flattening directory structure of the installation tree.

    Utilities/itktiff/CMakeLists.txt
        BUG: 9757. Flattening directory structure of the installation tree.

    Utilities/itktiff/tif_luv

    Utilities/itktiff/tif_unix

    Utilities/itktiff/tiff
        BUG: uint32 was not defined properly with Sun Studio on amd64 architecture.

    Utilities/itkzlib/CMakeLists.txt
        BUG: 9757. Flattening directory structure of the installation tree.

    Utilities/itkzlib/deflate
        ENH: apply Dave C.'s patch to initialize memory allocations in zlib to prevent valgrind warnings.

    Utilities/kwsys/Base64

    Utilities/kwsys/Base64.h.in

    Utilities/kwsys/CMakeLists.txt

    Utilities/kwsys/CPU.h.in

    Utilities/kwsys/CTestConfig.cmake

    Utilities/kwsys/CommandLineArguments

    Utilities/kwsys/CommandLineArguments.hxx.in

    Utilities/kwsys/Configure.h.in
        COMP: Added missing case for the export macro, thanks to Kenneth Moreland.

    Utilities/kwsys/Configure.hxx.in
        Can not use cmakedefine in kwsys because bootstrap of cmake does not support it.

    Utilities/kwsys/Copyright.txt

    Utilities/kwsys/DateStamp.h.in

    Utilities/kwsys/Directory

    Utilities/kwsys/Directory.hxx.in

    Utilities/kwsys/DynamicLoader
        ENH: Adding symbol for cray compute linux to DynamicLoader.cxx

    Utilities/kwsys/DynamicLoader.hxx.in

    Utilities/kwsys/EncodeExecutable

    Utilities/kwsys/FundamentalType.h.in

    Utilities/kwsys/Glob

    Utilities/kwsys/Glob.hxx.in

    Utilities/kwsys/IOStream

    Utilities/kwsys/IOStream.hxx.in

    Utilities/kwsys/MD5

    Utilities/kwsys/MD5.h.in

    Utilities/kwsys/Process.h.in

    Utilities/kwsys/ProcessFwd9x

    Utilities/kwsys/ProcessUNIX

    Utilities/kwsys/ProcessWin32

    Utilities/kwsys/Registry

    Utilities/kwsys/Registry.hxx.in

    Utilities/kwsys/RegularExpression

    Utilities/kwsys/RegularExpression.hxx.in

    Utilities/kwsys/SharedForward.h.in

    Utilities/kwsys/String

    Utilities/kwsys/String.h.in

    Utilities/kwsys/String.hxx.in
        COMP: remove exporting String as VS10 attempts to export its parents (basic_string) which causes all kinds of multiply defined symbols at link time.

    Utilities/kwsys/System

    Utilities/kwsys/System.h.in

    Utilities/kwsys/SystemInformation
        BUG: Commit a fix from Rusty to address incorrectly reported memory queries.
        Fix bogus calls to GetMemoryStatus and GetMemoryStatusEx: need to set the dwLength member of the struct prior to calling. Otherwise it's just a garbage value from the stack. Also, pay attention to return value of GetMemoryStatusEx: if it indicates failure then just return 0 without using any of the other data the call returns.
        Added OS Platform (cpu architecture) detection support to windows systems
        Fix bus error on mac.  Was a result of not having null termination of arg list to sw_vers calls.

    Utilities/kwsys/SystemInformation.hxx.in
        Try to fix missing size_t on qnx

    Utilities/kwsys/SystemTools
    msys/mingw installation on a Linux box. Thanks to Clinton Stimpson for preparing the patch.
        Better fix for crash on Windows. This time it will even work on Linux, too. That GetLineFromStream method while loop sure is fussy.
        Put a flag in that will stop system tools from deleting system environment memory on exit, as it can cause gcov to crash the programs.

    Utilities/kwsys/SystemTools.hxx.in

    Utilities/kwsys/Terminal

    Utilities/kwsys/Terminal.h.in

    Utilities/kwsys/auto_ptr.hxx.in

    Utilities/kwsys/hash_fun.hxx.in

    Utilities/kwsys/hash_map.hxx.in

    Utilities/kwsys/hash_set.hxx.in

    Utilities/kwsys/hashtable.hxx.in

    Utilities/kwsys/kwsysDateStamp.cmake
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp

    Utilities/kwsys/kwsysDateStamp.py

    Utilities/kwsys/kwsysHeaderDump.pl

    Utilities/kwsys/kwsysPlatformTests.cmake

    Utilities/kwsys/kwsysPlatformTestsC

    Utilities/kwsys/kwsysPlatformTestsCXX

    Utilities/kwsys/kwsysPrivate

    Utilities/kwsys/kwsys_cstddef.hxx.in

    Utilities/kwsys/kwsys_ios_fstream.h.in

    Utilities/kwsys/kwsys_ios_iosfwd.h.in

    Utilities/kwsys/kwsys_ios_iostream.h.in

    Utilities/kwsys/kwsys_ios_sstream.h.in

    Utilities/kwsys/kwsys_stl.hxx.in

    Utilities/kwsys/kwsys_stl_string.hxx.in

    Utilities/kwsys/testAutoPtr

    Utilities/kwsys/testCommandLineArguments

    Utilities/kwsys/testCommandLineArguments1

    Utilities/kwsys/testDynamicLoader

    Utilities/kwsys/testDynload

    Utilities/kwsys/testEncode

    Utilities/kwsys/testFail

    Utilities/kwsys/testHashSTL

    Utilities/kwsys/testIOS

    Utilities/kwsys/testProcess
        Fix warnings in CMake source code. Suppress warnings in Lexer and Parser files that are 'too hard' to fix.

    Utilities/kwsys/testRegistry

    Utilities/kwsys/testSharedForward.c.in

    Utilities/kwsys/testSystemInformation

    Utilities/kwsys/testSystemTools

    Utilities/kwsys/testSystemTools.h.in

    Utilities/kwsys/testTerminal

    Utilities/nifti/CMakeLists.txt
        BUG: 9757. Flattening directory structure of the installation tree.

    Utilities/nifti/niftilib/nifti1_io
        COMP: warning: subscript has type char.
        COMP: Fixing conversion warnings about potential truncation of 64bits types in to 32bits types.

    Utilities/openjpeg/event
        COMP: warning: subscript has type char.

    Utilities/vxl/core/vnl/vnl_ma
    insight-users/2009-November/033770.html

    Utilities/vxl/core/vnl/vnl_matrix
        COMP: Fixing warnings about unused variables.

    Utilities/vxl/core/vnl/vnl_matrix_fixed
        COMP: Fixing warnings about unused variables.

    Utilities/vxl/core/vnl/vnl_matrix_fixed_ref
        COMP: Fixing warnings about unused variables.

    Utilities/vxl/core/vnl/algo/CMakeLists.txt

    Utilities/vxl/core/vnl/algo/vnl_lsqr

    Utilities/vxl/core/vnl/algo/vnl_lsqr

    Utilities/vxl/core/vnl/algo/Attic/vnl_rpoly_roots

    Utilities/vxl/core/vnl/algo/tests/CMakeLists.txt

    Utilities/vxl/core/vnl/algo/tests/test_driver

    Utilities/vxl/core/vnl/algo/tests/test_include

    Utilities/vxl/core/vnl/algo/tests/Attic/test_rpoly_roots

    Utilities/vxl/v3p/netlib/CMakeLists.txt

    Utilities/vxl/v3p/netlib/v3p_netlib_prototypes

    Utilities/vxl/v3p/netlib/blas/caxpy

    Utilities/vxl/v3p/netlib/libf2c/c_div

    Utilities/vxl/v3p/netlib/libf2c/c_sqrt

    Utilities/vxl/v3p/netlib/libf2c/cabs
        COMP: Fixing warning messages about local variables shadowing others.

    Utilities/vxl/v3p/netlib/linalg/CMakeLists.txt

    Utilities/vxl/v3p/netlib/linalg/Attic/lsqr.P

    Utilities/vxl/v3p/netlib/linalg/Attic/lsqr

    Utilities/vxl/v3p/netlib/linalg/Attic/lsqr.f

    Utilities/vxl/v3p/netlib/linalg/Attic/lsqr

    Utilities/vxl/v3p/netlib/linalg/lsqrBase

    Utilities/vxl/v3p/netlib/linalg/lsqrBase

    Utilities/vxl/v3p/netlib/tests/CMakeLists.txt

    Wrapping/CSwig/CMakeLists.txt
        COMP: When using system VXL, need to add special include path

    Wrapping/WrapITK/Modules/SegmentationAndThreshold/wrap_itkBayesianClassifierImageFilter.cmake
        ENH: Reuse the previous types and make sure to use the right pixel type for the priors.
