/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 *          
 * Released under the GPL v2. */

/* Container for SSL state information. */
class SSLState
{
#ifdef HAVE_SSL
	public:
		SSLState(void);
		bool init(class Options &options, bool debugmode);
		void free(void);
		bool imserversocktossl(class Socket &imserversock);
		bool clientsocktossl(class Socket &clientsock);
		
	private:
		bool sslcertclient(std::string commandline, bool selfsigned);
		bool loadcert(SSL_CTX *ctx, std::string domain, std::string certfilename);

		bool sslcertserver(std::string sslcertdir);
		bool signcert(std::string commonname, bool selfsigned);
		
		std::string formatcertfilename(std::string commonname);
		
		std::string sslcertdir;
		std::string sslverifydir;
		int sslverify;
		
		bool localdebugmode;
		SSL_METHOD *method;
		SSL_CTX *connectctx;
		SSL_CTX *ctx;

		X509 *cacert;
		EVP_PKEY *cakey;
		EVP_PKEY *serverkey;
		
#endif
};
