/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 *          
 * Released under the GPL v2. */

#include "imspector.h"

#define PLUGIN_NAME "HTTPS IMSpector protocol plugin"
#define PROTOCOL_NAME "HTTPS"
#define PROTOCOL_PORT 443

extern "C"
{
	bool initprotocolplugin(struct protocolplugininfo &pprotocolplugininfo,
		class Options &options, bool debugmode);
	void closeprotocolplugin(void);
	int processpacket(bool outgoing, class Socket &incomingsock, char *replybuffer,
		int *replybufferlength, std::vector<struct imevent> &imevents, std::string &clientaddress);
};

int packetcount = 0;
bool tracing = false;
bool localdebugmode = false;

bool initprotocolplugin(struct protocolplugininfo &protocolplugininfo,
	class Options &options, bool debugmode)
{
	if (options["https_protocol"] != "on") return false;

	localdebugmode = debugmode;
	
	protocolplugininfo.pluginname = PLUGIN_NAME;
	protocolplugininfo.protocolname = PROTOCOL_NAME;
	protocolplugininfo.port = htons(PROTOCOL_PORT);

	if (options["https_trace"] == "on") tracing = true;
	
	return true;
}

void closeprotocolplugin(void)
{
	return;
}

/* The main plugin function. See protocolplugin.cpp. */
int processpacket(bool outgoing, class Socket &incomingsock, char *replybuffer, 
	int *replybufferlength, std::vector<struct imevent> &imevents, std::string &clientaddress)
{
	int len;

	if ((len = incomingsock.recvdata(replybuffer, BUFFER_SIZE)) < 1) 
		return 1;

	debugprint(localdebugmode, PROTOCOL_NAME ": Got: %d", len);
	
	*replybufferlength = len;

	/* Write out trace packets if enabled. */
	if (tracing) tracepacket("https", packetcount, replybuffer, *replybufferlength);
	
	packetcount++;
	
	return 0;
}
