/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2005 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02111-1301, USA.
 */
#include <glib.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
# include "../gf_config.h"
#endif

#include "gf_internal.h"
#include "gf_utils.h"

gint
gf_utils_strcmp(const gchar *s1, const gchar *s2) {
	gchar *s1k = NULL, *s2k = NULL;
	gint ret = 0;

	if(!s1 && !s2)
		return 0;

	if(!s1)
		return -1;

	if(!s2)
		return 1;

	s1k = g_utf8_collate_key(s1, -1);
	s2k = g_utf8_collate_key(s2, -1);

	ret = strcmp(s1k, s2k);

	g_free(s1k);
	g_free(s2k);

	return ret;
}

gint
gf_utils_compare_strings(gconstpointer a, gconstpointer b) {
	return gf_utils_strcmp(a, b);
}
