/*
 *     gtkatlantic - the gtk+ monopd client, enjoy network monopoly games
 *
 *
 *  Copyright (C) 2002-2010 Rochet Sylvain
 *
 *  gtkatlantic is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <gtk/gtk.h>

#include "global.h"
#include "trade.h"
#include "game.h"
#include "client.h"
#include "interface.h"
#include "callback.h"


void trade_initnew(gint32 tradeid)  {

	gint32 tradeslot;
	gchar *sendstr;

	/* already created */
	if(get_trade_slot_with_tradeid(tradeid) >= 0)  return;

	if(! game_get_valid_trade_slot(&tradeslot) )  {

		/* no trade slot valid -> reject trade */
		sendstr = g_strdup_printf(".Tr%d\n", tradeid);
		client_send(game->connectid, sendstr, strlen(sendstr));
		g_free(sendstr);
		return;
	}

	game->trade[tradeslot].open = TRUE;
	game->trade[tradeslot].tradeid = tradeid;

	trade_create_panel(tradeslot);
}


void trade_destroy(gint32 tradeid)  {

	gint32 tradeslot;

	tradeslot = get_trade_slot_with_tradeid(tradeid);
	if(tradeslot < 0) return;

	trade_destroy_slot(tradeslot);
}


void trade_destroy_slot(gint32 tradeslot)  {

	if(!game->trade[tradeslot].open) return;

	gtk_widget_destroy(game->trade[tradeslot].TradeWin);
	memset(&game->trade[tradeslot], 0, sizeof(_trade) );
}


void trade_create_panel(gint32 tradeslot)  {

	GtkWidget *TradeWin;
		GtkWidget *VBox;
			//components
		GtkWidget *HBox;
			GtkWidget *ScrollWinPlayer;
				GtkWidget *PlayerCList;
			GtkWidget *VboxProposalButtons;
				GtkWidget *ScrollWinProposal;
					GtkWidget *ProposalCList;
				GtkWidget *HBox_buttons;

	GtkWidget *Button;
	gchar *text;

	TradeWin = game->trade[tradeslot].TradeWin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(TradeWin, 500, 220);
	gtk_window_set_title(GTK_WINDOW(TradeWin), "GtkAtlantic: Trade");
	gtk_window_set_policy(GTK_WINDOW(TradeWin), TRUE, TRUE, TRUE);
	gtk_widget_realize(TradeWin);
	gdk_window_set_icon(TradeWin->window, NULL, global->icon_pixmap, global->icon_mask);
	gtk_object_set_data(GTK_OBJECT(TradeWin), "command", "reject");
	text = g_strdup_printf("%d", game->trade[tradeslot].tradeid);
	gtk_object_set_data_full(GTK_OBJECT(TradeWin), "tradeid", text, g_free);
	gtk_signal_connect(GTK_OBJECT(TradeWin), "delete_event", (GtkSignalFunc)CallBack_trade_button, NULL);

	/* component / hbox / buttons */
	VBox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(TradeWin), VBox);

	/* component */
	game->trade[tradeslot].FrameComponent = gtk_frame_new("Add Component");
	gtk_container_set_border_width(GTK_CONTAINER(game->trade[tradeslot].FrameComponent), BORDER);
	gtk_box_pack_start(GTK_BOX(VBox), game->trade[tradeslot].FrameComponent, FALSE, FALSE, 0);

	trade_rebuild_component(tradeslot);
	trade_rebuild_subcomponent(tradeslot);

	/* player / current proposal */
	HBox = gtk_hbox_new(FALSE, BORDER);
	gtk_container_set_border_width(GTK_CONTAINER(HBox), BORDER);
	gtk_box_pack_start(GTK_BOX(VBox), HBox, TRUE, TRUE, 0);

	/* player list */
	ScrollWinPlayer = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_usize(ScrollWinPlayer, 100, 0);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrollWinPlayer), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(HBox), ScrollWinPlayer, FALSE, FALSE, 0);

	PlayerCList = game->trade[tradeslot].PlayerCList = gtk_clist_new(2);
	gtk_clist_set_column_auto_resize(GTK_CLIST(PlayerCList), 0, TRUE);
	gtk_clist_column_titles_passive(GTK_CLIST(PlayerCList));
	gtk_clist_set_reorderable(GTK_CLIST(PlayerCList), FALSE);
	gtk_clist_set_selection_mode(GTK_CLIST(PlayerCList), GTK_SELECTION_SINGLE);
	gtk_clist_set_column_visibility(GTK_CLIST(PlayerCList), 1, FALSE);
	gtk_container_add(GTK_CONTAINER(ScrollWinPlayer), PlayerCList);

	trade_rebuild_playerlist(tradeslot);
	trade_rebuild_subcomponent(tradeslot);


	/* vbox for proposal & buttons */
	VboxProposalButtons = gtk_vbox_new(FALSE, BORDER);
	gtk_box_pack_start(GTK_BOX(HBox), VboxProposalButtons, TRUE, TRUE, 0);

	/* current proposal */
	ScrollWinProposal = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrollWinProposal), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(VboxProposalButtons), ScrollWinProposal, TRUE, TRUE, 0);

	ProposalCList = game->trade[tradeslot].ProposalCList = gtk_clist_new(10);
	gtk_clist_set_column_auto_resize(GTK_CLIST(ProposalCList), 0, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(ProposalCList), 1, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(ProposalCList), 2, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(ProposalCList), 3, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(ProposalCList), 4, TRUE);
	gtk_clist_set_column_visibility(GTK_CLIST(ProposalCList), 5, FALSE);
	gtk_clist_set_column_visibility(GTK_CLIST(ProposalCList), 6, FALSE);
	gtk_clist_set_column_visibility(GTK_CLIST(ProposalCList), 7, FALSE);
	gtk_clist_set_column_visibility(GTK_CLIST(ProposalCList), 8, FALSE);
	gtk_clist_set_column_visibility(GTK_CLIST(ProposalCList), 9, FALSE);
	gtk_clist_column_titles_passive(GTK_CLIST(ProposalCList));
	gtk_clist_set_reorderable(GTK_CLIST(ProposalCList), TRUE);
	gtk_clist_set_selection_mode(GTK_CLIST(ProposalCList), GTK_SELECTION_SINGLE);
	gtk_container_add(GTK_CONTAINER(ScrollWinProposal), ProposalCList);

	gtk_signal_connect(GTK_OBJECT(ProposalCList), "unselect_row", (GtkSignalFunc)Callback_ProposalList_Unselect, NULL);
	gtk_signal_connect_after(GTK_OBJECT(ProposalCList), "select_row", (GtkSignalFunc)Callback_ProposalList_Select, NULL);

 	/* buttons */
	HBox_buttons = gtk_hbox_new(FALSE, 10);
	gtk_box_pack_end(GTK_BOX(VboxProposalButtons), HBox_buttons, FALSE, FALSE, 0);

	/* remove button */
	Button = gtk_button_new_with_label("Remove");
	gtk_widget_set_usize(Button, 100, 0);
	gtk_object_set_data(GTK_OBJECT(Button), "command", "remove");
	text = g_strdup_printf("%d", game->trade[tradeslot].tradeid);
	gtk_object_set_data_full(GTK_OBJECT(Button), "tradeid", text, g_free);
	gtk_signal_connect(GTK_OBJECT(Button), "clicked", (GtkSignalFunc)CallBack_trade_button, NULL);
	gtk_box_pack_start(GTK_BOX(HBox_buttons), Button, FALSE, FALSE, 0);

	/* accept button */
	Button = gtk_button_new_with_label("Accept");
	gtk_widget_set_usize(Button, 100, 0);
	gtk_object_set_data(GTK_OBJECT(Button), "command", "accept");
	text = g_strdup_printf("%d", game->trade[tradeslot].tradeid);
	gtk_object_set_data_full(GTK_OBJECT(Button), "tradeid", text, g_free);
	gtk_signal_connect(GTK_OBJECT(Button), "clicked", (GtkSignalFunc)CallBack_trade_button, NULL);
	gtk_box_pack_end(GTK_BOX(HBox_buttons), Button, FALSE, FALSE, 0);

	/* reject button */
	Button = gtk_button_new_with_label("Reject");
	gtk_widget_set_usize(Button, 100, 0);
	gtk_object_set_data(GTK_OBJECT(Button), "command", "reject");
	text = g_strdup_printf("%d", game->trade[tradeslot].tradeid);
	gtk_object_set_data_full(GTK_OBJECT(Button), "tradeid", text, g_free);
	gtk_signal_connect(GTK_OBJECT(Button), "clicked", (GtkSignalFunc)CallBack_trade_button, NULL);
	gtk_box_pack_end(GTK_BOX(HBox_buttons), Button, FALSE, FALSE, 0);

	gtk_widget_show_all(TradeWin);
}


void trade_rebuild_playerlist(gint32 tradeslot)  {

	GtkWidget *PlayerCList;
	gchar *txt[10];
	gint32 row, i;
	GdkColor gdk_color_red;
	GdkColor gdk_color_green;

	if(!game->trade[tradeslot].open)  return;

	gdk_color_red.red   = 0xffff;
	gdk_color_red.green = 0x0000;
	gdk_color_red.blue  = 0x0000;

	gdk_color_green.red   = 0x0000;
	gdk_color_green.green = 0xffff;
	gdk_color_green.blue  = 0x0000;

	PlayerCList = game->trade[tradeslot].PlayerCList;
	if(!PlayerCList) return;

	gtk_clist_freeze(GTK_CLIST(PlayerCList));
	gtk_clist_clear(GTK_CLIST(PlayerCList));

	for(i = 0 ; i < MAX_PLAYERS ; i++)  {

		if(! global->player[i].playerid) continue;
		if(global->player[i].game != game->gameid)  continue;
		if(! game->trade[tradeslot].player[i][TRADE_PLAYER_PARTICIPATE]) continue;

		txt[0] = global->player[i].name;
		txt[1] = g_strdup_printf("%d", global->player[i].playerid);
		row = gtk_clist_append(GTK_CLIST(PlayerCList), txt);
		g_free(txt[1]);

		gtk_clist_set_selectable(GTK_CLIST(PlayerCList), row ,FALSE);
		if(game->trade[tradeslot].player[i][TRADE_PLAYER_ACCEPT])
			gtk_clist_set_background(GTK_CLIST(PlayerCList), row, &gdk_color_green);
		else
			gtk_clist_set_background(GTK_CLIST(PlayerCList), row, &gdk_color_red);
	}

	gtk_clist_thaw(GTK_CLIST(PlayerCList));
}


void trade_rebuild_component(gint32 tradeslot)  {

	GtkWidget *box;
		GtkWidget *OptionMenu;
			GtkWidget *Menu;
			GtkWidget *MenuItem;

	guint32 i;
	gchar *text;

	game->trade[tradeslot].current_component = 0;

	if(game->trade[tradeslot].ComponentBox)  {
		gtk_widget_destroy(game->trade[tradeslot].ComponentBox);
		game->trade[tradeslot].ComponentBox = 0;
		game->trade[tradeslot].SubComponentBox = 0;
	}

	box = game->trade[tradeslot].ComponentBox = gtk_hbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(box), 5);
	gtk_container_add(GTK_CONTAINER(game->trade[tradeslot].FrameComponent), game->trade[tradeslot].ComponentBox);

	/* Choice component: Estate/Money/Card  */
	Menu = gtk_menu_new();

	MenuItem = gtk_menu_item_new_with_label("Money");
	text = g_strdup_printf("%d", game->trade[tradeslot].tradeid);
	gtk_object_set_data_full(GTK_OBJECT(MenuItem), "tradeid", text, g_free);
	gtk_object_set_data(GTK_OBJECT(MenuItem), "component", "money");
	gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)CallBack_trade_sub_component, NULL);
	gtk_menu_append(GTK_MENU(Menu), MenuItem);
	gtk_widget_show(MenuItem);

	for(i = 0 ; i < data->number_estates ; i++)  {

		if(game->estate[i].owner <= 0)  continue;

		MenuItem = gtk_menu_item_new_with_label("Estate");
		text = g_strdup_printf("%d", game->trade[tradeslot].tradeid);
		gtk_object_set_data_full(GTK_OBJECT(MenuItem), "tradeid", text, g_free);
		gtk_object_set_data(GTK_OBJECT(MenuItem), "component", "estate");
		gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)CallBack_trade_sub_component, NULL);
		gtk_menu_append(GTK_MENU(Menu), MenuItem);
		gtk_widget_show(MenuItem);
		break;
	}

	for(i = 0 ; i < MAX_CARDS ; i++)  {

		if(!game->card[i].owner)  continue;

		MenuItem = gtk_menu_item_new_with_label("Card");
		text = g_strdup_printf("%d", game->trade[tradeslot].tradeid);
		gtk_object_set_data_full(GTK_OBJECT(MenuItem), "tradeid", text, g_free);
		gtk_object_set_data(GTK_OBJECT(MenuItem), "component", "card");
		gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)CallBack_trade_sub_component, NULL);
		gtk_menu_append(GTK_MENU(Menu), MenuItem);
		gtk_widget_show(MenuItem);
		break;
	}

	OptionMenu = gtk_option_menu_new();
	gtk_option_menu_set_menu(GTK_OPTION_MENU(OptionMenu), Menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU(OptionMenu), 0);
	gtk_box_pack_start(GTK_BOX(box), OptionMenu, FALSE, FALSE, 0);

	gtk_widget_show_all(game->trade[tradeslot].ComponentBox);
}


void trade_rebuild_subcomponent(gint32 tradeslot)  {

	GtkWidget *box;
		GtkWidget *Label;
		GtkWidget *Entry;
		GtkWidget *Combo;
		GtkWidget *Alignment;
			GtkWidget *Button;
	gchar *text;
	guint32 i;
	GList *list;
	gpointer item;

	if(!game->trade[tradeslot].ComponentBox) return;

	if(game->trade[tradeslot].SubComponentBox)  {
		gtk_widget_destroy(game->trade[tradeslot].SubComponentBox);
		game->trade[tradeslot].SubComponentBox = 0;
	}

	box = game->trade[tradeslot].SubComponentBox = gtk_hbox_new(FALSE, BORDER);
	gtk_box_pack_start(GTK_BOX(game->trade[tradeslot].ComponentBox), box, TRUE, TRUE, 0);

	switch(game->trade[tradeslot].current_component)  {

		case TRADE_CURRENT_COMPONENT_ESTATE:

			/* update button */
			Alignment = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
			gtk_box_pack_end(GTK_BOX(box), Alignment, FALSE, TRUE, 0);

			Button = gtk_button_new_with_label("Update");
			text = g_strdup_printf("%d", game->trade[tradeslot].tradeid);
			gtk_object_set_data_full(GTK_OBJECT(Button), "tradeid", text, g_free);
			gtk_widget_set_usize(Button, 60, 0);

			gtk_signal_connect(GTK_OBJECT(Button), "clicked", (GtkSignalFunc)CallBack_trade_update_component, NULL);
			gtk_container_add(GTK_CONTAINER(Alignment), Button);

			/* valid estates */
			Combo = gtk_combo_box_entry_new_text();
			gtk_editable_set_editable(GTK_EDITABLE(GTK_BIN(Combo)->child), FALSE);
			gtk_object_set_data(GTK_OBJECT(Button), "name_estate", GTK_BIN(Combo)->child);

			gtk_box_pack_start(GTK_BOX(box), Combo, TRUE, TRUE, 0);

			for(i = 0 ; i < data->number_estates ; i++)  {

				if(game->estate[i].owner <= 0)  continue;
				gtk_combo_box_append_text(GTK_COMBO_BOX(Combo), game->estate[i].name);
			}

			gtk_combo_box_set_active(GTK_COMBO_BOX(Combo), 0);

			/* target label */
			Label = gtk_label_new("Target");
			gtk_box_pack_start(GTK_BOX(box), Label, FALSE, FALSE, 0);

			/* valid target players */
			Combo = gtk_combo_box_entry_new_text();
			gtk_editable_set_editable(GTK_EDITABLE(GTK_BIN(Combo)->child), FALSE);
			gtk_object_set_data(GTK_OBJECT(Button), "name_target_player", GTK_BIN(Combo)->child);

			gtk_widget_set_usize(Combo, 120, 0);
			gtk_box_pack_start(GTK_BOX(box), Combo, FALSE, FALSE, 0);

			for(i = 0 ; i < MAX_PLAYERS ; i++)  {

				if(!global->player[i].playerid)  continue;
				if(global->player[i].game != game->gameid)  continue;
				gtk_combo_box_append_text(GTK_COMBO_BOX(Combo), global->player[i].name);
			}

			gtk_combo_box_set_active(GTK_COMBO_BOX(Combo), 0);

			break;


		case TRADE_CURRENT_COMPONENT_MONEY:

			/* update button */
			Alignment = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
			gtk_box_pack_end(GTK_BOX(box), Alignment, FALSE, TRUE, 0);

			Button = gtk_button_new_with_label("Update");
			text = g_strdup_printf("%d", game->trade[tradeslot].tradeid);
			gtk_object_set_data_full(GTK_OBJECT(Button), "tradeid", text, g_free);
			gtk_widget_set_usize(Button, 60, 0);
			gtk_signal_connect(GTK_OBJECT(Button), "clicked", (GtkSignalFunc)CallBack_trade_update_component, NULL);
			gtk_container_add(GTK_CONTAINER(Alignment), Button);

			/* amount of money */
			Entry = gtk_entry_new();
			gtk_widget_set_usize(Entry, 50, 0);
			gtk_object_set_data(GTK_OBJECT(Button), "amount_money", Entry);
			gtk_box_pack_start(GTK_BOX(box), Entry, FALSE, FALSE, 0);

			/* from label */
			Label = gtk_label_new("From");
			gtk_box_pack_start(GTK_BOX(box), Label, FALSE, FALSE, 0);

			/* valid from players */
			Combo = gtk_combo_box_entry_new_text();
			gtk_editable_set_editable(GTK_EDITABLE(GTK_BIN(Combo)->child), FALSE);
			gtk_object_set_data(GTK_OBJECT(Button), "name_from_player", GTK_BIN(Combo)->child);

			gtk_box_pack_start(GTK_BOX(box), Combo, TRUE, TRUE, 0);

			for(i = 0 ; i < MAX_PLAYERS ; i++)  {

				if(!global->player[i].playerid)  continue;
				if(global->player[i].game != game->gameid)  continue;
				gtk_combo_box_append_text(GTK_COMBO_BOX(Combo), global->player[i].name);

			}

			gtk_combo_box_set_active(GTK_COMBO_BOX(Combo), 0);

			/* to label */
			Label = gtk_label_new("To");
			gtk_box_pack_start(GTK_BOX(box), Label, FALSE, FALSE, 0);

			/* valid to players */
			Combo = gtk_combo_box_entry_new_text();
			gtk_editable_set_editable(GTK_EDITABLE(GTK_BIN(Combo)->child), FALSE);
			gtk_object_set_data(GTK_OBJECT(Button), "name_to_player", GTK_BIN(Combo)->child);

			gtk_box_pack_start(GTK_BOX(box), Combo, TRUE, TRUE, 0);

			for(i = 0 ; i < MAX_PLAYERS ; i++)  {

				if(!global->player[i].playerid)  continue;
				if(global->player[i].game != game->gameid)  continue;
				gtk_combo_box_append_text(GTK_COMBO_BOX(Combo), global->player[i].name);
			}

			gtk_combo_box_set_active(GTK_COMBO_BOX(Combo), 0);

			break;


		case TRADE_CURRENT_COMPONENT_CARD:

			/* update button */
			Alignment = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
			gtk_box_pack_end(GTK_BOX(box), Alignment, FALSE, TRUE, 0);

			Button = gtk_button_new_with_label("Update");
			text = g_strdup_printf("%d", game->trade[tradeslot].tradeid);
			gtk_object_set_data_full(GTK_OBJECT(Button), "tradeid", text, g_free);
			gtk_widget_set_usize(Button, 60, 0);
			gtk_signal_connect(GTK_OBJECT(Button), "clicked", (GtkSignalFunc)CallBack_trade_update_component, NULL);
			gtk_container_add(GTK_CONTAINER(Alignment), Button);

			/* valid cards */
			Combo = gtk_combo_box_entry_new_text();
			gtk_editable_set_editable(GTK_EDITABLE(GTK_BIN(Combo)->child), FALSE);
			gtk_object_set_data(GTK_OBJECT(Button), "name_card", GTK_BIN(Combo)->child);

			gtk_box_pack_start(GTK_BOX(box), Combo, TRUE, TRUE, 0);
			list = NULL;
			for(i = 0 ; i < MAX_CARDS ; i++)  {

				if(!game->card[i].owner)  continue;
				text = g_strdup_printf("%d", game->card[i].cardid);
				list = g_list_append(list, text);
				gtk_combo_box_append_text(GTK_COMBO_BOX(Combo), text);

			}

			if(list)  {

				gtk_combo_box_set_active(GTK_COMBO_BOX(Combo), 0);

				for(i = 0 ;  ; i++)  {

					item = g_list_nth_data(list, i);
					if(!item) break;

					g_free(item);
				}
				g_list_free(list);
			}

			/* target label */
			Label = gtk_label_new("Target");
			gtk_box_pack_start(GTK_BOX(box), Label, FALSE, FALSE, 0);

			/* valid target players */
			Combo = gtk_combo_box_entry_new_text();
			gtk_editable_set_editable(GTK_EDITABLE(GTK_BIN(Combo)->child), FALSE);
			gtk_object_set_data(GTK_OBJECT(Button), "name_target_player", GTK_BIN(Combo)->child);
			gtk_widget_set_usize(Combo, 120, 0);

			gtk_box_pack_start(GTK_BOX(box), Combo, FALSE, FALSE, 0);

			for(i = 0 ; i < MAX_PLAYERS ; i++)  {

				if(!global->player[i].playerid)  continue;
				if(global->player[i].game != game->gameid)  continue;
				gtk_combo_box_append_text(GTK_COMBO_BOX(Combo), global->player[i].name);
			}

			gtk_combo_box_set_active(GTK_COMBO_BOX(Combo), 0);

			break;
	}

	gtk_widget_show_all(game->trade[tradeslot].SubComponentBox);
}


void trade_update_player(gint32 tradeid, gint32 playerid, gboolean accept)  {

	gint32 tradeslot, playerslot;

	tradeslot = get_trade_slot_with_tradeid(tradeid);
	playerslot = get_player_slot_with_playerid(playerid);
	if(tradeslot < 0) return;
	if(playerslot < 0) return;

	game->trade[tradeslot].player[playerslot][TRADE_PLAYER_PARTICIPATE] = TRUE;
	game->trade[tradeslot].player[playerslot][TRADE_PLAYER_ACCEPT] = accept;
	trade_rebuild_playerlist(tradeslot);
}


void trade_update_card(gint32 tradeid, gint32 cardid, gint32 targetplayer)  {

	gchar *txt[10], **text[2];
	gint32 tradeslot, test, i;
	GtkWidget *ProposalCList;
	gchar *cardname;

	tradeslot = get_trade_slot_with_tradeid(tradeid);
	ProposalCList = game->trade[tradeslot].ProposalCList;
	cardname = g_strdup_printf("card #%d", cardid);

	/* remove previous cardid */
	text[0] = g_malloc0(8192);
	text[1] = g_malloc0(8192);
	for(i = 0 ;   ; i++) {

		test = gtk_clist_get_text(GTK_CLIST(ProposalCList), i, 5, text[0]);
		if(!test) break;
		test = gtk_clist_get_text(GTK_CLIST(ProposalCList), i, 8, text[1]);
		if(!test) break;

		if(! strcmp("card", *text[0])  &&  atoi(*text[1]) == cardid)  {

			gtk_clist_remove(GTK_CLIST(ProposalCList), i);
			i--;
		}
	}
	g_free(text[0]);
	g_free(text[1]);

	if(targetplayer < 0)  {

		g_free(cardname);
		return;
	}

	txt[0] = g_strdup("CARD :");
	txt[1] = global->player[ get_player_slot_with_playerid( game->card[ get_card_slot_with_cardid(cardid)  ].owner ) ].name;
	txt[2] = g_strdup("gives");
	txt[3] = global->player[ get_player_slot_with_playerid(targetplayer) ].name;
	txt[4] = cardname;
	txt[5] = g_strdup("card");
	txt[6] = g_strdup_printf("%d", game->card[ get_card_slot_with_cardid(cardid)  ].owner);
	txt[7] = g_strdup_printf("%d", targetplayer);
	txt[8] = g_strdup_printf("%d", cardid);
	txt[9] = g_strdup_printf("%d", tradeslot);
	gtk_clist_append(GTK_CLIST(ProposalCList), txt);
	g_free(txt[0]);
	g_free(txt[2]);
	g_free(txt[5]);
	g_free(txt[6]);
	g_free(txt[7]);
	g_free(txt[8]);
	g_free(txt[9]);

	g_free(cardname);
}


void trade_update_estate(gint32 tradeid, gint32 estateid, gint32 targetplayer)  {

	gchar *txt[10], **text[2];
	gint32 tradeslot, test, i;
	GtkWidget *ProposalCList;
	gchar *estatename;

	tradeslot = get_trade_slot_with_tradeid(tradeid);
	ProposalCList = game->trade[tradeslot].ProposalCList;
	estatename = game->estate[estateid].name;

	/* remove previous estate */
	text[0] = g_malloc0(8192);
	text[1] = g_malloc0(8192);
	for(i = 0 ;   ; i++) {

		test = gtk_clist_get_text(GTK_CLIST(ProposalCList), i, 5, text[0]);
		if(!test) break;
		test = gtk_clist_get_text(GTK_CLIST(ProposalCList), i, 8, text[1]);
		if(!test) break;

		if(! strcmp("estate", *text[0])  &&  atoi(*text[1]) == estateid)  {

			gtk_clist_remove(GTK_CLIST(ProposalCList), i);
			i--;
		}
	}
	g_free(text[0]);
	g_free(text[1]);

	if(targetplayer < 0) return;

	txt[0] = g_strdup("ESTATE :");
	txt[1] = global->player[ get_player_slot_with_playerid( game->estate[estateid].owner) ].name;
	txt[2] = g_strdup("gives");
	txt[3] = global->player[ get_player_slot_with_playerid(targetplayer) ].name;
	txt[4] = estatename;
	txt[5] = g_strdup("estate");
	txt[6] = g_strdup_printf("%d", game->estate[estateid].owner);
	txt[7] = g_strdup_printf("%d", targetplayer);
	txt[8] = g_strdup_printf("%d", estateid);
	txt[9] = g_strdup_printf("%d", tradeslot);
	gtk_clist_append(GTK_CLIST(ProposalCList), txt);
	g_free(txt[0]);
	g_free(txt[2]);
	g_free(txt[5]);
	g_free(txt[6]);
	g_free(txt[7]);
	g_free(txt[8]);
	g_free(txt[9]);
}


void trade_update_money(gint32 tradeid, gint32 playerfrom, gint32 playerto, gint32 money)  {

	gchar *txt[10], **text[2];
	gint32 tradeslot, test, i;
	GtkWidget *ProposalCList;
	gchar *from, *to, *moneystr;

	moneystr = g_strdup_printf("%d money", money);

	tradeslot = get_trade_slot_with_tradeid(tradeid);
	ProposalCList = game->trade[tradeslot].ProposalCList;
	from = global->player[ get_player_slot_with_playerid(playerfrom) ].name;
	to = global->player[ get_player_slot_with_playerid(playerto) ].name;

	/* remove all money proposal if same playerfrom and same playerto */
	text[0] = g_malloc0(8192);
	text[1] = g_malloc0(8192);
	text[2] = g_malloc0(8192);
	for(i = 0 ;   ; i++) {

		test = gtk_clist_get_text(GTK_CLIST(ProposalCList), i, 5, text[0]);
		if(!test) break;
		test = gtk_clist_get_text(GTK_CLIST(ProposalCList), i, 6, text[1]);
		if(!test) break;
		test = gtk_clist_get_text(GTK_CLIST(ProposalCList), i, 7, text[2]);
		if(!test) break;

		if(! strcmp("money", *text[0])  &&  atoi(*text[1]) == playerfrom  &&  atoi(*text[2]) == playerto)  {

			gtk_clist_remove(GTK_CLIST(ProposalCList), i);
			i--;
		}
	}
	g_free(text[0]);
	g_free(text[1]);
	g_free(text[2]);

	if(!money)  return;

	txt[0] = g_strdup("MONEY :");
	txt[1] = from;
	txt[2] = g_strdup("gives");
	txt[3] = to;
	txt[4] = moneystr;
	txt[5] = g_strdup("money");
	txt[6] = g_strdup_printf("%d", playerfrom);
	txt[7] = g_strdup_printf("%d", playerto);
	txt[8] = g_strdup_printf("%d", money);
	txt[9] = g_strdup_printf("%d", tradeslot);
	gtk_clist_append(GTK_CLIST(ProposalCList), txt);
	g_free(txt[0]);
	g_free(txt[2]);
	g_free(txt[5]);
	g_free(txt[6]);
	g_free(txt[7]);
	g_free(txt[8]);
	g_free(txt[9]);

	g_free(moneystr);
}


