//**************************************************************************************************
//                                           Version.hpp                                           *
//                                          -------------                                          *
// Description : Version specifier for the GNU Spice GUI application.                              *
// Started     : 2003-08-15                                                                        *
// Last Update : Refer below                                                                       *
// Copyright   : (C) 2003 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef VERSION_HPP
#define VERSION_HPP

#define  APP_NAME       wxT("gSpiceUI")
#define  APP_VERSION    wxT("1.1.00")
#define  APP_DATE       wxT("2015-04-29")
#define  APP_COPYRIGHT  wxT("Copyright (C) MSWaters 2003")

#endif // VERSION_HPP

//**************************************************************************************************
// THINGS TO DO : (Refer also to the ToDo file)
//
// 2015-04-24 Allow .PARAM and other SPICE commands thro. to the simulation file.
// 2015-04-17 If GNU-Cap binary crashes (eg. it can't load library libgnucap.so) gSpiceUI crashes.
// 2015-04-17 GNU-Cap DC analysis results headers contain part of the results file name instead of
//            the column labels. This happens when gnucap crashes (eg. it can't load library
//            libgnucap.so).
// 2015-04-16 When signal source sync'ing is enable the level is lost when switching between panels.
// 2015-04-16 The signal source in the simulation file should specify DC and/or AC volts. Eg. for an
//            OP analysis DC volts are intended and for an AC analysis AC volts are intended.
// 2015-04-15 Executing a GNU-Cap FO analysis on demos/bjt-amp-ce-2.sch crashes gSpiceUI. The
//            broken-ness is in PrcGnuCap::bFmtResultsFO( ).
// 2015-02-09 Preference to use Degrees or Radian doesn't work for NG-Spice.
// 2015-02-20 All the schematics in sch/demos should work, many don't.
// 2015-02-12 Create a MOSFET demo. using the ARF446.
// 2015-02-10 Close all bug reports.
// 2010-04-15 Still need to check if the locale stuff works.
//**************************************************************************************************
// NG-Spice :
//
// 2010-03-31 NG-Spice seems to be broken for JFETs.
// 2009-10-06 NUMDGT should set the number digits to print when printing tables of data. Doesn't
//            work in batch mode.
// 2007-05-11 PRINT statement parser is broken. Eg. PRINT TRAN V(0,1) V(0,2) is interpreted as one
//            parameter -V(1)-V(2) instead of two; in  contrast PRINT TRAN V(1,0) V(2,0) is
//            interpreted correctly. In  addition eg. PRINT AC VDB(0,1) won't run at all.
//            Notes : The .PRINT statement parsing starts in the function fixem( char * )
//                    (src/frontend/dotcards.c) which calls gettoks( char * ) which calls
//                    gettok( char ** ) (src/misc/string.c). I think the bug is in gettok( char ** )
//                    or how it is used by gettoks( char * ).
//**************************************************************************************************
// GNU-Cap :
//
// 2010-03-22 GNU-Cap seems to be broken for JFETs.
// 2009-08-21 For GNU-Cap AC analysis where a NPN BJT is used, get an error message before each line
//            of the results (eg. "open circuit: internal node 2").
// 2005-04-21 At times the first result line from a DC analysis is clearly incorrect.
// 2005-04-20 In the AC analysis the following source line is not interpreted correctly :
//            "Vin 2 3 GENERATOR(1) AC 100.00m". The AC magnitude "100.00m" is not interpreted as
//            "0.1"; replace it with "0.1" and everything works OK.
// 2004-03-29 The PRINT command doesn't produce a label for the independent parameter ie.
//            temperature for OP, voltage for DC.
//**************************************************************************************************
// gnetlist :
//
// 2005-07-19 If a relative model file path specified in schematic file the path is regarded as
//            relative to the CWD not the schematic file path which would be more logical.
// 2005-04-12 When schematic file imported via command line "gnetlist.log" left in gspiceui bin
//            directory. When schematic file imported via GUI "gnetlist.log" left in schematic
//            directory.
//**************************************************************************************************
// Gaw :
//
//**************************************************************************************************
// Gwave :
//
// 2014-04-15 Gwave appears to be dead. Hasn't been updated since 2009.
// 2014-04-15 Can no longer compile the sources owing to Guile dependencies.
// 2004-03-29 GWave can't handle the banner that GNU-Cap includes in it's output.
//**************************************************************************************************
// wxWidgets Library Bugs :
//
// 2007-09-07  v2.8.5  Cannot set the font in the choice control in the PnlValue class when no file
//                     loaded at startup. It should inherit the font from it's parent; every other
//                     control does. This seems to be bug in wxWidgets v2.8.5 and v2.6.3.
// 2004-08-13  v2.4.2  In class wxFileDialog styles can only be set in the constructor. The method
//                     SetStyle( ) does nothing.
// 2003-11-17  v2.4.1  In class wxFileDialog wildcards can only be set in the constructor. The
//                     method SetWildcard( ) is not properly implemented. See constructor in
//                     src/generic/filedlgg.cpp and set method in include/wx/generic/filedlgg.h.
//**************************************************************************************************
