#ifndef _SEARCH_MONITOR_H
#define _SEARCH_MONITOR_H

#include "osl/search/searchMonitor.h"
#include "osl/state/numEffectState.h"
#include <vector>

class QLabel;
class QTextCodec;

class ViewerSearchMonitor : public osl::search::SearchMonitor
{
  QLabel *label;
  QTextCodec *codec;
  osl::state::NumEffectState root;
  osl::Move root_move;
  size_t node_count;
  double elapsed;
  int pv_value;
  std::vector<osl::Move> pv;
  std::vector<char> pv_threatmate;
public:
  ViewerSearchMonitor(QLabel *l, const osl::NumEffectState& state);
  void setState(const osl::NumEffectState &state) {
    root = state;
  }
  void showPV(int depth, size_t node_count, double elapsed, int value,
              osl::Move cur, const osl::Move *first, const osl::Move *last,
	      const bool *threatmate_first, const bool *threatmate_last);
  void rootMove(osl::Move cur)
  {
    root_move = cur;
    update();
  }
  void rootFirstMove(osl::Move cur)
  {
    root_move = cur;
    update();
  }
  void timeInfo(size_t node_count, double elapsed)
  {
    this->node_count = node_count;
    this->elapsed = elapsed;
    update();
  }		      
  void update();
};

#endif
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:

