// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dataproc/v1/jobs.proto

package dataproc

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf3 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The Log4j level for job execution. When running an
// [Apache Hive](http://hive.apache.org/) job, Cloud
// Dataproc configures the Hive client to an equivalent verbosity level.
type LoggingConfig_Level int32

const (
	// Level is unspecified. Use default level for log4j.
	LoggingConfig_LEVEL_UNSPECIFIED LoggingConfig_Level = 0
	// Use ALL level for log4j.
	LoggingConfig_ALL LoggingConfig_Level = 1
	// Use TRACE level for log4j.
	LoggingConfig_TRACE LoggingConfig_Level = 2
	// Use DEBUG level for log4j.
	LoggingConfig_DEBUG LoggingConfig_Level = 3
	// Use INFO level for log4j.
	LoggingConfig_INFO LoggingConfig_Level = 4
	// Use WARN level for log4j.
	LoggingConfig_WARN LoggingConfig_Level = 5
	// Use ERROR level for log4j.
	LoggingConfig_ERROR LoggingConfig_Level = 6
	// Use FATAL level for log4j.
	LoggingConfig_FATAL LoggingConfig_Level = 7
	// Turn off log4j.
	LoggingConfig_OFF LoggingConfig_Level = 8
)

var LoggingConfig_Level_name = map[int32]string{
	0: "LEVEL_UNSPECIFIED",
	1: "ALL",
	2: "TRACE",
	3: "DEBUG",
	4: "INFO",
	5: "WARN",
	6: "ERROR",
	7: "FATAL",
	8: "OFF",
}
var LoggingConfig_Level_value = map[string]int32{
	"LEVEL_UNSPECIFIED": 0,
	"ALL":               1,
	"TRACE":             2,
	"DEBUG":             3,
	"INFO":              4,
	"WARN":              5,
	"ERROR":             6,
	"FATAL":             7,
	"OFF":               8,
}

func (x LoggingConfig_Level) String() string {
	return proto.EnumName(LoggingConfig_Level_name, int32(x))
}
func (LoggingConfig_Level) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{0, 0} }

// The job state.
type JobStatus_State int32

const (
	// The job state is unknown.
	JobStatus_STATE_UNSPECIFIED JobStatus_State = 0
	// The job is pending; it has been submitted, but is not yet running.
	JobStatus_PENDING JobStatus_State = 1
	// Job has been received by the service and completed initial setup;
	// it will soon be submitted to the cluster.
	JobStatus_SETUP_DONE JobStatus_State = 8
	// The job is running on the cluster.
	JobStatus_RUNNING JobStatus_State = 2
	// A CancelJob request has been received, but is pending.
	JobStatus_CANCEL_PENDING JobStatus_State = 3
	// Transient in-flight resources have been canceled, and the request to
	// cancel the running job has been issued to the cluster.
	JobStatus_CANCEL_STARTED JobStatus_State = 7
	// The job cancellation was successful.
	JobStatus_CANCELLED JobStatus_State = 4
	// The job has completed successfully.
	JobStatus_DONE JobStatus_State = 5
	// The job has completed, but encountered an error.
	JobStatus_ERROR JobStatus_State = 6
)

var JobStatus_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "PENDING",
	8: "SETUP_DONE",
	2: "RUNNING",
	3: "CANCEL_PENDING",
	7: "CANCEL_STARTED",
	4: "CANCELLED",
	5: "DONE",
	6: "ERROR",
}
var JobStatus_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"PENDING":           1,
	"SETUP_DONE":        8,
	"RUNNING":           2,
	"CANCEL_PENDING":    3,
	"CANCEL_STARTED":    7,
	"CANCELLED":         4,
	"DONE":              5,
	"ERROR":             6,
}

func (x JobStatus_State) String() string {
	return proto.EnumName(JobStatus_State_name, int32(x))
}
func (JobStatus_State) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{9, 0} }

// A matcher that specifies categories of job states.
type ListJobsRequest_JobStateMatcher int32

const (
	// Match all jobs, regardless of state.
	ListJobsRequest_ALL ListJobsRequest_JobStateMatcher = 0
	// Only match jobs in non-terminal states: PENDING, RUNNING, or
	// CANCEL_PENDING.
	ListJobsRequest_ACTIVE ListJobsRequest_JobStateMatcher = 1
	// Only match jobs in terminal states: CANCELLED, DONE, or ERROR.
	ListJobsRequest_NON_ACTIVE ListJobsRequest_JobStateMatcher = 2
)

var ListJobsRequest_JobStateMatcher_name = map[int32]string{
	0: "ALL",
	1: "ACTIVE",
	2: "NON_ACTIVE",
}
var ListJobsRequest_JobStateMatcher_value = map[string]int32{
	"ALL":        0,
	"ACTIVE":     1,
	"NON_ACTIVE": 2,
}

func (x ListJobsRequest_JobStateMatcher) String() string {
	return proto.EnumName(ListJobsRequest_JobStateMatcher_name, int32(x))
}
func (ListJobsRequest_JobStateMatcher) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{14, 0}
}

// The runtime logging config of the job.
type LoggingConfig struct {
	// The per-package log levels for the driver. This may include
	// "root" package name to configure rootLogger.
	// Examples:
	//   'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
	DriverLogLevels map[string]LoggingConfig_Level `protobuf:"bytes,2,rep,name=driver_log_levels,json=driverLogLevels" json:"driver_log_levels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value,enum=google.cloud.dataproc.v1.LoggingConfig_Level"`
}

func (m *LoggingConfig) Reset()                    { *m = LoggingConfig{} }
func (m *LoggingConfig) String() string            { return proto.CompactTextString(m) }
func (*LoggingConfig) ProtoMessage()               {}
func (*LoggingConfig) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *LoggingConfig) GetDriverLogLevels() map[string]LoggingConfig_Level {
	if m != nil {
		return m.DriverLogLevels
	}
	return nil
}

// A Cloud Dataproc job for running
// [Apache Hadoop MapReduce](https://hadoop.apache.org/docs/current/hadoop-mapreduce-client/hadoop-mapreduce-client-core/MapReduceTutorial.html)
// jobs on [Apache Hadoop YARN](https://hadoop.apache.org/docs/r2.7.1/hadoop-yarn/hadoop-yarn-site/YARN.html).
type HadoopJob struct {
	// [Required] Indicates the location of the driver's main class. Specify
	// either the jar file that contains the main class or the main class name.
	// To specify both, add the jar file to `jar_file_uris`, and then specify
	// the main class name in this property.
	//
	// Types that are valid to be assigned to Driver:
	//	*HadoopJob_MainJarFileUri
	//	*HadoopJob_MainClass
	Driver isHadoopJob_Driver `protobuf_oneof:"driver"`
	// [Optional] The arguments to pass to the driver. Do not
	// include arguments, such as `-libjars` or `-Dfoo=bar`, that can be set as job
	// properties, since a collision may occur that causes an incorrect job
	// submission.
	Args []string `protobuf:"bytes,3,rep,name=args" json:"args,omitempty"`
	// [Optional] Jar file URIs to add to the CLASSPATHs of the
	// Hadoop driver and tasks.
	JarFileUris []string `protobuf:"bytes,4,rep,name=jar_file_uris,json=jarFileUris" json:"jar_file_uris,omitempty"`
	// [Optional] HCFS (Hadoop Compatible Filesystem) URIs of files to be copied
	// to the working directory of Hadoop drivers and distributed tasks. Useful
	// for naively parallel tasks.
	FileUris []string `protobuf:"bytes,5,rep,name=file_uris,json=fileUris" json:"file_uris,omitempty"`
	// [Optional] HCFS URIs of archives to be extracted in the working directory of
	// Hadoop drivers and tasks. Supported file types:
	// .jar, .tar, .tar.gz, .tgz, or .zip.
	ArchiveUris []string `protobuf:"bytes,6,rep,name=archive_uris,json=archiveUris" json:"archive_uris,omitempty"`
	// [Optional] A mapping of property names to values, used to configure Hadoop.
	// Properties that conflict with values set by the Cloud Dataproc API may be
	// overwritten. Can include properties set in /etc/hadoop/conf/*-site and
	// classes in user code.
	Properties map[string]string `protobuf:"bytes,7,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] The runtime log config for job execution.
	LoggingConfig *LoggingConfig `protobuf:"bytes,8,opt,name=logging_config,json=loggingConfig" json:"logging_config,omitempty"`
}

func (m *HadoopJob) Reset()                    { *m = HadoopJob{} }
func (m *HadoopJob) String() string            { return proto.CompactTextString(m) }
func (*HadoopJob) ProtoMessage()               {}
func (*HadoopJob) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

type isHadoopJob_Driver interface {
	isHadoopJob_Driver()
}

type HadoopJob_MainJarFileUri struct {
	MainJarFileUri string `protobuf:"bytes,1,opt,name=main_jar_file_uri,json=mainJarFileUri,oneof"`
}
type HadoopJob_MainClass struct {
	MainClass string `protobuf:"bytes,2,opt,name=main_class,json=mainClass,oneof"`
}

func (*HadoopJob_MainJarFileUri) isHadoopJob_Driver() {}
func (*HadoopJob_MainClass) isHadoopJob_Driver()      {}

func (m *HadoopJob) GetDriver() isHadoopJob_Driver {
	if m != nil {
		return m.Driver
	}
	return nil
}

func (m *HadoopJob) GetMainJarFileUri() string {
	if x, ok := m.GetDriver().(*HadoopJob_MainJarFileUri); ok {
		return x.MainJarFileUri
	}
	return ""
}

func (m *HadoopJob) GetMainClass() string {
	if x, ok := m.GetDriver().(*HadoopJob_MainClass); ok {
		return x.MainClass
	}
	return ""
}

func (m *HadoopJob) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *HadoopJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

func (m *HadoopJob) GetFileUris() []string {
	if m != nil {
		return m.FileUris
	}
	return nil
}

func (m *HadoopJob) GetArchiveUris() []string {
	if m != nil {
		return m.ArchiveUris
	}
	return nil
}

func (m *HadoopJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *HadoopJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HadoopJob) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HadoopJob_OneofMarshaler, _HadoopJob_OneofUnmarshaler, _HadoopJob_OneofSizer, []interface{}{
		(*HadoopJob_MainJarFileUri)(nil),
		(*HadoopJob_MainClass)(nil),
	}
}

func _HadoopJob_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HadoopJob)
	// driver
	switch x := m.Driver.(type) {
	case *HadoopJob_MainJarFileUri:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.MainJarFileUri)
	case *HadoopJob_MainClass:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.MainClass)
	case nil:
	default:
		return fmt.Errorf("HadoopJob.Driver has unexpected type %T", x)
	}
	return nil
}

func _HadoopJob_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HadoopJob)
	switch tag {
	case 1: // driver.main_jar_file_uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Driver = &HadoopJob_MainJarFileUri{x}
		return true, err
	case 2: // driver.main_class
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Driver = &HadoopJob_MainClass{x}
		return true, err
	default:
		return false, nil
	}
}

func _HadoopJob_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HadoopJob)
	// driver
	switch x := m.Driver.(type) {
	case *HadoopJob_MainJarFileUri:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.MainJarFileUri)))
		n += len(x.MainJarFileUri)
	case *HadoopJob_MainClass:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.MainClass)))
		n += len(x.MainClass)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Cloud Dataproc job for running [Apache Spark](http://spark.apache.org/)
// applications on YARN.
type SparkJob struct {
	// [Required] The specification of the main method to call to drive the job.
	// Specify either the jar file that contains the main class or the main class
	// name. To pass both a main jar and a main class in that jar, add the jar to
	// `CommonJob.jar_file_uris`, and then specify the main class name in `main_class`.
	//
	// Types that are valid to be assigned to Driver:
	//	*SparkJob_MainJarFileUri
	//	*SparkJob_MainClass
	Driver isSparkJob_Driver `protobuf_oneof:"driver"`
	// [Optional] The arguments to pass to the driver. Do not include arguments,
	// such as `--conf`, that can be set as job properties, since a collision may
	// occur that causes an incorrect job submission.
	Args []string `protobuf:"bytes,3,rep,name=args" json:"args,omitempty"`
	// [Optional] HCFS URIs of jar files to add to the CLASSPATHs of the
	// Spark driver and tasks.
	JarFileUris []string `protobuf:"bytes,4,rep,name=jar_file_uris,json=jarFileUris" json:"jar_file_uris,omitempty"`
	// [Optional] HCFS URIs of files to be copied to the working directory of
	// Spark drivers and distributed tasks. Useful for naively parallel tasks.
	FileUris []string `protobuf:"bytes,5,rep,name=file_uris,json=fileUris" json:"file_uris,omitempty"`
	// [Optional] HCFS URIs of archives to be extracted in the working directory
	// of Spark drivers and tasks. Supported file types:
	// .jar, .tar, .tar.gz, .tgz, and .zip.
	ArchiveUris []string `protobuf:"bytes,6,rep,name=archive_uris,json=archiveUris" json:"archive_uris,omitempty"`
	// [Optional] A mapping of property names to values, used to configure Spark.
	// Properties that conflict with values set by the Cloud Dataproc API may be
	// overwritten. Can include properties set in
	// /etc/spark/conf/spark-defaults.conf and classes in user code.
	Properties map[string]string `protobuf:"bytes,7,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] The runtime log config for job execution.
	LoggingConfig *LoggingConfig `protobuf:"bytes,8,opt,name=logging_config,json=loggingConfig" json:"logging_config,omitempty"`
}

func (m *SparkJob) Reset()                    { *m = SparkJob{} }
func (m *SparkJob) String() string            { return proto.CompactTextString(m) }
func (*SparkJob) ProtoMessage()               {}
func (*SparkJob) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

type isSparkJob_Driver interface {
	isSparkJob_Driver()
}

type SparkJob_MainJarFileUri struct {
	MainJarFileUri string `protobuf:"bytes,1,opt,name=main_jar_file_uri,json=mainJarFileUri,oneof"`
}
type SparkJob_MainClass struct {
	MainClass string `protobuf:"bytes,2,opt,name=main_class,json=mainClass,oneof"`
}

func (*SparkJob_MainJarFileUri) isSparkJob_Driver() {}
func (*SparkJob_MainClass) isSparkJob_Driver()      {}

func (m *SparkJob) GetDriver() isSparkJob_Driver {
	if m != nil {
		return m.Driver
	}
	return nil
}

func (m *SparkJob) GetMainJarFileUri() string {
	if x, ok := m.GetDriver().(*SparkJob_MainJarFileUri); ok {
		return x.MainJarFileUri
	}
	return ""
}

func (m *SparkJob) GetMainClass() string {
	if x, ok := m.GetDriver().(*SparkJob_MainClass); ok {
		return x.MainClass
	}
	return ""
}

func (m *SparkJob) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *SparkJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

func (m *SparkJob) GetFileUris() []string {
	if m != nil {
		return m.FileUris
	}
	return nil
}

func (m *SparkJob) GetArchiveUris() []string {
	if m != nil {
		return m.ArchiveUris
	}
	return nil
}

func (m *SparkJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *SparkJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SparkJob) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SparkJob_OneofMarshaler, _SparkJob_OneofUnmarshaler, _SparkJob_OneofSizer, []interface{}{
		(*SparkJob_MainJarFileUri)(nil),
		(*SparkJob_MainClass)(nil),
	}
}

func _SparkJob_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SparkJob)
	// driver
	switch x := m.Driver.(type) {
	case *SparkJob_MainJarFileUri:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.MainJarFileUri)
	case *SparkJob_MainClass:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.MainClass)
	case nil:
	default:
		return fmt.Errorf("SparkJob.Driver has unexpected type %T", x)
	}
	return nil
}

func _SparkJob_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SparkJob)
	switch tag {
	case 1: // driver.main_jar_file_uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Driver = &SparkJob_MainJarFileUri{x}
		return true, err
	case 2: // driver.main_class
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Driver = &SparkJob_MainClass{x}
		return true, err
	default:
		return false, nil
	}
}

func _SparkJob_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SparkJob)
	// driver
	switch x := m.Driver.(type) {
	case *SparkJob_MainJarFileUri:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.MainJarFileUri)))
		n += len(x.MainJarFileUri)
	case *SparkJob_MainClass:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.MainClass)))
		n += len(x.MainClass)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Cloud Dataproc job for running
// [Apache PySpark](https://spark.apache.org/docs/0.9.0/python-programming-guide.html)
// applications on YARN.
type PySparkJob struct {
	// [Required] The HCFS URI of the main Python file to use as the driver. Must
	// be a .py file.
	MainPythonFileUri string `protobuf:"bytes,1,opt,name=main_python_file_uri,json=mainPythonFileUri" json:"main_python_file_uri,omitempty"`
	// [Optional] The arguments to pass to the driver.  Do not include arguments,
	// such as `--conf`, that can be set as job properties, since a collision may
	// occur that causes an incorrect job submission.
	Args []string `protobuf:"bytes,2,rep,name=args" json:"args,omitempty"`
	// [Optional] HCFS file URIs of Python files to pass to the PySpark
	// framework. Supported file types: .py, .egg, and .zip.
	PythonFileUris []string `protobuf:"bytes,3,rep,name=python_file_uris,json=pythonFileUris" json:"python_file_uris,omitempty"`
	// [Optional] HCFS URIs of jar files to add to the CLASSPATHs of the
	// Python driver and tasks.
	JarFileUris []string `protobuf:"bytes,4,rep,name=jar_file_uris,json=jarFileUris" json:"jar_file_uris,omitempty"`
	// [Optional] HCFS URIs of files to be copied to the working directory of
	// Python drivers and distributed tasks. Useful for naively parallel tasks.
	FileUris []string `protobuf:"bytes,5,rep,name=file_uris,json=fileUris" json:"file_uris,omitempty"`
	// [Optional] HCFS URIs of archives to be extracted in the working directory of
	// .jar, .tar, .tar.gz, .tgz, and .zip.
	ArchiveUris []string `protobuf:"bytes,6,rep,name=archive_uris,json=archiveUris" json:"archive_uris,omitempty"`
	// [Optional] A mapping of property names to values, used to configure PySpark.
	// Properties that conflict with values set by the Cloud Dataproc API may be
	// overwritten. Can include properties set in
	// /etc/spark/conf/spark-defaults.conf and classes in user code.
	Properties map[string]string `protobuf:"bytes,7,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] The runtime log config for job execution.
	LoggingConfig *LoggingConfig `protobuf:"bytes,8,opt,name=logging_config,json=loggingConfig" json:"logging_config,omitempty"`
}

func (m *PySparkJob) Reset()                    { *m = PySparkJob{} }
func (m *PySparkJob) String() string            { return proto.CompactTextString(m) }
func (*PySparkJob) ProtoMessage()               {}
func (*PySparkJob) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *PySparkJob) GetMainPythonFileUri() string {
	if m != nil {
		return m.MainPythonFileUri
	}
	return ""
}

func (m *PySparkJob) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *PySparkJob) GetPythonFileUris() []string {
	if m != nil {
		return m.PythonFileUris
	}
	return nil
}

func (m *PySparkJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

func (m *PySparkJob) GetFileUris() []string {
	if m != nil {
		return m.FileUris
	}
	return nil
}

func (m *PySparkJob) GetArchiveUris() []string {
	if m != nil {
		return m.ArchiveUris
	}
	return nil
}

func (m *PySparkJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *PySparkJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// A list of queries to run on a cluster.
type QueryList struct {
	// [Required] The queries to execute. You do not need to terminate a query
	// with a semicolon. Multiple queries can be specified in one string
	// by separating each with a semicolon. Here is an example of an Cloud
	// Dataproc API snippet that uses a QueryList to specify a HiveJob:
	//
	//     "hiveJob": {
	//       "queryList": {
	//         "queries": [
	//           "query1",
	//           "query2",
	//           "query3;query4",
	//         ]
	//       }
	//     }
	Queries []string `protobuf:"bytes,1,rep,name=queries" json:"queries,omitempty"`
}

func (m *QueryList) Reset()                    { *m = QueryList{} }
func (m *QueryList) String() string            { return proto.CompactTextString(m) }
func (*QueryList) ProtoMessage()               {}
func (*QueryList) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *QueryList) GetQueries() []string {
	if m != nil {
		return m.Queries
	}
	return nil
}

// A Cloud Dataproc job for running [Apache Hive](https://hive.apache.org/)
// queries on YARN.
type HiveJob struct {
	// [Required] The sequence of Hive queries to execute, specified as either
	// an HCFS file URI or a list of queries.
	//
	// Types that are valid to be assigned to Queries:
	//	*HiveJob_QueryFileUri
	//	*HiveJob_QueryList
	Queries isHiveJob_Queries `protobuf_oneof:"queries"`
	// [Optional] Whether to continue executing queries if a query fails.
	// The default value is `false`. Setting to `true` can be useful when executing
	// independent parallel queries.
	ContinueOnFailure bool `protobuf:"varint,3,opt,name=continue_on_failure,json=continueOnFailure" json:"continue_on_failure,omitempty"`
	// [Optional] Mapping of query variable names to values (equivalent to the
	// Hive command: `SET name="value";`).
	ScriptVariables map[string]string `protobuf:"bytes,4,rep,name=script_variables,json=scriptVariables" json:"script_variables,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] A mapping of property names and values, used to configure Hive.
	// Properties that conflict with values set by the Cloud Dataproc API may be
	// overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml,
	// /etc/hive/conf/hive-site.xml, and classes in user code.
	Properties map[string]string `protobuf:"bytes,5,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] HCFS URIs of jar files to add to the CLASSPATH of the
	// Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes
	// and UDFs.
	JarFileUris []string `protobuf:"bytes,6,rep,name=jar_file_uris,json=jarFileUris" json:"jar_file_uris,omitempty"`
}

func (m *HiveJob) Reset()                    { *m = HiveJob{} }
func (m *HiveJob) String() string            { return proto.CompactTextString(m) }
func (*HiveJob) ProtoMessage()               {}
func (*HiveJob) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

type isHiveJob_Queries interface {
	isHiveJob_Queries()
}

type HiveJob_QueryFileUri struct {
	QueryFileUri string `protobuf:"bytes,1,opt,name=query_file_uri,json=queryFileUri,oneof"`
}
type HiveJob_QueryList struct {
	QueryList *QueryList `protobuf:"bytes,2,opt,name=query_list,json=queryList,oneof"`
}

func (*HiveJob_QueryFileUri) isHiveJob_Queries() {}
func (*HiveJob_QueryList) isHiveJob_Queries()    {}

func (m *HiveJob) GetQueries() isHiveJob_Queries {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *HiveJob) GetQueryFileUri() string {
	if x, ok := m.GetQueries().(*HiveJob_QueryFileUri); ok {
		return x.QueryFileUri
	}
	return ""
}

func (m *HiveJob) GetQueryList() *QueryList {
	if x, ok := m.GetQueries().(*HiveJob_QueryList); ok {
		return x.QueryList
	}
	return nil
}

func (m *HiveJob) GetContinueOnFailure() bool {
	if m != nil {
		return m.ContinueOnFailure
	}
	return false
}

func (m *HiveJob) GetScriptVariables() map[string]string {
	if m != nil {
		return m.ScriptVariables
	}
	return nil
}

func (m *HiveJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *HiveJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HiveJob) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HiveJob_OneofMarshaler, _HiveJob_OneofUnmarshaler, _HiveJob_OneofSizer, []interface{}{
		(*HiveJob_QueryFileUri)(nil),
		(*HiveJob_QueryList)(nil),
	}
}

func _HiveJob_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HiveJob)
	// queries
	switch x := m.Queries.(type) {
	case *HiveJob_QueryFileUri:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.QueryFileUri)
	case *HiveJob_QueryList:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QueryList); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("HiveJob.Queries has unexpected type %T", x)
	}
	return nil
}

func _HiveJob_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HiveJob)
	switch tag {
	case 1: // queries.query_file_uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Queries = &HiveJob_QueryFileUri{x}
		return true, err
	case 2: // queries.query_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryList)
		err := b.DecodeMessage(msg)
		m.Queries = &HiveJob_QueryList{msg}
		return true, err
	default:
		return false, nil
	}
}

func _HiveJob_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HiveJob)
	// queries
	switch x := m.Queries.(type) {
	case *HiveJob_QueryFileUri:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.QueryFileUri)))
		n += len(x.QueryFileUri)
	case *HiveJob_QueryList:
		s := proto.Size(x.QueryList)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Cloud Dataproc job for running [Apache Spark SQL](http://spark.apache.org/sql/)
// queries.
type SparkSqlJob struct {
	// [Required] The sequence of Spark SQL queries to execute, specified as
	// either an HCFS file URI or as a list of queries.
	//
	// Types that are valid to be assigned to Queries:
	//	*SparkSqlJob_QueryFileUri
	//	*SparkSqlJob_QueryList
	Queries isSparkSqlJob_Queries `protobuf_oneof:"queries"`
	// [Optional] Mapping of query variable names to values (equivalent to the
	// Spark SQL command: SET `name="value";`).
	ScriptVariables map[string]string `protobuf:"bytes,3,rep,name=script_variables,json=scriptVariables" json:"script_variables,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] A mapping of property names to values, used to configure
	// Spark SQL's SparkConf. Properties that conflict with values set by the
	// Cloud Dataproc API may be overwritten.
	Properties map[string]string `protobuf:"bytes,4,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] HCFS URIs of jar files to be added to the Spark CLASSPATH.
	JarFileUris []string `protobuf:"bytes,56,rep,name=jar_file_uris,json=jarFileUris" json:"jar_file_uris,omitempty"`
	// [Optional] The runtime log config for job execution.
	LoggingConfig *LoggingConfig `protobuf:"bytes,6,opt,name=logging_config,json=loggingConfig" json:"logging_config,omitempty"`
}

func (m *SparkSqlJob) Reset()                    { *m = SparkSqlJob{} }
func (m *SparkSqlJob) String() string            { return proto.CompactTextString(m) }
func (*SparkSqlJob) ProtoMessage()               {}
func (*SparkSqlJob) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

type isSparkSqlJob_Queries interface {
	isSparkSqlJob_Queries()
}

type SparkSqlJob_QueryFileUri struct {
	QueryFileUri string `protobuf:"bytes,1,opt,name=query_file_uri,json=queryFileUri,oneof"`
}
type SparkSqlJob_QueryList struct {
	QueryList *QueryList `protobuf:"bytes,2,opt,name=query_list,json=queryList,oneof"`
}

func (*SparkSqlJob_QueryFileUri) isSparkSqlJob_Queries() {}
func (*SparkSqlJob_QueryList) isSparkSqlJob_Queries()    {}

func (m *SparkSqlJob) GetQueries() isSparkSqlJob_Queries {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *SparkSqlJob) GetQueryFileUri() string {
	if x, ok := m.GetQueries().(*SparkSqlJob_QueryFileUri); ok {
		return x.QueryFileUri
	}
	return ""
}

func (m *SparkSqlJob) GetQueryList() *QueryList {
	if x, ok := m.GetQueries().(*SparkSqlJob_QueryList); ok {
		return x.QueryList
	}
	return nil
}

func (m *SparkSqlJob) GetScriptVariables() map[string]string {
	if m != nil {
		return m.ScriptVariables
	}
	return nil
}

func (m *SparkSqlJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *SparkSqlJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

func (m *SparkSqlJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SparkSqlJob) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SparkSqlJob_OneofMarshaler, _SparkSqlJob_OneofUnmarshaler, _SparkSqlJob_OneofSizer, []interface{}{
		(*SparkSqlJob_QueryFileUri)(nil),
		(*SparkSqlJob_QueryList)(nil),
	}
}

func _SparkSqlJob_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SparkSqlJob)
	// queries
	switch x := m.Queries.(type) {
	case *SparkSqlJob_QueryFileUri:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.QueryFileUri)
	case *SparkSqlJob_QueryList:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QueryList); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("SparkSqlJob.Queries has unexpected type %T", x)
	}
	return nil
}

func _SparkSqlJob_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SparkSqlJob)
	switch tag {
	case 1: // queries.query_file_uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Queries = &SparkSqlJob_QueryFileUri{x}
		return true, err
	case 2: // queries.query_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryList)
		err := b.DecodeMessage(msg)
		m.Queries = &SparkSqlJob_QueryList{msg}
		return true, err
	default:
		return false, nil
	}
}

func _SparkSqlJob_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SparkSqlJob)
	// queries
	switch x := m.Queries.(type) {
	case *SparkSqlJob_QueryFileUri:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.QueryFileUri)))
		n += len(x.QueryFileUri)
	case *SparkSqlJob_QueryList:
		s := proto.Size(x.QueryList)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Cloud Dataproc job for running [Apache Pig](https://pig.apache.org/)
// queries on YARN.
type PigJob struct {
	// [Required] The sequence of Pig queries to execute, specified as an HCFS
	// file URI or a list of queries.
	//
	// Types that are valid to be assigned to Queries:
	//	*PigJob_QueryFileUri
	//	*PigJob_QueryList
	Queries isPigJob_Queries `protobuf_oneof:"queries"`
	// [Optional] Whether to continue executing queries if a query fails.
	// The default value is `false`. Setting to `true` can be useful when executing
	// independent parallel queries.
	ContinueOnFailure bool `protobuf:"varint,3,opt,name=continue_on_failure,json=continueOnFailure" json:"continue_on_failure,omitempty"`
	// [Optional] Mapping of query variable names to values (equivalent to the Pig
	// command: `name=[value]`).
	ScriptVariables map[string]string `protobuf:"bytes,4,rep,name=script_variables,json=scriptVariables" json:"script_variables,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] A mapping of property names to values, used to configure Pig.
	// Properties that conflict with values set by the Cloud Dataproc API may be
	// overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml,
	// /etc/pig/conf/pig.properties, and classes in user code.
	Properties map[string]string `protobuf:"bytes,5,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] HCFS URIs of jar files to add to the CLASSPATH of
	// the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
	JarFileUris []string `protobuf:"bytes,6,rep,name=jar_file_uris,json=jarFileUris" json:"jar_file_uris,omitempty"`
	// [Optional] The runtime log config for job execution.
	LoggingConfig *LoggingConfig `protobuf:"bytes,7,opt,name=logging_config,json=loggingConfig" json:"logging_config,omitempty"`
}

func (m *PigJob) Reset()                    { *m = PigJob{} }
func (m *PigJob) String() string            { return proto.CompactTextString(m) }
func (*PigJob) ProtoMessage()               {}
func (*PigJob) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

type isPigJob_Queries interface {
	isPigJob_Queries()
}

type PigJob_QueryFileUri struct {
	QueryFileUri string `protobuf:"bytes,1,opt,name=query_file_uri,json=queryFileUri,oneof"`
}
type PigJob_QueryList struct {
	QueryList *QueryList `protobuf:"bytes,2,opt,name=query_list,json=queryList,oneof"`
}

func (*PigJob_QueryFileUri) isPigJob_Queries() {}
func (*PigJob_QueryList) isPigJob_Queries()    {}

func (m *PigJob) GetQueries() isPigJob_Queries {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *PigJob) GetQueryFileUri() string {
	if x, ok := m.GetQueries().(*PigJob_QueryFileUri); ok {
		return x.QueryFileUri
	}
	return ""
}

func (m *PigJob) GetQueryList() *QueryList {
	if x, ok := m.GetQueries().(*PigJob_QueryList); ok {
		return x.QueryList
	}
	return nil
}

func (m *PigJob) GetContinueOnFailure() bool {
	if m != nil {
		return m.ContinueOnFailure
	}
	return false
}

func (m *PigJob) GetScriptVariables() map[string]string {
	if m != nil {
		return m.ScriptVariables
	}
	return nil
}

func (m *PigJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *PigJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

func (m *PigJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PigJob) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PigJob_OneofMarshaler, _PigJob_OneofUnmarshaler, _PigJob_OneofSizer, []interface{}{
		(*PigJob_QueryFileUri)(nil),
		(*PigJob_QueryList)(nil),
	}
}

func _PigJob_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PigJob)
	// queries
	switch x := m.Queries.(type) {
	case *PigJob_QueryFileUri:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.QueryFileUri)
	case *PigJob_QueryList:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QueryList); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("PigJob.Queries has unexpected type %T", x)
	}
	return nil
}

func _PigJob_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PigJob)
	switch tag {
	case 1: // queries.query_file_uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Queries = &PigJob_QueryFileUri{x}
		return true, err
	case 2: // queries.query_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryList)
		err := b.DecodeMessage(msg)
		m.Queries = &PigJob_QueryList{msg}
		return true, err
	default:
		return false, nil
	}
}

func _PigJob_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PigJob)
	// queries
	switch x := m.Queries.(type) {
	case *PigJob_QueryFileUri:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.QueryFileUri)))
		n += len(x.QueryFileUri)
	case *PigJob_QueryList:
		s := proto.Size(x.QueryList)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Cloud Dataproc job config.
type JobPlacement struct {
	// [Required] The name of the cluster where the job will be submitted.
	ClusterName string `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
	// [Output-only] A cluster UUID generated by the Cloud Dataproc service when
	// the job is submitted.
	ClusterUuid string `protobuf:"bytes,2,opt,name=cluster_uuid,json=clusterUuid" json:"cluster_uuid,omitempty"`
}

func (m *JobPlacement) Reset()                    { *m = JobPlacement{} }
func (m *JobPlacement) String() string            { return proto.CompactTextString(m) }
func (*JobPlacement) ProtoMessage()               {}
func (*JobPlacement) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *JobPlacement) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *JobPlacement) GetClusterUuid() string {
	if m != nil {
		return m.ClusterUuid
	}
	return ""
}

// Cloud Dataproc job status.
type JobStatus struct {
	// [Output-only] A state message specifying the overall job state.
	State JobStatus_State `protobuf:"varint,1,opt,name=state,enum=google.cloud.dataproc.v1.JobStatus_State" json:"state,omitempty"`
	// [Output-only] Optional job state details, such as an error
	// description if the state is <code>ERROR</code>.
	Details string `protobuf:"bytes,2,opt,name=details" json:"details,omitempty"`
	// [Output-only] The time when this state was entered.
	StateStartTime *google_protobuf3.Timestamp `protobuf:"bytes,6,opt,name=state_start_time,json=stateStartTime" json:"state_start_time,omitempty"`
}

func (m *JobStatus) Reset()                    { *m = JobStatus{} }
func (m *JobStatus) String() string            { return proto.CompactTextString(m) }
func (*JobStatus) ProtoMessage()               {}
func (*JobStatus) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *JobStatus) GetState() JobStatus_State {
	if m != nil {
		return m.State
	}
	return JobStatus_STATE_UNSPECIFIED
}

func (m *JobStatus) GetDetails() string {
	if m != nil {
		return m.Details
	}
	return ""
}

func (m *JobStatus) GetStateStartTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.StateStartTime
	}
	return nil
}

// Encapsulates the full scoping used to reference a job.
type JobReference struct {
	// [Required] The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Optional] The job ID, which must be unique within the project. The job ID
	// is generated by the server upon job submission or provided by the user as a
	// means to perform retries without creating duplicate jobs. The ID must
	// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or
	// hyphens (-). The maximum length is 512 characters.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId" json:"job_id,omitempty"`
}

func (m *JobReference) Reset()                    { *m = JobReference{} }
func (m *JobReference) String() string            { return proto.CompactTextString(m) }
func (*JobReference) ProtoMessage()               {}
func (*JobReference) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *JobReference) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *JobReference) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

// A Cloud Dataproc job resource.
type Job struct {
	// [Optional] The fully qualified reference to the job, which can be used to
	// obtain the equivalent REST path of the job resource. If this property
	// is not specified when a job is created, the server generates a
	// <code>job_id</code>.
	Reference *JobReference `protobuf:"bytes,1,opt,name=reference" json:"reference,omitempty"`
	// [Required] Job information, including how, when, and where to
	// run the job.
	Placement *JobPlacement `protobuf:"bytes,2,opt,name=placement" json:"placement,omitempty"`
	// [Required] The application/framework-specific portion of the job.
	//
	// Types that are valid to be assigned to TypeJob:
	//	*Job_HadoopJob
	//	*Job_SparkJob
	//	*Job_PysparkJob
	//	*Job_HiveJob
	//	*Job_PigJob
	//	*Job_SparkSqlJob
	TypeJob isJob_TypeJob `protobuf_oneof:"type_job"`
	// [Output-only] The job status. Additional application-specific
	// status information may be contained in the <code>type_job</code>
	// and <code>yarn_applications</code> fields.
	Status *JobStatus `protobuf:"bytes,8,opt,name=status" json:"status,omitempty"`
	// [Output-only] The previous job status.
	StatusHistory []*JobStatus `protobuf:"bytes,13,rep,name=status_history,json=statusHistory" json:"status_history,omitempty"`
	// [Output-only] A URI pointing to the location of the stdout of the job's
	// driver program.
	DriverOutputResourceUri string `protobuf:"bytes,17,opt,name=driver_output_resource_uri,json=driverOutputResourceUri" json:"driver_output_resource_uri,omitempty"`
	// [Output-only] If present, the location of miscellaneous control files
	// which may be used as part of job setup and handling. If not present,
	// control files may be placed in the same location as `driver_output_uri`.
	DriverControlFilesUri string `protobuf:"bytes,15,opt,name=driver_control_files_uri,json=driverControlFilesUri" json:"driver_control_files_uri,omitempty"`
}

func (m *Job) Reset()                    { *m = Job{} }
func (m *Job) String() string            { return proto.CompactTextString(m) }
func (*Job) ProtoMessage()               {}
func (*Job) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

type isJob_TypeJob interface {
	isJob_TypeJob()
}

type Job_HadoopJob struct {
	HadoopJob *HadoopJob `protobuf:"bytes,3,opt,name=hadoop_job,json=hadoopJob,oneof"`
}
type Job_SparkJob struct {
	SparkJob *SparkJob `protobuf:"bytes,4,opt,name=spark_job,json=sparkJob,oneof"`
}
type Job_PysparkJob struct {
	PysparkJob *PySparkJob `protobuf:"bytes,5,opt,name=pyspark_job,json=pysparkJob,oneof"`
}
type Job_HiveJob struct {
	HiveJob *HiveJob `protobuf:"bytes,6,opt,name=hive_job,json=hiveJob,oneof"`
}
type Job_PigJob struct {
	PigJob *PigJob `protobuf:"bytes,7,opt,name=pig_job,json=pigJob,oneof"`
}
type Job_SparkSqlJob struct {
	SparkSqlJob *SparkSqlJob `protobuf:"bytes,12,opt,name=spark_sql_job,json=sparkSqlJob,oneof"`
}

func (*Job_HadoopJob) isJob_TypeJob()   {}
func (*Job_SparkJob) isJob_TypeJob()    {}
func (*Job_PysparkJob) isJob_TypeJob()  {}
func (*Job_HiveJob) isJob_TypeJob()     {}
func (*Job_PigJob) isJob_TypeJob()      {}
func (*Job_SparkSqlJob) isJob_TypeJob() {}

func (m *Job) GetTypeJob() isJob_TypeJob {
	if m != nil {
		return m.TypeJob
	}
	return nil
}

func (m *Job) GetReference() *JobReference {
	if m != nil {
		return m.Reference
	}
	return nil
}

func (m *Job) GetPlacement() *JobPlacement {
	if m != nil {
		return m.Placement
	}
	return nil
}

func (m *Job) GetHadoopJob() *HadoopJob {
	if x, ok := m.GetTypeJob().(*Job_HadoopJob); ok {
		return x.HadoopJob
	}
	return nil
}

func (m *Job) GetSparkJob() *SparkJob {
	if x, ok := m.GetTypeJob().(*Job_SparkJob); ok {
		return x.SparkJob
	}
	return nil
}

func (m *Job) GetPysparkJob() *PySparkJob {
	if x, ok := m.GetTypeJob().(*Job_PysparkJob); ok {
		return x.PysparkJob
	}
	return nil
}

func (m *Job) GetHiveJob() *HiveJob {
	if x, ok := m.GetTypeJob().(*Job_HiveJob); ok {
		return x.HiveJob
	}
	return nil
}

func (m *Job) GetPigJob() *PigJob {
	if x, ok := m.GetTypeJob().(*Job_PigJob); ok {
		return x.PigJob
	}
	return nil
}

func (m *Job) GetSparkSqlJob() *SparkSqlJob {
	if x, ok := m.GetTypeJob().(*Job_SparkSqlJob); ok {
		return x.SparkSqlJob
	}
	return nil
}

func (m *Job) GetStatus() *JobStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Job) GetStatusHistory() []*JobStatus {
	if m != nil {
		return m.StatusHistory
	}
	return nil
}

func (m *Job) GetDriverOutputResourceUri() string {
	if m != nil {
		return m.DriverOutputResourceUri
	}
	return ""
}

func (m *Job) GetDriverControlFilesUri() string {
	if m != nil {
		return m.DriverControlFilesUri
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Job) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Job_OneofMarshaler, _Job_OneofUnmarshaler, _Job_OneofSizer, []interface{}{
		(*Job_HadoopJob)(nil),
		(*Job_SparkJob)(nil),
		(*Job_PysparkJob)(nil),
		(*Job_HiveJob)(nil),
		(*Job_PigJob)(nil),
		(*Job_SparkSqlJob)(nil),
	}
}

func _Job_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Job)
	// type_job
	switch x := m.TypeJob.(type) {
	case *Job_HadoopJob:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HadoopJob); err != nil {
			return err
		}
	case *Job_SparkJob:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SparkJob); err != nil {
			return err
		}
	case *Job_PysparkJob:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PysparkJob); err != nil {
			return err
		}
	case *Job_HiveJob:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HiveJob); err != nil {
			return err
		}
	case *Job_PigJob:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PigJob); err != nil {
			return err
		}
	case *Job_SparkSqlJob:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SparkSqlJob); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Job.TypeJob has unexpected type %T", x)
	}
	return nil
}

func _Job_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Job)
	switch tag {
	case 3: // type_job.hadoop_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HadoopJob)
		err := b.DecodeMessage(msg)
		m.TypeJob = &Job_HadoopJob{msg}
		return true, err
	case 4: // type_job.spark_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SparkJob)
		err := b.DecodeMessage(msg)
		m.TypeJob = &Job_SparkJob{msg}
		return true, err
	case 5: // type_job.pyspark_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PySparkJob)
		err := b.DecodeMessage(msg)
		m.TypeJob = &Job_PysparkJob{msg}
		return true, err
	case 6: // type_job.hive_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HiveJob)
		err := b.DecodeMessage(msg)
		m.TypeJob = &Job_HiveJob{msg}
		return true, err
	case 7: // type_job.pig_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PigJob)
		err := b.DecodeMessage(msg)
		m.TypeJob = &Job_PigJob{msg}
		return true, err
	case 12: // type_job.spark_sql_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SparkSqlJob)
		err := b.DecodeMessage(msg)
		m.TypeJob = &Job_SparkSqlJob{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Job_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Job)
	// type_job
	switch x := m.TypeJob.(type) {
	case *Job_HadoopJob:
		s := proto.Size(x.HadoopJob)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Job_SparkJob:
		s := proto.Size(x.SparkJob)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Job_PysparkJob:
		s := proto.Size(x.PysparkJob)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Job_HiveJob:
		s := proto.Size(x.HiveJob)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Job_PigJob:
		s := proto.Size(x.PigJob)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Job_SparkSqlJob:
		s := proto.Size(x.SparkSqlJob)
		n += proto.SizeVarint(12<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A request to submit a job.
type SubmitJobRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The job resource.
	Job *Job `protobuf:"bytes,2,opt,name=job" json:"job,omitempty"`
}

func (m *SubmitJobRequest) Reset()                    { *m = SubmitJobRequest{} }
func (m *SubmitJobRequest) String() string            { return proto.CompactTextString(m) }
func (*SubmitJobRequest) ProtoMessage()               {}
func (*SubmitJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *SubmitJobRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SubmitJobRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *SubmitJobRequest) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

// A request to get the resource representation for a job in a project.
type GetJobRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The job ID.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId" json:"job_id,omitempty"`
}

func (m *GetJobRequest) Reset()                    { *m = GetJobRequest{} }
func (m *GetJobRequest) String() string            { return proto.CompactTextString(m) }
func (*GetJobRequest) ProtoMessage()               {}
func (*GetJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

func (m *GetJobRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetJobRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *GetJobRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

// A request to list jobs in a project.
type ListJobsRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,6,opt,name=region" json:"region,omitempty"`
	// [Optional] The number of results to return in each response.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// [Optional] The page token, returned by a previous call, to request the
	// next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// [Optional] If set, the returned jobs list includes only jobs that were
	// submitted to the named cluster.
	ClusterName string `protobuf:"bytes,4,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
	// [Optional] Specifies enumerated categories of jobs to list
	// (default = match ALL jobs).
	JobStateMatcher ListJobsRequest_JobStateMatcher `protobuf:"varint,5,opt,name=job_state_matcher,json=jobStateMatcher,enum=google.cloud.dataproc.v1.ListJobsRequest_JobStateMatcher" json:"job_state_matcher,omitempty"`
}

func (m *ListJobsRequest) Reset()                    { *m = ListJobsRequest{} }
func (m *ListJobsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListJobsRequest) ProtoMessage()               {}
func (*ListJobsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

func (m *ListJobsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListJobsRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *ListJobsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListJobsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListJobsRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *ListJobsRequest) GetJobStateMatcher() ListJobsRequest_JobStateMatcher {
	if m != nil {
		return m.JobStateMatcher
	}
	return ListJobsRequest_ALL
}

// A list of jobs in a project.
type ListJobsResponse struct {
	// [Output-only] Jobs list.
	Jobs []*Job `protobuf:"bytes,1,rep,name=jobs" json:"jobs,omitempty"`
	// [Optional] This token is included in the response if there are more results
	// to fetch. To fetch additional results, provide this value as the
	// `page_token` in a subsequent <code>ListJobsRequest</code>.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListJobsResponse) Reset()                    { *m = ListJobsResponse{} }
func (m *ListJobsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListJobsResponse) ProtoMessage()               {}
func (*ListJobsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{15} }

func (m *ListJobsResponse) GetJobs() []*Job {
	if m != nil {
		return m.Jobs
	}
	return nil
}

func (m *ListJobsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to cancel a job.
type CancelJobRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The job ID.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId" json:"job_id,omitempty"`
}

func (m *CancelJobRequest) Reset()                    { *m = CancelJobRequest{} }
func (m *CancelJobRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelJobRequest) ProtoMessage()               {}
func (*CancelJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{16} }

func (m *CancelJobRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CancelJobRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *CancelJobRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

// A request to delete a job.
type DeleteJobRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The job ID.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId" json:"job_id,omitempty"`
}

func (m *DeleteJobRequest) Reset()                    { *m = DeleteJobRequest{} }
func (m *DeleteJobRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteJobRequest) ProtoMessage()               {}
func (*DeleteJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{17} }

func (m *DeleteJobRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeleteJobRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *DeleteJobRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func init() {
	proto.RegisterType((*LoggingConfig)(nil), "google.cloud.dataproc.v1.LoggingConfig")
	proto.RegisterType((*HadoopJob)(nil), "google.cloud.dataproc.v1.HadoopJob")
	proto.RegisterType((*SparkJob)(nil), "google.cloud.dataproc.v1.SparkJob")
	proto.RegisterType((*PySparkJob)(nil), "google.cloud.dataproc.v1.PySparkJob")
	proto.RegisterType((*QueryList)(nil), "google.cloud.dataproc.v1.QueryList")
	proto.RegisterType((*HiveJob)(nil), "google.cloud.dataproc.v1.HiveJob")
	proto.RegisterType((*SparkSqlJob)(nil), "google.cloud.dataproc.v1.SparkSqlJob")
	proto.RegisterType((*PigJob)(nil), "google.cloud.dataproc.v1.PigJob")
	proto.RegisterType((*JobPlacement)(nil), "google.cloud.dataproc.v1.JobPlacement")
	proto.RegisterType((*JobStatus)(nil), "google.cloud.dataproc.v1.JobStatus")
	proto.RegisterType((*JobReference)(nil), "google.cloud.dataproc.v1.JobReference")
	proto.RegisterType((*Job)(nil), "google.cloud.dataproc.v1.Job")
	proto.RegisterType((*SubmitJobRequest)(nil), "google.cloud.dataproc.v1.SubmitJobRequest")
	proto.RegisterType((*GetJobRequest)(nil), "google.cloud.dataproc.v1.GetJobRequest")
	proto.RegisterType((*ListJobsRequest)(nil), "google.cloud.dataproc.v1.ListJobsRequest")
	proto.RegisterType((*ListJobsResponse)(nil), "google.cloud.dataproc.v1.ListJobsResponse")
	proto.RegisterType((*CancelJobRequest)(nil), "google.cloud.dataproc.v1.CancelJobRequest")
	proto.RegisterType((*DeleteJobRequest)(nil), "google.cloud.dataproc.v1.DeleteJobRequest")
	proto.RegisterEnum("google.cloud.dataproc.v1.LoggingConfig_Level", LoggingConfig_Level_name, LoggingConfig_Level_value)
	proto.RegisterEnum("google.cloud.dataproc.v1.JobStatus_State", JobStatus_State_name, JobStatus_State_value)
	proto.RegisterEnum("google.cloud.dataproc.v1.ListJobsRequest_JobStateMatcher", ListJobsRequest_JobStateMatcher_name, ListJobsRequest_JobStateMatcher_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for JobController service

type JobControllerClient interface {
	// Submits a job to a cluster.
	SubmitJob(ctx context.Context, in *SubmitJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Gets the resource representation for a job in a project.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Lists regions/{region}/jobs in a project.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Starts a job cancellation request. To access the job resource
	// after cancellation, call
	// [regions/{region}/jobs.list](/dataproc/reference/rest/v1/projects.regions.jobs/list) or
	// [regions/{region}/jobs.get](/dataproc/reference/rest/v1/projects.regions.jobs/get).
	CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Deletes the job from the project. If the job is active, the delete fails,
	// and the response returns `FAILED_PRECONDITION`.
	DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
}

type jobControllerClient struct {
	cc *grpc.ClientConn
}

func NewJobControllerClient(cc *grpc.ClientConn) JobControllerClient {
	return &jobControllerClient{cc}
}

func (c *jobControllerClient) SubmitJob(ctx context.Context, in *SubmitJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.JobController/SubmitJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobControllerClient) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.JobController/GetJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobControllerClient) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.JobController/ListJobs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobControllerClient) CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.JobController/CancelJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobControllerClient) DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.JobController/DeleteJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for JobController service

type JobControllerServer interface {
	// Submits a job to a cluster.
	SubmitJob(context.Context, *SubmitJobRequest) (*Job, error)
	// Gets the resource representation for a job in a project.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// Lists regions/{region}/jobs in a project.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Starts a job cancellation request. To access the job resource
	// after cancellation, call
	// [regions/{region}/jobs.list](/dataproc/reference/rest/v1/projects.regions.jobs/list) or
	// [regions/{region}/jobs.get](/dataproc/reference/rest/v1/projects.regions.jobs/get).
	CancelJob(context.Context, *CancelJobRequest) (*Job, error)
	// Deletes the job from the project. If the job is active, the delete fails,
	// and the response returns `FAILED_PRECONDITION`.
	DeleteJob(context.Context, *DeleteJobRequest) (*google_protobuf2.Empty, error)
}

func RegisterJobControllerServer(s *grpc.Server, srv JobControllerServer) {
	s.RegisterService(&_JobController_serviceDesc, srv)
}

func _JobController_SubmitJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).SubmitJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.JobController/SubmitJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).SubmitJob(ctx, req.(*SubmitJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobController_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.JobController/GetJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobController_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.JobController/ListJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobController_CancelJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).CancelJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.JobController/CancelJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).CancelJob(ctx, req.(*CancelJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobController_DeleteJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).DeleteJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.JobController/DeleteJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).DeleteJob(ctx, req.(*DeleteJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _JobController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.JobController",
	HandlerType: (*JobControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SubmitJob",
			Handler:    _JobController_SubmitJob_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _JobController_GetJob_Handler,
		},
		{
			MethodName: "ListJobs",
			Handler:    _JobController_ListJobs_Handler,
		},
		{
			MethodName: "CancelJob",
			Handler:    _JobController_CancelJob_Handler,
		},
		{
			MethodName: "DeleteJob",
			Handler:    _JobController_DeleteJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1/jobs.proto",
}

func init() { proto.RegisterFile("google/cloud/dataproc/v1/jobs.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 1862 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x59, 0x5b, 0x6f, 0x23, 0x49,
	0x15, 0x8e, 0xef, 0xee, 0xe3, 0xb1, 0xd3, 0x29, 0x66, 0x17, 0xcb, 0xb3, 0xab, 0xcd, 0xf6, 0xb0,
	0x43, 0x76, 0x10, 0x36, 0xf1, 0xc2, 0xec, 0x90, 0x00, 0xbb, 0x8e, 0xed, 0x8c, 0x13, 0x8c, 0xe3,
	0x6d, 0x3b, 0x83, 0x84, 0x84, 0x7a, 0xda, 0x76, 0xc5, 0x69, 0x4f, 0xbb, 0xab, 0xd3, 0xd5, 0x6d,
	0xe1, 0x19, 0xcd, 0x0b, 0x7f, 0x00, 0x71, 0x11, 0x12, 0x3c, 0xf2, 0x2b, 0x90, 0x10, 0xe2, 0x01,
	0xc4, 0x1f, 0xe0, 0x15, 0xf1, 0xc4, 0x0f, 0x41, 0x55, 0xd5, 0xed, 0xf8, 0x12, 0x5f, 0xb2, 0xc3,
	0xae, 0x76, 0xf7, 0x29, 0xd5, 0xe7, 0x56, 0xa7, 0xea, 0xfb, 0xce, 0xa9, 0x2a, 0x07, 0xee, 0xf7,
	0x09, 0xe9, 0x9b, 0xb8, 0xd0, 0x35, 0x89, 0xd7, 0x2b, 0xf4, 0x74, 0x57, 0xb7, 0x1d, 0xd2, 0x2d,
	0x8c, 0xf6, 0x0b, 0x03, 0xd2, 0xa1, 0x79, 0xdb, 0x21, 0x2e, 0x41, 0x59, 0x61, 0x94, 0xe7, 0x46,
	0xf9, 0xc0, 0x28, 0x3f, 0xda, 0xcf, 0xbd, 0xe5, 0xbb, 0xeb, 0xb6, 0x51, 0xd0, 0x2d, 0x8b, 0xb8,
	0xba, 0x6b, 0x10, 0xcb, 0xf7, 0xcb, 0xdd, 0xf3, 0xb5, 0xfc, 0xab, 0xe3, 0x5d, 0x14, 0xf0, 0xd0,
	0x76, 0xc7, 0xbe, 0xf2, 0x9d, 0x79, 0xa5, 0x6b, 0x0c, 0x31, 0x75, 0xf5, 0xa1, 0x2d, 0x0c, 0x94,
	0xff, 0x84, 0x21, 0x5d, 0x27, 0xfd, 0xbe, 0x61, 0xf5, 0xcb, 0xc4, 0xba, 0x30, 0xfa, 0xe8, 0x12,
	0x76, 0x7a, 0x8e, 0x31, 0xc2, 0x8e, 0x66, 0x92, 0xbe, 0x66, 0xe2, 0x11, 0x36, 0x69, 0x36, 0xbc,
	0x1b, 0xd9, 0x4b, 0x15, 0x7f, 0x90, 0x5f, 0x96, 0x63, 0x7e, 0x26, 0x46, 0xbe, 0xc2, 0x03, 0xd4,
	0x49, 0xbf, 0xce, 0xdd, 0xab, 0x96, 0xeb, 0x8c, 0xd5, 0xed, 0xde, 0xac, 0x34, 0x77, 0x05, 0x77,
	0x6f, 0x32, 0x44, 0x32, 0x44, 0x9e, 0xe3, 0x71, 0x36, 0xb4, 0x1b, 0xda, 0x93, 0x54, 0x36, 0x44,
	0x65, 0x88, 0x8d, 0x74, 0xd3, 0xc3, 0xd9, 0xf0, 0x6e, 0x68, 0x2f, 0x53, 0xfc, 0xf6, 0xa6, 0x79,
	0xf0, 0xa8, 0xaa, 0xf0, 0x3d, 0x08, 0x3f, 0x0e, 0x29, 0x36, 0xc4, 0xb8, 0x0c, 0xbd, 0x01, 0x3b,
	0xf5, 0xea, 0xd3, 0x6a, 0x5d, 0x3b, 0x6f, 0xb4, 0x9a, 0xd5, 0xf2, 0xc9, 0xf1, 0x49, 0xb5, 0x22,
	0x6f, 0xa1, 0x04, 0x44, 0x4a, 0xf5, 0xba, 0x1c, 0x42, 0x12, 0xc4, 0xda, 0x6a, 0xa9, 0x5c, 0x95,
	0xc3, 0x6c, 0x58, 0xa9, 0x1e, 0x9d, 0x3f, 0x91, 0x23, 0x28, 0x09, 0xd1, 0x93, 0xc6, 0xf1, 0x99,
	0x1c, 0x65, 0xa3, 0x9f, 0x96, 0xd4, 0x86, 0x1c, 0x63, 0xea, 0xaa, 0xaa, 0x9e, 0xa9, 0x72, 0x9c,
	0x0d, 0x8f, 0x4b, 0xed, 0x52, 0x5d, 0x4e, 0xb0, 0x40, 0x67, 0xc7, 0xc7, 0x72, 0x52, 0xf9, 0x5b,
	0x04, 0xa4, 0x9a, 0xde, 0x23, 0xc4, 0x3e, 0x25, 0x1d, 0xf4, 0x2d, 0xd8, 0x19, 0xea, 0x86, 0xa5,
	0x0d, 0x74, 0x47, 0xbb, 0x30, 0x4c, 0xac, 0x79, 0x8e, 0x21, 0x16, 0x5a, 0xdb, 0x52, 0x33, 0x4c,
	0x75, 0xaa, 0x3b, 0xc7, 0x86, 0x89, 0xcf, 0x1d, 0x03, 0xbd, 0x03, 0xc0, 0x8d, 0xbb, 0xa6, 0x4e,
	0x29, 0x5f, 0x3a, 0xb3, 0x92, 0x98, 0xac, 0xcc, 0x44, 0x08, 0x41, 0x54, 0x77, 0xfa, 0x34, 0x1b,
	0xd9, 0x8d, 0xec, 0x49, 0x2a, 0x1f, 0x23, 0x05, 0xd2, 0xd3, 0xc1, 0x69, 0x36, 0xca, 0x95, 0xa9,
	0xc1, 0x24, 0x2e, 0x45, 0xf7, 0x40, 0xba, 0xd6, 0xc7, 0xb8, 0x3e, 0x79, 0x11, 0x28, 0xdf, 0x85,
	0x3b, 0xba, 0xd3, 0xbd, 0x34, 0x46, 0xbe, 0x3e, 0x2e, 0xfc, 0x7d, 0x19, 0x37, 0x69, 0x01, 0xd8,
	0x0e, 0xb1, 0xb1, 0xe3, 0x1a, 0x98, 0x66, 0x13, 0x9c, 0x1b, 0x1f, 0x2c, 0xc7, 0x64, 0xb2, 0xfc,
	0x7c, 0x73, 0xe2, 0x25, 0x28, 0x31, 0x15, 0x06, 0x35, 0x20, 0x63, 0x0a, 0xf0, 0xb4, 0x2e, 0x47,
	0x2f, 0x9b, 0xdc, 0x0d, 0xed, 0xa5, 0x8a, 0xdf, 0xdc, 0x10, 0x6c, 0x35, 0x6d, 0x4e, 0x7f, 0xe6,
	0x7e, 0x08, 0xdb, 0x73, 0xd3, 0xdd, 0x40, 0xac, 0xbb, 0xd3, 0xc4, 0x92, 0xa6, 0x98, 0x72, 0x94,
	0x84, 0xb8, 0xe0, 0xab, 0xf2, 0xd7, 0x08, 0x24, 0x5b, 0xb6, 0xee, 0x3c, 0xff, 0xea, 0x00, 0xa8,
	0xde, 0x00, 0x60, 0x71, 0xf9, 0x3e, 0x07, 0xab, 0xff, 0x72, 0xe2, 0xf7, 0x8f, 0x08, 0x40, 0x73,
	0x3c, 0x41, 0xb0, 0x00, 0x77, 0x39, 0x28, 0xf6, 0xd8, 0xbd, 0x24, 0xd6, 0x1c, 0x88, 0x2a, 0x47,
	0xb7, 0xc9, 0x55, 0x01, 0x8a, 0x01, 0x48, 0xe1, 0x29, 0x90, 0xf6, 0x40, 0x9e, 0xf3, 0x0f, 0x40,
	0xcc, 0xd8, 0xd3, 0xce, 0x9f, 0x0f, 0x9c, 0xed, 0x1b, 0xe0, 0xfc, 0xee, 0xf2, 0x6d, 0xbf, 0xde,
	0x8c, 0x2f, 0x11, 0xa0, 0xca, 0x7b, 0x20, 0x7d, 0xe2, 0x61, 0x67, 0x5c, 0x37, 0xa8, 0x8b, 0xb2,
	0x90, 0xb8, 0xf2, 0xb0, 0xc3, 0x96, 0x1b, 0xe2, 0xfb, 0x11, 0x7c, 0x2a, 0xbf, 0x8a, 0x42, 0xa2,
	0x66, 0x8c, 0x30, 0x83, 0xfa, 0x01, 0x64, 0x98, 0x78, 0xbc, 0x58, 0xa9, 0x77, 0xb8, 0x3c, 0x40,
	0xb8, 0x02, 0x20, 0xec, 0x4c, 0x83, 0xba, 0x7c, 0xe6, 0x54, 0xf1, 0xfe, 0xf2, 0x55, 0x4e, 0xd2,
	0x60, 0xc5, 0x7c, 0x35, 0xc9, 0x29, 0x0f, 0x5f, 0xeb, 0x12, 0xcb, 0x35, 0x2c, 0x0f, 0x6b, 0x8c,
	0x18, 0xba, 0x61, 0x7a, 0x0e, 0xce, 0x46, 0x76, 0x43, 0x7b, 0x49, 0x75, 0x27, 0x50, 0x9d, 0x59,
	0xc7, 0x42, 0x81, 0x74, 0x90, 0x69, 0xd7, 0x31, 0x6c, 0x57, 0x1b, 0xe9, 0x8e, 0xa1, 0x77, 0x4c,
	0x2c, 0xc8, 0x91, 0x2a, 0x3e, 0x5a, 0xd1, 0x4b, 0xc5, 0xd2, 0xf2, 0x2d, 0xee, 0xf9, 0x34, 0x70,
	0xf4, 0x4f, 0x58, 0x3a, 0x2b, 0x45, 0x9f, 0xcc, 0x10, 0x23, 0xc6, 0x83, 0xef, 0xaf, 0x0f, 0xbe,
	0x8a, 0x15, 0x0b, 0x7c, 0x8e, 0x2f, 0xf0, 0x39, 0x77, 0x04, 0x77, 0x6f, 0xca, 0xef, 0x36, 0x70,
	0xbf, 0x6e, 0xf9, 0x4b, 0x13, 0x82, 0x28, 0x7f, 0x89, 0x42, 0x8a, 0x13, 0xbe, 0x75, 0x65, 0x7e,
	0xfe, 0xac, 0xc0, 0x37, 0xa0, 0x1c, 0xe1, 0x40, 0x1c, 0xac, 0x69, 0xb8, 0x22, 0xdd, 0x0d, 0x91,
	0x3e, 0x9f, 0x41, 0x5a, 0xd0, 0xe8, 0x7b, 0x9b, 0x4d, 0x70, 0x2b, 0xb4, 0x1f, 0x2f, 0x76, 0xaf,
	0xc5, 0x3e, 0x11, 0x7f, 0xad, 0x3e, 0xf1, 0xc5, 0x62, 0xcf, 0xbf, 0xa3, 0x10, 0x6f, 0x1a, 0xfd,
	0x2f, 0x7e, 0x3b, 0x79, 0xb6, 0xb4, 0x9d, 0xac, 0xe0, 0x81, 0x58, 0xd9, 0x86, 0x1c, 0x6b, 0xde,
	0xd0, 0x4d, 0xbe, 0xb3, 0x36, 0xf6, 0x6b, 0x36, 0x93, 0x1b, 0xe8, 0x95, 0xf8, 0x0a, 0xd1, 0xab,
	0x0d, 0x77, 0x4e, 0x49, 0xa7, 0x69, 0xea, 0x5d, 0x3c, 0xc4, 0x96, 0xcb, 0x4e, 0xfb, 0xae, 0xe9,
	0x51, 0x17, 0x3b, 0x9a, 0xa5, 0x0f, 0xb1, 0x1f, 0x2f, 0xe5, 0xcb, 0x1a, 0xfa, 0x10, 0x4f, 0x9b,
	0x78, 0x9e, 0xd1, 0xf3, 0xc3, 0x07, 0x26, 0xe7, 0x9e, 0xd1, 0x53, 0xfe, 0x1e, 0x06, 0xe9, 0x94,
	0x74, 0x5a, 0xae, 0xee, 0x7a, 0x14, 0x7d, 0x04, 0x31, 0xea, 0xea, 0xae, 0x08, 0x96, 0x29, 0xbe,
	0xbf, 0x7c, 0xe3, 0x26, 0x3e, 0x79, 0xf6, 0x07, 0xab, 0xc2, 0x8f, 0x9d, 0xb6, 0x3d, 0xec, 0xea,
	0x86, 0xe9, 0x5f, 0x62, 0xd5, 0xe0, 0x13, 0x55, 0x40, 0xe6, 0x26, 0x1a, 0x75, 0x75, 0xc7, 0xd5,
	0xd8, 0xeb, 0xd2, 0xaf, 0xfe, 0x5c, 0x30, 0x4b, 0xf0, 0xf4, 0xcc, 0xb7, 0x83, 0xa7, 0xa7, 0x9a,
	0xe1, 0x3e, 0x2d, 0xe6, 0xc2, 0x84, 0xca, 0xef, 0x42, 0x10, 0xe3, 0x13, 0xb2, 0x67, 0x59, 0xab,
	0x5d, 0x6a, 0x57, 0xe7, 0x9e, 0x65, 0x29, 0x48, 0x34, 0xab, 0x8d, 0xca, 0x49, 0xe3, 0x89, 0x1c,
	0x42, 0x19, 0x80, 0x56, 0xb5, 0x7d, 0xde, 0xd4, 0x2a, 0x67, 0x8d, 0xaa, 0x9c, 0x64, 0x4a, 0xf5,
	0xbc, 0xd1, 0x60, 0xca, 0x30, 0x42, 0x90, 0x29, 0x97, 0x1a, 0xe5, 0x6a, 0x5d, 0x0b, 0x1c, 0x22,
	0x53, 0xb2, 0x56, 0xbb, 0xa4, 0xb6, 0xab, 0x15, 0x39, 0x81, 0xd2, 0x20, 0x09, 0x59, 0xbd, 0x5a,
	0x11, 0xcf, 0x39, 0x1e, 0x6d, 0xfa, 0x39, 0xa7, 0x54, 0x38, 0x36, 0x2a, 0xbe, 0xc0, 0x0e, 0xb6,
	0xba, 0x18, 0xbd, 0xcd, 0xf9, 0x3f, 0xc0, 0x5d, 0x57, 0x33, 0x7a, 0x3e, 0x32, 0x92, 0x2f, 0x39,
	0xe9, 0xa1, 0x37, 0x20, 0x3e, 0x20, 0x1d, 0x6d, 0x82, 0x48, 0x6c, 0x40, 0x3a, 0x27, 0x3d, 0xe5,
	0xcf, 0x71, 0x88, 0xb0, 0xee, 0x51, 0x01, 0xc9, 0x09, 0x42, 0x71, 0xe7, 0x54, 0xf1, 0xc1, 0x4a,
	0x24, 0x26, 0x13, 0xab, 0xd7, 0x8e, 0x2c, 0x8a, 0x1d, 0x90, 0xc5, 0x6f, 0x2d, 0xab, 0xa3, 0x4c,
	0xa8, 0xa5, 0x5e, 0x3b, 0xb2, 0x0e, 0x75, 0xc9, 0x1f, 0x65, 0xda, 0x80, 0x74, 0x78, 0x4b, 0x59,
	0xd9, 0xa1, 0x26, 0x0f, 0x38, 0xd6, 0xa1, 0x2e, 0x27, 0x8f, 0xd9, 0x12, 0x48, 0x94, 0x9d, 0x23,
	0x3c, 0x48, 0x94, 0x07, 0x51, 0xd6, 0x3f, 0x22, 0x6a, 0x5b, 0x6a, 0x92, 0x06, 0x97, 0xf1, 0x27,
	0x90, 0xb2, 0xc7, 0xd7, 0x41, 0x62, 0x3c, 0xc8, 0x37, 0x36, 0xb9, 0xba, 0xd6, 0xb6, 0x54, 0xf0,
	0x5d, 0x59, 0xa0, 0x1f, 0x41, 0x92, 0x5f, 0x91, 0x59, 0x14, 0x41, 0xc0, 0x77, 0xd7, 0xde, 0x73,
	0x6a, 0x5b, 0x6a, 0xe2, 0xd2, 0xbf, 0x2a, 0x1e, 0x42, 0xc2, 0x36, 0xfa, 0xdc, 0x5d, 0xb4, 0x97,
	0xdd, 0x75, 0x8d, 0xad, 0xb6, 0xa5, 0xc6, 0x6d, 0x71, 0x30, 0xfc, 0x18, 0xd2, 0x62, 0x0d, 0xf4,
	0xca, 0xe4, 0x21, 0xee, 0xf0, 0x10, 0xef, 0x6d, 0x74, 0xfe, 0xd6, 0xb6, 0xd4, 0x14, 0x9d, 0xba,
	0x9e, 0x1c, 0x42, 0x9c, 0xf2, 0x1a, 0xf4, 0xaf, 0xdb, 0xf7, 0x37, 0x28, 0x57, 0xd5, 0x77, 0x41,
	0xa7, 0x90, 0x11, 0x23, 0xed, 0xd2, 0xa0, 0x2e, 0x71, 0xc6, 0xd9, 0x34, 0x6f, 0xd3, 0x1b, 0x05,
	0x49, 0x0b, 0xd7, 0x9a, 0xf0, 0x44, 0x87, 0x90, 0xf3, 0x7f, 0x08, 0x22, 0x9e, 0x6b, 0x7b, 0xae,
	0xe6, 0x60, 0x4a, 0x3c, 0xa7, 0x2b, 0x8e, 0xbe, 0x1d, 0xce, 0xf1, 0xaf, 0x0b, 0x8b, 0x33, 0x6e,
	0xa0, 0xfa, 0x7a, 0x76, 0x06, 0x7e, 0x08, 0x59, 0xdf, 0x99, 0x9d, 0x54, 0x0e, 0x31, 0x79, 0x93,
	0xa7, 0xdc, 0x75, 0x9b, 0xbb, 0xbe, 0x21, 0xf4, 0x65, 0xa1, 0x66, 0xed, 0x9e, 0x9e, 0x3b, 0xc6,
	0x11, 0x40, 0xd2, 0x1d, 0xdb, 0x1c, 0x48, 0xe5, 0x05, 0xc8, 0x2d, 0xaf, 0x33, 0x34, 0x5c, 0x5e,
	0x0d, 0x57, 0x1e, 0xa6, 0xee, 0xba, 0x22, 0x7c, 0x13, 0xe2, 0x0e, 0xee, 0x1b, 0xc4, 0xe2, 0xac,
	0x96, 0x54, 0xff, 0x0b, 0x15, 0x20, 0xc2, 0x80, 0x11, 0x15, 0xf3, 0xf6, 0xea, 0xba, 0x63, 0x96,
	0xca, 0xcf, 0x21, 0xfd, 0x04, 0xff, 0x1f, 0x26, 0x5e, 0xd2, 0x15, 0xfe, 0x19, 0x86, 0x6d, 0x76,
	0xcc, 0x9f, 0x92, 0x0e, 0xbd, 0xf5, 0x0c, 0xf1, 0x99, 0x19, 0xee, 0x81, 0x64, 0xeb, 0x7d, 0xac,
	0x51, 0xe3, 0x85, 0x38, 0x6b, 0x62, 0x6a, 0x92, 0x09, 0x5a, 0xc6, 0x0b, 0xd1, 0xb3, 0x98, 0xd2,
	0x25, 0xcf, 0x71, 0x90, 0x1a, 0x37, 0x6f, 0x33, 0xc1, 0xc2, 0x71, 0x13, 0x5d, 0x3c, 0x6e, 0x30,
	0xec, 0xb0, 0x05, 0x88, 0x36, 0x3f, 0xd4, 0xdd, 0xee, 0x25, 0x76, 0x78, 0xa1, 0x66, 0x8a, 0xdf,
	0x5f, 0x71, 0x04, 0xcf, 0xae, 0x2d, 0x60, 0x19, 0xfe, 0x89, 0x08, 0xa0, 0x6e, 0x0f, 0x66, 0x05,
	0xca, 0x23, 0xd8, 0x9e, 0xb3, 0x09, 0x7e, 0x8c, 0xdb, 0x42, 0x00, 0xf1, 0x52, 0xb9, 0x7d, 0xf2,
	0xb4, 0x2a, 0xba, 0x7f, 0xe3, 0xac, 0xa1, 0xf9, 0xdf, 0x61, 0x65, 0x08, 0xf2, 0xf5, 0x5c, 0xd4,
	0x26, 0x16, 0xc5, 0x68, 0x1f, 0xa2, 0x03, 0xd2, 0x11, 0x4f, 0xc3, 0xb5, 0x68, 0x73, 0x53, 0xf4,
	0x00, 0xb6, 0x2d, 0xfc, 0x0b, 0x57, 0x9b, 0xda, 0x2c, 0x81, 0x57, 0x9a, 0x89, 0x9b, 0xc1, 0x86,
	0x29, 0xcf, 0x40, 0x2e, 0xeb, 0x56, 0x17, 0x9b, 0x9f, 0x19, 0x33, 0x9e, 0x81, 0x5c, 0xc1, 0x26,
	0x76, 0xf1, 0x67, 0x35, 0x43, 0xf1, 0xf7, 0x71, 0x48, 0x9f, 0x92, 0x8e, 0x5f, 0x79, 0x26, 0x76,
	0xd0, 0x1f, 0x42, 0x20, 0x4d, 0x2a, 0x0d, 0x3d, 0x5c, 0xd1, 0xb7, 0xe6, 0xca, 0x31, 0xb7, 0x7a,
	0x73, 0x95, 0xd2, 0x2f, 0xff, 0xf5, 0xdf, 0xdf, 0x86, 0x0f, 0x95, 0x47, 0x85, 0xd1, 0x7e, 0xc1,
	0x4f, 0x98, 0x16, 0x5e, 0x5e, 0x2f, 0xe6, 0x55, 0x41, 0xe4, 0x4a, 0x0b, 0x2f, 0xc5, 0xe0, 0x15,
	0xff, 0x4d, 0xfc, 0x80, 0xf2, 0x89, 0x0e, 0x42, 0x0f, 0xd1, 0x6f, 0x42, 0x10, 0x17, 0x95, 0x88,
	0x56, 0x5c, 0xf9, 0x66, 0x6a, 0x75, 0x5d, 0x56, 0x1f, 0xf3, 0xac, 0x0e, 0xd0, 0xe3, 0x5b, 0x66,
	0x55, 0x78, 0x29, 0xb6, 0xf3, 0x15, 0xfa, 0x63, 0x08, 0x92, 0x01, 0xed, 0xd0, 0xfb, 0x1b, 0x97,
	0x41, 0xee, 0xe1, 0x26, 0xa6, 0x82, 0xc5, 0xca, 0x87, 0x3c, 0xcb, 0x7d, 0x54, 0xb8, 0x65, 0x96,
	0xe8, 0x4f, 0x21, 0x90, 0x26, 0x24, 0x5d, 0x85, 0xe6, 0x3c, 0x93, 0xd7, 0xed, 0xdb, 0x29, 0xcf,
	0xa8, 0xa2, 0x7c, 0xf4, 0x69, 0xf7, 0xed, 0xa0, 0xcb, 0x67, 0x64, 0xb0, 0xfe, 0x3a, 0x04, 0xd2,
	0x84, 0xe7, 0xab, 0x92, 0x9c, 0x2f, 0x86, 0xdc, 0x9b, 0x0b, 0x37, 0xcb, 0xea, 0xd0, 0x76, 0xc7,
	0x01, 0xaa, 0x0f, 0x3f, 0x35, 0xaa, 0x47, 0x43, 0x78, 0xab, 0x4b, 0x86, 0x4b, 0x53, 0x39, 0x62,
	0x77, 0x6a, 0xda, 0x64, 0xb3, 0x36, 0x43, 0x3f, 0xfb, 0xd8, 0x37, 0xeb, 0x13, 0x53, 0xb7, 0xfa,
	0x79, 0xe2, 0xf4, 0x0b, 0x7d, 0x6c, 0xf1, 0x9c, 0x0a, 0x42, 0xa5, 0xdb, 0x06, 0x5d, 0xfc, 0x9f,
	0xcf, 0x61, 0x30, 0xee, 0xc4, 0xb9, 0xf1, 0x07, 0xff, 0x0b, 0x00, 0x00, 0xff, 0xff, 0xaf, 0x59,
	0x9b, 0xa1, 0x1f, 0x1a, 0x00, 0x00,
}
