# Examples

Simple functions:

* **[add](add):** Add two numbers. The "Hello World!" of `avo`.
* **[sum](sum):** Sum an array of numbers.

Features:

* **[args](args):** Loading function arguments.
* **[returns](returns):** Building return values.
* **[complex](complex):** Working with `complex{64,128}` types.
* **[data](data):** Defining `DATA` sections.
* **[ext](ext):** Interacting with types from external packages.
* **[pragma](pragma):** Apply compiler directives to generated functions.

"Real" examples:

* **[fnv1a](fnv1a):** [FNV-1a](https://en.wikipedia.org/wiki/Fowler%E2%80%93Noll%E2%80%93Vo_hash_function#FNV-1a_hash) hash function.
* **[dot](dot):** Vector dot product.
* **[geohash](geohash):** Integer [geohash](https://en.wikipedia.org/wiki/Geohash) encoding.
* **[sha1](sha1):** [SHA-1](https://en.wikipedia.org/wiki/SHA-1) cryptographic hash.
* **[stadtx](stadtx):** [`StadtX` hash](https://github.com/demerphq/BeagleHash) port from [dgryski/go-stadtx](https://github.com/dgryski/go-stadtx).
