[<img src="https://raw.githubusercontent.com/erikras/redux-form/master/logo.png" align="right" class="logo" height="100" width="165"/>](http://erikras.github.io/redux-form/)

# redux-form

---

[![NPM Version](https://img.shields.io/npm/v/redux-form.svg?style=flat)](https://www.npmjs.com/package/redux-form)
[![NPM Downloads](https://img.shields.io/npm/dm/redux-form.svg?style=flat)](https://www.npmjs.com/package/redux-form)
[![Build Status](https://img.shields.io/travis/erikras/redux-form/v6.svg?style=flat)](https://travis-ci.org/erikras/redux-form)
[![codecov.io](https://codecov.io/gh/erikras/redux-form/branch/master/graph/badge.svg)](https://codecov.io/gh/erikras/redux-form)
[![Code Climate](https://codeclimate.com/github/erikras/redux-form/badges/gpa.svg)](https://codeclimate.com/github/erikras/redux-form)
[![styled with prettier](https://img.shields.io/badge/styled_with-prettier-ff69b4.svg)](https://github.com/prettier/prettier)
[![PayPal donate button](http://img.shields.io/paypal/donate.png?color=yellowgreen)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=3QQPTMLGV6GU2)
[![Twitter URL](https://img.shields.io/twitter/url/https/github.com/erikras/redux-form.svg?style=social)](https://twitter.com/intent/tweet?text=With%20@ReduxForm,%20I%20can%20keep%20all%20my%20form%20state%20in%20Redux!%20Thanks,%20@erikras!)
[![Patreon](https://img.shields.io/badge/patreon-support%20the%20author-blue.svg)](https://www.patreon.com/erikras)

`redux-form` works with [React Redux](https://github.com/rackt/react-redux) to
enable an html form in [React](https://github.com/facebook/react) to use
[Redux](https://github.com/rackt/redux) to store all of its state.
[![Beerpay](https://beerpay.io/erikras/redux-form/badge.svg)](https://beerpay.io/erikras/redux-form)

## Sponsorship

Redux-form is proudly sponsored by [Rollbar](https://codesponsor.io/t/c/07f83dcd8b17080d225df0abb69cdd0a/). They provide real-time error monitoring, alerting, and analytics for developers. [Try Rollbar for free](https://codesponsor.io/t/c/07f83dcd8b17080d225df0abb69cdd0a/).

![](https://codesponsor.io/t/l/07f83dcd8b17080d225df0abb69cdd0a/pixel.png)

## Installation

`npm install --save redux-form`

## Documentation

* [Getting Started](https://redux-form.com/7.2.3/docs/GettingStarted.md/)
* [Examples](https://redux-form.com/7.2.3/examples/)
* [API](https://redux-form.com/7.2.3/docs/api/)
* [FAQ](https://redux-form.com/7.2.3/docs/faq/)
* [Release Notes](https://github.com/erikras/redux-form/releases)
* [Older Documentation](https://redux-form.com/7.2.3/docs/DocumentationVersions.md/)

## 🏖 Code Sandboxes 🏖

You can play around with `redux-form` in these sandbox versions of the Examples.

* [Simple Form](https://codesandbox.io/s/mZRjw05yp)
* [Synchronous Validation](https://codesandbox.io/s/pQj03w7Y6)
* [Field-Level Validation](https://codesandbox.io/s/PNQYw1kVy)
* [Submit Validation](https://codesandbox.io/s/XoA5vXDgA)
* [Asynchronous Blur Validation](https://codesandbox.io/s/nKlYo387)
* [Initializing From State](https://codesandbox.io/s/MQnD536Km)
* [Field Arrays](https://codesandbox.io/s/Ww4QG1Wx)
* [Remote Submit](https://codesandbox.io/s/ElYvJR21K)
* [Normalizing](https://codesandbox.io/s/L8KWERjDw)
* [Immutable JS](https://codesandbox.io/s/ZVGJQBJMw)
* [Selecting Form Values](https://codesandbox.io/s/gJOBWZMRZ)
* [Wizard Form](https://codesandbox.io/s/0Qzz3843)

## Videos

| [![A Practical Guide to Redux Form – React Alicante 2017](docs/ReactAlicante2017.gif)](https://youtu.be/ey7H8h4ERHg) |
| :------------------------------------------------------------------------------------------------------------------: |
|                              **A Practical Guide to Redux Form – React Alicante 2017**                               |

| [![Abstracting Form State with Redux Form – JS Channel 2016](docs/JSChannel2016.gif)](https://youtu.be/eDTi7lYR1VU) |
| :-----------------------------------------------------------------------------------------------------------------: |
|                            **Abstracting Form State with Redux Form – JS Channel 2016**                             |
