// dnstap: flexible, structured event replication format for DNS software
//
// This file contains the protobuf schemas for the "dnstap" structured event
// replication format for DNS software.

// Written in 2013-2014 by Farsight Security, Inc.
//
// To the extent possible under law, the author(s) have dedicated all
// copyright and related and neighboring rights to this file to the public
// domain worldwide. This file is distributed without any warranty.
//
// You should have received a copy of the CC0 Public Domain Dedication along
// with this file. If not, see:
//
// <http://creativecommons.org/publicdomain/zero/1.0/>.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        (unknown)
// source: dnstap.proto

package dnstap

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// SocketFamily: the network protocol family of a socket. This specifies how
// to interpret "network address" fields.
type SocketFamily int32

const (
	SocketFamily_INET  SocketFamily = 1 // IPv4 (RFC 791)
	SocketFamily_INET6 SocketFamily = 2 // IPv6 (RFC 2460)
)

// Enum value maps for SocketFamily.
var (
	SocketFamily_name = map[int32]string{
		1: "INET",
		2: "INET6",
	}
	SocketFamily_value = map[string]int32{
		"INET":  1,
		"INET6": 2,
	}
)

func (x SocketFamily) Enum() *SocketFamily {
	p := new(SocketFamily)
	*p = x
	return p
}

func (x SocketFamily) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SocketFamily) Descriptor() protoreflect.EnumDescriptor {
	return file_dnstap_proto_enumTypes[0].Descriptor()
}

func (SocketFamily) Type() protoreflect.EnumType {
	return &file_dnstap_proto_enumTypes[0]
}

func (x SocketFamily) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *SocketFamily) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = SocketFamily(num)
	return nil
}

// Deprecated: Use SocketFamily.Descriptor instead.
func (SocketFamily) EnumDescriptor() ([]byte, []int) {
	return file_dnstap_proto_rawDescGZIP(), []int{0}
}

// SocketProtocol: the protocol used to transport a DNS message.
type SocketProtocol int32

const (
	SocketProtocol_UDP SocketProtocol = 1 // DNS over UDP transport (RFC 1035 section 4.2.1)
	SocketProtocol_TCP SocketProtocol = 2 // DNS over TCP transport (RFC 1035 section 4.2.2)
	SocketProtocol_DOT SocketProtocol = 3 // DNS over TLS (RFC 7858)
	SocketProtocol_DOH SocketProtocol = 4 // DNS over HTTPS (RFC 8484)
)

// Enum value maps for SocketProtocol.
var (
	SocketProtocol_name = map[int32]string{
		1: "UDP",
		2: "TCP",
		3: "DOT",
		4: "DOH",
	}
	SocketProtocol_value = map[string]int32{
		"UDP": 1,
		"TCP": 2,
		"DOT": 3,
		"DOH": 4,
	}
)

func (x SocketProtocol) Enum() *SocketProtocol {
	p := new(SocketProtocol)
	*p = x
	return p
}

func (x SocketProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SocketProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_dnstap_proto_enumTypes[1].Descriptor()
}

func (SocketProtocol) Type() protoreflect.EnumType {
	return &file_dnstap_proto_enumTypes[1]
}

func (x SocketProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *SocketProtocol) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = SocketProtocol(num)
	return nil
}

// Deprecated: Use SocketProtocol.Descriptor instead.
func (SocketProtocol) EnumDescriptor() ([]byte, []int) {
	return file_dnstap_proto_rawDescGZIP(), []int{1}
}

// Identifies which field below is filled in.
type Dnstap_Type int32

const (
	Dnstap_MESSAGE Dnstap_Type = 1
)

// Enum value maps for Dnstap_Type.
var (
	Dnstap_Type_name = map[int32]string{
		1: "MESSAGE",
	}
	Dnstap_Type_value = map[string]int32{
		"MESSAGE": 1,
	}
)

func (x Dnstap_Type) Enum() *Dnstap_Type {
	p := new(Dnstap_Type)
	*p = x
	return p
}

func (x Dnstap_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Dnstap_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_dnstap_proto_enumTypes[2].Descriptor()
}

func (Dnstap_Type) Type() protoreflect.EnumType {
	return &file_dnstap_proto_enumTypes[2]
}

func (x Dnstap_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Dnstap_Type) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Dnstap_Type(num)
	return nil
}

// Deprecated: Use Dnstap_Type.Descriptor instead.
func (Dnstap_Type) EnumDescriptor() ([]byte, []int) {
	return file_dnstap_proto_rawDescGZIP(), []int{0, 0}
}

type Message_Type int32

const (
	// AUTH_QUERY is a DNS query message received from a resolver by an
	// authoritative name server, from the perspective of the authoritative
	// name server.
	Message_AUTH_QUERY Message_Type = 1
	// AUTH_RESPONSE is a DNS response message sent from an authoritative
	// name server to a resolver, from the perspective of the authoritative
	// name server.
	Message_AUTH_RESPONSE Message_Type = 2
	// RESOLVER_QUERY is a DNS query message sent from a resolver to an
	// authoritative name server, from the perspective of the resolver.
	// Resolvers typically clear the RD (recursion desired) bit when
	// sending queries.
	Message_RESOLVER_QUERY Message_Type = 3
	// RESOLVER_RESPONSE is a DNS response message received from an
	// authoritative name server by a resolver, from the perspective of
	// the resolver.
	Message_RESOLVER_RESPONSE Message_Type = 4
	// CLIENT_QUERY is a DNS query message sent from a client to a DNS
	// server which is expected to perform further recursion, from the
	// perspective of the DNS server. The client may be a stub resolver or
	// forwarder or some other type of software which typically sets the RD
	// (recursion desired) bit when querying the DNS server. The DNS server
	// may be a simple forwarding proxy or it may be a full recursive
	// resolver.
	Message_CLIENT_QUERY Message_Type = 5
	// CLIENT_RESPONSE is a DNS response message sent from a DNS server to
	// a client, from the perspective of the DNS server. The DNS server
	// typically sets the RA (recursion available) bit when responding.
	Message_CLIENT_RESPONSE Message_Type = 6
	// FORWARDER_QUERY is a DNS query message sent from a downstream DNS
	// server to an upstream DNS server which is expected to perform
	// further recursion, from the perspective of the downstream DNS
	// server.
	Message_FORWARDER_QUERY Message_Type = 7
	// FORWARDER_RESPONSE is a DNS response message sent from an upstream
	// DNS server performing recursion to a downstream DNS server, from the
	// perspective of the downstream DNS server.
	Message_FORWARDER_RESPONSE Message_Type = 8
	// STUB_QUERY is a DNS query message sent from a stub resolver to a DNS
	// server, from the perspective of the stub resolver.
	Message_STUB_QUERY Message_Type = 9
	// STUB_RESPONSE is a DNS response message sent from a DNS server to a
	// stub resolver, from the perspective of the stub resolver.
	Message_STUB_RESPONSE Message_Type = 10
	// TOOL_QUERY is a DNS query message sent from a DNS software tool to a
	// DNS server, from the perspective of the tool.
	Message_TOOL_QUERY Message_Type = 11
	// TOOL_RESPONSE is a DNS response message received by a DNS software
	// tool from a DNS server, from the perspective of the tool.
	Message_TOOL_RESPONSE Message_Type = 12
	// UPDATE_QUERY is a DNS update query message received from a resolver
	// by an authoritative name server, from the perspective of the
	// authoritative name server.
	Message_UPDATE_QUERY Message_Type = 13
	// UPDATE_RESPONSE is a DNS update response message sent from an
	// authoritative name server to a resolver, from the perspective of the
	// authoritative name server.
	Message_UPDATE_RESPONSE Message_Type = 14
)

// Enum value maps for Message_Type.
var (
	Message_Type_name = map[int32]string{
		1:  "AUTH_QUERY",
		2:  "AUTH_RESPONSE",
		3:  "RESOLVER_QUERY",
		4:  "RESOLVER_RESPONSE",
		5:  "CLIENT_QUERY",
		6:  "CLIENT_RESPONSE",
		7:  "FORWARDER_QUERY",
		8:  "FORWARDER_RESPONSE",
		9:  "STUB_QUERY",
		10: "STUB_RESPONSE",
		11: "TOOL_QUERY",
		12: "TOOL_RESPONSE",
		13: "UPDATE_QUERY",
		14: "UPDATE_RESPONSE",
	}
	Message_Type_value = map[string]int32{
		"AUTH_QUERY":         1,
		"AUTH_RESPONSE":      2,
		"RESOLVER_QUERY":     3,
		"RESOLVER_RESPONSE":  4,
		"CLIENT_QUERY":       5,
		"CLIENT_RESPONSE":    6,
		"FORWARDER_QUERY":    7,
		"FORWARDER_RESPONSE": 8,
		"STUB_QUERY":         9,
		"STUB_RESPONSE":      10,
		"TOOL_QUERY":         11,
		"TOOL_RESPONSE":      12,
		"UPDATE_QUERY":       13,
		"UPDATE_RESPONSE":    14,
	}
)

func (x Message_Type) Enum() *Message_Type {
	p := new(Message_Type)
	*p = x
	return p
}

func (x Message_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Message_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_dnstap_proto_enumTypes[3].Descriptor()
}

func (Message_Type) Type() protoreflect.EnumType {
	return &file_dnstap_proto_enumTypes[3]
}

func (x Message_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Message_Type) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Message_Type(num)
	return nil
}

// Deprecated: Use Message_Type.Descriptor instead.
func (Message_Type) EnumDescriptor() ([]byte, []int) {
	return file_dnstap_proto_rawDescGZIP(), []int{1, 0}
}

// "Dnstap": this is the top-level dnstap type, which is a "union" type that
// contains other kinds of dnstap payloads, although currently only one type
// of dnstap payload is defined.
// See: https://developers.google.com/protocol-buffers/docs/techniques#union
type Dnstap struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DNS server identity.
	// If enabled, this is the identity string of the DNS server which generated
	// this message. Typically this would be the same string as returned by an
	// "NSID" (RFC 5001) query.
	Identity []byte `protobuf:"bytes,1,opt,name=identity" json:"identity,omitempty"`
	// DNS server version.
	// If enabled, this is the version string of the DNS server which generated
	// this message. Typically this would be the same string as returned by a
	// "version.bind" query.
	Version []byte `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
	// Extra data for this payload.
	// This field can be used for adding an arbitrary byte-string annotation to
	// the payload. No encoding or interpretation is applied or enforced.
	Extra []byte       `protobuf:"bytes,3,opt,name=extra" json:"extra,omitempty"`
	Type  *Dnstap_Type `protobuf:"varint,15,req,name=type,enum=dnstap.Dnstap_Type" json:"type,omitempty"`
	// One of the following will be filled in.
	Message *Message `protobuf:"bytes,14,opt,name=message" json:"message,omitempty"`
}

func (x *Dnstap) Reset() {
	*x = Dnstap{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dnstap_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dnstap) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dnstap) ProtoMessage() {}

func (x *Dnstap) ProtoReflect() protoreflect.Message {
	mi := &file_dnstap_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dnstap.ProtoReflect.Descriptor instead.
func (*Dnstap) Descriptor() ([]byte, []int) {
	return file_dnstap_proto_rawDescGZIP(), []int{0}
}

func (x *Dnstap) GetIdentity() []byte {
	if x != nil {
		return x.Identity
	}
	return nil
}

func (x *Dnstap) GetVersion() []byte {
	if x != nil {
		return x.Version
	}
	return nil
}

func (x *Dnstap) GetExtra() []byte {
	if x != nil {
		return x.Extra
	}
	return nil
}

func (x *Dnstap) GetType() Dnstap_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return Dnstap_MESSAGE
}

func (x *Dnstap) GetMessage() *Message {
	if x != nil {
		return x.Message
	}
	return nil
}

// Message: a wire-format (RFC 1035 section 4) DNS message and associated
// metadata. Applications generating "Message" payloads should follow
// certain requirements based on the MessageType, see below.
type Message struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One of the Type values described above.
	Type *Message_Type `protobuf:"varint,1,req,name=type,enum=dnstap.Message_Type" json:"type,omitempty"`
	// One of the SocketFamily values described above.
	SocketFamily *SocketFamily `protobuf:"varint,2,opt,name=socket_family,json=socketFamily,enum=dnstap.SocketFamily" json:"socket_family,omitempty"`
	// One of the SocketProtocol values described above.
	SocketProtocol *SocketProtocol `protobuf:"varint,3,opt,name=socket_protocol,json=socketProtocol,enum=dnstap.SocketProtocol" json:"socket_protocol,omitempty"`
	// The network address of the message initiator.
	// For SocketFamily INET, this field is 4 octets (IPv4 address).
	// For SocketFamily INET6, this field is 16 octets (IPv6 address).
	QueryAddress []byte `protobuf:"bytes,4,opt,name=query_address,json=queryAddress" json:"query_address,omitempty"`
	// The network address of the message responder.
	// For SocketFamily INET, this field is 4 octets (IPv4 address).
	// For SocketFamily INET6, this field is 16 octets (IPv6 address).
	ResponseAddress []byte `protobuf:"bytes,5,opt,name=response_address,json=responseAddress" json:"response_address,omitempty"`
	// The transport port of the message initiator.
	// This is a 16-bit UDP or TCP port number, depending on SocketProtocol.
	QueryPort *uint32 `protobuf:"varint,6,opt,name=query_port,json=queryPort" json:"query_port,omitempty"`
	// The transport port of the message responder.
	// This is a 16-bit UDP or TCP port number, depending on SocketProtocol.
	ResponsePort *uint32 `protobuf:"varint,7,opt,name=response_port,json=responsePort" json:"response_port,omitempty"`
	// The time at which the DNS query message was sent or received, depending
	// on whether this is an AUTH_QUERY, RESOLVER_QUERY, or CLIENT_QUERY.
	// This is the number of seconds since the UNIX epoch.
	QueryTimeSec *uint64 `protobuf:"varint,8,opt,name=query_time_sec,json=queryTimeSec" json:"query_time_sec,omitempty"`
	// The time at which the DNS query message was sent or received.
	// This is the seconds fraction, expressed as a count of nanoseconds.
	QueryTimeNsec *uint32 `protobuf:"fixed32,9,opt,name=query_time_nsec,json=queryTimeNsec" json:"query_time_nsec,omitempty"`
	// The initiator's original wire-format DNS query message, verbatim.
	QueryMessage []byte `protobuf:"bytes,10,opt,name=query_message,json=queryMessage" json:"query_message,omitempty"`
	// The "zone" or "bailiwick" pertaining to the DNS query message.
	// This is a wire-format DNS domain name.
	QueryZone []byte `protobuf:"bytes,11,opt,name=query_zone,json=queryZone" json:"query_zone,omitempty"`
	// The time at which the DNS response message was sent or received,
	// depending on whether this is an AUTH_RESPONSE, RESOLVER_RESPONSE, or
	// CLIENT_RESPONSE.
	// This is the number of seconds since the UNIX epoch.
	ResponseTimeSec *uint64 `protobuf:"varint,12,opt,name=response_time_sec,json=responseTimeSec" json:"response_time_sec,omitempty"`
	// The time at which the DNS response message was sent or received.
	// This is the seconds fraction, expressed as a count of nanoseconds.
	ResponseTimeNsec *uint32 `protobuf:"fixed32,13,opt,name=response_time_nsec,json=responseTimeNsec" json:"response_time_nsec,omitempty"`
	// The responder's original wire-format DNS response message, verbatim.
	ResponseMessage []byte `protobuf:"bytes,14,opt,name=response_message,json=responseMessage" json:"response_message,omitempty"`
}

func (x *Message) Reset() {
	*x = Message{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dnstap_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Message) ProtoMessage() {}

func (x *Message) ProtoReflect() protoreflect.Message {
	mi := &file_dnstap_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Message.ProtoReflect.Descriptor instead.
func (*Message) Descriptor() ([]byte, []int) {
	return file_dnstap_proto_rawDescGZIP(), []int{1}
}

func (x *Message) GetType() Message_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return Message_AUTH_QUERY
}

func (x *Message) GetSocketFamily() SocketFamily {
	if x != nil && x.SocketFamily != nil {
		return *x.SocketFamily
	}
	return SocketFamily_INET
}

func (x *Message) GetSocketProtocol() SocketProtocol {
	if x != nil && x.SocketProtocol != nil {
		return *x.SocketProtocol
	}
	return SocketProtocol_UDP
}

func (x *Message) GetQueryAddress() []byte {
	if x != nil {
		return x.QueryAddress
	}
	return nil
}

func (x *Message) GetResponseAddress() []byte {
	if x != nil {
		return x.ResponseAddress
	}
	return nil
}

func (x *Message) GetQueryPort() uint32 {
	if x != nil && x.QueryPort != nil {
		return *x.QueryPort
	}
	return 0
}

func (x *Message) GetResponsePort() uint32 {
	if x != nil && x.ResponsePort != nil {
		return *x.ResponsePort
	}
	return 0
}

func (x *Message) GetQueryTimeSec() uint64 {
	if x != nil && x.QueryTimeSec != nil {
		return *x.QueryTimeSec
	}
	return 0
}

func (x *Message) GetQueryTimeNsec() uint32 {
	if x != nil && x.QueryTimeNsec != nil {
		return *x.QueryTimeNsec
	}
	return 0
}

func (x *Message) GetQueryMessage() []byte {
	if x != nil {
		return x.QueryMessage
	}
	return nil
}

func (x *Message) GetQueryZone() []byte {
	if x != nil {
		return x.QueryZone
	}
	return nil
}

func (x *Message) GetResponseTimeSec() uint64 {
	if x != nil && x.ResponseTimeSec != nil {
		return *x.ResponseTimeSec
	}
	return 0
}

func (x *Message) GetResponseTimeNsec() uint32 {
	if x != nil && x.ResponseTimeNsec != nil {
		return *x.ResponseTimeNsec
	}
	return 0
}

func (x *Message) GetResponseMessage() []byte {
	if x != nil {
		return x.ResponseMessage
	}
	return nil
}

var File_dnstap_proto protoreflect.FileDescriptor

var file_dnstap_proto_rawDesc = []byte{
	0x0a, 0x0c, 0x64, 0x6e, 0x73, 0x74, 0x61, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x06,
	0x64, 0x6e, 0x73, 0x74, 0x61, 0x70, 0x22, 0xbd, 0x01, 0x0a, 0x06, 0x44, 0x6e, 0x73, 0x74, 0x61,
	0x70, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x78, 0x74, 0x72, 0x61,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x65, 0x78, 0x74, 0x72, 0x61, 0x12, 0x27, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0f, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x64, 0x6e,
	0x73, 0x74, 0x61, 0x70, 0x2e, 0x44, 0x6e, 0x73, 0x74, 0x61, 0x70, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x29, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x64, 0x6e, 0x73, 0x74, 0x61, 0x70,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x22, 0x13, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x45, 0x53,
	0x53, 0x41, 0x47, 0x45, 0x10, 0x01, 0x22, 0xf2, 0x06, 0x0a, 0x07, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x28, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e,
	0x32, 0x14, 0x2e, 0x64, 0x6e, 0x73, 0x74, 0x61, 0x70, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x39, 0x0a, 0x0d,
	0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x64, 0x6e, 0x73, 0x74, 0x61, 0x70, 0x2e, 0x53, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x52, 0x0c, 0x73, 0x6f, 0x63, 0x6b, 0x65,
	0x74, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x12, 0x3f, 0x0a, 0x0f, 0x73, 0x6f, 0x63, 0x6b, 0x65,
	0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x16, 0x2e, 0x64, 0x6e, 0x73, 0x74, 0x61, 0x70, 0x2e, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x52, 0x0e, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x29, 0x0a,
	0x10, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x24, 0x0a, 0x0e,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x53,
	0x65, 0x63, 0x12, 0x26, 0x0a, 0x0f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x6e, 0x73, 0x65, 0x63, 0x18, 0x09, 0x20, 0x01, 0x28, 0x07, 0x52, 0x0d, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x4e, 0x73, 0x65, 0x63, 0x12, 0x23, 0x0a, 0x0d, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x09, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x2a,
	0x0a, 0x11, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x73, 0x65, 0x63, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x63, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6e, 0x73, 0x65, 0x63,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x07, 0x52, 0x10, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x4e, 0x73, 0x65, 0x63, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x22, 0x95, 0x02, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x0a,
	0x41, 0x55, 0x54, 0x48, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d,
	0x41, 0x55, 0x54, 0x48, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x02, 0x12,
	0x12, 0x0a, 0x0e, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x52, 0x5f, 0x51, 0x55, 0x45, 0x52,
	0x59, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x52, 0x5f,
	0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x4c,
	0x49, 0x45, 0x4e, 0x54, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x05, 0x12, 0x13, 0x0a, 0x0f,
	0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10,
	0x06, 0x12, 0x13, 0x0a, 0x0f, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x51,
	0x55, 0x45, 0x52, 0x59, 0x10, 0x07, 0x12, 0x16, 0x0a, 0x12, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52,
	0x44, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x08, 0x12, 0x0e,
	0x0a, 0x0a, 0x53, 0x54, 0x55, 0x42, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x09, 0x12, 0x11,
	0x0a, 0x0d, 0x53, 0x54, 0x55, 0x42, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10,
	0x0a, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x4f, 0x4f, 0x4c, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10,
	0x0b, 0x12, 0x11, 0x0a, 0x0d, 0x54, 0x4f, 0x4f, 0x4c, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e,
	0x53, 0x45, 0x10, 0x0c, 0x12, 0x10, 0x0a, 0x0c, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x51,
	0x55, 0x45, 0x52, 0x59, 0x10, 0x0d, 0x12, 0x13, 0x0a, 0x0f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45,
	0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x0e, 0x2a, 0x23, 0x0a, 0x0c, 0x53,
	0x6f, 0x63, 0x6b, 0x65, 0x74, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x12, 0x08, 0x0a, 0x04, 0x49,
	0x4e, 0x45, 0x54, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4e, 0x45, 0x54, 0x36, 0x10, 0x02,
	0x2a, 0x34, 0x0a, 0x0e, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x12, 0x07, 0x0a, 0x03, 0x55, 0x44, 0x50, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x54,
	0x43, 0x50, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x44, 0x4f, 0x54, 0x10, 0x03, 0x12, 0x07, 0x0a,
	0x03, 0x44, 0x4f, 0x48, 0x10, 0x04, 0x42, 0x28, 0x5a, 0x26, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x64, 0x6e, 0x73, 0x74, 0x61, 0x70, 0x2f, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2d, 0x64, 0x6e, 0x73, 0x74, 0x61, 0x70, 0x3b, 0x64, 0x6e, 0x73, 0x74, 0x61, 0x70,
}

var (
	file_dnstap_proto_rawDescOnce sync.Once
	file_dnstap_proto_rawDescData = file_dnstap_proto_rawDesc
)

func file_dnstap_proto_rawDescGZIP() []byte {
	file_dnstap_proto_rawDescOnce.Do(func() {
		file_dnstap_proto_rawDescData = protoimpl.X.CompressGZIP(file_dnstap_proto_rawDescData)
	})
	return file_dnstap_proto_rawDescData
}

var file_dnstap_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_dnstap_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_dnstap_proto_goTypes = []interface{}{
	(SocketFamily)(0),   // 0: dnstap.SocketFamily
	(SocketProtocol)(0), // 1: dnstap.SocketProtocol
	(Dnstap_Type)(0),    // 2: dnstap.Dnstap.Type
	(Message_Type)(0),   // 3: dnstap.Message.Type
	(*Dnstap)(nil),      // 4: dnstap.Dnstap
	(*Message)(nil),     // 5: dnstap.Message
}
var file_dnstap_proto_depIdxs = []int32{
	2, // 0: dnstap.Dnstap.type:type_name -> dnstap.Dnstap.Type
	5, // 1: dnstap.Dnstap.message:type_name -> dnstap.Message
	3, // 2: dnstap.Message.type:type_name -> dnstap.Message.Type
	0, // 3: dnstap.Message.socket_family:type_name -> dnstap.SocketFamily
	1, // 4: dnstap.Message.socket_protocol:type_name -> dnstap.SocketProtocol
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_dnstap_proto_init() }
func file_dnstap_proto_init() {
	if File_dnstap_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_dnstap_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Dnstap); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dnstap_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Message); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_dnstap_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_dnstap_proto_goTypes,
		DependencyIndexes: file_dnstap_proto_depIdxs,
		EnumInfos:         file_dnstap_proto_enumTypes,
		MessageInfos:      file_dnstap_proto_msgTypes,
	}.Build()
	File_dnstap_proto = out.File
	file_dnstap_proto_rawDesc = nil
	file_dnstap_proto_goTypes = nil
	file_dnstap_proto_depIdxs = nil
}
