package storage

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/storage/mgmt/2021-09-01/storage"

// AccessPolicy ...
type AccessPolicy struct {
	// StartTime - Start time of the access policy
	StartTime *date.Time `json:"startTime,omitempty"`
	// ExpiryTime - Expiry time of the access policy
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// Permission - List of abbreviated permissions.
	Permission *string `json:"permission,omitempty"`
}

// Account the storage account.
type Account struct {
	autorest.Response `json:"-"`
	// Sku - READ-ONLY; Gets the SKU.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - READ-ONLY; Gets the Kind. Possible values include: 'KindStorage', 'KindStorageV2', 'KindBlobStorage', 'KindFileStorage', 'KindBlockBlobStorage'
	Kind Kind `json:"kind,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// ExtendedLocation - The extendedLocation of the resource.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	// AccountProperties - Properties of the storage account.
	*AccountProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Identity != nil {
		objectMap["identity"] = a.Identity
	}
	if a.ExtendedLocation != nil {
		objectMap["extendedLocation"] = a.ExtendedLocation
	}
	if a.AccountProperties != nil {
		objectMap["properties"] = a.AccountProperties
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Account struct.
func (a *Account) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				a.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				a.Kind = kind
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				a.Identity = &identity
			}
		case "extendedLocation":
			if v != nil {
				var extendedLocation ExtendedLocation
				err = json.Unmarshal(*v, &extendedLocation)
				if err != nil {
					return err
				}
				a.ExtendedLocation = &extendedLocation
			}
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				a.AccountProperties = &accountProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AccountCheckNameAvailabilityParameters the parameters used to check the availability of the storage
// account name.
type AccountCheckNameAvailabilityParameters struct {
	// Name - The storage account name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, Microsoft.Storage/storageAccounts
	Type *string `json:"type,omitempty"`
}

// AccountCreateParameters the parameters used when creating a storage account.
type AccountCreateParameters struct {
	// Sku - Required. Gets or sets the SKU name.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - Required. Indicates the type of storage account. Possible values include: 'KindStorage', 'KindStorageV2', 'KindBlobStorage', 'KindFileStorage', 'KindBlockBlobStorage'
	Kind Kind `json:"kind,omitempty"`
	// Location - Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
	Location *string `json:"location,omitempty"`
	// ExtendedLocation - Optional. Set the extended location of the resource. If not set, the storage account will be created in Azure main region. Otherwise it will be created in the specified extended location
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	// Tags - Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
	Tags map[string]*string `json:"tags"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// AccountPropertiesCreateParameters - The parameters used to create the storage account.
	*AccountPropertiesCreateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountCreateParameters.
func (acp AccountCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if acp.Sku != nil {
		objectMap["sku"] = acp.Sku
	}
	if acp.Kind != "" {
		objectMap["kind"] = acp.Kind
	}
	if acp.Location != nil {
		objectMap["location"] = acp.Location
	}
	if acp.ExtendedLocation != nil {
		objectMap["extendedLocation"] = acp.ExtendedLocation
	}
	if acp.Tags != nil {
		objectMap["tags"] = acp.Tags
	}
	if acp.Identity != nil {
		objectMap["identity"] = acp.Identity
	}
	if acp.AccountPropertiesCreateParameters != nil {
		objectMap["properties"] = acp.AccountPropertiesCreateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountCreateParameters struct.
func (acp *AccountCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				acp.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				acp.Kind = kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				acp.Location = &location
			}
		case "extendedLocation":
			if v != nil {
				var extendedLocation ExtendedLocation
				err = json.Unmarshal(*v, &extendedLocation)
				if err != nil {
					return err
				}
				acp.ExtendedLocation = &extendedLocation
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				acp.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				acp.Identity = &identity
			}
		case "properties":
			if v != nil {
				var accountPropertiesCreateParameters AccountPropertiesCreateParameters
				err = json.Unmarshal(*v, &accountPropertiesCreateParameters)
				if err != nil {
					return err
				}
				acp.AccountPropertiesCreateParameters = &accountPropertiesCreateParameters
			}
		}
	}

	return nil
}

// AccountImmutabilityPolicyProperties this defines account-level immutability policy properties.
type AccountImmutabilityPolicyProperties struct {
	// ImmutabilityPeriodSinceCreationInDays - The immutability period for the blobs in the container since the policy creation, in days.
	ImmutabilityPeriodSinceCreationInDays *int32 `json:"immutabilityPeriodSinceCreationInDays,omitempty"`
	// State - The ImmutabilityPolicy state defines the mode of the policy. Disabled state disables the policy, Unlocked state allows increase and decrease of immutability retention time and also allows toggling allowProtectedAppendWrites property, Locked state only allows the increase of the immutability retention time. A policy can only be created in a Disabled or Unlocked state and can be toggled between the two states. Only a policy in an Unlocked state can transition to a Locked state which cannot be reverted. Possible values include: 'AccountImmutabilityPolicyStateUnlocked', 'AccountImmutabilityPolicyStateLocked', 'AccountImmutabilityPolicyStateDisabled'
	State AccountImmutabilityPolicyState `json:"state,omitempty"`
	// AllowProtectedAppendWrites - This property can only be changed for disabled and unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
	AllowProtectedAppendWrites *bool `json:"allowProtectedAppendWrites,omitempty"`
}

// AccountInternetEndpoints the URIs that are used to perform a retrieval of a public blob, file, web or
// dfs object via a internet routing endpoint.
type AccountInternetEndpoints struct {
	// Blob - READ-ONLY; Gets the blob endpoint.
	Blob *string `json:"blob,omitempty"`
	// File - READ-ONLY; Gets the file endpoint.
	File *string `json:"file,omitempty"`
	// Web - READ-ONLY; Gets the web endpoint.
	Web *string `json:"web,omitempty"`
	// Dfs - READ-ONLY; Gets the dfs endpoint.
	Dfs *string `json:"dfs,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountInternetEndpoints.
func (aie AccountInternetEndpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AccountKey an access key for the storage account.
type AccountKey struct {
	// KeyName - READ-ONLY; Name of the key.
	KeyName *string `json:"keyName,omitempty"`
	// Value - READ-ONLY; Base 64-encoded value of the key.
	Value *string `json:"value,omitempty"`
	// Permissions - READ-ONLY; Permissions for the key -- read-only or full permissions. Possible values include: 'KeyPermissionRead', 'KeyPermissionFull'
	Permissions KeyPermission `json:"permissions,omitempty"`
	// CreationTime - READ-ONLY; Creation time of the key, in round trip date format.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountKey.
func (ak AccountKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AccountListKeysResult the response from the ListKeys operation.
type AccountListKeysResult struct {
	autorest.Response `json:"-"`
	// Keys - READ-ONLY; Gets the list of storage account keys and their properties for the specified storage account.
	Keys *[]AccountKey `json:"keys,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountListKeysResult.
func (alkr AccountListKeysResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AccountListResult the response from the List Storage Accounts operation.
type AccountListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Gets the list of storage accounts and their properties.
	Value *[]Account `json:"value,omitempty"`
	// NextLink - READ-ONLY; Request URL that can be used to query next page of storage accounts. Returned when total number of requested storage accounts exceed maximum page size.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountListResult.
func (alr AccountListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AccountListResultIterator provides access to a complete listing of Account values.
type AccountListResultIterator struct {
	i    int
	page AccountListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccountListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountListResultIterator) Response() AccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountListResultIterator) Value() Account {
	if !iter.page.NotDone() {
		return Account{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccountListResultIterator type.
func NewAccountListResultIterator(page AccountListResultPage) AccountListResultIterator {
	return AccountListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AccountListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr AccountListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// accountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AccountListResult) accountListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AccountListResultPage contains a page of Account values.
type AccountListResultPage struct {
	fn  func(context.Context, AccountListResult) (AccountListResult, error)
	alr AccountListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccountListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountListResultPage) Response() AccountListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountListResultPage) Values() []Account {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AccountListResultPage type.
func NewAccountListResultPage(cur AccountListResult, getNextPage func(context.Context, AccountListResult) (AccountListResult, error)) AccountListResultPage {
	return AccountListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// AccountMicrosoftEndpoints the URIs that are used to perform a retrieval of a public blob, queue, table,
// web or dfs object via a microsoft routing endpoint.
type AccountMicrosoftEndpoints struct {
	// Blob - READ-ONLY; Gets the blob endpoint.
	Blob *string `json:"blob,omitempty"`
	// Queue - READ-ONLY; Gets the queue endpoint.
	Queue *string `json:"queue,omitempty"`
	// Table - READ-ONLY; Gets the table endpoint.
	Table *string `json:"table,omitempty"`
	// File - READ-ONLY; Gets the file endpoint.
	File *string `json:"file,omitempty"`
	// Web - READ-ONLY; Gets the web endpoint.
	Web *string `json:"web,omitempty"`
	// Dfs - READ-ONLY; Gets the dfs endpoint.
	Dfs *string `json:"dfs,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountMicrosoftEndpoints.
func (ame AccountMicrosoftEndpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AccountProperties properties of the storage account.
type AccountProperties struct {
	// ProvisioningState - READ-ONLY; Gets the status of the storage account at the time the operation was called. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateResolvingDNS', 'ProvisioningStateSucceeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrimaryEndpoints - READ-ONLY; Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object. Note that Standard_ZRS and Premium_LRS accounts only return the blob endpoint.
	PrimaryEndpoints *Endpoints `json:"primaryEndpoints,omitempty"`
	// PrimaryLocation - READ-ONLY; Gets the location of the primary data center for the storage account.
	PrimaryLocation *string `json:"primaryLocation,omitempty"`
	// StatusOfPrimary - READ-ONLY; Gets the status indicating whether the primary location of the storage account is available or unavailable. Possible values include: 'AccountStatusAvailable', 'AccountStatusUnavailable'
	StatusOfPrimary AccountStatus `json:"statusOfPrimary,omitempty"`
	// LastGeoFailoverTime - READ-ONLY; Gets the timestamp of the most recent instance of a failover to the secondary location. Only the most recent timestamp is retained. This element is not returned if there has never been a failover instance. Only available if the accountType is Standard_GRS or Standard_RAGRS.
	LastGeoFailoverTime *date.Time `json:"lastGeoFailoverTime,omitempty"`
	// SecondaryLocation - READ-ONLY; Gets the location of the geo-replicated secondary for the storage account. Only available if the accountType is Standard_GRS or Standard_RAGRS.
	SecondaryLocation *string `json:"secondaryLocation,omitempty"`
	// StatusOfSecondary - READ-ONLY; Gets the status indicating whether the secondary location of the storage account is available or unavailable. Only available if the SKU name is Standard_GRS or Standard_RAGRS. Possible values include: 'AccountStatusAvailable', 'AccountStatusUnavailable'
	StatusOfSecondary AccountStatus `json:"statusOfSecondary,omitempty"`
	// CreationTime - READ-ONLY; Gets the creation date and time of the storage account in UTC.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// CustomDomain - READ-ONLY; Gets the custom domain the user assigned to this storage account.
	CustomDomain *CustomDomain `json:"customDomain,omitempty"`
	// SasPolicy - READ-ONLY; SasPolicy assigned to the storage account.
	SasPolicy *SasPolicy `json:"sasPolicy,omitempty"`
	// KeyPolicy - READ-ONLY; KeyPolicy assigned to the storage account.
	KeyPolicy *KeyPolicy `json:"keyPolicy,omitempty"`
	// KeyCreationTime - READ-ONLY; Storage account keys creation time.
	KeyCreationTime *KeyCreationTime `json:"keyCreationTime,omitempty"`
	// SecondaryEndpoints - READ-ONLY; Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object from the secondary location of the storage account. Only available if the SKU name is Standard_RAGRS.
	SecondaryEndpoints *Endpoints `json:"secondaryEndpoints,omitempty"`
	// Encryption - READ-ONLY; Encryption settings to be used for server-side encryption for the storage account.
	Encryption *Encryption `json:"encryption,omitempty"`
	// AccessTier - READ-ONLY; Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier is the default value for premium block blobs storage account type and it cannot be changed for the premium block blobs storage account type. Possible values include: 'AccessTierHot', 'AccessTierCool', 'AccessTierPremium'
	AccessTier AccessTier `json:"accessTier,omitempty"`
	// AzureFilesIdentityBasedAuthentication - Provides the identity based authentication settings for Azure Files.
	AzureFilesIdentityBasedAuthentication *AzureFilesIdentityBasedAuthentication `json:"azureFilesIdentityBasedAuthentication,omitempty"`
	// EnableHTTPSTrafficOnly - Allows https traffic only to storage service if sets to true.
	EnableHTTPSTrafficOnly *bool `json:"supportsHttpsTrafficOnly,omitempty"`
	// NetworkRuleSet - READ-ONLY; Network rule set
	NetworkRuleSet *NetworkRuleSet `json:"networkAcls,omitempty"`
	// IsSftpEnabled - Enables Secure File Transfer Protocol, if set to true
	IsSftpEnabled *bool `json:"isSftpEnabled,omitempty"`
	// IsLocalUserEnabled - Enables local users feature, if set to true
	IsLocalUserEnabled *bool `json:"isLocalUserEnabled,omitempty"`
	// IsHnsEnabled - Account HierarchicalNamespace enabled if sets to true.
	IsHnsEnabled *bool `json:"isHnsEnabled,omitempty"`
	// GeoReplicationStats - READ-ONLY; Geo Replication Stats
	GeoReplicationStats *GeoReplicationStats `json:"geoReplicationStats,omitempty"`
	// FailoverInProgress - READ-ONLY; If the failover is in progress, the value will be true, otherwise, it will be null.
	FailoverInProgress *bool `json:"failoverInProgress,omitempty"`
	// LargeFileSharesState - Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled. Possible values include: 'LargeFileSharesStateDisabled', 'LargeFileSharesStateEnabled'
	LargeFileSharesState LargeFileSharesState `json:"largeFileSharesState,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of private endpoint connection associated with the specified storage account
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// RoutingPreference - Maintains information about the network routing choice opted by the user for data transfer
	RoutingPreference *RoutingPreference `json:"routingPreference,omitempty"`
	// BlobRestoreStatus - READ-ONLY; Blob restore status
	BlobRestoreStatus *BlobRestoreStatus `json:"blobRestoreStatus,omitempty"`
	// AllowBlobPublicAccess - Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for this property.
	AllowBlobPublicAccess *bool `json:"allowBlobPublicAccess,omitempty"`
	// MinimumTLSVersion - Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property. Possible values include: 'MinimumTLSVersionTLS10', 'MinimumTLSVersionTLS11', 'MinimumTLSVersionTLS12'
	MinimumTLSVersion MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`
	// AllowSharedKeyAccess - Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If false, then all requests, including shared access signatures, must be authorized with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
	AllowSharedKeyAccess *bool `json:"allowSharedKeyAccess,omitempty"`
	// EnableNfsV3 - NFS 3.0 protocol support enabled if set to true.
	EnableNfsV3 *bool `json:"isNfsV3Enabled,omitempty"`
	// AllowCrossTenantReplication - Allow or disallow cross AAD tenant object replication. The default interpretation is true for this property.
	AllowCrossTenantReplication *bool `json:"allowCrossTenantReplication,omitempty"`
	// DefaultToOAuthAuthentication - A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false for this property.
	DefaultToOAuthAuthentication *bool `json:"defaultToOAuthAuthentication,omitempty"`
	// PublicNetworkAccess - Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// ImmutableStorageWithVersioning - The property is immutable and can only be set to true at the account creation time. When set to true, it enables object level immutability for all the containers in the account by default.
	ImmutableStorageWithVersioning *ImmutableStorageAccount `json:"immutableStorageWithVersioning,omitempty"`
	// AllowedCopyScope - Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet. Possible values include: 'AllowedCopyScopePrivateLink', 'AllowedCopyScopeAAD'
	AllowedCopyScope AllowedCopyScope `json:"allowedCopyScope,omitempty"`
	// StorageAccountSkuConversionStatus - This property is readOnly and is set by server during asynchronous storage account sku conversion operations.
	StorageAccountSkuConversionStatus *AccountSkuConversionStatus `json:"storageAccountSkuConversionStatus,omitempty"`
	// DNSEndpointType - Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier. Possible values include: 'DNSEndpointTypeStandard', 'DNSEndpointTypeAzureDNSZone'
	DNSEndpointType DNSEndpointType `json:"dnsEndpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountProperties.
func (ap AccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.AzureFilesIdentityBasedAuthentication != nil {
		objectMap["azureFilesIdentityBasedAuthentication"] = ap.AzureFilesIdentityBasedAuthentication
	}
	if ap.EnableHTTPSTrafficOnly != nil {
		objectMap["supportsHttpsTrafficOnly"] = ap.EnableHTTPSTrafficOnly
	}
	if ap.IsSftpEnabled != nil {
		objectMap["isSftpEnabled"] = ap.IsSftpEnabled
	}
	if ap.IsLocalUserEnabled != nil {
		objectMap["isLocalUserEnabled"] = ap.IsLocalUserEnabled
	}
	if ap.IsHnsEnabled != nil {
		objectMap["isHnsEnabled"] = ap.IsHnsEnabled
	}
	if ap.LargeFileSharesState != "" {
		objectMap["largeFileSharesState"] = ap.LargeFileSharesState
	}
	if ap.RoutingPreference != nil {
		objectMap["routingPreference"] = ap.RoutingPreference
	}
	if ap.AllowBlobPublicAccess != nil {
		objectMap["allowBlobPublicAccess"] = ap.AllowBlobPublicAccess
	}
	if ap.MinimumTLSVersion != "" {
		objectMap["minimumTlsVersion"] = ap.MinimumTLSVersion
	}
	if ap.AllowSharedKeyAccess != nil {
		objectMap["allowSharedKeyAccess"] = ap.AllowSharedKeyAccess
	}
	if ap.EnableNfsV3 != nil {
		objectMap["isNfsV3Enabled"] = ap.EnableNfsV3
	}
	if ap.AllowCrossTenantReplication != nil {
		objectMap["allowCrossTenantReplication"] = ap.AllowCrossTenantReplication
	}
	if ap.DefaultToOAuthAuthentication != nil {
		objectMap["defaultToOAuthAuthentication"] = ap.DefaultToOAuthAuthentication
	}
	if ap.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = ap.PublicNetworkAccess
	}
	if ap.ImmutableStorageWithVersioning != nil {
		objectMap["immutableStorageWithVersioning"] = ap.ImmutableStorageWithVersioning
	}
	if ap.AllowedCopyScope != "" {
		objectMap["allowedCopyScope"] = ap.AllowedCopyScope
	}
	if ap.StorageAccountSkuConversionStatus != nil {
		objectMap["storageAccountSkuConversionStatus"] = ap.StorageAccountSkuConversionStatus
	}
	if ap.DNSEndpointType != "" {
		objectMap["dnsEndpointType"] = ap.DNSEndpointType
	}
	return json.Marshal(objectMap)
}

// AccountPropertiesCreateParameters the parameters used to create the storage account.
type AccountPropertiesCreateParameters struct {
	// AllowedCopyScope - Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet. Possible values include: 'AllowedCopyScopePrivateLink', 'AllowedCopyScopeAAD'
	AllowedCopyScope AllowedCopyScope `json:"allowedCopyScope,omitempty"`
	// PublicNetworkAccess - Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// SasPolicy - SasPolicy assigned to the storage account.
	SasPolicy *SasPolicy `json:"sasPolicy,omitempty"`
	// KeyPolicy - KeyPolicy assigned to the storage account.
	KeyPolicy *KeyPolicy `json:"keyPolicy,omitempty"`
	// CustomDomain - User domain assigned to the storage account. Name is the CNAME source. Only one custom domain is supported per storage account at this time. To clear the existing custom domain, use an empty string for the custom domain name property.
	CustomDomain *CustomDomain `json:"customDomain,omitempty"`
	// Encryption - Encryption settings to be used for server-side encryption for the storage account.
	Encryption *Encryption `json:"encryption,omitempty"`
	// NetworkRuleSet - Network rule set
	NetworkRuleSet *NetworkRuleSet `json:"networkAcls,omitempty"`
	// AccessTier - Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier is the default value for premium block blobs storage account type and it cannot be changed for the premium block blobs storage account type. Possible values include: 'AccessTierHot', 'AccessTierCool', 'AccessTierPremium'
	AccessTier AccessTier `json:"accessTier,omitempty"`
	// AzureFilesIdentityBasedAuthentication - Provides the identity based authentication settings for Azure Files.
	AzureFilesIdentityBasedAuthentication *AzureFilesIdentityBasedAuthentication `json:"azureFilesIdentityBasedAuthentication,omitempty"`
	// EnableHTTPSTrafficOnly - Allows https traffic only to storage service if sets to true. The default value is true since API version 2019-04-01.
	EnableHTTPSTrafficOnly *bool `json:"supportsHttpsTrafficOnly,omitempty"`
	// IsSftpEnabled - Enables Secure File Transfer Protocol, if set to true
	IsSftpEnabled *bool `json:"isSftpEnabled,omitempty"`
	// IsLocalUserEnabled - Enables local users feature, if set to true
	IsLocalUserEnabled *bool `json:"isLocalUserEnabled,omitempty"`
	// IsHnsEnabled - Account HierarchicalNamespace enabled if sets to true.
	IsHnsEnabled *bool `json:"isHnsEnabled,omitempty"`
	// LargeFileSharesState - Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled. Possible values include: 'LargeFileSharesStateDisabled', 'LargeFileSharesStateEnabled'
	LargeFileSharesState LargeFileSharesState `json:"largeFileSharesState,omitempty"`
	// RoutingPreference - Maintains information about the network routing choice opted by the user for data transfer
	RoutingPreference *RoutingPreference `json:"routingPreference,omitempty"`
	// AllowBlobPublicAccess - Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for this property.
	AllowBlobPublicAccess *bool `json:"allowBlobPublicAccess,omitempty"`
	// MinimumTLSVersion - Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property. Possible values include: 'MinimumTLSVersionTLS10', 'MinimumTLSVersionTLS11', 'MinimumTLSVersionTLS12'
	MinimumTLSVersion MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`
	// AllowSharedKeyAccess - Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If false, then all requests, including shared access signatures, must be authorized with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
	AllowSharedKeyAccess *bool `json:"allowSharedKeyAccess,omitempty"`
	// EnableNfsV3 - NFS 3.0 protocol support enabled if set to true.
	EnableNfsV3 *bool `json:"isNfsV3Enabled,omitempty"`
	// AllowCrossTenantReplication - Allow or disallow cross AAD tenant object replication. The default interpretation is true for this property.
	AllowCrossTenantReplication *bool `json:"allowCrossTenantReplication,omitempty"`
	// DefaultToOAuthAuthentication - A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false for this property.
	DefaultToOAuthAuthentication *bool `json:"defaultToOAuthAuthentication,omitempty"`
	// ImmutableStorageWithVersioning - The property is immutable and can only be set to true at the account creation time. When set to true, it enables object level immutability for all the new containers in the account by default.
	ImmutableStorageWithVersioning *ImmutableStorageAccount `json:"immutableStorageWithVersioning,omitempty"`
	// DNSEndpointType - Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier. Possible values include: 'DNSEndpointTypeStandard', 'DNSEndpointTypeAzureDNSZone'
	DNSEndpointType DNSEndpointType `json:"dnsEndpointType,omitempty"`
}

// AccountPropertiesUpdateParameters the parameters used when updating a storage account.
type AccountPropertiesUpdateParameters struct {
	// CustomDomain - Custom domain assigned to the storage account by the user. Name is the CNAME source. Only one custom domain is supported per storage account at this time. To clear the existing custom domain, use an empty string for the custom domain name property.
	CustomDomain *CustomDomain `json:"customDomain,omitempty"`
	// Encryption - Not applicable. Azure Storage encryption at rest is enabled by default for all storage accounts and cannot be disabled.
	Encryption *Encryption `json:"encryption,omitempty"`
	// SasPolicy - SasPolicy assigned to the storage account.
	SasPolicy *SasPolicy `json:"sasPolicy,omitempty"`
	// KeyPolicy - KeyPolicy assigned to the storage account.
	KeyPolicy *KeyPolicy `json:"keyPolicy,omitempty"`
	// AccessTier - Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier is the default value for premium block blobs storage account type and it cannot be changed for the premium block blobs storage account type. Possible values include: 'AccessTierHot', 'AccessTierCool', 'AccessTierPremium'
	AccessTier AccessTier `json:"accessTier,omitempty"`
	// AzureFilesIdentityBasedAuthentication - Provides the identity based authentication settings for Azure Files.
	AzureFilesIdentityBasedAuthentication *AzureFilesIdentityBasedAuthentication `json:"azureFilesIdentityBasedAuthentication,omitempty"`
	// EnableHTTPSTrafficOnly - Allows https traffic only to storage service if sets to true.
	EnableHTTPSTrafficOnly *bool `json:"supportsHttpsTrafficOnly,omitempty"`
	// IsSftpEnabled - Enables Secure File Transfer Protocol, if set to true
	IsSftpEnabled *bool `json:"isSftpEnabled,omitempty"`
	// IsLocalUserEnabled - Enables local users feature, if set to true
	IsLocalUserEnabled *bool `json:"isLocalUserEnabled,omitempty"`
	// NetworkRuleSet - Network rule set
	NetworkRuleSet *NetworkRuleSet `json:"networkAcls,omitempty"`
	// LargeFileSharesState - Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled. Possible values include: 'LargeFileSharesStateDisabled', 'LargeFileSharesStateEnabled'
	LargeFileSharesState LargeFileSharesState `json:"largeFileSharesState,omitempty"`
	// RoutingPreference - Maintains information about the network routing choice opted by the user for data transfer
	RoutingPreference *RoutingPreference `json:"routingPreference,omitempty"`
	// AllowBlobPublicAccess - Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for this property.
	AllowBlobPublicAccess *bool `json:"allowBlobPublicAccess,omitempty"`
	// MinimumTLSVersion - Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property. Possible values include: 'MinimumTLSVersionTLS10', 'MinimumTLSVersionTLS11', 'MinimumTLSVersionTLS12'
	MinimumTLSVersion MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`
	// AllowSharedKeyAccess - Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If false, then all requests, including shared access signatures, must be authorized with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
	AllowSharedKeyAccess *bool `json:"allowSharedKeyAccess,omitempty"`
	// AllowCrossTenantReplication - Allow or disallow cross AAD tenant object replication. The default interpretation is true for this property.
	AllowCrossTenantReplication *bool `json:"allowCrossTenantReplication,omitempty"`
	// DefaultToOAuthAuthentication - A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false for this property.
	DefaultToOAuthAuthentication *bool `json:"defaultToOAuthAuthentication,omitempty"`
	// PublicNetworkAccess - Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// ImmutableStorageWithVersioning - The property is immutable and can only be set to true at the account creation time. When set to true, it enables object level immutability for all the containers in the account by default.
	ImmutableStorageWithVersioning *ImmutableStorageAccount `json:"immutableStorageWithVersioning,omitempty"`
	// AllowedCopyScope - Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet. Possible values include: 'AllowedCopyScopePrivateLink', 'AllowedCopyScopeAAD'
	AllowedCopyScope AllowedCopyScope `json:"allowedCopyScope,omitempty"`
	// DNSEndpointType - Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier. Possible values include: 'DNSEndpointTypeStandard', 'DNSEndpointTypeAzureDNSZone'
	DNSEndpointType DNSEndpointType `json:"dnsEndpointType,omitempty"`
}

// AccountRegenerateKeyParameters the parameters used to regenerate the storage account key.
type AccountRegenerateKeyParameters struct {
	// KeyName - The name of storage keys that want to be regenerated, possible values are key1, key2, kerb1, kerb2.
	KeyName *string `json:"keyName,omitempty"`
}

// AccountsAbortHierarchicalNamespaceMigrationFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type AccountsAbortHierarchicalNamespaceMigrationFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsAbortHierarchicalNamespaceMigrationFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsAbortHierarchicalNamespaceMigrationFuture.Result.
func (future *AccountsAbortHierarchicalNamespaceMigrationFuture) result(client AccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storage.AccountsAbortHierarchicalNamespaceMigrationFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storage.AccountsAbortHierarchicalNamespaceMigrationFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AccountSasParameters the parameters to list SAS credentials of a storage account.
type AccountSasParameters struct {
	// Services - The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t), File (f). Possible values include: 'ServicesB', 'ServicesQ', 'ServicesT', 'ServicesF'
	Services Services `json:"signedServices,omitempty"`
	// ResourceTypes - The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files. Possible values include: 'SignedResourceTypesS', 'SignedResourceTypesC', 'SignedResourceTypesO'
	ResourceTypes SignedResourceTypes `json:"signedResourceTypes,omitempty"`
	// Permissions - The signed permissions for the account SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). Possible values include: 'PermissionsR', 'PermissionsD', 'PermissionsW', 'PermissionsL', 'PermissionsA', 'PermissionsC', 'PermissionsU', 'PermissionsP'
	Permissions Permissions `json:"signedPermission,omitempty"`
	// IPAddressOrRange - An IP address or a range of IP addresses from which to accept requests.
	IPAddressOrRange *string `json:"signedIp,omitempty"`
	// Protocols - The protocol permitted for a request made with the account SAS. Possible values include: 'HTTPProtocolHttpshttp', 'HTTPProtocolHTTPS'
	Protocols HTTPProtocol `json:"signedProtocol,omitempty"`
	// SharedAccessStartTime - The time at which the SAS becomes valid.
	SharedAccessStartTime *date.Time `json:"signedStart,omitempty"`
	// SharedAccessExpiryTime - The time at which the shared access signature becomes invalid.
	SharedAccessExpiryTime *date.Time `json:"signedExpiry,omitempty"`
	// KeyToSign - The key to sign the account SAS token with.
	KeyToSign *string `json:"keyToSign,omitempty"`
}

// AccountsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (Account, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsCreateFuture.Result.
func (future *AccountsCreateFuture) result(client AccountsClient) (a Account, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storage.AccountsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		a.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storage.AccountsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.CreateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storage.AccountsCreateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AccountsFailoverFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsFailoverFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsFailoverFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsFailoverFuture.Result.
func (future *AccountsFailoverFuture) result(client AccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storage.AccountsFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storage.AccountsFailoverFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AccountsHierarchicalNamespaceMigrationFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type AccountsHierarchicalNamespaceMigrationFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsHierarchicalNamespaceMigrationFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsHierarchicalNamespaceMigrationFuture.Result.
func (future *AccountsHierarchicalNamespaceMigrationFuture) result(client AccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storage.AccountsHierarchicalNamespaceMigrationFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storage.AccountsHierarchicalNamespaceMigrationFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AccountSkuConversionStatus this defines the sku conversion status object for asynchronous sku
// conversions.
type AccountSkuConversionStatus struct {
	// SkuConversionStatus - READ-ONLY; This property indicates the current sku conversion status. Possible values include: 'SkuConversionStatusInProgress', 'SkuConversionStatusSucceeded', 'SkuConversionStatusFailed'
	SkuConversionStatus SkuConversionStatus `json:"skuConversionStatus,omitempty"`
	// TargetSkuName - This property represents the target sku name to which the account sku is being converted asynchronously. Possible values include: 'SkuNameStandardLRS', 'SkuNameStandardGRS', 'SkuNameStandardRAGRS', 'SkuNameStandardZRS', 'SkuNamePremiumLRS', 'SkuNamePremiumZRS', 'SkuNameStandardGZRS', 'SkuNameStandardRAGZRS'
	TargetSkuName SkuName `json:"targetSkuName,omitempty"`
	// StartTime - READ-ONLY; This property represents the sku conversion start time.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; This property represents the sku conversion end time.
	EndTime *string `json:"endTime,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountSkuConversionStatus.
func (ascs AccountSkuConversionStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ascs.TargetSkuName != "" {
		objectMap["targetSkuName"] = ascs.TargetSkuName
	}
	return json.Marshal(objectMap)
}

// AccountsRestoreBlobRangesFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AccountsRestoreBlobRangesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (BlobRestoreStatus, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsRestoreBlobRangesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsRestoreBlobRangesFuture.Result.
func (future *AccountsRestoreBlobRangesFuture) result(client AccountsClient) (brs BlobRestoreStatus, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storage.AccountsRestoreBlobRangesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		brs.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storage.AccountsRestoreBlobRangesFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if brs.Response.Response, err = future.GetResult(sender); err == nil && brs.Response.Response.StatusCode != http.StatusNoContent {
		brs, err = client.RestoreBlobRangesResponder(brs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storage.AccountsRestoreBlobRangesFuture", "Result", brs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AccountUpdateParameters the parameters that can be provided when updating the storage account
// properties.
type AccountUpdateParameters struct {
	// Sku - Gets or sets the SKU name. Note that the SKU name cannot be updated to Standard_ZRS, Premium_LRS or Premium_ZRS, nor can accounts of those SKU names be updated to any other value.
	Sku *Sku `json:"sku,omitempty"`
	// Tags - Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.
	Tags map[string]*string `json:"tags"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// AccountPropertiesUpdateParameters - The parameters used when updating a storage account.
	*AccountPropertiesUpdateParameters `json:"properties,omitempty"`
	// Kind - Optional. Indicates the type of storage account. Currently only StorageV2 value supported by server. Possible values include: 'KindStorage', 'KindStorageV2', 'KindBlobStorage', 'KindFileStorage', 'KindBlockBlobStorage'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountUpdateParameters.
func (aup AccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aup.Sku != nil {
		objectMap["sku"] = aup.Sku
	}
	if aup.Tags != nil {
		objectMap["tags"] = aup.Tags
	}
	if aup.Identity != nil {
		objectMap["identity"] = aup.Identity
	}
	if aup.AccountPropertiesUpdateParameters != nil {
		objectMap["properties"] = aup.AccountPropertiesUpdateParameters
	}
	if aup.Kind != "" {
		objectMap["kind"] = aup.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountUpdateParameters struct.
func (aup *AccountUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				aup.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				aup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				aup.Identity = &identity
			}
		case "properties":
			if v != nil {
				var accountPropertiesUpdateParameters AccountPropertiesUpdateParameters
				err = json.Unmarshal(*v, &accountPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				aup.AccountPropertiesUpdateParameters = &accountPropertiesUpdateParameters
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				aup.Kind = kind
			}
		}
	}

	return nil
}

// ActiveDirectoryProperties settings properties for Active Directory (AD).
type ActiveDirectoryProperties struct {
	// DomainName - Specifies the primary domain that the AD DNS server is authoritative for.
	DomainName *string `json:"domainName,omitempty"`
	// NetBiosDomainName - Specifies the NetBIOS domain name.
	NetBiosDomainName *string `json:"netBiosDomainName,omitempty"`
	// ForestName - Specifies the Active Directory forest to get.
	ForestName *string `json:"forestName,omitempty"`
	// DomainGUID - Specifies the domain GUID.
	DomainGUID *string `json:"domainGuid,omitempty"`
	// DomainSid - Specifies the security identifier (SID).
	DomainSid *string `json:"domainSid,omitempty"`
	// AzureStorageSid - Specifies the security identifier (SID) for Azure Storage.
	AzureStorageSid *string `json:"azureStorageSid,omitempty"`
	// SamAccountName - Specifies the Active Directory SAMAccountName for Azure Storage.
	SamAccountName *string `json:"samAccountName,omitempty"`
	// AccountType - Specifies the Active Directory account type for Azure Storage. Possible values include: 'AccountTypeUser', 'AccountTypeComputer'
	AccountType AccountType `json:"accountType,omitempty"`
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureFilesIdentityBasedAuthentication settings for Azure Files identity based authentication.
type AzureFilesIdentityBasedAuthentication struct {
	// DirectoryServiceOptions - Indicates the directory service used. Possible values include: 'DirectoryServiceOptionsNone', 'DirectoryServiceOptionsAADDS', 'DirectoryServiceOptionsAD'
	DirectoryServiceOptions DirectoryServiceOptions `json:"directoryServiceOptions,omitempty"`
	// ActiveDirectoryProperties - Required if choose AD.
	ActiveDirectoryProperties *ActiveDirectoryProperties `json:"activeDirectoryProperties,omitempty"`
	// DefaultSharePermission - Default share permission for users using Kerberos authentication if RBAC role is not assigned. Possible values include: 'DefaultSharePermissionNone', 'DefaultSharePermissionStorageFileDataSmbShareReader', 'DefaultSharePermissionStorageFileDataSmbShareContributor', 'DefaultSharePermissionStorageFileDataSmbShareElevatedContributor'
	DefaultSharePermission DefaultSharePermission `json:"defaultSharePermission,omitempty"`
}

// BlobContainer properties of the blob container, including Id, resource name, resource type, Etag.
type BlobContainer struct {
	autorest.Response `json:"-"`
	// ContainerProperties - Properties of the blob container.
	*ContainerProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobContainer.
func (bc BlobContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bc.ContainerProperties != nil {
		objectMap["properties"] = bc.ContainerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BlobContainer struct.
func (bc *BlobContainer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var containerProperties ContainerProperties
				err = json.Unmarshal(*v, &containerProperties)
				if err != nil {
					return err
				}
				bc.ContainerProperties = &containerProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bc.Type = &typeVar
			}
		}
	}

	return nil
}

// BlobContainersObjectLevelWormFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BlobContainersObjectLevelWormFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BlobContainersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BlobContainersObjectLevelWormFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BlobContainersObjectLevelWormFuture.Result.
func (future *BlobContainersObjectLevelWormFuture) result(client BlobContainersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storage.BlobContainersObjectLevelWormFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storage.BlobContainersObjectLevelWormFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BlobInventoryPolicy the storage account blob inventory policy.
type BlobInventoryPolicy struct {
	autorest.Response `json:"-"`
	// BlobInventoryPolicyProperties - Returns the storage account blob inventory policy rules.
	*BlobInventoryPolicyProperties `json:"properties,omitempty"`
	SystemData                     *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobInventoryPolicy.
func (bip BlobInventoryPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bip.BlobInventoryPolicyProperties != nil {
		objectMap["properties"] = bip.BlobInventoryPolicyProperties
	}
	if bip.SystemData != nil {
		objectMap["systemData"] = bip.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BlobInventoryPolicy struct.
func (bip *BlobInventoryPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var blobInventoryPolicyProperties BlobInventoryPolicyProperties
				err = json.Unmarshal(*v, &blobInventoryPolicyProperties)
				if err != nil {
					return err
				}
				bip.BlobInventoryPolicyProperties = &blobInventoryPolicyProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				bip.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bip.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bip.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bip.Type = &typeVar
			}
		}
	}

	return nil
}

// BlobInventoryPolicyDefinition an object that defines the blob inventory rule.
type BlobInventoryPolicyDefinition struct {
	// Filters - An object that defines the filter set.
	Filters *BlobInventoryPolicyFilter `json:"filters,omitempty"`
	// Format - This is a required field, it specifies the format for the inventory files. Possible values include: 'FormatCsv', 'FormatParquet'
	Format Format `json:"format,omitempty"`
	// Schedule - This is a required field. This field is used to schedule an inventory formation. Possible values include: 'ScheduleDaily', 'ScheduleWeekly'
	Schedule Schedule `json:"schedule,omitempty"`
	// ObjectType - This is a required field. This field specifies the scope of the inventory created either at the blob or container level. Possible values include: 'ObjectTypeBlob', 'ObjectTypeContainer'
	ObjectType ObjectType `json:"objectType,omitempty"`
	// SchemaFields - This is a required field. This field specifies the fields and properties of the object to be included in the inventory. The Schema field value 'Name' is always required. The valid values for this field for the 'Blob' definition.objectType include 'Name, Creation-Time, Last-Modified, Content-Length, Content-MD5, BlobType, AccessTier, AccessTierChangeTime, AccessTierInferred, Tags, Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, Snapshot, VersionId, IsCurrentVersion, Metadata, LastAccessTime, Tags, Etag, ContentType, ContentEncoding, ContentLanguage, ContentCRC64, CacheControl, ContentDisposition, LeaseStatus, LeaseState, LeaseDuration, ServerEncrypted, Deleted, DeletionId, DeletedTime, RemainingRetentionDays, ImmutabilityPolicyUntilDate, ImmutabilityPolicyMode, LegalHold, CopyId, CopyStatus, CopySource, CopyProgress, CopyCompletionTime, CopyStatusDescription, CustomerProvidedKeySha256, RehydratePriority, ArchiveStatus, XmsBlobSequenceNumber, EncryptionScope, IncrementalCopy, TagCount'. For Blob object type schema field value 'DeletedTime' is applicable only for Hns enabled accounts. The valid values for 'Container' definition.objectType include 'Name, Last-Modified, Metadata, LeaseStatus, LeaseState, LeaseDuration, PublicAccess, HasImmutabilityPolicy, HasLegalHold, Etag, DefaultEncryptionScope, DenyEncryptionScopeOverride, ImmutableStorageWithVersioningEnabled, Deleted, Version, DeletedTime, RemainingRetentionDays'. Schema field values 'Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, DeletionId' are valid only for Hns enabled accounts.Schema field values 'Tags, TagCount' are only valid for Non-Hns accounts.
	SchemaFields *[]string `json:"schemaFields,omitempty"`
}

// BlobInventoryPolicyFilter an object that defines the blob inventory rule filter conditions. For 'Blob'
// definition.objectType all filter properties are applicable, 'blobTypes' is required and others are
// optional. For 'Container' definition.objectType only prefixMatch is applicable and is optional.
type BlobInventoryPolicyFilter struct {
	// PrefixMatch - An array of strings with maximum 10 blob prefixes to be included in the inventory.
	PrefixMatch *[]string `json:"prefixMatch,omitempty"`
	// ExcludePrefix - An array of strings with maximum 10 blob prefixes to be excluded from the inventory.
	ExcludePrefix *[]string `json:"excludePrefix,omitempty"`
	// BlobTypes - An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not support pageBlobs. This field is required when definition.objectType property is set to 'Blob'.
	BlobTypes *[]string `json:"blobTypes,omitempty"`
	// IncludeBlobVersions - Includes blob versions in blob inventory when value is set to true. The definition.schemaFields values 'VersionId and IsCurrentVersion' are required if this property is set to true, else they must be excluded.
	IncludeBlobVersions *bool `json:"includeBlobVersions,omitempty"`
	// IncludeSnapshots - Includes blob snapshots in blob inventory when value is set to true. The definition.schemaFields value 'Snapshot' is required if this property is set to true, else it must be excluded.
	IncludeSnapshots *bool `json:"includeSnapshots,omitempty"`
	// IncludeDeleted - For 'Container' definition.objectType the definition.schemaFields must include 'Deleted, Version, DeletedTime and RemainingRetentionDays'. For 'Blob' definition.objectType and HNS enabled storage accounts the definition.schemaFields must include 'DeletionId, Deleted, DeletedTime and RemainingRetentionDays' and for Hns disabled accounts the definition.schemaFields must include 'Deleted and RemainingRetentionDays', else it must be excluded.
	IncludeDeleted *bool `json:"includeDeleted,omitempty"`
}

// BlobInventoryPolicyProperties the storage account blob inventory policy properties.
type BlobInventoryPolicyProperties struct {
	// LastModifiedTime - READ-ONLY; Returns the last modified date and time of the blob inventory policy.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Policy - The storage account blob inventory policy object. It is composed of policy rules.
	Policy *BlobInventoryPolicySchema `json:"policy,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobInventoryPolicyProperties.
func (bipp BlobInventoryPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bipp.Policy != nil {
		objectMap["policy"] = bipp.Policy
	}
	return json.Marshal(objectMap)
}

// BlobInventoryPolicyRule an object that wraps the blob inventory rule. Each rule is uniquely defined by
// name.
type BlobInventoryPolicyRule struct {
	// Enabled - Rule is enabled when set to true.
	Enabled *bool `json:"enabled,omitempty"`
	// Name - A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
	Name *string `json:"name,omitempty"`
	// Destination - Container name where blob inventory files are stored. Must be pre-created.
	Destination *string `json:"destination,omitempty"`
	// Definition - An object that defines the blob inventory policy rule.
	Definition *BlobInventoryPolicyDefinition `json:"definition,omitempty"`
}

// BlobInventoryPolicySchema the storage account blob inventory policy rules.
type BlobInventoryPolicySchema struct {
	// Enabled - Policy is enabled if set to true.
	Enabled *bool `json:"enabled,omitempty"`
	// Destination - READ-ONLY; Deprecated Property from API version 2021-04-01 onwards, the required destination container name must be specified at the rule level 'policy.rule.destination'
	Destination *string `json:"destination,omitempty"`
	// Type - The valid value is Inventory
	Type *string `json:"type,omitempty"`
	// Rules - The storage account blob inventory policy rules. The rule is applied when it is enabled.
	Rules *[]BlobInventoryPolicyRule `json:"rules,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobInventoryPolicySchema.
func (bips BlobInventoryPolicySchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bips.Enabled != nil {
		objectMap["enabled"] = bips.Enabled
	}
	if bips.Type != nil {
		objectMap["type"] = bips.Type
	}
	if bips.Rules != nil {
		objectMap["rules"] = bips.Rules
	}
	return json.Marshal(objectMap)
}

// BlobRestoreParameters blob restore parameters
type BlobRestoreParameters struct {
	// TimeToRestore - Restore blob to the specified time.
	TimeToRestore *date.Time `json:"timeToRestore,omitempty"`
	// BlobRanges - Blob ranges to restore.
	BlobRanges *[]BlobRestoreRange `json:"blobRanges,omitempty"`
}

// BlobRestoreRange blob range
type BlobRestoreRange struct {
	// StartRange - Blob start range. This is inclusive. Empty means account start.
	StartRange *string `json:"startRange,omitempty"`
	// EndRange - Blob end range. This is exclusive. Empty means account end.
	EndRange *string `json:"endRange,omitempty"`
}

// BlobRestoreStatus blob restore status.
type BlobRestoreStatus struct {
	autorest.Response `json:"-"`
	// Status - READ-ONLY; The status of blob restore progress. Possible values are: - InProgress: Indicates that blob restore is ongoing. - Complete: Indicates that blob restore has been completed successfully. - Failed: Indicates that blob restore is failed. Possible values include: 'BlobRestoreProgressStatusInProgress', 'BlobRestoreProgressStatusComplete', 'BlobRestoreProgressStatusFailed'
	Status BlobRestoreProgressStatus `json:"status,omitempty"`
	// FailureReason - READ-ONLY; Failure reason when blob restore is failed.
	FailureReason *string `json:"failureReason,omitempty"`
	// RestoreID - READ-ONLY; Id for tracking blob restore request.
	RestoreID *string `json:"restoreId,omitempty"`
	// Parameters - READ-ONLY; Blob restore request parameters.
	Parameters *BlobRestoreParameters `json:"parameters,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobRestoreStatus.
func (brs BlobRestoreStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BlobServiceItems ...
type BlobServiceItems struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of blob services returned.
	Value *[]BlobServiceProperties `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobServiceItems.
func (bsi BlobServiceItems) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BlobServiceProperties the properties of a storage account’s Blob service.
type BlobServiceProperties struct {
	autorest.Response `json:"-"`
	// BlobServicePropertiesProperties - The properties of a storage account’s Blob service.
	*BlobServicePropertiesProperties `json:"properties,omitempty"`
	// Sku - READ-ONLY; Sku name and tier.
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobServiceProperties.
func (bsp BlobServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bsp.BlobServicePropertiesProperties != nil {
		objectMap["properties"] = bsp.BlobServicePropertiesProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BlobServiceProperties struct.
func (bsp *BlobServiceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var blobServiceProperties BlobServicePropertiesProperties
				err = json.Unmarshal(*v, &blobServiceProperties)
				if err != nil {
					return err
				}
				bsp.BlobServicePropertiesProperties = &blobServiceProperties
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				bsp.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bsp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bsp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bsp.Type = &typeVar
			}
		}
	}

	return nil
}

// BlobServicePropertiesProperties the properties of a storage account’s Blob service.
type BlobServicePropertiesProperties struct {
	// Cors - Specifies CORS rules for the Blob service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Blob service.
	Cors *CorsRules `json:"cors,omitempty"`
	// DefaultServiceVersion - DefaultServiceVersion indicates the default version to use for requests to the Blob service if an incoming request’s version is not specified. Possible values include version 2008-10-27 and all more recent versions.
	DefaultServiceVersion *string `json:"defaultServiceVersion,omitempty"`
	// DeleteRetentionPolicy - The blob service properties for blob soft delete.
	DeleteRetentionPolicy *DeleteRetentionPolicy `json:"deleteRetentionPolicy,omitempty"`
	// IsVersioningEnabled - Versioning is enabled if set to true.
	IsVersioningEnabled *bool `json:"isVersioningEnabled,omitempty"`
	// AutomaticSnapshotPolicyEnabled - Deprecated in favor of isVersioningEnabled property.
	AutomaticSnapshotPolicyEnabled *bool `json:"automaticSnapshotPolicyEnabled,omitempty"`
	// ChangeFeed - The blob service properties for change feed events.
	ChangeFeed *ChangeFeed `json:"changeFeed,omitempty"`
	// RestorePolicy - The blob service properties for blob restore policy.
	RestorePolicy *RestorePolicyProperties `json:"restorePolicy,omitempty"`
	// ContainerDeleteRetentionPolicy - The blob service properties for container soft delete.
	ContainerDeleteRetentionPolicy *DeleteRetentionPolicy `json:"containerDeleteRetentionPolicy,omitempty"`
	// LastAccessTimeTrackingPolicy - The blob service property to configure last access time based tracking policy.
	LastAccessTimeTrackingPolicy *LastAccessTimeTrackingPolicy `json:"lastAccessTimeTrackingPolicy,omitempty"`
}

// ChangeFeed the blob service properties for change feed events.
type ChangeFeed struct {
	// Enabled - Indicates whether change feed event logging is enabled for the Blob service.
	Enabled *bool `json:"enabled,omitempty"`
	// RetentionInDays - Indicates the duration of changeFeed retention in days. Minimum value is 1 day and maximum value is 146000 days (400 years). A null value indicates an infinite retention of the change feed.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
}

// CheckNameAvailabilityResult the CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; Gets a boolean value that indicates whether the name is available for you to use. If true, the name is available. If false, the name has already been taken or is invalid and cannot be used.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; Gets the reason that a storage account name could not be used. The Reason element is only returned if NameAvailable is false. Possible values include: 'ReasonAccountNameInvalid', 'ReasonAlreadyExists'
	Reason Reason `json:"reason,omitempty"`
	// Message - READ-ONLY; Gets an error message explaining the Reason value in more detail.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckNameAvailabilityResult.
func (cnar CheckNameAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CloudError an error response from the Storage service.
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the Storage service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// ContainerProperties the properties of a container.
type ContainerProperties struct {
	// Version - READ-ONLY; The version of the deleted blob container.
	Version *string `json:"version,omitempty"`
	// Deleted - READ-ONLY; Indicates whether the blob container was deleted.
	Deleted *bool `json:"deleted,omitempty"`
	// DeletedTime - READ-ONLY; Blob container deletion time.
	DeletedTime *date.Time `json:"deletedTime,omitempty"`
	// RemainingRetentionDays - READ-ONLY; Remaining retention days for soft deleted blob container.
	RemainingRetentionDays *int32 `json:"remainingRetentionDays,omitempty"`
	// DefaultEncryptionScope - Default the container to use specified encryption scope for all writes.
	DefaultEncryptionScope *string `json:"defaultEncryptionScope,omitempty"`
	// DenyEncryptionScopeOverride - Block override of encryption scope from the container default.
	DenyEncryptionScopeOverride *bool `json:"denyEncryptionScopeOverride,omitempty"`
	// PublicAccess - Specifies whether data in the container may be accessed publicly and the level of access. Possible values include: 'PublicAccessContainer', 'PublicAccessBlob', 'PublicAccessNone'
	PublicAccess PublicAccess `json:"publicAccess,omitempty"`
	// LastModifiedTime - READ-ONLY; Returns the date and time the container was last modified.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// LeaseStatus - READ-ONLY; The lease status of the container. Possible values include: 'LeaseStatusLocked', 'LeaseStatusUnlocked'
	LeaseStatus LeaseStatus `json:"leaseStatus,omitempty"`
	// LeaseState - READ-ONLY; Lease state of the container. Possible values include: 'LeaseStateAvailable', 'LeaseStateLeased', 'LeaseStateExpired', 'LeaseStateBreaking', 'LeaseStateBroken'
	LeaseState LeaseState `json:"leaseState,omitempty"`
	// LeaseDuration - READ-ONLY; Specifies whether the lease on a container is of infinite or fixed duration, only when the container is leased. Possible values include: 'LeaseDurationInfinite', 'LeaseDurationFixed'
	LeaseDuration LeaseDuration `json:"leaseDuration,omitempty"`
	// Metadata - A name-value pair to associate with the container as metadata.
	Metadata map[string]*string `json:"metadata"`
	// ImmutabilityPolicy - READ-ONLY; The ImmutabilityPolicy property of the container.
	ImmutabilityPolicy *ImmutabilityPolicyProperties `json:"immutabilityPolicy,omitempty"`
	// LegalHold - READ-ONLY; The LegalHold property of the container.
	LegalHold *LegalHoldProperties `json:"legalHold,omitempty"`
	// HasLegalHold - READ-ONLY; The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
	HasLegalHold *bool `json:"hasLegalHold,omitempty"`
	// HasImmutabilityPolicy - READ-ONLY; The hasImmutabilityPolicy public property is set to true by SRP if ImmutabilityPolicy has been created for this container. The hasImmutabilityPolicy public property is set to false by SRP if ImmutabilityPolicy has not been created for this container.
	HasImmutabilityPolicy *bool `json:"hasImmutabilityPolicy,omitempty"`
	// ImmutableStorageWithVersioning - The object level immutability property of the container. The property is immutable and can only be set to true at the container creation time. Existing containers must undergo a migration process.
	ImmutableStorageWithVersioning *ImmutableStorageWithVersioning `json:"immutableStorageWithVersioning,omitempty"`
	// EnableNfsV3RootSquash - Enable NFSv3 root squash on blob container.
	EnableNfsV3RootSquash *bool `json:"enableNfsV3RootSquash,omitempty"`
	// EnableNfsV3AllSquash - Enable NFSv3 all squash on blob container.
	EnableNfsV3AllSquash *bool `json:"enableNfsV3AllSquash,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerProperties.
func (cp ContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.DefaultEncryptionScope != nil {
		objectMap["defaultEncryptionScope"] = cp.DefaultEncryptionScope
	}
	if cp.DenyEncryptionScopeOverride != nil {
		objectMap["denyEncryptionScopeOverride"] = cp.DenyEncryptionScopeOverride
	}
	if cp.PublicAccess != "" {
		objectMap["publicAccess"] = cp.PublicAccess
	}
	if cp.Metadata != nil {
		objectMap["metadata"] = cp.Metadata
	}
	if cp.ImmutableStorageWithVersioning != nil {
		objectMap["immutableStorageWithVersioning"] = cp.ImmutableStorageWithVersioning
	}
	if cp.EnableNfsV3RootSquash != nil {
		objectMap["enableNfsV3RootSquash"] = cp.EnableNfsV3RootSquash
	}
	if cp.EnableNfsV3AllSquash != nil {
		objectMap["enableNfsV3AllSquash"] = cp.EnableNfsV3AllSquash
	}
	return json.Marshal(objectMap)
}

// CorsRule specifies a CORS rule for the Blob service.
type CorsRule struct {
	// AllowedOrigins - Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
	AllowedOrigins *[]string `json:"allowedOrigins,omitempty"`
	// AllowedMethods - Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
	AllowedMethods *[]string `json:"allowedMethods,omitempty"`
	// MaxAgeInSeconds - Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight response.
	MaxAgeInSeconds *int32 `json:"maxAgeInSeconds,omitempty"`
	// ExposedHeaders - Required if CorsRule element is present. A list of response headers to expose to CORS clients.
	ExposedHeaders *[]string `json:"exposedHeaders,omitempty"`
	// AllowedHeaders - Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
	AllowedHeaders *[]string `json:"allowedHeaders,omitempty"`
}

// CorsRules sets the CORS rules. You can include up to five CorsRule elements in the request.
type CorsRules struct {
	// CorsRules - The List of CORS rules. You can include up to five CorsRule elements in the request.
	CorsRules *[]CorsRule `json:"corsRules,omitempty"`
}

// CustomDomain the custom domain assigned to this storage account. This can be set via Update.
type CustomDomain struct {
	// Name - Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
	Name *string `json:"name,omitempty"`
	// UseSubDomainName - Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
	UseSubDomainName *bool `json:"useSubDomainName,omitempty"`
}

// DateAfterCreation object to define snapshot and version action conditions.
type DateAfterCreation struct {
	// DaysAfterCreationGreaterThan - Value indicating the age in days after creation
	DaysAfterCreationGreaterThan *float64 `json:"daysAfterCreationGreaterThan,omitempty"`
	// DaysAfterLastTierChangeGreaterThan - Value indicating the age in days after last blob tier change time. This property is only applicable for tierToArchive actions and requires daysAfterCreationGreaterThan to be set for snapshots and blob version based actions. The blob will be archived if both the conditions are satisfied.
	DaysAfterLastTierChangeGreaterThan *float64 `json:"daysAfterLastTierChangeGreaterThan,omitempty"`
}

// DateAfterModification object to define the base blob action conditions. Properties
// daysAfterModificationGreaterThan, daysAfterLastAccessTimeGreaterThan and daysAfterCreationGreaterThan
// are mutually exclusive. The daysAfterLastTierChangeGreaterThan property is only applicable for
// tierToArchive actions which requires daysAfterModificationGreaterThan to be set, also it cannot be used
// in conjunction with daysAfterLastAccessTimeGreaterThan or daysAfterCreationGreaterThan.
type DateAfterModification struct {
	// DaysAfterModificationGreaterThan - Value indicating the age in days after last modification
	DaysAfterModificationGreaterThan *float64 `json:"daysAfterModificationGreaterThan,omitempty"`
	// DaysAfterLastAccessTimeGreaterThan - Value indicating the age in days after last blob access. This property can only be used in conjunction with last access time tracking policy
	DaysAfterLastAccessTimeGreaterThan *float64 `json:"daysAfterLastAccessTimeGreaterThan,omitempty"`
	// DaysAfterLastTierChangeGreaterThan - Value indicating the age in days after last blob tier change time. This property is only applicable for tierToArchive actions and requires daysAfterModificationGreaterThan to be set for baseBlobs based actions. The blob will be archived if both the conditions are satisfied.
	DaysAfterLastTierChangeGreaterThan *float64 `json:"daysAfterLastTierChangeGreaterThan,omitempty"`
	// DaysAfterCreationGreaterThan - Value indicating the age in days after blob creation.
	DaysAfterCreationGreaterThan *float64 `json:"daysAfterCreationGreaterThan,omitempty"`
}

// DeletedAccount deleted storage account
type DeletedAccount struct {
	autorest.Response `json:"-"`
	// DeletedAccountProperties - Properties of the deleted account.
	*DeletedAccountProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedAccount.
func (da DeletedAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if da.DeletedAccountProperties != nil {
		objectMap["properties"] = da.DeletedAccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeletedAccount struct.
func (da *DeletedAccount) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var deletedAccountProperties DeletedAccountProperties
				err = json.Unmarshal(*v, &deletedAccountProperties)
				if err != nil {
					return err
				}
				da.DeletedAccountProperties = &deletedAccountProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				da.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				da.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				da.Type = &typeVar
			}
		}
	}

	return nil
}

// DeletedAccountListResult the response from the List Deleted Accounts operation.
type DeletedAccountListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Gets the list of deleted accounts and their properties.
	Value *[]DeletedAccount `json:"value,omitempty"`
	// NextLink - READ-ONLY; Request URL that can be used to query next page of deleted accounts. Returned when total number of requested deleted accounts exceed maximum page size.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedAccountListResult.
func (dalr DeletedAccountListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DeletedAccountListResultIterator provides access to a complete listing of DeletedAccount values.
type DeletedAccountListResultIterator struct {
	i    int
	page DeletedAccountListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedAccountListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedAccountListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeletedAccountListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedAccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedAccountListResultIterator) Response() DeletedAccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedAccountListResultIterator) Value() DeletedAccount {
	if !iter.page.NotDone() {
		return DeletedAccount{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeletedAccountListResultIterator type.
func NewDeletedAccountListResultIterator(page DeletedAccountListResultPage) DeletedAccountListResultIterator {
	return DeletedAccountListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dalr DeletedAccountListResult) IsEmpty() bool {
	return dalr.Value == nil || len(*dalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dalr DeletedAccountListResult) hasNextLink() bool {
	return dalr.NextLink != nil && len(*dalr.NextLink) != 0
}

// deletedAccountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dalr DeletedAccountListResult) deletedAccountListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dalr.NextLink)))
}

// DeletedAccountListResultPage contains a page of DeletedAccount values.
type DeletedAccountListResultPage struct {
	fn   func(context.Context, DeletedAccountListResult) (DeletedAccountListResult, error)
	dalr DeletedAccountListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedAccountListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedAccountListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dalr)
		if err != nil {
			return err
		}
		page.dalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeletedAccountListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedAccountListResultPage) NotDone() bool {
	return !page.dalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedAccountListResultPage) Response() DeletedAccountListResult {
	return page.dalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedAccountListResultPage) Values() []DeletedAccount {
	if page.dalr.IsEmpty() {
		return nil
	}
	return *page.dalr.Value
}

// Creates a new instance of the DeletedAccountListResultPage type.
func NewDeletedAccountListResultPage(cur DeletedAccountListResult, getNextPage func(context.Context, DeletedAccountListResult) (DeletedAccountListResult, error)) DeletedAccountListResultPage {
	return DeletedAccountListResultPage{
		fn:   getNextPage,
		dalr: cur,
	}
}

// DeletedAccountProperties attributes of a deleted storage account.
type DeletedAccountProperties struct {
	// StorageAccountResourceID - READ-ONLY; Full resource id of the original storage account.
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`
	// Location - READ-ONLY; Location of the deleted account.
	Location *string `json:"location,omitempty"`
	// RestoreReference - READ-ONLY; Can be used to attempt recovering this deleted account via PutStorageAccount API.
	RestoreReference *string `json:"restoreReference,omitempty"`
	// CreationTime - READ-ONLY; Creation time of the deleted account.
	CreationTime *string `json:"creationTime,omitempty"`
	// DeletionTime - READ-ONLY; Deletion time of the deleted account.
	DeletionTime *string `json:"deletionTime,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedAccountProperties.
func (dap DeletedAccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DeletedShare the deleted share to be restored.
type DeletedShare struct {
	// DeletedShareName - Required. Identify the name of the deleted share that will be restored.
	DeletedShareName *string `json:"deletedShareName,omitempty"`
	// DeletedShareVersion - Required. Identify the version of the deleted share that will be restored.
	DeletedShareVersion *string `json:"deletedShareVersion,omitempty"`
}

// DeleteRetentionPolicy the service properties for soft delete.
type DeleteRetentionPolicy struct {
	// Enabled - Indicates whether DeleteRetentionPolicy is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Days - Indicates the number of days that the deleted item should be retained. The minimum specified value can be 1 and the maximum value can be 365.
	Days *int32 `json:"days,omitempty"`
	// AllowPermanentDelete - This property when set to true allows deletion of the soft deleted blob versions and snapshots. This property cannot be used blob restore policy. This property only applies to blob service and does not apply to containers or file share.
	AllowPermanentDelete *bool `json:"allowPermanentDelete,omitempty"`
}

// Dimension dimension of blobs, possibly be blob type or access tier.
type Dimension struct {
	// Name - Display name of dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of dimension.
	DisplayName *string `json:"displayName,omitempty"`
}

// Encryption the encryption settings on the storage account.
type Encryption struct {
	// Services - List of services which support encryption.
	Services *EncryptionServices `json:"services,omitempty"`
	// KeySource - The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault. Possible values include: 'KeySourceMicrosoftStorage', 'KeySourceMicrosoftKeyvault'
	KeySource KeySource `json:"keySource,omitempty"`
	// RequireInfrastructureEncryption - A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
	RequireInfrastructureEncryption *bool `json:"requireInfrastructureEncryption,omitempty"`
	// KeyVaultProperties - Properties provided by key vault.
	KeyVaultProperties *KeyVaultProperties `json:"keyvaultproperties,omitempty"`
	// EncryptionIdentity - The identity to be used with service-side encryption at rest.
	EncryptionIdentity *EncryptionIdentity `json:"identity,omitempty"`
}

// EncryptionIdentity encryption identity for the storage account.
type EncryptionIdentity struct {
	// EncryptionUserAssignedIdentity - Resource identifier of the UserAssigned identity to be associated with server-side encryption on the storage account.
	EncryptionUserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
	// EncryptionFederatedIdentityClientID - ClientId of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the storage account.
	EncryptionFederatedIdentityClientID *string `json:"federatedIdentityClientId,omitempty"`
}

// EncryptionScope the Encryption Scope resource.
type EncryptionScope struct {
	autorest.Response `json:"-"`
	// EncryptionScopeProperties - Properties of the encryption scope.
	*EncryptionScopeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionScope.
func (es EncryptionScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if es.EncryptionScopeProperties != nil {
		objectMap["properties"] = es.EncryptionScopeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EncryptionScope struct.
func (es *EncryptionScope) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var encryptionScopeProperties EncryptionScopeProperties
				err = json.Unmarshal(*v, &encryptionScopeProperties)
				if err != nil {
					return err
				}
				es.EncryptionScopeProperties = &encryptionScopeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				es.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				es.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				es.Type = &typeVar
			}
		}
	}

	return nil
}

// EncryptionScopeKeyVaultProperties the key vault properties for the encryption scope. This is a required
// field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
type EncryptionScopeKeyVaultProperties struct {
	// KeyURI - The object identifier for a key vault key object. When applied, the encryption scope will use the key referenced by the identifier to enable customer-managed key support on this encryption scope.
	KeyURI *string `json:"keyUri,omitempty"`
	// CurrentVersionedKeyIdentifier - READ-ONLY; The object identifier of the current versioned Key Vault Key in use.
	CurrentVersionedKeyIdentifier *string `json:"currentVersionedKeyIdentifier,omitempty"`
	// LastKeyRotationTimestamp - READ-ONLY; Timestamp of last rotation of the Key Vault Key.
	LastKeyRotationTimestamp *date.Time `json:"lastKeyRotationTimestamp,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionScopeKeyVaultProperties.
func (eskvp EncryptionScopeKeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eskvp.KeyURI != nil {
		objectMap["keyUri"] = eskvp.KeyURI
	}
	return json.Marshal(objectMap)
}

// EncryptionScopeListResult list of encryption scopes requested, and if paging is required, a URL to the
// next page of encryption scopes.
type EncryptionScopeListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of encryption scopes requested.
	Value *[]EncryptionScope `json:"value,omitempty"`
	// NextLink - READ-ONLY; Request URL that can be used to query next page of encryption scopes. Returned when total number of requested encryption scopes exceeds the maximum page size.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionScopeListResult.
func (eslr EncryptionScopeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EncryptionScopeListResultIterator provides access to a complete listing of EncryptionScope values.
type EncryptionScopeListResultIterator struct {
	i    int
	page EncryptionScopeListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EncryptionScopeListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EncryptionScopeListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EncryptionScopeListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EncryptionScopeListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EncryptionScopeListResultIterator) Response() EncryptionScopeListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EncryptionScopeListResultIterator) Value() EncryptionScope {
	if !iter.page.NotDone() {
		return EncryptionScope{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EncryptionScopeListResultIterator type.
func NewEncryptionScopeListResultIterator(page EncryptionScopeListResultPage) EncryptionScopeListResultIterator {
	return EncryptionScopeListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eslr EncryptionScopeListResult) IsEmpty() bool {
	return eslr.Value == nil || len(*eslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eslr EncryptionScopeListResult) hasNextLink() bool {
	return eslr.NextLink != nil && len(*eslr.NextLink) != 0
}

// encryptionScopeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eslr EncryptionScopeListResult) encryptionScopeListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !eslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eslr.NextLink)))
}

// EncryptionScopeListResultPage contains a page of EncryptionScope values.
type EncryptionScopeListResultPage struct {
	fn   func(context.Context, EncryptionScopeListResult) (EncryptionScopeListResult, error)
	eslr EncryptionScopeListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EncryptionScopeListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EncryptionScopeListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eslr)
		if err != nil {
			return err
		}
		page.eslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EncryptionScopeListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EncryptionScopeListResultPage) NotDone() bool {
	return !page.eslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EncryptionScopeListResultPage) Response() EncryptionScopeListResult {
	return page.eslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EncryptionScopeListResultPage) Values() []EncryptionScope {
	if page.eslr.IsEmpty() {
		return nil
	}
	return *page.eslr.Value
}

// Creates a new instance of the EncryptionScopeListResultPage type.
func NewEncryptionScopeListResultPage(cur EncryptionScopeListResult, getNextPage func(context.Context, EncryptionScopeListResult) (EncryptionScopeListResult, error)) EncryptionScopeListResultPage {
	return EncryptionScopeListResultPage{
		fn:   getNextPage,
		eslr: cur,
	}
}

// EncryptionScopeProperties properties of the encryption scope.
type EncryptionScopeProperties struct {
	// Source - The provider for the encryption scope. Possible values (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault. Possible values include: 'EncryptionScopeSourceMicrosoftStorage', 'EncryptionScopeSourceMicrosoftKeyVault'
	Source EncryptionScopeSource `json:"source,omitempty"`
	// State - The state of the encryption scope. Possible values (case-insensitive):  Enabled, Disabled. Possible values include: 'EncryptionScopeStateEnabled', 'EncryptionScopeStateDisabled'
	State EncryptionScopeState `json:"state,omitempty"`
	// CreationTime - READ-ONLY; Gets the creation date and time of the encryption scope in UTC.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - READ-ONLY; Gets the last modification date and time of the encryption scope in UTC.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// KeyVaultProperties - The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
	KeyVaultProperties *EncryptionScopeKeyVaultProperties `json:"keyVaultProperties,omitempty"`
	// RequireInfrastructureEncryption - A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
	RequireInfrastructureEncryption *bool `json:"requireInfrastructureEncryption,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionScopeProperties.
func (esp EncryptionScopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if esp.Source != "" {
		objectMap["source"] = esp.Source
	}
	if esp.State != "" {
		objectMap["state"] = esp.State
	}
	if esp.KeyVaultProperties != nil {
		objectMap["keyVaultProperties"] = esp.KeyVaultProperties
	}
	if esp.RequireInfrastructureEncryption != nil {
		objectMap["requireInfrastructureEncryption"] = esp.RequireInfrastructureEncryption
	}
	return json.Marshal(objectMap)
}

// EncryptionService a service that allows server-side encryption to be used.
type EncryptionService struct {
	// Enabled - A boolean indicating whether or not the service encrypts the data as it is stored. Encryption at rest is enabled by default today and cannot be disabled.
	Enabled *bool `json:"enabled,omitempty"`
	// LastEnabledTime - READ-ONLY; Gets a rough estimate of the date/time when the encryption was last enabled by the user. Data is encrypted at rest by default today and cannot be disabled.
	LastEnabledTime *date.Time `json:"lastEnabledTime,omitempty"`
	// KeyType - Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption key will be used. 'Service' key type implies that a default service key is used. Possible values include: 'KeyTypeService', 'KeyTypeAccount'
	KeyType KeyType `json:"keyType,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionService.
func (es EncryptionService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if es.Enabled != nil {
		objectMap["enabled"] = es.Enabled
	}
	if es.KeyType != "" {
		objectMap["keyType"] = es.KeyType
	}
	return json.Marshal(objectMap)
}

// EncryptionServices a list of services that support encryption.
type EncryptionServices struct {
	// Blob - The encryption function of the blob storage service.
	Blob *EncryptionService `json:"blob,omitempty"`
	// File - The encryption function of the file storage service.
	File *EncryptionService `json:"file,omitempty"`
	// Table - The encryption function of the table storage service.
	Table *EncryptionService `json:"table,omitempty"`
	// Queue - The encryption function of the queue storage service.
	Queue *EncryptionService `json:"queue,omitempty"`
}

// Endpoints the URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs
// object.
type Endpoints struct {
	// Blob - READ-ONLY; Gets the blob endpoint.
	Blob *string `json:"blob,omitempty"`
	// Queue - READ-ONLY; Gets the queue endpoint.
	Queue *string `json:"queue,omitempty"`
	// Table - READ-ONLY; Gets the table endpoint.
	Table *string `json:"table,omitempty"`
	// File - READ-ONLY; Gets the file endpoint.
	File *string `json:"file,omitempty"`
	// Web - READ-ONLY; Gets the web endpoint.
	Web *string `json:"web,omitempty"`
	// Dfs - READ-ONLY; Gets the dfs endpoint.
	Dfs *string `json:"dfs,omitempty"`
	// MicrosoftEndpoints - Gets the microsoft routing storage endpoints.
	MicrosoftEndpoints *AccountMicrosoftEndpoints `json:"microsoftEndpoints,omitempty"`
	// InternetEndpoints - Gets the internet routing storage endpoints
	InternetEndpoints *AccountInternetEndpoints `json:"internetEndpoints,omitempty"`
}

// MarshalJSON is the custom marshaler for Endpoints.
func (e Endpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.MicrosoftEndpoints != nil {
		objectMap["microsoftEndpoints"] = e.MicrosoftEndpoints
	}
	if e.InternetEndpoints != nil {
		objectMap["internetEndpoints"] = e.InternetEndpoints
	}
	return json.Marshal(objectMap)
}

// ErrorResponse an error response from the storage resource provider.
type ErrorResponse struct {
	// Error - Azure Storage Resource Provider error response body.
	Error *ErrorResponseBody `json:"error,omitempty"`
}

// ErrorResponseBody error response body contract.
type ErrorResponseBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
}

// ExtendedLocation the complex type of the extended location.
type ExtendedLocation struct {
	// Name - The name of the extended location.
	Name *string `json:"name,omitempty"`
	// Type - The type of the extended location. Possible values include: 'ExtendedLocationTypesEdgeZone'
	Type ExtendedLocationTypes `json:"type,omitempty"`
}

// FileServiceItems ...
type FileServiceItems struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of file services returned.
	Value *[]FileServiceProperties `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for FileServiceItems.
func (fsi FileServiceItems) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// FileServiceProperties the properties of File services in storage account.
type FileServiceProperties struct {
	autorest.Response `json:"-"`
	// FileServicePropertiesProperties - The properties of File services in storage account.
	*FileServicePropertiesProperties `json:"properties,omitempty"`
	// Sku - READ-ONLY; Sku name and tier.
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FileServiceProperties.
func (fsp FileServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fsp.FileServicePropertiesProperties != nil {
		objectMap["properties"] = fsp.FileServicePropertiesProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FileServiceProperties struct.
func (fsp *FileServiceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileServiceProperties FileServicePropertiesProperties
				err = json.Unmarshal(*v, &fileServiceProperties)
				if err != nil {
					return err
				}
				fsp.FileServicePropertiesProperties = &fileServiceProperties
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				fsp.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fsp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fsp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fsp.Type = &typeVar
			}
		}
	}

	return nil
}

// FileServicePropertiesProperties the properties of File services in storage account.
type FileServicePropertiesProperties struct {
	// Cors - Specifies CORS rules for the File service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the File service.
	Cors *CorsRules `json:"cors,omitempty"`
	// ShareDeleteRetentionPolicy - The file service properties for share soft delete.
	ShareDeleteRetentionPolicy *DeleteRetentionPolicy `json:"shareDeleteRetentionPolicy,omitempty"`
	// ProtocolSettings - Protocol settings for file service
	ProtocolSettings *ProtocolSettings `json:"protocolSettings,omitempty"`
}

// FileShare properties of the file share, including Id, resource name, resource type, Etag.
type FileShare struct {
	autorest.Response `json:"-"`
	// FileShareProperties - Properties of the file share.
	*FileShareProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FileShare.
func (fs FileShare) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fs.FileShareProperties != nil {
		objectMap["properties"] = fs.FileShareProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FileShare struct.
func (fs *FileShare) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileShareProperties FileShareProperties
				err = json.Unmarshal(*v, &fileShareProperties)
				if err != nil {
					return err
				}
				fs.FileShareProperties = &fileShareProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				fs.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fs.Type = &typeVar
			}
		}
	}

	return nil
}

// FileShareItem the file share properties be listed out.
type FileShareItem struct {
	// FileShareProperties - The file share properties be listed out.
	*FileShareProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FileShareItem.
func (fsi FileShareItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fsi.FileShareProperties != nil {
		objectMap["properties"] = fsi.FileShareProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FileShareItem struct.
func (fsi *FileShareItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileShareProperties FileShareProperties
				err = json.Unmarshal(*v, &fileShareProperties)
				if err != nil {
					return err
				}
				fsi.FileShareProperties = &fileShareProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				fsi.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fsi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fsi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fsi.Type = &typeVar
			}
		}
	}

	return nil
}

// FileShareItems response schema. Contains list of shares returned, and if paging is requested or
// required, a URL to next page of shares.
type FileShareItems struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of file shares returned.
	Value *[]FileShareItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; Request URL that can be used to query next page of shares. Returned when total number of requested shares exceed maximum page size.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for FileShareItems.
func (fsi FileShareItems) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// FileShareItemsIterator provides access to a complete listing of FileShareItem values.
type FileShareItemsIterator struct {
	i    int
	page FileShareItemsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FileShareItemsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FileShareItemsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FileShareItemsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FileShareItemsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FileShareItemsIterator) Response() FileShareItems {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FileShareItemsIterator) Value() FileShareItem {
	if !iter.page.NotDone() {
		return FileShareItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FileShareItemsIterator type.
func NewFileShareItemsIterator(page FileShareItemsPage) FileShareItemsIterator {
	return FileShareItemsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fsi FileShareItems) IsEmpty() bool {
	return fsi.Value == nil || len(*fsi.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (fsi FileShareItems) hasNextLink() bool {
	return fsi.NextLink != nil && len(*fsi.NextLink) != 0
}

// fileShareItemsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fsi FileShareItems) fileShareItemsPreparer(ctx context.Context) (*http.Request, error) {
	if !fsi.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fsi.NextLink)))
}

// FileShareItemsPage contains a page of FileShareItem values.
type FileShareItemsPage struct {
	fn  func(context.Context, FileShareItems) (FileShareItems, error)
	fsi FileShareItems
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FileShareItemsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FileShareItemsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.fsi)
		if err != nil {
			return err
		}
		page.fsi = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FileShareItemsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FileShareItemsPage) NotDone() bool {
	return !page.fsi.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FileShareItemsPage) Response() FileShareItems {
	return page.fsi
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FileShareItemsPage) Values() []FileShareItem {
	if page.fsi.IsEmpty() {
		return nil
	}
	return *page.fsi.Value
}

// Creates a new instance of the FileShareItemsPage type.
func NewFileShareItemsPage(cur FileShareItems, getNextPage func(context.Context, FileShareItems) (FileShareItems, error)) FileShareItemsPage {
	return FileShareItemsPage{
		fn:  getNextPage,
		fsi: cur,
	}
}

// FileShareProperties the properties of the file share.
type FileShareProperties struct {
	// LastModifiedTime - READ-ONLY; Returns the date and time the share was last modified.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Metadata - A name-value pair to associate with the share as metadata.
	Metadata map[string]*string `json:"metadata"`
	// ShareQuota - The maximum size of the share, in gigabytes. Must be greater than 0, and less than or equal to 5TB (5120). For Large File Shares, the maximum size is 102400.
	ShareQuota *int32 `json:"shareQuota,omitempty"`
	// EnabledProtocols - The authentication protocol that is used for the file share. Can only be specified when creating a share. Possible values include: 'EnabledProtocolsSMB', 'EnabledProtocolsNFS'
	EnabledProtocols EnabledProtocols `json:"enabledProtocols,omitempty"`
	// RootSquash - The property is for NFS share only. The default is NoRootSquash. Possible values include: 'RootSquashTypeNoRootSquash', 'RootSquashTypeRootSquash', 'RootSquashTypeAllSquash'
	RootSquash RootSquashType `json:"rootSquash,omitempty"`
	// Version - READ-ONLY; The version of the share.
	Version *string `json:"version,omitempty"`
	// Deleted - READ-ONLY; Indicates whether the share was deleted.
	Deleted *bool `json:"deleted,omitempty"`
	// DeletedTime - READ-ONLY; The deleted time if the share was deleted.
	DeletedTime *date.Time `json:"deletedTime,omitempty"`
	// RemainingRetentionDays - READ-ONLY; Remaining retention days for share that was soft deleted.
	RemainingRetentionDays *int32 `json:"remainingRetentionDays,omitempty"`
	// AccessTier - Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium. Possible values include: 'ShareAccessTierTransactionOptimized', 'ShareAccessTierHot', 'ShareAccessTierCool', 'ShareAccessTierPremium'
	AccessTier ShareAccessTier `json:"accessTier,omitempty"`
	// AccessTierChangeTime - READ-ONLY; Indicates the last modification time for share access tier.
	AccessTierChangeTime *date.Time `json:"accessTierChangeTime,omitempty"`
	// AccessTierStatus - READ-ONLY; Indicates if there is a pending transition for access tier.
	AccessTierStatus *string `json:"accessTierStatus,omitempty"`
	// ShareUsageBytes - READ-ONLY; The approximate size of the data stored on the share. Note that this value may not include all recently created or recently resized files.
	ShareUsageBytes *int64 `json:"shareUsageBytes,omitempty"`
	// LeaseStatus - READ-ONLY; The lease status of the share. Possible values include: 'LeaseStatusLocked', 'LeaseStatusUnlocked'
	LeaseStatus LeaseStatus `json:"leaseStatus,omitempty"`
	// LeaseState - READ-ONLY; Lease state of the share. Possible values include: 'LeaseStateAvailable', 'LeaseStateLeased', 'LeaseStateExpired', 'LeaseStateBreaking', 'LeaseStateBroken'
	LeaseState LeaseState `json:"leaseState,omitempty"`
	// LeaseDuration - READ-ONLY; Specifies whether the lease on a share is of infinite or fixed duration, only when the share is leased. Possible values include: 'LeaseDurationInfinite', 'LeaseDurationFixed'
	LeaseDuration LeaseDuration `json:"leaseDuration,omitempty"`
	// SignedIdentifiers - List of stored access policies specified on the share.
	SignedIdentifiers *[]SignedIdentifier `json:"signedIdentifiers,omitempty"`
	// SnapshotTime - READ-ONLY; Creation time of share snapshot returned in the response of list shares with expand param "snapshots".
	SnapshotTime *date.Time `json:"snapshotTime,omitempty"`
}

// MarshalJSON is the custom marshaler for FileShareProperties.
func (fsp FileShareProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fsp.Metadata != nil {
		objectMap["metadata"] = fsp.Metadata
	}
	if fsp.ShareQuota != nil {
		objectMap["shareQuota"] = fsp.ShareQuota
	}
	if fsp.EnabledProtocols != "" {
		objectMap["enabledProtocols"] = fsp.EnabledProtocols
	}
	if fsp.RootSquash != "" {
		objectMap["rootSquash"] = fsp.RootSquash
	}
	if fsp.AccessTier != "" {
		objectMap["accessTier"] = fsp.AccessTier
	}
	if fsp.SignedIdentifiers != nil {
		objectMap["signedIdentifiers"] = fsp.SignedIdentifiers
	}
	return json.Marshal(objectMap)
}

// GeoReplicationStats statistics related to replication for storage account's Blob, Table, Queue and File
// services. It is only available when geo-redundant replication is enabled for the storage account.
type GeoReplicationStats struct {
	// Status - READ-ONLY; The status of the secondary location. Possible values are: - Live: Indicates that the secondary location is active and operational. - Bootstrap: Indicates initial synchronization from the primary location to the secondary location is in progress.This typically occurs when replication is first enabled. - Unavailable: Indicates that the secondary location is temporarily unavailable. Possible values include: 'GeoReplicationStatusLive', 'GeoReplicationStatusBootstrap', 'GeoReplicationStatusUnavailable'
	Status GeoReplicationStatus `json:"status,omitempty"`
	// LastSyncTime - READ-ONLY; All primary writes preceding this UTC date/time value are guaranteed to be available for read operations. Primary writes following this point in time may or may not be available for reads. Element may be default value if value of LastSyncTime is not available, this can happen if secondary is offline or we are in bootstrap.
	LastSyncTime *date.Time `json:"lastSyncTime,omitempty"`
	// CanFailover - READ-ONLY; A boolean flag which indicates whether or not account failover is supported for the account.
	CanFailover *bool `json:"canFailover,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoReplicationStats.
func (grs GeoReplicationStats) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'IdentityTypeNone', 'IdentityTypeSystemAssigned', 'IdentityTypeUserAssigned', 'IdentityTypeSystemAssignedUserAssigned'
	Type IdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - Gets or sets a list of key value pairs that describe the set of User Assigned identities that will be used with this storage account. The key is the ARM resource identifier of the identity. Only 1 User Assigned identity is permitted here.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	if i.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = i.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// ImmutabilityPolicy the ImmutabilityPolicy property of a blob container, including Id, resource name,
// resource type, Etag.
type ImmutabilityPolicy struct {
	autorest.Response `json:"-"`
	// ImmutabilityPolicyProperty - The properties of an ImmutabilityPolicy of a blob container.
	*ImmutabilityPolicyProperty `json:"properties,omitempty"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImmutabilityPolicy.
func (IP ImmutabilityPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.ImmutabilityPolicyProperty != nil {
		objectMap["properties"] = IP.ImmutabilityPolicyProperty
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImmutabilityPolicy struct.
func (IP *ImmutabilityPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var immutabilityPolicyProperty ImmutabilityPolicyProperty
				err = json.Unmarshal(*v, &immutabilityPolicyProperty)
				if err != nil {
					return err
				}
				IP.ImmutabilityPolicyProperty = &immutabilityPolicyProperty
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				IP.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				IP.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				IP.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				IP.Type = &typeVar
			}
		}
	}

	return nil
}

// ImmutabilityPolicyProperties the properties of an ImmutabilityPolicy of a blob container.
type ImmutabilityPolicyProperties struct {
	// ImmutabilityPolicyProperty - The properties of an ImmutabilityPolicy of a blob container.
	*ImmutabilityPolicyProperty `json:"properties,omitempty"`
	// Etag - READ-ONLY; ImmutabilityPolicy Etag.
	Etag *string `json:"etag,omitempty"`
	// UpdateHistory - READ-ONLY; The ImmutabilityPolicy update history of the blob container.
	UpdateHistory *[]UpdateHistoryProperty `json:"updateHistory,omitempty"`
}

// MarshalJSON is the custom marshaler for ImmutabilityPolicyProperties.
func (ipp ImmutabilityPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipp.ImmutabilityPolicyProperty != nil {
		objectMap["properties"] = ipp.ImmutabilityPolicyProperty
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImmutabilityPolicyProperties struct.
func (ipp *ImmutabilityPolicyProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var immutabilityPolicyProperty ImmutabilityPolicyProperty
				err = json.Unmarshal(*v, &immutabilityPolicyProperty)
				if err != nil {
					return err
				}
				ipp.ImmutabilityPolicyProperty = &immutabilityPolicyProperty
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ipp.Etag = &etag
			}
		case "updateHistory":
			if v != nil {
				var updateHistory []UpdateHistoryProperty
				err = json.Unmarshal(*v, &updateHistory)
				if err != nil {
					return err
				}
				ipp.UpdateHistory = &updateHistory
			}
		}
	}

	return nil
}

// ImmutabilityPolicyProperty the properties of an ImmutabilityPolicy of a blob container.
type ImmutabilityPolicyProperty struct {
	// ImmutabilityPeriodSinceCreationInDays - The immutability period for the blobs in the container since the policy creation, in days.
	ImmutabilityPeriodSinceCreationInDays *int32 `json:"immutabilityPeriodSinceCreationInDays,omitempty"`
	// State - READ-ONLY; The ImmutabilityPolicy state of a blob container, possible values include: Locked and Unlocked. Possible values include: 'ImmutabilityPolicyStateLocked', 'ImmutabilityPolicyStateUnlocked'
	State ImmutabilityPolicyState `json:"state,omitempty"`
	// AllowProtectedAppendWrites - This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API.
	AllowProtectedAppendWrites *bool `json:"allowProtectedAppendWrites,omitempty"`
	// AllowProtectedAppendWritesAll - This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and 'allowProtectedAppendWritesAll' properties are mutually exclusive.
	AllowProtectedAppendWritesAll *bool `json:"allowProtectedAppendWritesAll,omitempty"`
}

// MarshalJSON is the custom marshaler for ImmutabilityPolicyProperty.
func (ipp ImmutabilityPolicyProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipp.ImmutabilityPeriodSinceCreationInDays != nil {
		objectMap["immutabilityPeriodSinceCreationInDays"] = ipp.ImmutabilityPeriodSinceCreationInDays
	}
	if ipp.AllowProtectedAppendWrites != nil {
		objectMap["allowProtectedAppendWrites"] = ipp.AllowProtectedAppendWrites
	}
	if ipp.AllowProtectedAppendWritesAll != nil {
		objectMap["allowProtectedAppendWritesAll"] = ipp.AllowProtectedAppendWritesAll
	}
	return json.Marshal(objectMap)
}

// ImmutableStorageAccount this property enables and defines account-level immutability. Enabling the
// feature auto-enables Blob Versioning.
type ImmutableStorageAccount struct {
	// Enabled - A boolean flag which enables account-level immutability. All the containers under such an account have object-level immutability enabled by default.
	Enabled *bool `json:"enabled,omitempty"`
	// ImmutabilityPolicy - Specifies the default account-level immutability policy which is inherited and applied to objects that do not possess an explicit immutability policy at the object level. The object-level immutability policy has higher precedence than the container-level immutability policy, which has a higher precedence than the account-level immutability policy.
	ImmutabilityPolicy *AccountImmutabilityPolicyProperties `json:"immutabilityPolicy,omitempty"`
}

// ImmutableStorageWithVersioning object level immutability properties of the container.
type ImmutableStorageWithVersioning struct {
	// Enabled - This is an immutable property, when set to true it enables object level immutability at the container level.
	Enabled *bool `json:"enabled,omitempty"`
	// TimeStamp - READ-ONLY; Returns the date and time the object level immutability was enabled.
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
	// MigrationState - READ-ONLY; This property denotes the container level immutability to object level immutability migration state. Possible values include: 'MigrationStateInProgress', 'MigrationStateCompleted'
	MigrationState MigrationState `json:"migrationState,omitempty"`
}

// MarshalJSON is the custom marshaler for ImmutableStorageWithVersioning.
func (iswv ImmutableStorageWithVersioning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iswv.Enabled != nil {
		objectMap["enabled"] = iswv.Enabled
	}
	return json.Marshal(objectMap)
}

// IPRule IP rule with specific IP or IP range in CIDR format.
type IPRule struct {
	// IPAddressOrRange - Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
	IPAddressOrRange *string `json:"value,omitempty"`
	// Action - The action of IP ACL rule. Possible values include: 'ActionAllow'
	Action Action `json:"action,omitempty"`
}

// KeyCreationTime storage account keys creation time.
type KeyCreationTime struct {
	Key1 *date.Time `json:"key1,omitempty"`
	Key2 *date.Time `json:"key2,omitempty"`
}

// KeyPolicy keyPolicy assigned to the storage account.
type KeyPolicy struct {
	// KeyExpirationPeriodInDays - The key expiration period in days.
	KeyExpirationPeriodInDays *int32 `json:"keyExpirationPeriodInDays,omitempty"`
}

// KeyVaultProperties properties of key vault.
type KeyVaultProperties struct {
	// KeyName - The name of KeyVault key.
	KeyName *string `json:"keyname,omitempty"`
	// KeyVersion - The version of KeyVault key.
	KeyVersion *string `json:"keyversion,omitempty"`
	// KeyVaultURI - The Uri of KeyVault.
	KeyVaultURI *string `json:"keyvaulturi,omitempty"`
	// CurrentVersionedKeyIdentifier - READ-ONLY; The object identifier of the current versioned Key Vault Key in use.
	CurrentVersionedKeyIdentifier *string `json:"currentVersionedKeyIdentifier,omitempty"`
	// LastKeyRotationTimestamp - READ-ONLY; Timestamp of last rotation of the Key Vault Key.
	LastKeyRotationTimestamp *date.Time `json:"lastKeyRotationTimestamp,omitempty"`
	// CurrentVersionedKeyExpirationTimestamp - READ-ONLY; This is a read only property that represents the expiration time of the current version of the customer managed key used for encryption.
	CurrentVersionedKeyExpirationTimestamp *date.Time `json:"currentVersionedKeyExpirationTimestamp,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyVaultProperties.
func (kvp KeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kvp.KeyName != nil {
		objectMap["keyname"] = kvp.KeyName
	}
	if kvp.KeyVersion != nil {
		objectMap["keyversion"] = kvp.KeyVersion
	}
	if kvp.KeyVaultURI != nil {
		objectMap["keyvaulturi"] = kvp.KeyVaultURI
	}
	return json.Marshal(objectMap)
}

// LastAccessTimeTrackingPolicy the blob service properties for Last access time based tracking policy.
type LastAccessTimeTrackingPolicy struct {
	// Enable - When set to true last access time based tracking is enabled.
	Enable *bool `json:"enable,omitempty"`
	// Name - Name of the policy. The valid value is AccessTimeTracking. This field is currently read only. Possible values include: 'NameAccessTimeTracking'
	Name Name `json:"name,omitempty"`
	// TrackingGranularityInDays - The field specifies blob object tracking granularity in days, typically how often the blob object should be tracked.This field is currently read only with value as 1
	TrackingGranularityInDays *int32 `json:"trackingGranularityInDays,omitempty"`
	// BlobType - An array of predefined supported blob types. Only blockBlob is the supported value. This field is currently read only
	BlobType *[]string `json:"blobType,omitempty"`
}

// LeaseContainerRequest lease Container request schema.
type LeaseContainerRequest struct {
	// Action - Specifies the lease action. Can be one of the available actions. Possible values include: 'Action1Acquire', 'Action1Renew', 'Action1Change', 'Action1Release', 'Action1Break'
	Action Action1 `json:"action,omitempty"`
	// LeaseID - Identifies the lease. Can be specified in any valid GUID string format.
	LeaseID *string `json:"leaseId,omitempty"`
	// BreakPeriod - Optional. For a break action, proposed duration the lease should continue before it is broken, in seconds, between 0 and 60.
	BreakPeriod *int32 `json:"breakPeriod,omitempty"`
	// LeaseDuration - Required for acquire. Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never expires.
	LeaseDuration *int32 `json:"leaseDuration,omitempty"`
	// ProposedLeaseID - Optional for acquire, required for change. Proposed lease ID, in a GUID string format.
	ProposedLeaseID *string `json:"proposedLeaseId,omitempty"`
}

// LeaseContainerResponse lease Container response schema.
type LeaseContainerResponse struct {
	autorest.Response `json:"-"`
	// LeaseID - Returned unique lease ID that must be included with any request to delete the container, or to renew, change, or release the lease.
	LeaseID *string `json:"leaseId,omitempty"`
	// LeaseTimeSeconds - Approximate time remaining in the lease period, in seconds.
	LeaseTimeSeconds *string `json:"leaseTimeSeconds,omitempty"`
}

// LeaseShareRequest lease Share request schema.
type LeaseShareRequest struct {
	// Action - Specifies the lease action. Can be one of the available actions. Possible values include: 'LeaseShareActionAcquire', 'LeaseShareActionRenew', 'LeaseShareActionChange', 'LeaseShareActionRelease', 'LeaseShareActionBreak'
	Action LeaseShareAction `json:"action,omitempty"`
	// LeaseID - Identifies the lease. Can be specified in any valid GUID string format.
	LeaseID *string `json:"leaseId,omitempty"`
	// BreakPeriod - Optional. For a break action, proposed duration the lease should continue before it is broken, in seconds, between 0 and 60.
	BreakPeriod *int32 `json:"breakPeriod,omitempty"`
	// LeaseDuration - Required for acquire. Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never expires.
	LeaseDuration *int32 `json:"leaseDuration,omitempty"`
	// ProposedLeaseID - Optional for acquire, required for change. Proposed lease ID, in a GUID string format.
	ProposedLeaseID *string `json:"proposedLeaseId,omitempty"`
}

// LeaseShareResponse lease Share response schema.
type LeaseShareResponse struct {
	autorest.Response `json:"-"`
	// LeaseID - Returned unique lease ID that must be included with any request to delete the share, or to renew, change, or release the lease.
	LeaseID *string `json:"leaseId,omitempty"`
	// LeaseTimeSeconds - Approximate time remaining in the lease period, in seconds.
	LeaseTimeSeconds *string `json:"leaseTimeSeconds,omitempty"`
}

// LegalHold the LegalHold property of a blob container.
type LegalHold struct {
	autorest.Response `json:"-"`
	// HasLegalHold - READ-ONLY; The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
	HasLegalHold *bool `json:"hasLegalHold,omitempty"`
	// Tags - Each tag should be 3 to 23 alphanumeric characters and is normalized to lower case at SRP.
	Tags *[]string `json:"tags,omitempty"`
	// AllowProtectedAppendWritesAll - When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining legal hold protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
	AllowProtectedAppendWritesAll *bool `json:"allowProtectedAppendWritesAll,omitempty"`
}

// MarshalJSON is the custom marshaler for LegalHold.
func (lh LegalHold) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lh.Tags != nil {
		objectMap["tags"] = lh.Tags
	}
	if lh.AllowProtectedAppendWritesAll != nil {
		objectMap["allowProtectedAppendWritesAll"] = lh.AllowProtectedAppendWritesAll
	}
	return json.Marshal(objectMap)
}

// LegalHoldProperties the LegalHold property of a blob container.
type LegalHoldProperties struct {
	// HasLegalHold - READ-ONLY; The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
	HasLegalHold *bool `json:"hasLegalHold,omitempty"`
	// Tags - The list of LegalHold tags of a blob container.
	Tags *[]TagProperty `json:"tags,omitempty"`
	// ProtectedAppendWritesHistory - Protected append blob writes history.
	ProtectedAppendWritesHistory *ProtectedAppendWritesHistory `json:"protectedAppendWritesHistory,omitempty"`
}

// MarshalJSON is the custom marshaler for LegalHoldProperties.
func (lhp LegalHoldProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lhp.Tags != nil {
		objectMap["tags"] = lhp.Tags
	}
	if lhp.ProtectedAppendWritesHistory != nil {
		objectMap["protectedAppendWritesHistory"] = lhp.ProtectedAppendWritesHistory
	}
	return json.Marshal(objectMap)
}

// ListAccountSasResponse the List SAS credentials operation response.
type ListAccountSasResponse struct {
	autorest.Response `json:"-"`
	// AccountSasToken - READ-ONLY; List SAS credentials of storage account.
	AccountSasToken *string `json:"accountSasToken,omitempty"`
}

// MarshalJSON is the custom marshaler for ListAccountSasResponse.
func (lasr ListAccountSasResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListBlobInventoryPolicy list of blob inventory policies returned.
type ListBlobInventoryPolicy struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of blob inventory policies.
	Value *[]BlobInventoryPolicy `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ListBlobInventoryPolicy.
func (lbip ListBlobInventoryPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListContainerItem the blob container properties be listed out.
type ListContainerItem struct {
	// ContainerProperties - The blob container properties be listed out.
	*ContainerProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ListContainerItem.
func (lci ListContainerItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lci.ContainerProperties != nil {
		objectMap["properties"] = lci.ContainerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ListContainerItem struct.
func (lci *ListContainerItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var containerProperties ContainerProperties
				err = json.Unmarshal(*v, &containerProperties)
				if err != nil {
					return err
				}
				lci.ContainerProperties = &containerProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lci.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lci.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lci.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lci.Type = &typeVar
			}
		}
	}

	return nil
}

// ListContainerItems response schema. Contains list of blobs returned, and if paging is requested or
// required, a URL to next page of containers.
type ListContainerItems struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of blobs containers returned.
	Value *[]ListContainerItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; Request URL that can be used to query next page of containers. Returned when total number of requested containers exceed maximum page size.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ListContainerItems.
func (lci ListContainerItems) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListContainerItemsIterator provides access to a complete listing of ListContainerItem values.
type ListContainerItemsIterator struct {
	i    int
	page ListContainerItemsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListContainerItemsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListContainerItemsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListContainerItemsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListContainerItemsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListContainerItemsIterator) Response() ListContainerItems {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListContainerItemsIterator) Value() ListContainerItem {
	if !iter.page.NotDone() {
		return ListContainerItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListContainerItemsIterator type.
func NewListContainerItemsIterator(page ListContainerItemsPage) ListContainerItemsIterator {
	return ListContainerItemsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lci ListContainerItems) IsEmpty() bool {
	return lci.Value == nil || len(*lci.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lci ListContainerItems) hasNextLink() bool {
	return lci.NextLink != nil && len(*lci.NextLink) != 0
}

// listContainerItemsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lci ListContainerItems) listContainerItemsPreparer(ctx context.Context) (*http.Request, error) {
	if !lci.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lci.NextLink)))
}

// ListContainerItemsPage contains a page of ListContainerItem values.
type ListContainerItemsPage struct {
	fn  func(context.Context, ListContainerItems) (ListContainerItems, error)
	lci ListContainerItems
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListContainerItemsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListContainerItemsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lci)
		if err != nil {
			return err
		}
		page.lci = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListContainerItemsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListContainerItemsPage) NotDone() bool {
	return !page.lci.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListContainerItemsPage) Response() ListContainerItems {
	return page.lci
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListContainerItemsPage) Values() []ListContainerItem {
	if page.lci.IsEmpty() {
		return nil
	}
	return *page.lci.Value
}

// Creates a new instance of the ListContainerItemsPage type.
func NewListContainerItemsPage(cur ListContainerItems, getNextPage func(context.Context, ListContainerItems) (ListContainerItems, error)) ListContainerItemsPage {
	return ListContainerItemsPage{
		fn:  getNextPage,
		lci: cur,
	}
}

// ListQueue ...
type ListQueue struct {
	// ListQueueProperties - List Queue resource properties.
	*ListQueueProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ListQueue.
func (lq ListQueue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lq.ListQueueProperties != nil {
		objectMap["properties"] = lq.ListQueueProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ListQueue struct.
func (lq *ListQueue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var queueProperties ListQueueProperties
				err = json.Unmarshal(*v, &queueProperties)
				if err != nil {
					return err
				}
				lq.ListQueueProperties = &queueProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lq.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lq.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lq.Type = &typeVar
			}
		}
	}

	return nil
}

// ListQueueProperties ...
type ListQueueProperties struct {
	// Metadata - A name-value pair that represents queue metadata.
	Metadata map[string]*string `json:"metadata"`
}

// MarshalJSON is the custom marshaler for ListQueueProperties.
func (lqp ListQueueProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lqp.Metadata != nil {
		objectMap["metadata"] = lqp.Metadata
	}
	return json.Marshal(objectMap)
}

// ListQueueResource response schema. Contains list of queues returned
type ListQueueResource struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of queues returned.
	Value *[]ListQueue `json:"value,omitempty"`
	// NextLink - READ-ONLY; Request URL that can be used to list next page of queues
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ListQueueResource.
func (lqr ListQueueResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListQueueResourceIterator provides access to a complete listing of ListQueue values.
type ListQueueResourceIterator struct {
	i    int
	page ListQueueResourcePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListQueueResourceIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListQueueResourceIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListQueueResourceIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListQueueResourceIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListQueueResourceIterator) Response() ListQueueResource {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListQueueResourceIterator) Value() ListQueue {
	if !iter.page.NotDone() {
		return ListQueue{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListQueueResourceIterator type.
func NewListQueueResourceIterator(page ListQueueResourcePage) ListQueueResourceIterator {
	return ListQueueResourceIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lqr ListQueueResource) IsEmpty() bool {
	return lqr.Value == nil || len(*lqr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lqr ListQueueResource) hasNextLink() bool {
	return lqr.NextLink != nil && len(*lqr.NextLink) != 0
}

// listQueueResourcePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lqr ListQueueResource) listQueueResourcePreparer(ctx context.Context) (*http.Request, error) {
	if !lqr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lqr.NextLink)))
}

// ListQueueResourcePage contains a page of ListQueue values.
type ListQueueResourcePage struct {
	fn  func(context.Context, ListQueueResource) (ListQueueResource, error)
	lqr ListQueueResource
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListQueueResourcePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListQueueResourcePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lqr)
		if err != nil {
			return err
		}
		page.lqr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListQueueResourcePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListQueueResourcePage) NotDone() bool {
	return !page.lqr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListQueueResourcePage) Response() ListQueueResource {
	return page.lqr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListQueueResourcePage) Values() []ListQueue {
	if page.lqr.IsEmpty() {
		return nil
	}
	return *page.lqr.Value
}

// Creates a new instance of the ListQueueResourcePage type.
func NewListQueueResourcePage(cur ListQueueResource, getNextPage func(context.Context, ListQueueResource) (ListQueueResource, error)) ListQueueResourcePage {
	return ListQueueResourcePage{
		fn:  getNextPage,
		lqr: cur,
	}
}

// ListQueueServices ...
type ListQueueServices struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of queue services returned.
	Value *[]QueueServiceProperties `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ListQueueServices.
func (lqs ListQueueServices) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListServiceSasResponse the List service SAS credentials operation response.
type ListServiceSasResponse struct {
	autorest.Response `json:"-"`
	// ServiceSasToken - READ-ONLY; List service SAS credentials of specific resource.
	ServiceSasToken *string `json:"serviceSasToken,omitempty"`
}

// MarshalJSON is the custom marshaler for ListServiceSasResponse.
func (lssr ListServiceSasResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListTableResource response schema. Contains list of tables returned
type ListTableResource struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of tables returned.
	Value *[]Table `json:"value,omitempty"`
	// NextLink - READ-ONLY; Request URL that can be used to query next page of tables
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ListTableResource.
func (ltr ListTableResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListTableResourceIterator provides access to a complete listing of Table values.
type ListTableResourceIterator struct {
	i    int
	page ListTableResourcePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListTableResourceIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListTableResourceIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListTableResourceIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListTableResourceIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListTableResourceIterator) Response() ListTableResource {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListTableResourceIterator) Value() Table {
	if !iter.page.NotDone() {
		return Table{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListTableResourceIterator type.
func NewListTableResourceIterator(page ListTableResourcePage) ListTableResourceIterator {
	return ListTableResourceIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ltr ListTableResource) IsEmpty() bool {
	return ltr.Value == nil || len(*ltr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ltr ListTableResource) hasNextLink() bool {
	return ltr.NextLink != nil && len(*ltr.NextLink) != 0
}

// listTableResourcePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ltr ListTableResource) listTableResourcePreparer(ctx context.Context) (*http.Request, error) {
	if !ltr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ltr.NextLink)))
}

// ListTableResourcePage contains a page of Table values.
type ListTableResourcePage struct {
	fn  func(context.Context, ListTableResource) (ListTableResource, error)
	ltr ListTableResource
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListTableResourcePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListTableResourcePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ltr)
		if err != nil {
			return err
		}
		page.ltr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListTableResourcePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListTableResourcePage) NotDone() bool {
	return !page.ltr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListTableResourcePage) Response() ListTableResource {
	return page.ltr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListTableResourcePage) Values() []Table {
	if page.ltr.IsEmpty() {
		return nil
	}
	return *page.ltr.Value
}

// Creates a new instance of the ListTableResourcePage type.
func NewListTableResourcePage(cur ListTableResource, getNextPage func(context.Context, ListTableResource) (ListTableResource, error)) ListTableResourcePage {
	return ListTableResourcePage{
		fn:  getNextPage,
		ltr: cur,
	}
}

// ListTableServices ...
type ListTableServices struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of table services returned.
	Value *[]TableServiceProperties `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ListTableServices.
func (lts ListTableServices) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LocalUser the local user associated with the storage accounts.
type LocalUser struct {
	autorest.Response `json:"-"`
	// LocalUserProperties - Storage account local user properties.
	*LocalUserProperties `json:"properties,omitempty"`
	SystemData           *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LocalUser.
func (lu LocalUser) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lu.LocalUserProperties != nil {
		objectMap["properties"] = lu.LocalUserProperties
	}
	if lu.SystemData != nil {
		objectMap["systemData"] = lu.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LocalUser struct.
func (lu *LocalUser) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var localUserProperties LocalUserProperties
				err = json.Unmarshal(*v, &localUserProperties)
				if err != nil {
					return err
				}
				lu.LocalUserProperties = &localUserProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				lu.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lu.Type = &typeVar
			}
		}
	}

	return nil
}

// LocalUserKeys the Storage Account Local User keys.
type LocalUserKeys struct {
	autorest.Response `json:"-"`
	SSHAuthorizedKeys *[]SSHPublicKey `json:"sshAuthorizedKeys,omitempty"`
	SharedKey         *string         `json:"sharedKey,omitempty"`
}

// LocalUserProperties the Storage Account Local User properties.
type LocalUserProperties struct {
	// PermissionScopes - The permission scopes of the local user.
	PermissionScopes *[]PermissionScope `json:"permissionScopes,omitempty"`
	// HomeDirectory - Optional, local user home directory.
	HomeDirectory     *string         `json:"homeDirectory,omitempty"`
	SSHAuthorizedKeys *[]SSHPublicKey `json:"sshAuthorizedKeys,omitempty"`
	// Sid - READ-ONLY; A unique Security Identifier that is generated by the server.
	Sid *string `json:"sid,omitempty"`
	// HasSharedKey - Indicates whether shared key exists. Set it to false to remove existing shared key.
	HasSharedKey *bool `json:"hasSharedKey,omitempty"`
	// HasSSHKey - Indicates whether ssh key exists. Set it to false to remove existing SSH key.
	HasSSHKey *bool `json:"hasSshKey,omitempty"`
	// HasSSHPassword - Indicates whether ssh password exists. Set it to false to remove existing SSH password.
	HasSSHPassword *bool `json:"hasSshPassword,omitempty"`
}

// MarshalJSON is the custom marshaler for LocalUserProperties.
func (lup LocalUserProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lup.PermissionScopes != nil {
		objectMap["permissionScopes"] = lup.PermissionScopes
	}
	if lup.HomeDirectory != nil {
		objectMap["homeDirectory"] = lup.HomeDirectory
	}
	if lup.SSHAuthorizedKeys != nil {
		objectMap["sshAuthorizedKeys"] = lup.SSHAuthorizedKeys
	}
	if lup.HasSharedKey != nil {
		objectMap["hasSharedKey"] = lup.HasSharedKey
	}
	if lup.HasSSHKey != nil {
		objectMap["hasSshKey"] = lup.HasSSHKey
	}
	if lup.HasSSHPassword != nil {
		objectMap["hasSshPassword"] = lup.HasSSHPassword
	}
	return json.Marshal(objectMap)
}

// LocalUserRegeneratePasswordResult the secrets of Storage Account Local User.
type LocalUserRegeneratePasswordResult struct {
	autorest.Response `json:"-"`
	// SSHPassword - READ-ONLY; Auto generated password by the server for SSH authentication if hasSshPassword is set to true on the creation of local user.
	SSHPassword *string `json:"sshPassword,omitempty"`
}

// MarshalJSON is the custom marshaler for LocalUserRegeneratePasswordResult.
func (lurpr LocalUserRegeneratePasswordResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LocalUsers list storage account local users.
type LocalUsers struct {
	autorest.Response `json:"-"`
	// Value - The local users associated with the storage account.
	Value *[]LocalUser `json:"value,omitempty"`
}

// ManagementPolicy the Get Storage Account ManagementPolicies operation response.
type ManagementPolicy struct {
	autorest.Response `json:"-"`
	// ManagementPolicyProperties - Returns the Storage Account Data Policies Rules.
	*ManagementPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementPolicy.
func (mp ManagementPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mp.ManagementPolicyProperties != nil {
		objectMap["properties"] = mp.ManagementPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagementPolicy struct.
func (mp *ManagementPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managementPolicyProperties ManagementPolicyProperties
				err = json.Unmarshal(*v, &managementPolicyProperties)
				if err != nil {
					return err
				}
				mp.ManagementPolicyProperties = &managementPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mp.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagementPolicyAction actions are applied to the filtered blobs when the execution condition is met.
type ManagementPolicyAction struct {
	// BaseBlob - The management policy action for base blob
	BaseBlob *ManagementPolicyBaseBlob `json:"baseBlob,omitempty"`
	// Snapshot - The management policy action for snapshot
	Snapshot *ManagementPolicySnapShot `json:"snapshot,omitempty"`
	// Version - The management policy action for version
	Version *ManagementPolicyVersion `json:"version,omitempty"`
}

// ManagementPolicyBaseBlob management policy action for base blob.
type ManagementPolicyBaseBlob struct {
	// TierToCool - The function to tier blobs to cool storage. Support blobs currently at Hot tier
	TierToCool *DateAfterModification `json:"tierToCool,omitempty"`
	// TierToArchive - The function to tier blobs to archive storage. Support blobs currently at Hot or Cool tier
	TierToArchive *DateAfterModification `json:"tierToArchive,omitempty"`
	// Delete - The function to delete the blob
	Delete *DateAfterModification `json:"delete,omitempty"`
	// EnableAutoTierToHotFromCool - This property enables auto tiering of a blob from cool to hot on a blob access. This property requires tierToCool.daysAfterLastAccessTimeGreaterThan.
	EnableAutoTierToHotFromCool *bool `json:"enableAutoTierToHotFromCool,omitempty"`
}

// ManagementPolicyDefinition an object that defines the Lifecycle rule. Each definition is made up with a
// filters set and an actions set.
type ManagementPolicyDefinition struct {
	// Actions - An object that defines the action set.
	Actions *ManagementPolicyAction `json:"actions,omitempty"`
	// Filters - An object that defines the filter set.
	Filters *ManagementPolicyFilter `json:"filters,omitempty"`
}

// ManagementPolicyFilter filters limit rule actions to a subset of blobs within the storage account. If
// multiple filters are defined, a logical AND is performed on all filters.
type ManagementPolicyFilter struct {
	// PrefixMatch - An array of strings for prefixes to be match.
	PrefixMatch *[]string `json:"prefixMatch,omitempty"`
	// BlobTypes - An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
	BlobTypes *[]string `json:"blobTypes,omitempty"`
	// BlobIndexMatch - An array of blob index tag based filters, there can be at most 10 tag filters
	BlobIndexMatch *[]TagFilter `json:"blobIndexMatch,omitempty"`
}

// ManagementPolicyProperties the Storage Account ManagementPolicy properties.
type ManagementPolicyProperties struct {
	// LastModifiedTime - READ-ONLY; Returns the date and time the ManagementPolicies was last modified.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Policy - The Storage Account ManagementPolicy, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
	Policy *ManagementPolicySchema `json:"policy,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementPolicyProperties.
func (mpp ManagementPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mpp.Policy != nil {
		objectMap["policy"] = mpp.Policy
	}
	return json.Marshal(objectMap)
}

// ManagementPolicyRule an object that wraps the Lifecycle rule. Each rule is uniquely defined by name.
type ManagementPolicyRule struct {
	// Enabled - Rule is enabled if set to true.
	Enabled *bool `json:"enabled,omitempty"`
	// Name - A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
	Name *string `json:"name,omitempty"`
	// Type - The valid value is Lifecycle
	Type *string `json:"type,omitempty"`
	// Definition - An object that defines the Lifecycle rule.
	Definition *ManagementPolicyDefinition `json:"definition,omitempty"`
}

// ManagementPolicySchema the Storage Account ManagementPolicies Rules. See more details in:
// https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
type ManagementPolicySchema struct {
	// Rules - The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
	Rules *[]ManagementPolicyRule `json:"rules,omitempty"`
}

// ManagementPolicySnapShot management policy action for snapshot.
type ManagementPolicySnapShot struct {
	// TierToCool - The function to tier blob snapshot to cool storage. Support blob snapshot currently at Hot tier
	TierToCool *DateAfterCreation `json:"tierToCool,omitempty"`
	// TierToArchive - The function to tier blob snapshot to archive storage. Support blob snapshot currently at Hot or Cool tier
	TierToArchive *DateAfterCreation `json:"tierToArchive,omitempty"`
	// Delete - The function to delete the blob snapshot
	Delete *DateAfterCreation `json:"delete,omitempty"`
}

// ManagementPolicyVersion management policy action for blob version.
type ManagementPolicyVersion struct {
	// TierToCool - The function to tier blob version to cool storage. Support blob version currently at Hot tier
	TierToCool *DateAfterCreation `json:"tierToCool,omitempty"`
	// TierToArchive - The function to tier blob version to archive storage. Support blob version currently at Hot or Cool tier
	TierToArchive *DateAfterCreation `json:"tierToArchive,omitempty"`
	// Delete - The function to delete the blob version
	Delete *DateAfterCreation `json:"delete,omitempty"`
}

// MetricSpecification metric specification of operation.
type MetricSpecification struct {
	// Name - Name of metric specification.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of metric specification.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Display description of metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Unit could be Bytes or Count.
	Unit *string `json:"unit,omitempty"`
	// Dimensions - Dimensions of blobs, including blob type and access tier.
	Dimensions *[]Dimension `json:"dimensions,omitempty"`
	// AggregationType - Aggregation type could be Average.
	AggregationType *string `json:"aggregationType,omitempty"`
	// FillGapWithZero - The property to decide fill gap with zero or not.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Category - The category this metric specification belong to, could be Capacity.
	Category *string `json:"category,omitempty"`
	// ResourceIDDimensionNameOverride - Account Resource Id.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`
}

// Multichannel multichannel setting. Applies to Premium FileStorage only.
type Multichannel struct {
	// Enabled - Indicates whether multichannel is enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// NetworkRuleSet network rule set
type NetworkRuleSet struct {
	// Bypass - Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics. Possible values include: 'BypassNone', 'BypassLogging', 'BypassMetrics', 'BypassAzureServices'
	Bypass Bypass `json:"bypass,omitempty"`
	// ResourceAccessRules - Sets the resource access rules
	ResourceAccessRules *[]ResourceAccessRule `json:"resourceAccessRules,omitempty"`
	// VirtualNetworkRules - Sets the virtual network rules
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// IPRules - Sets the IP ACL rules
	IPRules *[]IPRule `json:"ipRules,omitempty"`
	// DefaultAction - Specifies the default action of allow or deny when no other rules match. Possible values include: 'DefaultActionAllow', 'DefaultActionDeny'
	DefaultAction DefaultAction `json:"defaultAction,omitempty"`
}

// ObjectReplicationPolicies list storage account object replication policies.
type ObjectReplicationPolicies struct {
	autorest.Response `json:"-"`
	// Value - The replication policy between two storage accounts.
	Value *[]ObjectReplicationPolicy `json:"value,omitempty"`
}

// ObjectReplicationPolicy the replication policy between two storage accounts. Multiple rules can be
// defined in one policy.
type ObjectReplicationPolicy struct {
	autorest.Response `json:"-"`
	// ObjectReplicationPolicyProperties - Returns the Storage Account Object Replication Policy.
	*ObjectReplicationPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ObjectReplicationPolicy.
func (orp ObjectReplicationPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if orp.ObjectReplicationPolicyProperties != nil {
		objectMap["properties"] = orp.ObjectReplicationPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ObjectReplicationPolicy struct.
func (orp *ObjectReplicationPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var objectReplicationPolicyProperties ObjectReplicationPolicyProperties
				err = json.Unmarshal(*v, &objectReplicationPolicyProperties)
				if err != nil {
					return err
				}
				orp.ObjectReplicationPolicyProperties = &objectReplicationPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				orp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				orp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				orp.Type = &typeVar
			}
		}
	}

	return nil
}

// ObjectReplicationPolicyFilter filters limit replication to a subset of blobs within the storage account.
// A logical OR is performed on values in the filter. If multiple filters are defined, a logical AND is
// performed on all filters.
type ObjectReplicationPolicyFilter struct {
	// PrefixMatch - Optional. Filters the results to replicate only blobs whose names begin with the specified prefix.
	PrefixMatch *[]string `json:"prefixMatch,omitempty"`
	// MinCreationTime - Blobs created after the time will be replicated to the destination. It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'. Example: 2020-02-19T16:05:00Z
	MinCreationTime *string `json:"minCreationTime,omitempty"`
}

// ObjectReplicationPolicyProperties the Storage Account ObjectReplicationPolicy properties.
type ObjectReplicationPolicyProperties struct {
	// PolicyID - READ-ONLY; A unique id for object replication policy.
	PolicyID *string `json:"policyId,omitempty"`
	// EnabledTime - READ-ONLY; Indicates when the policy is enabled on the source account.
	EnabledTime *date.Time `json:"enabledTime,omitempty"`
	// SourceAccount - Required. Source account name. It should be full resource id if allowCrossTenantReplication set to false.
	SourceAccount *string `json:"sourceAccount,omitempty"`
	// DestinationAccount - Required. Destination account name. It should be full resource id if allowCrossTenantReplication set to false.
	DestinationAccount *string `json:"destinationAccount,omitempty"`
	// Rules - The storage account object replication rules.
	Rules *[]ObjectReplicationPolicyRule `json:"rules,omitempty"`
}

// MarshalJSON is the custom marshaler for ObjectReplicationPolicyProperties.
func (orpp ObjectReplicationPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if orpp.SourceAccount != nil {
		objectMap["sourceAccount"] = orpp.SourceAccount
	}
	if orpp.DestinationAccount != nil {
		objectMap["destinationAccount"] = orpp.DestinationAccount
	}
	if orpp.Rules != nil {
		objectMap["rules"] = orpp.Rules
	}
	return json.Marshal(objectMap)
}

// ObjectReplicationPolicyRule the replication policy rule between two containers.
type ObjectReplicationPolicyRule struct {
	// RuleID - Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source account.
	RuleID *string `json:"ruleId,omitempty"`
	// SourceContainer - Required. Source container name.
	SourceContainer *string `json:"sourceContainer,omitempty"`
	// DestinationContainer - Required. Destination container name.
	DestinationContainer *string `json:"destinationContainer,omitempty"`
	// Filters - Optional. An object that defines the filter set.
	Filters *ObjectReplicationPolicyFilter `json:"filters,omitempty"`
}

// Operation storage REST API operation definition.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - The origin of operations.
	Origin *string `json:"origin,omitempty"`
	// OperationProperties - Properties of operation, include metric specifications.
	*OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.OperationProperties != nil {
		objectMap["properties"] = o.OperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				o.Origin = &origin
			}
		case "properties":
			if v != nil {
				var operationProperties OperationProperties
				err = json.Unmarshal(*v, &operationProperties)
				if err != nil {
					return err
				}
				o.OperationProperties = &operationProperties
			}
		}
	}

	return nil
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft Storage.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list Storage operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Storage operations supported by the Storage resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// OperationProperties properties of operation, include metric specifications.
type OperationProperties struct {
	// ServiceSpecification - One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// PermissionScope ...
type PermissionScope struct {
	// Permissions - The permissions for the local user. Possible values include: Read (r), Write (w), Delete (d), List (l), and Create (c).
	Permissions *string `json:"permissions,omitempty"`
	// Service - The service used by the local user, e.g. blob, file.
	Service *string `json:"service,omitempty"`
	// ResourceName - The name of resource, normally the container name or the file share name, used by the local user.
	ResourceName *string `json:"resourceName,omitempty"`
}

// PrivateEndpoint the Private Endpoint resource.
type PrivateEndpoint struct {
	// ID - READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection the Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult list of private endpoint connection associated with the specified
// storage account
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private endpoint connections
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint connection resource. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState a collection of information about the state of the connection between
// service consumer and provider.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'PrivateEndpointServiceConnectionStatusPending', 'PrivateEndpointServiceConnectionStatusApproved', 'PrivateEndpointServiceConnectionStatusRejected'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionRequired *string `json:"actionRequired,omitempty"`
}

// ProtectedAppendWritesHistory protected append writes history setting for the blob container with Legal
// holds.
type ProtectedAppendWritesHistory struct {
	// AllowProtectedAppendWritesAll - When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining legal hold protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
	AllowProtectedAppendWritesAll *bool `json:"allowProtectedAppendWritesAll,omitempty"`
	// Timestamp - READ-ONLY; Returns the date and time the tag was added.
	Timestamp *date.Time `json:"timestamp,omitempty"`
}

// MarshalJSON is the custom marshaler for ProtectedAppendWritesHistory.
func (pawh ProtectedAppendWritesHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pawh.AllowProtectedAppendWritesAll != nil {
		objectMap["allowProtectedAppendWritesAll"] = pawh.AllowProtectedAppendWritesAll
	}
	return json.Marshal(objectMap)
}

// ProtocolSettings protocol settings for file service
type ProtocolSettings struct {
	// Smb - Setting for SMB protocol
	Smb *SmbSetting `json:"smb,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Queue ...
type Queue struct {
	autorest.Response `json:"-"`
	// QueueProperties - Queue resource properties.
	*QueueProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Queue.
func (q Queue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if q.QueueProperties != nil {
		objectMap["properties"] = q.QueueProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Queue struct.
func (q *Queue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var queueProperties QueueProperties
				err = json.Unmarshal(*v, &queueProperties)
				if err != nil {
					return err
				}
				q.QueueProperties = &queueProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				q.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				q.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				q.Type = &typeVar
			}
		}
	}

	return nil
}

// QueueProperties ...
type QueueProperties struct {
	// Metadata - A name-value pair that represents queue metadata.
	Metadata map[string]*string `json:"metadata"`
	// ApproximateMessageCount - READ-ONLY; Integer indicating an approximate number of messages in the queue. This number is not lower than the actual number of messages in the queue, but could be higher.
	ApproximateMessageCount *int32 `json:"approximateMessageCount,omitempty"`
}

// MarshalJSON is the custom marshaler for QueueProperties.
func (qp QueueProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qp.Metadata != nil {
		objectMap["metadata"] = qp.Metadata
	}
	return json.Marshal(objectMap)
}

// QueueServiceProperties the properties of a storage account’s Queue service.
type QueueServiceProperties struct {
	autorest.Response `json:"-"`
	// QueueServicePropertiesProperties - The properties of a storage account’s Queue service.
	*QueueServicePropertiesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for QueueServiceProperties.
func (qsp QueueServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qsp.QueueServicePropertiesProperties != nil {
		objectMap["properties"] = qsp.QueueServicePropertiesProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for QueueServiceProperties struct.
func (qsp *QueueServiceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var queueServiceProperties QueueServicePropertiesProperties
				err = json.Unmarshal(*v, &queueServiceProperties)
				if err != nil {
					return err
				}
				qsp.QueueServicePropertiesProperties = &queueServiceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				qsp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				qsp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				qsp.Type = &typeVar
			}
		}
	}

	return nil
}

// QueueServicePropertiesProperties the properties of a storage account’s Queue service.
type QueueServicePropertiesProperties struct {
	// Cors - Specifies CORS rules for the Queue service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Queue service.
	Cors *CorsRules `json:"cors,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceAccessRule resource Access Rule.
type ResourceAccessRule struct {
	// TenantID - Tenant Id
	TenantID *string `json:"tenantId,omitempty"`
	// ResourceID - Resource Id
	ResourceID *string `json:"resourceId,omitempty"`
}

// RestorePolicyProperties the blob service properties for blob restore policy
type RestorePolicyProperties struct {
	// Enabled - Blob restore is enabled if set to true.
	Enabled *bool `json:"enabled,omitempty"`
	// Days - how long this blob can be restored. It should be great than zero and less than DeleteRetentionPolicy.days.
	Days *int32 `json:"days,omitempty"`
	// LastEnabledTime - READ-ONLY; Deprecated in favor of minRestoreTime property.
	LastEnabledTime *date.Time `json:"lastEnabledTime,omitempty"`
	// MinRestoreTime - READ-ONLY; Returns the minimum date and time that the restore can be started.
	MinRestoreTime *date.Time `json:"minRestoreTime,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorePolicyProperties.
func (rpp RestorePolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpp.Enabled != nil {
		objectMap["enabled"] = rpp.Enabled
	}
	if rpp.Days != nil {
		objectMap["days"] = rpp.Days
	}
	return json.Marshal(objectMap)
}

// Restriction the restriction because of which SKU cannot be used.
type Restriction struct {
	// Type - READ-ONLY; The type of restrictions. As of now only possible value for this is location.
	Type *string `json:"type,omitempty"`
	// Values - READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
	Values *[]string `json:"values,omitempty"`
	// ReasonCode - The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. The "NotAvailableForSubscription" is related to capacity at DC. Possible values include: 'ReasonCodeQuotaID', 'ReasonCodeNotAvailableForSubscription'
	ReasonCode ReasonCode `json:"reasonCode,omitempty"`
}

// MarshalJSON is the custom marshaler for Restriction.
func (r Restriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ReasonCode != "" {
		objectMap["reasonCode"] = r.ReasonCode
	}
	return json.Marshal(objectMap)
}

// RoutingPreference routing preference defines the type of network, either microsoft or internet routing
// to be used to deliver the user data, the default option is microsoft routing
type RoutingPreference struct {
	// RoutingChoice - Routing Choice defines the kind of network routing opted by the user. Possible values include: 'RoutingChoiceMicrosoftRouting', 'RoutingChoiceInternetRouting'
	RoutingChoice RoutingChoice `json:"routingChoice,omitempty"`
	// PublishMicrosoftEndpoints - A boolean flag which indicates whether microsoft routing storage endpoints are to be published
	PublishMicrosoftEndpoints *bool `json:"publishMicrosoftEndpoints,omitempty"`
	// PublishInternetEndpoints - A boolean flag which indicates whether internet routing storage endpoints are to be published
	PublishInternetEndpoints *bool `json:"publishInternetEndpoints,omitempty"`
}

// SasPolicy sasPolicy assigned to the storage account.
type SasPolicy struct {
	// SasExpirationPeriod - The SAS expiration period, DD.HH:MM:SS.
	SasExpirationPeriod *string `json:"sasExpirationPeriod,omitempty"`
	// ExpirationAction - The SAS expiration action. Can only be Log.
	ExpirationAction *string `json:"expirationAction,omitempty"`
}

// ServiceSasParameters the parameters to list service SAS credentials of a specific resource.
type ServiceSasParameters struct {
	// CanonicalizedResource - The canonical path to the signed resource.
	CanonicalizedResource *string `json:"canonicalizedResource,omitempty"`
	// Resource - The signed services accessible with the service SAS. Possible values include: Blob (b), Container (c), File (f), Share (s). Possible values include: 'SignedResourceB', 'SignedResourceC', 'SignedResourceF', 'SignedResourceS'
	Resource SignedResource `json:"signedResource,omitempty"`
	// Permissions - The signed permissions for the service SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). Possible values include: 'PermissionsR', 'PermissionsD', 'PermissionsW', 'PermissionsL', 'PermissionsA', 'PermissionsC', 'PermissionsU', 'PermissionsP'
	Permissions Permissions `json:"signedPermission,omitempty"`
	// IPAddressOrRange - An IP address or a range of IP addresses from which to accept requests.
	IPAddressOrRange *string `json:"signedIp,omitempty"`
	// Protocols - The protocol permitted for a request made with the account SAS. Possible values include: 'HTTPProtocolHttpshttp', 'HTTPProtocolHTTPS'
	Protocols HTTPProtocol `json:"signedProtocol,omitempty"`
	// SharedAccessStartTime - The time at which the SAS becomes valid.
	SharedAccessStartTime *date.Time `json:"signedStart,omitempty"`
	// SharedAccessExpiryTime - The time at which the shared access signature becomes invalid.
	SharedAccessExpiryTime *date.Time `json:"signedExpiry,omitempty"`
	// Identifier - A unique value up to 64 characters in length that correlates to an access policy specified for the container, queue, or table.
	Identifier *string `json:"signedIdentifier,omitempty"`
	// PartitionKeyStart - The start of partition key.
	PartitionKeyStart *string `json:"startPk,omitempty"`
	// PartitionKeyEnd - The end of partition key.
	PartitionKeyEnd *string `json:"endPk,omitempty"`
	// RowKeyStart - The start of row key.
	RowKeyStart *string `json:"startRk,omitempty"`
	// RowKeyEnd - The end of row key.
	RowKeyEnd *string `json:"endRk,omitempty"`
	// KeyToSign - The key to sign the account SAS token with.
	KeyToSign *string `json:"keyToSign,omitempty"`
	// CacheControl - The response header override for cache control.
	CacheControl *string `json:"rscc,omitempty"`
	// ContentDisposition - The response header override for content disposition.
	ContentDisposition *string `json:"rscd,omitempty"`
	// ContentEncoding - The response header override for content encoding.
	ContentEncoding *string `json:"rsce,omitempty"`
	// ContentLanguage - The response header override for content language.
	ContentLanguage *string `json:"rscl,omitempty"`
	// ContentType - The response header override for content type.
	ContentType *string `json:"rsct,omitempty"`
}

// ServiceSpecification one property of operation, include metric specifications.
type ServiceSpecification struct {
	// MetricSpecifications - Metric specifications of operation.
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// SignedIdentifier ...
type SignedIdentifier struct {
	// ID - An unique identifier of the stored access policy.
	ID *string `json:"id,omitempty"`
	// AccessPolicy - Access policy
	AccessPolicy *AccessPolicy `json:"accessPolicy,omitempty"`
}

// Sku the SKU of the storage account.
type Sku struct {
	// Name - Possible values include: 'SkuNameStandardLRS', 'SkuNameStandardGRS', 'SkuNameStandardRAGRS', 'SkuNameStandardZRS', 'SkuNamePremiumLRS', 'SkuNamePremiumZRS', 'SkuNameStandardGZRS', 'SkuNameStandardRAGZRS'
	Name SkuName `json:"name,omitempty"`
	// Tier - Possible values include: 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
}

// SKUCapability the capability information in the specified SKU, including file encryption, network ACLs,
// change notification, etc.
type SKUCapability struct {
	// Name - READ-ONLY; The name of capability, The capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; A string value to indicate states of given capability. Possibly 'true' or 'false'.
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for SKUCapability.
func (sc SKUCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SkuInformation storage SKU and its properties
type SkuInformation struct {
	// Name - Possible values include: 'SkuNameStandardLRS', 'SkuNameStandardGRS', 'SkuNameStandardRAGRS', 'SkuNameStandardZRS', 'SkuNamePremiumLRS', 'SkuNamePremiumZRS', 'SkuNameStandardGZRS', 'SkuNameStandardRAGZRS'
	Name SkuName `json:"name,omitempty"`
	// Tier - Possible values include: 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
	// ResourceType - READ-ONLY; The type of the resource, usually it is 'storageAccounts'.
	ResourceType *string `json:"resourceType,omitempty"`
	// Kind - READ-ONLY; Indicates the type of storage account. Possible values include: 'KindStorage', 'KindStorageV2', 'KindBlobStorage', 'KindFileStorage', 'KindBlockBlobStorage'
	Kind Kind `json:"kind,omitempty"`
	// Locations - READ-ONLY; The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
	Locations *[]string `json:"locations,omitempty"`
	// Capabilities - READ-ONLY; The capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.
	Capabilities *[]SKUCapability `json:"capabilities,omitempty"`
	// Restrictions - The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions *[]Restriction `json:"restrictions,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuInformation.
func (si SkuInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if si.Name != "" {
		objectMap["name"] = si.Name
	}
	if si.Tier != "" {
		objectMap["tier"] = si.Tier
	}
	if si.Restrictions != nil {
		objectMap["restrictions"] = si.Restrictions
	}
	return json.Marshal(objectMap)
}

// SkuListResult the response from the List Storage SKUs operation.
type SkuListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Get the list result of storage SKUs and their properties.
	Value *[]SkuInformation `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuListResult.
func (slr SkuListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SmbSetting setting for SMB protocol
type SmbSetting struct {
	// Multichannel - Multichannel setting. Applies to Premium FileStorage only.
	Multichannel *Multichannel `json:"multichannel,omitempty"`
	// Versions - SMB protocol versions supported by server. Valid values are SMB2.1, SMB3.0, SMB3.1.1. Should be passed as a string with delimiter ';'.
	Versions *string `json:"versions,omitempty"`
	// AuthenticationMethods - SMB authentication methods supported by server. Valid values are NTLMv2, Kerberos. Should be passed as a string with delimiter ';'.
	AuthenticationMethods *string `json:"authenticationMethods,omitempty"`
	// KerberosTicketEncryption - Kerberos ticket encryption supported by server. Valid values are RC4-HMAC, AES-256. Should be passed as a string with delimiter ';'
	KerberosTicketEncryption *string `json:"kerberosTicketEncryption,omitempty"`
	// ChannelEncryption - SMB channel encryption supported by server. Valid values are AES-128-CCM, AES-128-GCM, AES-256-GCM. Should be passed as a string with delimiter ';'.
	ChannelEncryption *string `json:"channelEncryption,omitempty"`
}

// SSHPublicKey ...
type SSHPublicKey struct {
	// Description - Optional. It is used to store the function/usage of the key
	Description *string `json:"description,omitempty"`
	// Key - Ssh public key base64 encoded. The format should be: '<keyType> <keyData>', e.g. ssh-rsa AAAABBBB
	Key *string `json:"key,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// Table properties of the table, including Id, resource name, resource type.
type Table struct {
	autorest.Response `json:"-"`
	// TableProperties - Table resource properties.
	*TableProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Table.
func (t Table) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.TableProperties != nil {
		objectMap["properties"] = t.TableProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Table struct.
func (t *Table) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tableProperties TableProperties
				err = json.Unmarshal(*v, &tableProperties)
				if err != nil {
					return err
				}
				t.TableProperties = &tableProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		}
	}

	return nil
}

// TableAccessPolicy table Access Policy Properties Object.
type TableAccessPolicy struct {
	// StartTime - Start time of the access policy
	StartTime *date.Time `json:"startTime,omitempty"`
	// ExpiryTime - Expiry time of the access policy
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// Permission - Required. List of abbreviated permissions. Supported permission values include 'r','a','u','d'
	Permission *string `json:"permission,omitempty"`
}

// TableProperties ...
type TableProperties struct {
	// TableName - READ-ONLY; Table name under the specified account
	TableName *string `json:"tableName,omitempty"`
	// SignedIdentifiers - List of stored access policies specified on the table.
	SignedIdentifiers *[]TableSignedIdentifier `json:"signedIdentifiers,omitempty"`
}

// MarshalJSON is the custom marshaler for TableProperties.
func (tp TableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.SignedIdentifiers != nil {
		objectMap["signedIdentifiers"] = tp.SignedIdentifiers
	}
	return json.Marshal(objectMap)
}

// TableServiceProperties the properties of a storage account’s Table service.
type TableServiceProperties struct {
	autorest.Response `json:"-"`
	// TableServicePropertiesProperties - The properties of a storage account’s Table service.
	*TableServicePropertiesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TableServiceProperties.
func (tsp TableServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tsp.TableServicePropertiesProperties != nil {
		objectMap["properties"] = tsp.TableServicePropertiesProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TableServiceProperties struct.
func (tsp *TableServiceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tableServiceProperties TableServicePropertiesProperties
				err = json.Unmarshal(*v, &tableServiceProperties)
				if err != nil {
					return err
				}
				tsp.TableServicePropertiesProperties = &tableServiceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tsp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tsp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tsp.Type = &typeVar
			}
		}
	}

	return nil
}

// TableServicePropertiesProperties the properties of a storage account’s Table service.
type TableServicePropertiesProperties struct {
	// Cors - Specifies CORS rules for the Table service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Table service.
	Cors *CorsRules `json:"cors,omitempty"`
}

// TableSignedIdentifier object to set Table Access Policy.
type TableSignedIdentifier struct {
	// ID - unique-64-character-value of the stored access policy.
	ID *string `json:"id,omitempty"`
	// AccessPolicy - Access policy
	AccessPolicy *TableAccessPolicy `json:"accessPolicy,omitempty"`
}

// TagFilter blob index tag based filtering for blob objects
type TagFilter struct {
	// Name - This is the filter tag name, it can have 1 - 128 characters
	Name *string `json:"name,omitempty"`
	// Op - This is the comparison operator which is used for object comparison and filtering. Only == (equality operator) is currently supported
	Op *string `json:"op,omitempty"`
	// Value - This is the filter tag value field used for tag based filtering, it can have 0 - 256 characters
	Value *string `json:"value,omitempty"`
}

// TagProperty a tag of the LegalHold of a blob container.
type TagProperty struct {
	// Tag - READ-ONLY; The tag value.
	Tag *string `json:"tag,omitempty"`
	// Timestamp - READ-ONLY; Returns the date and time the tag was added.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// ObjectIdentifier - READ-ONLY; Returns the Object ID of the user who added the tag.
	ObjectIdentifier *string `json:"objectIdentifier,omitempty"`
	// TenantID - READ-ONLY; Returns the Tenant ID that issued the token for the user who added the tag.
	TenantID *string `json:"tenantId,omitempty"`
	// Upn - READ-ONLY; Returns the User Principal Name of the user who added the tag.
	Upn *string `json:"upn,omitempty"`
}

// MarshalJSON is the custom marshaler for TagProperty.
func (tp TagProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UpdateHistoryProperty an update history of the ImmutabilityPolicy of a blob container.
type UpdateHistoryProperty struct {
	// Update - READ-ONLY; The ImmutabilityPolicy update type of a blob container, possible values include: put, lock and extend. Possible values include: 'ImmutabilityPolicyUpdateTypePut', 'ImmutabilityPolicyUpdateTypeLock', 'ImmutabilityPolicyUpdateTypeExtend'
	Update ImmutabilityPolicyUpdateType `json:"update,omitempty"`
	// ImmutabilityPeriodSinceCreationInDays - READ-ONLY; The immutability period for the blobs in the container since the policy creation, in days.
	ImmutabilityPeriodSinceCreationInDays *int32 `json:"immutabilityPeriodSinceCreationInDays,omitempty"`
	// Timestamp - READ-ONLY; Returns the date and time the ImmutabilityPolicy was updated.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// ObjectIdentifier - READ-ONLY; Returns the Object ID of the user who updated the ImmutabilityPolicy.
	ObjectIdentifier *string `json:"objectIdentifier,omitempty"`
	// TenantID - READ-ONLY; Returns the Tenant ID that issued the token for the user who updated the ImmutabilityPolicy.
	TenantID *string `json:"tenantId,omitempty"`
	// Upn - READ-ONLY; Returns the User Principal Name of the user who updated the ImmutabilityPolicy.
	Upn *string `json:"upn,omitempty"`
	// AllowProtectedAppendWrites - This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API.
	AllowProtectedAppendWrites *bool `json:"allowProtectedAppendWrites,omitempty"`
	// AllowProtectedAppendWritesAll - This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and 'allowProtectedAppendWritesAll' properties are mutually exclusive.
	AllowProtectedAppendWritesAll *bool `json:"allowProtectedAppendWritesAll,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateHistoryProperty.
func (uhp UpdateHistoryProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uhp.AllowProtectedAppendWrites != nil {
		objectMap["allowProtectedAppendWrites"] = uhp.AllowProtectedAppendWrites
	}
	if uhp.AllowProtectedAppendWritesAll != nil {
		objectMap["allowProtectedAppendWritesAll"] = uhp.AllowProtectedAppendWritesAll
	}
	return json.Marshal(objectMap)
}

// Usage describes Storage Resource Usage.
type Usage struct {
	// Unit - READ-ONLY; Gets the unit of measurement. Possible values include: 'UsageUnitCount', 'UsageUnitBytes', 'UsageUnitSeconds', 'UsageUnitPercent', 'UsageUnitCountsPerSecond', 'UsageUnitBytesPerSecond'
	Unit UsageUnit `json:"unit,omitempty"`
	// CurrentValue - READ-ONLY; Gets the current count of the allocated resources in the subscription.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; Gets the maximum count of the resources that can be allocated in the subscription.
	Limit *int32 `json:"limit,omitempty"`
	// Name - READ-ONLY; Gets the name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UsageListResult the response from the List Usages operation.
type UsageListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list of Storage Resource Usages.
	Value *[]Usage `json:"value,omitempty"`
}

// UsageName the usage names that can be used; currently limited to StorageAccount.
type UsageName struct {
	// Value - READ-ONLY; Gets a string describing the resource name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; Gets a localized string describing the resource name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MarshalJSON is the custom marshaler for UsageName.
func (un UsageName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UserAssignedIdentity userAssignedIdentity for the resource.
type UserAssignedIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of the identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client ID of the identity.
	ClientID *string `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for UserAssignedIdentity.
func (uai UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualNetworkRule virtual Network rule.
type VirtualNetworkRule struct {
	// VirtualNetworkResourceID - Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
	VirtualNetworkResourceID *string `json:"id,omitempty"`
	// Action - The action of virtual network rule. Possible values include: 'ActionAllow'
	Action Action `json:"action,omitempty"`
	// State - Gets the state of virtual network rule. Possible values include: 'StateProvisioning', 'StateDeprovisioning', 'StateSucceeded', 'StateFailed', 'StateNetworkSourceDeleted'
	State State `json:"state,omitempty"`
}
