package storsimple8000series

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.1.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// ManagersClient is the client for the Managers methods of the
// Storsimple8000series service.
type ManagersClient struct {
	ManagementClient
}

// NewManagersClient creates an instance of the ManagersClient client.
func NewManagersClient(subscriptionID string) ManagersClient {
	return NewManagersClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewManagersClientWithBaseURI creates an instance of the ManagersClient
// client.
func NewManagersClientWithBaseURI(baseURI string, subscriptionID string) ManagersClient {
	return ManagersClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateExtendedInfo creates the extended info of the manager.
//
// parameters is the manager extended information. resourceGroupName is the
// resource group name managerName is the manager name
func (client ManagersClient) CreateExtendedInfo(parameters ManagerExtendedInfo, resourceGroupName string, managerName string) (result ManagerExtendedInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ManagerExtendedInfoProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.ManagerExtendedInfoProperties.IntegrityKey", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.ManagerExtendedInfoProperties.Algorithm", Name: validation.Null, Rule: true, Chain: nil},
				}}}},
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "CreateExtendedInfo")
	}

	req, err := client.CreateExtendedInfoPreparer(parameters, resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "CreateExtendedInfo", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateExtendedInfoSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "CreateExtendedInfo", resp, "Failure sending request")
		return
	}

	result, err = client.CreateExtendedInfoResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "CreateExtendedInfo", resp, "Failure responding to request")
	}

	return
}

// CreateExtendedInfoPreparer prepares the CreateExtendedInfo request.
func (client ManagersClient) CreateExtendedInfoPreparer(parameters ManagerExtendedInfo, resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateExtendedInfoSender sends the CreateExtendedInfo request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) CreateExtendedInfoSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateExtendedInfoResponder handles the response to the CreateExtendedInfo request. The method always
// closes the http.Response Body.
func (client ManagersClient) CreateExtendedInfoResponder(resp *http.Response) (result ManagerExtendedInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate creates or updates the manager.
//
// parameters is the manager. resourceGroupName is the resource group name
// managerName is the manager name
func (client ManagersClient) CreateOrUpdate(parameters Manager, resourceGroupName string, managerName string) (result Manager, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ManagerProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.ManagerProperties.Sku", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "parameters.ManagerProperties.Sku.Name", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}},
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "CreateOrUpdate")
	}

	req, err := client.CreateOrUpdatePreparer(parameters, resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "CreateOrUpdate", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client ManagersClient) CreateOrUpdatePreparer(parameters Manager, resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client ManagersClient) CreateOrUpdateResponder(resp *http.Response) (result Manager, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes the manager.
//
// resourceGroupName is the resource group name managerName is the manager name
func (client ManagersClient) Delete(resourceGroupName string, managerName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "Delete")
	}

	req, err := client.DeletePreparer(resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ManagersClient) DeletePreparer(resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ManagersClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteExtendedInfo deletes the extended info of the manager.
//
// resourceGroupName is the resource group name managerName is the manager name
func (client ManagersClient) DeleteExtendedInfo(resourceGroupName string, managerName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "DeleteExtendedInfo")
	}

	req, err := client.DeleteExtendedInfoPreparer(resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "DeleteExtendedInfo", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteExtendedInfoSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "DeleteExtendedInfo", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteExtendedInfoResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "DeleteExtendedInfo", resp, "Failure responding to request")
	}

	return
}

// DeleteExtendedInfoPreparer prepares the DeleteExtendedInfo request.
func (client ManagersClient) DeleteExtendedInfoPreparer(resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteExtendedInfoSender sends the DeleteExtendedInfo request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) DeleteExtendedInfoSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteExtendedInfoResponder handles the response to the DeleteExtendedInfo request. The method always
// closes the http.Response Body.
func (client ManagersClient) DeleteExtendedInfoResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get returns the properties of the specified manager name.
//
// resourceGroupName is the resource group name managerName is the manager name
func (client ManagersClient) Get(resourceGroupName string, managerName string) (result Manager, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "Get")
	}

	req, err := client.GetPreparer(resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ManagersClient) GetPreparer(resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ManagersClient) GetResponder(resp *http.Response) (result Manager, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetActivationKey returns the activation key of the manager.
//
// resourceGroupName is the resource group name managerName is the manager name
func (client ManagersClient) GetActivationKey(resourceGroupName string, managerName string) (result Key, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "GetActivationKey")
	}

	req, err := client.GetActivationKeyPreparer(resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "GetActivationKey", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetActivationKeySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "GetActivationKey", resp, "Failure sending request")
		return
	}

	result, err = client.GetActivationKeyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "GetActivationKey", resp, "Failure responding to request")
	}

	return
}

// GetActivationKeyPreparer prepares the GetActivationKey request.
func (client ManagersClient) GetActivationKeyPreparer(resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/listActivationKey", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetActivationKeySender sends the GetActivationKey request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) GetActivationKeySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetActivationKeyResponder handles the response to the GetActivationKey request. The method always
// closes the http.Response Body.
func (client ManagersClient) GetActivationKeyResponder(resp *http.Response) (result Key, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDevicePublicEncryptionKey returns the public encryption key of the
// device.
//
// deviceName is the device name resourceGroupName is the resource group name
// managerName is the manager name
func (client ManagersClient) GetDevicePublicEncryptionKey(deviceName string, resourceGroupName string, managerName string) (result PublicKey, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "GetDevicePublicEncryptionKey")
	}

	req, err := client.GetDevicePublicEncryptionKeyPreparer(deviceName, resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "GetDevicePublicEncryptionKey", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDevicePublicEncryptionKeySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "GetDevicePublicEncryptionKey", resp, "Failure sending request")
		return
	}

	result, err = client.GetDevicePublicEncryptionKeyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "GetDevicePublicEncryptionKey", resp, "Failure responding to request")
	}

	return
}

// GetDevicePublicEncryptionKeyPreparer prepares the GetDevicePublicEncryptionKey request.
func (client ManagersClient) GetDevicePublicEncryptionKeyPreparer(deviceName string, resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"deviceName":        deviceName,
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/publicEncryptionKey", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDevicePublicEncryptionKeySender sends the GetDevicePublicEncryptionKey request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) GetDevicePublicEncryptionKeySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetDevicePublicEncryptionKeyResponder handles the response to the GetDevicePublicEncryptionKey request. The method always
// closes the http.Response Body.
func (client ManagersClient) GetDevicePublicEncryptionKeyResponder(resp *http.Response) (result PublicKey, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetEncryptionSettings returns the encryption settings of the manager.
//
// resourceGroupName is the resource group name managerName is the manager name
func (client ManagersClient) GetEncryptionSettings(resourceGroupName string, managerName string) (result EncryptionSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "GetEncryptionSettings")
	}

	req, err := client.GetEncryptionSettingsPreparer(resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "GetEncryptionSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEncryptionSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "GetEncryptionSettings", resp, "Failure sending request")
		return
	}

	result, err = client.GetEncryptionSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "GetEncryptionSettings", resp, "Failure responding to request")
	}

	return
}

// GetEncryptionSettingsPreparer prepares the GetEncryptionSettings request.
func (client ManagersClient) GetEncryptionSettingsPreparer(resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/encryptionSettings/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetEncryptionSettingsSender sends the GetEncryptionSettings request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) GetEncryptionSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetEncryptionSettingsResponder handles the response to the GetEncryptionSettings request. The method always
// closes the http.Response Body.
func (client ManagersClient) GetEncryptionSettingsResponder(resp *http.Response) (result EncryptionSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetExtendedInfo returns the extended information of the specified manager
// name.
//
// resourceGroupName is the resource group name managerName is the manager name
func (client ManagersClient) GetExtendedInfo(resourceGroupName string, managerName string) (result ManagerExtendedInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "GetExtendedInfo")
	}

	req, err := client.GetExtendedInfoPreparer(resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "GetExtendedInfo", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetExtendedInfoSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "GetExtendedInfo", resp, "Failure sending request")
		return
	}

	result, err = client.GetExtendedInfoResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "GetExtendedInfo", resp, "Failure responding to request")
	}

	return
}

// GetExtendedInfoPreparer prepares the GetExtendedInfo request.
func (client ManagersClient) GetExtendedInfoPreparer(resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetExtendedInfoSender sends the GetExtendedInfo request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) GetExtendedInfoSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetExtendedInfoResponder handles the response to the GetExtendedInfo request. The method always
// closes the http.Response Body.
func (client ManagersClient) GetExtendedInfoResponder(resp *http.Response) (result ManagerExtendedInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPublicEncryptionKey returns the symmetric encrypted public encryption key
// of the manager.
//
// resourceGroupName is the resource group name managerName is the manager name
func (client ManagersClient) GetPublicEncryptionKey(resourceGroupName string, managerName string) (result SymmetricEncryptedSecret, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "GetPublicEncryptionKey")
	}

	req, err := client.GetPublicEncryptionKeyPreparer(resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "GetPublicEncryptionKey", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPublicEncryptionKeySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "GetPublicEncryptionKey", resp, "Failure sending request")
		return
	}

	result, err = client.GetPublicEncryptionKeyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "GetPublicEncryptionKey", resp, "Failure responding to request")
	}

	return
}

// GetPublicEncryptionKeyPreparer prepares the GetPublicEncryptionKey request.
func (client ManagersClient) GetPublicEncryptionKeyPreparer(resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/listPublicEncryptionKey", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetPublicEncryptionKeySender sends the GetPublicEncryptionKey request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) GetPublicEncryptionKeySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetPublicEncryptionKeyResponder handles the response to the GetPublicEncryptionKey request. The method always
// closes the http.Response Body.
func (client ManagersClient) GetPublicEncryptionKeyResponder(resp *http.Response) (result SymmetricEncryptedSecret, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List retrieves all the managers in a subscription.
func (client ManagersClient) List() (result ManagerList, err error) {
	req, err := client.ListPreparer()
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client ManagersClient) ListPreparer() (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.StorSimple/managers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ManagersClient) ListResponder(resp *http.Response) (result ManagerList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroup retrieves all the managers in a resource group.
//
// resourceGroupName is the resource group name
func (client ManagersClient) ListByResourceGroup(resourceGroupName string) (result ManagerList, err error) {
	req, err := client.ListByResourceGroupPreparer(resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client ManagersClient) ListByResourceGroupPreparer(resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client ManagersClient) ListByResourceGroupResponder(resp *http.Response) (result ManagerList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListFeatureSupportStatus lists the features and their support status
//
// resourceGroupName is the resource group name managerName is the manager name
// filter is oData Filter options
func (client ManagersClient) ListFeatureSupportStatus(resourceGroupName string, managerName string, filter string) (result FeatureList, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "ListFeatureSupportStatus")
	}

	req, err := client.ListFeatureSupportStatusPreparer(resourceGroupName, managerName, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "ListFeatureSupportStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListFeatureSupportStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "ListFeatureSupportStatus", resp, "Failure sending request")
		return
	}

	result, err = client.ListFeatureSupportStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "ListFeatureSupportStatus", resp, "Failure responding to request")
	}

	return
}

// ListFeatureSupportStatusPreparer prepares the ListFeatureSupportStatus request.
func (client ManagersClient) ListFeatureSupportStatusPreparer(resourceGroupName string, managerName string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/features", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListFeatureSupportStatusSender sends the ListFeatureSupportStatus request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) ListFeatureSupportStatusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListFeatureSupportStatusResponder handles the response to the ListFeatureSupportStatus request. The method always
// closes the http.Response Body.
func (client ManagersClient) ListFeatureSupportStatusResponder(resp *http.Response) (result FeatureList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricDefinition gets the metric definitions for the specified manager.
//
// resourceGroupName is the resource group name managerName is the manager name
func (client ManagersClient) ListMetricDefinition(resourceGroupName string, managerName string) (result MetricDefinitionList, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "ListMetricDefinition")
	}

	req, err := client.ListMetricDefinitionPreparer(resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "ListMetricDefinition", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricDefinitionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "ListMetricDefinition", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetricDefinitionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "ListMetricDefinition", resp, "Failure responding to request")
	}

	return
}

// ListMetricDefinitionPreparer prepares the ListMetricDefinition request.
func (client ManagersClient) ListMetricDefinitionPreparer(resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/metricsDefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetricDefinitionSender sends the ListMetricDefinition request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) ListMetricDefinitionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMetricDefinitionResponder handles the response to the ListMetricDefinition request. The method always
// closes the http.Response Body.
func (client ManagersClient) ListMetricDefinitionResponder(resp *http.Response) (result MetricDefinitionList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetrics gets the metrics for the specified manager.
//
// resourceGroupName is the resource group name managerName is the manager name
// filter is oData Filter options
func (client ManagersClient) ListMetrics(resourceGroupName string, managerName string, filter string) (result MetricList, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "ListMetrics")
	}

	req, err := client.ListMetricsPreparer(resourceGroupName, managerName, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "ListMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "ListMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "ListMetrics", resp, "Failure responding to request")
	}

	return
}

// ListMetricsPreparer prepares the ListMetrics request.
func (client ManagersClient) ListMetricsPreparer(resourceGroupName string, managerName string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"$filter":     autorest.Encode("query", filter),
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetricsSender sends the ListMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) ListMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMetricsResponder handles the response to the ListMetrics request. The method always
// closes the http.Response Body.
func (client ManagersClient) ListMetricsResponder(resp *http.Response) (result MetricList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RegenerateActivationKey re-generates and returns the activation key of the
// manager.
//
// resourceGroupName is the resource group name managerName is the manager name
func (client ManagersClient) RegenerateActivationKey(resourceGroupName string, managerName string) (result Key, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "RegenerateActivationKey")
	}

	req, err := client.RegenerateActivationKeyPreparer(resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "RegenerateActivationKey", nil, "Failure preparing request")
		return
	}

	resp, err := client.RegenerateActivationKeySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "RegenerateActivationKey", resp, "Failure sending request")
		return
	}

	result, err = client.RegenerateActivationKeyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "RegenerateActivationKey", resp, "Failure responding to request")
	}

	return
}

// RegenerateActivationKeyPreparer prepares the RegenerateActivationKey request.
func (client ManagersClient) RegenerateActivationKeyPreparer(resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/regenerateActivationKey", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// RegenerateActivationKeySender sends the RegenerateActivationKey request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) RegenerateActivationKeySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// RegenerateActivationKeyResponder handles the response to the RegenerateActivationKey request. The method always
// closes the http.Response Body.
func (client ManagersClient) RegenerateActivationKeyResponder(resp *http.Response) (result Key, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update updates the StorSimple Manager.
//
// parameters is the manager update parameters. resourceGroupName is the
// resource group name managerName is the manager name
func (client ManagersClient) Update(parameters ManagerPatch, resourceGroupName string, managerName string) (result Manager, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "Update")
	}

	req, err := client.UpdatePreparer(parameters, resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client ManagersClient) UpdatePreparer(parameters ManagerPatch, resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client ManagersClient) UpdateResponder(resp *http.Response) (result Manager, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateExtendedInfo updates the extended info of the manager.
//
// parameters is the manager extended information. resourceGroupName is the
// resource group name managerName is the manager name ifMatch is pass the ETag
// of ExtendedInfo fetched from GET call
func (client ManagersClient) UpdateExtendedInfo(parameters ManagerExtendedInfo, resourceGroupName string, managerName string, ifMatch string) (result ManagerExtendedInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.ManagersClient", "UpdateExtendedInfo")
	}

	req, err := client.UpdateExtendedInfoPreparer(parameters, resourceGroupName, managerName, ifMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "UpdateExtendedInfo", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateExtendedInfoSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "UpdateExtendedInfo", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateExtendedInfoResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.ManagersClient", "UpdateExtendedInfo", resp, "Failure responding to request")
	}

	return
}

// UpdateExtendedInfoPreparer prepares the UpdateExtendedInfo request.
func (client ManagersClient) UpdateExtendedInfoPreparer(parameters ManagerExtendedInfo, resourceGroupName string, managerName string, ifMatch string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	return preparer.Prepare(&http.Request{})
}

// UpdateExtendedInfoSender sends the UpdateExtendedInfo request. The method will close the
// http.Response Body if it receives an error.
func (client ManagersClient) UpdateExtendedInfoSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateExtendedInfoResponder handles the response to the UpdateExtendedInfo request. The method always
// closes the http.Response Body.
func (client ManagersClient) UpdateExtendedInfoResponder(resp *http.Response) (result ManagerExtendedInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
