// Code generated by smithy-go-codegen DO NOT EDIT.

package kms

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/kms/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCancelKeyDeletion struct {
}

func (*validateOpCancelKeyDeletion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelKeyDeletion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelKeyDeletionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelKeyDeletionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpConnectCustomKeyStore struct {
}

func (*validateOpConnectCustomKeyStore) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpConnectCustomKeyStore) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ConnectCustomKeyStoreInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpConnectCustomKeyStoreInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateAlias struct {
}

func (*validateOpCreateAlias) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateAlias) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateAliasInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateAliasInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateCustomKeyStore struct {
}

func (*validateOpCreateCustomKeyStore) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateCustomKeyStore) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateCustomKeyStoreInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateCustomKeyStoreInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateGrant struct {
}

func (*validateOpCreateGrant) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateGrant) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateGrantInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateGrantInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateKey struct {
}

func (*validateOpCreateKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDecrypt struct {
}

func (*validateOpDecrypt) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDecrypt) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DecryptInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDecryptInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteAlias struct {
}

func (*validateOpDeleteAlias) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAlias) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAliasInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAliasInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteCustomKeyStore struct {
}

func (*validateOpDeleteCustomKeyStore) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteCustomKeyStore) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteCustomKeyStoreInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteCustomKeyStoreInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteImportedKeyMaterial struct {
}

func (*validateOpDeleteImportedKeyMaterial) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteImportedKeyMaterial) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteImportedKeyMaterialInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteImportedKeyMaterialInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeriveSharedSecret struct {
}

func (*validateOpDeriveSharedSecret) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeriveSharedSecret) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeriveSharedSecretInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeriveSharedSecretInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeKey struct {
}

func (*validateOpDescribeKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisableKey struct {
}

func (*validateOpDisableKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisableKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisableKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisableKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisableKeyRotation struct {
}

func (*validateOpDisableKeyRotation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisableKeyRotation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisableKeyRotationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisableKeyRotationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisconnectCustomKeyStore struct {
}

func (*validateOpDisconnectCustomKeyStore) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisconnectCustomKeyStore) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisconnectCustomKeyStoreInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisconnectCustomKeyStoreInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpEnableKey struct {
}

func (*validateOpEnableKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpEnableKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*EnableKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpEnableKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpEnableKeyRotation struct {
}

func (*validateOpEnableKeyRotation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpEnableKeyRotation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*EnableKeyRotationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpEnableKeyRotationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpEncrypt struct {
}

func (*validateOpEncrypt) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpEncrypt) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*EncryptInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpEncryptInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGenerateDataKey struct {
}

func (*validateOpGenerateDataKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGenerateDataKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GenerateDataKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGenerateDataKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGenerateDataKeyPair struct {
}

func (*validateOpGenerateDataKeyPair) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGenerateDataKeyPair) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GenerateDataKeyPairInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGenerateDataKeyPairInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGenerateDataKeyPairWithoutPlaintext struct {
}

func (*validateOpGenerateDataKeyPairWithoutPlaintext) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGenerateDataKeyPairWithoutPlaintext) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GenerateDataKeyPairWithoutPlaintextInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGenerateDataKeyPairWithoutPlaintextInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGenerateDataKeyWithoutPlaintext struct {
}

func (*validateOpGenerateDataKeyWithoutPlaintext) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGenerateDataKeyWithoutPlaintext) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GenerateDataKeyWithoutPlaintextInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGenerateDataKeyWithoutPlaintextInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGenerateMac struct {
}

func (*validateOpGenerateMac) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGenerateMac) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GenerateMacInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGenerateMacInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetKeyPolicy struct {
}

func (*validateOpGetKeyPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetKeyPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetKeyPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetKeyPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetKeyRotationStatus struct {
}

func (*validateOpGetKeyRotationStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetKeyRotationStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetKeyRotationStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetKeyRotationStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetParametersForImport struct {
}

func (*validateOpGetParametersForImport) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetParametersForImport) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetParametersForImportInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetParametersForImportInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetPublicKey struct {
}

func (*validateOpGetPublicKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetPublicKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetPublicKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetPublicKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpImportKeyMaterial struct {
}

func (*validateOpImportKeyMaterial) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpImportKeyMaterial) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ImportKeyMaterialInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpImportKeyMaterialInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListGrants struct {
}

func (*validateOpListGrants) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListGrants) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListGrantsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListGrantsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListKeyPolicies struct {
}

func (*validateOpListKeyPolicies) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListKeyPolicies) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListKeyPoliciesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListKeyPoliciesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListKeyRotations struct {
}

func (*validateOpListKeyRotations) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListKeyRotations) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListKeyRotationsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListKeyRotationsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListResourceTags struct {
}

func (*validateOpListResourceTags) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListResourceTags) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListResourceTagsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListResourceTagsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListRetirableGrants struct {
}

func (*validateOpListRetirableGrants) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListRetirableGrants) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListRetirableGrantsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListRetirableGrantsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutKeyPolicy struct {
}

func (*validateOpPutKeyPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutKeyPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutKeyPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutKeyPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpReEncrypt struct {
}

func (*validateOpReEncrypt) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpReEncrypt) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ReEncryptInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpReEncryptInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpReplicateKey struct {
}

func (*validateOpReplicateKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpReplicateKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ReplicateKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpReplicateKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRevokeGrant struct {
}

func (*validateOpRevokeGrant) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRevokeGrant) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RevokeGrantInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRevokeGrantInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRotateKeyOnDemand struct {
}

func (*validateOpRotateKeyOnDemand) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRotateKeyOnDemand) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RotateKeyOnDemandInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRotateKeyOnDemandInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpScheduleKeyDeletion struct {
}

func (*validateOpScheduleKeyDeletion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpScheduleKeyDeletion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ScheduleKeyDeletionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpScheduleKeyDeletionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSign struct {
}

func (*validateOpSign) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSign) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SignInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSignInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateAlias struct {
}

func (*validateOpUpdateAlias) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateAlias) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateAliasInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateAliasInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateCustomKeyStore struct {
}

func (*validateOpUpdateCustomKeyStore) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateCustomKeyStore) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateCustomKeyStoreInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateCustomKeyStoreInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateKeyDescription struct {
}

func (*validateOpUpdateKeyDescription) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateKeyDescription) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateKeyDescriptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateKeyDescriptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdatePrimaryRegion struct {
}

func (*validateOpUpdatePrimaryRegion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdatePrimaryRegion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdatePrimaryRegionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdatePrimaryRegionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpVerify struct {
}

func (*validateOpVerify) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpVerify) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*VerifyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpVerifyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpVerifyMac struct {
}

func (*validateOpVerifyMac) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpVerifyMac) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*VerifyMacInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpVerifyMacInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCancelKeyDeletionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelKeyDeletion{}, middleware.After)
}

func addOpConnectCustomKeyStoreValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpConnectCustomKeyStore{}, middleware.After)
}

func addOpCreateAliasValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateAlias{}, middleware.After)
}

func addOpCreateCustomKeyStoreValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateCustomKeyStore{}, middleware.After)
}

func addOpCreateGrantValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateGrant{}, middleware.After)
}

func addOpCreateKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateKey{}, middleware.After)
}

func addOpDecryptValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDecrypt{}, middleware.After)
}

func addOpDeleteAliasValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAlias{}, middleware.After)
}

func addOpDeleteCustomKeyStoreValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteCustomKeyStore{}, middleware.After)
}

func addOpDeleteImportedKeyMaterialValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteImportedKeyMaterial{}, middleware.After)
}

func addOpDeriveSharedSecretValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeriveSharedSecret{}, middleware.After)
}

func addOpDescribeKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeKey{}, middleware.After)
}

func addOpDisableKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisableKey{}, middleware.After)
}

func addOpDisableKeyRotationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisableKeyRotation{}, middleware.After)
}

func addOpDisconnectCustomKeyStoreValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisconnectCustomKeyStore{}, middleware.After)
}

func addOpEnableKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpEnableKey{}, middleware.After)
}

func addOpEnableKeyRotationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpEnableKeyRotation{}, middleware.After)
}

func addOpEncryptValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpEncrypt{}, middleware.After)
}

func addOpGenerateDataKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGenerateDataKey{}, middleware.After)
}

func addOpGenerateDataKeyPairValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGenerateDataKeyPair{}, middleware.After)
}

func addOpGenerateDataKeyPairWithoutPlaintextValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGenerateDataKeyPairWithoutPlaintext{}, middleware.After)
}

func addOpGenerateDataKeyWithoutPlaintextValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGenerateDataKeyWithoutPlaintext{}, middleware.After)
}

func addOpGenerateMacValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGenerateMac{}, middleware.After)
}

func addOpGetKeyPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetKeyPolicy{}, middleware.After)
}

func addOpGetKeyRotationStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetKeyRotationStatus{}, middleware.After)
}

func addOpGetParametersForImportValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetParametersForImport{}, middleware.After)
}

func addOpGetPublicKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetPublicKey{}, middleware.After)
}

func addOpImportKeyMaterialValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpImportKeyMaterial{}, middleware.After)
}

func addOpListGrantsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListGrants{}, middleware.After)
}

func addOpListKeyPoliciesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListKeyPolicies{}, middleware.After)
}

func addOpListKeyRotationsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListKeyRotations{}, middleware.After)
}

func addOpListResourceTagsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListResourceTags{}, middleware.After)
}

func addOpListRetirableGrantsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListRetirableGrants{}, middleware.After)
}

func addOpPutKeyPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutKeyPolicy{}, middleware.After)
}

func addOpReEncryptValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpReEncrypt{}, middleware.After)
}

func addOpReplicateKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpReplicateKey{}, middleware.After)
}

func addOpRevokeGrantValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRevokeGrant{}, middleware.After)
}

func addOpRotateKeyOnDemandValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRotateKeyOnDemand{}, middleware.After)
}

func addOpScheduleKeyDeletionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpScheduleKeyDeletion{}, middleware.After)
}

func addOpSignValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSign{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateAliasValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateAlias{}, middleware.After)
}

func addOpUpdateCustomKeyStoreValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateCustomKeyStore{}, middleware.After)
}

func addOpUpdateKeyDescriptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateKeyDescription{}, middleware.After)
}

func addOpUpdatePrimaryRegionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdatePrimaryRegion{}, middleware.After)
}

func addOpVerifyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpVerify{}, middleware.After)
}

func addOpVerifyMacValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpVerifyMac{}, middleware.After)
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.TagKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKey"))
	}
	if v.TagValue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagValue"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagList(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagList"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateXksProxyAuthenticationCredentialType(v *types.XksProxyAuthenticationCredentialType) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "XksProxyAuthenticationCredentialType"}
	if v.AccessKeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccessKeyId"))
	}
	if v.RawSecretAccessKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RawSecretAccessKey"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelKeyDeletionInput(v *CancelKeyDeletionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelKeyDeletionInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpConnectCustomKeyStoreInput(v *ConnectCustomKeyStoreInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConnectCustomKeyStoreInput"}
	if v.CustomKeyStoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CustomKeyStoreId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateAliasInput(v *CreateAliasInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateAliasInput"}
	if v.AliasName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AliasName"))
	}
	if v.TargetKeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetKeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateCustomKeyStoreInput(v *CreateCustomKeyStoreInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateCustomKeyStoreInput"}
	if v.CustomKeyStoreName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CustomKeyStoreName"))
	}
	if v.XksProxyAuthenticationCredential != nil {
		if err := validateXksProxyAuthenticationCredentialType(v.XksProxyAuthenticationCredential); err != nil {
			invalidParams.AddNested("XksProxyAuthenticationCredential", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateGrantInput(v *CreateGrantInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateGrantInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if v.GranteePrincipal == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GranteePrincipal"))
	}
	if v.Operations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Operations"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateKeyInput(v *CreateKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateKeyInput"}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDecryptInput(v *DecryptInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DecryptInput"}
	if v.CiphertextBlob == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CiphertextBlob"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAliasInput(v *DeleteAliasInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAliasInput"}
	if v.AliasName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AliasName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteCustomKeyStoreInput(v *DeleteCustomKeyStoreInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteCustomKeyStoreInput"}
	if v.CustomKeyStoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CustomKeyStoreId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteImportedKeyMaterialInput(v *DeleteImportedKeyMaterialInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteImportedKeyMaterialInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeriveSharedSecretInput(v *DeriveSharedSecretInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeriveSharedSecretInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if len(v.KeyAgreementAlgorithm) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("KeyAgreementAlgorithm"))
	}
	if v.PublicKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PublicKey"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeKeyInput(v *DescribeKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeKeyInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisableKeyInput(v *DisableKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisableKeyInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisableKeyRotationInput(v *DisableKeyRotationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisableKeyRotationInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisconnectCustomKeyStoreInput(v *DisconnectCustomKeyStoreInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisconnectCustomKeyStoreInput"}
	if v.CustomKeyStoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CustomKeyStoreId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpEnableKeyInput(v *EnableKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EnableKeyInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpEnableKeyRotationInput(v *EnableKeyRotationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EnableKeyRotationInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpEncryptInput(v *EncryptInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EncryptInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if v.Plaintext == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Plaintext"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGenerateDataKeyInput(v *GenerateDataKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GenerateDataKeyInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGenerateDataKeyPairInput(v *GenerateDataKeyPairInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GenerateDataKeyPairInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if len(v.KeyPairSpec) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("KeyPairSpec"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGenerateDataKeyPairWithoutPlaintextInput(v *GenerateDataKeyPairWithoutPlaintextInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GenerateDataKeyPairWithoutPlaintextInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if len(v.KeyPairSpec) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("KeyPairSpec"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGenerateDataKeyWithoutPlaintextInput(v *GenerateDataKeyWithoutPlaintextInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GenerateDataKeyWithoutPlaintextInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGenerateMacInput(v *GenerateMacInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GenerateMacInput"}
	if v.Message == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Message"))
	}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if len(v.MacAlgorithm) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("MacAlgorithm"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetKeyPolicyInput(v *GetKeyPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetKeyPolicyInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetKeyRotationStatusInput(v *GetKeyRotationStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetKeyRotationStatusInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetParametersForImportInput(v *GetParametersForImportInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetParametersForImportInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if len(v.WrappingAlgorithm) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("WrappingAlgorithm"))
	}
	if len(v.WrappingKeySpec) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("WrappingKeySpec"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetPublicKeyInput(v *GetPublicKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetPublicKeyInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpImportKeyMaterialInput(v *ImportKeyMaterialInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImportKeyMaterialInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if v.ImportToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImportToken"))
	}
	if v.EncryptedKeyMaterial == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EncryptedKeyMaterial"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListGrantsInput(v *ListGrantsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListGrantsInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListKeyPoliciesInput(v *ListKeyPoliciesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListKeyPoliciesInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListKeyRotationsInput(v *ListKeyRotationsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListKeyRotationsInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListResourceTagsInput(v *ListResourceTagsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListResourceTagsInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListRetirableGrantsInput(v *ListRetirableGrantsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListRetirableGrantsInput"}
	if v.RetiringPrincipal == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RetiringPrincipal"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutKeyPolicyInput(v *PutKeyPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutKeyPolicyInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if v.Policy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Policy"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpReEncryptInput(v *ReEncryptInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReEncryptInput"}
	if v.CiphertextBlob == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CiphertextBlob"))
	}
	if v.DestinationKeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationKeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpReplicateKeyInput(v *ReplicateKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReplicateKeyInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if v.ReplicaRegion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReplicaRegion"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRevokeGrantInput(v *RevokeGrantInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RevokeGrantInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if v.GrantId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GrantId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRotateKeyOnDemandInput(v *RotateKeyOnDemandInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RotateKeyOnDemandInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpScheduleKeyDeletionInput(v *ScheduleKeyDeletionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScheduleKeyDeletionInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSignInput(v *SignInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SignInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if v.Message == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Message"))
	}
	if len(v.SigningAlgorithm) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SigningAlgorithm"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateAliasInput(v *UpdateAliasInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateAliasInput"}
	if v.AliasName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AliasName"))
	}
	if v.TargetKeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetKeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateCustomKeyStoreInput(v *UpdateCustomKeyStoreInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateCustomKeyStoreInput"}
	if v.CustomKeyStoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CustomKeyStoreId"))
	}
	if v.XksProxyAuthenticationCredential != nil {
		if err := validateXksProxyAuthenticationCredentialType(v.XksProxyAuthenticationCredential); err != nil {
			invalidParams.AddNested("XksProxyAuthenticationCredential", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateKeyDescriptionInput(v *UpdateKeyDescriptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateKeyDescriptionInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if v.Description == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Description"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdatePrimaryRegionInput(v *UpdatePrimaryRegionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdatePrimaryRegionInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if v.PrimaryRegion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrimaryRegion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpVerifyInput(v *VerifyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VerifyInput"}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if v.Message == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Message"))
	}
	if v.Signature == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Signature"))
	}
	if len(v.SigningAlgorithm) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SigningAlgorithm"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpVerifyMacInput(v *VerifyMacInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VerifyMacInput"}
	if v.Message == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Message"))
	}
	if v.KeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyId"))
	}
	if len(v.MacAlgorithm) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("MacAlgorithm"))
	}
	if v.Mac == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Mac"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
