/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/***********************************************************************************/
/* This file is automatically generated using bindtool and can be manually edited  */
/* The following lines can be configured to regenerate this file during cmake      */
/* If manual edits are made, the following tags should be modified accordingly.    */
/* BINDTOOL_GEN_AUTOMATIC(0)                                                       */
/* BINDTOOL_USE_PYGCCXML(0)                                                        */
/* BINDTOOL_HEADER_FILE(linear_equalizer.h)                                        */
/* BINDTOOL_HEADER_FILE_HASH(11ccc23f6c5aa3de99d592bd83b2638c)                     */
/***********************************************************************************/

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/digital/linear_equalizer.h>
// pydoc.h is automatically generated in the build directory
#include <linear_equalizer_pydoc.h>

void bind_linear_equalizer(py::module& m)
{

    using linear_equalizer = ::gr::digital::linear_equalizer;


    py::class_<linear_equalizer, gr::sync_decimator, std::shared_ptr<linear_equalizer>>(
        m, "linear_equalizer", D(linear_equalizer))

        .def(py::init(&linear_equalizer::make),
             py::arg("num_taps"),
             py::arg("sps"),
             py::arg("alg"),
             py::arg("adapt_after_training") = true,
             py::arg("training_sequence") = std::vector<gr_complex>(),
             py::arg("training_start_tag") = "",
             D(linear_equalizer, make))


        .def("set_taps",
             &linear_equalizer::set_taps,
             py::arg("taps"),
             D(linear_equalizer, set_taps))


        .def("taps", &linear_equalizer::taps, D(linear_equalizer, taps))


        .def("equalize",
             &linear_equalizer::equalize,
             py::arg("input_samples"),
             py::arg("output_symbols"),
             py::arg("num_inputs"),
             py::arg("max_num_outputs"),
             py::arg("training_start_samples") = std::vector<unsigned int>(0),
             py::arg("history_included") = false,
             py::arg("taps") = nullptr,
             py::arg("state") = nullptr,
             D(linear_equalizer, equalize))

        ;
}
