=begin  
  music.rb
    Copyright (c) 2004 by Jesse van den Kieboom <jesse@icecrew.nl>
    Copyright (c) 2004/07/29 by Simon Gijsen <simon@gijsen.org>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	Defines:
	  rb/rhythmbox - show which song rb is currenly playing, control rb
	  xmms/beep - show which song xmms is playing, control xmms (thanks to Simon Gijsen)
=end

def register_functions
  $scripts.register("rhythmbox", "use: /rhythmbox <prefix>|next|prev|play|pause\nsends the song Rhythmbox is currently playing to the world prefixed by <prefix> or performs the action specified if pause, play, next or prev is specified")
  $scripts.register("rb", "alias for rhythmbox", "rhythmbox")
  $scripts.register("xmms", "use: /xmms <prefix>|prev|play|pause|stop|next\nsends the song XMMS is currently playing to the world prefixed by <prefix> or performs the action specified if prev, play, pause, stop or next is specified")
  $scripts.register("beep", "alias for xmms", "xmms")
end

def getOgginfo(filename)
  if (!File.exists?("/usr/bin/ogginfo"))
    return nil
  end
  
  info = `/usr/bin/ogginfo "#{filename}" 2> /dev/null`
  artist = nil
  title = nil
  
  if (!info.empty?)
    info.split("\n").each {|line|
      line = line.strip
      if (line[/^artist=/i])
        artist = line[7..-1]
      elsif (line[/^title=/i])
        title = line[6..-1]
      end
    }
    
    return "#{artist} - #{title}"
  else
    return nil
  end
end

def getID3info(filename)
  if (!File.exists?("/usr/bin/id3info"))
    nil
  end

  info = `/usr/bin/id3info "#{filename}" 2> /dev/null`.split("\n")
  artist = nil
  title = nil
  
  if (info.length == 1 && info[0].empty? == 0)
    return nil
  end
  
  info.each {|line|
    line = line.strip
    if (line.index(/TPE[1|2]/) != nil)
      artist = line[line.index(":") + 1..-1].strip
    elsif (line.index("TIT2") != nil)
      title = line[line.index(":") + 1..-1].strip
    end
  }
  
  if (title && artist)
    return "#{artist} - #{title}"
  else
    return nil
  end
end

def getMP3info(filename)
  if ((info = getID3info(filename)))
    return info
  end
  
  if (!File.exists?("/usr/bin/mp3info"))
    return nil
  end
  
  info = `/usr/bin/mp3info -p "%a - %t" "#{filename}" 2> /dev/null`
  
  if (!info.empty?)  
    return info
  else
    return nil
  end
end

def rhythmbox(argstr)
  isopen = !(`/bin/ps -ae | /bin/grep rhythmbox`.empty?)

  if (!isopen)
    $world.writeln("Script error: rhythmbox is not running!")
    return
  end
  
  if (argstr == "next")
    `/usr/bin/rhythmbox --next`
  elsif (argstr == "prev")
    `/usr/bin/rhythmbox --previous`
  elsif (argstr == "play" || argstr == "pause")
    `/usr/bin/rhythmbox --play-pause`
  else      
    path = `/usr/bin/rhythmbox --print-playing-path 2> /dev/null`
    info = nil
  
    if (!path.empty?)
      filename = path.split("\n")[0].gsub(/%20/, " ")[7..-1]
      
      if (filename[-3..-1] == "mp3" && (info = getMP3info(filename)))
      elsif (filename[-3..-1] == "ogg" && (info = getOgginfo(filename)))
      else
        info = `/usr/bin/rhythmbox --print-playing 2> /dev/null`
      
        if (!info.empty?)
          info = info.split("\n")[0]
        else
          info = nil
        end 
      end
    
      if (info)
        $world.sendln(argstr + " :luistert op dit moment naar [ #{info} ]")
      else
        $world.writeln("Script error: cannot retrieve rhythmbox file play")
      end  
    
    else
      $world.writeln("Script error: can not execute /usr/bin/rhythmbox!")
    end
  end
end

def xmms(argstr)
  case argstr
    when "prev", "play", "pause", "stop", "next"
      io = IO.popen("/usr/bin/xmms-shell -e " + argstr + " 2>&1")
      line = io.gets
      io.close
    else
      line = `/usr/bin/xmms-shell -e current-track 2>&1`
  end

  if (line[0..18] === "XMMS is not running")
    $world.writeln("Script error: " + line[0..-2])
  elsif(line[0..3] === "sh: ")
    $world.writeln("Script error: " + line[12..-2])
  elsif(line[0..12] === "Current song:")
    index = line.index('.') + 2
    $world.sendln(argstr + " emote luistert op dit moment naar [ " + line[index..-2] + " ]")
  else
    line2 = `/usr/bin/xmms-shell -e current-track 2>&1`
    index = line2.index('.') + 2
    $world.writeln(line[0..-2] + " [ " + line2[index..-2] + " ]")
  end
end
