------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-gen_ocinumber.ads,v 1.13 2006/12/11 04:31:47 vagul Exp $

package OCI.Thick.Gen_OCINumber is

   generic
      with function OCINumberOper
        (err    : in OCIError;
         number : in OCINumber;
         result : access OCINumber)
         return   SWord;
   function Unary_Function (Item : OCINumber) return OCINumber;
   pragma Inline (Unary_Function);

   generic
      with function OCINumberOper
        (err     : in OCIError;
         number1 : in OCINumber;
         number2 : in OCINumber;
         result  : access OCINumber)
         return    SWord;
   function Binary_Function (Left, Right : OCINumber) return OCINumber;
   pragma Inline (Binary_Function);

   generic
      type Integer_Type is range <>;
      with function OCINumberOper
        (Err    : in     OCIError;
         Number : in     OCINumber;
         Value  : in     SWord;
         Result : access OCINumber) return SWord;
   function Integer_Function
     (Left : OCINumber; Right : Integer_Type) return OCINumber;
   pragma Inline (Integer_Function);

   generic
      with function Compare (Left, Right : SWord) return Boolean;
   function Compare_Function (Left, Right : OCINumber) return Boolean;
   pragma Inline (Compare_Function);

   generic
      type Integer_Type is range <>;
   function Num_To_Integer (Numb : OCINumber) return Integer_Type;

   generic
      type Integer_Type is range <>;
   function Int_To_Number (From : Integer_Type) return OCINumber;

   generic
      type Unsigned_Type is mod <>;
   function Unsigned_To_Number (From : Unsigned_Type) return OCINumber;

   generic
      type Unsigned_Type is mod <>;
   function Num_To_Unsigned (Numb : OCINumber) return Unsigned_Type;

   generic
      type Float_Type is digits <>;
   function Float_To_Number (From : Float_Type) return OCINumber;

   generic
      type Float_Type is digits <>;
   function Num_To_Float (Numb : OCINumber) return Float_Type;

   generic
      type Float_Type is digits <>;
   function Float_To_Number_Better (From : Float_Type) return OCINumber;

   generic
      type Float_Type is digits <>;
   function Num_To_Float_Better (Numb : OCINumber) return Float_Type;

   generic
      type Decimal_Type is delta <> digits <>;
   function Decimal_To_Number (From : Decimal_Type) return OCINumber;

   generic
      type Decimal_Type is delta <> digits <>;
   function Num_To_Decimal (Numb : OCINumber) return Decimal_Type;

end OCI.Thick.Gen_OCINumber;
