/* gmpc-image-async.c generated by valac 0.12.0, the Vala compiler
 * generated from gmpc-image-async.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "gmpc-extras.h"
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gtk/gtk.h>
#include <plugin.h>
#include <config1.h>
#include <float.h>
#include <math.h>
#include <misc.h>
#include <pixbuf-cache.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_tree_row_reference_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_row_reference_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
typedef struct _GmpcPixbufLoaderAsyncLoadFromFileAsyncData GmpcPixbufLoaderAsyncLoadFromFileAsyncData;

struct _GmpcPixbufLoaderAsyncPrivate {
	GCancellable* pcancel;
	GdkPixbuf* _pixbuf;
	GtkTreeRowReference* rref;
	gint width;
	gint height;
};

struct _GmpcPixbufLoaderAsyncLoadFromFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GmpcPixbufLoaderAsync* self;
	gchar* uri;
	gint req_width;
	gint req_height;
	GCancellable* cancel;
	GmpcModificationType border;
	GFile* _tmp0_;
	GFile* file;
	gsize _result_;
	GdkPixbufLoader* _tmp1_;
	GdkPixbufLoader* loader;
	GFileInputStream* _tmp2_;
	GFileInputStream* stream;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	guchar data[1024];
	gssize _tmp8_;
	gssize _tmp9_;
	GError * erro;
	GError * e;
	GError * err;
	gboolean _tmp10_;
	GdkPixbuf* _tmp11_;
	GdkPixbuf* _tmp12_;
	GdkPixbuf* pix;
	gint _tmp13_;
	GdkPixbuf* _tmp14_;
	GdkPixbuf* final;
	GdkPixbuf* _tmp15_;
	gint _tmp16_;
	GdkPixbuf* _tmp17_;
	gint _tmp18_;
	GError * _inner_error_;
};

struct _GmpcMetaImageAsyncPrivate {
	GmpcPixbufLoaderAsync* loader;
};


static gpointer gmpc_pixbuf_loader_async_parent_class = NULL;
static gpointer gmpc_meta_image_async_parent_class = NULL;

#define LOG_DOMAIN "ImageAsync"
#define GMPC_PIXBUF_LOADER_ASYNC_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_TYPE_PIXBUF_LOADER_ASYNC, GmpcPixbufLoaderAsyncPrivate))
enum  {
	GMPC_PIXBUF_LOADER_ASYNC_DUMMY_PROPERTY,
	GMPC_PIXBUF_LOADER_ASYNC_PIXBUF
};
static void gmpc_pixbuf_loader_async_call_row_changed (GmpcPixbufLoaderAsync* self);
static GdkPixbuf* gmpc_pixbuf_loader_async_modify_pixbuf (GmpcPixbufLoaderAsync* self, GdkPixbuf* pix, gint size, GmpcModificationType casing);
static void gmpc_pixbuf_loader_async_load_from_file_async (GmpcPixbufLoaderAsync* self, const gchar* uri, gint req_width, gint req_height, GCancellable* cancel, GmpcModificationType border, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gmpc_pixbuf_loader_async_load_from_file_finish (GmpcPixbufLoaderAsync* self, GAsyncResult* _res_);
static void gmpc_pixbuf_loader_async_size_prepare (GmpcPixbufLoaderAsync* self, GdkPixbufLoader* loader, gint gwidth, gint gheight);
static void gmpc_pixbuf_loader_async_load_from_file_async_data_free (gpointer _data);
static gboolean gmpc_pixbuf_loader_async_load_from_file_async_co (GmpcPixbufLoaderAsyncLoadFromFileAsyncData* data);
static void _gmpc_pixbuf_loader_async_size_prepare_gdk_pixbuf_loader_size_prepared (GdkPixbufLoader* _sender, gint width, gint height, gpointer self);
static void gmpc_pixbuf_loader_async_load_from_file_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GObject * gmpc_pixbuf_loader_async_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gmpc_pixbuf_loader_async_finalize (GObject* obj);
static void _vala_gmpc_pixbuf_loader_async_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gmpc_pixbuf_loader_async_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GMPC_META_IMAGE_ASYNC_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_TYPE_META_IMAGE_ASYNC, GmpcMetaImageAsyncPrivate))
enum  {
	GMPC_META_IMAGE_ASYNC_DUMMY_PROPERTY
};
static void _lambda17_ (GmpcPixbufLoaderAsync* source, GdkPixbuf* pixbuf, GmpcMetaImageAsync* self);
static void __lambda17__gmpc_pixbuf_loader_async_pixbuf_update (GmpcPixbufLoaderAsync* _sender, GdkPixbuf* pixbuf, gpointer self);
static void _lambda18_ (GmpcPixbufLoaderAsync* source, GdkPixbuf* pixbuf, GmpcMetaImageAsync* self);
static void __lambda18__gmpc_pixbuf_loader_async_pixbuf_update (GmpcPixbufLoaderAsync* _sender, GdkPixbuf* pixbuf, gpointer self);
static GObject * gmpc_meta_image_async_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gmpc_meta_image_async_finalize (GObject* obj);


/**
 * Operations you can do on the image. 
 * The modified pixbuf will be stored in cache.
     */
GType gmpc_modification_type_get_type (void) {
	static volatile gsize gmpc_modification_type_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_modification_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GMPC_MODIFICATION_TYPE_NONE, "GMPC_MODIFICATION_TYPE_NONE", "none"}, {GMPC_MODIFICATION_TYPE_CASING, "GMPC_MODIFICATION_TYPE_CASING", "casing"}, {GMPC_MODIFICATION_TYPE_DARKEN, "GMPC_MODIFICATION_TYPE_DARKEN", "darken"}, {GMPC_MODIFICATION_TYPE_DECOLOR, "GMPC_MODIFICATION_TYPE_DECOLOR", "decolor"}, {GMPC_MODIFICATION_TYPE_BORDER, "GMPC_MODIFICATION_TYPE_BORDER", "border"}, {0, NULL, NULL}};
		GType gmpc_modification_type_type_id;
		gmpc_modification_type_type_id = g_enum_register_static ("GmpcModificationType", values);
		g_once_init_leave (&gmpc_modification_type_type_id__volatile, gmpc_modification_type_type_id);
	}
	return gmpc_modification_type_type_id__volatile;
}


static gpointer _gtk_tree_row_reference_copy0 (gpointer self) {
	return self ? gtk_tree_row_reference_copy (self) : NULL;
}


void gmpc_pixbuf_loader_async_set_rref (GmpcPixbufLoaderAsync* self, const GtkTreeRowReference* rreference) {
	GtkTreeRowReference* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rreference != NULL);
	_tmp0_ = _gtk_tree_row_reference_copy0 (rreference);
	_gtk_tree_row_reference_free0 (self->priv->rref);
	self->priv->rref = _tmp0_;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gmpc_pixbuf_loader_async_call_row_changed (GmpcPixbufLoaderAsync* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->rref != NULL) {
		GtkTreeModel* _tmp0_ = NULL;
		GtkTreeModel* _tmp1_;
		GtkTreeModel* model;
		GtkTreePath* _tmp2_ = NULL;
		GtkTreePath* path;
		GtkTreeIter iter = {0};
		GtkTreeIter _tmp3_ = {0};
		gboolean _tmp4_;
		_tmp0_ = gtk_tree_row_reference_get_model (self->priv->rref);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		model = _tmp1_;
		_tmp2_ = gtk_tree_row_reference_get_path (self->priv->rref);
		path = _tmp2_;
		_tmp4_ = gtk_tree_model_get_iter (model, &_tmp3_, path);
		iter = _tmp3_;
		if (_tmp4_) {
			gtk_tree_model_row_changed (model, path, &iter);
		}
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (model);
	}
}


static GdkPixbuf* gmpc_pixbuf_loader_async_modify_pixbuf (GmpcPixbufLoaderAsync* self, GdkPixbuf* pix, gint size, GmpcModificationType casing) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp29_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (pix == NULL) {
		result = NULL;
		_g_object_unref0 (pix);
		return result;
	}
	if ((casing & GMPC_MODIFICATION_TYPE_CASING) == GMPC_MODIFICATION_TYPE_CASING) {
		gint _tmp0_;
		_tmp0_ = cfg_get_single_value_as_int_with_default (config, "metaimage", "addcase", 1);
		if (_tmp0_ == 1) {
			gint _tmp1_;
			gint width;
			gint _tmp2_;
			gint height;
			gdouble spineRatio;
			GtkIconTheme* _tmp3_ = NULL;
			GtkIconInfo* _tmp4_ = NULL;
			GtkIconInfo* ii;
			_tmp1_ = gdk_pixbuf_get_width (pix);
			width = _tmp1_;
			_tmp2_ = gdk_pixbuf_get_height (pix);
			height = _tmp2_;
			spineRatio = 5.0 / 65.0;
			_tmp3_ = gtk_icon_theme_get_default ();
			_tmp4_ = gtk_icon_theme_lookup_icon (_tmp3_, "stylized-cover", size, 0);
			ii = _tmp4_;
			if (ii != NULL) {
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				gchar* path;
				GdkPixbuf* _tmp7_ = NULL;
				GdkPixbuf* case_image;
				gint _tmp8_;
				gint tempw;
				GdkPixbuf* pix2 = NULL;
				gint _tmp9_;
				gint _tmp14_;
				gint _tmp15_;
				GdkPixbuf* _tmp16_ = NULL;
				GdkPixbuf* blank;
				gint _tmp17_ = 0;
				gint _tmp18_;
				gint _tmp20_ = 0;
				gint _tmp21_;
				gint _tmp22_;
				gint temph;
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				GdkPixbuf* _tmp28_;
				_tmp5_ = gtk_icon_info_get_filename (ii);
				_tmp6_ = g_strdup (_tmp5_);
				path = _tmp6_;
				_tmp7_ = gdk_pixbuf_new_from_file_at_scale (path, size, size, TRUE, &_inner_error_);
				case_image = _tmp7_;
				if (_inner_error_ != NULL) {
					goto __catch5_g_error;
				}
				_tmp8_ = gdk_pixbuf_get_width (case_image);
				tempw = (gint) (_tmp8_ * (1.0 - spineRatio));
				_tmp9_ = gdk_pixbuf_get_height (case_image);
				if (((_tmp9_ / ((gdouble) height)) * width) < tempw) {
					GdkPixbuf* _tmp10_ = NULL;
					_tmp10_ = gdk_pixbuf_scale_simple (pix, tempw, (gint) ((height * tempw) / width), GDK_INTERP_BILINEAR);
					_g_object_unref0 (pix2);
					pix2 = _tmp10_;
				} else {
					gint _tmp11_;
					gint _tmp12_;
					GdkPixbuf* _tmp13_ = NULL;
					_tmp11_ = gdk_pixbuf_get_height (case_image);
					_tmp12_ = gdk_pixbuf_get_height (case_image);
					_tmp13_ = gdk_pixbuf_scale_simple (pix, (gint) (width * (_tmp11_ / ((gdouble) height))), _tmp12_, GDK_INTERP_BILINEAR);
					_g_object_unref0 (pix2);
					pix2 = _tmp13_;
				}
				_tmp14_ = gdk_pixbuf_get_width (case_image);
				_tmp15_ = gdk_pixbuf_get_height (case_image);
				_tmp16_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, _tmp14_, _tmp15_);
				blank = _tmp16_;
				gdk_pixbuf_fill (blank, (guint32) 0x000000FF);
				_tmp18_ = gdk_pixbuf_get_width (pix2);
				if (tempw >= _tmp18_) {
					gint _tmp19_;
					_tmp19_ = gdk_pixbuf_get_width (pix2);
					_tmp17_ = _tmp19_;
				} else {
					_tmp17_ = tempw;
				}
				tempw = _tmp17_;
				_tmp21_ = gdk_pixbuf_get_height (case_image);
				_tmp22_ = gdk_pixbuf_get_height (pix2);
				if (_tmp21_ > _tmp22_) {
					gint _tmp23_;
					_tmp23_ = gdk_pixbuf_get_height (pix2);
					_tmp20_ = _tmp23_;
				} else {
					gint _tmp24_;
					_tmp24_ = gdk_pixbuf_get_height (case_image);
					_tmp20_ = _tmp24_;
				}
				temph = _tmp20_;
				_tmp25_ = gdk_pixbuf_get_width (case_image);
				gdk_pixbuf_copy_area (pix2, 0, 0, tempw - 1, temph - 2, blank, _tmp25_ - tempw, 1);
				_tmp26_ = gdk_pixbuf_get_width (case_image);
				_tmp27_ = gdk_pixbuf_get_height (case_image);
				gdk_pixbuf_composite (case_image, blank, 0, 0, _tmp26_, _tmp27_, (gdouble) 0, (gdouble) 0, (gdouble) 1, (gdouble) 1, GDK_INTERP_BILINEAR, 250);
				_tmp28_ = blank;
				blank = NULL;
				_g_object_unref0 (pix);
				pix = _tmp28_;
				_g_object_unref0 (blank);
				_g_object_unref0 (pix2);
				_g_object_unref0 (case_image);
				goto __finally5;
				__catch5_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_log (LOG_DOMAIN, G_LOG_LEVEL_WARNING, "gmpc-image-async.vala:108: Failed to get the stylized-cover image");
					_g_error_free0 (e);
				}
				__finally5:
				if (_inner_error_ != NULL) {
					_g_free0 (path);
					_gtk_icon_info_free0 (ii);
					_g_object_unref0 (pix);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (path);
			}
			_gtk_icon_info_free0 (ii);
		} else {
			screenshot_add_border (pix);
		}
	}
	if ((casing & GMPC_MODIFICATION_TYPE_DARKEN) == GMPC_MODIFICATION_TYPE_DARKEN) {
		darken_pixbuf (pix, (guint) 2);
	}
	if ((casing & GMPC_MODIFICATION_TYPE_DECOLOR) == GMPC_MODIFICATION_TYPE_DECOLOR) {
		decolor_pixbuf (pix, pix);
	}
	if ((casing & GMPC_MODIFICATION_TYPE_BORDER) == GMPC_MODIFICATION_TYPE_BORDER) {
		screenshot_add_border (pix);
	}
	_tmp29_ = _g_object_ref0 (pix);
	result = _tmp29_;
	_g_object_unref0 (pix);
	return result;
}


void gmpc_pixbuf_loader_async_set_from_file (GmpcPixbufLoaderAsync* self, const gchar* uri, gint req_width, gint req_height, GmpcModificationType border) {
	gchar* _tmp0_;
	gint _tmp1_;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* pb;
	GCancellable* _tmp3_ = NULL;
	GCancellable* cancel;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	self->priv->width = req_width;
	self->priv->height = req_height;
	gmpc_pixbuf_loader_async_cancel (self);
	self->priv->pcancel = NULL;
	_tmp0_ = g_strdup (uri);
	_g_free0 (self->uri);
	self->uri = _tmp0_;
	_tmp1_ = MAX (self->priv->width, self->priv->height);
	_tmp2_ = pixbuf_cache_lookup_icon (_tmp1_, uri);
	pb = _tmp2_;
	if (pb != NULL) {
		gmpc_pixbuf_loader_async_set_pixbuf (self, pb);
		g_signal_emit_by_name (self, "pixbuf-update", self->priv->_pixbuf);
		gmpc_pixbuf_loader_async_call_row_changed (self);
		_g_object_unref0 (pb);
		return;
	}
	_tmp3_ = g_cancellable_new ();
	cancel = _tmp3_;
	self->priv->pcancel = cancel;
	gmpc_pixbuf_loader_async_load_from_file_async (self, uri, self->priv->width, self->priv->height, cancel, border, NULL, NULL);
	_g_object_unref0 (cancel);
	_g_object_unref0 (pb);
}


void gmpc_pixbuf_loader_async_cancel (GmpcPixbufLoaderAsync* self) {
	g_return_if_fail (self != NULL);
	g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-image-async.vala:158: Cancel the image loading");
	if (self->priv->pcancel != NULL) {
		g_cancellable_cancel (self->priv->pcancel);
	}
}


static void gmpc_pixbuf_loader_async_size_prepare (GmpcPixbufLoaderAsync* self, GdkPixbufLoader* loader, gint gwidth, gint gheight) {
	gint _tmp0_;
	gdouble dsize;
	gint nwidth;
	gint nheight;
	g_return_if_fail (self != NULL);
	g_return_if_fail (loader != NULL);
	_tmp0_ = MAX (self->priv->width, self->priv->height);
	dsize = (gdouble) _tmp0_;
	nwidth = 0;
	nheight = 0;
	if (self->priv->height < 0) {
		gdouble scale;
		scale = self->priv->width / ((gdouble) gwidth);
		nwidth = self->priv->width;
		nheight = (gint) (gheight * scale);
	} else {
		if (self->priv->width < 0) {
			gdouble scale;
			scale = self->priv->height / ((gdouble) gheight);
			nheight = self->priv->height;
			nwidth = (gint) (gwidth * scale);
		} else {
			gint _tmp1_ = 0;
			gint _tmp2_ = 0;
			if (gheight > gwidth) {
				_tmp1_ = (gint) ((dsize / gheight) * gwidth);
			} else {
				_tmp1_ = (gint) dsize;
			}
			nwidth = _tmp1_;
			if (gwidth > gheight) {
				_tmp2_ = (gint) ((dsize / gwidth) * gheight);
			} else {
				_tmp2_ = (gint) dsize;
			}
			nheight = _tmp2_;
		}
	}
	gdk_pixbuf_loader_set_size (loader, nwidth, nheight);
}


static void gmpc_pixbuf_loader_async_load_from_file_async_data_free (gpointer _data) {
	GmpcPixbufLoaderAsyncLoadFromFileAsyncData* data;
	data = _data;
	_g_free0 (data->uri);
	_g_object_unref0 (data->cancel);
	_g_object_unref0 (data->self);
	g_slice_free (GmpcPixbufLoaderAsyncLoadFromFileAsyncData, data);
}


static void gmpc_pixbuf_loader_async_load_from_file_async (GmpcPixbufLoaderAsync* self, const gchar* uri, gint req_width, gint req_height, GCancellable* cancel, GmpcModificationType border, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GmpcPixbufLoaderAsyncLoadFromFileAsyncData* _data_;
	_data_ = g_slice_new0 (GmpcPixbufLoaderAsyncLoadFromFileAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gmpc_pixbuf_loader_async_load_from_file_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gmpc_pixbuf_loader_async_load_from_file_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->uri = g_strdup (uri);
	_data_->req_width = req_width;
	_data_->req_height = req_height;
	_data_->cancel = _g_object_ref0 (cancel);
	_data_->border = border;
	gmpc_pixbuf_loader_async_load_from_file_async_co (_data_);
}


static void gmpc_pixbuf_loader_async_load_from_file_finish (GmpcPixbufLoaderAsync* self, GAsyncResult* _res_) {
	GmpcPixbufLoaderAsyncLoadFromFileAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _gmpc_pixbuf_loader_async_size_prepare_gdk_pixbuf_loader_size_prepared (GdkPixbufLoader* _sender, gint width, gint height, gpointer self) {
	gmpc_pixbuf_loader_async_size_prepare (self, _sender, width, height);
}


static void gmpc_pixbuf_loader_async_load_from_file_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GmpcPixbufLoaderAsyncLoadFromFileAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	gmpc_pixbuf_loader_async_load_from_file_async_co (data);
}


static gboolean gmpc_pixbuf_loader_async_load_from_file_async_co (GmpcPixbufLoaderAsyncLoadFromFileAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->self->priv->width = data->req_width;
	data->self->priv->height = data->req_height;
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_new_for_path (data->uri);
	data->file = data->_tmp0_;
	data->_result_ = (gsize) 0;
	data->_tmp1_ = NULL;
	data->_tmp1_ = gdk_pixbuf_loader_new ();
	data->loader = data->_tmp1_;
	g_signal_connect_object (data->loader, "size-prepared", (GCallback) _gmpc_pixbuf_loader_async_size_prepare_gdk_pixbuf_loader_size_prepared, data->self, 0);
	data->_state_ = 1;
	g_file_read_async (data->file, 0, data->cancel, gmpc_pixbuf_loader_async_load_from_file_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp2_ = NULL;
	data->_tmp2_ = g_file_read_finish (data->file, data->_res_, &data->_inner_error_);
	data->stream = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		goto __catch6_g_error;
	}
	data->_tmp4_ = g_cancellable_is_cancelled (data->cancel);
	if (!data->_tmp4_) {
		data->_tmp3_ = data->stream != NULL;
	} else {
		data->_tmp3_ = FALSE;
	}
	if (data->_tmp3_) {
		{
			data->_tmp5_ = TRUE;
			while (TRUE) {
				if (!data->_tmp5_) {
					data->_tmp7_ = g_cancellable_is_cancelled (data->cancel);
					if (!data->_tmp7_) {
						data->_tmp6_ = data->_result_ > 0;
					} else {
						data->_tmp6_ = FALSE;
					}
					if (!data->_tmp6_) {
						break;
					}
				}
				data->_tmp5_ = FALSE;
				data->_state_ = 2;
				g_input_stream_read_async ((GInputStream*) data->stream, data->data, (gsize) 1024, 0, data->cancel, gmpc_pixbuf_loader_async_load_from_file_async_ready, data);
				return FALSE;
				_state_2:
				data->_tmp8_ = g_input_stream_read_finish ((GInputStream*) data->stream, data->_res_, &data->_inner_error_);
				data->_tmp9_ = data->_tmp8_;
				if (data->_inner_error_ != NULL) {
					goto __catch7_g_error;
				}
				data->_result_ = (gsize) data->_tmp9_;
				gdk_pixbuf_loader_write (data->loader, (const gchar*) data->data, data->_result_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch7_g_error;
				}
				goto __finally7;
				__catch7_g_error:
				{
					data->erro = data->_inner_error_;
					data->_inner_error_ = NULL;
					g_warning ("gmpc-image-async.vala:208: Error trying to fetch image: %s::%s", data->erro->message, data->uri);
					g_cancellable_cancel (data->cancel);
					_g_error_free0 (data->erro);
				}
				__finally7:
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->stream);
					goto __catch6_g_error;
				}
			}
		}
	}
	_g_object_unref0 (data->stream);
	goto __finally6;
	__catch6_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("gmpc-image-async.vala:214: Error trying to fetch image: %s::%s", data->e->message, data->uri);
		_g_error_free0 (data->e);
	}
	__finally6:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->loader);
		_g_object_unref0 (data->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	gdk_pixbuf_loader_close (data->loader, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	goto __finally8;
	__catch8_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_debug ("gmpc-image-async.vala:219: Error trying to parse image: %s::%s? query " \
"cancelled?", data->err->message, data->uri);
		g_signal_emit_by_name (data->self, "pixbuf-update", NULL);
		gmpc_pixbuf_loader_async_call_row_changed (data->self);
		_g_object_unref0 (data->loader);
		data->loader = NULL;
		data->self->priv->pcancel = NULL;
		_g_error_free0 (data->err);
		_g_object_unref0 (data->loader);
		_g_object_unref0 (data->file);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally8:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->loader);
		_g_object_unref0 (data->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp10_ = g_cancellable_is_cancelled (data->cancel);
	if (data->_tmp10_) {
		g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-image-async.vala:230: Cancelled loading of image");
		g_signal_emit_by_name (data->self, "pixbuf-update", NULL);
		g_cancellable_reset (data->cancel);
		_g_object_unref0 (data->loader);
		data->loader = NULL;
		data->self->priv->pcancel = NULL;
		_g_object_unref0 (data->loader);
		_g_object_unref0 (data->file);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp11_ = NULL;
	data->_tmp11_ = gdk_pixbuf_loader_get_pixbuf (data->loader);
	data->_tmp12_ = _g_object_ref0 (data->_tmp11_);
	data->pix = data->_tmp12_;
	data->_tmp13_ = MAX (data->self->priv->height, data->self->priv->width);
	data->_tmp14_ = NULL;
	data->_tmp14_ = pixbuf_cache_lookup_icon (data->_tmp13_, data->uri);
	data->final = data->_tmp14_;
	if (data->final == NULL) {
		data->_tmp15_ = data->pix;
		data->pix = NULL;
		data->_tmp16_ = MAX (data->self->priv->height, data->self->priv->width);
		data->_tmp17_ = NULL;
		data->_tmp17_ = gmpc_pixbuf_loader_async_modify_pixbuf (data->self, data->_tmp15_, data->_tmp16_, data->border);
		_g_object_unref0 (data->final);
		data->final = data->_tmp17_;
		data->_tmp18_ = MAX (data->self->priv->height, data->self->priv->width);
		pixbuf_cache_add_icon (data->_tmp18_, data->uri, data->final);
	}
	gmpc_pixbuf_loader_async_set_pixbuf (data->self, data->final);
	g_signal_emit_by_name (data->self, "pixbuf-update", data->self->priv->_pixbuf);
	gmpc_pixbuf_loader_async_call_row_changed (data->self);
	data->self->priv->pcancel = NULL;
	_g_object_unref0 (data->loader);
	data->loader = NULL;
	_g_object_unref0 (data->final);
	_g_object_unref0 (data->pix);
	_g_object_unref0 (data->loader);
	_g_object_unref0 (data->file);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


GmpcPixbufLoaderAsync* gmpc_pixbuf_loader_async_construct (GType object_type) {
	GmpcPixbufLoaderAsync * self = NULL;
	self = (GmpcPixbufLoaderAsync*) g_object_new (object_type, NULL);
	return self;
}


GmpcPixbufLoaderAsync* gmpc_pixbuf_loader_async_new (void) {
	return gmpc_pixbuf_loader_async_construct (GMPC_TYPE_PIXBUF_LOADER_ASYNC);
}


GdkPixbuf* gmpc_pixbuf_loader_async_get_pixbuf (GmpcPixbufLoaderAsync* self) {
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_pixbuf;
	return result;
}


void gmpc_pixbuf_loader_async_set_pixbuf (GmpcPixbufLoaderAsync* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_pixbuf);
	self->priv->_pixbuf = _tmp0_;
	g_object_notify ((GObject *) self, "pixbuf");
}


static GObject * gmpc_pixbuf_loader_async_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcPixbufLoaderAsync * self;
	parent_class = G_OBJECT_CLASS (gmpc_pixbuf_loader_async_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_PIXBUF_LOADER_ASYNC (obj);
	g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-image-async.vala:68: Create the image loading\n");
	return obj;
}


static void gmpc_pixbuf_loader_async_class_init (GmpcPixbufLoaderAsyncClass * klass) {
	gmpc_pixbuf_loader_async_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcPixbufLoaderAsyncPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gmpc_pixbuf_loader_async_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gmpc_pixbuf_loader_async_set_property;
	G_OBJECT_CLASS (klass)->constructor = gmpc_pixbuf_loader_async_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_pixbuf_loader_async_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GMPC_PIXBUF_LOADER_ASYNC_PIXBUF, g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("pixbuf_update", GMPC_TYPE_PIXBUF_LOADER_ASYNC, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GDK_TYPE_PIXBUF);
}


static void gmpc_pixbuf_loader_async_instance_init (GmpcPixbufLoaderAsync * self) {
	self->priv = GMPC_PIXBUF_LOADER_ASYNC_GET_PRIVATE (self);
	self->priv->pcancel = NULL;
	self->uri = NULL;
	self->priv->_pixbuf = NULL;
	self->priv->rref = NULL;
	self->priv->width = 0;
	self->priv->height = 0;
}


static void gmpc_pixbuf_loader_async_finalize (GObject* obj) {
	GmpcPixbufLoaderAsync * self;
	self = GMPC_PIXBUF_LOADER_ASYNC (obj);
	g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-image-async.vala:72: Free the image loading");
	if (self->priv->pcancel != NULL) {
		g_cancellable_cancel (self->priv->pcancel);
	}
	_g_free0 (self->uri);
	_g_object_unref0 (self->priv->_pixbuf);
	_gtk_tree_row_reference_free0 (self->priv->rref);
	G_OBJECT_CLASS (gmpc_pixbuf_loader_async_parent_class)->finalize (obj);
}


GType gmpc_pixbuf_loader_async_get_type (void) {
	static volatile gsize gmpc_pixbuf_loader_async_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_pixbuf_loader_async_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcPixbufLoaderAsyncClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_pixbuf_loader_async_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcPixbufLoaderAsync), 0, (GInstanceInitFunc) gmpc_pixbuf_loader_async_instance_init, NULL };
		GType gmpc_pixbuf_loader_async_type_id;
		gmpc_pixbuf_loader_async_type_id = g_type_register_static (G_TYPE_OBJECT, "GmpcPixbufLoaderAsync", &g_define_type_info, 0);
		g_once_init_leave (&gmpc_pixbuf_loader_async_type_id__volatile, gmpc_pixbuf_loader_async_type_id);
	}
	return gmpc_pixbuf_loader_async_type_id__volatile;
}


static void _vala_gmpc_pixbuf_loader_async_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GmpcPixbufLoaderAsync * self;
	self = GMPC_PIXBUF_LOADER_ASYNC (object);
	switch (property_id) {
		case GMPC_PIXBUF_LOADER_ASYNC_PIXBUF:
		g_value_set_object (value, gmpc_pixbuf_loader_async_get_pixbuf (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gmpc_pixbuf_loader_async_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GmpcPixbufLoaderAsync * self;
	self = GMPC_PIXBUF_LOADER_ASYNC (object);
	switch (property_id) {
		case GMPC_PIXBUF_LOADER_ASYNC_PIXBUF:
		gmpc_pixbuf_loader_async_set_pixbuf (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _lambda17_ (GmpcPixbufLoaderAsync* source, GdkPixbuf* pixbuf, GmpcMetaImageAsync* self) {
	g_return_if_fail (source != NULL);
	gtk_image_set_from_pixbuf ((GtkImage*) self, pixbuf);
}


static void __lambda17__gmpc_pixbuf_loader_async_pixbuf_update (GmpcPixbufLoaderAsync* _sender, GdkPixbuf* pixbuf, gpointer self) {
	_lambda17_ (_sender, pixbuf, self);
}


void gmpc_meta_image_async_set_from_file (GmpcMetaImageAsync* self, const gchar* uri, gint size, GmpcModificationType border) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_strdup (uri);
	_g_free0 (self->uri);
	self->uri = _tmp0_;
	if (self->priv->loader == NULL) {
		GmpcPixbufLoaderAsync* _tmp1_ = NULL;
		_tmp1_ = gmpc_pixbuf_loader_async_new ();
		_g_object_unref0 (self->priv->loader);
		self->priv->loader = _tmp1_;
		g_signal_connect_object (self->priv->loader, "pixbuf-update", (GCallback) __lambda17__gmpc_pixbuf_loader_async_pixbuf_update, self, 0);
	}
	gmpc_pixbuf_loader_async_set_from_file (self->priv->loader, uri, size, size, border);
}


static void _lambda18_ (GmpcPixbufLoaderAsync* source, GdkPixbuf* pixbuf, GmpcMetaImageAsync* self) {
	g_return_if_fail (source != NULL);
	gtk_image_set_from_pixbuf ((GtkImage*) self, pixbuf);
}


static void __lambda18__gmpc_pixbuf_loader_async_pixbuf_update (GmpcPixbufLoaderAsync* _sender, GdkPixbuf* pixbuf, gpointer self) {
	_lambda18_ (_sender, pixbuf, self);
}


void gmpc_meta_image_async_set_from_file_at_size (GmpcMetaImageAsync* self, const gchar* uri, gint width, gint height, GmpcModificationType border) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_strdup (uri);
	_g_free0 (self->uri);
	self->uri = _tmp0_;
	if (self->priv->loader == NULL) {
		GmpcPixbufLoaderAsync* _tmp1_ = NULL;
		_tmp1_ = gmpc_pixbuf_loader_async_new ();
		_g_object_unref0 (self->priv->loader);
		self->priv->loader = _tmp1_;
		g_signal_connect_object (self->priv->loader, "pixbuf-update", (GCallback) __lambda18__gmpc_pixbuf_loader_async_pixbuf_update, self, 0);
	}
	gmpc_pixbuf_loader_async_set_from_file (self->priv->loader, uri, width, height, border);
}


void gmpc_meta_image_async_clear_now (GmpcMetaImageAsync* self) {
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->loader);
	self->priv->loader = NULL;
	_g_free0 (self->uri);
	self->uri = NULL;
	gtk_image_clear ((GtkImage*) self);
}


void gmpc_meta_image_async_set_pixbuf (GmpcMetaImageAsync* self, GdkPixbuf* pb) {
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->loader);
	self->priv->loader = NULL;
	_g_free0 (self->uri);
	self->uri = NULL;
	if (pb != NULL) {
		gtk_image_set_from_pixbuf ((GtkImage*) self, pb);
	} else {
		gtk_image_clear ((GtkImage*) self);
	}
}


GmpcMetaImageAsync* gmpc_meta_image_async_construct (GType object_type) {
	GmpcMetaImageAsync * self = NULL;
	self = (GmpcMetaImageAsync*) g_object_new (object_type, NULL);
	return self;
}


GmpcMetaImageAsync* gmpc_meta_image_async_new (void) {
	return gmpc_meta_image_async_construct (GMPC_TYPE_META_IMAGE_ASYNC);
}


static GObject * gmpc_meta_image_async_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcMetaImageAsync * self;
	parent_class = G_OBJECT_CLASS (gmpc_meta_image_async_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_META_IMAGE_ASYNC (obj);
	return obj;
}


static void gmpc_meta_image_async_class_init (GmpcMetaImageAsyncClass * klass) {
	gmpc_meta_image_async_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcMetaImageAsyncPrivate));
	G_OBJECT_CLASS (klass)->constructor = gmpc_meta_image_async_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_meta_image_async_finalize;
}


static void gmpc_meta_image_async_instance_init (GmpcMetaImageAsync * self) {
	self->priv = GMPC_META_IMAGE_ASYNC_GET_PRIVATE (self);
	self->priv->loader = NULL;
	self->uri = NULL;
}


static void gmpc_meta_image_async_finalize (GObject* obj) {
	GmpcMetaImageAsync * self;
	self = GMPC_META_IMAGE_ASYNC (obj);
	g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-image-async.vala:263: Freeing metaimageasync\n");
	_g_object_unref0 (self->priv->loader);
	_g_free0 (self->uri);
	G_OBJECT_CLASS (gmpc_meta_image_async_parent_class)->finalize (obj);
}


GType gmpc_meta_image_async_get_type (void) {
	static volatile gsize gmpc_meta_image_async_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_meta_image_async_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcMetaImageAsyncClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_meta_image_async_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcMetaImageAsync), 0, (GInstanceInitFunc) gmpc_meta_image_async_instance_init, NULL };
		GType gmpc_meta_image_async_type_id;
		gmpc_meta_image_async_type_id = g_type_register_static (GTK_TYPE_IMAGE, "GmpcMetaImageAsync", &g_define_type_info, 0);
		g_once_init_leave (&gmpc_meta_image_async_type_id__volatile, gmpc_meta_image_async_type_id);
	}
	return gmpc_meta_image_async_type_id__volatile;
}



