/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.logdata;

import gmonitor.logdata.DataElement;
import gmonitor.logdata.IntervalDefBlock;
import gmonitor.logdata.IntervalDefElement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class DataBlock {
    boolean valid = true;
    int timeInUNIXSeconds;
    int timeInUNIXuSeconds;
    long time;
    ArrayList data = new ArrayList();

    public DataBlock() {
        this.valid = false;
    }

    public DataBlock(byte[] byArray, int n, int n2) {
        this.timeInUNIXSeconds = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        this.timeInUNIXuSeconds = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        this.time = (long)this.timeInUNIXSeconds * 1000L + (long)this.timeInUNIXuSeconds / 1000L;
        for (int i = 0; i < n2; ++i) {
            byte by = byArray[n++];
            long l = ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
            DataElement dataElement = new DataElement(by, l);
            this.data.add(dataElement);
        }
    }

    public ArrayList getData() {
        return this.data;
    }

    public int getTimeInUNIXSeconds() {
        return this.timeInUNIXSeconds;
    }

    public int getTimeInUNIXuSeconds() {
        return this.timeInUNIXuSeconds;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String asDump(int n, IntervalDefBlock intervalDefBlock) {
        StringBuffer stringBuffer = new StringBuffer();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        long l = (long)this.timeInUNIXSeconds * 1000L;
        String string = simpleDateFormat.format(new Date(l));
        stringBuffer.append("# DataBlock " + n + "\n");
        if (this.valid) {
            stringBuffer.append("TimeStampInSeconds::" + this.timeInUNIXSeconds + ":\"");
            stringBuffer.append(string + "\"\n");
            stringBuffer.append("TimeStampInuSeconds::" + this.timeInUNIXuSeconds + "\n");
            for (int i = 0; i < this.data.size(); ++i) {
                IntervalDefElement intervalDefElement = intervalDefBlock.getElement(i);
                int n2 = intervalDefElement.getHostIndex();
                int n3 = intervalDefElement.getOidIndex();
                DataElement dataElement = (DataElement)this.data.get(i);
                stringBuffer.append(dataElement.asDump(n2, n3));
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public long getTime() {
        return this.time;
    }
}

