/*
    saft.c - SAFT interface
    Copyright (c) 1999,2006  Joey Schulze <joey@infodrom.org>

    This file is part of the Gerstensaft package.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA.
*/

#define _GNU_SOURCE

#include <malloc.h>
#include <stdlib.h>
#include <unistd.h>
#include "config.h"
#include "msgbox.h"
#include "io.h"
#include "nls.h"
#include "beer.h"
#include "saft.h"


#include <stdio.h>
#include <string.h>

char *saft_taint_fname (char *fname)
{
  char *res = NULL;
  char *p, *q;

  if (!fname)
    return NULL;

  if ((res = (char *)malloc((strlen(fname)*2)+1)) != NULL) {
    for (p=fname,q=res;*p;p++,q++) {
      if (strchr(" |\'\"`", *p))
	*(q++)='\\';
      *q=*p;
    }
    *q='\0';
  }

  return res;
}

int saft_send (const char *addr, char **files, const char *comment)
{
  char **cp;
  char *cmd;
  char *lastdir;
  char errmsg[1024];
  char *taint_fname;
  char *taint_comment = NULL;
  char *msg;
  char protocol[4];
  int ret;

  if (!addr || !strlen(addr))
    return 0;

  if (comment && strlen(comment))
    taint_comment = escape_quotes((char *)comment);

  if (config.protocol == PROTOCOL_AUTO)
    protocol[0] = '\0';
  else if (config.protocol == PROTOCOL_IPV4)
    strcpy (protocol, " -4");
  else if (config.protocol == PROTOCOL_IPV6)
    strcpy (protocol, " -6");

  /*
   * Since comments can be only added to single files or archives,
   * don't group arguments.
   */
  for (cp=files; *cp; (char **)cp++) {

    if ((lastdir = strrchr (*cp, '/')) == NULL){
      snprintf (errmsg, sizeof(errmsg), _("'%s' lacks full path"), *cp);
      msgbox (_("Error condition"), errmsg);
      continue;
    }

    *lastdir = '\0';
    if (chdir (*cp) != 0) {
      snprintf (errmsg, sizeof(errmsg), _("Can't change directory to '%s'"), *cp);
      msgbox (_("Error condition"), errmsg);
      *(lastdir++) = '/';
      continue;
    }
    *(lastdir++) = '/';

    taint_fname = saft_taint_fname((char *)lastdir);

    if (is_dir (lastdir, NULL)) {
      if (taint_comment) {
	if (asprintf (&cmd, "sendfile -Q%s -a=%s -c '%s' %s %s 2> /dev/null",
		      protocol, taint_fname, taint_comment, taint_fname, addr) == -1)
	  return 0;
      } else {
	if (asprintf (&cmd, "sendfile -Q%s -a=%s %s %s 2> /dev/null",
		      protocol, taint_fname, taint_fname, addr) == -1)
	  return 0;
      }
    } else {
      if (taint_comment) {
	if (asprintf (&cmd, "sendfile -Q%s -c '%s' %s %s 2> /dev/null",
		      protocol, taint_comment, taint_fname, addr) == -1)
	  return 0;
      } else {
	if (asprintf (&cmd, "sendfile -Q%s %s %s 2> /dev/null",
		      protocol, taint_fname, addr) == -1)
	  return 0;
      }
    }
    free (taint_fname);

#ifdef DEBUG
    printf ("%s\n", cmd);
#endif

    ret = system (cmd);
    if (ret == -1) {
      perror ("system");
      free (cmd);
      return 0;
    } else if (WEXITSTATUS(ret)) {
      if (asprintf (&msg, _("%s terminated with exit code %d."),
		    "sendfile", WEXITSTATUS(ret)) != -1) {
	msgbox (_("Error condition"), msg);
	free (msg);
      }
      free (cmd);
      return 0;
    }
    free (cmd);
  }
  return 1;
}
