/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.parameters;

import geotrans3.parameters.CoordinateSystemParameters;

public class MercatorScaleFactorParameters
extends CoordinateSystemParameters {
    private double centralMeridian;
    private double scaleFactor;
    private double falseEasting;
    private double falseNorthing;

    public MercatorScaleFactorParameters(int n, double d, double d2, double d3, double d4) {
        super(n);
        this.centralMeridian = d;
        this.scaleFactor = d2;
        this.falseEasting = d3;
        this.falseNorthing = d4;
    }

    public boolean equal(MercatorScaleFactorParameters mercatorScaleFactorParameters) {
        return super.equal(mercatorScaleFactorParameters) && this.centralMeridian == mercatorScaleFactorParameters.getCentralMeridian() && this.scaleFactor == mercatorScaleFactorParameters.getScaleFactor() && this.falseEasting == mercatorScaleFactorParameters.getFalseEasting() && this.falseNorthing == mercatorScaleFactorParameters.getFalseNorthing();
    }

    public double getCentralMeridian() {
        return this.centralMeridian;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public String toString() {
        return "MercatorScaleFactorParameters: CentralMeridian = " + this.centralMeridian + " ScaleFactor = " + this.scaleFactor + " FalseEasting = " + this.falseEasting + " FalseNorthing = " + this.falseNorthing;
    }
}

