;;;
;;; gen-syms.scm - Generate gl-syms.[ch]
;;;
;;;  Copyright (c) 2005-2008  Shiro Kawai  <shiro@acm.org>
;;;
;;;  Redistribution and use in source and binary forms, with or without
;;;  modification, are permitted provided that the following conditions
;;;  are met:
;;;
;;;   1. Redistributions of source code must retain the above copyright
;;;      notice, this list of conditions and the following disclaimer.
;;;
;;;   2. Redistributions in binary form must reproduce the above copyright
;;;      notice, this list of conditions and the following disclaimer in the
;;;      documentation and/or other materials provided with the distribution.
;;;
;;;   3. Neither the name of the authors nor the names of its contributors
;;;      may be used to endorse or promote products derived from this
;;;      software without specific prior written permission.
;;;
;;;  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
;;;  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
;;;  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
;;;  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
;;;  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
;;;  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
;;;  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
;;;  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
;;;  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;;  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;;  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;;;
;;;  $Id: gen-syms.scm,v 1.4 2008-06-04 11:50:40 shirok Exp $
;;;

(use util.match)
(use gauche.cgen)
(use gauche.parameter)

(define *glext-abi* "glext-abi.scm")

(cgen-current-unit
 (make <cgen-unit>
   :name "gl-syms"
   :h-file "gl-syms.h"
   :preamble "/* generated by gen-syms.scm $Revision: 1.4 $.  DO NOT EDIT */"
   :init-prologue "void Scm_Init_gl_syms(void)\n{"
   ))

(define (main args)
  (cgen-decl "#include <gauche.h>")
  (cgen-init "  ScmModule *m = SCM_MODULE(SCM_FIND_MODULE(\"gl\", TRUE));")
  (with-input-from-file *glext-abi*
    (cut port-for-each gen read))
  (cgen-emit-h (cgen-current-unit))
  (cgen-emit-c (cgen-current-unit))
  0)

(define (gen expr)
  (match expr
    (('define-extension-name var)
     (let ((varname-literal (cgen-literal (symbol->string var))))
       (cgen-init
        (format "  Scm_Define(m, SCM_SYMBOL(Scm_Intern(SCM_STRING(~a))), SCM_UNDEFINED);"
                (cgen-cexpr varname-literal)))
       ))
    (('define-constant var val)
     (let ((varname-literal (cgen-literal (symbol->string var)))
           (val-literal (cgen-literal val)))
       (cgen-extern
        (format "#undef ~a" var)
        (format "#define ~a ~a" var val))
       (cgen-init
        (format "  Scm_DefineConst(m, SCM_SYMBOL(Scm_Intern(SCM_STRING(~a))), ~a);"
                (cgen-cexpr varname-literal)
                (cgen-cexpr val-literal)))))
    (else #f)))
