############################################################
## gatos.m4      ###     0.2     ###     26 Aug 1999     ###
############################################################
## usage:
##  IBTK_CHECK:               enable/disable checking ibtk header files/lib.
##                              check by default.
##  AC_TRY_CPP_MOD:           modified version of autoconf part
##                              (needed by AC_CHECK_HEADER_MOD)
##  AC_CHECK_HEADER_MOD:      modified version of autoconf part
##                              needed by FreeBSD.
##  AM_INCLUDES_IBTK:         check IBTK header files (platform dependent).
##  AM_LIB_IBTK:              check IBTK library.
##  GATOS_DGA_VMODE:          check header files and lib of 
##			      libXxf86dga and libXxf86vmode
##  GATOS_HASH_CHARS:         check enabling of hashing chars feature
##  GATOS_RAW_CC_EDS:         check enabling of raw cc and raw eds feature
##  GATOS_I2C_DELAY:          check for i2c timer source
##  GATOS_SOUND_OSSEMU:       check enabling of oss sound emulation 
##                              under NetBSD
##  GATOS_SHM:                enable/disable IPC shared memory.
##  GATOS_IPC:                enable/disable IPC messages.
############################################################

AC_DEFUN(IBTK_CHECK,[
  AC_ARG_ENABLE(ibtk-ckeck,
  [GATOS Features:                                                                   --enable-ibtk-check     Enable IBTK header files/lib checking (default)],,)
    
  if test "$enable_ibtk_check" = "yes"; then
      ibtk_check=yes
  elif test "$enable_ibtk_check" = "no"; then
      ibtk_check=no
  else
      ibtk_check=yes
  fi
])

dnl ################################################

AC_DEFUN(AC_TRY_CPP_MOD,
[AC_REQUIRE_CPP()dnl
cat > conftest.$ac_ext <<EOF
[#]line __oline__ "configure"
#include "confdefs.h"
[$1]
EOF
dnl Capture the stderr of cpp.  eval is necessary to expand ac_cpp.
dnl We used to copy stderr to stdout and capture it in a variable, but
dnl that breaks under sh -x, which writes compile commands starting
dnl with ` +' to stderr in eval and subshells.
ac_try="$ac_cpp conftest.$ac_ext -I/usr/X11R6/include \
	>/dev/null 2>conftest.out"
AC_TRY_EVAL(ac_try)
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  ifelse([$2], , :, [rm -rf conftest*
  $2])
else
  echo "$ac_err" >&AC_FD_CC
  echo "configure: failed program was:" >&AC_FD_CC
  cat conftest.$ac_ext >&AC_FD_CC
ifelse([$3], , , [  rm -rf conftest*
  $3
])dnl
fi
rm -f conftest*])

dnl ################################################

AC_DEFUN(AC_CHECK_HEADER_MOD,
[dnl Do the transliteration at runtime so arg 1 can be a shell variable.
ac_safe=`echo "$1" | sed 'y%./+-%__p_%'`
AC_MSG_CHECKING([for $1])
AC_CACHE_VAL(ac_cv_header_$ac_safe,
[AC_TRY_CPP_MOD([#include <$1>], eval "ac_cv_header_$ac_safe=yes",
  eval "ac_cv_header_$ac_safe=no")])dnl
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  AC_MSG_RESULT(yes)
  ifelse([$2], , :, [$2])
else
  AC_MSG_RESULT(no)
ifelse([$3], , , [$3
])dnl
fi
])

dnl ################################################

AC_DEFUN(AM_INCLUDES_IBTK,[
    IBTK_HEADER_FILES="ibox.h ibutton.h idialogs.h idodad.h igbox.h  \
		iintbox.h ilistbox.h irealbox.h isbutton.h islider.h \
		istatbar.h itextbox.h iwindow.h pclaim.h version.h"

    case "$ArchRunning" in
      x86Linux)
	hdir="ibtk"
      ;;
      x86FreeBSD)
	hdir="/usr/local/include/ibtk"
      ;;
      x86NetBSD)
	hdir="/usr/local/include/ibtk"
      ;;
      *)
	AC_MSG_ERROR(Unknown Arch)
      ;;
    esac

    for ibtkh in $IBTK_HEADER_FILES; do
        AC_CHECK_HEADER_MOD($hdir/$ibtkh, have_ibtk_headers=yes, \
           AC_MSG_ERROR(some IBTK headers missing... please check.))
    done
])

dnl ################################################

AC_DEFUN(AM_LIB_IBTK,[
  AC_CHECK_LIB(ibtk, main, have_ibtk_lib=yes,
   AC_MSG_ERROR(libibtk not present. Xatitv will cannot compile.),
		-L$x_libraries -L/usr/lib -L/usr/local/lib)
])

dnl ################################################

AC_DEFUN(GATOS_DGA_VMODE,[
  XEXTLIBS=""
  XEXTFLAGS=""
  AC_MSG_CHECKING(using DGA and VMODE extensions support)
  AC_ARG_WITH(dga-vmode,
    [  --with-dga-vmode        Use DGA and VMODE extensions support (default)],
    [case "$withval" in
      no)
         AC_MSG_RESULT(no)
         dga_vmode=no
      ;;
      *)
         AC_MSG_RESULT(yes)
         dga_vmode=yes
      ;;
    esac],[
    dga_vmode=yes
    AC_MSG_RESULT(yes)
  ])

  dnl forced to no, set to yes if everything going all right 
  use_dga_vmode=no    

  if test "$dga_vmode" = "yes"; then
    AC_CHECK_HEADER_MOD(X11/extensions/xf86dga.h, have_dga_header=yes,
	have_dga_header=no)

    AC_CHECK_HEADER_MOD(X11/extensions/xf86vmode.h, have_vmode_header=yes,
	have_vmode_header=no)

    AC_CHECK_LIB(Xxf86dga, main, [have_dga_lib=yes; 
        XEXTLIBS="$XEXTLIBS -lXxf86dga"; XEXTFLAGS="$XEXTFLAGS -DUSE_DGA"], 
        have_dga_lib=no, -L$x_libraries)

    AC_CHECK_LIB(Xxf86vm, main, [have_vmode_lib=yes; 
        XEXTLIBS="$XEXTLIBS -lXxf86vm"; XEXTFLAGS="$XEXTFLAGS -DUSE_VMODE"], 
        have_vmode_lib=no, -L$x_libraries)

    if test "$have_dga_header" = "yes"; then
       if test "$have_dga_lib" = "yes" ; then
          if test "$have_vmode_header" = "yes" ; then
             if test "$have_vmode_lib" = "yes" ; then
                use_dga_vmode=yes
                XEXTLIBS="$XEXTLIBS -lXext"
             fi
          fi
       fi
    fi
  fi
  AC_SUBST(XEXTLIBS)
  AC_SUBST(XEXTFLAGS)
])

dnl ################################################

AC_DEFUN(GATOS_HASH_CHARS,[
  HASH_CHARS=""
  AC_MSG_CHECKING(enable CHAR HASHING)
  AC_ARG_ENABLE(hash-chars,
    [  --enable-hash-chars     Enable char hashing  (default)
                            consumes more memory in favor of speed],
    [case "$enableval" in
      yes) 
        hash_chars=yes
        AC_MSG_RESULT(yes)
      ;;
      no) 
        hash_chars=no
        AC_MSG_RESULT(no)
      ;;
      *) AC_MSG_ERROR(bad value ${enableval} for hash-chars option) ;;
    esac],[
  AC_MSG_RESULT(yes)
  hash_chars=yes])

  if test "$hash_chars" = "yes"; then
    HASH_CHARS="-DHASH_CHARS"
  fi
  AC_SUBST(HASH_CHARS)
])

dnl ################################################

AC_DEFUN(GATOS_RAW_CC_EDS,[
  RAW_OUTPUT=""
  AC_MSG_CHECKING(output RAW CC)
  AC_ARG_ENABLE(raw-cc,
    [  --enable-raw-cc         Output the raw cc (expect 0)],
    [case "$enableval" in
      yes) 
         raw_cc=yes
         AC_MSG_RESULT(yes)
      ;;
      no)
         raw_cc=no
         AC_MSG_RESULT(no)
      ;;
      *) AC_MSG_ERROR(bad value ${enableval} for raw-cc option) ;;
    esac],[
    AC_MSG_RESULT(no)
    raw_cc=no]) 
    if test "$raw_cc" = "yes"; then
      RAW_OUTPUT="-DCCTEST"
    fi

  AC_MSG_CHECKING(output RAW EDS)
  AC_ARG_ENABLE(raw-eds,
    [  --enable-raw-eds        Output the raw eds (expect 0)],
    [case "$enableval" in
      yes) 
         raw_eds=yes
         AC_MSG_RESULT(yes) 
      ;;
      no) 
         AC_MSG_RESULT(no)
         raw_eds=no 
      ;;
      *) AC_MSG_ERROR(bad value ${enableval} for raw-eds option) ;;
    esac],[
    AC_MSG_RESULT(no)
    raw_eds=no])
    if test "$raw_eds" = "yes"; then
      RAW_OUTPUT="-DCCTEST -DEDSTEST"
    fi

dnl Check if CC and EDS aren't enabled as same time
  if test "$raw_cc" = "yes"; then
    if test "$raw_eds" = "yes"; then
      AC_MSG_ERROR(raw cc or raw eds can't be enabled as same time !)
    fi
  fi

  AC_SUBST(RAW_OUTPUT)
])

dnl ################################################

AC_DEFUN(GATOS_I2C_DELAY,[
  AC_MSG_CHECKING(using DELAY from the Linux/(Free/Net)BSD kernel sources)
  AC_ARG_WITH(kernel-delay,
    [  --with-kernel-delay     Use delay from Linux/(Free/Net)BSD kernel                                         sources (default)
  --without-kernel-delay  Use i2c delay in i2c.c],
    [case "$withval" in
      no)
         AC_MSG_RESULT(no)
         kernel_delay=false
      ;;
      *)
         AC_MSG_RESULT(yes)
         AC_DEFINE(WITH_KERNEL_DELAY)
         kernel_delay=true
      ;;
    esac],[
    AC_MSG_RESULT(yes)
    AC_DEFINE(WITH_KERNEL_DELAY)
    kernel_delay=true])
    AM_CONDITIONAL(WITH_KERNEL_DELAY, test "$kernel_delay" = "true")
])

dnl ################################################

AC_DEFUN(GATOS_SOUND_OSSEMU,[
  AC_MSG_CHECKING(using the OSS sound emulation in NetBSD)
  AC_ARG_WITH(ossemu,
    [  --with-ossemu           Use the OSS sound emulation in NetBSD (default=no)],
    [case "$withval" in
      yes)
	 if test "$ArchRunning" != "x86NetBSD"; then
	   AC_MSG_ERROR(Only available in NetBSD!)
	 else
           AC_MSG_RESULT(yes)
           AC_DEFINE(WITH_OSSEMU)
           netbsd_ossemu=yes
	 fi
      ;;
      *)
         AC_MSG_RESULT(no)
         netbsd_ossemu=no
      ;;
    esac],[
    AC_MSG_RESULT(no)
    netbsd_ossemu=no])
    AM_CONDITIONAL(WITH_OSSEMU, test "$netbsd_ossemu" = "yes")
])

dnl ################################################

AC_DEFUN(GATOS_SHM,[
  AC_MSG_CHECKING(using IPC shared memory)
  AC_ARG_WITH(shm,
    [  --with-shm              Use IPC shared memory support (default=no)],
    [case "$withval" in
      no)
         AC_MSG_RESULT(no)
         shm=no
      ;;
      *)
         AC_MSG_RESULT(yes)
         shm=yes
      ;;
    esac],[
    shm=no
    AC_MSG_RESULT(no)
  ])

if test "$shm" = "yes"; then
  USE_SHM="-DUSE_SHM"
fi 
AC_SUBST(USE_SHM)
])

dnl ################################################

AC_DEFUN(GATOS_IPC,[
  AC_MSG_CHECKING(using IPC messages)
  AC_ARG_WITH(ipc,
    [  --with-ipc              Use IPC messages support (default=no)],
    [case "$withval" in
      no)
         AC_MSG_RESULT(no)
         ipcmsg=no
      ;;
      *)
         AC_MSG_RESULT(yes)
         ipcmsg=yes
      ;;
    esac],[
    ipcmsg=no
    AC_MSG_RESULT(no)
  ])

if test "$ipcmsg" = "yes"; then
  USE_IPC="-DUSE_IPC"
fi 
AC_SUBST(USE_IPC)
])

dnl ################################################
