/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class Base64 {
    private static char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static byte[] codes = new byte[256];

    public static char[] encode(byte[] byArray) {
        char[] cArray = new char[(byArray.length + 2) / 3 * 4];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            boolean bl = false;
            boolean bl2 = false;
            int n3 = 0xFF & byArray[n];
            n3 <<= 8;
            if (n + 1 < byArray.length) {
                n3 |= 0xFF & byArray[n + 1];
                bl2 = true;
            }
            n3 <<= 8;
            if (n + 2 < byArray.length) {
                n3 |= 0xFF & byArray[n + 2];
                bl = true;
            }
            cArray[n2 + 3] = alphabet[bl ? n3 & 0x3F : 64];
            cArray[n2 + 2] = alphabet[bl2 ? (n3 >>= 6) & 0x3F : 64];
            cArray[n2 + 1] = alphabet[(n3 >>= 6) & 0x3F];
            cArray[n2 + 0] = alphabet[(n3 >>= 6) & 0x3F];
            n += 3;
            n2 += 4;
        }
        return cArray;
    }

    public static byte[] decode(char[] cArray) {
        int n = cArray.length;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] > '\u00ff' || codes[cArray[n2]] < 0) {
                --n;
            }
            ++n2;
        }
        int n3 = n / 4 * 3;
        if (n % 4 == 3) {
            n3 += 2;
        }
        if (n % 4 == 2) {
            ++n3;
        }
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < cArray.length) {
            int n8;
            int n9 = n8 = cArray[n7] > '\u00ff' ? -1 : codes[cArray[n7]];
            if (n8 >= 0) {
                n5 <<= 6;
                n5 |= n8;
                if ((n4 += 6) >= 8) {
                    byArray[n6++] = (byte)(n5 >> (n4 -= 8) & 0xFF);
                }
            }
            ++n7;
        }
        if (n6 != byArray.length) {
            throw new Error("Miscalculated data length (wrote " + n6 + " instead of " + byArray.length + ")");
        }
        return byArray;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println("usage:  java Base64 [-d[ecode]] filename");
            System.exit(0);
        }
        int n = 0;
        while (n < stringArray.length) {
            if ("-decode".equalsIgnoreCase(stringArray[n])) {
                bl = true;
            } else if ("-d".equalsIgnoreCase(stringArray[n])) {
                bl = true;
            }
            ++n;
        }
        String string = stringArray[stringArray.length - 1];
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("Error:  file '" + string + "' doesn't exist!");
            System.exit(0);
        }
        if (bl) {
            char[] cArray = Base64.readChars(file);
            byte[] byArray = Base64.decode(cArray);
            Base64.writeBytes(file, byArray);
        } else {
            byte[] byArray = Base64.readBytes(file);
            char[] cArray = Base64.encode(byArray);
            Base64.writeChars(file, cArray);
        }
    }

    private static byte[] readBytes(File file) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            int n = 0;
            byte[] byArray = new byte[16384];
            while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                if (n <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n);
            }
            ((InputStream)bufferedInputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static char[] readChars(File file) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            int n = 0;
            char[] cArray = new char[16384];
            while ((n = bufferedReader.read(cArray)) != -1) {
                if (n <= 0) continue;
                charArrayWriter.write(cArray, 0, n);
            }
            ((Reader)bufferedReader).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return charArrayWriter.toCharArray();
    }

    private static void writeBytes(File file, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            ((OutputStream)bufferedOutputStream).write(byArray);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void writeChars(File file, char[] cArray) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(cArray);
            ((Writer)bufferedWriter).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        int n = 0;
        while (n < 256) {
            Base64.codes[n] = -1;
            ++n;
        }
        int n2 = 65;
        while (n2 <= 90) {
            Base64.codes[n2] = (byte)(n2 - 65);
            ++n2;
        }
        int n3 = 97;
        while (n3 <= 122) {
            Base64.codes[n3] = (byte)(26 + n3 - 97);
            ++n3;
        }
        int n4 = 48;
        while (n4 <= 57) {
            Base64.codes[n4] = (byte)(52 + n4 - 48);
            ++n4;
        }
        Base64.codes[43] = 62;
        Base64.codes[47] = 63;
    }
}

