#include "wu-ftpd.h"

extern char nondet_char();

/* Returns the number of bytes written to buf, or -1 if there's an
   error. This'll do it, assuming buf is initially uninitialized. */
int readlink(const char *path, char *buf, int bufsiz)
{
  int n = nondet_int ();
  if (n < bufsiz && n >= 0)
    return n;
  return -1;
}

/* Havoc everything in buf, then null-terminate it. */
char *getcwd(char *buf, size_t size)
{
  int i;
  if (nondet_int() == 0) {
    return NULL;
  }
  for (i = 0; i < size-1; i++)
    buf[i] = nondet_char();
  buf [size-1] = EOS;
  return buf;
}
