/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file vcard.h
 * \brief Contains vcard information structures and definitions
 */

#ifndef VCARD_H
#define VCARD_H

/** States in parser */
enum {
	STATE_NEW = 0,
	STATE_TAG,
	STATE_OPTIONS,
	STATE_ENTRY
};

struct sCardData {
	gint nState;
	gchar *pnHeader;
	gchar *pnOptions;
	gchar *pnEntry;
};

GString *createUid( void );
void loadCardFile( char *pnFileName );
void writeCardFile( char *pnFileName );

#endif
