/* $Id: cim_parallel.c,v 1.8 2009-01-27 17:06:39 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "cim_parallel.h"

static void
cim_parallel_recv(void *_css, struct sig_parallel_msg *smsg)
{
	struct cim_parallel *css = (struct cim_parallel *) _css;
	struct cim_parallel_msg cmsg;

	cmsg.status = smsg->status;
	cmsg.control = smsg->control;
	cmsg.data = smsg->data;

	cim_send(&css->bridge, &cmsg, sizeof(cmsg));
}

void
cim_parallel_interrupt(void *_css, void *_buf, unsigned int bufsize)
{
	struct cim_parallel *css = (struct cim_parallel *) _css;
	struct cim_parallel_msg *cmsg = (struct cim_parallel_msg *) _buf;
	struct sig_parallel_msg smsg;

	assert(bufsize == sizeof(*cmsg));

	smsg.status = cmsg->status;
	smsg.control = cmsg->control;
	smsg.data = cmsg->data;

	sig_parallel_send(css->sig_parallel, css, &smsg);
}

void
cim_parallel_init(struct cim_parallel *css, struct sig_parallel *sig_parallel)
{
	static const struct sig_parallel_funcs funcs = {
		.recv = cim_parallel_recv,
	};

	cim_connect(&css->bridge, cim_parallel_interrupt, css);

	css->sig_parallel = sig_parallel;
	sig_parallel_connect(sig_parallel, css, &funcs);
}

void
cim_parallel_create(struct cim_parallel *css)
{
	cim_create(&css->bridge);
}

void
cim_parallel_destroy(struct cim_parallel *css)
{
	cim_destroy(&css->bridge);
}
