/* $Id: SyntaxError.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SYNTAX_ERROR_HPP_INCLUDED
#define __SYNTAX_ERROR_HPP_INCLUDED

#include <stdexcept>
#include <string>

namespace yy {

/** A syntax error during parsing. */
class SyntaxError : public std::runtime_error {
public:
	//! dummy c'tor to forward to runtime_error
	/** @param msg error message */
	SyntaxError(const std::string& msg) : runtime_error(msg) {}
};
	
}; /* namespace yy */

#endif /* __SYNTAX_ERROR_HPP_INCLUDED */
