/* $Id: Slice.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SLICE_HPP_INCLUDED
#define __SLICE_HPP_INCLUDED

#include "frontend/ast/Expression.hpp"

namespace ast {

//! slice operation on an array type.
/** array(bound1 [down]to bound2) -> array
 *  Will create a slice of an array from bound1 to or downto bound2.
 *  Returning type is the same array type but with different bounds.
 */
class Slice : public Expression {
public:
	Slice(
		Expression *arrayTypeSource,
		DiscreteRange *dRange,
		Location loc
		) : 	Expression(loc),
			source(arrayTypeSource),
			range(dRange) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor &visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << this->source << '(' << this->range << ')';
	}


	//! source operand.
	Expression *source;
	//! slice range.
	DiscreteRange *range;

protected:
	/** Destructor */
	virtual ~Slice() {
		util::MiscUtil::terminate(source);
		util::MiscUtil::terminate(range);
	}
};

}; /* namespace ast */

#endif /* __SLICE_HPP_INCLUDED */
