!! NOTES
!!  This file has been automatically generated by the config/scripts/autogen_tests.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten. See the template file in config/etsf/template.tests_init.

program tests_init

  use etsf_io_low_level
  use etsf_io
  
  implicit none

  call test_data_init()
  
contains

  subroutine tests_write_status(name, lstat, error)
    character(len = *), intent(in)      :: name
    logical, intent(in)                 :: lstat
    type(etsf_io_low_error), intent(in) :: error
    
    if (lstat) then
      write(*, "(A,A,A,A)") "== ", name, repeat(" ", 68 - len(name)), "OK     =="
    else
      write(*, "(A,A,A,A)") "== ", name, repeat(" ", 68 - len(name)), "Failed =="
      call etsf_io_low_error_handle(error)
    end if
  end subroutine tests_write_status


  subroutine test_data_init()
    type(etsf_dims) :: dims
    integer :: ncid, dimvalue
    type(etsf_groups_flags) :: flags
    type(etsf_io_low_error) :: error
    type(etsf_io_low_var_infos) :: var_infos
    character(len = *), parameter :: me = "test_data_init"
    logical :: lstat

    write(*,*)
    write(*,*) "Testing etsf_io_data_init()..."

    dims%number_of_grid_points_vector3 = 5
    dims%number_of_symmetry_operations = 4
    dims%max_number_of_coefficients = 6
    dims%max_number_of_projectors = 2
    dims%max_number_of_states = 8
    dims%number_of_atoms = 4
    dims%number_of_kpoints = 12
    dims%number_of_components = 2

    flags%geometry = etsf_geometry_all
    call etsf_io_data_init("test_init_geometry.nc", flags, &
                         & dims, "Test", "", lstat, error)
    call tests_write_status("Create file test_init_geometry.nc", lstat, error)
    flags%geometry = etsf_geometry_none
    call etsf_io_low_open_read(ncid, "test_init_geometry.nc", lstat, error_data = error)
    call tests_write_status(" | opening", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "space_group", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'space_group' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_integer .or. &
      & var_infos%ncshape /= 0 .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "space_group", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'space_group' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_vectors", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_vectors'", lstat, error)
    if (dimvalue /= dims%number_of_vectors) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_vectors", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_vectors'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_cartesian_directions", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_cartesian_directions'", lstat, error)
    if (dimvalue /= dims%number_of_cartesian_directions) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_cartesian_directions", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_cartesian_directions'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "primitive_vectors", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'primitive_vectors' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_vectors .or. &
      & var_infos%ncdims(1) /= dims%number_of_cartesian_directions .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "primitive_vectors", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'primitive_vectors' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_symmetry_operations", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_symmetry_operations'", lstat, error)
    if (dimvalue /= dims%number_of_symmetry_operations) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_symmetry_operations", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_symmetry_operations'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_reduced_dimensions", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_reduced_dimensions'", lstat, error)
    if (dimvalue /= dims%number_of_reduced_dimensions) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_reduced_dimensions", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_reduced_dimensions'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_reduced_dimensions", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_reduced_dimensions'", lstat, error)
    if (dimvalue /= dims%number_of_reduced_dimensions) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_reduced_dimensions", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_reduced_dimensions'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "reduced_symmetry_matrices", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'reduced_symmetry_matrices' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_integer .or. &
      & var_infos%ncshape /= 3 .or. &
      & var_infos%ncdims(3) /= dims%number_of_symmetry_operations .or. &
      & var_infos%ncdims(2) /= dims%number_of_reduced_dimensions .or. &
      & var_infos%ncdims(1) /= dims%number_of_reduced_dimensions .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "reduced_symmetry_matrices", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'reduced_symmetry_matrices' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_symmetry_operations", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_symmetry_operations'", lstat, error)
    if (dimvalue /= dims%number_of_symmetry_operations) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_symmetry_operations", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_symmetry_operations'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_reduced_dimensions", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_reduced_dimensions'", lstat, error)
    if (dimvalue /= dims%number_of_reduced_dimensions) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_reduced_dimensions", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_reduced_dimensions'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "reduced_symmetry_translations", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'reduced_symmetry_translations' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_symmetry_operations .or. &
      & var_infos%ncdims(1) /= dims%number_of_reduced_dimensions .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "reduced_symmetry_translations", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'reduced_symmetry_translations' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_atoms", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_atoms'", lstat, error)
    if (dimvalue /= dims%number_of_atoms) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_atoms", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_atoms'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "atom_species", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'atom_species' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_integer .or. &
      & var_infos%ncshape /= 1 .or. &
      & var_infos%ncdims(1) /= dims%number_of_atoms .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "atom_species", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'atom_species' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_atoms", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_atoms'", lstat, error)
    if (dimvalue /= dims%number_of_atoms) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_atoms", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_atoms'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_reduced_dimensions", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_reduced_dimensions'", lstat, error)
    if (dimvalue /= dims%number_of_reduced_dimensions) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_reduced_dimensions", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_reduced_dimensions'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "reduced_atom_positions", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'reduced_atom_positions' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_atoms .or. &
      & var_infos%ncdims(1) /= dims%number_of_reduced_dimensions .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "reduced_atom_positions", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'reduced_atom_positions' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_atom_species", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_atom_species'", lstat, error)
    if (dimvalue /= dims%number_of_atom_species) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_atom_species", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_atom_species'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "valence_charges", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'valence_charges' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 1 .or. &
      & var_infos%ncdims(1) /= dims%number_of_atom_species .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "valence_charges", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'valence_charges' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_atom_species", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_atom_species'", lstat, error)
    if (dimvalue /= dims%number_of_atom_species) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_atom_species", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_atom_species'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "atomic_numbers", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'atomic_numbers' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 1 .or. &
      & var_infos%ncdims(1) /= dims%number_of_atom_species .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "atomic_numbers", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'atomic_numbers' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_atom_species", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_atom_species'", lstat, error)
    if (dimvalue /= dims%number_of_atom_species) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_atom_species", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_atom_species'", lstat, error)
    call etsf_io_low_read_dim(ncid, "character_string_length", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'character_string_length'", lstat, error)
    if (dimvalue /= dims%character_string_length) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "character_string_length", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'character_string_length'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "atom_species_names", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'atom_species_names' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_character .or. &
      & var_infos%ncshape /= 2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_atom_species .or. &
      & var_infos%ncdims(1) /= dims%character_string_length .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "atom_species_names", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'atom_species_names' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_atom_species", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_atom_species'", lstat, error)
    if (dimvalue /= dims%number_of_atom_species) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_atom_species", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_atom_species'", lstat, error)
    call etsf_io_low_read_dim(ncid, "symbol_length", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'symbol_length'", lstat, error)
    if (dimvalue /= dims%symbol_length) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "symbol_length", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'symbol_length'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "chemical_symbols", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'chemical_symbols' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_character .or. &
      & var_infos%ncshape /= 2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_atom_species .or. &
      & var_infos%ncdims(1) /= dims%symbol_length .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "chemical_symbols", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'chemical_symbols' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_atom_species", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_atom_species'", lstat, error)
    if (dimvalue /= dims%number_of_atom_species) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_atom_species", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_atom_species'", lstat, error)
    call etsf_io_low_read_dim(ncid, "character_string_length", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'character_string_length'", lstat, error)
    if (dimvalue /= dims%character_string_length) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "character_string_length", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'character_string_length'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "pseudopotential_types", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'pseudopotential_types' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_character .or. &
      & var_infos%ncshape /= 2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_atom_species .or. &
      & var_infos%ncdims(1) /= dims%character_string_length .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "pseudopotential_types", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'pseudopotential_types' characteristics", lstat, error)
    call etsf_io_low_close(ncid, lstat, error_data = error)
    call tests_write_status(" | closing", lstat, error)
    
        flags%electrons = etsf_electrons_all
    call etsf_io_data_init("test_init_electrons.nc", flags, &
                         & dims, "Test", "", lstat, error)
    call tests_write_status("Create file test_init_electrons.nc", lstat, error)
    flags%electrons = etsf_electrons_none
    call etsf_io_low_open_read(ncid, "test_init_electrons.nc", lstat, error_data = error)
    call tests_write_status(" | opening", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "number_of_electrons", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'number_of_electrons' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_integer .or. &
      & var_infos%ncshape /= 0 .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "number_of_electrons", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'number_of_electrons' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "character_string_length", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'character_string_length'", lstat, error)
    if (dimvalue /= dims%character_string_length) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "character_string_length", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'character_string_length'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "exchange_functional", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'exchange_functional' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_character .or. &
      & var_infos%ncshape /= 1 .or. &
      & var_infos%ncdims(1) /= dims%character_string_length .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "exchange_functional", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'exchange_functional' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "character_string_length", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'character_string_length'", lstat, error)
    if (dimvalue /= dims%character_string_length) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "character_string_length", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'character_string_length'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "correlation_functional", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'correlation_functional' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_character .or. &
      & var_infos%ncshape /= 1 .or. &
      & var_infos%ncdims(1) /= dims%character_string_length .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "correlation_functional", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'correlation_functional' characteristics", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "fermi_energy", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'fermi_energy' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 0 .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "fermi_energy", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'fermi_energy' characteristics", lstat, error)
    call etsf_io_low_check_att(ncid, var_infos%ncid, "units", &
                             & etsf_io_low_character, etsf_charlen, &
                             & lstat, error_data = error)
    call tests_write_status(" | check att 'units'", lstat, error)
    call etsf_io_low_read_dim(ncid, "character_string_length", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'character_string_length'", lstat, error)
    if (dimvalue /= dims%character_string_length) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "character_string_length", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'character_string_length'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "smearing_scheme", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'smearing_scheme' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_character .or. &
      & var_infos%ncshape /= 1 .or. &
      & var_infos%ncdims(1) /= dims%character_string_length .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "smearing_scheme", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'smearing_scheme' characteristics", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "smearing_width", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'smearing_width' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 0 .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "smearing_width", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'smearing_width' characteristics", lstat, error)
    call etsf_io_low_check_att(ncid, var_infos%ncid, "units", &
                             & etsf_io_low_character, etsf_charlen, &
                             & lstat, error_data = error)
    call tests_write_status(" | check att 'units'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_kpoints", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_kpoints'", lstat, error)
    if (dimvalue /= dims%number_of_kpoints) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_kpoints", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_kpoints'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "number_of_states", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'number_of_states' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_integer .or. &
      & var_infos%ncshape /= 2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_spins .or. &
      & var_infos%ncdims(1) /= dims%number_of_kpoints .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "number_of_states", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'number_of_states' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_kpoints", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_kpoints'", lstat, error)
    if (dimvalue /= dims%number_of_kpoints) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_kpoints", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_kpoints'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_states", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_states'", lstat, error)
    if (dimvalue /= dims%max_number_of_states) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_states", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_states'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "eigenvalues", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'eigenvalues' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 3 .or. &
      & var_infos%ncdims(3) /= dims%number_of_spins .or. &
      & var_infos%ncdims(2) /= dims%number_of_kpoints .or. &
      & var_infos%ncdims(1) /= dims%max_number_of_states .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "eigenvalues", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'eigenvalues' characteristics", lstat, error)
    call etsf_io_low_check_att(ncid, var_infos%ncid, "units", &
                             & etsf_io_low_character, etsf_charlen, &
                             & lstat, error_data = error)
    call tests_write_status(" | check att 'units'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_kpoints", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_kpoints'", lstat, error)
    if (dimvalue /= dims%number_of_kpoints) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_kpoints", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_kpoints'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_states", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_states'", lstat, error)
    if (dimvalue /= dims%max_number_of_states) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_states", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_states'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "occupations", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'occupations' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 3 .or. &
      & var_infos%ncdims(3) /= dims%number_of_spins .or. &
      & var_infos%ncdims(2) /= dims%number_of_kpoints .or. &
      & var_infos%ncdims(1) /= dims%max_number_of_states .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "occupations", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'occupations' characteristics", lstat, error)
    call etsf_io_low_close(ncid, lstat, error_data = error)
    call tests_write_status(" | closing", lstat, error)
    
        flags%kpoints = etsf_kpoints_all
    call etsf_io_data_init("test_init_kpoints.nc", flags, &
                         & dims, "Test", "", lstat, error)
    call tests_write_status("Create file test_init_kpoints.nc", lstat, error)
    flags%kpoints = etsf_kpoints_none
    call etsf_io_low_open_read(ncid, "test_init_kpoints.nc", lstat, error_data = error)
    call tests_write_status(" | opening", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_reduced_dimensions", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_reduced_dimensions'", lstat, error)
    if (dimvalue /= dims%number_of_reduced_dimensions) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_reduced_dimensions", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_reduced_dimensions'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "kpoint_grid_shift", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'kpoint_grid_shift' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 1 .or. &
      & var_infos%ncdims(1) /= dims%number_of_reduced_dimensions .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "kpoint_grid_shift", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'kpoint_grid_shift' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_vectors", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_vectors'", lstat, error)
    if (dimvalue /= dims%number_of_vectors) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_vectors", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_vectors'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_reduced_dimensions", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_reduced_dimensions'", lstat, error)
    if (dimvalue /= dims%number_of_reduced_dimensions) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_reduced_dimensions", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_reduced_dimensions'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "kpoint_grid_vectors", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'kpoint_grid_vectors' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_vectors .or. &
      & var_infos%ncdims(1) /= dims%number_of_reduced_dimensions .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "kpoint_grid_vectors", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'kpoint_grid_vectors' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_vectors", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_vectors'", lstat, error)
    if (dimvalue /= dims%number_of_vectors) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_vectors", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_vectors'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "monkhorst_pack_folding", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'monkhorst_pack_folding' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_integer .or. &
      & var_infos%ncshape /= 1 .or. &
      & var_infos%ncdims(1) /= dims%number_of_vectors .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "monkhorst_pack_folding", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'monkhorst_pack_folding' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_kpoints", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_kpoints'", lstat, error)
    if (dimvalue /= dims%number_of_kpoints) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_kpoints", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_kpoints'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_reduced_dimensions", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_reduced_dimensions'", lstat, error)
    if (dimvalue /= dims%number_of_reduced_dimensions) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_reduced_dimensions", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_reduced_dimensions'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "reduced_coordinates_of_kpoints", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'reduced_coordinates_of_kpoints' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_kpoints .or. &
      & var_infos%ncdims(1) /= dims%number_of_reduced_dimensions .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "reduced_coordinates_of_kpoints", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'reduced_coordinates_of_kpoints' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_kpoints", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_kpoints'", lstat, error)
    if (dimvalue /= dims%number_of_kpoints) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_kpoints", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_kpoints'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "kpoint_weights", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'kpoint_weights' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 1 .or. &
      & var_infos%ncdims(1) /= dims%number_of_kpoints .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "kpoint_weights", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'kpoint_weights' characteristics", lstat, error)
    call etsf_io_low_close(ncid, lstat, error_data = error)
    call tests_write_status(" | closing", lstat, error)
    
        flags%basisdata = etsf_basisdata_all
    call etsf_io_data_init("test_init_basisdata.nc", flags, &
                         & dims, "Test", "", lstat, error)
    call tests_write_status("Create file test_init_basisdata.nc", lstat, error)
    flags%basisdata = etsf_basisdata_none
    call etsf_io_low_open_read(ncid, "test_init_basisdata.nc", lstat, error_data = error)
    call tests_write_status(" | opening", lstat, error)
    call etsf_io_low_read_dim(ncid, "character_string_length", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'character_string_length'", lstat, error)
    if (dimvalue /= dims%character_string_length) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "character_string_length", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'character_string_length'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "basis_set", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'basis_set' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_character .or. &
      & var_infos%ncshape /= 1 .or. &
      & var_infos%ncdims(1) /= dims%character_string_length .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "basis_set", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'basis_set' characteristics", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "kinetic_energy_cutoff", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'kinetic_energy_cutoff' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 0 .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "kinetic_energy_cutoff", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'kinetic_energy_cutoff' characteristics", lstat, error)
    call etsf_io_low_check_att(ncid, var_infos%ncid, "units", &
                             & etsf_io_low_character, etsf_charlen, &
                             & lstat, error_data = error)
    call tests_write_status(" | check att 'units'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_kpoints", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_kpoints'", lstat, error)
    if (dimvalue /= dims%number_of_kpoints) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_kpoints", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_kpoints'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "number_of_coefficients", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'number_of_coefficients' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_integer .or. &
      & var_infos%ncshape /= 1 .or. &
      & var_infos%ncdims(1) /= dims%number_of_kpoints .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "number_of_coefficients", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'number_of_coefficients' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_kpoints", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_kpoints'", lstat, error)
    if (dimvalue /= dims%number_of_kpoints) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_kpoints", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_kpoints'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_coefficients", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_coefficients'", lstat, error)
    if (dimvalue /= dims%max_number_of_coefficients) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_coefficients", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_coefficients'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_reduced_dimensions", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_reduced_dimensions'", lstat, error)
    if (dimvalue /= dims%number_of_reduced_dimensions) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_reduced_dimensions", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_reduced_dimensions'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "reduced_coordinates_of_plane_waves", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'reduced_coordinates_of_plane_waves' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_integer .or. &
      & var_infos%ncshape /= 3 .or. &
      & var_infos%ncdims(3) /= dims%number_of_kpoints .or. &
      & var_infos%ncdims(2) /= dims%max_number_of_coefficients .or. &
      & var_infos%ncdims(1) /= dims%number_of_reduced_dimensions .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "reduced_coordinates_of_plane_waves", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'reduced_coordinates_of_plane_waves' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_localization_regions", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_localization_regions'", lstat, error)
    if (dimvalue /= dims%number_of_localization_regions) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_localization_regions", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_localization_regions'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_basis_grid_points", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_basis_grid_points'", lstat, error)
    if (dimvalue /= dims%max_number_of_basis_grid_points) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_basis_grid_points", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_basis_grid_points'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_reduced_dimensions", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_reduced_dimensions'", lstat, error)
    if (dimvalue /= dims%number_of_reduced_dimensions) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_reduced_dimensions", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_reduced_dimensions'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "coordinates_of_basis_grid_points", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'coordinates_of_basis_grid_points' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_integer .or. &
      & var_infos%ncshape /= 3 .or. &
      & var_infos%ncdims(3) /= dims%number_of_localization_regions .or. &
      & var_infos%ncdims(2) /= dims%max_number_of_basis_grid_points .or. &
      & var_infos%ncdims(1) /= dims%number_of_reduced_dimensions .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "coordinates_of_basis_grid_points", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'coordinates_of_basis_grid_points' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_localization_regions", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_localization_regions'", lstat, error)
    if (dimvalue /= dims%number_of_localization_regions) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_localization_regions", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_localization_regions'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_basis_grid_points", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_basis_grid_points'", lstat, error)
    if (dimvalue /= dims%max_number_of_basis_grid_points) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_basis_grid_points", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_basis_grid_points'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "number_of_coefficients_per_grid_point", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'number_of_coefficients_per_grid_point' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_integer .or. &
      & var_infos%ncshape /= 2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_localization_regions .or. &
      & var_infos%ncdims(1) /= dims%max_number_of_basis_grid_points .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "number_of_coefficients_per_grid_point", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'number_of_coefficients_per_grid_point' characteristics", lstat, error)
    call etsf_io_low_close(ncid, lstat, error_data = error)
    call tests_write_status(" | closing", lstat, error)
    
        flags%gwdata = etsf_gwdata_all
    call etsf_io_data_init("test_init_gwdata.nc", flags, &
                         & dims, "Test", "", lstat, error)
    call tests_write_status("Create file test_init_gwdata.nc", lstat, error)
    flags%gwdata = etsf_gwdata_none
    call etsf_io_low_open_read(ncid, "test_init_gwdata.nc", lstat, error_data = error)
    call tests_write_status(" | opening", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_kpoints", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_kpoints'", lstat, error)
    if (dimvalue /= dims%number_of_kpoints) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_kpoints", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_kpoints'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_states", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_states'", lstat, error)
    if (dimvalue /= dims%max_number_of_states) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_states", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_states'", lstat, error)
    call etsf_io_low_read_dim(ncid, "real_or_complex_gw_corrections", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'real_or_complex_gw_corrections'", lstat, error)
    if (dimvalue /= dims%real_or_complex_gw_corrections) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "real_or_complex_gw_corrections", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'real_or_complex_gw_corrections'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "gw_corrections", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'gw_corrections' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 4 .or. &
      & var_infos%ncdims(4) /= dims%number_of_spins .or. &
      & var_infos%ncdims(3) /= dims%number_of_kpoints .or. &
      & var_infos%ncdims(2) /= dims%max_number_of_states .or. &
      & var_infos%ncdims(1) /= dims%real_or_complex_gw_corrections .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "gw_corrections", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'gw_corrections' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_atom_species", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_atom_species'", lstat, error)
    if (dimvalue /= dims%number_of_atom_species) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_atom_species", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_atom_species'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_angular_momenta", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_angular_momenta'", lstat, error)
    if (dimvalue /= dims%max_number_of_angular_momenta) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_angular_momenta", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_angular_momenta'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_projectors", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_projectors'", lstat, error)
    if (dimvalue /= dims%max_number_of_projectors) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_projectors", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_projectors'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "kb_formfactor_sign", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'kb_formfactor_sign' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_integer .or. &
      & var_infos%ncshape /= 3 .or. &
      & var_infos%ncdims(3) /= dims%number_of_atom_species .or. &
      & var_infos%ncdims(2) /= dims%max_number_of_angular_momenta .or. &
      & var_infos%ncdims(1) /= dims%max_number_of_projectors .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "kb_formfactor_sign", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'kb_formfactor_sign' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_atom_species", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_atom_species'", lstat, error)
    if (dimvalue /= dims%number_of_atom_species) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_atom_species", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_atom_species'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_angular_momenta", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_angular_momenta'", lstat, error)
    if (dimvalue /= dims%max_number_of_angular_momenta) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_angular_momenta", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_angular_momenta'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_projectors", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_projectors'", lstat, error)
    if (dimvalue /= dims%max_number_of_projectors) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_projectors", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_projectors'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_kpoints", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_kpoints'", lstat, error)
    if (dimvalue /= dims%number_of_kpoints) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_kpoints", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_kpoints'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_coefficients", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_coefficients'", lstat, error)
    if (dimvalue /= dims%max_number_of_coefficients) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_coefficients", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_coefficients'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "kb_formfactors", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'kb_formfactors' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 5 .or. &
      & var_infos%ncdims(5) /= dims%number_of_atom_species .or. &
      & var_infos%ncdims(4) /= dims%max_number_of_angular_momenta .or. &
      & var_infos%ncdims(3) /= dims%max_number_of_projectors .or. &
      & var_infos%ncdims(2) /= dims%number_of_kpoints .or. &
      & var_infos%ncdims(1) /= dims%max_number_of_coefficients .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "kb_formfactors", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'kb_formfactors' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_atom_species", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_atom_species'", lstat, error)
    if (dimvalue /= dims%number_of_atom_species) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_atom_species", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_atom_species'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_angular_momenta", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_angular_momenta'", lstat, error)
    if (dimvalue /= dims%max_number_of_angular_momenta) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_angular_momenta", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_angular_momenta'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_projectors", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_projectors'", lstat, error)
    if (dimvalue /= dims%max_number_of_projectors) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_projectors", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_projectors'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_kpoints", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_kpoints'", lstat, error)
    if (dimvalue /= dims%number_of_kpoints) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_kpoints", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_kpoints'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_coefficients", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_coefficients'", lstat, error)
    if (dimvalue /= dims%max_number_of_coefficients) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_coefficients", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_coefficients'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "kb_formfactor_derivative", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'kb_formfactor_derivative' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 5 .or. &
      & var_infos%ncdims(5) /= dims%number_of_atom_species .or. &
      & var_infos%ncdims(4) /= dims%max_number_of_angular_momenta .or. &
      & var_infos%ncdims(3) /= dims%max_number_of_projectors .or. &
      & var_infos%ncdims(2) /= dims%number_of_kpoints .or. &
      & var_infos%ncdims(1) /= dims%max_number_of_coefficients .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "kb_formfactor_derivative", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'kb_formfactor_derivative' characteristics", lstat, error)
    call etsf_io_low_close(ncid, lstat, error_data = error)
    call tests_write_status(" | closing", lstat, error)
    
        flags%dielectric = etsf_dielectric_all
    call etsf_io_data_init("test_init_dielectric.nc", flags, &
                         & dims, "Test", "", lstat, error)
    call tests_write_status("Create file test_init_dielectric.nc", lstat, error)
    flags%dielectric = etsf_dielectric_none
    call etsf_io_low_open_read(ncid, "test_init_dielectric.nc", lstat, error_data = error)
    call tests_write_status(" | opening", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "frequencies_dielectric_function", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'frequencies_dielectric_function' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "frequencies_dielectric_function", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'frequencies_dielectric_function' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_reduced_dimensions", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_reduced_dimensions'", lstat, error)
    if (dimvalue /= dims%number_of_reduced_dimensions) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_reduced_dimensions", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_reduced_dimensions'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "qpoints_dielectric_function", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'qpoints_dielectric_function' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_qpoints_dielectric_function .or. &
      & var_infos%ncdims(1) /= dims%number_of_reduced_dimensions .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "qpoints_dielectric_function", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'qpoints_dielectric_function' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_gamma_limit", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_gamma_limit'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_gamma_limit) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_gamma_limit", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_gamma_limit'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_reduced_dimensions", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_reduced_dimensions'", lstat, error)
    if (dimvalue /= dims%number_of_reduced_dimensions) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_reduced_dimensions", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_reduced_dimensions'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "qpoints_gamma_limit", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'qpoints_gamma_limit' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_qpoints_gamma_limit .or. &
      & var_infos%ncdims(1) /= dims%number_of_reduced_dimensions .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "qpoints_gamma_limit", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'qpoints_gamma_limit' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "dielectric_function", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'dielectric_function' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 7 .or. &
      & var_infos%ncdims(7) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(6) /= dims%number_of_qpoints_dielectric_function .or. &
      & var_infos%ncdims(5) /= dims%number_of_spins .or. &
      & var_infos%ncdims(4) /= dims%number_of_spins .or. &
      & var_infos%ncdims(3) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(2) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "dielectric_function", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'dielectric_function' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "dielectric_function_head", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'dielectric_function_head' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 5 .or. &
      & var_infos%ncdims(5) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(4) /= dims%number_of_qpoints_dielectric_function .or. &
      & var_infos%ncdims(3) /= dims%number_of_spins .or. &
      & var_infos%ncdims(2) /= dims%number_of_spins .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "dielectric_function_head", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'dielectric_function_head' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_gamma_limit", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_gamma_limit'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_gamma_limit) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_gamma_limit", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_gamma_limit'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "dielectric_function_lower_wing", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'dielectric_function_lower_wing' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 6 .or. &
      & var_infos%ncdims(6) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(5) /= dims%number_of_qpoints_gamma_limit .or. &
      & var_infos%ncdims(4) /= dims%number_of_spins .or. &
      & var_infos%ncdims(3) /= dims%number_of_spins .or. &
      & var_infos%ncdims(2) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "dielectric_function_lower_wing", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'dielectric_function_lower_wing' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_gamma_limit", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_gamma_limit'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_gamma_limit) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_gamma_limit", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_gamma_limit'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "dielectric_function_upper_wing", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'dielectric_function_upper_wing' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 6 .or. &
      & var_infos%ncdims(6) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(5) /= dims%number_of_qpoints_gamma_limit .or. &
      & var_infos%ncdims(4) /= dims%number_of_spins .or. &
      & var_infos%ncdims(3) /= dims%number_of_spins .or. &
      & var_infos%ncdims(2) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "dielectric_function_upper_wing", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'dielectric_function_upper_wing' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "inverse_dielectric_function", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'inverse_dielectric_function' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 7 .or. &
      & var_infos%ncdims(7) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(6) /= dims%number_of_qpoints_dielectric_function .or. &
      & var_infos%ncdims(5) /= dims%number_of_spins .or. &
      & var_infos%ncdims(4) /= dims%number_of_spins .or. &
      & var_infos%ncdims(3) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(2) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "inverse_dielectric_function", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'inverse_dielectric_function' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "inverse_dielectric_function_head", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'inverse_dielectric_function_head' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 5 .or. &
      & var_infos%ncdims(5) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(4) /= dims%number_of_qpoints_dielectric_function .or. &
      & var_infos%ncdims(3) /= dims%number_of_spins .or. &
      & var_infos%ncdims(2) /= dims%number_of_spins .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "inverse_dielectric_function_head", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'inverse_dielectric_function_head' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_gamma_limit", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_gamma_limit'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_gamma_limit) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_gamma_limit", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_gamma_limit'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "inverse_dielectric_function_lower_wing", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'inverse_dielectric_function_lower_wing' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 6 .or. &
      & var_infos%ncdims(6) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(5) /= dims%number_of_qpoints_gamma_limit .or. &
      & var_infos%ncdims(4) /= dims%number_of_spins .or. &
      & var_infos%ncdims(3) /= dims%number_of_spins .or. &
      & var_infos%ncdims(2) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "inverse_dielectric_function_lower_wing", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'inverse_dielectric_function_lower_wing' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_gamma_limit", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_gamma_limit'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_gamma_limit) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_gamma_limit", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_gamma_limit'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "inverse_dielectric_function_upper_wing", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'inverse_dielectric_function_upper_wing' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 6 .or. &
      & var_infos%ncdims(6) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(5) /= dims%number_of_qpoints_gamma_limit .or. &
      & var_infos%ncdims(4) /= dims%number_of_spins .or. &
      & var_infos%ncdims(3) /= dims%number_of_spins .or. &
      & var_infos%ncdims(2) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "inverse_dielectric_function_upper_wing", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'inverse_dielectric_function_upper_wing' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "polarizability", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'polarizability' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 7 .or. &
      & var_infos%ncdims(7) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(6) /= dims%number_of_qpoints_dielectric_function .or. &
      & var_infos%ncdims(5) /= dims%number_of_spins .or. &
      & var_infos%ncdims(4) /= dims%number_of_spins .or. &
      & var_infos%ncdims(3) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(2) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "polarizability", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'polarizability' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "polarizability_head", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'polarizability_head' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 5 .or. &
      & var_infos%ncdims(5) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(4) /= dims%number_of_qpoints_dielectric_function .or. &
      & var_infos%ncdims(3) /= dims%number_of_spins .or. &
      & var_infos%ncdims(2) /= dims%number_of_spins .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "polarizability_head", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'polarizability_head' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_gamma_limit", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_gamma_limit'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_gamma_limit) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_gamma_limit", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_gamma_limit'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "polarizability_lower_wing", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'polarizability_lower_wing' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 6 .or. &
      & var_infos%ncdims(6) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(5) /= dims%number_of_qpoints_gamma_limit .or. &
      & var_infos%ncdims(4) /= dims%number_of_spins .or. &
      & var_infos%ncdims(3) /= dims%number_of_spins .or. &
      & var_infos%ncdims(2) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "polarizability_lower_wing", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'polarizability_lower_wing' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_gamma_limit", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_gamma_limit'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_gamma_limit) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_gamma_limit", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_gamma_limit'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "polarizability_upper_wing", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'polarizability_upper_wing' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 6 .or. &
      & var_infos%ncdims(6) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(5) /= dims%number_of_qpoints_gamma_limit .or. &
      & var_infos%ncdims(4) /= dims%number_of_spins .or. &
      & var_infos%ncdims(3) /= dims%number_of_spins .or. &
      & var_infos%ncdims(2) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "polarizability_upper_wing", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'polarizability_upper_wing' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "inverse_polarizability", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'inverse_polarizability' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 7 .or. &
      & var_infos%ncdims(7) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(6) /= dims%number_of_qpoints_dielectric_function .or. &
      & var_infos%ncdims(5) /= dims%number_of_spins .or. &
      & var_infos%ncdims(4) /= dims%number_of_spins .or. &
      & var_infos%ncdims(3) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(2) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "inverse_polarizability", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'inverse_polarizability' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "inverse_polarizability_head", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'inverse_polarizability_head' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 5 .or. &
      & var_infos%ncdims(5) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(4) /= dims%number_of_qpoints_dielectric_function .or. &
      & var_infos%ncdims(3) /= dims%number_of_spins .or. &
      & var_infos%ncdims(2) /= dims%number_of_spins .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "inverse_polarizability_head", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'inverse_polarizability_head' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_gamma_limit", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_gamma_limit'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_gamma_limit) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_gamma_limit", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_gamma_limit'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "inverse_polarizability_lower_wing", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'inverse_polarizability_lower_wing' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 6 .or. &
      & var_infos%ncdims(6) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(5) /= dims%number_of_qpoints_gamma_limit .or. &
      & var_infos%ncdims(4) /= dims%number_of_spins .or. &
      & var_infos%ncdims(3) /= dims%number_of_spins .or. &
      & var_infos%ncdims(2) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "inverse_polarizability_lower_wing", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'inverse_polarizability_lower_wing' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_frequencies_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_frequencies_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_frequencies_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_frequencies_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_frequencies_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_qpoints_gamma_limit", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_qpoints_gamma_limit'", lstat, error)
    if (dimvalue /= dims%number_of_qpoints_gamma_limit) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_qpoints_gamma_limit", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_qpoints_gamma_limit'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_coefficients_dielectric_function", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_coefficients_dielectric_function'", lstat, error)
    if (dimvalue /= dims%number_of_coefficients_dielectric_function) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_coefficients_dielectric_function", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_coefficients_dielectric_function'", lstat, error)
    call etsf_io_low_read_dim(ncid, "complex", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'complex'", lstat, error)
    if (dimvalue /= dims%complex) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "complex", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'complex'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "inverse_polarizability_upper_wing", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'inverse_polarizability_upper_wing' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 6 .or. &
      & var_infos%ncdims(6) /= dims%number_of_frequencies_dielectric_function .or. &
      & var_infos%ncdims(5) /= dims%number_of_qpoints_gamma_limit .or. &
      & var_infos%ncdims(4) /= dims%number_of_spins .or. &
      & var_infos%ncdims(3) /= dims%number_of_spins .or. &
      & var_infos%ncdims(2) /= dims%number_of_coefficients_dielectric_function .or. &
      & var_infos%ncdims(1) /= dims%complex .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "inverse_polarizability_upper_wing", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'inverse_polarizability_upper_wing' characteristics", lstat, error)
    call etsf_io_low_close(ncid, lstat, error_data = error)
    call tests_write_status(" | closing", lstat, error)
    
        flags%main = etsf_main_all
    call etsf_io_data_init("test_init_main.nc", flags, &
                         & dims, "Test", "", lstat, error)
    call tests_write_status("Create file test_init_main.nc", lstat, error)
    flags%main = etsf_main_none
    call etsf_io_low_open_read(ncid, "test_init_main.nc", lstat, error_data = error)
    call tests_write_status(" | opening", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_components", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_components'", lstat, error)
    if (dimvalue /= dims%number_of_components) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_components", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_components'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_grid_points_vector3", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_grid_points_vector3'", lstat, error)
    if (dimvalue /= dims%number_of_grid_points_vector3) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_grid_points_vector3", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_grid_points_vector3'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_grid_points_vector2", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_grid_points_vector2'", lstat, error)
    if (dimvalue /= dims%number_of_grid_points_vector2) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_grid_points_vector2", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_grid_points_vector2'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_grid_points_vector1", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_grid_points_vector1'", lstat, error)
    if (dimvalue /= dims%number_of_grid_points_vector1) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_grid_points_vector1", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_grid_points_vector1'", lstat, error)
    call etsf_io_low_read_dim(ncid, "real_or_complex_density", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'real_or_complex_density'", lstat, error)
    if (dimvalue /= dims%real_or_complex_density) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "real_or_complex_density", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'real_or_complex_density'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "density", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'density' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 5 .or. &
      & var_infos%ncdims(5) /= dims%number_of_components .or. &
      & var_infos%ncdims(4) /= dims%number_of_grid_points_vector3 .or. &
      & var_infos%ncdims(3) /= dims%number_of_grid_points_vector2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_grid_points_vector1 .or. &
      & var_infos%ncdims(1) /= dims%real_or_complex_density .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "density", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'density' characteristics", lstat, error)
    call etsf_io_low_check_att(ncid, var_infos%ncid, "units", &
                             & etsf_io_low_character, etsf_charlen, &
                             & lstat, error_data = error)
    call tests_write_status(" | check att 'units'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_components", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_components'", lstat, error)
    if (dimvalue /= dims%number_of_components) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_components", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_components'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_grid_points_vector3", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_grid_points_vector3'", lstat, error)
    if (dimvalue /= dims%number_of_grid_points_vector3) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_grid_points_vector3", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_grid_points_vector3'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_grid_points_vector2", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_grid_points_vector2'", lstat, error)
    if (dimvalue /= dims%number_of_grid_points_vector2) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_grid_points_vector2", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_grid_points_vector2'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_grid_points_vector1", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_grid_points_vector1'", lstat, error)
    if (dimvalue /= dims%number_of_grid_points_vector1) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_grid_points_vector1", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_grid_points_vector1'", lstat, error)
    call etsf_io_low_read_dim(ncid, "real_or_complex_potential", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'real_or_complex_potential'", lstat, error)
    if (dimvalue /= dims%real_or_complex_potential) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "real_or_complex_potential", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'real_or_complex_potential'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "exchange_potential", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'exchange_potential' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 5 .or. &
      & var_infos%ncdims(5) /= dims%number_of_components .or. &
      & var_infos%ncdims(4) /= dims%number_of_grid_points_vector3 .or. &
      & var_infos%ncdims(3) /= dims%number_of_grid_points_vector2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_grid_points_vector1 .or. &
      & var_infos%ncdims(1) /= dims%real_or_complex_potential .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "exchange_potential", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'exchange_potential' characteristics", lstat, error)
    call etsf_io_low_check_att(ncid, var_infos%ncid, "units", &
                             & etsf_io_low_character, etsf_charlen, &
                             & lstat, error_data = error)
    call tests_write_status(" | check att 'units'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_components", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_components'", lstat, error)
    if (dimvalue /= dims%number_of_components) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_components", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_components'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_grid_points_vector3", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_grid_points_vector3'", lstat, error)
    if (dimvalue /= dims%number_of_grid_points_vector3) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_grid_points_vector3", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_grid_points_vector3'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_grid_points_vector2", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_grid_points_vector2'", lstat, error)
    if (dimvalue /= dims%number_of_grid_points_vector2) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_grid_points_vector2", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_grid_points_vector2'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_grid_points_vector1", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_grid_points_vector1'", lstat, error)
    if (dimvalue /= dims%number_of_grid_points_vector1) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_grid_points_vector1", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_grid_points_vector1'", lstat, error)
    call etsf_io_low_read_dim(ncid, "real_or_complex_potential", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'real_or_complex_potential'", lstat, error)
    if (dimvalue /= dims%real_or_complex_potential) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "real_or_complex_potential", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'real_or_complex_potential'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "correlation_potential", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'correlation_potential' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 5 .or. &
      & var_infos%ncdims(5) /= dims%number_of_components .or. &
      & var_infos%ncdims(4) /= dims%number_of_grid_points_vector3 .or. &
      & var_infos%ncdims(3) /= dims%number_of_grid_points_vector2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_grid_points_vector1 .or. &
      & var_infos%ncdims(1) /= dims%real_or_complex_potential .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "correlation_potential", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'correlation_potential' characteristics", lstat, error)
    call etsf_io_low_check_att(ncid, var_infos%ncid, "units", &
                             & etsf_io_low_character, etsf_charlen, &
                             & lstat, error_data = error)
    call tests_write_status(" | check att 'units'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_components", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_components'", lstat, error)
    if (dimvalue /= dims%number_of_components) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_components", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_components'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_grid_points_vector3", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_grid_points_vector3'", lstat, error)
    if (dimvalue /= dims%number_of_grid_points_vector3) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_grid_points_vector3", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_grid_points_vector3'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_grid_points_vector2", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_grid_points_vector2'", lstat, error)
    if (dimvalue /= dims%number_of_grid_points_vector2) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_grid_points_vector2", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_grid_points_vector2'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_grid_points_vector1", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_grid_points_vector1'", lstat, error)
    if (dimvalue /= dims%number_of_grid_points_vector1) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_grid_points_vector1", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_grid_points_vector1'", lstat, error)
    call etsf_io_low_read_dim(ncid, "real_or_complex_potential", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'real_or_complex_potential'", lstat, error)
    if (dimvalue /= dims%real_or_complex_potential) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "real_or_complex_potential", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'real_or_complex_potential'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "exchange_correlation_potential", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'exchange_correlation_potential' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 5 .or. &
      & var_infos%ncdims(5) /= dims%number_of_components .or. &
      & var_infos%ncdims(4) /= dims%number_of_grid_points_vector3 .or. &
      & var_infos%ncdims(3) /= dims%number_of_grid_points_vector2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_grid_points_vector1 .or. &
      & var_infos%ncdims(1) /= dims%real_or_complex_potential .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "exchange_correlation_potential", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'exchange_correlation_potential' characteristics", lstat, error)
    call etsf_io_low_check_att(ncid, var_infos%ncid, "units", &
                             & etsf_io_low_character, etsf_charlen, &
                             & lstat, error_data = error)
    call tests_write_status(" | check att 'units'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_kpoints", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_kpoints'", lstat, error)
    if (dimvalue /= dims%number_of_kpoints) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_kpoints", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_kpoints'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_states", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_states'", lstat, error)
    if (dimvalue /= dims%max_number_of_states) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_states", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_states'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spinor_components", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spinor_components'", lstat, error)
    if (dimvalue /= dims%number_of_spinor_components) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spinor_components", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spinor_components'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_coefficients", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_coefficients'", lstat, error)
    if (dimvalue /= dims%max_number_of_coefficients) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_coefficients", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_coefficients'", lstat, error)
    call etsf_io_low_read_dim(ncid, "real_or_complex_coefficients", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'real_or_complex_coefficients'", lstat, error)
    if (dimvalue /= dims%real_or_complex_coefficients) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "real_or_complex_coefficients", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'real_or_complex_coefficients'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "coefficients_of_wavefunctions", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'coefficients_of_wavefunctions' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 6 .or. &
      & var_infos%ncdims(6) /= dims%number_of_spins .or. &
      & var_infos%ncdims(5) /= dims%number_of_kpoints .or. &
      & var_infos%ncdims(4) /= dims%max_number_of_states .or. &
      & var_infos%ncdims(3) /= dims%number_of_spinor_components .or. &
      & var_infos%ncdims(2) /= dims%max_number_of_coefficients .or. &
      & var_infos%ncdims(1) /= dims%real_or_complex_coefficients .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "coefficients_of_wavefunctions", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'coefficients_of_wavefunctions' characteristics", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spins", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spins'", lstat, error)
    if (dimvalue /= dims%number_of_spins) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spins", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spins'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_kpoints", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_kpoints'", lstat, error)
    if (dimvalue /= dims%number_of_kpoints) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_kpoints", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_kpoints'", lstat, error)
    call etsf_io_low_read_dim(ncid, "max_number_of_states", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'max_number_of_states'", lstat, error)
    if (dimvalue /= dims%max_number_of_states) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "max_number_of_states", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'max_number_of_states'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_spinor_components", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_spinor_components'", lstat, error)
    if (dimvalue /= dims%number_of_spinor_components) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_spinor_components", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_spinor_components'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_grid_points_vector3", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_grid_points_vector3'", lstat, error)
    if (dimvalue /= dims%number_of_grid_points_vector3) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_grid_points_vector3", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_grid_points_vector3'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_grid_points_vector2", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_grid_points_vector2'", lstat, error)
    if (dimvalue /= dims%number_of_grid_points_vector2) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_grid_points_vector2", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_grid_points_vector2'", lstat, error)
    call etsf_io_low_read_dim(ncid, "number_of_grid_points_vector1", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'number_of_grid_points_vector1'", lstat, error)
    if (dimvalue /= dims%number_of_grid_points_vector1) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "number_of_grid_points_vector1", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'number_of_grid_points_vector1'", lstat, error)
    call etsf_io_low_read_dim(ncid, "real_or_complex_wavefunctions", dimvalue, lstat, error_data = error)
    call tests_write_status(" | read dim 'real_or_complex_wavefunctions'", lstat, error)
    if (dimvalue /= dims%real_or_complex_wavefunctions) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_DIM, me, &
                               & tgtname = "real_or_complex_wavefunctions", errmess = "Wrong value")
      lstat = .false.
    end if
    call tests_write_status(" | check dim value 'real_or_complex_wavefunctions'", lstat, error)
    call etsf_io_low_read_var_infos(ncid, "real_space_wavefunctions", var_infos, lstat, error_data = error)
    call tests_write_status(" | read var 'real_space_wavefunctions' characteristics", lstat, error)
    if (var_infos%nctype /= etsf_io_low_double .or. &
      & var_infos%ncshape /= 8 .or. &
      & var_infos%ncdims(8) /= dims%number_of_spins .or. &
      & var_infos%ncdims(7) /= dims%number_of_kpoints .or. &
      & var_infos%ncdims(6) /= dims%max_number_of_states .or. &
      & var_infos%ncdims(5) /= dims%number_of_spinor_components .or. &
      & var_infos%ncdims(4) /= dims%number_of_grid_points_vector3 .or. &
      & var_infos%ncdims(3) /= dims%number_of_grid_points_vector2 .or. &
      & var_infos%ncdims(2) /= dims%number_of_grid_points_vector1 .or. &
      & var_infos%ncdims(1) /= dims%real_or_complex_wavefunctions .or. &
      & .false. ) then
      call etsf_io_low_error_set(error, ERROR_MODE_SPEC, ERROR_TYPE_VAR, me, &
                               & tgtname = "real_space_wavefunctions", errmess = "Wrong characteristic")
      lstat = .false.
    end if
    call tests_write_status(" | check var 'real_space_wavefunctions' characteristics", lstat, error)
    call etsf_io_low_close(ncid, lstat, error_data = error)
    call tests_write_status(" | closing", lstat, error)
    
    

    write(*,*)

  end subroutine test_data_init

end program tests_init
