C Copyright 1981-2012 ECMWF.
C
C This software is licensed under the terms of the Apache Licence 
C Version 2.0 which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
C
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation 
C nor does it submit to any jurisdiction.
C

      INTEGER FUNCTION HSP2GG2(KTRUNC,NS,EW,KGAUSS,KPTS,PLATS,KSIZE)
C
C---->
C**** HSP2GG2
C
C     Purpose
C     -------
C
C     This routine finds a suitable gaussian grid for a given
C     spectral truncation.
C
C
C     Interface
C     ---------
C
C     IRET = HSP2GG2(KTRUNC,KGAUSS,KPTS,KSIZE)
C
C
C     Input parameters
C     ----------------
C
C     KTRUNC - The spectral truncation
C
C
C     Output parameters
C     -----------------
C
C     KGAUSS - The gaussian number
C     KPTS   - Array giving number of points along each line of latitude
C              in the reduced gaussian grid (both hemispheres)
C     PLATS  - Array giving gaussian latitudes (both hemispheres)
C     KSIZE  - The number of points in the reduced gaussian grid
C
C     Returns 0 if all OK, otherwise there is an error.
C
C
C     Common block usage
C     ------------------
C
C     None
C
C
C     Method
C     ------
C
C     None
C
C
C     Externals
C     ---------
C
C     JGETGG - Reads the definition of a gaussian grid
C
C
C     Reference
C     ---------
C
C     None.
C
C
C     Comments
C     --------
C
C     None.
C
C
C     Author
C     ------
C
C     J.D.Chambers      ECMWF      February 2001
C
C
C     Modifications
C     -------------
C
C     S.Curic     ECMWF      March 2005
C     Added checking for a automatic trancation T255, T399, T799, T2047 
C     and corresponding gaussian grid.
C
C     S.Curic     ECMWF      April 2008
C     Added checking for a automatic trancation T1279
C     and corresponding gaussian grid.
C
C
C     S.Curic     ECMWF      Semptember 2009
C     Match T255 and T213 against N128 instead of N160
C     upon Alan Geer request
C
C----<
C     -----------------------------------------------------------------|
C*    Section 0. Definition of variables.
C     -----------------------------------------------------------------|
C
      IMPLICIT NONE
C
#include "parim.h"
C
C     Function arguments
C
      INTEGER KTRUNC, KGAUSS, KPTS(*), KSIZE
      REAL NS, EW, STEP
      REAL PLATS(*)
#include "jparams.h"
C
C     Local variables
C
      INTEGER LOOP, IRET
      LOGICAL LDEBUG
C
C
C     -----------------------------------------------------------------|
C     Section 1.  Initialise.
C     -----------------------------------------------------------------|
      STEP = MIN(ABS(NS),ABS(EW))
C
  100 CONTINUE
C
      HSP2GG2 = 0
c
      CALL JDEBUG()
      LDEBUG = ( NDBG.NE.0 )

C     2.5 and greater -> T63
C
      IF( STEP.GE.2.5 ) THEN
        KTRUNC = 63
        KGAUSS  = 48
        GOTO 890
      ENDIF
C
C     1.5 to 2.5      -> T106
C
      IF( STEP.GE.1.5 ) THEN
        KTRUNC = 106
        KGAUSS = 80
        GOTO 890
      ENDIF
C
C     0.6 to 1.5      -> T213
C
      IF( STEP.GE.0.6 ) THEN
        KTRUNC = 213
        KGAUSS  = 128
        GOTO 890
      ENDIF
C
C     0.4 to 0.6      -> T319
C
      IF( STEP.GE.0.4 ) THEN
        KTRUNC = 319
        KGAUSS  = 160
        GOTO 890
      ENDIF
C
C     0.3 to 0.4      -> T511
C
      IF( STEP.GE.0.3 ) THEN
        KTRUNC  = 511
        KGAUSS  = 256
        GOTO 890
      ENDIF
C
C     0.15 to 0.3      -> T799
C
      IF( STEP.GE.0.15 ) THEN
        KTRUNC  = 799
        KGAUSS  = 400
        GOTO 890
      ENDIF

C
C     0.09 to 0.15      -> T1279
C
      IF( STEP.GE.0.09 ) THEN
        KTRUNC  = 1279
        KGAUSS  = 640
        GOTO 890
      ENDIF
c
      KTRUNC  = 2047
      KGAUSS  = 1024
C
C     Get the reduced gaussian grid information and count the
C     number of points.
C
  890 CONTINUE
      CALL JGETGG(KGAUSS,'R',PLATS,KPTS,IRET)
      IF( IRET.NE.0 ) THEN
        CALL INTLOG(JP_ERROR,
     X    'HSP2GG2: JGETGG failed to get gaussian data',JPQUIET)
        HSP2GG2 = 2
        GOTO 900
      ENDIF
C
      KSIZE = 0
      DO LOOP = 1, KGAUSS*2
        KSIZE = KSIZE + KPTS(LOOP)
      ENDDO

      IF( LDEBUG ) THEN
          CALL INTLOG(JP_DEBUG,
     X    'HSP2GG2: Corresponding Spectral Truncation:',KTRUNC)
          CALL INTLOG(JP_DEBUG,
     X    'HSP2GG2: Corresponding Gaussian Number:',KGAUSS)
      ENDIF
C
C     -----------------------------------------------------------------|
C     Section 9.  Return.
C     -----------------------------------------------------------------|
C
  900 CONTINUE
C
      RETURN
      END
