/*
 * Decompiled with CFR 0.152.
 */
package jalview.structure;

import MCview.PDBChain;
import MCview.PDBfile;
import jalview.analysis.AlignSeq;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Annotation;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SequenceI;
import jalview.io.AppletFormatAdapter;
import jalview.structure.SequenceListener;
import jalview.structure.StructureListener;
import jalview.structure.StructureMapping;
import jalview.structure.VamsasListener;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StructureSelectionManager {
    static StructureSelectionManager instance;
    StructureMapping[] mappings;
    Hashtable mappingData = new Hashtable();
    boolean relaySeqMappings = true;
    Vector listeners = new Vector();
    Vector seqmappings = null;
    boolean handlingVamsasMo = false;
    long lastmsg = 0L;
    private int[] seqmappingrefs = null;

    public static StructureSelectionManager getStructureSelectionManager() {
        if (instance == null) {
            instance = new StructureSelectionManager();
        }
        return instance;
    }

    public void setRelaySeqMappings(boolean relay) {
        this.relaySeqMappings = relay;
    }

    public boolean isRelaySeqMappingsEnabled() {
        return this.relaySeqMappings;
    }

    public void addStructureViewerListener(Object svl) {
        if (!this.listeners.contains(svl)) {
            this.listeners.addElement(svl);
        }
    }

    public String alreadyMappedToFile(String pdbid) {
        if (this.mappings != null) {
            for (int i = 0; i < this.mappings.length; ++i) {
                if (!this.mappings[i].getPdbId().equals(pdbid)) continue;
                return this.mappings[i].pdbfile;
            }
        }
        return null;
    }

    public synchronized PDBfile setMapping(SequenceI[] sequence, String[] targetChains, String pdbFile, String protocol) {
        PDBfile pdb = null;
        try {
            pdb = new PDBfile(pdbFile, protocol);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        for (int s = 0; s < sequence.length; ++s) {
            StructureMapping[] tmp;
            String targetChain = targetChains != null && targetChains[s] != null ? targetChains[s] : (sequence[s].getName().indexOf("|") > -1 ? sequence[s].getName().substring(sequence[s].getName().lastIndexOf("|") + 1) : "");
            int max = -10;
            AlignSeq maxAlignseq = null;
            String maxChainId = " ";
            PDBChain maxChain = null;
            for (int i = 0; i < pdb.chains.size(); ++i) {
                AlignSeq as = new AlignSeq(sequence[s], ((PDBChain)pdb.chains.elementAt((int)i)).sequence, "pep");
                as.calcScoreMatrix();
                as.traceAlignment();
                PDBChain chain = (PDBChain)pdb.chains.elementAt(i);
                if (as.maxscore <= max && (as.maxscore != max || !chain.id.equals(targetChain))) continue;
                maxChain = chain;
                max = as.maxscore;
                maxAlignseq = as;
                maxChainId = chain.id;
            }
            final StringBuffer mappingDetails = new StringBuffer();
            mappingDetails.append("\n\nPDB Sequence is :\nSequence = " + maxChain.sequence.getSequenceAsString());
            mappingDetails.append("\nNo of residues = " + maxChain.residues.size() + "\n\n");
            PrintStream ps = new PrintStream(System.out){

                public void print(String x) {
                    mappingDetails.append(x);
                }

                public void println() {
                    mappingDetails.append("\n");
                }
            };
            maxAlignseq.printAlignment(ps);
            mappingDetails.append("\nPDB start/end " + maxAlignseq.seq2start + " " + maxAlignseq.seq2end);
            mappingDetails.append("\nSEQ start/end " + (maxAlignseq.seq1start + sequence[s].getStart() - 1) + " " + (maxAlignseq.seq1end + sequence[s].getEnd() - 1));
            maxChain.makeExactMapping(maxAlignseq, sequence[s]);
            maxChain.transferRESNUMFeatures(sequence[s], null);
            int[][] mapping = new int[sequence[s].getEnd() + 2][2];
            int resNum = -10000;
            int index = 0;
            do {
                tmp = (StructureMapping[])maxChain.atoms.elementAt(index);
                if (resNum == tmp.resNumber || tmp.alignmentMapping == -1) continue;
                resNum = tmp.resNumber;
                mapping[tmp.alignmentMapping + 1][0] = tmp.resNumber;
                mapping[tmp.alignmentMapping + 1][1] = tmp.atomIndex;
            } while (++index < maxChain.atoms.size());
            if (this.mappings == null) {
                this.mappings = new StructureMapping[1];
            } else {
                tmp = new StructureMapping[this.mappings.length + 1];
                System.arraycopy(this.mappings, 0, tmp, 0, this.mappings.length);
                this.mappings = tmp;
            }
            if (protocol.equals(AppletFormatAdapter.PASTE)) {
                pdbFile = "INLINE" + pdb.id;
            }
            this.mappings[this.mappings.length - 1] = new StructureMapping(sequence[s], pdbFile, pdb.id, maxChainId, mapping, mappingDetails.toString());
            maxChain.transferResidueAnnotation(this.mappings[this.mappings.length - 1]);
        }
        return pdb;
    }

    public void removeStructureViewerListener(Object svl, String pdbfile) {
        this.listeners.removeElement(svl);
        boolean removeMapping = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            StructureListener sl;
            if (!(this.listeners.elementAt(i) instanceof StructureListener) || !(sl = (StructureListener)this.listeners.elementAt(i)).getPdbFile().equals(pdbfile)) continue;
            removeMapping = false;
            break;
        }
        if (removeMapping && this.mappings != null) {
            Vector<StructureMapping> tmp = new Vector<StructureMapping>();
            for (int i = 0; i < this.mappings.length; ++i) {
                if (this.mappings[i].pdbfile.equals(pdbfile)) continue;
                tmp.addElement(this.mappings[i]);
            }
            this.mappings = new StructureMapping[tmp.size()];
            tmp.copyInto(this.mappings);
        }
    }

    public void mouseOverStructure(int pdbResNum, String chain, String pdbfile) {
        int i;
        boolean hasSequenceListeners = this.handlingVamsasMo || this.seqmappings != null;
        SearchResults results = null;
        for (i = 0; i < this.listeners.size(); ++i) {
            if (!(this.listeners.elementAt(i) instanceof SequenceListener)) continue;
            if (results == null) {
                results = new SearchResults();
            }
            for (int j = 0; j < this.mappings.length; ++j) {
                if (!this.mappings[j].pdbfile.equals(pdbfile) || !this.mappings[j].pdbchain.equals(chain)) continue;
                int indexpos = this.mappings[j].getSeqPos(pdbResNum);
                results.addResult(this.mappings[j].sequence, indexpos, indexpos);
                if (this.seqmappings == null) continue;
                Enumeration e = this.seqmappings.elements();
                while (e.hasMoreElements()) {
                    ((AlignedCodonFrame)e.nextElement()).markMappedRegion(this.mappings[j].sequence, indexpos, results);
                }
            }
        }
        if (results.getSize() > 0) {
            for (i = 0; i < this.listeners.size(); ++i) {
                Object li = this.listeners.elementAt(i);
                if (!(li instanceof SequenceListener)) continue;
                ((SequenceListener)li).highlightSequence(results);
            }
        }
    }

    public void mouseOverSequence(SequenceI seq, int indexpos, int index) {
        boolean hasSequenceListeners = this.handlingVamsasMo || this.seqmappings != null;
        SearchResults results = null;
        if (index == -1) {
            index = seq.findPosition(indexpos);
        }
        int atomNo = 0;
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (this.listeners.elementAt(i) instanceof StructureListener) {
                StructureListener sl = (StructureListener)this.listeners.elementAt(i);
                for (int j = 0; j < this.mappings.length; ++j) {
                    if (this.mappings[j].sequence != seq && this.mappings[j].sequence != seq.getDatasetSequence() || (atomNo = this.mappings[j].getAtomNum(index)) <= 0) continue;
                    sl.highlightAtom(atomNo, this.mappings[j].getPDBResNum(index), this.mappings[j].pdbchain, this.mappings[j].pdbfile);
                }
                continue;
            }
            if (this.relaySeqMappings && hasSequenceListeners && this.listeners.elementAt(i) instanceof SequenceListener) {
                if (results == null) {
                    results = new SearchResults();
                    if (index >= seq.getStart() && index <= seq.getEnd()) {
                        if (this.seqmappings != null) {
                            Enumeration e = this.seqmappings.elements();
                            while (e.hasMoreElements()) {
                                ((AlignedCodonFrame)e.nextElement()).markMappedRegion(seq, index, results);
                            }
                        }
                        if (this.handlingVamsasMo) {
                            results.addResult(seq, index, index);
                        }
                    }
                }
                if (!hasSequenceListeners) continue;
                ((SequenceListener)this.listeners.elementAt(i)).highlightSequence(results);
                continue;
            }
            if (!(this.listeners.elementAt(i) instanceof VamsasListener) || this.handlingVamsasMo) continue;
            ((VamsasListener)this.listeners.elementAt(i)).mouseOver(seq, indexpos);
        }
    }

    public void mouseOverVamsasSequence(SequenceI sequenceI, int position) {
        this.handlingVamsasMo = true;
        long msg = sequenceI.hashCode() * (1 + position);
        if (this.lastmsg != msg) {
            this.lastmsg = msg;
            this.mouseOverSequence(sequenceI, position, -1);
        }
        this.handlingVamsasMo = false;
    }

    public Annotation[] colourSequenceFromStructure(SequenceI seq, String pdbid) {
        return null;
    }

    public void structureSelectionChanged() {
    }

    public void sequenceSelectionChanged() {
    }

    public void sequenceColoursChanged(Object source) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!(this.listeners.elementAt(i) instanceof StructureListener)) continue;
            StructureListener sl = (StructureListener)this.listeners.elementAt(i);
            sl.updateColours(source);
        }
    }

    public StructureMapping[] getMapping(String pdbfile) {
        Vector<StructureMapping> tmp = new Vector<StructureMapping>();
        for (int i = 0; i < this.mappings.length; ++i) {
            if (!this.mappings[i].pdbfile.equals(pdbfile)) continue;
            tmp.addElement(this.mappings[i]);
        }
        StructureMapping[] ret = new StructureMapping[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            ret[i] = (StructureMapping)tmp.elementAt(i);
        }
        return ret;
    }

    public String printMapping(String pdbfile) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.mappings.length; ++i) {
            if (!this.mappings[i].pdbfile.equals(pdbfile)) continue;
            sb.append(this.mappings[i].mappingDetails);
        }
        return sb.toString();
    }

    private synchronized void modifySeqMappingList(boolean add, AlignedCodonFrame[] codonFrames) {
        if (!(add || this.seqmappings != null && this.seqmappings.size() != 0)) {
            return;
        }
        if (this.seqmappings == null) {
            this.seqmappings = new Vector();
        }
        if (codonFrames != null && codonFrames.length > 0) {
            for (int cf = 0; cf < codonFrames.length; ++cf) {
                if (this.seqmappings.contains(codonFrames[cf])) {
                    if (add) {
                        int n = this.seqmappings.indexOf(codonFrames[cf]);
                        this.seqmappingrefs[n] = this.seqmappingrefs[n] + 1;
                        continue;
                    }
                    int n = this.seqmappings.indexOf(codonFrames[cf]);
                    this.seqmappingrefs[n] = this.seqmappingrefs[n] - 1;
                    if (this.seqmappingrefs[n] > 0) continue;
                    int pos = this.seqmappings.indexOf(codonFrames[cf]);
                    int[] nr = new int[this.seqmappingrefs.length - 1];
                    if (pos > 0) {
                        System.arraycopy(this.seqmappingrefs, 0, nr, 0, pos);
                    }
                    if (pos >= this.seqmappingrefs.length - 1) continue;
                    System.arraycopy(this.seqmappingrefs, pos + 1, nr, 0, this.seqmappingrefs.length - pos - 2);
                    continue;
                }
                if (!add) continue;
                this.seqmappings.addElement(codonFrames[cf]);
                int[] nsr = new int[this.seqmappingrefs == null ? 1 : this.seqmappingrefs.length + 1];
                if (this.seqmappingrefs != null && this.seqmappingrefs.length > 0) {
                    System.arraycopy(this.seqmappingrefs, 0, nsr, 0, this.seqmappingrefs.length);
                }
                nsr[this.seqmappingrefs == null ? 0 : this.seqmappingrefs.length] = 1;
                this.seqmappingrefs = nsr;
            }
        }
    }

    public void removeMappings(AlignedCodonFrame[] codonFrames) {
        this.modifySeqMappingList(false, codonFrames);
    }

    public void addMappings(AlignedCodonFrame[] codonFrames) {
        this.modifySeqMappingList(true, codonFrames);
    }
}

