package de.lmu.ifi.dbs.elki.math.statistics.distribution;

/*
 This file is part of ELKI:
 Environment for Developing KDD-Applications Supported by Index-Structures

 Copyright (C) 2015
 Ludwig-Maximilians-Universität München
 Lehr- und Forschungseinheit für Datenbanksysteme
 ELKI Development Team

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU Affero General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import org.junit.Test;

import de.lmu.ifi.dbs.elki.JUnit4Test;

/**
 * Unit test for the Beta distribution in ELKI.
 * 
 * The reference values were computed using GNU R and SciPy.
 * 
 * @author Erich Schubert
 * @since 0.5.0
 */
public class BetaDistributionTest extends AbstractDistributionTest implements JUnit4Test {
  public static final double[] P_CDFPDF = { //
  1e-10, 1e-05, 0.1, 0.1234567, 0.2, 0.271828182846, 0.3, 0.314159265359, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 2.71828182846, 3.14159265359 //
  };

  public static final double[] SCIPY_BETA_CDF_01_01 = { //
  5.07237274393781481518495013460778864100575447082520e-02, // 0.000000
  1.60402641359773445728365004470106214284896850585938e-01, // 0.000010
  4.06385093936275976211902616341831162571907043457031e-01, // 0.100000
  4.15927737016427878646851468147360719740390777587891e-01, // 0.123457
  4.39709190223345591785886199431843124330043792724609e-01, // 0.200000
  4.56830072616762117299060719233239069581031799316406e-01, // 0.271828
  4.62804186115552074198831178364343941211700439453125e-01, // 0.300000
  4.65695944978432807559443062928039580583572387695312e-01, // 0.314159
  4.82120045609327974034385988488793373107910156250000e-01, // 0.400000
  4.99999999999999888977697537484345957636833190917969e-01, // 0.500000
  5.17879954390672025965614011511206626892089843750000e-01, // 0.600000
  5.37195813884447925801168821635656058788299560546875e-01, // 0.700000
  5.60290809776654241680660106794675812125205993652344e-01, // 0.800000
  5.93614906063723468676585071079898625612258911132812e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_01_01 = { //
  5.07237274435283020138740539550781250000000000000000e+07, // 0.000000
  1.60403953757008639513514935970306396484375000000000e+03, // 0.000010
  4.42988958666523380269808285447652451694011688232422e-01, // 0.100000
  3.75276980422167505402342158049577847123146057128906e-01, // 0.123457
  2.63938762316794750528714530446450226008892059326172e-01, // 0.200000
  2.17939347824759516170090023479133378714323043823242e-01, // 0.271828
  2.06639715373252902397283037316810805350542068481445e-01, // 0.300000
  2.01918135102394286084503960410074796527624130249023e-01, // 0.314159
  1.83240320487424945827825695232604630291461944580078e-01, // 0.400000
  1.76630277977873700878674867453810293227434158325195e-01, // 0.500000
  1.83240320487424945827825695232604630291461944580078e-01, // 0.600000
  2.06639715373252874641707421687897294759750366210938e-01, // 0.700000
  2.63938762316794861551016992962104268372058868408203e-01, // 0.800000
  4.42988958666523491292110747963306494057178497314453e-01, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_01_01 = { //
  5.07237274393781412129555974388495087623596191406250e-02, // 0.000000
  1.60402641359773390217213773212279193103313446044922e-01, // 0.000010
  4.06385093936275865189600153826177120208740234375000e-01, // 0.100000
  4.15927737016427712113397774373879656195640563964844e-01, // 0.123457
  4.39709190223345480763583736916189081966876983642578e-01, // 0.200000
  4.56830072616782767447318747144890949130058288574219e-01, // 0.271828
  4.62804186115551741131923790817381814122200012207031e-01, // 0.300000
  4.65695944978436748851180482233758084475994110107422e-01, // 0.314159
  4.82120045609327474434024907168350182473659515380859e-01, // 0.400000
  4.99999999999999500399638918679556809365749359130859e-01, // 0.500000
  5.17879954390672470054823861573822796344757080078125e-01, // 0.600000
  5.37195813884448258868076209182618185877799987792969e-01, // 0.700000
  5.60290809776654574747567494341637939214706420898438e-01, // 0.800000
  5.93614906063724134810399846173822879791259765625000e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_01_01 = { //
  5.07237274435282945632934570312500000000000000000000e+07, // 0.000000
  1.60403953757008684988250024616718292236328125000000e+03, // 0.000010
  4.42988958666523380269808285447652451694011688232422e-01, // 0.100000
  3.75276980422167782958098314338712953031063079833984e-01, // 0.123457
  2.63938762316794861551016992962104268372058868408203e-01, // 0.200000
  2.17939347824716384005583336147537920624017715454102e-01, // 0.271828
  2.06639715373252930152858652945724315941333770751953e-01, // 0.300000
  2.01918135102387819035385518873226828873157501220703e-01, // 0.314159
  1.83240320487424973583401310861518140882253646850586e-01, // 0.400000
  1.76630277977873756389826098711637314409017562866211e-01, // 0.500000
  1.83240320487424973583401310861518140882253646850586e-01, // 0.600000
  2.06639715373252930152858652945724315941333770751953e-01, // 0.700000
  2.63938762316794917062168224219931289553642272949219e-01, // 0.800000
  4.42988958666523602314413210478960536420345306396484e-01, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_01_05 = { //
  8.83151389893383070850418903319223318248987197875977e-02, // 0.000000
  2.79277118023966042237304918671725317835807800292969e-01, // 0.000010
  7.04833622051221020399225380970165133476257324218750e-01, // 0.100000
  7.20681507439501545242421798320719972252845764160156e-01, // 0.123457
  7.59304219445318007153389316954417154192924499511719e-01, // 0.200000
  7.86085328767555213680395809205947443842887878417969e-01, // 0.271828
  7.95176530367367906393383236718364059925079345703125e-01, // 0.300000
  7.99524278991131209792797562840860337018966674804688e-01, // 0.314159
  8.23494838536657169925092603079974651336669921875000e-01, // 0.400000
  8.48001712399770513073349320620764046907424926757812e-01, // 0.500000
  8.70603436980005307432861627603415399789810180664062e-01, // 0.600000
  8.92658587836405614801549290859838947653770446777344e-01, // 0.700000
  9.15640640375003589390701108641223981976509094238281e-01, // 0.800000
  9.42366288315789946139489074994344264268875122070312e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_01_05 = { //
  8.83151389933526813983917236328125000000000000000000e+07, // 0.000000
  2.79278387474808914703316986560821533203125000000000e+03, // 0.000010
  7.39458664410644117559456844901433214545249938964844e-01, // 0.100000
  6.19848096459823749704298734286567196249961853027344e-01, // 0.123457
  4.20303655461324865427741315215826034545898437500000e-01, // 0.200000
  3.34235972869352193637126902103773318231105804443359e-01, // 0.271828
  3.11944266317603025040483544216840527951717376708984e-01, // 0.300000
  3.02335144044583059574904382316162809729576110839844e-01, // 0.314159
  2.60079151351645165846093732398003339767456054687500e-01, // 0.400000
  2.33065049073819779978933297570620197802782058715820e-01, // 0.500000
  2.21140881157234348020068637197255156934261322021484e-01, // 0.600000
  2.22272786172716479979882819861813914030790328979492e-01, // 0.700000
  2.41401058813832225524720342946238815784454345703125e-01, // 0.800000
  3.07055512274369113434602240886306390166282653808594e-01, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_01_05 = { //
  8.83151389893382793294662747030088212341070175170898e-02, // 0.000000
  2.79277118023966042237304918671725317835807800292969e-01, // 0.000010
  7.04833622051220909376922918454511091113090515136719e-01, // 0.100000
  7.20681507439501323197816873289411887526512145996094e-01, // 0.123457
  7.59304219445317896131086854438763111829757690429688e-01, // 0.200000
  7.86085328767586744014295163651695474982261657714844e-01, // 0.271828
  7.95176530367367462304173386655747890472412109375000e-01, // 0.300000
  7.99524278991137093974828076170524582266807556152344e-01, // 0.314159
  8.23494838536657169925092603079974651336669921875000e-01, // 0.400000
  8.48001712399770513073349320620764046907424926757812e-01, // 0.500000
  8.70603436980005307432861627603415399789810180664062e-01, // 0.600000
  8.92658587836405725823851753375492990016937255859375e-01, // 0.700000
  9.15640640375003700413003571156878024339675903320312e-01, // 0.800000
  9.42366288315790390228698925056960433721542358398438e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_01_05 = { //
  8.83151389933526664972305297851562500000000000000000e+07, // 0.000000
  2.79278387474808823753846809267997741699218750000000e+03, // 0.000010
  7.39458664410643895514851919870125129818916320800781e-01, // 0.100000
  6.19848096459823971748903659317875280976295471191406e-01, // 0.123457
  4.20303655461324865427741315215826034545898437500000e-01, // 0.200000
  3.34235972869268427309918934042798355221748352050781e-01, // 0.271828
  3.11944266317603025040483544216840527951717376708984e-01, // 0.300000
  3.02335144044569681387457649179850704967975616455078e-01, // 0.314159
  2.60079151351645221357244963655830360949039459228516e-01, // 0.400000
  2.33065049073819752223357681941706687211990356445312e-01, // 0.500000
  2.21140881157234375775644252826168667525053024291992e-01, // 0.600000
  2.22272786172716479979882819861813914030790328979492e-01, // 0.700000
  2.41401058813832253280295958575152326375246047973633e-01, // 0.800000
  3.07055512274369168945753472144133411347866058349609e-01, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_01_1 = { //
  1.00000000000000019428902930940239457413554191589355e-01, // 0.000000
  3.16227766016837996687627310166135430335998535156250e-01, // 0.000010
  7.94328234724281712075821815233211964368820190429688e-01, // 0.100000
  8.11243941442105320760447284555993974208831787109375e-01, // 0.123457
  8.51339922520784830872742077190196141600608825683594e-01, // 0.200000
  8.77868464423642858029950275522423908114433288574219e-01, // 0.271828
  8.86568150565213541902664928784361109137535095214844e-01, // 0.300000
  8.90666232270154401007289379776921123266220092773438e-01, // 0.314159
  9.12443536555481049532545512192882597446441650390625e-01, // 0.400000
  9.33032991536807632115824162610806524753570556640625e-01, // 0.500000
  9.50200216505676653611089932383038103580474853515625e-01, // 0.600000
  9.64961095119817868770439872605493292212486267089844e-01, // 0.700000
  9.77932768542928765320709771913243457674980163574219e-01, // 0.800000
  9.89519258206214669115752258221618831157684326171875e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_01_1 = { //
  1.00000000000000059604644775390625000000000000000000e+08, // 0.000000
  3.16227766016838040741276927292346954345703125000000e+03, // 0.000010
  7.94328234724281601053519352717557922005653381347656e-01, // 0.100000
  6.57108072256997965965297225920949131250381469726562e-01, // 0.123457
  4.25669961260392415436371038595098070800304412841797e-01, // 0.200000
  3.22949760114201955829571488720830529928207397460938e-01, // 0.271828
  2.95522716855071199137938720014062710106372833251953e-01, // 0.300000
  2.83507867021658532813432884722715243697166442871094e-01, // 0.314159
  2.28110884138870234627560762419307138770818710327148e-01, // 0.400000
  1.86606598307361509769819463144813198596239089965820e-01, // 0.500000
  1.58366702750946081179606039768259506672620773315430e-01, // 0.600000
  1.37851585017116834430694893853797111660242080688477e-01, // 0.700000
  1.22241596067866081787300913674698676913976669311523e-01, // 0.800000
  1.09946584245134940105437237889418611302971839904785e-01, // 0.900000
  1.00000000000000019428902930940239457413554191589355e-01, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_01_1 = { //
  9.99999999999999777955395074968691915273666381835938e-02, // 0.000000
  3.16227766016837885665324847650481387972831726074219e-01, // 0.000010
  7.94328234724281379008914427686249837279319763183594e-01, // 0.100000
  8.11243941442104987693539897009031847119331359863281e-01, // 0.123457
  8.51339922520784497805834689643234014511108398437500e-01, // 0.200000
  8.77868464423673389163127467327285557985305786132812e-01, // 0.271828
  8.86568150565213208835757541237398982048034667968750e-01, // 0.300000
  8.90666232270159952122412505559623241424560546875000e-01, // 0.314159
  9.12443536555480938510243049677228555083274841308594e-01, // 0.400000
  9.33032991536807410071219237579498440027236938476562e-01, // 0.500000
  9.50200216505676431566485007351730018854141235351562e-01, // 0.600000
  9.64961095119817535703532485058531165122985839843750e-01, // 0.700000
  9.77932768542928543276104846881935372948646545410156e-01, // 0.800000
  9.89519258206214447071147333190310746431350708007812e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_01_1 = { //
  9.99999999999998211860656738281250000000000000000000e+07, // 0.000000
  3.16227766016838040741276927292346954345703125000000e+03, // 0.000010
  7.94328234724281601053519352717557922005653381347656e-01, // 0.100000
  6.57108072256998076987599688436603173613548278808594e-01, // 0.123457
  4.25669961260392415436371038595098070800304412841797e-01, // 0.200000
  3.22949760114099870822457205576938576996326446533203e-01, // 0.271828
  2.95522716855071199137938720014062710106372833251953e-01, // 0.300000
  2.83507867021641657423458582343300804495811462402344e-01, // 0.314159
  2.28110884138870234627560762419307138770818710327148e-01, // 0.400000
  1.86606598307361537525395078773726709187030792236328e-01, // 0.500000
  1.58366702750946108935181655397173017263412475585938e-01, // 0.600000
  1.37851585017116834430694893853797111660242080688477e-01, // 0.700000
  1.22241596067866095665088721489155432209372520446777e-01, // 0.800000
  1.09946584245134940105437237889418611302971839904785e-01, // 0.900000
  1.00000000000000005551115123125782702118158340454102e-01, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_01_2 = { //
  1.09999999998999994921256018187705194577574729919434e-01, // 0.000000
  3.47850226390755745686789168757968582212924957275391e-01, // 0.000010
  8.65817775849466841897594804322579875588417053222656e-01, // 0.100000
  8.82352985595772132398906251182779669761657714843750e-01, // 0.123457
  9.19447116322447466352230094344122335314750671386719e-01, // 0.200000
  9.41792371919806692304177886398974806070327758789062e-01, // 0.271828
  9.48627921104778337735297100152820348739624023437500e-01, // 0.300000
  9.51751750576165678197071429167408496141433715820312e-01, // 0.314159
  9.67190148748809930268066636926960200071334838867188e-01, // 0.400000
  9.79684641113647836085931430716300383210182189941406e-01, // 0.500000
  9.88208225165903453302007619640789926052093505859375e-01, // 0.600000
  9.93909927973412155033372528123436495661735534667969e-01, // 0.700000
  9.97491423913787089716720402066130191087722778320312e-01, // 0.800000
  9.99414450788276509385354984260629862546920776367188e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_01_2 = { //
  1.09999999989000067114830017089843750000000000000000e+08, // 0.000000
  3.47847064113095666471053846180438995361328125000000e+03, // 0.000010
  7.86384952377038759507854592811781913042068481445312e-01, // 0.100000
  6.33582045924066195041746141214389353990554809570312e-01, // 0.123457
  3.74589565909145327804452563213999383151531219482422e-01, // 0.200000
  2.58679205039021475887039969165925867855548858642578e-01, // 0.271828
  2.27552491978404769490396120090736076235771179199219e-01, // 0.300000
  2.13885368174107387551075021292490419000387191772461e-01, // 0.314159
  1.50553183531654338755956246131972875446081161499023e-01, // 0.400000
  1.02633629069048826210064362385310232639312744140625e-01, // 0.500000
  6.96813492104162851559223668118647765368223190307617e-02, // 0.600000
  4.54910230556485536967947780340182362124323844909668e-02, // 0.700000
  2.68931511349305325808689559607955743558704853057861e-02, // 0.800000
  1.20941242669648403584847784486555610783398151397705e-02, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_01_2 = { //
  1.09999999998999994921256018187705194577574729919434e-01, // 0.000000
  3.47850226390755745686789168757968582212924957275391e-01, // 0.000010
  8.65817775849466841897594804322579875588417053222656e-01, // 0.100000
  8.82352985595771910354301326151471585035324096679688e-01, // 0.123457
  9.19447116322447355329927631828468292951583862304688e-01, // 0.200000
  9.41792371919831339255324564874172210693359375000000e-01, // 0.271828
  9.48627921104778337735297100152820348739624023437500e-01, // 0.300000
  9.51751750576169897044565004762262105941772460937500e-01, // 0.314159
  9.67190148748809708223461711895652115345001220703125e-01, // 0.400000
  9.79684641113647725063628968200646340847015380859375e-01, // 0.500000
  9.88208225165903453302007619640789926052093505859375e-01, // 0.600000
  9.93909927973412155033372528123436495661735534667969e-01, // 0.700000
  9.97491423913787089716720402066130191087722778320312e-01, // 0.800000
  9.99414450788276509385354984260629862546920776367188e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_01_2 = { //
  1.09999999989000082015991210937500000000000000000000e+08, // 0.000000
  3.47847064113095257198438048362731933593750000000000e+03, // 0.000010
  7.86384952377038648485552130296127870678901672363281e-01, // 0.100000
  6.33582045924066306064048603730043396353721618652344e-01, // 0.123457
  3.74589565909145272293301331956172361969947814941406e-01, // 0.200000
  2.58679205038905735136722796596586704254150390625000e-01, // 0.271828
  2.27552491978404825001547351348563097417354583740234e-01, // 0.300000
  2.13885368174088180692749006084341090172529220581055e-01, // 0.314159
  1.50553183531654338755956246131972875446081161499023e-01, // 0.400000
  1.02633629069048826210064362385310232639312744140625e-01, // 0.500000
  6.96813492104162851559223668118647765368223190307617e-02, // 0.600000
  4.54910230556485675745825858484749915078282356262207e-02, // 0.700000
  2.68931511349305360503159079144097631797194480895996e-02, // 0.800000
  1.20941242669648386237613024718484666664153337478638e-02, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_01_4 = { //
  1.19349999996744948749238801610772497951984405517578e-01, // 0.000000
  3.77416809425109245346163788781268522143363952636719e-01, // 0.000010
  9.23499112106322184168050171138020232319831848144531e-01, // 0.100000
  9.37669077635512548951624012261163443326950073242188e-01, // 0.123457
  9.66195894147908407312286271917400881648063659667969e-01, // 0.200000
  9.80442982290223752350755148654570803046226501464844e-01, // 0.271828
  9.84228508474799701488677783345337957143783569335938e-01, // 0.300000
  9.85856268655784573340383758477400988340377807617188e-01, // 0.314159
  9.92844411222603584477042204525787383317947387695312e-01, // 0.400000
  9.97004066019049783875516368425451219081878662109375e-01, // 0.500000
  9.98911280404623402873198756424244493246078491210938e-01, // 0.600000
  9.99689562452632296540855350031051784753799438476562e-01, // 0.700000
  9.99944079297292787167350525123765692114830017089844e-01, // 0.800000
  9.99996782871730882646943427971564233303070068359375e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_01_4 = { //
  1.19349999964195013046264648437500000000000000000000e+08, // 0.000000
  3.77406516319158845362835563719272613525390625000000e+03, // 0.000010
  6.91114415396560266557912655116524547338485717773438e-01, // 0.100000
  5.28176834178893939153454084589611738920211791992188e-01, // 0.123457
  2.60114994567310409134819337850785814225673675537109e-01, // 0.200000
  1.48819207734607078519317724385473411530256271362305e-01, // 0.271828
  1.20978282360318822874489796959096565842628479003906e-01, // 0.300000
  1.09158451358456268232011154850624734535813331604004e-01, // 0.314159
  5.88060734874641527492045156577660236507654190063477e-02, // 0.400000
  2.78393718849794802316921504825586453080177307128906e-02, // 0.500000
  1.20966822229282636169678255555481882765889167785645e-02, // 0.600000
  4.44219840138408098711986227158377005252987146377563e-03, // 0.700000
  1.16716275925598405617533703804156175465323030948639e-03, // 0.800000
  1.31221248296568387655194887209120224724756553769112e-04, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_01_4 = { //
  1.19349999996745004260390032868599519133567810058594e-01, // 0.000000
  3.77416809425109411879617482554749585688114166259766e-01, // 0.000010
  9.23499112106322628257260021200636401772499084472656e-01, // 0.100000
  9.37669077635512770996228937292471528053283691406250e-01, // 0.123457
  9.66195894147908740379193659464363008737564086914062e-01, // 0.200000
  9.80442982290238074227772813173942267894744873046875e-01, // 0.271828
  9.84228508474799701488677783345337957143783569335938e-01, // 0.300000
  9.85856268655786793786433008790481835603713989257812e-01, // 0.314159
  9.92844411222603584477042204525787383317947387695312e-01, // 0.400000
  9.97004066019049783875516368425451219081878662109375e-01, // 0.500000
  9.98911280404623402873198756424244493246078491210938e-01, // 0.600000
  9.99689562452632296540855350031051784753799438476562e-01, // 0.700000
  9.99944079297292676145048062608111649751663208007812e-01, // 0.800000
  9.99996782871730882646943427971564233303070068359375e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_01_4 = { //
  1.19349999964195147156715393066406250000000000000000e+08, // 0.000000
  3.77406516319158572514425031840801239013671875000000e+03, // 0.000010
  6.91114415396560155535610192600870504975318908691406e-01, // 0.100000
  5.28176834178893939153454084589611738920211791992188e-01, // 0.123457
  2.60114994567310353623668106592958793044090270996094e-01, // 0.200000
  1.48819207734501468554100256369565613567829132080078e-01, // 0.271828
  1.20978282360318920019004451660293852910399436950684e-01, // 0.300000
  1.09158451358439906320185741606110241264104843139648e-01, // 0.314159
  5.88060734874641596880984195649944012984633445739746e-02, // 0.400000
  2.78393718849794941094799582970154006034135818481445e-02, // 0.500000
  1.20966822229282670864147775091623771004378795623779e-02, // 0.600000
  4.44219840138408185448160025998731725849211215972900e-03, // 0.700000
  1.16716275925598514037750952354599576210603117942810e-03, // 0.800000
  1.31221248296568414760249199346731074911076575517654e-04, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_05_01 = { //
  1.76630277983172680022875850741614911498800211120397e-06, // 0.000000
  5.58555657830258874343987152144563879119232296943665e-04, // 0.000010
  5.76337116842095750768315554068976780399680137634277e-02, // 0.100000
  6.45370774761398202645779065278475172817707061767578e-02, // 0.123457
  8.43593596249963134647842366575787309557199478149414e-02, // 0.200000
  1.01039482858121226760417243895062711089849472045898e-01, // 0.271828
  1.07341412163594357442875093511247541755437850952148e-01, // 0.300000
  1.10480921737836620954986699416622286662459373474121e-01, // 0.314159
  1.29396563019994831345016450541152153164148330688477e-01, // 0.400000
  1.51998287600229570193377526265976484864950180053711e-01, // 0.500000
  1.76505161463342941097209859435679391026496887207031e-01, // 0.600000
  2.04823469632632232384494841426203493028879165649414e-01, // 0.700000
  2.40695780554681937335459451787755824625492095947266e-01, // 0.800000
  2.95166377948778924089623387772007845342159271240234e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_05_01 = { //
  8.83151389968852345191407948732376098632812500000000e+03, // 0.000000
  2.79279504596178647091164748417213559150695800781250e+01, // 0.000010
  3.07055512274369002412299778370652347803115844726562e-01, // 0.100000
  2.82996971327952206998190831654937937855720520019531e-01, // 0.123457
  2.41401058813832225524720342946238815784454345703125e-01, // 0.200000
  2.25360312523454175970272217455203644931316375732422e-01, // 0.271828
  2.22272786172716479979882819861813914030790328979492e-01, // 0.300000
  2.21237769900911845910584929697506595402956008911133e-01, // 0.314159
  2.21140881157234348020068637197255156934261322021484e-01, // 0.400000
  2.33065049073819779978933297570620197802782058715820e-01, // 0.500000
  2.60079151351645165846093732398003339767456054687500e-01, // 0.600000
  3.11944266317603025040483544216840527951717376708984e-01, // 0.700000
  4.20303655461324976450043777731480076909065246582031e-01, // 0.800000
  7.39458664410644339604061769932741299271583557128906e-01, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_05_01 = { //
  1.76630277983172658847052169384106434790737694129348e-06, // 0.000000
  5.58555657830258765923769903594120478373952209949493e-04, // 0.000010
  5.76337116842095611990437475924409227445721626281738e-02, // 0.100000
  6.45370774761398063867900987133907619863748550415039e-02, // 0.123457
  8.43593596249962857092086210286652203649282455444336e-02, // 0.200000
  1.01039482858142709575943740674119908362627029418945e-01, // 0.271828
  1.07341412163594315809511670067877275869250297546387e-01, // 0.300000
  1.10480921737841158991599854743981268256902694702148e-01, // 0.314159
  1.29396563019994748078289603654411621391773223876953e-01, // 0.400000
  1.51998287600229459171075063750322442501783370971680e-01, // 0.500000
  1.76505161463342774563756165662198327481746673583984e-01, // 0.600000
  2.04823469632632537695826613344252109527587890625000e-01, // 0.700000
  2.40695780554682103868913145561236888170242309570312e-01, // 0.800000
  2.95166377948779090623077081545488908886909484863281e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_05_01 = { //
  8.83151389968851799494586884975433349609375000000000e+03, // 0.000000
  2.79279504596178611564027960412204265594482421875000e+01, // 0.000010
  3.07055512274369057923451009628479368984699249267578e-01, // 0.100000
  2.82996971327952262509342062912764959037303924560547e-01, // 0.123457
  2.41401058813832197769144727317325305193662643432617e-01, // 0.200000
  2.25360312523441158605308487494767177850008010864258e-01, // 0.271828
  2.22272786172716479979882819861813914030790328979492e-01, // 0.300000
  2.21237769900910513642955379509658087044954299926758e-01, // 0.314159
  2.21140881157234375775644252826168667525053024291992e-01, // 0.400000
  2.33065049073819752223357681941706687211990356445312e-01, // 0.500000
  2.60079151351645221357244963655830360949039459228516e-01, // 0.600000
  3.11944266317603025040483544216840527951717376708984e-01, // 0.700000
  4.20303655461324976450043777731480076909065246582031e-01, // 0.800000
  7.39458664410644228581759307417087256908416748046875e-01, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_05_05 = { //
  6.36619772378191858851811252284491615682782139629126e-06, // 0.000000
  2.01317183947538743890581791617933049565181136131287e-03, // 0.000010
  2.04832764699133501595795792127319145947694778442383e-01, // 0.100000
  2.28564106667586530718949688889551907777786254882812e-01, // 0.123457
  2.95167235300866637182082286017248407006263732910156e-01, // 0.200000
  3.49158781117712757602333795148297213017940521240234e-01, // 0.271828
  3.69010119565545413600204938120441511273384094238281e-01, // 0.300000
  3.78781359553035823495292788720689713954925537109375e-01, // 0.314159
  4.35905783151025183475013591305469162762165069580078e-01, // 0.400000
  5.00000000000000111022302462515654042363166809082031e-01, // 0.500000
  5.64094216848975094080742564983665943145751953125000e-01, // 0.600000
  6.30989880434454586399795061879558488726615905761719e-01, // 0.700000
  7.04832764699133362817917713982751592993736267089844e-01, // 0.800000
  7.95167235300866193092872435954632237553596496582031e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_05_05 = { //
  3.18309886199706197658088058233261108398437500000000e+04, // 0.000000
  1.00658927504869836866419063881039619445800781250000e+02, // 0.000010
  1.06103295394596908174378313560737296938896179199219e+00, // 0.100000
  9.67622833349070621267173919477500021457672119140625e-01, // 0.123457
  7.95774715459476977841291045479010790586471557617188e-01, // 0.200000
  7.15460980314251537848235784622374922037124633789062e-01, // 0.271828
  6.94609118042856854557953738549258559942245483398438e-01, // 0.300000
  6.85746426302663469876108592870878055691719055175781e-01, // 0.314159
  6.49747334361396755575412953476188704371452331542969e-01, // 0.400000
  6.36619772367581604477493328886339440941810607910156e-01, // 0.500000
  6.49747334361396755575412953476188704371452331542969e-01, // 0.600000
  6.94609118042856854557953738549258559942245483398438e-01, // 0.700000
  7.95774715459476977841291045479010790586471557617188e-01, // 0.800000
  1.06103295394596930378838806063868105411529541015625e+00, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_05_05 = { //
  6.36619772378191689445221801424423802018282003700733e-06, // 0.000000
  2.01317183947538700522494892197755689267069101333618e-03, // 0.000010
  2.04832764699133446084644560869492124766111373901367e-01, // 0.100000
  2.28564106667586419696647226373897865414619445800781e-01, // 0.123457
  2.95167235300866415137477360985940322279930114746094e-01, // 0.200000
  3.49158781117780925296045779759879224002361297607422e-01, // 0.271828
  3.69010119565545247066751244346960447728633880615234e-01, // 0.300000
  3.78781359553049756794251834435272030532360076904297e-01, // 0.314159
  4.35905783151024850408106203758507035672664642333984e-01, // 0.400000
  4.99999999999999555910790149937383830547332763671875e-01, // 0.500000
  5.64094216848975094080742564983665943145751953125000e-01, // 0.600000
  6.30989880434454697422097524395212531089782714843750e-01, // 0.700000
  7.04832764699133584862522639014059677720069885253906e-01, // 0.800000
  7.95167235300866637182082286017248407006263732910156e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_05_05 = { //
  3.18309886199705724720843136310577392578125000000000e+04, // 0.000000
  1.00658927504869879498983209487050771713256835937500e+02, // 0.000010
  1.06103295394596863765457328554475679993629455566406e+00, // 0.100000
  9.67622833349070399222568994446191936731338500976562e-01, // 0.123457
  7.95774715459476422729778732900740578770637512207031e-01, // 0.200000
  7.15460980314172489968882473476696759462356567382812e-01, // 0.271828
  6.94609118042856410468743888486642390489578247070312e-01, // 0.300000
  6.85746426302651035378232791117625311017036437988281e-01, // 0.314159
  6.49747334361396533530808028444880619645118713378906e-01, // 0.400000
  6.36619772367581160388283478823723271489143371582031e-01, // 0.500000
  6.49747334361396533530808028444880619645118713378906e-01, // 0.600000
  6.94609118042856410468743888486642390489578247070312e-01, // 0.700000
  7.95774715459476533752081195416394621133804321289062e-01, // 0.800000
  1.06103295394596885969917821057606488466262817382812e+00, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_05_1 = { //
  1.00000000000000008180305391403130954586231382563710e-05, // 0.000000
  3.16227766016837939441752602931501314742490649223328e-03, // 0.000010
  3.16227766016837941176476078908308409154415130615234e-01, // 0.100000
  3.51364056215202502642114268383011221885681152343750e-01, // 0.123457
  4.47213595499957927703604809721582569181919097900391e-01, // 0.200000
  5.21371444217943791343827797390986233949661254882812e-01, // 0.271828
  5.47722557505166074420799304789397865533828735351562e-01, // 0.300000
  5.60499121639792874383090293122222647070884704589844e-01, // 0.314159
  6.32455532033675882352952157816616818308830261230469e-01, // 0.400000
  7.07106781186547572737310929369414225220680236816406e-01, // 0.500000
  7.74596669241483404277914814883843064308166503906250e-01, // 0.600000
  8.36660026534075562665293546160683035850524902343750e-01, // 0.700000
  8.94427190999915855407209619443165138363838195800781e-01, // 0.800000
  9.48683298050513768018277005467098206281661987304688e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_05_1 = { //
  5.00000000000000072759576141834259033203125000000000e+04, // 0.000000
  1.58113883008418980580245261080563068389892578125000e+02, // 0.000010
  1.58113883008418976139353162579936906695365905761719e+00, // 0.100000
  1.42302546648016092767363716120598837733268737792969e+00, // 0.123457
  1.11803398874989512457034379622200503945350646972656e+00, // 0.200000
  9.59009177708225135638997471687616780400276184082031e-01, // 0.271828
  9.12870929175277012745937099680304527282714843750000e-01, // 0.300000
  8.92062058076385722138468281627865508198738098144531e-01, // 0.314159
  7.90569415042094880696765812899684533476829528808594e-01, // 0.400000
  7.07106781186547683759613391885068267583847045898438e-01, // 0.500000
  6.45497224367902910913130654080305248498916625976562e-01, // 0.600000
  5.97614304667197004938827831210801377892494201660156e-01, // 0.700000
  5.59016994374947562285171898111002519726753234863281e-01, // 0.800000
  5.27046276694730031486813004448777064681053161621094e-01, // 0.900000
  5.00000000000000111022302462515654042363166809082031e-01, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_05_1 = { //
  1.00000000000000008180305391403130954586231382563710e-05, // 0.000000
  3.16227766016837939441752602931501314742490649223328e-03, // 0.000010
  3.16227766016837941176476078908308409154415130615234e-01, // 0.100000
  3.51364056215202502642114268383011221885681152343750e-01, // 0.123457
  4.47213595499957927703604809721582569181919097900391e-01, // 0.200000
  5.21371444218035384743359372805571183562278747558594e-01, // 0.271828
  5.47722557505166074420799304789397865533828735351562e-01, // 0.300000
  5.60499121639811304085299070720793679356575012207031e-01, // 0.314159
  6.32455532033675882352952157816616818308830261230469e-01, // 0.400000
  7.07106781186547572737310929369414225220680236816406e-01, // 0.500000
  7.74596669241483404277914814883843064308166503906250e-01, // 0.600000
  8.36660026534075562665293546160683035850524902343750e-01, // 0.700000
  8.94427190999915966429512081958819180727005004882812e-01, // 0.800000
  9.48683298050513768018277005467098206281661987304688e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_05_1 = { //
  5.00000000000000072759576141834259033203125000000000e+04, // 0.000000
  1.58113883008418980580245261080563068389892578125000e+02, // 0.000010
  1.58113883008418953934892670076806098222732543945312e+00, // 0.100000
  1.42302546648016092767363716120598837733268737792969e+00, // 0.123457
  1.11803398874989490252573887119069695472717285156250e+00, // 0.200000
  9.59009177708056492761556910409126430749893188476562e-01, // 0.271828
  9.12870929175276901723634637164650484919548034667969e-01, // 0.300000
  8.92062058076356190206013252463890239596366882324219e-01, // 0.314159
  7.90569415042094769674463350384030491113662719726562e-01, // 0.400000
  7.07106781186547572737310929369414225220680236816406e-01, // 0.500000
  6.45497224367902799890828191564651206135749816894531e-01, // 0.600000
  5.97614304667196893916525368695147335529327392578125e-01, // 0.700000
  5.59016994374947451262869435595348477363586425781250e-01, // 0.800000
  5.27046276694729920464510541933123022317886352539062e-01, // 0.900000
  5.00000000000000000000000000000000000000000000000000e-01, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_05_2 = { //
  1.49999999995000036075122260004199858940410194918513e-05, // 0.000000
  4.74340067886426866583526873455411987379193305969238e-03, // 0.000010
  4.58530260724415050788138614734634757041931152343750e-01, // 0.100000
  5.05356960883332151368563245341647416353225708007812e-01, // 0.123457
  6.26099033699941132091737472364911809563636779785156e-01, // 0.200000
  7.11195440192161520975844268832588568329811096191406e-01, // 0.271828
  7.39425452631974344797072262736037373542785644531250e-01, // 0.300000
  7.52705686315334188130066195299150422215461730957031e-01, // 0.314159
  8.22192191643778769183370513928821310400962829589844e-01, // 0.400000
  8.83883476483184660210667971114162355661392211914062e-01, // 0.500000
  9.29516003089779996315655807848088443279266357421875e-01, // 0.600000
  9.62159030514186830451706100575393065810203552246094e-01, // 0.700000
  9.83869910099907429845700335135916247963905334472656e-01, // 0.800000
  9.96117462953039489725881594495149329304695129394531e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_05_2 = { //
  7.49999999925000010989606380462646484375000000000000e+04, // 0.000000
  2.37168452804383292686907225288450717926025390625000e+02, // 0.000010
  2.13453742061365581150766956852748990058898925781250e+00, // 0.100000
  1.87101515755883918146196265297476202249526977539062e+00, // 0.123457
  1.34164078649987406066657058545388281345367431640625e+00, // 0.200000
  1.04748518339887985995062535948818549513816833496094e+00, // 0.271828
  9.58514475634040685747550014639273285865783691406250e-01, // 0.300000
  9.17718745884733677620204161939909681677818298339844e-01, // 0.314159
  7.11512473537885270502556522842496633529663085937500e-01, // 0.400000
  5.30330085889910707308558812655974179506301879882812e-01, // 0.500000
  3.87298334620741757650108638699748553335666656494141e-01, // 0.600000
  2.68926437100238668875817893422208726406097412109375e-01, // 0.700000
  1.67705098312484202072170091923908330500125885009766e-01, // 0.800000
  7.90569415042094714163312119126203469932079315185547e-02, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_05_2 = { //
  1.49999999994999815846555973886111701176560018211603e-05, // 0.000000
  4.74340067886426779847353074615057266782969236373901e-03, // 0.000010
  4.58530260724415050788138614734634757041931152343750e-01, // 0.100000
  5.05356960883331929323958320310339331626892089843750e-01, // 0.123457
  6.26099033699941021069435009849257767200469970703125e-01, // 0.200000
  7.11195440192261552070362995436880737543106079101562e-01, // 0.271828
  7.39425452631974677863979650282999500632286071777344e-01, // 0.300000
  7.52705686315353283966089747991645708680152893066406e-01, // 0.314159
  8.22192191643778880205672976444475352764129638671875e-01, // 0.400000
  8.83883476483184438166063046082854270935058593750000e-01, // 0.500000
  9.29516003089779996315655807848088443279266357421875e-01, // 0.600000
  9.62159030514186941474008563091047108173370361328125e-01, // 0.700000
  9.83869910099907540868002797651570290327072143554688e-01, // 0.800000
  9.96117462953039489725881594495149329304695129394531e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_05_2 = { //
  7.49999999924999574432149529457092285156250000000000e+04, // 0.000000
  2.37168452804383349530326086096465587615966796875000e+02, // 0.000010
  2.13453742061365536741845971846487373113632202148438e+00, // 0.100000
  1.87101515755883918146196265297476202249526977539062e+00, // 0.123457
  1.34164078649987361657736073539126664400100708007812e+00, // 0.200000
  1.04748518339855811731808898912277072668075561523438e+00, // 0.271828
  9.58514475634040685747550014639273285865783691406250e-01, // 0.300000
  9.17718745884675612956016266252845525741577148437500e-01, // 0.314159
  7.11512473537885270502556522842496633529663085937500e-01, // 0.400000
  5.30330085889910596286256350140320137143135070800781e-01, // 0.500000
  3.87298334620741702138957407441921532154083251953125e-01, // 0.600000
  2.68926437100238557853515430906554684042930603027344e-01, // 0.700000
  1.67705098312484174316594476294994819909334182739258e-01, // 0.800000
  7.90569415042094297829677884692500811070203781127930e-02, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_05_4 = { //
  2.18749999978125033101364338428140854375669732689857e-05, // 0.000000
  6.91741320720956186923755737439023505430668592453003e-03, // 0.000010
  6.26625082597740412637676854501478374004364013671875e-01, // 0.100000
  6.80541225384169945478163299412699416279792785644531e-01, // 0.123457
  8.04984471899924280968718903750414028763771057128906e-01, // 0.200000
  8.77770786854125240061819113179808482527732849121094e-01, // 0.271828
  8.98778484206133598810595231043407693505287170410156e-01, // 0.300000
  9.08079033661920775877263167785713449120521545410156e-01, // 0.314159
  9.50264436880598029055988718027947470545768737792969e-01, // 0.400000
  9.77796095859522762516746752226026728749275207519531e-01, // 0.500000
  9.91483736629098721948594175046309828758239746093750e-01, // 0.600000
  9.97455625383593225130596238159341737627983093261719e-01, // 0.700000
  9.99522385942405944270205964130582287907600402832031e-01, // 0.800000
  9.99971488851369660899592872738139703869819641113281e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_05_4 = { //
  1.09374999967187526635825634002685546875000000000000e+05, // 0.000000
  3.45863742961106026996276341378688812255859375000000e+02, // 0.000010
  2.52142232809988131592149329662788659334182739257812e+00, // 0.100000
  2.09643237315321817604285570268984884023666381835938e+00, // 0.123457
  1.25219806739988270827268479479243978857994079589844e+00, // 0.200000
  8.09976508987270138462122304190415889024734497070312e-01, // 0.271828
  6.84938469046824982555676797346677631139755249023438e-01, // 0.300000
  6.29524964821042476437185086979297921061515808105469e-01, // 0.314159
  3.73544048607389767013842174492310732603073120117188e-01, // 0.400000
  1.93349510480696623604401906959537882357835769653320e-01, // 0.500000
  9.03696114115064286220757594492170028388500213623047e-02, // 0.600000
  3.52965948694063461066328102333500282838940620422363e-02, // 0.700000
  9.78279740156157671948644605208755820058286190032959e-03, // 0.800000
  1.15291373026972119794630877720464923186227679252625e-03, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_05_4 = { //
  2.18749999978125100864000118772167979841469787061214e-05, // 0.000000
  6.91741320720955839979060542077604623045772314071655e-03, // 0.000010
  6.26625082597740301615374391985824331641197204589844e-01, // 0.100000
  6.80541225384170056500465761928353458642959594726562e-01, // 0.123457
  8.04984471899924280968718903750414028763771057128906e-01, // 0.200000
  8.77770786854202622606635486590676009654998779296875e-01, // 0.271828
  8.98778484206133709832897693559061735868453979492188e-01, // 0.300000
  9.08079033661933876508953744632890447974205017089844e-01, // 0.314159
  9.50264436880598029055988718027947470545768737792969e-01, // 0.400000
  9.77796095859522762516746752226026728749275207519531e-01, // 0.500000
  9.91483736629098721948594175046309828758239746093750e-01, // 0.600000
  9.97455625383593114108293775643687695264816284179688e-01, // 0.700000
  9.99522385942406055292508426646236330270767211914062e-01, // 0.800000
  9.99971488851369771921895335253793746232986450195312e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_05_4 = { //
  1.09374999967187599395401775836944580078125000000000e+05, // 0.000000
  3.45863742961106026996276341378688812255859375000000e+02, // 0.000010
  2.52142232809988087183228344656527042388916015625000e+00, // 0.100000
  2.09643237315321773195364585262723267078399658203125e+00, // 0.123457
  1.25219806739988204213887001969851553440093994140625e+00, // 0.200000
  8.09976508986808951817693014163523912429809570312500e-01, // 0.271828
  6.84938469046825204600281722377985715866088867187500e-01, // 0.300000
  6.29524964820964538780856400990160182118415832519531e-01, // 0.314159
  3.73544048607389822524993405750137753784656524658203e-01, // 0.400000
  1.93349510480696651359977522588451392948627471923828e-01, // 0.500000
  9.03696114115064008665001438203034922480583190917969e-02, // 0.600000
  3.52965948694063183510571946044365176931023597717285e-02, // 0.700000
  9.78279740156157845420992202889465261250734329223633e-03, // 0.800000
  1.15291373026972098110587428010376243037171661853790e-03, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_1_01 = { //
  1.00000000004500018040698788008499304624104864203105e-11, // 0.000000
  1.00000450002850051417838117551184495823690667748451e-06, // 0.000010
  1.04807417937856101747273740443233691621571779251099e-02, // 0.100000
  1.30904819719778343217742033743888896424323320388794e-02, // 0.123457
  2.20672314570714948878116246078207041136920452117920e-02, // 0.200000
  3.12239657447760353414789591397493495605885982513428e-02, // 0.271828
  3.50389048801823949075284758691850584000349044799805e-02, // 0.300000
  3.70087797866922516010212973469606367871165275573730e-02, // 0.314159
  4.97997834943236170057723199988686246797442436218262e-02, // 0.400000
  6.69670084631925899287807624205015599727630615234375e-02, // 0.500000
  8.75564634445191447564837972095119766891002655029297e-02, // 0.600000
  1.13431849434786694019727804061403730884194374084473e-01, // 0.700000
  1.48660077479215418927438463470025453716516494750977e-01, // 0.800000
  2.05671765275718482213207494169182609766721725463867e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_1_01 = { //
  1.00000000009000014622451146806270116940140724182129e-01, // 0.000000
  1.00000900008550108744032058893935754895210266113281e-01, // 0.000010
  1.09946584245134940105437237889418611302971839904785e-01, // 0.100000
  1.12591074283269546030261665237048873677849769592285e-01, // 0.123457
  1.22241596067866081787300913674698676913976669311523e-01, // 0.200000
  1.33042231439480740373682010613265447318553924560547e-01, // 0.271828
  1.37851585017116834430694893853797111660242080688477e-01, // 0.300000
  1.40410327292290693090848208157694898545742034912109e-01, // 0.314159
  1.58366702750946081179606039768259506672620773315430e-01, // 0.400000
  1.86606598307361509769819463144813198596239089965820e-01, // 0.500000
  2.28110884138870234627560762419307138770818710327148e-01, // 0.600000
  2.95522716855071143626787488756235688924789428710938e-01, // 0.700000
  4.25669961260392526458673501110752113163471221923828e-01, // 0.800000
  7.94328234724281823098124277748866006731986999511719e-01, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_1_01 = { //
  1.00000000004500001884827449082177529791903847211643e-11, // 0.000000
  1.00000450002850030242014436193676019115628150757402e-06, // 0.000010
  1.04807417937856067052804220907091803383082151412964e-02, // 0.100000
  1.30904819719778325870507273975817952305078506469727e-02, // 0.123457
  2.20672314570714879489177207005923264659941196441650e-02, // 0.200000
  3.12239657447887335173231093676804448477923870086670e-02, // 0.271828
  3.50389048801823740908467641474999254569411277770996e-02, // 0.300000
  3.70087797866951451197792266611941158771514892578125e-02, // 0.314159
  4.97997834943235961890906082771834917366504669189453e-02, // 0.400000
  6.69670084631925344176295311626745387911796569824219e-02, // 0.500000
  8.75564634445190614897569503227714449167251586914062e-02, // 0.600000
  1.13431849434786791164242458762601017951965332031250e-01, // 0.700000
  1.48660077479215502194165310356765985488891601562500e-01, // 0.800000
  2.05671765275718620991085572313750162720680236816406e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_1_01 = { //
  1.00000000009000028500238954620726872235536575317383e-01, // 0.000000
  1.00000900008550108744032058893935754895210266113281e-01, // 0.000010
  1.09946584245134940105437237889418611302971839904785e-01, // 0.100000
  1.12591074283269559908049473051505628973245620727539e-01, // 0.123457
  1.22241596067866095665088721489155432209372520446777e-01, // 0.200000
  1.33042231439496422273904840949398931115865707397461e-01, // 0.271828
  1.37851585017116834430694893853797111660242080688477e-01, // 0.300000
  1.40410327292294495604707549318845849484205245971680e-01, // 0.314159
  1.58366702750946108935181655397173017263412475585938e-01, // 0.400000
  1.86606598307361537525395078773726709187030792236328e-01, // 0.500000
  2.28110884138870234627560762419307138770818710327148e-01, // 0.600000
  2.95522716855071199137938720014062710106372833251953e-01, // 0.700000
  4.25669961260392470947522269852925091981887817382812e-01, // 0.800000
  7.94328234724281934120426740264520049095153808593750e-01, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_1_05 = { //
  5.00000000012500009741482020021919761496032030834158e-11, // 0.000000
  5.00001250006250130353616101253066972276428714394569e-06, // 0.000010
  5.13167019494862042261473789039882831275463104248047e-02, // 0.100000
  6.37610881831496972838024817065161187201738357543945e-02, // 0.123457
  1.05572809000084130715002572742378106340765953063965e-01, // 0.200000
  1.46670159226752749859201685467269271612167358398438e-01, // 0.271828
  1.63339973465924465090282069468230474740266799926758e-01, // 0.300000
  1.71844981515525241366759701122646220028400421142578e-01, // 0.314159
  2.25403330758516595722085185116156935691833496093750e-01, // 0.400000
  2.92893218813452427262689070630585774779319763183594e-01, // 0.500000
  3.67544467966324062135896610925556160509586334228516e-01, // 0.600000
  4.52277442494833814556898232694948092103004455566406e-01, // 0.700000
  5.52786404500041905762941496504936367273330688476562e-01, // 0.800000
  6.83772233983161559223162839771248400211334228515625e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_1_05 = { //
  5.00000000025000113090811737492913380265235900878906e-01, // 0.000000
  5.00002500018750239973996940534561872482299804687500e-01, // 0.000010
  5.27046276694730031486813004448777064681053161621094e-01, // 0.100000
  5.34051718732463376326791149040218442678451538085938e-01, // 0.123457
  5.59016994374947562285171898111002519726753234863281e-01, // 0.200000
  5.85939898160509287095010222401469945907592773437500e-01, // 0.271828
  5.97614304667197004938827831210801377892494201660156e-01, // 0.300000
  6.03751699669707986295463797432603314518928527832031e-01, // 0.314159
  6.45497224367902910913130654080305248498916625976562e-01, // 0.400000
  7.07106781186547683759613391885068267583847045898438e-01, // 0.500000
  7.90569415042094880696765812899684533476829528808594e-01, // 0.600000
  9.12870929175276901723634637164650484919548034667969e-01, // 0.700000
  1.11803398874989512457034379622200503945350646972656e+00, // 0.800000
  1.58113883008418998343813655083067715167999267578125e+00, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_1_05 = { //
  5.00000000012500009741482020021919761496032030834158e-11, // 0.000000
  5.00001250006250130353616101253066972276428714394569e-06, // 0.000010
  5.13167019494862042261473789039882831275463104248047e-02, // 0.100000
  6.37610881831496972838024817065161187201738357543945e-02, // 0.123457
  1.05572809000084130715002572742378106340765953063965e-01, // 0.200000
  1.46670159226808705099642793356906622648239135742188e-01, // 0.271828
  1.63339973465924409579130838210403453558683395385742e-01, // 0.300000
  1.71844981515537759131362349762639496475458145141602e-01, // 0.314159
  2.25403330758516567966509569487243425101041793823242e-01, // 0.400000
  2.92893218813452260729235376857104711234569549560547e-01, // 0.500000
  3.67544467966324117647047842183383181691169738769531e-01, // 0.600000
  4.52277442494833814556898232694948092103004455566406e-01, // 0.700000
  5.52786404500042127807546421536244451999664306640625e-01, // 0.800000
  6.83772233983162114334675152349518612027168273925781e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_1_05 = { //
  5.00000000025000002068509274977259337902069091796875e-01, // 0.000000
  5.00002500018750128951694478018907830119132995605469e-01, // 0.000010
  5.27046276694729920464510541933123022317886352539062e-01, // 0.100000
  5.34051718732463265304488686524564400315284729003906e-01, // 0.123457
  5.59016994374947451262869435595348477363586425781250e-01, // 0.200000
  5.85939898160547589789359790302114561200141906738281e-01, // 0.271828
  5.97614304667196782894222906179493293166160583496094e-01, // 0.300000
  6.03751699669717090124265723716234788298606872558594e-01, // 0.314159
  6.45497224367902799890828191564651206135749816894531e-01, // 0.400000
  7.07106781186547572737310929369414225220680236816406e-01, // 0.500000
  7.90569415042094769674463350384030491113662719726562e-01, // 0.600000
  9.12870929175276790701332174648996442556381225585938e-01, // 0.700000
  1.11803398874989490252573887119069695472717285156250e+00, // 0.800000
  1.58113883008418998343813655083067715167999267578125e+00, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_1_1 = { //
  1.00000000000000003643219731549774157916554706559964e-10, // 0.000000
  1.00000000000000008180305391403130954586231382563710e-05, // 0.000010
  1.00000000000000005551115123125782702118158340454102e-01, // 0.100000
  1.23456700000000002548361521803599316626787185668945e-01, // 0.123457
  2.00000000000000011102230246251565404236316680908203e-01, // 0.200000
  2.71828182845904486875099337339634075760841369628906e-01, // 0.271828
  2.99999999999999988897769753748434595763683319091797e-01, // 0.300000
  3.14159265358979311599796346854418516159057617187500e-01, // 0.314159
  4.00000000000000022204460492503130808472633361816406e-01, // 0.400000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.500000
  5.99999999999999977795539507496869191527366638183594e-01, // 0.600000
  6.99999999999999955591079014993738383054733276367188e-01, // 0.700000
  8.00000000000000044408920985006261616945266723632812e-01, // 0.800000
  9.00000000000000022204460492503130808472633361816406e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_1_1 = { //
  1.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  1.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  1.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  1.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  1.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_1_1 = { //
  9.99999999999999648691285181266018983192722657804552e-11, // 0.000000
  9.99999999999999742989875012311173918533313553780317e-06, // 0.000010
  1.00000000000000019428902930940239457413554191589355e-01, // 0.100000
  1.23456699999999974792785906174685806035995483398438e-01, // 0.123457
  2.00000000000000011102230246251565404236316680908203e-01, // 0.200000
  2.71828182846000021566368332059937529265880584716797e-01, // 0.271828
  2.99999999999999988897769753748434595763683319091797e-01, // 0.300000
  3.14159265359000017259205606023897416889667510986328e-01, // 0.314159
  4.00000000000000022204460492503130808472633361816406e-01, // 0.400000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.500000
  5.99999999999999977795539507496869191527366638183594e-01, // 0.600000
  6.99999999999999955591079014993738383054733276367188e-01, // 0.700000
  8.00000000000000044408920985006261616945266723632812e-01, // 0.800000
  9.00000000000000022204460492503130808472633361816406e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_1_1 = { //
  1.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  1.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  1.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  1.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  1.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_1_2 = { //
  1.99999999990000014066132773281109138302502614692457e-10, // 0.000000
  1.99999000000000014167899492489866020150657277554274e-05, // 0.000010
  1.90000000000000002220446049250313080847263336181641e-01, // 0.100000
  2.31671843225110002384425911259313579648733139038086e-01, // 0.123457
  3.60000000000000042188474935755948536098003387451172e-01, // 0.200000
  4.69765804702502509648809336795238777995109558105469e-01, // 0.271828
  5.10000000000000008881784197001252323389053344726562e-01, // 0.300000
  5.29622486707065021072082799946656450629234313964844e-01, // 0.314159
  6.40000000000000124344978758017532527446746826171875e-01, // 0.400000
  7.50000000000000000000000000000000000000000000000000e-01, // 0.500000
  8.39999999999999968913755310495616868138313293457031e-01, // 0.600000
  9.09999999999999920063942226988729089498519897460938e-01, // 0.700000
  9.59999999999999964472863211994990706443786621093750e-01, // 0.800000
  9.89999999999999991118215802998747676610946655273438e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_1_2 = { //
  1.99999999979999998345192580018192529678344726562500e+00, // 0.000000
  1.99998000000000009102052445086883381009101867675781e+00, // 0.000010
  1.80000000000000004440892098500626161694526672363281e+00, // 0.100000
  1.75308660000000005041442818765062838792800903320312e+00, // 0.123457
  1.60000000000000008881784197001252323389053344726562e+00, // 0.200000
  1.45634363430819102624980132532073184847831726074219e+00, // 0.271828
  1.39999999999999991118215802998747676610946655273438e+00, // 0.300000
  1.37168146928204137680040730629116296768188476562500e+00, // 0.314159
  1.19999999999999995559107901499373838305473327636719e+00, // 0.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  8.00000000000000044408920985006261616945266723632812e-01, // 0.600000
  6.00000000000000088817841970012523233890533447265625e-01, // 0.700000
  3.99999999999999911182158029987476766109466552734375e-01, // 0.800000
  1.99999999999999955591079014993738383054733276367188e-01, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_1_2 = { //
  1.99999999989999600475826496767271702598156579711031e-10, // 0.000000
  1.99998999999999980286581602317852457417757250368595e-05, // 0.000010
  1.89999999999999502620084967929869890213012695312500e-01, // 0.100000
  2.31671843225110141162303989403881132602691650390625e-01, // 0.123457
  3.59999999999999764632718779466813430190086364746094e-01, // 0.200000
  4.69765804702641842638399793941061943769454956054688e-01, // 0.271828
  5.10000000000000008881784197001252323389053344726562e-01, // 0.300000
  5.29622486707093331759210741438437253236770629882812e-01, // 0.314159
  6.40000000000000013322676295501878485083580017089844e-01, // 0.400000
  7.50000000000000000000000000000000000000000000000000e-01, // 0.500000
  8.39999999999999968913755310495616868138313293457031e-01, // 0.600000
  9.09999999999999920063942226988729089498519897460938e-01, // 0.700000
  9.59999999999999964472863211994990706443786621093750e-01, // 0.800000
  9.89999999999999991118215802998747676610946655273438e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_1_2 = { //
  1.99999999979999998345192580018192529678344726562500e+00, // 0.000000
  1.99998000000000009102052445086883381009101867675781e+00, // 0.000010
  1.79999999999999982236431605997495353221893310546875e+00, // 0.100000
  1.75308660000000005041442818765062838792800903320312e+00, // 0.123457
  1.59999999999999986677323704498121514916419982910156e+00, // 0.200000
  1.45634363430799984584496087336447089910507202148438e+00, // 0.271828
  1.40000000000000013322676295501878485083580017089844e+00, // 0.300000
  1.37168146928199985445928632543655112385749816894531e+00, // 0.314159
  1.19999999999999995559107901499373838305473327636719e+00, // 0.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  8.00000000000000044408920985006261616945266723632812e-01, // 0.600000
  6.00000000000000088817841970012523233890533447265625e-01, // 0.700000
  3.99999999999999966693309261245303787291049957275391e-01, // 0.800000
  1.99999999999999983346654630622651893645524978637695e-01, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_1_4 = { //
  3.99999999940000003552250502724231887019534781302355e-10, // 0.000000
  3.99994000039999964652912001206175318657187744975090e-05, // 0.000010
  3.43900000000000038991032624835497699677944183349609e-01, // 0.100000
  4.09671843506900057452213559372466988861560821533203e-01, // 0.123457
  5.90400000000000035882408155885059386491775512695312e-01, // 0.200000
  7.18851698137215278094913628592621535062789916992188e-01, // 0.271828
  7.59900000000000019895196601282805204391479492187500e-01, // 0.300000
  7.78744994988354810594444188609486445784568786621094e-01, // 0.314159
  8.70400000000000062527760746888816356658935546875000e-01, // 0.400000
  9.37500000000000000000000000000000000000000000000000e-01, // 0.500000
  9.74400000000000043876013933186186477541923522949219e-01, // 0.600000
  9.91900000000000003907985046680551022291183471679688e-01, // 0.700000
  9.98399999999999954169993543473538011312484741210938e-01, // 0.800000
  9.99900000000000011013412404281552881002426147460938e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_1_4 = { //
  3.99999999879999990071155480109155178070068359375000e+00, // 0.000000
  3.99988000119999664860870325355790555477142333984375e+00, // 0.000010
  2.91600000000000036948222259525209665298461914062500e+00, // 0.100000
  2.69389159208951811663723674428183585405349731445312e+00, // 0.123457
  2.04800000000000048672177399566862732172012329101562e+00, // 0.200000
  1.54440639002807333923783517093397676944732666015625e+00, // 0.271828
  1.37199999999999966426855735335266217589378356933594e+00, // 0.300000
  1.29041623710177200123894181160721927881240844726562e+00, // 0.314159
  8.63999999999999879207734920782968401908874511718750e-01, // 0.400000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.500000
  2.56000000000000060840221749458578415215015411376953e-01, // 0.600000
  1.08000000000000054289905904170154826715588569641113e-01, // 0.700000
  3.19999999999999798494521030534087913110852241516113e-02, // 0.800000
  3.99999999999999748118151288167609891388565301895142e-03, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_1_4 = { //
  3.99999999939999900154673933595772528093448272556998e-10, // 0.000000
  3.99994000039999896890276220862148193191387690603733e-05, // 0.000010
  3.43899999999999872457578931062016636133193969726562e-01, // 0.100000
  4.09671843506900223985667253145948052406311035156250e-01, // 0.123457
  5.90399999999999813837803230853751301765441894531250e-01, // 0.200000
  7.18851698137362937757188774412497878074645996093750e-01, // 0.271828
  7.59900000000000019895196601282805204391479492187500e-01, // 0.300000
  7.78744994988381455947035192366456612944602966308594e-01, // 0.314159
  8.70400000000000062527760746888816356658935546875000e-01, // 0.400000
  9.37500000000000000000000000000000000000000000000000e-01, // 0.500000
  9.74399999999999932853711470670532435178756713867188e-01, // 0.600000
  9.91900000000000003907985046680551022291183471679688e-01, // 0.700000
  9.98399999999999954169993543473538011312484741210938e-01, // 0.800000
  9.99900000000000011013412404281552881002426147460938e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_1_4 = { //
  3.99999999879999990071155480109155178070068359375000e+00, // 0.000000
  3.99988000119999531634107370337005704641342163085938e+00, // 0.000010
  2.91600000000000036948222259525209665298461914062500e+00, // 0.100000
  2.69389159208951767254802689421921968460083007812500e+00, // 0.123457
  2.04799999999999959854335429554339498281478881835938e+00, // 0.200000
  1.54440639002746538110955043521244078874588012695312e+00, // 0.271828
  1.37200000000000033040237212844658643007278442382812e+00, // 0.300000
  1.29041623710165476168754139507655054330825805664062e+00, // 0.314159
  8.63999999999999879207734920782968401908874511718750e-01, // 0.400000
  5.00000000000000111022302462515654042363166809082031e-01, // 0.500000
  2.56000000000000060840221749458578415215015411376953e-01, // 0.600000
  1.08000000000000054289905904170154826715588569641113e-01, // 0.700000
  3.19999999999999937272399108678655466064810752868652e-02, // 0.800000
  3.99999999999999834854325087007964611984789371490479e-03, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_2_01 = { //
  5.50000000033000091061882744625813924005303568789147e-22, // 0.000000
  5.50003300023512856945298627756354276335110098372638e-12, // 0.000010
  5.85549211723463618010920850309730667504481971263885e-04, // 0.100000
  9.06422742544821247179243073333054780960083007812500e-04, // 0.123457
  2.50857608621292025793958480051060178084298968315125e-03, // 0.200000
  4.88990284715010506411125845716014737263321876525879e-03, // 0.271828
  6.09007202658786231386223164463444845750927925109863e-03, // 0.300000
  6.75551835775626500352197822962807549629360437393188e-03, // 0.314159
  1.17917748340965571063332362200526404194533824920654e-02, // 0.400000
  2.03153588863522159557728485879124491475522518157959e-02, // 0.500000
  3.28098512511902778987504802898911293596029281616211e-02, // 0.600000
  5.13720788952217247147480350122350500896573066711426e-02, // 0.700000
  8.05528836775526307922845603570749517530202865600586e-02, // 0.800000
  1.34182224150533185857980811306333635002374649047852e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_2_01 = { //
  1.10000000009900018879889436430572250639331466359749e-11, // 0.000000
  1.10000990009405111972099443329309309547170414589345e-06, // 0.000010
  1.20941242669648438279317304022697499021887779235840e-02, // 0.100000
  1.52901347285140567361372276877773401793092489242554e-02, // 0.123457
  2.68931511349305395197628598680239520035684108734131e-02, // 0.200000
  3.97810908153541434306710300461418228223919868469238e-02, // 0.271828
  4.54910230556485536967947780340182362124323844909668e-02, // 0.300000
  4.85223257980558694835160338243440492078661918640137e-02, // 0.314159
  6.96813492104162851559223668118647765368223190307617e-02, // 0.400000
  1.02633629069048826210064362385310232639312744140625e-01, // 0.500000
  1.50553183531654338755956246131972875446081161499023e-01, // 0.600000
  2.27552491978404769490396120090736076235771179199219e-01, // 0.700000
  3.74589565909145438826755025729653425514698028564453e-01, // 0.800000
  7.86384952377038870530157055327435955405235290527344e-01, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_2_01 = { //
  5.50000000033000185101430810408814561504226546568802e-22, // 0.000000
  5.50003300023513099283368711651180898818125353244568e-12, // 0.000010
  5.85549211723463618010920850309730667504481971263885e-04, // 0.100000
  9.06422742544820921918591327681724578724242746829987e-04, // 0.123457
  2.50857608621292025793958480051060178084298968315125e-03, // 0.200000
  4.88990284715390410852364766469690948724746704101562e-03, // 0.271828
  6.09007202658786057913875566782735404558479785919189e-03, // 0.300000
  6.75551835775727114313804477774283441249281167984009e-03, // 0.314159
  1.17917748340965536368862842664384515956044197082520e-02, // 0.400000
  2.03153588863522090168789446806840714998543262481689e-02, // 0.500000
  3.28098512511902501431748646609776187688112258911133e-02, // 0.600000
  5.13720788952216692035968037544080289080739021301270e-02, // 0.700000
  8.05528836775526863034357916149019729346036911010742e-02, // 0.800000
  1.34182224150533130346829580048506613820791244506836e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_2_01 = { //
  1.10000000009900018879889436430572250639331466359749e-11, // 0.000000
  1.10000990009405090796275761971800832839107897598296e-06, // 0.000010
  1.20941242669648507668256343094981275498867034912109e-02, // 0.100000
  1.52901347285140602055841796413915290031582117080688e-02, // 0.123457
  2.68931511349305464586567637752523296512663364410400e-02, // 0.200000
  3.97810908153728159941664443977060727775096893310547e-02, // 0.271828
  4.54910230556485467579008741267898585647344589233398e-02, // 0.300000
  4.85223257980603936423413813372462755069136619567871e-02, // 0.314159
  6.96813492104162851559223668118647765368223190307617e-02, // 0.400000
  1.02633629069048826210064362385310232639312744140625e-01, // 0.500000
  1.50553183531654338755956246131972875446081161499023e-01, // 0.600000
  2.27552491978404769490396120090736076235771179199219e-01, // 0.700000
  3.74589565909145383315603794471826404333114624023438e-01, // 0.800000
  7.86384952377038981552459517843089997768402099609375e-01, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_2_05 = { //
  3.75000000012500073511663321748728148736677675747611e-21, // 0.000000
  3.75001250007031431176997547885672810996648962600375e-11, // 0.000010
  3.88253704696051200884188148165776510722935199737549e-03, // 0.100000
  5.96860495090002600437895097229556995443999767303467e-03, // 0.123457
  1.61300899000925389292770972815560526214540004730225e-02, // 0.200000
  3.06906092339643381261549137661859276704490184783936e-02, // 0.271828
  3.78409694858131209760365720740082906559109687805176e-02, // 0.300000
  4.17586954103080082445487164477526675909757614135742e-02, // 0.314159
  7.04839969102199759287685765229980461299419403076172e-02, // 0.400000
  1.16116523516815603467300377360515994951128959655762e-01, // 0.500000
  1.77807808356221369594507564215746242552995681762695e-01, // 0.600000
  2.60574547368025710714078968521789647638797760009766e-01, // 0.700000
  3.73900966300058923419413758892915211617946624755859e-01, // 0.800000
  5.41469739275584838189558922749711200594902038574219e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_2_05 = { //
  7.50000000037500098835526107000383749107141895251516e-11, // 0.000000
  7.50003750028125248017121101673509997453948017209768e-06, // 0.000010
  7.90569415042094991719068275415338575839996337890625e-02, // 0.100000
  9.88983942360571466334562273914343677461147308349609e-02, // 0.123457
  1.67705098312484257583321323181735351681709289550781e-01, // 0.200000
  2.38912466660828326503462903929175809025764465332031e-01, // 0.271828
  2.68926437100238613364666662164381705224514007568359e-01, // 0.300000
  2.84511285641205868834902048547519370913505554199219e-01, // 0.314159
  3.87298334620741757650108638699748553335666656494141e-01, // 0.400000
  5.30330085889910707308558812655974179506301879882812e-01, // 0.500000
  7.11512473537885270502556522842496633529663085937500e-01, // 0.600000
  9.58514475634040685747550014639273285865783691406250e-01, // 0.700000
  1.34164078649987406066657058545388281345367431640625e+00, // 0.800000
  2.13453742061365625559687941859010607004165649414062e+00, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_2_05 = { //
  3.75000000012498794573809627099919478751325177944313e-21, // 0.000000
  3.75001250007031495800482903590959910325453030566223e-11, // 0.000010
  3.88253704696051200884188148165776510722935199737549e-03, // 0.100000
  5.96860495090002253493199901868138113059103488922119e-03, // 0.123457
  1.61300899000925389292770972815560526214540004730225e-02, // 0.200000
  3.06906092339871497398640087794774444773793220520020e-02, // 0.271828
  3.78409694858131001593548603523231577128171920776367e-02, // 0.300000
  4.17586954103138993654731336846452904865145683288574e-02, // 0.314159
  7.04839969102199342954051530796277802437543869018555e-02, // 0.400000
  1.16116523516815506322785722659318707883358001708984e-01, // 0.500000
  1.77807808356221147549902639184438157826662063598633e-01, // 0.600000
  2.60574547368025322136020349717000499367713928222656e-01, // 0.700000
  3.73900966300058978930564990150742232799530029296875e-01, // 0.800000
  5.41469739275584949211861385265365242958068847656250e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_2_05 = { //
  7.50000000037501132811291798284977338368006982705083e-11, // 0.000000
  7.50003750028124570390763298233238742795947473496199e-06, // 0.000010
  7.90569415042094991719068275415338575839996337890625e-02, // 0.100000
  9.88983942360571466334562273914343677461147308349609e-02, // 0.123457
  1.67705098312484229827745707552821841090917587280273e-01, // 0.200000
  2.38912466660927941264347396099765319377183914184570e-01, // 0.271828
  2.68926437100238502342364199648727662861347198486328e-01, // 0.300000
  2.84511285641228850451511789287906140089035034179688e-01, // 0.314159
  3.87298334620741702138957407441921532154083251953125e-01, // 0.400000
  5.30330085889910596286256350140320137143135070800781e-01, // 0.500000
  7.11512473537885270502556522842496633529663085937500e-01, // 0.600000
  9.58514475634040463702945089607965201139450073242188e-01, // 0.700000
  1.34164078649987383862196566042257472872734069824219e+00, // 0.800000
  2.13453742061365581150766956852748990058898925781250e+00, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_2_1 = { //
  1.00000000000000009561654835946237267172778046723484e-20, // 0.000000
  1.00000000000000016567916802690831577782315520153134e-10, // 0.000010
  1.00000000000000019428902930940239457413554191589355e-02, // 0.100000
  1.52415567748900009775736563710779591929167509078979e-02, // 0.123457
  4.00000000000000077715611723760957829654216766357422e-02, // 0.200000
  7.38905609893064779791771456984861288219690322875977e-02, // 0.271828
  8.99999999999999966693309261245303787291049957275391e-02, // 0.300000
  9.86960440108935743719342781332670710980892181396484e-02, // 0.314159
  1.60000000000000031086244689504383131861686706542969e-01, // 0.400000
  2.50000000000000000000000000000000000000000000000000e-01, // 0.500000
  3.59999999999999986677323704498121514916419982910156e-01, // 0.600000
  4.89999999999999935607064571740920655429363250732422e-01, // 0.700000
  6.40000000000000124344978758017532527446746826171875e-01, // 0.800000
  8.10000000000000053290705182007513940334320068359375e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_2_1 = { //
  2.00000000000000007286439463099548315833109413119928e-10, // 0.000000
  2.00000000000000016360610782806261909172462765127420e-05, // 0.000010
  2.00000000000000011102230246251565404236316680908203e-01, // 0.100000
  2.46913400000000005096723043607198633253574371337891e-01, // 0.123457
  4.00000000000000022204460492503130808472633361816406e-01, // 0.200000
  5.43656365691808973750198674679268151521682739257812e-01, // 0.271828
  5.99999999999999977795539507496869191527366638183594e-01, // 0.300000
  6.28318530717958623199592693708837032318115234375000e-01, // 0.314159
  8.00000000000000044408920985006261616945266723632812e-01, // 0.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.19999999999999995559107901499373838305473327636719e+00, // 0.600000
  1.39999999999999991118215802998747676610946655273438e+00, // 0.700000
  1.60000000000000008881784197001252323389053344726562e+00, // 0.800000
  1.80000000000000004440892098500626161694526672363281e+00, // 0.900000
  2.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_2_1 = { //
  1.00000000000000114885948669623197981171571781836697e-20, // 0.000000
  9.99999999999997968480665932928554400643816890692506e-11, // 0.000010
  1.00000000000000054123372450476381345652043819427490e-02, // 0.100000
  1.52415567748899975081267044174637703690677881240845e-02, // 0.123457
  4.00000000000000077715611723760957829654216766357422e-02, // 0.200000
  7.38905609893584225389417952101211994886398315429688e-02, // 0.271828
  8.99999999999999827915431183100736234337091445922852e-02, // 0.300000
  9.86960440109066056146858159081602934747934341430664e-02, // 0.314159
  1.60000000000000003330669073875469621270895004272461e-01, // 0.400000
  2.50000000000000000000000000000000000000000000000000e-01, // 0.500000
  3.59999999999999986677323704498121514916419982910156e-01, // 0.600000
  4.89999999999999935607064571740920655429363250732422e-01, // 0.700000
  6.40000000000000235367281220533186569809913635253906e-01, // 0.800000
  8.10000000000000053290705182007513940334320068359375e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_2_1 = { //
  1.99999999999999593696133186585710880128763378138501e-10, // 0.000000
  1.99999999999999982479292892634248346439562737941742e-05, // 0.000010
  2.00000000000000066613381477509392425417900085449219e-01, // 0.100000
  2.46913399999999977341147427978285122662782669067383e-01, // 0.123457
  4.00000000000000022204460492503130808472633361816406e-01, // 0.200000
  5.43656365692000043132736664119875058531761169433594e-01, // 0.271828
  5.99999999999999866773237044981215149164199829101562e-01, // 0.300000
  6.28318530718000034518411212047794833779335021972656e-01, // 0.314159
  8.00000000000000044408920985006261616945266723632812e-01, // 0.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.19999999999999995559107901499373838305473327636719e+00, // 0.600000
  1.39999999999999991118215802998747676610946655273438e+00, // 0.700000
  1.60000000000000008881784197001252323389053344726562e+00, // 0.800000
  1.80000000000000004440892098500626161694526672363281e+00, // 0.900000
  2.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_2_2 = { //
  2.99999999980000028621542970819290774575628845094157e-20, // 0.000000
  2.99998000000000032546659169620955655288785379752881e-10, // 0.000010
  2.80000000000000040523140398818213725462555885314941e-02, // 0.100000
  4.19613257200888781217607004236924694851040840148926e-02, // 0.123457
  1.04000000000000022981616609740740386769175529479980e-01, // 0.200000
  1.81500609121544087543043133337050676345825195312500e-01, // 0.271828
  2.16000000000000025313084961453569121658802032470703e-01, // 0.300000
  2.34075578672081091591294921272492501884698867797852e-01, // 0.314159
  3.52000000000000090594198809412773698568344116210938e-01, // 0.400000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.500000
  6.47999999999999909405801190587226301431655883789062e-01, // 0.600000
  7.83999999999999919175763807288603857159614562988281e-01, // 0.700000
  8.96000000000000018651746813702629879117012023925781e-01, // 0.800000
  9.71999999999999975131004248396493494510650634765625e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_2_2 = { //
  5.99999999940000036688084108105895042584165821608622e-10, // 0.000000
  5.99994000000000069806882496692423956119455397129059e-05, // 0.000010
  5.40000000000000146549439250520663335919380187988281e-01, // 0.100000
  6.49290859350659999016386336734285578131675720214844e-01, // 0.123457
  9.60000000000000186517468137026298791170120239257812e-01, // 0.200000
  1.18762573113958813664225999673362821340560913085938e+00, // 0.271828
  1.26000000000000000888178419700125232338905334472656e+00, // 0.300000
  1.29277932808851447887832364358473569154739379882812e+00, // 0.314159
  1.43999999999999994670929481799248605966567993164062e+00, // 0.400000
  1.50000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.43999999999999994670929481799248605966567993164062e+00, // 0.600000
  1.26000000000000023092638912203256040811538696289062e+00, // 0.700000
  9.59999999999999853450560749479336664080619812011719e-01, // 0.800000
  5.39999999999999924504834325489355251193046569824219e-01, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_2_2 = { //
  2.99999999979999607324367636111447918580453904641306e-20, // 0.000000
  2.99997999999999722353929462235577578510525853516810e-10, // 0.000010
  2.80000000000000109912079437890497501939535140991211e-02, // 0.100000
  4.19613257200888642439728926092357141897082328796387e-02, // 0.123457
  1.04000000000000022981616609740740386769175529479980e-01, // 0.200000
  1.81500609121657580091735439964395482093095779418945e-01, // 0.271828
  2.15999999999999942046358114566828589886426925659180e-01, // 0.300000
  2.34075578672107875721764003174030221998691558837891e-01, // 0.314159
  3.52000000000000035083047578154946677386760711669922e-01, // 0.400000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.500000
  6.47999999999999909405801190587226301431655883789062e-01, // 0.600000
  7.84000000000000030198066269804257899522781372070312e-01, // 0.700000
  8.96000000000000018651746813702629879117012023925781e-01, // 0.800000
  9.71999999999999975131004248396493494510650634765625e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_2_2 = { //
  5.99999999940000553675966953748191837214598365335405e-10, // 0.000000
  5.99993999999999459943160473596179826927254907786846e-05, // 0.000010
  5.40000000000000035527136788005009293556213378906250e-01, // 0.100000
  6.49290859350659776971781411702977493405342102050781e-01, // 0.123457
  9.60000000000000075495165674510644748806953430175781e-01, // 0.200000
  1.18762573113984970518686168361455202102661132812500e+00, // 0.271828
  1.26000000000000000888178419700125232338905334472656e+00, // 0.300000
  1.29277932808856044211154312506550922989845275878906e+00, // 0.314159
  1.44000000000000016875389974302379414439201354980469e+00, // 0.400000
  1.50000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.44000000000000016875389974302379414439201354980469e+00, // 0.600000
  1.26000000000000000888178419700125232338905334472656e+00, // 0.700000
  9.59999999999999853450560749479336664080619812011719e-01, // 0.800000
  5.39999999999999813482531862973701208829879760742188e-01, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_2_4 = { //
  9.99999999800000094982332989268162402300727516471889e-20, // 0.000000
  9.99980000149999789015279420541053301274558862132835e-10, // 0.000010
  8.14600000000000185051973744521092157810926437377930e-02, // 0.100000
  1.18151979036013266011195810278877615928649902343750e-01, // 0.123457
  2.62720000000000009077183449335279874503612518310547e-01, // 0.200000
  4.13155570114924819424828683622763492166996002197266e-01, // 0.271828
  4.71779999999999921644899814054952003061771392822266e-01, // 0.300000
  5.00707755662531783791280304285464808344841003417969e-01, // 0.314159
  6.63040000000000073754335971898399293422698974609375e-01, // 0.400000
  8.12500000000000000000000000000000000000000000000000e-01, // 0.500000
  9.12959999999999993747223925311118364334106445312500e-01, // 0.600000
  9.69219999999999970441422192379832267761230468750000e-01, // 0.700000
  9.93280000000000051763038300123298540711402893066406e-01, // 0.800000
  9.99539999999999984048315582185750827193260192871094e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_2_4 = { //
  1.99999999939999970416416897342568731454903740996087e-09, // 0.000000
  1.99994000059999853073644526801899701240472495555878e-04, // 0.000010
  1.45799999999999996269650637259474024176597595214844e+00, // 0.100000
  1.66289483058558995587361550860805436968803405761719e+00, // 0.123457
  2.04800000000000048672177399566862732172012329101562e+00, // 0.200000
  2.09906591288467181399823857645969837903976440429688e+00, // 0.271828
  2.05799999999999938538053356751333922147750854492188e+00, // 0.300000
  2.02698108527595532990517313010059297084808349609375e+00, // 0.314159
  1.72799999999999975841546984156593680381774902343750e+00, // 0.400000
  1.25000000000000000000000000000000000000000000000000e+00, // 0.500000
  7.68000000000000127009514017117908224463462829589844e-01, // 0.600000
  3.78000000000000113686837721616029739379882812500000e-01, // 0.700000
  1.27999999999999919397808412213635165244340896606445e-01, // 0.800000
  1.79999999999999882316359389733406715095043182373047e-02, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_2_4 = { //
  9.99999999799998650534874698841272610317270577776400e-20, // 0.000000
  9.99980000149998548244360590999540994161520757188555e-10, // 0.000010
  8.14600000000000601385607978954794816672801971435547e-02, // 0.100000
  1.18151979036013293766771425907791126519441604614258e-01, // 0.123457
  2.62720000000000064588334680593106895685195922851562e-01, // 0.200000
  4.13155570115125381214227218151791021227836608886719e-01, // 0.271828
  4.71779999999999810622597351539297960698604583740234e-01, // 0.300000
  5.00707755662573861243913597718346863985061645507812e-01, // 0.314159
  6.63040000000000073754335971898399293422698974609375e-01, // 0.400000
  8.12500000000000000000000000000000000000000000000000e-01, // 0.500000
  9.12959999999999993747223925311118364334106445312500e-01, // 0.600000
  9.69219999999999970441422192379832267761230468750000e-01, // 0.700000
  9.93279999999999940740735837607644498348236083984375e-01, // 0.800000
  9.99539999999999984048315582185750827193260192871094e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_2_4 = { //
  1.99999999940000135852539407948103705736642154988658e-09, // 0.000000
  1.99994000059999527812992781150569499004632234573364e-04, // 0.000010
  1.45799999999999996269650637259474024176597595214844e+00, // 0.100000
  1.66289483058558951178440565854543820023536682128906e+00, // 0.123457
  2.04799999999999959854335429554339498281478881835938e+00, // 0.200000
  2.09906591288458299615626856393646448850631713867188e+00, // 0.271828
  2.05799999999999938538053356751333922147750854492188e+00, // 0.300000
  2.02698108527590559191366992308758199214935302734375e+00, // 0.314159
  1.72799999999999998046007476659724488854408264160156e+00, // 0.400000
  1.25000000000000000000000000000000000000000000000000e+00, // 0.500000
  7.67999999999999904964909092086600139737129211425781e-01, // 0.600000
  3.78000000000000002664535259100375697016716003417969e-01, // 0.700000
  1.27999999999999947153384027842548675835132598876953e-01, // 0.800000
  1.79999999999999847621889870197264826856553554534912e-02, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_4_01 = { //
  2.98375000021482896530143510253419751265415869320405e-42, // 0.000000
  2.98377148317007480476821711655106704510022866858290e-22, // 0.000010
  3.21712826910625692496299710132490190517273731529713e-06, // 0.100000
  7.61463101593263861873502745813979686317907180637121e-06, // 0.123457
  5.59207027072549877851938282535826374441967345774174e-05, // 0.200000
  2.03667699680023080383364786349886799143860116600990e-04, // 0.271828
  3.10437547367714518006809321093442122219130396842957e-04, // 0.300000
  3.78567315617660054768989219553532166173681616783142e-04, // 0.314159
  1.08871959537661425719556884672556407167576253414154e-03, // 0.400000
  2.99593398095022393073927347018070577178150415420532e-03, // 0.500000
  7.15558877739638343057348990328137006144970655441284e-03, // 0.600000
  1.57714915252002985113222166546620428562164306640625e-02, // 0.700000
  3.38041058520913012541697639790072571486234664916992e-02, // 0.800000
  7.65008878936773301093765553559933323413133621215820e-02, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_4_01 = { //
  1.19350000010741456808122504902637373369716469559713e-31, // 0.000000
  1.19351074160204525818413908323422939743433979524131e-16, // 0.000010
  1.31221248296568523180466447897174475656356662511826e-04, // 0.100000
  2.52854320367995155215828928518817519943695515394211e-04, // 0.123457
  1.16716275925598492353707502644510896061547100543976e-03, // 0.200000
  3.18930012206767362487047634544978791382163763046265e-03, // 0.271828
  4.44219840138407838503464830637312843464314937591553e-03, // 0.300000
  5.19602333868628314672566403942255419678986072540283e-03, // 0.314159
  1.20966822229282636169678255555481882765889167785645e-02, // 0.400000
  2.78393718849794802316921504825586453080177307128906e-02, // 0.500000
  5.88060734874641527492045156577660236507654190063477e-02, // 0.600000
  1.20978282360318822874489796959096565842628479003906e-01, // 0.700000
  2.60114994567310464645970569108612835407257080078125e-01, // 0.800000
  6.91114415396560488602517580147832632064819335937500e-01, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_4_01 = { //
  2.98375000021482960253819955551510832420631780028878e-42, // 0.000000
  2.98377148317007715575691876112608298257330311307425e-22, // 0.000010
  3.21712826910625988957831249137608864430148969404399e-06, // 0.100000
  7.61463101593263438357029118663810152156656840816140e-06, // 0.123457
  5.59207027072550148902481403911934876305167563259602e-05, // 0.200000
  2.03667699680327795403941837371064593753544613718987e-04, // 0.271828
  3.10437547367714355376483448267777021101210266351700e-04, // 0.300000
  3.78567315617767824464934278694272506982088088989258e-04, // 0.314159
  1.08871959537661447403600334382645087316632270812988e-03, // 0.400000
  2.99593398095022523178188045278602658072486519813538e-03, // 0.500000
  7.15558877739638603265870386849201167933642864227295e-03, // 0.600000
  1.57714915252002915724283127474336652085185050964355e-02, // 0.700000
  3.38041058520913290097453796079207677394151687622070e-02, // 0.800000
  7.65008878936773439871643631704500876367092132568359e-02, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_4_01 = { //
  1.19350000010741500598699515053170839736265947369592e-31, // 0.000000
  1.19351074160204328603187603070471586811292658827574e-16, // 0.000010
  1.31221248296568631600683696447617876401636749505997e-04, // 0.100000
  2.52854320367994938375394431417930718453135341405869e-04, // 0.123457
  1.16716275925598514037750952354599576210603117942810e-03, // 0.200000
  3.18930012207141325500381334734356642002239823341370e-03, // 0.271828
  4.44219840138407751767291031796958122868090867996216e-03, // 0.300000
  5.19602333868745148298673441900064062792807817459106e-03, // 0.314159
  1.20966822229282670864147775091623771004378795623779e-02, // 0.400000
  2.78393718849794941094799582970154006034135818481445e-02, // 0.500000
  5.88060734874641596880984195649944012984633445739746e-02, // 0.600000
  1.20978282360318822874489796959096565842628479003906e-01, // 0.700000
  2.60114994567310464645970569108612835407257080078125e-01, // 0.800000
  6.91114415396560599624820042663486674427986145019531e-01, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_4_05 = { //
  2.73437500010937531608195608847323954680264550128516e-41, // 0.000000
  2.73438593756836093040429464081171992743562950508136e-21, // 0.000010
  2.85111486302981175650073097926906484644860029220581e-05, // 0.100000
  6.69233684394836031601727643902677300502546131610870e-05, // 0.123457
  4.77614057594005748073884287663304348825477063655853e-04, // 0.200000
  1.68960523493624824656333949235431646229699254035950e-03, // 0.271828
  2.54437461640680739546893640579128259560093283653259e-03, // 0.300000
  3.08346021657933443485544167117495817365124821662903e-03, // 0.314159
  8.51626337090127978612930093049726565368473529815674e-03, // 0.400000
  2.22039041404772513610410555884300265461206436157227e-02, // 0.500000
  4.97355631194020056384808015081944176927208900451660e-02, // 0.600000
  1.01221515793866442822768192399962572380900382995605e-01, // 0.700000
  1.95015528100075691275705480620672460645437240600586e-01, // 0.800000
  3.73374917402259476340020682982867583632469177246094e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_4_05 = { //
  1.09375000005468786566718251296557641016341269128500e-30, // 0.000000
  1.09375546879101630526115027849392190014539904489160e-15, // 0.000010
  1.15291373026972206530804676560819643782451748847961e-03, // 0.100000
  2.19824134059588231077109199418373464141041040420532e-03, // 0.123457
  9.78279740156158365838034995931593584828078746795654e-03, // 0.200000
  2.57445069421568979717296343778798473067581653594971e-02, // 0.271828
  3.52965948694063183510571946044365176931023597717285e-02, // 0.300000
  4.09502017884755334375945778901950689032673835754395e-02, // 0.314159
  9.03696114115064286220757594492170028388500213623047e-02, // 0.400000
  1.93349510480696623604401906959537882357835769653320e-01, // 0.500000
  3.73544048607389767013842174492310732603073120117188e-01, // 0.600000
  6.84938469046824871533374334831023588776588439941406e-01, // 0.700000
  1.25219806739988270827268479479243978857994079589844e+00, // 0.800000
  2.52142232809988220409991299675311893224716186523438e+00, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_4_05 = { //
  2.73437500010936715945137109031758115893500893060072e-41, // 0.000000
  2.73438593756835415955683390443567402751317510494625e-21, // 0.000010
  2.85111486302981480581934109475028549240960273891687e-05, // 0.100000
  6.69233684394835353975369840462406045844545587897301e-05, // 0.123457
  4.77614057594005693863775663388082648452837020158768e-04, // 0.200000
  1.68960523493870678340966762220887176226824522018433e-03, // 0.271828
  2.54437461640680566074546042898418818367645144462585e-03, // 0.300000
  3.08346021658018184727345634144057839876040816307068e-03, // 0.314159
  8.51626337090127805140582495369017124176025390625000e-03, // 0.400000
  2.22039041404772374832532477739732712507247924804688e-02, // 0.500000
  4.97355631194019570662234741575957741588354110717773e-02, // 0.600000
  1.01221515793866317922677922069851774722337722778320e-01, // 0.700000
  1.95015528100075719031281096249585971236228942871094e-01, // 0.800000
  3.73374917402259698384625608014175668358802795410156e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_4_05 = { //
  1.09375000005468611404410210694423775550143357888984e-30, // 0.000000
  1.09375546879101808019818702577048407653467093116062e-15, // 0.000010
  1.15291373026972206530804676560819643782451748847961e-03, // 0.100000
  2.19824134059588057604761601737664022948592901229858e-03, // 0.123457
  9.78279740156158712782730191293012467212975025177002e-03, // 0.200000
  2.57445069421857186675595130509464070200920104980469e-02, // 0.271828
  3.52965948694062836565876750682946294546127319335938e-02, // 0.300000
  4.09502017884842486883378853690373944118618965148926e-02, // 0.314159
  9.03696114115064008665001438203034922480583190917969e-02, // 0.400000
  1.93349510480696651359977522588451392948627471923828e-01, // 0.500000
  3.73544048607389822524993405750137753784656524658203e-01, // 0.600000
  6.84938469046824760511071872315369546413421630859375e-01, // 0.700000
  1.25219806739988248622807986976113170385360717773438e+00, // 0.800000
  2.52142232809988176001070314669050276279449462890625e+00, // 0.900000
  Double.POSITIVE_INFINITY, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_4_1 = { //
  1.00000000000000013320864402483403646202733603332908e-40, // 0.000000
  1.00000000000000039654310216996797471172433399612973e-20, // 0.000010
  1.00000000000000018344700758454735023406101390719414e-04, // 0.100000
  2.32305052922195277983682948352850416995352134108543e-04, // 0.123457
  1.60000000000000029351521213527576037449762225151062e-03, // 0.200000
  5.45981500331442059364972507751190278213471174240112e-03, // 0.271828
  8.09999999999999956146190527306316653266549110412598e-03, // 0.300000
  9.74090910340024221381050040236004861071705818176270e-03, // 0.314159
  2.56000000000000046962433941644121659919619560241699e-02, // 0.400000
  6.25000000000000000000000000000000000000000000000000e-02, // 0.500000
  1.29599999999999992983390484369010664522647857666016e-01, // 0.600000
  2.40099999999999952349227783088281285017728805541992e-01, // 0.700000
  4.09600000000000075139894306630594655871391296386719e-01, // 0.800000
  6.56100000000000016520118606422329321503639221191406e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_4_1 = { //
  4.00000000000000033334568243034394140372534410747462e-30, // 0.000000
  4.00000000000000109968250472765612236495730768756629e-15, // 0.000010
  4.00000000000000095062846483529028773773461580276489e-03, // 0.100000
  7.52668920916224962192053737908281618729233741760254e-03, // 0.123457
  3.20000000000000076050277186823223019018769264221191e-02, // 0.200000
  8.03421476927506372778253762589883990585803985595703e-02, // 0.271828
  1.07999999999999984900966865097871050238609313964844e-01, // 0.300000
  1.24025106721199263049015826254617422819137573242188e-01, // 0.314159
  2.56000000000000060840221749458578415215015411376953e-01, // 0.400000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.500000
  8.63999999999999879207734920782968401908874511718750e-01, // 0.600000
  1.37199999999999966426855735335266217589378356933594e+00, // 0.700000
  2.04800000000000048672177399566862732172012329101562e+00, // 0.800000
  2.91600000000000036948222259525209665298461914062500e+00, // 0.900000
  4.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_4_1 = { //
  1.00000000000000217236629027437295105899424517600020e-40, // 0.000000
  9.99999999999995882644795012383944111776031062706330e-21, // 0.000010
  1.00000000000000113212390850936372999058221466839314e-04, // 0.100000
  2.32305052922195169563465699802407016250072047114372e-04, // 0.123457
  1.60000000000000094403651562657842077896930277347565e-03, // 0.200000
  5.45981500332209674503092244890467554796487092971802e-03, // 0.271828
  8.09999999999999782673842929625607212074100971221924e-03, // 0.300000
  9.74090910340281480872537400728106149472296237945557e-03, // 0.314159
  2.56000000000000012267964422107979771681129932403564e-02, // 0.400000
  6.25000000000000000000000000000000000000000000000000e-02, // 0.500000
  1.29599999999999965227814868740097153931856155395508e-01, // 0.600000
  2.40099999999999924593652167459367774426937103271484e-01, // 0.700000
  4.09600000000000130651045537888421677052974700927734e-01, // 0.800000
  6.56100000000000127542421068937983363866806030273438e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_4_1 = { //
  4.00000000000002415541957595223414710712826003604885e-30, // 0.000000
  3.99999999999999084449073685450265201248595901134530e-15, // 0.000010
  4.00000000000000181799020282369383494369685649871826e-03, // 0.100000
  7.52668920916224701983532341387217456940561532974243e-03, // 0.123457
  3.20000000000000214828155264967790571972727775573730e-02, // 0.200000
  8.03421476928353334168164678885659668594598770141602e-02, // 0.271828
  1.07999999999999957145391249468957539647817611694336e-01, // 0.300000
  1.24025106721223812855647850028617540374398231506348e-01, // 0.314159
  2.56000000000000060840221749458578415215015411376953e-01, // 0.400000
  5.00000000000000111022302462515654042363166809082031e-01, // 0.500000
  8.63999999999999879207734920782968401908874511718750e-01, // 0.600000
  1.37199999999999966426855735335266217589378356933594e+00, // 0.700000
  2.04800000000000004263256414560601115226745605468750e+00, // 0.800000
  2.91600000000000036948222259525209665298461914062500e+00, // 0.900000
  4.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_4_2 = { //
  4.99999999960000092956526294536008149911609020135072e-40, // 0.000000
  4.99996000000000182972062623064444698658055305533981e-20, // 0.000010
  4.60000000000000122332699525884436297928914427757263e-04, // 0.100000
  1.04680680370257796554800400201656884746626019477844e-03, // 0.123457
  6.72000000000000114602771716931783885229378938674927e-03, // 0.200000
  2.13625486524690426370920448562173987738788127899170e-02, // 0.271828
  3.07799999999999983335552400376400328241288661956787e-02, // 0.300000
  3.64637581255899539955933619239658582955598831176758e-02, // 0.314159
  8.70400000000000062527760746888816356658935546875000e-02, // 0.400000
  1.87500000000000000000000000000000000000000000000000e-01, // 0.500000
  3.36959999999999981756815259359427727758884429931641e-01, // 0.600000
  5.28219999999999911821646492171566933393478393554688e-01, // 0.700000
  7.37280000000000157456270244438201189041137695312500e-01, // 0.800000
  9.18540000000000023128166048991261050105094909667969e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_4_2 = { //
  1.99999999980000012361177456368779558183353543188356e-29, // 0.000000
  1.99998000000000044302004307985331939009172267512904e-14, // 0.000010
  1.80000000000000021094237467877974268049001693725586e-02, // 0.100000
  3.29873449873673424415088106798066291958093643188477e-02, // 0.123457
  1.28000000000000030420110874729289207607507705688477e-01, // 0.200000
  2.92514438397464715535534196533262729644775390625000e-01, // 0.271828
  3.77999999999999891642232796584721654653549194335938e-01, // 0.300000
  4.25307351537991429335505699782515875995159149169922e-01, // 0.314159
  7.68000000000000127009514017117908224463462829589844e-01, // 0.400000
  1.25000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.72799999999999975841546984156593680381774902343750e+00, // 0.600000
  2.05799999999999982946974341757595539093017578125000e+00, // 0.700000
  2.04800000000000004263256414560601115226745605468750e+00, // 0.800000
  1.45799999999999974065190144756343215703964233398438e+00, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_4_2 = { //
  4.99999999960002458379395944001149082393223625633561e-40, // 0.000000
  4.99995999999999340377711953648758986667705424628279e-20, // 0.000010
  4.60000000000000501803459895810988200537394732236862e-04, // 0.100000
  1.04680680370257774870756950491568204597570002079010e-03, // 0.123457
  6.72000000000000461547466912293202767614275217056274e-03, // 0.200000
  2.13625486524969925017369831721225637011229991912842e-02, // 0.271828
  3.07799999999999948641082880840258440002799034118652e-02, // 0.300000
  3.64637581255987802686391319184622261673212051391602e-02, // 0.314159
  8.70400000000000062527760746888816356658935546875000e-02, // 0.400000
  1.87499999999999972244424384371086489409208297729492e-01, // 0.500000
  3.36959999999999926245664028101600706577301025390625e-01, // 0.600000
  5.28220000000000022843948954687220975756645202636719e-01, // 0.700000
  7.37280000000000046433967781922547146677970886230469e-01, // 0.800000
  9.18540000000000023128166048991261050105094909667969e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_4_2 = { //
  1.99999999980001413659641781185850481912936833104487e-29, // 0.000000
  1.99998000000000801608473320156665134268594938987684e-14, // 0.000010
  1.80000000000000159872115546022541821002960205078125e-02, // 0.100000
  3.29873449873673146859331950508931186050176620483398e-02, // 0.123457
  1.28000000000000058175686490358202718198299407958984e-01, // 0.200000
  2.92514438397734666263971803346066735684871673583984e-01, // 0.271828
  3.77999999999999669597627871553413569927215576171875e-01, // 0.300000
  4.25307351538062705653686634832411073148250579833984e-01, // 0.314159
  7.67999999999999904964909092086600139737129211425781e-01, // 0.400000
  1.25000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.72799999999999998046007476659724488854408264160156e+00, // 0.600000
  2.05799999999999938538053356751333922147750854492188e+00, // 0.700000
  2.04799999999999959854335429554339498281478881835938e+00, // 0.800000
  1.45799999999999929656269159750081598758697509765625e+00, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_CDF_4_4 = { //
  3.49999999916000016318033258661157178322633534961105e-39, // 0.000000
  3.49991600069999950401327387562812102476143042072235e-19, // 0.000010
  2.72800000000000038985481509712371916975826025009155e-03, // 0.100000
  5.96069507924967562778606477991161227691918611526489e-03, // 0.123457
  3.33440000000000055790927433463366469368338584899902e-02, // 0.200000
  9.24732206974749615380204659231822006404399871826172e-02, // 0.271828
  1.26036000000000009135803225035488139837980270385742e-01, // 0.300000
  1.45131940494089783921793923582299612462520599365234e-01, // 0.314159
  2.89791999999999994042099160651559941470623016357422e-01, // 0.400000
  4.99999999999999888977697537484345957636833190917969e-01, // 0.500000
  7.10207999999999950446749608090613037347793579101562e-01, // 0.600000
  8.73963999999999963108621159335598349571228027343750e-01, // 0.700000
  9.66656000000000070748740199633175507187843322753906e-01, // 0.800000
  9.97272000000000047315040774265071377158164978027344e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_BETA_PDF_4_4 = { //
  1.39999999958000002624274888250361173924268353172324e-28, // 0.000000
  1.39995800041999896773103113821248488557241404506293e-13, // 0.000010
  1.02060000000000025699442574023123597726225852966309e-01, // 0.100000
  1.77415741797289500114587212920014280825853347778320e-01, // 0.123457
  5.73440000000000171809233506792224943637847900390625e-01, // 0.200000
  1.08570810499605374666032275854377076029777526855469e+00, // 0.271828
  1.29653999999999935965888653299771249294281005859375e+00, // 0.300000
  1.40038510081151179598180078755831345915794372558594e+00, // 0.314159
  1.93535999999999996923349954158766195178031921386719e+00, // 0.400000
  2.18750000000000000000000000000000000000000000000000e+00, // 0.500000
  1.93535999999999996923349954158766195178031921386719e+00, // 0.600000
  1.29654000000000024783730623312294483184814453125000e+00, // 0.700000
  5.73439999999999727720023656729608774185180664062500e-01, // 0.800000
  1.02059999999999942432715727136383065953850746154785e-01, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_CDF_4_4 = { //
  3.49999999915999951064988578675911911219692442395630e-39, // 0.000000
  3.49991600069999998549575997243708428875591606695418e-19, // 0.000010
  2.72800000000000125721655308552726637572050094604492e-03, // 0.100000
  5.96069507924966868889216087268323462922126054763794e-03, // 0.123457
  3.33440000000000194568805511607934022322297096252441e-02, // 0.200000
  9.24732206975786980018838789874280337244272232055664e-02, // 0.271828
  1.26035999999999953624651993777661118656396865844727e-01, // 0.300000
  1.45131940494118955031765949570399243384599685668945e-01, // 0.314159
  2.89792000000000049553250391909386962652206420898438e-01, // 0.400000
  4.99999999999999944488848768742172978818416595458984e-01, // 0.500000
  7.10207999999999950446749608090613037347793579101562e-01, // 0.600000
  8.73963999999999963108621159335598349571228027343750e-01, // 0.700000
  9.66655999999999959726437737117521464824676513671875e-01, // 0.800000
  9.97271999999999936292738311749417334794998168945312e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] GNUR_BETA_PDF_4_4 = { //
  1.39999999957999778416520596279629826127535026785743e-28, // 0.000000
  1.39995800042000149208592784545026220310382294997886e-13, // 0.000010
  1.02060000000000108966169420909864129498600959777832e-01, // 0.100000
  1.77415741797289527870162828548927791416645050048828e-01, // 0.123457
  5.73439999999999949764628581760916858911514282226562e-01, // 0.200000
  1.08570810499677206095725523482542484998703002929688e+00, // 0.271828
  1.29653999999999958170349145802902057766914367675781e+00, // 0.300000
  1.40038510081166234222393995878519490361213684082031e+00, // 0.314159
  1.93536000000000041332270939165027812123298645019531e+00, // 0.400000
  2.18750000000000000000000000000000000000000000000000e+00, // 0.500000
  1.93536000000000041332270939165027812123298645019531e+00, // 0.600000
  1.29653999999999958170349145802902057766914367675781e+00, // 0.700000
  5.73439999999999505675418731698300689458847045898438e-01, // 0.800000
  1.02060000000000011821654766208666842430830001831055e-01, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] P_QUANT = { //
  0.0001, 0.001, 0.01, 0.1, 0.25, 0.5, 0.75, 0.9, 0.99, 0.999, 0.9999 //
  };

  public static final double[] SCIPY_BETA_QUANT_01_01 = { //
  8.86928065555026613565596956864396236737615274357892e-38, // 0.000100
  8.86928065555024393294670900210330809197198311562804e-28, // 0.001000
  8.86928065555025006242057470083821192914616784639358e-18, // 0.010000
  8.86928001193459112153072432249700796091929078102112e-08, // 0.100000
  8.45255532847129752160864057941580540500581264495850e-04, // 0.250000
  5.00000000000000777156117237609578296542167663574219e-01, // 0.500000
  9.99154744467152911013840821397025138139724731445312e-01, // 0.750000
  9.99999911307199895738051509397337213158607482910156e-01, // 0.900000
  9.99999999999999888977697537484345957636833190917969e-01, // 0.990000
  9.99999999999999888977697537484345957636833190917969e-01, // 0.999000
  9.99999999999999888977697537484345957636833190917969e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_01_01 = { //
  8.86928065555028388448412252463067501937612992138827e-38, // 0.000100
  8.86928065555027263153925837435692060995384889311041e-28, // 0.001000
  8.86928065555026392911617428893635393218735445787027e-18, // 0.010000
  8.86928001193460965037644551031692508047399314818904e-08, // 0.100000
  8.45255532847132245825860774601778757642023265361786e-04, // 0.250000
  4.99999999999999500399638918679556809365749359130859e-01, // 0.500000
  9.99154744467152911013840821397025138139724731445312e-01, // 0.750000
  9.99999911307199895738051509397337213158607482910156e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.990000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.999000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_01_05 = { //
  3.46456275607431455261002811459588941188867309477607e-40, // 0.000100
  3.46456275607431613825500469117221110902093083941640e-30, // 0.001000
  3.46456275607430439357088457229084493496058065920175e-20, // 0.010000
  3.46456275552870422056197107589232790647582049814446e-10, // 0.100000
  3.30405955584976185706561242760859187228561495430768e-06, // 0.250000
  3.37816430372528137687782034959127486217767000198364e-03, // 0.500000
  1.78799793029011389045024316146736964583396911621094e-01, // 0.750000
  7.32777808689458409752148781990399584174156188964844e-01, // 0.900000
  9.96800847460084904483323953172657638788223266601562e-01, // 0.990000
  9.99967947541768209518409094016533344984054565429688e-01, // 0.999000
  9.99999679469315005952978481218451634049415588378906e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_01_05 = { //
  3.46456275607432760321896411164494283247689160787118e-40, // 0.000100
  3.46456275607431613825500469117221110902093083941640e-30, // 0.001000
  3.46456275607431342136749888745890613485718652604856e-20, // 0.010000
  3.46456275552870783947715099538840546888884830423194e-10, // 0.100000
  3.30405955584976524519740144480994814557561767287552e-06, // 0.250000
  3.37816430372529221889954520463561493670567870140076e-03, // 0.500000
  1.78799793029011944156536628725007176399230957031250e-01, // 0.750000
  7.32777808689457965662938931927783414721488952636719e-01, // 0.900000
  9.96800847460084904483323953172657638788223266601562e-01, // 0.990000
  9.99967947541768209518409094016533344984054565429688e-01, // 0.999000
  9.99999679469315005952978481218451634049415588378906e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_01_1 = { //
  1.00000000000000298802934877418851689778100883306864e-40, // 0.000100
  1.00000000000000218528411709481159173652571096174285e-30, // 0.001000
  1.00000000000000084793293288572637777171916428947207e-20, // 0.010000
  9.99999999999999131703402335623722188562290114077769e-11, // 0.100000
  9.53674316406248835329697525337033781056561565492302e-07, // 0.250000
  9.76562499999998590537175768844235790311358869075775e-04, // 0.500000
  5.63135147094726076777426726494013564661145210266113e-02, // 0.750000
  3.48678440099999320533896707274834625422954559326172e-01, // 0.900000
  9.04382075008804409144147484767017886042594909667969e-01, // 0.990000
  9.90044880209748234811684142187004908919334411621094e-01, // 0.999000
  9.99000449880021124116069586307276040315628051757812e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_01_1 = { //
  1.00000000000000665851311202335856317232144528987664e-40, // 0.000100
  1.00000000000000673950412615046707223864685665397028e-30, // 0.001000
  1.00000000000000445905157861179360225167780663621080e-20, // 0.010000
  1.00000000000000313835949438935152234694814232796034e-10, // 0.100000
  9.53674316406252541098841762901017204967502038925886e-07, // 0.250000
  9.76562500000002385244779468109754816396161913871765e-04, // 0.500000
  5.63135147094727672723024625156540423631668090820312e-02, // 0.750000
  3.48678440100000486268072563689202070236206054687500e-01, // 0.900000
  9.04382075008804409144147484767017886042594909667969e-01, // 0.990000
  9.90044880209748234811684142187004908919334411621094e-01, // 0.999000
  9.99000449880021124116069586307276040315628051757812e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_01_2 = { //
  3.85543289429533451133658448963742592666926086214652e-41, // 0.000100
  3.85543289429532603687340095433216245505652506485049e-31, // 0.001000
  3.85543289429532404962034705548650193823057760610265e-21, // 0.010000
  3.85543289443045237890743375235041599455310112887219e-11, // 0.100000
  3.67682855892327505770053293690513562808064307319000e-07, // 0.250000
  3.76636057551797004145505143313243934244383126497269e-04, // 0.500000
  2.21534346953469116203727651281951693817973136901855e-02, // 0.750000
  1.54915841004560961291502962922095321118831634521484e-01, // 0.900000
  6.27148329248184310813485353719443082809448242187500e-01, // 0.990000
  8.70585822529799657765181564172962680459022521972656e-01, // 0.999000
  9.57904427593739837831776640086900442838668823242188e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_01_2 = { //
  3.85543289429538701964597541526447679856717128592763e-41, // 0.000100
  3.85543289429535537655999775518958492064467519746949e-31, // 0.001000
  3.85543289429532931583503873933453763817026436176329e-21, // 0.010000
  3.85543289443044591655889818182170606167269433228739e-11, // 0.100000
  3.67682855892327611649171700478055946348376892274246e-07, // 0.250000
  3.76636057551797437826374137515017537225503474473953e-04, // 0.500000
  2.21534346953469185592666690354235470294952392578125e-02, // 0.750000
  1.54915841004561238847259119211230427026748657226562e-01, // 0.900000
  6.27148329248184310813485353719443082809448242187500e-01, // 0.990000
  8.70585822529799657765181564172962680459022521972656e-01, // 0.999000
  9.57904427593739837831776640086900442838668823242188e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_01_4 = { //
  1.70520173780031775915342203870768816354885853037205e-41, // 0.000100
  1.70520173780031788553917314540519037060879260315405e-31, // 0.001000
  1.70520173780031400068231169360407429564207370948071e-21, // 0.010000
  1.70520173787961264841636790620568427459535776335997e-11, // 0.100000
  1.62620782287267823496376044703493057852483616443351e-07, // 0.250000
  1.66599281457928790261754925516868297563632950186729e-04, // 0.500000
  9.86339324158605999792737151210531010292470455169678e-03, // 0.750000
  7.19532648151699621985599719664605800062417984008789e-02, // 0.900000
  3.58513695489701578189567499066470190882682800292969e-01, // 0.990000
  6.07588693735668705642183340387418866157531738281250e-01, // 0.999000
  7.70239957250841489333481604262487962841987609863281e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_01_4 = { //
  1.70520173780032387662636078732443195444958595838538e-41, // 0.000100
  1.70520173780031000323531131830916642462988659737581e-31, // 0.001000
  1.70520173780030873446762000975603859570238695382007e-21, // 0.010000
  1.70520173787960327801099132893905487191876790831202e-11, // 0.100000
  1.62620782287266764705191976828069222449357766890898e-07, // 0.250000
  1.66599281457928193950560058489429593464592471718788e-04, // 0.500000
  9.86339324158602703818132795277051627635955810546875e-03, // 0.750000
  7.19532648151695042315623140893876552581787109375000e-02, // 0.900000
  3.58513695489701134100357649003854021430015563964844e-01, // 0.990000
  6.07588693735668594619880877871764823794364929199219e-01, // 0.999000
  7.70239957250841489333481604262487962841987609863281e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_05_01 = { //
  3.20530684976785390026245365149848431940426962682977e-07, // 0.000100
  3.20524582318020690016244222952934705972438678145409e-05, // 0.001000
  3.19915253991507426631346611145545466570183634757996e-03, // 0.010000
  2.67222191310541978825909836814389564096927642822266e-01, // 0.100000
  8.21200206970988388910370758821954950690269470214844e-01, // 0.250000
  9.96621835696274716021036965685198083519935607910156e-01, // 0.500000
  9.99996695940444157990611984132556244730949401855469e-01, // 0.750000
  9.99999999653543691913171187479747459292411804199219e-01, // 0.900000
  9.99999999999999888977697537484345957636833190917969e-01, // 0.990000
  9.99999999999999888977697537484345957636833190917969e-01, // 0.999000
  9.99999999999999888977697537484345957636833190917969e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_05_01 = { //
  3.20530684976785442965804568543619623710583255160600e-07, // 0.000100
  3.20524582318020825541515783640988956904038786888123e-05, // 0.001000
  3.19915253991507513367520409985900187166407704353333e-03, // 0.010000
  2.67222191310542089848212299330043606460094451904297e-01, // 0.100000
  8.21200206970988055843463371274992823600769042968750e-01, // 0.250000
  9.96621835696274716021036965685198083519935607910156e-01, // 0.500000
  9.99996695940444157990611984132556244730949401855469e-01, // 0.750000
  9.99999999653543691913171187479747459292411804199219e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.990000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.999000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_05_05 = { //
  2.46740107997877850811582013451292438865891654131701e-08, // 0.000100
  2.46739907091694248724746130196905369302839972078800e-06, // 0.001000
  2.46719817134221513794251068318885700136888772249222e-04, // 0.010000
  2.44717418524231997145612638178135966882109642028809e-02, // 0.100000
  1.46446609406726185875768919686379376798868179321289e-01, // 0.250000
  4.99999999999999666933092612453037872910499572753906e-01, // 0.500000
  8.53553390593273841879806695942534133791923522949219e-01, // 0.750000
  9.75528258147576821102120447903871536254882812500000e-01, // 0.900000
  9.99753280182865800007618872768944129347801208496094e-01, // 0.990000
  9.99997532600929051049831741693196818232536315917969e-01, // 0.999000
  9.99999975325989165497730937204323709011077880859375e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_05_05 = { //
  2.46740107997877950073255519814613423434934702527244e-08, // 0.000100
  2.46739907091694375779688218341956229551215074025095e-06, // 0.001000
  2.46719817134221622214468316869329100882168859243393e-04, // 0.010000
  2.44717418524232274701368794467271072790026664733887e-02, // 0.100000
  1.46446609406726185875768919686379376798868179321289e-01, // 0.250000
  4.99999999999999167332731531132594682276248931884766e-01, // 0.500000
  8.53553390593273841879806695942534133791923522949219e-01, // 0.750000
  9.75528258147576821102120447903871536254882812500000e-01, // 0.900000
  9.99753280182865800007618872768944129347801208496094e-01, // 0.990000
  9.99997532600929051049831741693196818232536315917969e-01, // 0.999000
  9.99999975325989165497730937204323709011077880859375e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_05_1 = { //
  1.00000000000000018635868334073400764960837250328041e-08, // 0.000100
  1.00000000000000016650634863946134345269456389360130e-06, // 0.001000
  1.00000000000000004792173602385929598312941379845142e-04, // 0.010000
  1.00000000000000002081668171172168513294309377670288e-02, // 0.100000
  6.25000000000000000000000000000000000000000000000000e-02, // 0.250000
  2.50000000000000000000000000000000000000000000000000e-01, // 0.500000
  5.62500000000000000000000000000000000000000000000000e-01, // 0.750000
  8.10000000000000053290705182007513940334320068359375e-01, // 0.900000
  9.80099999999999971223019201715942472219467163085938e-01, // 0.990000
  9.98001000000000026979307676811004057526588439941406e-01, // 0.999000
  9.99800010000000072274417561857262626290321350097656e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_05_1 = { //
  1.00000000000000018635868334073400764960837250328041e-08, // 0.000100
  1.00000000000000037826458545303642821977518906351179e-06, // 0.001000
  1.00000000000000086107336538798762148871901445090771e-04, // 0.010000
  1.00000000000000036776137690708310401532799005508423e-02, // 0.100000
  6.25000000000000277555756156289135105907917022705078e-02, // 0.250000
  2.50000000000000000000000000000000000000000000000000e-01, // 0.500000
  5.62499999999999777955395074968691915273666381835938e-01, // 0.750000
  8.10000000000000053290705182007513940334320068359375e-01, // 0.900000
  9.80099999999999971223019201715942472219467163085938e-01, // 0.990000
  9.98001000000000026979307676811004057526588439941406e-01, // 0.999000
  9.99800010000000072274417561857262626290321350097656e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_05_2 = { //
  4.44444445761316705817644639965255382030306918750284e-09, // 0.000100
  4.44444576131755449727476570478956752197063906351104e-07, // 0.001000
  4.44457613851590344110700780966283218731405213475227e-05, // 0.010000
  4.45768188762137376746075290157023118808865547180176e-03, // 0.100000
  2.83095437186913906346674707492638844996690750122070e-02, // 0.250000
  1.20614758428183241334430420010903617367148399353027e-01, // 0.500000
  3.11224179038489423554381119174649938941001892089844e-01, // 0.750000
  5.31877433473580407685687987395795062184333801269531e-01, // 0.900000
  8.41255287053071842962026494205929338932037353515625e-01, // 0.990000
  9.48808055284168672116607012867461889982223510742188e-01, // 0.999000
  9.83714619081483720997027830890147015452384948730469e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_05_2 = { //
  4.44444445761315465046725810423743074917268813806004e-09, // 0.000100
  4.44444576131755290908798960297643176886595028918236e-07, // 0.001000
  4.44457613851590750686515463030445971526205539703369e-05, // 0.010000
  4.45768188762137550218422887837732560001313686370850e-03, // 0.100000
  2.83095437186913941041144227028780733235180377960205e-02, // 0.250000
  1.20614758428183130312127957495249575003981590270996e-01, // 0.500000
  3.11224179038489201509776194143341854214668273925781e-01, // 0.750000
  5.31877433473580518707990449911449104547500610351562e-01, // 0.900000
  8.41255287053071842962026494205929338932037353515625e-01, // 0.990000
  9.48808055284168672116607012867461889982223510742188e-01, // 0.999000
  9.83714619081483720997027830890147015452384948730469e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_05_4 = { //
  2.08979592710184102207603484900426404902162857979420e-09, // 0.000100
  2.08979679181727248935671503900224355021464361925609e-07, // 0.001000
  2.08988326860078756129837640465041204151930287480354e-05, // 0.010000
  2.09858372142358862166844346575089730322360992431641e-03, // 0.100000
  1.34159346080160047504081788360963400918990373611450e-02, // 0.250000
  5.87108013397836248081773646845249459147453308105469e-02, // 0.500000
  1.61283978400102917527547674581001047044992446899414e-01, // 0.750000
  3.01792928793774728468690682348096743226051330566406e-01, // 0.900000
  5.84601685951977589894568154704757034778594970703125e-01, // 0.990000
  7.60584846730546160209485151426633819937705993652344e-01, // 0.999000
  8.63700924381154200304422374756541103124618530273438e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_05_4 = { //
  2.08979592710183854053419718992123943479555236990564e-09, // 0.000100
  2.08979679181727301875230707293995546791620654403232e-07, // 0.001000
  2.08988326860079027180380761841149706015130504965782e-05, // 0.010000
  2.09858372142358948903018145415444450918585062026978e-03, // 0.100000
  1.34159346080160134240255587201318121515214443206787e-02, // 0.250000
  5.87108013397836039914956529628398129716515541076660e-02, // 0.500000
  1.61283978400102778749669596436433494091033935546875e-01, // 0.750000
  3.01792928793774506424085757316788658499717712402344e-01, // 0.900000
  5.84601685951977145805358304642140865325927734375000e-01, // 0.990000
  7.60584846730546049187182688910979777574539184570312e-01, // 0.999000
  8.63700924381154200304422374756541103124618530273438e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_1_01 = { //
  9.99550119979002518744159999641851754859089851379395e-04, // 0.000100
  9.95511979025178947444452148829441284760832786560059e-03, // 0.001000
  9.56179249911954937113378605317848268896341323852539e-02, // 0.010000
  6.51321559899999957821137286373414099216461181640625e-01, // 0.100000
  9.43686485290527454772302462515654042363166809082031e-01, // 0.250000
  9.99023437500000000000000000000000000000000000000000e-01, // 0.500000
  9.99999046325683593750000000000000000000000000000000e-01, // 0.750000
  9.99999999899999991725962900090962648391723632812500e-01, // 0.900000
  9.99999999999999888977697537484345957636833190917969e-01, // 0.990000
  9.99999999999999888977697537484345957636833190917969e-01, // 0.999000
  9.99999999999999888977697537484345957636833190917969e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_1_01 = { //
  9.99550119979002735584594496742738556349650025367737e-04, // 0.000100
  9.95511979025179120916799746510150725953280925750732e-03, // 0.001000
  9.56179249911955353447012839751550927758216857910156e-02, // 0.010000
  6.51321559899999735776532361342106014490127563476562e-01, // 0.100000
  9.43686485290527232727697537484345957636833190917969e-01, // 0.250000
  9.99023437500000000000000000000000000000000000000000e-01, // 0.500000
  9.99999046325683593750000000000000000000000000000000e-01, // 0.750000
  9.99999999899999991725962900090962648391723632812500e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.990000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.999000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_1_05 = { //
  1.99989999999999987657234301607900306407827883958817e-04, // 0.000100
  1.99899999999999990890620082950590585824102163314819e-03, // 0.001000
  1.99000000000000010214051826551440171897411346435547e-02, // 0.010000
  1.90000000000000002220446049250313080847263336181641e-01, // 0.100000
  4.37500000000000055511151231257827021181583404541016e-01, // 0.250000
  7.50000000000000111022302462515654042363166809082031e-01, // 0.500000
  9.37500000000000000000000000000000000000000000000000e-01, // 0.750000
  9.89999999999999991118215802998747676610946655273438e-01, // 0.900000
  9.99900000000000011013412404281552881002426147460938e-01, // 0.990000
  9.99998999999999971244335483788745477795600891113281e-01, // 0.999000
  9.99999989999999949752407246705843135714530944824219e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_1_05 = { //
  1.99989999999999987657234301607900306407827883958817e-04, // 0.000100
  1.99899999999999990890620082950590585824102163314819e-03, // 0.001000
  1.99000000000000010214051826551440171897411346435547e-02, // 0.010000
  1.90000000000000057731597280508140102028846740722656e-01, // 0.100000
  4.37500000000000166533453693773481063544750213623047e-01, // 0.250000
  7.50000000000000000000000000000000000000000000000000e-01, // 0.500000
  9.37500000000000000000000000000000000000000000000000e-01, // 0.750000
  9.89999999999999991118215802998747676610946655273438e-01, // 0.900000
  9.99900000000000011013412404281552881002426147460938e-01, // 0.990000
  9.99998999999999971244335483788745477795600891113281e-01, // 0.999000
  9.99999989999999949752407246705843135714530944824219e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_1_1 = { //
  1.00000000000000004792173602385929598312941379845142e-04, // 0.000100
  1.00000000000000002081668171172168513294309377670288e-03, // 0.001000
  1.00000000000000002081668171172168513294309377670288e-02, // 0.010000
  1.00000000000000005551115123125782702118158340454102e-01, // 0.100000
  2.50000000000000000000000000000000000000000000000000e-01, // 0.250000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.500000
  7.50000000000000000000000000000000000000000000000000e-01, // 0.750000
  9.00000000000000022204460492503130808472633361816406e-01, // 0.900000
  9.89999999999999991118215802998747676610946655273438e-01, // 0.990000
  9.98999999999999999111821580299874767661094665527344e-01, // 0.999000
  9.99900000000000011013412404281552881002426147460938e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_1_1 = { //
  1.00000000000000086107336538798762148871901445090771e-04, // 0.000100
  1.00000000000000023765711620882257193443365395069122e-03, // 0.001000
  1.00000000000000036776137690708310401532799005508423e-02, // 0.010000
  1.00000000000000019428902930940239457413554191589355e-01, // 0.100000
  2.50000000000000000000000000000000000000000000000000e-01, // 0.250000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.500000
  7.50000000000000000000000000000000000000000000000000e-01, // 0.750000
  9.00000000000000022204460492503130808472633361816406e-01, // 0.900000
  9.89999999999999991118215802998747676610946655273438e-01, // 0.990000
  9.98999999999999999111821580299874767661094665527344e-01, // 0.999000
  9.99900000000000011013412404281552881002426147460938e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_1_2 = { //
  5.00012500625039114031909759372496182550094090402126e-05, // 0.000100
  5.00125062539089927649005318244235240854322910308838e-04, // 0.001000
  5.01256289338004520916847184253128943964838981628418e-03, // 0.010000
  5.13167019494862042261473789039882831275463104248047e-02, // 0.100000
  1.33974596215561375656122322652663569897413253784180e-01, // 0.250000
  2.92893218813452482773840301888412795960903167724609e-01, // 0.500000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.750000
  6.83772233983162003312372689833864569664001464843750e-01, // 0.900000
  8.99999999999999911182158029987476766109466552734375e-01, // 0.990000
  9.68377223398316222535697761486517265439033508300781e-01, // 0.999000
  9.90000000000000546229728115577017888426780700683594e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_1_2 = { //
  5.00012500625039249557181320060550433481694199144840e-05, // 0.000100
  5.00125062539089710808570821143348439363762736320496e-04, // 0.001000
  5.01256289338004520916847184253128943964838981628418e-03, // 0.010000
  5.13167019494862042261473789039882831275463104248047e-02, // 0.100000
  1.33974596215561375656122322652663569897413253784180e-01, // 0.250000
  2.92893218813452371751537839372758753597736358642578e-01, // 0.500000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.750000
  6.83772233983162114334675152349518612027168273925781e-01, // 0.900000
  8.99999999999999911182158029987476766109466552734375e-01, // 0.990000
  9.68377223398316222535697761486517265439033508300781e-01, // 0.999000
  9.90000000000000546229728115577017888426780700683594e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_1_4 = { //
  2.50009375546912596263108424787802164246386382728815e-05, // 0.000100
  2.50093804725125897110704631387534391251392662525177e-04, // 0.001000
  2.50943006631889524785106182491745130391791462898254e-03, // 0.010000
  2.59962535747032368049769246454161475412547588348389e-02, // 0.100000
  6.93951408979004008559243743547995109111070632934570e-02, // 0.250000
  1.59103584746285470208349011045356746762990951538086e-01, // 0.500000
  2.92893218813452482773840301888412795960903167724609e-01, // 0.750000
  4.37658674809650927173265699821058660745620727539062e-01, // 0.900000
  6.83772233983162003312372689833864569664001464843750e-01, // 0.990000
  8.22172058996107679718079452868551015853881835937500e-01, // 0.999000
  9.00000000000002797762022055394481867551803588867188e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_1_4 = { //
  2.50009375546912697907062095303842852445086464285851e-05, // 0.000100
  2.50093804725125951320813255662756091624032706022263e-04, // 0.001000
  2.50943006631889611521279981332099850988015532493591e-03, // 0.010000
  2.59962535747032368049769246454161475412547588348389e-02, // 0.100000
  6.93951408979004286114999899837130215018987655639648e-02, // 0.250000
  1.59103584746285470208349011045356746762990951538086e-01, // 0.500000
  2.92893218813452427262689070630585774779319763183594e-01, // 0.750000
  4.37658674809650927173265699821058660745620727539062e-01, // 0.900000
  6.83772233983162003312372689833864569664001464843750e-01, // 0.990000
  8.22172058996107679718079452868551015853881835937500e-01, // 0.999000
  9.00000000000002686739719592878827825188636779785156e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_2_01 = { //
  4.20955724062624797587872649273776914924383163452148e-02, // 0.000100
  1.29414177470200258968091588940296787768602371215820e-01, // 0.001000
  3.72851670751815522653060952507075853645801544189453e-01, // 0.010000
  8.45084158995438761152740880788769572973251342773438e-01, // 0.100000
  9.77846565304653081440733330964576452970504760742188e-01, // 0.250000
  9.99623363942448217578373714786721393465995788574219e-01, // 0.500000
  9.99999632317144060422720031056087464094161987304688e-01, // 0.750000
  9.99999999961445618090749576367670670151710510253906e-01, // 0.900000
  9.99999999999999888977697537484345957636833190917969e-01, // 0.990000
  9.99999999999999888977697537484345957636833190917969e-01, // 0.999000
  9.99999999999999888977697537484345957636833190917969e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_2_01 = { //
  4.20955724062624728198933610201493138447403907775879e-02, // 0.000100
  1.29414177470200231212515973311383277177810668945312e-01, // 0.001000
  3.72851670751815578164212183764902874827384948730469e-01, // 0.010000
  8.45084158995438761152740880788769572973251342773438e-01, // 0.100000
  9.77846565304653081440733330964576452970504760742188e-01, // 0.250000
  9.99623363942448217578373714786721393465995788574219e-01, // 0.500000
  9.99999632317144060422720031056087464094161987304688e-01, // 0.750000
  9.99999999961445618090749576367670670151710510253906e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.990000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.999000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_2_05 = { //
  1.62853809185172157536491965856839669868350028991699e-02, // 0.000100
  5.11919447158312862500295636891678441315889358520508e-02, // 0.001000
  1.58744712946928157037973505794070661067962646484375e-01, // 0.010000
  4.68122566526419536803160781346377916634082794189453e-01, // 0.100000
  6.88775820961510354401013955794041976332664489746094e-01, // 0.250000
  8.79385241571816744787781772174639627337455749511719e-01, // 0.500000
  9.71690456281308567731969105807365849614143371582031e-01, // 0.750000
  9.95542318112378588068622775608673691749572753906250e-01, // 0.900000
  9.99955554238614818807207029749406501650810241699219e-01, // 0.990000
  9.99999555555423857988728286727564409375190734863281e-01, // 0.999000
  9.99999995555555520887480724923079833388328552246094e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_2_05 = { //
  1.62853809185172088147552926784555893391370773315430e-02, // 0.000100
  5.11919447158312793111356597819394664838910102844238e-02, // 0.001000
  1.58744712946928129282397890165157150477170944213867e-01, // 0.010000
  4.68122566526419647825463243862031958997249603271484e-01, // 0.100000
  6.88775820961510798490223805856658145785331726074219e-01, // 0.250000
  8.79385241571817299899294084752909839153289794921875e-01, // 0.500000
  9.71690456281308567731969105807365849614143371582031e-01, // 0.750000
  9.95542318112378588068622775608673691749572753906250e-01, // 0.900000
  9.99955554238614818807207029749406501650810241699219e-01, // 0.990000
  9.99999555555423857988728286727564409375190734863281e-01, // 0.999000
  9.99999995555555520887480724923079833388328552246094e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_2_1 = { //
  1.00000000000000002081668171172168513294309377670288e-02, // 0.000100
  3.16227766016837913420900463279394898563623428344727e-02, // 0.001000
  9.99999999999999916733273153113259468227624893188477e-02, // 0.010000
  3.16227766016837941176476078908308409154415130615234e-01, // 0.100000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.250000
  7.07106781186547461715008466853760182857513427734375e-01, // 0.500000
  8.66025403784438596588302061718422919511795043945312e-01, // 0.750000
  9.48683298050513768018277005467098206281661987304688e-01, // 0.900000
  9.94987437106619965199172384018311277031898498535156e-01, // 0.990000
  9.99499874937460952573076156113529577851295471191406e-01, // 0.999000
  9.99949998749937507547258519480237737298011779785156e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_2_1 = { //
  9.99999999999999500399638918679556809365749359130859e-03, // 0.000100
  3.16227766016837982809839502351678675040602684020996e-02, // 0.001000
  1.00000000000000019428902930940239457413554191589355e-01, // 0.010000
  3.16227766016837885665324847650481387972831726074219e-01, // 0.100000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.250000
  7.07106781186547572737310929369414225220680236816406e-01, // 0.500000
  8.66025403784438596588302061718422919511795043945312e-01, // 0.750000
  9.48683298050513768018277005467098206281661987304688e-01, // 0.900000
  9.94987437106619965199172384018311277031898498535156e-01, // 0.990000
  9.99499874937460952573076156113529577851295471191406e-01, // 0.999000
  9.99949998749937507547258519480237737298011779785156e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_2_2 = { //
  5.78466759288776954245347994287840265315026044845581e-03, // 0.000100
  1.83702538588116116857751336510773398913443088531494e-02, // 0.001000
  5.89031357781952535912495250158826820552349090576172e-02, // 0.010000
  1.95800105659091727705600760600646026432514190673828e-01, // 0.100000
  3.26351822333069641057790022387052886188030242919922e-01, // 0.250000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.500000
  6.73648177666930303431058746355120092630386352539062e-01, // 0.750000
  8.04199894340908327805550470657180994749069213867188e-01, // 0.900000
  9.41096864221804718653174859355203807353973388671875e-01, // 0.990000
  9.81629746141188364028096202673623338341712951660156e-01, // 0.999000
  9.94215332407112573065433025476522743701934814453125e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_2_2 = { //
  5.78466759288776954245347994287840265315026044845581e-03, // 0.000100
  1.83702538588116116857751336510773398913443088531494e-02, // 0.001000
  5.89031357781952674690373328303394373506307601928711e-02, // 0.010000
  1.95800105659091699950025144971732515841722488403320e-01, // 0.100000
  3.26351822333069696568941253644879907369613647460938e-01, // 0.250000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.500000
  6.73648177666930303431058746355120092630386352539062e-01, // 0.750000
  8.04199894340908327805550470657180994749069213867188e-01, // 0.900000
  9.41096864221804718653174859355203807353973388671875e-01, // 0.990000
  9.81629746141188364028096202673623338341712951660156e-01, // 0.999000
  9.94215332407112573065433025476522743701934814453125e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_2_4 = { //
  3.17233337277439495643927003243334183935075998306274e-03, // 0.000100
  1.01017878837377523409957191802277520764619112014771e-02, // 0.001000
  3.26821122006028808026911747219855897128582000732422e-02, // 0.010000
  1.12234958545858548584206459963752422481775283813477e-01, // 0.100000
  1.93763609553971150045725835298071615397930145263672e-01, // 0.250000
  3.13810170455697423630425646479125134646892547607422e-01, // 0.500000
  4.54180564773615791374083983100717887282371520996094e-01, // 0.750000
  5.83890374619528973454407605458982288837432861328125e-01, // 0.900000
  7.77927716615001818567520786018576472997665405273438e-01, // 0.990000
  8.77986170388521558471950356761226430535316467285156e-01, // 0.999000
  9.32186920845740840668725013529183343052864074707031e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_2_4 = { //
  3.17233337277439452275840103823156823636963963508606e-03, // 0.000100
  1.01017878837377488715487672266135632526129484176636e-02, // 0.001000
  3.26821122006028738637972708147572120651602745056152e-02, // 0.010000
  1.12234958545858534706418652149295667186379432678223e-01, // 0.100000
  1.93763609553971177801301450926985125988721847534180e-01, // 0.250000
  3.13810170455697368119274415221298113465309143066406e-01, // 0.500000
  4.54180564773615680351781520585063844919204711914062e-01, // 0.750000
  5.83890374619528973454407605458982288837432861328125e-01, // 0.900000
  7.77927716615001929589823248534230515360832214355469e-01, // 0.990000
  8.77986170388521558471950356761226430535316467285156e-01, // 0.999000
  9.32186920845740840668725013529183343052864074707031e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_4_01 = { //
  2.29760042749164533626426987211743835359811782836914e-01, // 0.000100
  3.92411306264331405380119122128235176205635070800781e-01, // 0.001000
  6.41486304510298754877339888480491936206817626953125e-01, // 0.010000
  9.28046735184830051679227835847996175289154052734375e-01, // 0.100000
  9.90136606758413972961818672047229483723640441894531e-01, // 0.250000
  9.99833400718542097962426851154305040836334228515625e-01, // 0.500000
  9.99999837379217715316315207019215449690818786621094e-01, // 0.750000
  9.99999999982947973542479758179979398846626281738281e-01, // 0.900000
  9.99999999999999888977697537484345957636833190917969e-01, // 0.990000
  9.99999999999999888977697537484345957636833190917969e-01, // 0.999000
  9.99999999999999888977697537484345957636833190917969e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_4_01 = { //
  2.29760042749164533626426987211743835359811782836914e-01, // 0.000100
  3.92411306264331349868967890870408155024051666259766e-01, // 0.001000
  6.41486304510298754877339888480491936206817626953125e-01, // 0.010000
  9.28046735184830495768437685910612344741821289062500e-01, // 0.100000
  9.90136606758413972961818672047229483723640441894531e-01, // 0.250000
  9.99833400718542097962426851154305040836334228515625e-01, // 0.500000
  9.99999837379217715316315207019215449690818786621094e-01, // 0.750000
  9.99999999982947973542479758179979398846626281738281e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.990000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.999000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_4_05 = { //
  1.36299075618849435675983272631128784269094467163086e-01, // 0.000100
  2.39415153269453812034939232944452669471502304077148e-01, // 0.001000
  4.15398314048022576638885539068724028766155242919922e-01, // 0.010000
  6.98207071206225382553611780167557299137115478515625e-01, // 0.100000
  8.38716021599897110228027941047912463545799255371094e-01, // 0.250000
  9.41289198660216319680671404057648032903671264648438e-01, // 0.500000
  9.86584065391983955350951873697340488433837890625000e-01, // 0.750000
  9.97901416278576425256119364348705857992172241210938e-01, // 0.900000
  9.99979101167314032849731120222713798284530639648438e-01, // 0.990000
  9.99999791020320771828266970260301604866981506347656e-01, // 0.999000
  9.99999997910204108109155640704557299613952636718750e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_4_05 = { //
  1.36299075618849463431558888260042294859886169433594e-01, // 0.000100
  2.39415153269453950812817311089020222425460815429688e-01, // 0.001000
  4.15398314048022687661188001584378071129322052001953e-01, // 0.010000
  6.98207071206225493575914242683211341500282287597656e-01, // 0.100000
  8.38716021599897221250330403563566505908966064453125e-01, // 0.250000
  9.41289198660216541725276329088956117630004882812500e-01, // 0.500000
  9.86584065391983955350951873697340488433837890625000e-01, // 0.750000
  9.97901416278576425256119364348705857992172241210938e-01, // 0.900000
  9.99979101167314032849731120222713798284530639648438e-01, // 0.990000
  9.99999791020320771828266970260301604866981506347656e-01, // 0.999000
  9.99999997910204108109155640704557299613952636718750e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_4_1 = { //
  1.00000000000000005551115123125782702118158340454102e-01, // 0.000100
  1.77827941003892292526344931502535473555326461791992e-01, // 0.001000
  3.16227766016837941176476078908308409154415130615234e-01, // 0.010000
  5.62341325190349072826734300178941339254379272460938e-01, // 0.100000
  7.07106781186547572737310929369414225220680236816406e-01, // 0.250000
  8.40896415253714613058377835841383785009384155273438e-01, // 0.500000
  9.30604859102099557510712202201830223202705383300781e-01, // 0.750000
  9.74003746425296745847788315586512908339500427246094e-01, // 0.900000
  9.97490569933681126002511518890969455242156982421875e-01, // 0.990000
  9.99749906195274928855099005886586382985115051269531e-01, // 0.999000
  9.99974999062445357722594962979201227426528930664062e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_4_1 = { //
  1.00000000000000019428902930940239457413554191589355e-01, // 0.000100
  1.77827941003892264770769315873621962964534759521484e-01, // 0.001000
  3.16227766016837941176476078908308409154415130615234e-01, // 0.010000
  5.62341325190349072826734300178941339254379272460938e-01, // 0.100000
  7.07106781186547572737310929369414225220680236816406e-01, // 0.250000
  8.40896415253714502036075373325729742646217346191406e-01, // 0.500000
  9.30604859102099557510712202201830223202705383300781e-01, // 0.750000
  9.74003746425296745847788315586512908339500427246094e-01, // 0.900000
  9.97490569933681126002511518890969455242156982421875e-01, // 0.990000
  9.99749906195274928855099005886586382985115051269531e-01, // 0.999000
  9.99974999062445357722594962979201227426528930664062e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_4_2 = { //
  6.78130791542610467104168492369353771209716796875000e-02, // 0.000100
  1.22013829611478455405837451053230324760079383850098e-01, // 0.001000
  2.22072283384998070410176751465769484639167785644531e-01, // 0.010000
  4.16109625380471082056743625798844732344150543212891e-01, // 0.100000
  5.45819435226384208625916016899282112717628479003906e-01, // 0.250000
  6.86189829544302631880725584778701886534690856933594e-01, // 0.500000
  8.06236390446028794443122933444101363420486450195312e-01, // 0.750000
  8.87765041454141479171369155665161088109016418457031e-01, // 0.900000
  9.67317887799397091441733209649100899696350097656250e-01, // 0.990000
  9.89898212116262277149303372425492852926254272460938e-01, // 0.999000
  9.96827666627225772444376161729451268911361694335938e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_4_2 = { //
  6.78130791542610883437802726803056430071592330932617e-02, // 0.000100
  1.22013829611478469283625258867687080055475234985352e-01, // 0.001000
  2.22072283384998042654601135836855974048376083374023e-01, // 0.010000
  4.16109625380471026545592394541017711162567138671875e-01, // 0.100000
  5.45819435226384319648218479414936155080795288085938e-01, // 0.250000
  6.86189829544302631880725584778701886534690856933594e-01, // 0.500000
  8.06236390446028794443122933444101363420486450195312e-01, // 0.750000
  8.87765041454141479171369155665161088109016418457031e-01, // 0.900000
  9.67317887799397091441733209649100899696350097656250e-01, // 0.990000
  9.89898212116262277149303372425492852926254272460938e-01, // 0.999000
  9.96827666627225772444376161729451268911361694335938e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_4_4 = { //
  4.21840560047029092261006155695213237777352333068848e-02, // 0.000100
  7.66545428268873701993513236629951279610395431518555e-02, // 0.001000
  1.42270377006857268176176489760109689086675643920898e-01, // 0.010000
  2.78602048581713057640030228867544792592525482177734e-01, // 0.100000
  3.78848440641707306930641152575844898819923400878906e-01, // 0.250000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.500000
  6.21151559358292693069358847424155101180076599121094e-01, // 0.750000
  7.21397951418286886848818539874628186225891113281250e-01, // 0.900000
  8.57729622993142704068247894610976800322532653808594e-01, // 0.990000
  9.23345457173112560411709637264721095561981201171875e-01, // 0.999000
  9.57815943995298235691393529123160988092422485351562e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_4_4 = { //
  4.21840560047029092261006155695213237777352333068848e-02, // 0.000100
  7.66545428268873701993513236629951279610395431518555e-02, // 0.001000
  1.42270377006857268176176489760109689086675643920898e-01, // 0.010000
  2.78602048581713057640030228867544792592525482177734e-01, // 0.100000
  3.78848440641707306930641152575844898819923400878906e-01, // 0.250000
  5.00000000000000111022302462515654042363166809082031e-01, // 0.500000
  6.21151559358292693069358847424155101180076599121094e-01, // 0.750000
  7.21397951418286886848818539874628186225891113281250e-01, // 0.900000
  8.57729622993142704068247894610976800322532653808594e-01, // 0.990000
  9.23345457173112560411709637264721095561981201171875e-01, // 0.999000
  9.57815943995298235691393529123160988092422485351562e-01, // 0.999900
  };

  public static final double[] SCIPY_BETA_QUANT_5000_10000 = { //
  3.19116827168564931582750432426109910011291503906250e-01, // 0.000100
  3.21504012263543914595942396772443316876888275146484e-01, // 0.001000
  3.24412567280382702072927258996060118079185485839844e-01, // 0.010000
  3.28405475125335688524330635118531063199043273925781e-01, // 0.100000
  3.30733175792180755792060153908096253871917724609375e-01, // 0.250000
  3.33325925743107376320040202699601650238037109375000e-01, // 0.500000
  3.35925416008591048999676331732189282774925231933594e-01, // 0.750000
  3.38270709107204470278418284578947350382804870605469e-01, // 0.900000
  3.42319458459627412594272755086421966552734375000000e-01, // 0.990000
  3.45289298443524073078947367321234196424484252929688e-01, // 0.999000
  3.47739889112688382866167557949665933847427368164062e-01, // 0.999900
  };

  public static final double[] GNUR_BETA_QUANT_5000_10000 = { //
  3.19116827168544670012551023319247178733348846435547e-01, // 0.000100
  3.21504012263524707737616381564293988049030303955078e-01, // 0.001000
  3.24412567280357388987965805426938459277153015136719e-01, // 0.010000
  3.28405475125304435746187436961918137967586517333984e-01, // 0.100000
  3.30733175792131905978976647020317614078521728515625e-01, // 0.250000
  3.33325925743034268133868636141414754092693328857422e-01, // 0.500000
  3.35925416008648558552351914840983226895332336425781e-01, // 0.750000
  3.38270709107251876801569778763223439455032348632812e-01, // 0.900000
  3.42319458459653502835351446265121921896934509277344e-01, // 0.990000
  3.45289298443550274342328521015588194131851196289062e-01, // 0.999000
  3.47739889112697708739574409264605492353439331054688e-01, // 0.999900
  };

  @Test
  public void testPDF() {
    checkPDF(new BetaDistribution(1., 1.), P_CDFPDF, SCIPY_BETA_PDF_1_1, 1e-15);
    checkPDF(new BetaDistribution(2., 1.), P_CDFPDF, SCIPY_BETA_PDF_2_1, 1e-12);
    checkPDF(new BetaDistribution(4., 1.), P_CDFPDF, SCIPY_BETA_PDF_4_1, 1e-11);
    checkPDF(new BetaDistribution(.1, 1.), P_CDFPDF, SCIPY_BETA_PDF_01_1, 1e-12);
    checkPDF(new BetaDistribution(.5, 1.), P_CDFPDF, SCIPY_BETA_PDF_05_1, 1e-12);
    checkPDF(new BetaDistribution(1., 2.), P_CDFPDF, SCIPY_BETA_PDF_1_2, 1e-12);
    checkPDF(new BetaDistribution(2., 2.), P_CDFPDF, SCIPY_BETA_PDF_2_2, 1e-12);
    checkPDF(new BetaDistribution(4., 2.), P_CDFPDF, SCIPY_BETA_PDF_4_2, 1e-12);
    checkPDF(new BetaDistribution(.1, 2.), P_CDFPDF, SCIPY_BETA_PDF_01_2, 1e-12);
    checkPDF(new BetaDistribution(.5, 2.), P_CDFPDF, SCIPY_BETA_PDF_05_2, 1e-12);
    checkPDF(new BetaDistribution(1., 4.), P_CDFPDF, SCIPY_BETA_PDF_1_4, 1e-12);
    checkPDF(new BetaDistribution(2., 4.), P_CDFPDF, SCIPY_BETA_PDF_2_4, 1e-13);
    checkPDF(new BetaDistribution(4., 4.), P_CDFPDF, SCIPY_BETA_PDF_4_4, 1e-12);
    checkPDF(new BetaDistribution(.1, 4.), P_CDFPDF, SCIPY_BETA_PDF_01_4, 1e-12);
    checkPDF(new BetaDistribution(.5, 4.), P_CDFPDF, SCIPY_BETA_PDF_05_4, 1e-12);
    checkPDF(new BetaDistribution(1., .1), P_CDFPDF, SCIPY_BETA_PDF_1_01, 1e-12);
    checkPDF(new BetaDistribution(2., .1), P_CDFPDF, SCIPY_BETA_PDF_2_01, 1e-12);
    checkPDF(new BetaDistribution(4., .1), P_CDFPDF, SCIPY_BETA_PDF_4_01, 1e-11);
    checkPDF(new BetaDistribution(.1, .1), P_CDFPDF, SCIPY_BETA_PDF_01_01, 1e-12);
    checkPDF(new BetaDistribution(.5, .1), P_CDFPDF, SCIPY_BETA_PDF_05_01, 1e-13);
    checkPDF(new BetaDistribution(1., .5), P_CDFPDF, SCIPY_BETA_PDF_1_05, 1e-13);
    checkPDF(new BetaDistribution(2., .5), P_CDFPDF, SCIPY_BETA_PDF_2_05, 1e-12);
    checkPDF(new BetaDistribution(4., .5), P_CDFPDF, SCIPY_BETA_PDF_4_05, 1e-11);
    checkPDF(new BetaDistribution(.1, .5), P_CDFPDF, SCIPY_BETA_PDF_01_05, 1e-12);
    checkPDF(new BetaDistribution(.5, .5), P_CDFPDF, SCIPY_BETA_PDF_05_05, 1e-12);

    checkPDF(new BetaDistribution(1., 1.), P_CDFPDF, GNUR_BETA_PDF_1_1, 1e-15);
    checkPDF(new BetaDistribution(2., 1.), P_CDFPDF, GNUR_BETA_PDF_2_1, 1e-14);
    checkPDF(new BetaDistribution(4., 1.), P_CDFPDF, GNUR_BETA_PDF_4_1, 1e-14);
    checkPDF(new BetaDistribution(.1, 1.), P_CDFPDF, GNUR_BETA_PDF_01_1, 1e-14);
    checkPDF(new BetaDistribution(.5, 1.), P_CDFPDF, GNUR_BETA_PDF_05_1, 1e-14);
    checkPDF(new BetaDistribution(1., 2.), P_CDFPDF, GNUR_BETA_PDF_1_2, 1e-15);
    checkPDF(new BetaDistribution(2., 2.), P_CDFPDF, GNUR_BETA_PDF_2_2, 1e-15);
    checkPDF(new BetaDistribution(4., 2.), P_CDFPDF, GNUR_BETA_PDF_4_2, 1e-13);
    checkPDF(new BetaDistribution(.1, 2.), P_CDFPDF, GNUR_BETA_PDF_01_2, 1e-15);
    checkPDF(new BetaDistribution(.5, 2.), P_CDFPDF, GNUR_BETA_PDF_05_2, 1e-14);
    checkPDF(new BetaDistribution(1., 4.), P_CDFPDF, GNUR_BETA_PDF_1_4, 1e-15);
    checkPDF(new BetaDistribution(2., 4.), P_CDFPDF, GNUR_BETA_PDF_2_4, 1e-15);
    checkPDF(new BetaDistribution(4., 4.), P_CDFPDF, GNUR_BETA_PDF_4_4, 1e-14);
    checkPDF(new BetaDistribution(.1, 4.), P_CDFPDF, GNUR_BETA_PDF_01_4, 1e-14);
    checkPDF(new BetaDistribution(.5, 4.), P_CDFPDF, GNUR_BETA_PDF_05_4, 1e-15);
    checkPDF(new BetaDistribution(1., .1), P_CDFPDF, GNUR_BETA_PDF_1_01, 1e-15);
    checkPDF(new BetaDistribution(2., .1), P_CDFPDF, GNUR_BETA_PDF_2_01, 1e-15);
    checkPDF(new BetaDistribution(4., .1), P_CDFPDF, GNUR_BETA_PDF_4_01, 1e-14);
    checkPDF(new BetaDistribution(.1, .1), P_CDFPDF, GNUR_BETA_PDF_01_01, 1e-14);
    checkPDF(new BetaDistribution(.5, .1), P_CDFPDF, GNUR_BETA_PDF_05_01, 1e-15);
    checkPDF(new BetaDistribution(1., .5), P_CDFPDF, GNUR_BETA_PDF_1_05, 1e-14);
    checkPDF(new BetaDistribution(2., .5), P_CDFPDF, GNUR_BETA_PDF_2_05, 1e-14);
    checkPDF(new BetaDistribution(4., .5), P_CDFPDF, GNUR_BETA_PDF_4_05, 1e-15);
    checkPDF(new BetaDistribution(.1, .5), P_CDFPDF, GNUR_BETA_PDF_01_05, 1e-15);
    checkPDF(new BetaDistribution(.5, .5), P_CDFPDF, GNUR_BETA_PDF_05_05, 1e-14);
  }

  @Test
  public void testCDF() {
    checkCDF(new BetaDistribution(1., 1.), P_CDFPDF, SCIPY_BETA_CDF_1_1, 1e-12);
    checkCDF(new BetaDistribution(2., 1.), P_CDFPDF, SCIPY_BETA_CDF_2_1, 1e-12);
    checkCDF(new BetaDistribution(4., 1.), P_CDFPDF, SCIPY_BETA_CDF_4_1, 1e-11);
    checkCDF(new BetaDistribution(.1, 1.), P_CDFPDF, SCIPY_BETA_CDF_01_1, 1e-13);
    checkCDF(new BetaDistribution(.5, 1.), P_CDFPDF, SCIPY_BETA_CDF_05_1, 1e-12);
    checkCDF(new BetaDistribution(1., 2.), P_CDFPDF, SCIPY_BETA_CDF_1_2, 1e-12);
    checkCDF(new BetaDistribution(2., 2.), P_CDFPDF, SCIPY_BETA_CDF_2_2, 1e-12);
    checkCDF(new BetaDistribution(4., 2.), P_CDFPDF, SCIPY_BETA_CDF_4_2, 1e-11);
    checkCDF(new BetaDistribution(.1, 2.), P_CDFPDF, SCIPY_BETA_CDF_01_2, 1e-13);
    checkCDF(new BetaDistribution(.5, 2.), P_CDFPDF, SCIPY_BETA_CDF_05_2, 1e-12);
    checkCDF(new BetaDistribution(1., 4.), P_CDFPDF, SCIPY_BETA_CDF_1_4, 1e-12);
    checkCDF(new BetaDistribution(2., 4.), P_CDFPDF, SCIPY_BETA_CDF_2_4, 1e-12);
    checkCDF(new BetaDistribution(4., 4.), P_CDFPDF, SCIPY_BETA_CDF_4_4, 1e-11);
    checkCDF(new BetaDistribution(.1, 4.), P_CDFPDF, SCIPY_BETA_CDF_01_4, 1e-13);
    checkCDF(new BetaDistribution(.5, 4.), P_CDFPDF, SCIPY_BETA_CDF_05_4, 1e-13);
    checkCDF(new BetaDistribution(1., .1), P_CDFPDF, SCIPY_BETA_CDF_1_01, 1e-12);
    checkCDF(new BetaDistribution(2., .1), P_CDFPDF, SCIPY_BETA_CDF_2_01, 1e-12);
    checkCDF(new BetaDistribution(4., .1), P_CDFPDF, SCIPY_BETA_CDF_4_01, 1e-11);
    checkCDF(new BetaDistribution(.1, .1), P_CDFPDF, SCIPY_BETA_CDF_01_01, 1e-13);
    checkCDF(new BetaDistribution(.5, .1), P_CDFPDF, SCIPY_BETA_CDF_05_01, 1e-12);
    checkCDF(new BetaDistribution(1., .5), P_CDFPDF, SCIPY_BETA_CDF_1_05, 1e-12);
    checkCDF(new BetaDistribution(2., .5), P_CDFPDF, SCIPY_BETA_CDF_2_05, 1e-12);
    checkCDF(new BetaDistribution(4., .5), P_CDFPDF, SCIPY_BETA_CDF_4_05, 1e-11);
    checkCDF(new BetaDistribution(.1, .5), P_CDFPDF, SCIPY_BETA_CDF_01_05, 1e-13);
    checkCDF(new BetaDistribution(.5, .5), P_CDFPDF, SCIPY_BETA_CDF_05_05, 1e-12);

    checkCDF(new BetaDistribution(1., 1.), P_CDFPDF, GNUR_BETA_CDF_1_1, 1e-14);
    checkCDF(new BetaDistribution(2., 1.), P_CDFPDF, GNUR_BETA_CDF_2_1, 1e-14);
    checkCDF(new BetaDistribution(4., 1.), P_CDFPDF, GNUR_BETA_CDF_4_1, 1e-13);
    checkCDF(new BetaDistribution(.1, 1.), P_CDFPDF, GNUR_BETA_CDF_01_1, 1e-15);
    checkCDF(new BetaDistribution(.5, 1.), P_CDFPDF, GNUR_BETA_CDF_05_1, 1e-14);
    checkCDF(new BetaDistribution(1., 2.), P_CDFPDF, GNUR_BETA_CDF_1_2, 1e-14);
    checkCDF(new BetaDistribution(2., 2.), P_CDFPDF, GNUR_BETA_CDF_2_2, 1e-14);
    checkCDF(new BetaDistribution(4., 2.), P_CDFPDF, GNUR_BETA_CDF_4_2, 1e-14);
    checkCDF(new BetaDistribution(.1, 2.), P_CDFPDF, GNUR_BETA_CDF_01_2, 1e-15);
    checkCDF(new BetaDistribution(.5, 2.), P_CDFPDF, GNUR_BETA_CDF_05_2, 1e-14);
    checkCDF(new BetaDistribution(1., 4.), P_CDFPDF, GNUR_BETA_CDF_1_4, 1e-14);
    checkCDF(new BetaDistribution(2., 4.), P_CDFPDF, GNUR_BETA_CDF_2_4, 1e-14);
    checkCDF(new BetaDistribution(4., 4.), P_CDFPDF, GNUR_BETA_CDF_4_4, 1e-14);
    checkCDF(new BetaDistribution(.1, 4.), P_CDFPDF, GNUR_BETA_CDF_01_4, 1e-15);
    checkCDF(new BetaDistribution(.5, 4.), P_CDFPDF, GNUR_BETA_CDF_05_4, 1e-15);
    checkCDF(new BetaDistribution(1., .1), P_CDFPDF, GNUR_BETA_CDF_1_01, 1e-14);
    checkCDF(new BetaDistribution(2., .1), P_CDFPDF, GNUR_BETA_CDF_2_01, 1e-14);
    checkCDF(new BetaDistribution(4., .1), P_CDFPDF, GNUR_BETA_CDF_4_01, 1e-14);
    checkCDF(new BetaDistribution(.1, .1), P_CDFPDF, GNUR_BETA_CDF_01_01, 1e-14);
    checkCDF(new BetaDistribution(.5, .1), P_CDFPDF, GNUR_BETA_CDF_05_01, 1e-14);
    checkCDF(new BetaDistribution(1., .5), P_CDFPDF, GNUR_BETA_CDF_1_05, 1e-14);
    checkCDF(new BetaDistribution(2., .5), P_CDFPDF, GNUR_BETA_CDF_2_05, 1e-14);
    checkCDF(new BetaDistribution(4., .5), P_CDFPDF, GNUR_BETA_CDF_4_05, 1e-13);
    checkCDF(new BetaDistribution(.1, .5), P_CDFPDF, GNUR_BETA_CDF_01_05, 1e-14);
    checkCDF(new BetaDistribution(.5, .5), P_CDFPDF, GNUR_BETA_CDF_05_05, 1e-14);
  }

  @Test
  public void testQuantile() {
    checkQuantile(new BetaDistribution(1., 1.), P_QUANT, SCIPY_BETA_QUANT_1_1, 1e-15);
    checkQuantile(new BetaDistribution(2., 1.), P_QUANT, SCIPY_BETA_QUANT_2_1, 1e-15);
    checkQuantile(new BetaDistribution(4., 1.), P_QUANT, SCIPY_BETA_QUANT_4_1, 1e-15);
    checkQuantile(new BetaDistribution(.1, 1.), P_QUANT, SCIPY_BETA_QUANT_01_1, 1e-14);
    checkQuantile(new BetaDistribution(.5, 1.), P_QUANT, SCIPY_BETA_QUANT_05_1, 1e-14);
    checkQuantile(new BetaDistribution(1., 2.), P_QUANT, SCIPY_BETA_QUANT_1_2, 1e-14);
    checkQuantile(new BetaDistribution(2., 2.), P_QUANT, SCIPY_BETA_QUANT_2_2, 1e-15);
    checkQuantile(new BetaDistribution(4., 2.), P_QUANT, SCIPY_BETA_QUANT_4_2, 1e-15);
    checkQuantile(new BetaDistribution(.1, 2.), P_QUANT, SCIPY_BETA_QUANT_01_2, 1e-13);
    checkQuantile(new BetaDistribution(.5, 2.), P_QUANT, SCIPY_BETA_QUANT_05_2, 1e-14);
    checkQuantile(new BetaDistribution(1., 4.), P_QUANT, SCIPY_BETA_QUANT_1_4, 1e-14);
    checkQuantile(new BetaDistribution(2., 4.), P_QUANT, SCIPY_BETA_QUANT_2_4, 1e-15);
    checkQuantile(new BetaDistribution(4., 4.), P_QUANT, SCIPY_BETA_QUANT_4_4, 1e-15);
    checkQuantile(new BetaDistribution(.1, 4.), P_QUANT, SCIPY_BETA_QUANT_01_4, 1e-13);
    checkQuantile(new BetaDistribution(.5, 4.), P_QUANT, SCIPY_BETA_QUANT_05_4, 1e-14);
    checkQuantile(new BetaDistribution(1., .1), P_QUANT, SCIPY_BETA_QUANT_1_01, 1e-14);
    checkQuantile(new BetaDistribution(2., .1), P_QUANT, SCIPY_BETA_QUANT_2_01, 1e-15);
    checkQuantile(new BetaDistribution(4., .1), P_QUANT, SCIPY_BETA_QUANT_4_01, 1e-15);
    checkQuantile(new BetaDistribution(.1, .1), P_QUANT, SCIPY_BETA_QUANT_01_01, 1e-13);
    checkQuantile(new BetaDistribution(.5, .1), P_QUANT, SCIPY_BETA_QUANT_05_01, 1e-14);
    checkQuantile(new BetaDistribution(1., .5), P_QUANT, SCIPY_BETA_QUANT_1_05, 1e-14);
    checkQuantile(new BetaDistribution(2., .5), P_QUANT, SCIPY_BETA_QUANT_2_05, 1e-15);
    checkQuantile(new BetaDistribution(4., .5), P_QUANT, SCIPY_BETA_QUANT_4_05, 1e-15);
    checkQuantile(new BetaDistribution(.1, .5), P_QUANT, SCIPY_BETA_QUANT_01_05, 1e-14);
    checkQuantile(new BetaDistribution(.5, .5), P_QUANT, SCIPY_BETA_QUANT_05_05, 1e-14);
    checkQuantile(new BetaDistribution(5000, 10000), P_QUANT, SCIPY_BETA_QUANT_5000_10000, 1e-13);

    checkQuantile(new BetaDistribution(1., 1.), P_QUANT, GNUR_BETA_QUANT_1_1, 1e-15);
    checkQuantile(new BetaDistribution(2., 1.), P_QUANT, GNUR_BETA_QUANT_2_1, 1e-15);
    checkQuantile(new BetaDistribution(4., 1.), P_QUANT, GNUR_BETA_QUANT_4_1, 1e-15);
    checkQuantile(new BetaDistribution(.1, 1.), P_QUANT, GNUR_BETA_QUANT_01_1, 1e-13);
    checkQuantile(new BetaDistribution(.5, 1.), P_QUANT, GNUR_BETA_QUANT_05_1, 1e-14);
    checkQuantile(new BetaDistribution(1., 2.), P_QUANT, GNUR_BETA_QUANT_1_2, 1e-14);
    checkQuantile(new BetaDistribution(2., 2.), P_QUANT, GNUR_BETA_QUANT_2_2, 1e-15);
    checkQuantile(new BetaDistribution(4., 2.), P_QUANT, GNUR_BETA_QUANT_4_2, 1e-15);
    checkQuantile(new BetaDistribution(.1, 2.), P_QUANT, GNUR_BETA_QUANT_01_2, 1e-14);
    checkQuantile(new BetaDistribution(.5, 2.), P_QUANT, GNUR_BETA_QUANT_05_2, 1e-14);
    checkQuantile(new BetaDistribution(1., 4.), P_QUANT, GNUR_BETA_QUANT_1_4, 1e-14);
    checkQuantile(new BetaDistribution(2., 4.), P_QUANT, GNUR_BETA_QUANT_2_4, 1e-15);
    checkQuantile(new BetaDistribution(4., 4.), P_QUANT, GNUR_BETA_QUANT_4_4, 1e-15);
    checkQuantile(new BetaDistribution(.1, 4.), P_QUANT, GNUR_BETA_QUANT_01_4, 1e-13);
    checkQuantile(new BetaDistribution(.5, 4.), P_QUANT, GNUR_BETA_QUANT_05_4, 1e-14);
    checkQuantile(new BetaDistribution(1., .1), P_QUANT, GNUR_BETA_QUANT_1_01, 1e-14);
    checkQuantile(new BetaDistribution(2., .1), P_QUANT, GNUR_BETA_QUANT_2_01, 1e-15);
    checkQuantile(new BetaDistribution(4., .1), P_QUANT, GNUR_BETA_QUANT_4_01, 1e-15);
    checkQuantile(new BetaDistribution(.1, .1), P_QUANT, GNUR_BETA_QUANT_01_01, 1e-13);
    checkQuantile(new BetaDistribution(.5, .1), P_QUANT, GNUR_BETA_QUANT_05_01, 1e-14);
    checkQuantile(new BetaDistribution(1., .5), P_QUANT, GNUR_BETA_QUANT_1_05, 1e-14);
    checkQuantile(new BetaDistribution(2., .5), P_QUANT, GNUR_BETA_QUANT_2_05, 1e-15);
    checkQuantile(new BetaDistribution(4., .5), P_QUANT, GNUR_BETA_QUANT_4_05, 1e-15);
    checkQuantile(new BetaDistribution(.1, .5), P_QUANT, GNUR_BETA_QUANT_01_05, 1e-14);
    checkQuantile(new BetaDistribution(.5, .5), P_QUANT, GNUR_BETA_QUANT_05_05, 1e-14);
    checkQuantile(new BetaDistribution(5000, 10000), P_QUANT, GNUR_BETA_QUANT_5000_10000, 1e-13);
  }
}
