# Goal #

The goal is that we provide a full-automatic debian-upgrade solution for all 
conffiles, except those that were modified on the same key on both sides.

The goal of elektra is to provide a universal and secure framework to store 
configuration parameters in a global, hierarchical key database.


# Strategy #

To achieve the goal we will provide (during GSoC) building blocks, tool support and examples how the goals can be achieved. 
That means spreading the word and the idea is our main strategy to achieve the goal.
Apart from that the needed merging infrastructure will be integrated into the Elektra framework and patches for
involved tools will be implemented if needed.

# Architecture #

This section describes the building blocks and tool support to achieve the goal.

The following explanation describes the different states of a debian package in detail:
https://wiki.debian.org/MaintainerScripts.

## Setup ##

For all other steps we need some infrastructure, namely:
- a very good debian package, ideally
- the Elektra mounting framework
- an Elektra backend for the configuration in the chosen package (ideally a package is chosen for which a backend already exists)

## Installation ##

### two-Way vs three-Way merge ###

When a package is installed the conffiles are copied and a md5 sum is taken and 
stored in status.
e.g. /var/lib/dpkg/status would contain
`/etc/anacrontab 00ff43422e8756204113c5546b00d529`

Additionally the md5 sum of the newly installed configuration file (maintainer version) is calculated. This allows dpkg to determine
if the configuration file was modified by the user. In this case dpkg would allow only to choose one of these two versions.

With these two files only a two-way merge would be possible. However, in most cases a three-way merge would be preferrable. In order
to achieve a three-way merge, we additionally need to keep the base config file (the whole config file and not only its md5 sum):

e.g. store base config file /etc/anacrontab below 
`/var/lib/dpkg/conffiles/00ff43422e8756204113c5546b00d529`

The base config file can be one of these two:
- the version shipped with the package when it was initially installed
- if the package is upgraded the version that results from merging the new configuration file

As dpkg does not provide this functionality yet, two options exist on howto achieve this:
- provide a patch for dpkg
- do it via the maintainer scripts (e.g. with the help of ucf)

### Integration with Elektra ###

To achieve the goal with Elektras, we additionally need to make the configuration file(s) available 
in the Elektra framework. That means to mount each configuration file during installation
e.g. `kdb mount /etc/anacrontab system/anachron anachron`

The additional information where to mount + how to mount needs to be known and must be provided by the package.
The current idea is to ship this information in a special specification file. This file could not only contain
information on how to mount the configuration file, but also additional information about the structure
of the file as used by for example the contextual values (see Elektra 0.8.7 or newer for more details).

### Line plugin ###

If the information on how to mount the configuration in Elektra is missing, or no fitting storage plugin is available, 
a feasible default should be provided. For that reason a storage plugin is needed that is able to mount every 
configuration file regardless of its structure. This is the line plugin.

The line plugin simply converts line found in a configuration file into an own key. While this eliminates most of the
advantages of Elektra, it allows to reuse the rest of the merging framework even for configurations without existing
Elektra integration. 

### TASKS ###
- [x] evaluate a patch for dpkg (see dpkg evaluation and the corresponding blog post)
- [ ] provide the needed infrastructure to ship mount specifications with packages
- [x] modify "kdb-mount" so that options to plugins can be passed (some plugins need initial configuration) (see kdb mount options)
- [x] implement the line plugin (the development of this plugin was used to write the plugin writing tutorial http://community.libelektra.org/wp/)

## Upgrading ##

When a package is upgraded, the new (maintainers) config file needs to be installed to /etc/anacrontab.dpkg-new and mounted.
Also the base configuration file has to be mounted. The user modified configuration file should be mounted already, but if not it
needs to be mounted too.

After all three parts have been mounted, Elektra can be used to merge the resulting KeySets and finally write the result KeySet back
to the configuration. This merge should happen as automatic as possible, probably supported by additional information provided in the
before mentioned specification file shipped with the package.

dpkg currently is not able to attempt an automatic merge. Therefore two options exist on how to trigger this automatic merge:
- provide a patch for dpkg
- do it via the maintainer scripts

Tasks:
- [x] evaluate a dpkg patch (see dpkg evaluation and the corresponding blog post)
- [x] umount via path (makes merge script easier)
- [ ] integrate mounting and merging process into the package upgrade (+ pull request for Manoj)
- [x] add merge functionality to kdb tool ("kdb-merge") (see the blogpost on merging)
- [x] provide examples for implementing different merging strategies (see the blogpost on merging)

## Removing ##

When a package is removed, the conffiles are unmounted, but not removed.
The unmounting is needed, because the dependencies to make the backend work might be gone.

Tasks:
- [x] integrate the unmounting process into the package removal

## Purging ##

Then the conffiles will be removed, too.

The only change is that the file below /var/lib/dpkg/conffiles needs to be removed, too.

## dpkg evaluation ##

As a first try to modify dpkg we set out to develop a generic merging hook. This means providing a command to dpkg to call in the case
of a configuration file conflict. This would not only help with achieving the above goals, but also provide an option for people who
do not want to use the Elektra merging infrastrucutre (for example they could call their favorite merging tool). As it turned out, 
the request for such a feature already existed in the form of a bug report in the BTS (https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=32877).
Even better, somebody already had written exactly what we needed. The only thing we had to do was to reintegrate the patch with the newer dpkg version.
We posted the ported patch to the mailing list (https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=32877#84) and asked if anyone was still interested
in a threeway merge. Unfortunately we received no answer and because many of the dpkg bugs remained unanswered for several years, we decided
to abandon the idea of patching dpkg. It would be a loss of time to develop an even more complex patch for the base file handling (especially because
some parts of the dpkg source are very tricky and hard to understand), knowing that it will possibly never accepted. 

## Demonstration ##

To demonstrate that it works, we need:
- Modified packages that make use of it (have needed conffiles options)
- Tutorials what Maintainers need to do to have that feature
- Also have elektrifed software, that uses elektra even for their native 
  storage
- The more is upstream and the more people have heard of it, the better


## Documentation and Tutorials ##

In order to keep people up to date with what we are working on, providing regular blog entries is very important. Especially after all the work done blog entries about the following should be written as soon as possible:

- [X] Plug-in Tutorial (about contract)
- [X] the evaluation about a dpkg patch (see above)
- [X] the line based plugin and why it is needed
- [X] Progress of the Debian Package
- [X] the merging framework and its strategies (how to use "kdb merge")
- [X] a tutorial about how to integrate the kdb merging into a package
- [X] about the ucf integration
- [X] what else has been done on the way to the final integration eg.(mount config, ini plugin, ...)
- [ ] Augeas, Config::Model
- [ ] How to use import/export, links missing, export different formats missing
- [ ] about the samba integration
- [ ] compare with diff3, git
- [ ] about our fixed Debian bug


# Quality #

## Idempotence ##

All steps must be repeatable without any harm.

## Testing ##

Because mangling configuration files can be very dangerous, the resulting code has to be tested extensively.

## Merge ##

The quality of the merge itself is of course very relevant, too. 
Interesting properties include:
- can it cope with added lines on both sides in comments
- can it cope with added lines in arrays
  (especially important for line oriented config files like fstab)

# OTHER TASKS #

## Important ##

- [X] provide Elektra debian packages for the new version (Pino Toscano)
- [ ] fix a Debian bug report

## Not so important ##

- [X] fix strategies to be used the same way for "kdb import" and "kdb merge"
- [ ] provide a kdb cmp tool for simply comparing configurations
- [ ] evaluate merge heuristics for line based data (e.g. comments, key arrays)
