/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import java.util.Vector;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIObjectiveData;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class CMIObjectives
extends CMICategory
implements Serializable {
    public Vector objectives = new Vector();
    static int CMIOBJ_MIN_NUM_TOKENS = 3;

    public CMIObjectives() {
        super(true);
    }

    public Vector getObjectives() {
        return this.objectives;
    }

    public void setObjectives(CMIObjectiveData objective, int index) {
        this.objectives.add(index, objective);
    }

    public String performGet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        if (DebugIndicator.ON) {
            System.out.println("CMIObjectives::performGet()");
        }
        String result = new String("");
        if (this.isValidObjRequest(theRequest)) {
            String token = theRequest.getNextToken();
            if (DebugIndicator.ON) {
                System.out.println("Token being processed: " + token);
            }
            if (theRequest.hasMoreTokensToProcess()) {
                try {
                    Integer tmpInt = new Integer(token);
                    int indexOfArr = tmpInt;
                    try {
                        CMIObjectiveData objData = (CMIObjectiveData)this.objectives.elementAt(indexOfArr);
                        result = objData.performGet(theRequest, dmErrorMgr);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        if (DebugIndicator.ON) {
                            System.out.println("Element does not exist at the given index");
                            System.out.println("Index: " + indexOfArr);
                        }
                        dmErrorMgr.SetCurrentErrorCode("201");
                    }
                }
                catch (NumberFormatException nfe) {
                    if (DebugIndicator.ON) {
                        System.out.println("Error - Data Model Element not implemented");
                        System.out.println("Invalid data model element: " + theRequest.getRequest() + " passed to LMSGetValue()");
                        System.out.println("Array index required");
                    }
                    dmErrorMgr.SetCurrentErrorCode("401");
                }
            } else if (theRequest.isAChildrenRequest()) {
                result = this.getChildren();
            } else if (theRequest.isACountRequest()) {
                int count = 0;
                count = this.objectives.size();
                System.out.println("Count: " + count);
                Integer tmpInt = new Integer(count);
                result = tmpInt.toString();
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Data Model Element not implemented");
                    System.out.println("Invalid request: " + theRequest.getRequest());
                }
                dmErrorMgr.recNotImplementedError(theRequest);
            }
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Invalid request: " + theRequest.getRequest());
            }
            dmErrorMgr.SetCurrentErrorCode("401");
        }
        theRequest.done();
        if (DebugIndicator.ON) {
            System.out.println("Returning from CMIObjectives::performGet()");
            System.out.println("Value returned: " + result);
        }
        return result;
    }

    public String getChildren() {
        String children = "id,score,status";
        return children;
    }

    public void performSet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        if (DebugIndicator.ON) {
            System.out.println("CMIObjectives::performSet()");
        }
        int index = -1;
        String token = theRequest.getNextToken();
        if (DebugIndicator.ON) {
            System.out.println("Token being processed: " + token);
        }
        try {
            Integer tmpInt = new Integer(token);
            index = tmpInt;
            CMIObjectiveData tmpObj = (CMIObjectiveData)this.objectives.elementAt(index);
            tmpObj.performSet(theRequest, dmErrorMgr);
            this.objectives.set(index, tmpObj);
        }
        catch (NumberFormatException nfe) {
            if (theRequest.isAKeywordRequest()) {
                dmErrorMgr.recKeyWordError(token);
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Data Model Element not implemented");
                    System.out.println("Invalid data model element: " + theRequest.getRequest() + " passed to LMSSetValue()");
                }
                dmErrorMgr.recNotImplementedError(theRequest);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (DebugIndicator.ON) {
                System.out.println("First time setting the Objective Data");
            }
            if (index <= this.objectives.size()) {
                CMIObjectiveData objData = new CMIObjectiveData();
                objData.performSet(theRequest, dmErrorMgr);
                this.objectives.add(index, objData);
            }
            dmErrorMgr.SetCurrentErrorCode("201");
        }
        theRequest.done();
    }

    private boolean isValidObjRequest(CMIRequest theRequest) {
        boolean rtrnFlag = false;
        if (theRequest.getTotalNumTokens() >= CMIOBJ_MIN_NUM_TOKENS) {
            rtrnFlag = true;
        }
        return rtrnFlag;
    }
}

