/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.StringValue;

public class JTokenIterator
implements SequenceIterator {
    private CharSequence input;
    private Pattern pattern;
    private Matcher matcher;
    private CharSequence current;
    private int position = 0;
    private int prevEnd = 0;

    public JTokenIterator(CharSequence input, Pattern pattern) {
        this.input = input;
        this.pattern = pattern;
        this.matcher = pattern.matcher(input);
        this.prevEnd = 0;
    }

    public Item next() {
        if (this.prevEnd < 0) {
            this.current = null;
            this.position = -1;
            return null;
        }
        if (this.matcher.find()) {
            this.current = this.input.subSequence(this.prevEnd, this.matcher.start());
            this.prevEnd = this.matcher.end();
        } else {
            this.current = this.input.subSequence(this.prevEnd, this.input.length());
            this.prevEnd = -1;
        }
        ++this.position;
        return StringValue.makeStringValue(this.current);
    }

    public Item current() {
        return this.current == null ? null : StringValue.makeStringValue(this.current);
    }

    public int position() {
        return this.position;
    }

    public void close() {
    }

    public SequenceIterator getAnother() {
        return new JTokenIterator(this.input, this.pattern);
    }

    public int getProperties() {
        return 0;
    }
}

