/****
DIAMOND protein aligner
Copyright (C) 2020 Max Planck Society for the Advancement of Science e.V.

Code developed by Benjamin Buchfink <benjamin.buchfink@tue.mpg.de>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
****/

#include "../standard_matrix.h"

namespace Stats {

const StandardMatrix pam70{

    10, 1,

	{ { (double)INT2_MAX, (double)INT2_MAX, (double)INT2_MAX, 0.3345, 0.229, 1.029, 0.3250,   -0.7, 0.511296, 0.633439, 0.633439 },
	{ 8, 2, (double)INT2_MAX, 0.301, 0.12, 0.54, 0.56, -5, 0.549019, 2.881650, 3.025710 },
	{ 7, 2, (double)INT2_MAX, 0.286, 0.093, 0.43, 0.67, -7, 0.565659, 4.534540, 4.785780 },
	{ 6, 2, (double)INT2_MAX, 0.264, 0.064, 0.29, 0.90, -12, 0.596330, 7.942630, 8.402720 },
	{ 11, 1, (double)INT2_MAX, 0.305, 0.12, 0.52, 0.59, -6, 0.543514, 3.681400, 4.108020 },
	{ 10, 1, (double)INT2_MAX, 0.291, 0.091, 0.41, 0.71, -9, 0.560723, 6.002970, 6.716570 },
	{ 9, 1, (double)INT2_MAX, 0.270, 0.060, 0.28, 0.97, -14, 0.585186, 11.360800, 12.636700 } },

    {
  /*       A,  R,  N,  D,  C,  Q,  E,  G,  H,  I,  L,  K,  M,
             F,  P,  S,  T,  W,  Y,  V,  B,  J,  Z,  X,  *        */ 
    /*A*/    5, -4, -2, -1, -4, -2, -1,  0, -4, -2, -4, -4, -3,
            -6,  0,  1,  1, -9, -5, -1, -1, -3, -1, -1,-11, -14,
    /*R*/   -4,  8, -3, -6, -5,  0, -5, -6,  0, -3, -6,  2, -2,
            -7, -2, -1, -4,  0, -7, -5, -4, -5, -2, -1,-11, -14,
    /*N*/   -2, -3,  6,  3, -7, -1,  0, -1,  1, -3, -5,  0, -5,
            -6, -3,  1,  0, -6, -3, -5,  5, -4, -1, -1,-11, -14,
    /*D*/   -1, -6,  3,  6, -9,  0,  3, -1, -1, -5, -8, -2, -7,
           -10, -4, -1, -2,-10, -7, -5,  5, -7,  2, -1,-11, -14,
    /*C*/   -4, -5, -7, -9,  9, -9, -9, -6, -5, -4,-10, -9, -9,
            -8, -5, -1, -5,-11, -2, -4, -8, -7, -9, -1,-11, -14,
    /*Q*/   -2,  0, -1,  0, -9,  7,  2, -4,  2, -5, -3, -1, -2,
            -9, -1, -3, -3, -8, -8, -4, -1, -3,  5, -1,-11, -14,
    /*E*/   -1, -5,  0,  3, -9,  2,  6, -2, -2, -4, -6, -2, -4,
            -9, -3, -2, -3,-11, -6, -4,  2, -5,  5, -1,-11, -14,
    /*G*/    0, -6, -1, -1, -6, -4, -2,  6, -6, -6, -7, -5, -6,
            -7, -3,  0, -3,-10, -9, -3, -1, -7, -3, -1,-11, -14,
    /*H*/   -4,  0,  1, -1, -5,  2, -2, -6,  8, -6, -4, -3, -6,
            -4, -2, -3, -4, -5, -1, -4,  0, -4,  1, -1,-11, -14,
    /*I*/   -2, -3, -3, -5, -4, -5, -4, -6, -6,  7,  1, -4,  1,
             0, -5, -4, -1, -9, -4,  3, -4,  4, -4, -1,-11, -14,
    /*L*/   -4, -6, -5, -8,-10, -3, -6, -7, -4,  1,  6, -5,  2,
            -1, -5, -6, -4, -4, -4,  0, -6,  5, -4, -1,-11, -14,
    /*K*/   -4,  2,  0, -2, -9, -1, -2, -5, -3, -4, -5,  6,  0,
            -9, -4, -2, -1, -7, -7, -6, -1, -5, -2, -1,-11, -14,
    /*M*/   -3, -2, -5, -7, -9, -2, -4, -6, -6,  1,  2,  0, 10,
            -2, -5, -3, -2, -8, -7,  0, -6,  2, -3, -1,-11, -14,
    /*F*/   -6, -7, -6,-10, -8, -9, -9, -7, -4,  0, -1, -9, -2,
             8, -7, -4, -6, -2,  4, -5, -7, -1, -9, -1,-11, -14,
    /*P*/    0, -2, -3, -4, -5, -1, -3, -3, -2, -5, -5, -4, -5,
            -7,  7,  0, -2, -9, -9, -3, -4, -5, -2, -1,-11, -14,
    /*S*/    1, -1,  1, -1, -1, -3, -2,  0, -3, -4, -6, -2, -3,
            -4,  0,  5,  2, -3, -5, -3,  0, -5, -2, -1,-11, -14,
    /*T*/    1, -4,  0, -2, -5, -3, -3, -3, -4, -1, -4, -1, -2,
            -6, -2,  2,  6, -8, -4, -1, -1, -3, -3, -1,-11, -14,
    /*W*/   -9,  0, -6,-10,-11, -8,-11,-10, -5, -9, -4, -7, -8,
            -2, -9, -3, -8, 13, -3,-10, -7, -5,-10, -1,-11, -14,
    /*Y*/   -5, -7, -3, -7, -2, -8, -6, -9, -1, -4, -4, -7, -7,
             4, -9, -5, -4, -3,  9, -5, -4, -4, -7, -1,-11, -14,
    /*V*/   -1, -5, -5, -5, -4, -4, -4, -3, -4,  3,  0, -6,  0,
            -5, -3, -3, -1,-10, -5,  6, -5,  1, -4, -1,-11, -14,
    /*B*/   -1, -4,  5,  5, -8, -1,  2, -1,  0, -4, -6, -1, -6,
            -7, -4,  0, -1, -7, -4, -5,  5, -5,  1, -1,-11, -14,
    /*J*/   -3, -5, -4, -7, -7, -3, -5, -7, -4,  4,  5, -5,  2,
            -1, -5, -5, -3, -5, -4,  1, -5,  5, -4, -1,-11, -14,
    /*Z*/   -1, -2, -1,  2, -9,  5,  5, -3,  1, -4, -4, -2, -3,
            -9, -2, -2, -3,-10, -7, -4,  1, -4,  5, -1,-11, -14,
    /*X*/   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,-11, -14,
    /***/  -11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,
           -11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,  1, -14,
		   -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14,
		   -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14 },

{ {3.7194198649883180e-02, 8.0875430987034625e-04, 2.0736464600905839e-03,
   2.5255595007111849e-03, 7.0597624705127243e-04, 1.5518877282373696e-03,
   3.3281196505185301e-03, 7.8361919930011979e-03, 6.4846822847107975e-04,
   1.3965782283733507e-03, 1.8572709391302328e-03, 1.7482550126124556e-03,
   4.8307675706277730e-04, 4.6722180304288895e-04, 4.5500317017840861e-03,
   8.1815610080975230e-03, 6.7687959354540955e-03, 3.9553416320695907e-05,
   4.0198038575772689e-04, 4.5596297635283793e-03},
  {8.0875430987034625e-04, 2.2852256980208891e-02, 6.3934638630944640e-04,
   2.6565526087426409e-04, 2.0716330531302742e-04, 1.6017418992100730e-03,
   3.6247967443696756e-04, 4.4251315906877157e-04, 1.4545996303067922e-03,
   4.5486189188160571e-04, 4.7958376254792433e-04, 6.3755221317218641e-03,
   2.9453018991274540e-04, 1.6164674287424461e-04, 1.0920151094434257e-03,
   1.7360744550429996e-03, 6.7924379689915479e-04, 4.2527485122100103e-04,
   1.0517171198521535e-04, 4.6545505887026243e-04},
  {2.0736464600905839e-03, 6.3934638630944640e-04, 1.2675260298758369e-02,
   4.5473263538386658e-03, 1.3072655726453243e-04, 9.8476934026016437e-04,
   1.9319282404800279e-03, 2.3638339620501124e-03, 2.2789366146196482e-03,
   4.8031915042001503e-04, 6.3784180585582998e-04, 3.6406443267426908e-03,
   1.0839896462648394e-04, 2.1124510348244946e-04, 7.0593648786013011e-04,
   3.8434299995336323e-03, 2.1278266383167998e-03, 5.8506014024617153e-05,
   4.7128194649955374e-04, 5.2108088709319821e-04},
  {2.5255595007111849e-03, 2.6565526087426409e-04, 4.5473263538386658e-03,
   1.9552340613266873e-02, 6.2308454328698375e-05, 1.6541837501367655e-03,
   7.7926300406749079e-03, 2.6556442405114718e-03, 9.4505604487949357e-04,
   3.3373212803700417e-04, 2.5428746885488489e-04, 1.8252265778963348e-03,
   7.1571301890192352e-05, 6.2699722593189186e-05, 5.0522979322628484e-04,
   1.9557928207999562e-03, 1.2131330526185470e-03, 1.2993511235541354e-05,
   1.1201266335522796e-04, 5.2454950790431021e-04},
  {7.0597624705127243e-04, 2.0716330531302742e-04, 1.3072655726453243e-04,
   6.2308454328698375e-05, 2.7825141122194648e-02, 5.0435716826920468e-05,
   6.4183020849751415e-05, 3.4312217142660280e-04, 1.8549298854202793e-04,
   3.0428065563695795e-04, 8.6272008280351356e-05, 1.0319775490385661e-04,
   2.1845897888507003e-05, 7.3005996818964865e-05, 2.6943290953722234e-04,
   1.5492275564647287e-03, 3.6530353715738469e-04, 7.8068100250333932e-06,
   5.2405357404561922e-04, 5.9453107180990322e-04},
  {1.5518877282373696e-03, 1.6017418992100730e-03, 9.8476934026016437e-04,
   1.6541837501367655e-03, 5.0435716826920468e-05, 1.6787102517888230e-02,
   4.2787747314313521e-03, 8.0400665120515828e-04, 2.8143703113243106e-03,
   2.6711588850824816e-04, 1.1454480615912710e-03, 2.2219191879465955e-03,
   2.7431052994878819e-04, 7.9884925062964878e-05, 1.3266385181226064e-03,
   9.9419711566964102e-04, 7.3752923373982926e-04, 2.2068032648929309e-05,
   8.4534917138966498e-05, 5.7451792180619309e-04},
  {3.3281196505185301e-03, 3.6247967443696756e-04, 1.9319282404800279e-03,
   7.7926300406749079e-03, 6.4183020849751415e-05, 4.2787747314313521e-03,
   2.1230224844830631e-02, 2.1586929726556546e-03, 7.9951624929977820e-04,
   5.1817013748561565e-04, 4.9671333905053393e-04, 1.8583368487577027e-03,
   1.5522247207982098e-04, 7.5329038569461125e-05, 8.7224608153784204e-04,
   1.6494397215528771e-03, 9.8039692363547162e-04, 9.8627013698496747e-06,
   1.7654014099528279e-04, 7.9167009135776051e-04},
  {7.8361919930011979e-03, 4.4251315906877157e-04, 2.3638339620501124e-03,
   2.6556442405114718e-03, 3.4312217142660280e-04, 8.0400665120515828e-04,
   2.1586929726556546e-03, 5.7388208411163856e-02, 4.3236801169914066e-04,
   3.4974476371122900e-04, 6.1249836569746629e-04, 1.4966553087392409e-03,
   1.8860818518822553e-04, 3.5290430601106194e-04, 1.3849768155457195e-03,
   5.9445746107512484e-03, 1.9215787027991949e-03, 2.5013133615378750e-05,
   1.1604677012097751e-04, 1.7949010789751496e-03},
  {6.4846822847107975e-04, 1.4545996303067922e-03, 2.2789366146196482e-03,
   9.4505604487949357e-04, 1.8549298854202793e-04, 2.8143703113243106e-03,
   7.9951624929977820e-04, 4.3236801169914066e-04, 1.8560540662079211e-02,
   1.7329804084653826e-04, 7.4343007070569922e-04, 9.0662732602859596e-04,
   6.0703685726216408e-05, 3.6980044394832400e-04, 8.3973781481707591e-04,
   7.6422387310404486e-04, 4.5318311225648759e-04, 6.5639640674803356e-05,
   6.1489346188958391e-04, 5.0752810340000398e-04},
  {1.3965782283733507e-03, 4.5486189188160571e-04, 4.8031915042001503e-04,
   3.3373212803700417e-04, 3.0428065563695795e-04, 2.6711588850824816e-04,
   5.1817013748561565e-04, 3.4974476371122900e-04, 1.7329804084653826e-04,
   1.5987197880539435e-02, 3.7542109440494597e-03, 7.9047697379200301e-04,
   7.4501029384275877e-04, 1.2410414311848890e-03, 2.9830750222722838e-04,
   6.5095629385579479e-04, 1.6435015047341363e-03, 1.6913577722248789e-05,
   3.0951431979519975e-04, 7.1703817823281675e-03},
  {1.8572709391302328e-03, 4.7958376254792433e-04, 6.3784180585582998e-04,
   2.5428746885488489e-04, 8.6272008280351356e-05, 1.1454480615912710e-03,
   4.9671333905053393e-04, 6.1249836569746629e-04, 7.4343007070569922e-04,
   3.7542109440494597e-03, 5.9951531802758418e-02, 1.0493781626637116e-03,
   2.6814583560349986e-03, 2.7966586120273659e-03, 8.5989610618916832e-04,
   8.8237114340186434e-04, 1.2009021086866177e-03, 2.3930650357563717e-04,
   6.1025491368789397e-04, 5.0181292839441248e-03},
  {1.7482550126124556e-03, 6.3755221317218641e-03, 3.6406443267426908e-03,
   1.8252265778963348e-03, 1.0319775490385661e-04, 2.2219191879465955e-03,
   1.8583368487577027e-03, 1.4966553087392409e-03, 9.0662732602859596e-04,
   7.9047697379200301e-04, 1.0493781626637116e-03, 4.9293839020253936e-02,
   1.1255105312350092e-03, 1.3216275164777875e-04, 1.0446567434093407e-03,
   2.9144037757683188e-03, 2.9220724161787321e-03, 6.6880694143482477e-05,
   2.4262835127628017e-04, 7.2318948023856685e-04},
  {4.8307675706277730e-04, 2.9453018991274540e-04, 1.0839896462648394e-04,
   7.1571301890192352e-05, 2.1845897888507003e-05, 2.7431052994878819e-04,
   1.5522247207982098e-04, 1.8860818518822553e-04, 6.0703685726216408e-05,
   7.4501029384275877e-04, 2.6814583560349986e-03, 1.1255105312350092e-03,
   6.2216058278953433e-03, 2.9832445346669831e-04, 1.3153451000560772e-04,
   3.2741424213960572e-04, 4.2984024762048522e-04, 9.2547509155780498e-06,
   4.2944764664016277e-05, 1.0815956386861806e-03},
  {4.6722180304288895e-04, 1.6164674287424461e-04, 2.1124510348244946e-04,
   6.2699722593189186e-05, 7.3005996818964865e-05, 7.9884925062964878e-05,
   7.5329038569461125e-05, 3.5290430601106194e-04, 3.6980044394832400e-04,
   1.2410414311848890e-03, 2.7966586120273659e-03, 1.3216275164777875e-04,
   2.9832445346669831e-04, 2.7609457395367236e-02, 1.7973871152134819e-04,
   5.9661742408822192e-04, 3.2037468566685034e-04, 1.8874366992597410e-04,
   4.0197936157261114e-03, 5.3500773324884835e-04},
  {4.5500317017840861e-03, 1.0920151094434257e-03, 7.0593648786013011e-04,
   5.0522979322628484e-04, 2.6943290953722234e-04, 1.3266385181226064e-03,
   8.7224608153784204e-04, 1.3849768155457195e-03, 8.3973781481707591e-04,
   2.9830750222722838e-04, 8.5989610618916832e-04, 1.0446567434093407e-03,
   1.3153451000560772e-04, 1.7973871152134819e-04, 3.0491164657684509e-02,
   3.4531398828496866e-03, 1.5743611594360388e-03, 2.2239711690711994e-05,
   7.0790644298591358e-05, 1.0078399755563739e-03},
  {8.1815610080975230e-03, 1.7360744550429996e-03, 3.8434299995336323e-03,
   1.9557928207999562e-03, 1.5492275564647287e-03, 9.9419711566964102e-04,
   1.6494397215528771e-03, 5.9445746107512484e-03, 7.6422387310404486e-04,
   6.5095629385579479e-04, 8.8237114340186434e-04, 2.9144037757683188e-03,
   3.2741424213960572e-04, 5.9661742408822192e-04, 3.4531398828496866e-03,
   2.5194623995400022e-02, 6.9036292775662960e-03, 2.3646234303355702e-04,
   4.3310777955182051e-04, 1.3658286863463751e-03},
  {6.7687959354540955e-03, 6.7924379689915479e-04, 2.1278266383167998e-03,
   1.2131330526185470e-03, 3.6530353715738469e-04, 7.3752923373982926e-04,
   9.8039692363547162e-04, 1.9215787027991949e-03, 4.5318311225648759e-04,
   1.6435015047341363e-03, 1.2009021086866177e-03, 2.9220724161787321e-03,
   4.2984024762048522e-04, 3.2037468566685034e-04, 1.5743611594360388e-03,
   6.9036292775662960e-03, 2.5145073963504398e-02, 3.3504725726214485e-05,
   3.9901555652894171e-04, 2.7223976124681726e-03},
  {3.9553416320695907e-05, 4.2527485122100103e-04, 5.8506014024617153e-05,
   1.2993511235541354e-05, 7.8068100250333932e-06, 2.2068032648929309e-05,
   9.8627013698496747e-06, 2.5013133615378750e-05, 6.5639640674803356e-05,
   1.6913577722248789e-05, 2.3930650357563717e-04, 6.6880694143482477e-05,
   9.2547509155780498e-06, 1.8874366992597410e-04, 2.2239711690711994e-05,
   2.3646234303355702e-04, 3.3504725726214485e-05, 8.8772945001325369e-03,
   1.1825556331632613e-04, 1.8104742145890378e-05},
  {4.0198038575772689e-04, 1.0517171198521535e-04, 4.7128194649955374e-04,
   1.1201266335522796e-04, 5.2405357404561922e-04, 8.4534917138966498e-05,
   1.7654014099528279e-04, 1.1604677012097751e-04, 6.1489346188958391e-04,
   3.0951431979519975e-04, 6.1025491368789397e-04, 2.4262835127628017e-04,
   4.2944764664016277e-05, 4.0197936157261114e-03, 7.0790644298591358e-05,
   4.3310777955182051e-04, 3.9901555652894171e-04, 1.1825556331632613e-04,
   2.0713264962639342e-02, 3.5013220379328771e-04},
  {4.5596297635283793e-03, 4.6545505887026243e-04, 5.2108088709319821e-04,
   5.2454950790431021e-04, 5.9453107180990322e-04, 5.7451792180619309e-04,
   7.9167009135776051e-04, 1.7949010789751496e-03, 5.0752810340000398e-04,
   7.1703817823281675e-03, 5.0181292839441248e-03, 7.2318948023856685e-04,
   1.0815956386861806e-03, 5.3500773324884835e-04, 1.0078399755563739e-03,
   1.3658286863463751e-03, 2.7223976124681726e-03, 1.8104742145890378e-05,
   3.5013220379328771e-04, 3.4391130954492435e-02} },

   { 8.7126757718998679e-02, 4.0903890307999048e-02, 4.0432285538126674e-02,
     4.6871932807633972e-02, 3.3473507356366124e-02, 3.8255436978704142e-02,
     4.9530476921569762e-02, 8.8612083613937145e-02, 3.3618414314618796e-02,
     3.6885613388971901e-02, 8.5357443758733623e-02, 8.0481583375956817e-02,
     1.4752761600830055e-02, 3.9771658566274730e-02, 5.0679914836743105e-02,
     6.9577076005018168e-02, 5.8541664190993777e-02, 1.0493678893463984e-02,
     2.9916218247065893e-02, 6.4717601577993583e-02 },

  { {0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
{0.00000000e+00, 4.89972946e+00, 6.04638890e-01, 2.42067963e-01,
 6.18433760e-01, 7.71213936e-01, 1.34833512e-01, 1.01498720e+00,
 2.21390981e-01, 4.34566961e-01, 2.49319770e-01, 2.49736666e-01,
 3.75829845e-01, 5.88646912e-01, 1.03045017e+00, 4.65602795e-01,
 2.26934456e-01, 1.34964157e+00, 1.32707297e+00, 8.08640731e-01,
 4.32618091e-02, 7.50000000e-01, 1.54222102e-01, 6.38034395e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 3.05507349e-01},
{0.00000000e+00, 6.04638890e-01, 5.42142610e+00, 6.60540784e-02,
 5.88929014e+00, 2.24885858e+00, 7.88958522e-02, 6.48829213e-01,
 1.09845328e+00, 2.52789787e-01, 7.77906911e-01, 1.19715714e-01,
 1.39730820e-01, 4.87904539e+00, 2.73736473e-01, 7.90138593e-01,
 2.53425041e-01, 9.54703234e-01, 6.53688648e-01, 1.85063408e-01,
 7.80441148e-02, 7.50000000e-01, 2.23329473e-01, 1.61317606e+00,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.59869478e-01},
{0.00000000e+00, 2.42067963e-01, 6.60540784e-02, 2.48333286e+01,
 3.97130183e-02, 3.87120726e-02, 5.48382532e-02, 1.15679023e-01,
 1.64834856e-01, 2.46442788e-01, 3.83065039e-02, 3.01944614e-02,
 4.42379868e-02, 9.65904773e-02, 1.58823055e-01, 3.93861754e-02,
 1.51302811e-01, 6.65193229e-01, 1.86417892e-01, 2.74442219e-01,
 2.22251459e-02, 7.50000000e-01, 5.23320532e-01, 3.90058338e-02,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 9.54452197e-02},
{0.00000000e+00, 6.18433760e-01, 5.88929014e+00, 3.97130183e-02,
 8.89965209e+00, 3.35659301e+00, 3.36340414e-02, 6.39387415e-01,
 5.99746161e-01, 1.93031482e-01, 4.83846284e-01, 6.35580693e-02,
 1.03502951e-01, 2.39946804e+00, 2.12686642e-01, 9.22524100e-01,
 1.38560979e-01, 5.99713481e-01, 4.42110174e-01, 1.72922381e-01,
 2.64171458e-02, 7.50000000e-01, 7.98817496e-02, 2.29587193e+00,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.02625370e-01},
{0.00000000e+00, 7.71213936e-01, 2.24885858e+00, 3.87120726e-02,
 3.35659301e+00, 8.65385421e+00, 3.82398528e-02, 4.91841782e-01,
 4.80150693e-01, 2.83623924e-01, 4.66181910e-01, 1.17487568e-01,
 2.12426533e-01, 9.64695360e-01, 3.47480663e-01, 2.25815498e+00,
 1.78914910e-01, 4.78627630e-01, 3.38114944e-01, 2.46972907e-01,
 1.89756038e-02, 7.50000000e-01, 1.19141830e-01, 5.86672974e+00,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.67617543e-01},
{0.00000000e+00, 1.34833512e-01, 7.88958522e-02, 5.48382532e-02,
 3.36340414e-02, 3.82398528e-02, 1.74546228e+01, 1.00136016e-01,
 2.76577280e-01, 8.45971180e-01, 4.12894272e-02, 8.23804865e-01,
 5.08442478e-01, 1.31366508e-01, 8.91727264e-02, 5.25046736e-02,
 9.93639027e-02, 2.15603624e-01, 1.37600314e-01, 2.07856659e-01,
 4.52242030e-01, 7.50000000e-01, 3.37849562e+00, 4.44561913e-02,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 8.30493328e-01},
{0.00000000e+00, 1.01498720e+00, 6.48829213e-01, 1.15679023e-01,
 6.39387415e-01, 4.91841782e-01, 1.00136016e-01, 7.30864335e+00,
 1.45138751e-01, 1.07004308e-01, 2.09861286e-01, 8.09786598e-02,
 1.44276056e-01, 6.59774806e-01, 3.08399509e-01, 2.37177521e-01,
 1.22086776e-01, 9.64187863e-01, 3.70424893e-01, 3.12986176e-01,
 2.68996967e-02, 7.50000000e-01, 4.37757319e-02, 3.80863925e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 8.88316375e-02},
{0.00000000e+00, 2.21390981e-01, 1.09845328e+00, 1.64834856e-01,
 5.99746161e-01, 4.80150693e-01, 2.76577280e-01, 1.45138751e-01,
 1.64223829e+01, 1.39752446e-01, 3.35085062e-01, 2.59072609e-01,
 1.22395235e-01, 1.67658945e+00, 4.92867985e-01, 2.18832010e+00,
 1.05779530e+00, 3.26721114e-01, 2.30266854e-01, 2.33270842e-01,
 1.86063506e-01, 7.50000000e-01, 6.11386658e-01, 1.22453853e+00,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 2.23068949e-01},
{0.00000000e+00, 4.34566961e-01, 2.52789787e-01, 2.46442788e-01,
 1.93031482e-01, 2.83623924e-01, 8.45971180e-01, 1.07004308e-01,
 1.39752446e-01, 1.17505537e+01, 2.66278255e-01, 1.19239531e+00,
 1.36908981e+00, 3.22065793e-01, 1.59577365e-01, 1.89299534e-01,
 3.01479599e-01, 2.53646367e-01, 7.61111058e-01, 3.00374358e+00,
 4.36969076e-02, 7.50000000e-01, 2.80489781e-01, 2.42519143e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 4.37821344e+00},
{0.00000000e+00, 2.49319770e-01, 7.77906911e-01, 3.83065039e-02,
 4.83846284e-01, 4.66181910e-01, 4.12894272e-02, 2.09861286e-01,
 3.35085062e-01, 2.66278255e-01, 7.61026217e+00, 1.52754534e-01,
 9.47937549e-01, 1.11880255e+00, 2.56118662e-01, 7.21669881e-01,
 1.93666556e+00, 5.20459614e-01, 6.20196625e-01, 1.38845936e-01,
 7.91911207e-02, 7.50000000e-01, 1.00771644e-01, 5.77518724e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.87009175e-01},
{0.00000000e+00, 2.49736666e-01, 1.19715714e-01, 3.01944614e-02,
 6.35580693e-02, 1.17487568e-01, 8.23804865e-01, 8.09786598e-02,
 2.59072609e-01, 1.19239531e+00, 1.52754534e-01, 8.22843955e+00,
 2.12939550e+00, 1.84817584e-01, 1.98778178e-01, 3.50784854e-01,
 1.37359422e-01, 1.48574310e-01, 2.40326213e-01, 9.08401895e-01,
 2.67168548e-01, 7.50000000e-01, 2.38980900e-01, 2.19154102e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 6.10538395e+00},
{0.00000000e+00, 3.75829845e-01, 1.39730820e-01, 4.42379868e-02,
 1.03502951e-01, 2.12426533e-01, 5.08442478e-01, 1.44276056e-01,
 1.22395235e-01, 1.36908981e+00, 9.47937549e-01, 2.12939550e+00,
 2.85861616e+01, 1.81728699e-01, 1.75926195e-01, 4.86044449e-01,
 4.88080973e-01, 3.18976045e-01, 4.97701201e-01, 1.13284160e+00,
 5.97810639e-02, 7.50000000e-01, 9.73038916e-02, 3.31664034e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.89998090e+00},
{0.00000000e+00, 5.88646912e-01, 4.87904539e+00, 9.65904773e-02,
 2.39946804e+00, 9.64695360e-01, 1.31366508e-01, 6.59774806e-01,
 1.67658945e+00, 3.22065793e-01, 1.11880255e+00, 1.84817584e-01,
 1.81728699e-01, 7.75354485e+00, 3.44509706e-01, 6.36668056e-01,
 3.86583495e-01, 1.36623218e+00, 8.98965212e-01, 1.99138136e-01,
 1.37893708e-01, 7.50000000e-01, 3.89624106e-01, 8.21747280e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 2.26230851e-01},
{0.00000000e+00, 1.03045017e+00, 2.73736473e-01, 1.58823055e-01,
 2.12686642e-01, 3.47480663e-01, 8.91727264e-02, 3.08399509e-01,
 4.92867985e-01, 1.59577365e-01, 2.56118662e-01, 1.98778178e-01,
 1.75926195e-01, 3.44509706e-01, 1.18714088e+01, 6.84263791e-01,
 5.26778639e-01, 9.79291808e-01, 5.30644206e-01, 3.07279290e-01,
 4.18182164e-02, 7.50000000e-01, 4.66910129e-02, 4.94244365e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.86949727e-01},
{0.00000000e+00, 4.65602795e-01, 7.90138593e-01, 3.93861754e-02,
 9.22524100e-01, 2.25815498e+00, 5.25046736e-02, 2.37177521e-01,
 2.18832010e+00, 1.89299534e-01, 7.21669881e-01, 3.50784854e-01,
 4.86044449e-01, 6.36668056e-01, 6.84263791e-01, 1.14706864e+01,
 1.02361055e+00, 3.73519396e-01, 3.29322200e-01, 2.32053434e-01,
 5.49721446e-02, 7.50000000e-01, 7.38645866e-02, 6.27280154e+00,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 3.02058283e-01},
{0.00000000e+00, 2.26934456e-01, 2.53425041e-01, 1.51302811e-01,
 1.38560979e-01, 1.78914910e-01, 9.93639027e-02, 1.22086776e-01,
 1.05779530e+00, 3.01479599e-01, 1.93666556e+00, 1.37359422e-01,
 4.88080973e-01, 3.86583495e-01, 5.26778639e-01, 1.02361055e+00,
 1.36584013e+01, 6.10010848e-01, 2.83658630e-01, 1.75829089e-01,
 9.90780192e-01, 7.50000000e-01, 8.59463892e-02, 5.47017256e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.86881035e-01},
{0.00000000e+00, 1.34964157e+00, 9.54703234e-01, 6.65193229e-01,
 5.99713481e-01, 4.78627630e-01, 2.15603624e-01, 9.64187863e-01,
 3.26721114e-01, 2.53646367e-01, 5.20459614e-01, 1.48574310e-01,
 3.18976045e-01, 1.36623218e+00, 9.79291808e-01, 3.73519396e-01,
 6.10010848e-01, 5.20445832e+00, 1.69490837e+00, 3.03324606e-01,
 3.23868004e-01, 7.50000000e-01, 2.08076540e-01, 4.32823454e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.80278747e-01},
{0.00000000e+00, 1.32707297e+00, 6.53688648e-01, 1.86417892e-01,
 4.42110174e-01, 3.38114944e-01, 1.37600314e-01, 3.70424893e-01,
 2.30266854e-01, 7.61111058e-01, 6.20196625e-01, 2.40326213e-01,
 4.97701201e-01, 8.98965212e-01, 5.30644206e-01, 3.29322200e-01,
 2.83658630e-01, 1.69490837e+00, 7.33707214e+00, 7.18561720e-01,
 5.45397612e-02, 7.50000000e-01, 2.27833757e-01, 3.34283233e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 3.97467804e-01},
{0.00000000e+00, 8.08640731e-01, 1.85063408e-01, 2.74442219e-01,
 1.72922381e-01, 2.46972907e-01, 2.07856659e-01, 3.12986176e-01,
 2.33270842e-01, 3.00374358e+00, 1.38845936e-01, 9.08401895e-01,
 1.13284160e+00, 1.99138136e-01, 3.07279290e-01, 2.32053434e-01,
 1.75829089e-01, 3.03324606e-01, 7.18561720e-01, 8.21110545e+00,
 2.66588959e-02, 7.50000000e-01, 1.80843519e-01, 2.40471284e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.54065018e+00},
{0.00000000e+00, 4.32618091e-02, 7.80441148e-02, 2.22251459e-02,
 2.64171458e-02, 1.89756038e-02, 4.52242030e-01, 2.68996967e-02,
 1.86063506e-01, 4.36969076e-02, 7.91911207e-02, 2.67168548e-01,
 5.97810639e-02, 1.37893708e-01, 4.18182164e-02, 5.49721446e-02,
 9.90780192e-01, 3.23868004e-01, 5.45397612e-02, 2.66588959e-02,
 8.06167129e+01, 7.50000000e-01, 3.76692625e-01, 3.46622138e-02,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.99738227e-01},
{0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 7.50000000e-01},
{0.00000000e+00, 1.54222102e-01, 2.23329473e-01, 5.23320532e-01,
 7.98817496e-02, 1.19141830e-01, 3.37849562e+00, 4.37757319e-02,
 6.11386658e-01, 2.80489781e-01, 1.00771644e-01, 2.38980900e-01,
 9.73038916e-02, 3.89624106e-01, 4.66910129e-02, 7.38645866e-02,
 8.59463892e-02, 2.08076540e-01, 2.27833757e-01, 1.80843519e-01,
 3.76692625e-01, 7.50000000e-01, 2.31438270e+01, 9.94108657e-02,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 2.51505787e-01},
{0.00000000e+00, 6.38034395e-01, 1.61317606e+00, 3.90058338e-02,
 2.29587193e+00, 5.86672974e+00, 4.44561913e-02, 3.80863925e-01,
 1.22453853e+00, 2.42519143e-01, 5.77518724e-01, 2.19154102e-01,
 3.31664034e-01, 8.21747280e-01, 4.94244365e-01, 6.27280154e+00,
 5.47017256e-01, 4.32823454e-01, 3.34283233e-01, 2.40471284e-01,
 3.46622138e-02, 7.50000000e-01, 9.94108657e-02, 6.04368813e+00,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 2.26204268e-01},
{0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 7.50000000e-01},
{0.00000000e+00, 2.00000000e-02, 2.00000000e-02, 2.00000000e-02,
 2.00000000e-02, 2.00000000e-02, 2.00000000e-02, 2.00000000e-02,
 2.00000000e-02, 2.00000000e-02, 2.00000000e-02, 2.00000000e-02,
 2.00000000e-02, 2.00000000e-02, 2.00000000e-02, 2.00000000e-02,
 2.00000000e-02, 2.00000000e-02, 2.00000000e-02, 2.00000000e-02,
 2.00000000e-02, 2.00000000e-02, 2.00000000e-02, 2.00000000e-02,
 2.00000000e-02, 1.33300000e+00, 2.00000000e-02, 2.00000000e-02},
{0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 7.50000000e-01},
{0.00000000e+00, 3.05507349e-01, 1.59869478e-01, 9.54452197e-02,
 1.02625370e-01, 1.67617543e-01, 8.30493328e-01, 8.88316375e-02,
 2.23068949e-01, 4.37821344e+00, 1.87009175e-01, 6.10538395e+00,
 1.89998090e+00, 2.26230851e-01, 1.86949727e-01, 3.02058283e-01,
 1.86881035e-01, 1.80278747e-01, 3.97467804e-01, 1.54065018e+00,
 1.99738227e-01, 7.50000000e-01, 2.51505787e-01, 2.26204268e-01,
 7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 5.58422761e+00} }

};

}