/*******************************************************************************

  Intel Data Center Bridging (DCB) Software
  Copyright(c) 2007-2009 Intel Corporation.

  This program is free software; you can redistribute it and/or modify it
  under the terms and conditions of the GNU General Public License,
  version 2, as published by the Free Software Foundation.

  This program is distributed in the hope it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

  The full GNU General Public License is included in this distribution in
  the file called "COPYING".

  Contact Information:
  e1000-eedc Mailing List <e1000-eedc@lists.sourceforge.net>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497

*******************************************************************************/

#ifndef DCBD_SHM_H
#define DCBD_SHM_H

#include "dcbd.h"

#define DCBD_SHM_KEY 0xdcbd
#define DCBD_SHM_SIZE 4096

void mark_dcbx_shm_for_removal();

struct dcbd_shm_entry {
	char dn[IFNAMSIZ+1];
	dcbx_state st;
};

#define MAX_DCBD_SHM_ENTRIES (DCBD_SHM_SIZE/sizeof(struct dcbd_shm_entry) - 1)

struct dcbd_shm_tbl {
	u32 num_entries;
	struct dcbd_shm_entry ent[MAX_DCBD_SHM_ENTRIES];
};

#endif
