﻿' Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com 

Imports System
Imports Db4objects.Db4o.IO

Namespace Db4odoc.Storage
    Class LoggingStorage
        Inherits StorageDecorator
        Public Sub New()
            ' delegate to a normal file storage
            MyBase.New(New FileStorage())

        End Sub

        Public Sub New(ByVal storage As IStorage)
            ' use submitted storage as a delegate
            MyBase.New(storage)

        End Sub

        '
        ' opens a logging bin for the given URI.
        '         
        Public Overloads Overrides Function Open(ByVal config As BinConfiguration) As IBin
            Dim storage As IBin = MyBase.Open(config)
            If config.[ReadOnly]() Then
                Return New ReadOnlyBin(New LoggingBin(storage))
            End If
            Return New LoggingBin(storage)
        End Function

        ' LoggingBin implementation. Allows to log information
        ' for each IO operation
        Private Class LoggingBin
            Inherits BinDecorator

            Public Sub New(ByVal bin As IBin)
                MyBase.New(bin)

            End Sub

            ' delegate to the base class and log a message
            Public Overloads Overrides Sub Close()
                MyBase.Close()
                System.Console.WriteLine(String.Format("{0} LoggingStorage: File closed", DateTime.Now.ToString()))
            End Sub

            ' log a message, then delegate
            Public Overloads Overrides Function Read(ByVal pos As Long, ByVal buffer As Byte(), ByVal length As Integer) As Integer
                System.Console.WriteLine(String.Format("{0} LoggingStorage: Reading {1} bytes and {2} position", DateTime.Now.ToString(), length, pos))

                Return MyBase.Read(pos, buffer, length)
            End Function

            ' log a message, then delegate
            Public Overloads Overrides Sub Write(ByVal pos As Long, ByVal buffer As Byte(), ByVal length As Integer)
                System.Console.WriteLine(String.Format("{0} LoggingStorage: Writing {1} bytes and {2} position", DateTime.Now.ToString(), length, pos))
                MyBase.Write(pos, buffer, length)
            End Sub

            ' log a message, then delegate
            Public Overloads Overrides Sub Sync()
                System.Console.WriteLine(String.Format("{0} LoggingStorage: Syncing", DateTime.Now.ToString()))
                MyBase.Sync()
            End Sub

        End Class
    End Class
End Namespace
