<CsoundSynthesizer>
<CsOptions>
-d
</CsOptions>
<CsInstruments>


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Stria
;;; by John Chowning
;;; Reconstruction - ORChestra csound code
;;; Kevin Dahan 2007-20010
;;; kevin.dahan@wanadoo.fr
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The basis for this code was the original MUS10 orchestra file
;;; with modifications by John Chowning and Kevin Dahan
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; - Initial release : 2007
;;; - 11/2009: sco modifications for correcting END
;;; - 08/2010: orc modifications (butlp filters)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


  sr        =           48000
  kr        =           4800
  ksmps     =           10
  nchnls    =           2

  gaudio    init        0
  ga1       init        0
  ga2       init        0
  ga3       init        0
  ga4       init        0



instr 1                                         ;  vlna

  iamp      =           p4                      ;  amp 
  isk       =           p14
  idis      =           p15                     ;  distance
  ifc       =           p5                      ;  Freq Carrier
  ifma      =           p6                      ;  Freq ModA
  indxa1    =           p7                      ;  indx ampA1
  indxa2    =           p8                      ;  indx ampA2

  idifa     =           p8-p7                   

  ifmb      =           p9                      ; Freq ModB
  indxb1    =           p10                     ; index ampB1
  indxb2    =           p11                     ; index ampB2

            ; get correct index values for end.mem
  ;if ( p32 == 1 )   then      
  ;indxb2    =           indxa2
  ;endif     

  idifb     =           p11-p10                 

  imag      =           1                       ; fun to test

  ifactor   =           (p3-(p12+p13))/2

            ;  generate global envelop pointer
  kndx      linseg      0, p12, 0.25, ifactor, 0.5, ifactor, 0.75, p13, 1

            ; generate first envelop (env)
  ifn1      =           p28
  ixmode    =           1
  ktable    table       kndx, ifn1, ixmode
  kenv      =           ktable*iamp

            ; generate second envelop (skew)
  ifn2      =           p29
  ktable2   table       kndx, ifn2, ixmode
  ksk  	    = ktable2*isk
  kskew     =           1+ksk

            ; generate third envelop (fda)
  ifn3      =           p30
  ktable3   table       kndx, ifn3, ixmode
  kfda      =           ktable3*(ifma*idifa*imag)

            ; generate            fourth      envelop(fdb)
  ifn4      =           p31
  ktable4   table       kndx, ifn4, ixmode
  kfdb      =           ktable4*(ifmb*idifb*imag)


  amoda     oscil       (ifma*indxa1*imag)+kfda, (ifma*imag)*kskew, 1
  amodb     oscil       (ifma*indxb1*imag)+kfdb, (ifmb*imag)*kskew, 1
  asig      oscil       kenv, ((ifc*imag)*kskew)+amoda+amodb, 1

  gaudio    =           gaudio+(asig*p16)       ; sends reverb signal
  asig      =           asig*idis               ; adjust distance


  aout1     =           asig*p22                ; FL
  aout2     =           asig*p23                ; FR
  aout3     =           asig*p24                ; RR
  aout4     =           asig*p25                ; RL

  ga1       =           ga1+aout1
  ga2       =           ga2+aout2
  ga3       =           ga3+aout3
  ga4       =           ga4+aout4

endin 


;   p1 p2    p3    p4      p5   p6       p7    p8    p9       p10  p11
;   i  beg   dur   amp     Fc   FmA      ia1   ia2   FmB      ib1  ib2
; insa 1.000 6.924 151.644 2618 4235.924 0.056 0.223 4235.924 .000 1.023 

; p12   p13   p14   p15   p16   p17  p18  p19  p20  p21
; att   dec   %skew dis   %rev                        
; 1.385 2.306 0.006 0.333 0.150 .000 .000 .000 .000 .000

; p22  p23   p24  p25  p26  p27  p28  p29   p30  p31
; ch1  ch2   ch3  ch4  -    -    ampF skewF IAF  IBF
; 0.82 0.997 .000 .000 .000 .000 F2   F6    F2   F4


instr 99                                        ;  reverb unit

   a1        init        0                       
   a2        init        0
   a3        init        0
   a4        init        0
   a5        init        0
   a6        init        0
   a7        init        0
   idummy = p7

            ; factor to compensate changing rate (1 to disable)
  ifactor   =           2                       
  imag      =           1


  a1        alpass      gaudio, 20*(647/25600)*ifactor, 647/25600*ifactor
  a2        alpass      a1, 20*(213/25600)*ifactor, 213/25600*ifactor
  a3        alpass      a2, 20*(67/25600)*ifactor, 67/25600*ifactor

  a4        comb        a3, 32*(3201/25600)*ifactor, 3201/25600*ifactor
  a5        comb        a3, 27*(3667/25600)*ifactor, 3667/25600*ifactor
  a6        comb        a3, 25*(4053/25600)*ifactor, 4053/25600*ifactor
  a7        comb        a3, 25*(4451/25600)*ifactor, 4451/25600*ifactor

  afirstline    =           a4-a5+a6-a7
  asecondline   =           a4+a5+a6+a7
  athirdline    =           a4-a5-a6-a7
  afourthline   =           a4+a5-a6-a7

  arev1     poscil       p5-p4, imag/p3, 9
  arevsc    line        p4, p3, p5

  aos1      oscili       1000*p6, 0.0089*arevsc, 1, 0.75 ; 0.013
  amod1     =           1000+aos1
  az1       vdelay      afirstline, (amod1/25.600)*ifactor, 10000

  aos2      oscili       1000*p6, 0.0083*arevsc, 1, 0.75 ;  0.011
  amod2     =           1000+aos2
  az2       vdelay      asecondline, (amod2/25.600)*ifactor, 10000

  aos3      oscili      1000*p6, 0.0097*arevsc, 1 ;  0.017
  amod3     =           1000+aos3
  az3       vdelay      athirdline, (amod3/25.600)*ifactor, 10000

  aos4      oscili       1000*p6,  0.0101*arevsc, 1 ;  0.019
  amod4     =           1000+aos4
  az4       vdelay      afourthline, (amod4/25.600)*ifactor, 10000

            ; get correct scaling for multiple reverb instances
  kenv      linseg      1, p3-2, 1, 2, 0
  az1       =           az1*kenv
  az2       =           az2*kenv
  az3       =           az3*kenv
  az4       =           az4*kenv

  ga1       =           ga1+az1
  ga2       =           ga2+az2
  ga3       =           ga3+az3
  ga4       =           ga4+az4

  gaudio    =           0

endin


instr 999                                       ;  global amplitude shaping envelope
								    ; filter banks


;; filter banks 
  alpa1	butterlp ga1, 11500
  alpa2	butterlp alpa1, 11500
  alpa3	butterlp alpa2, 11500
  aout1 	butterlp alpa3, 11500
;;;
  alpb1	butterlp ga2, 11500
  alpb2	butterlp alpb1, 11500
  alpb3	butterlp alpb2, 11500
  aout2    butterlp alpb3, 11500
;;;
  alpc1	butterlp ga3, 11500
  alpc2	butterlp alpc1, 11500
  alpc3	butterlp alpc2, 11500
  aout3 	butterlp alpc3, 11500
;;;
  alpd1	butterlp ga4, 11500
  alpd2	butterlp alpd1, 11500
  alpd3	butterlp alpd2, 11500
  aout4 	butterlp alpd3, 11500
;
  ga1=aout1
  ga2=aout2
  ga3=aout3
  ga4=aout4
; end filters


  kpointer  linseg      0, 427, 0.1, 77, 0.35, 1, 0.45, 33, 0.45, 1, 0.35, 4, 0.45, 9, 0.5, 15, 0.5, 26, 0.8, 43, 0.8, 27, 0.9, 1, 0.8, 294, 0.95
  kv        tablei      kpointer, 2, 1
  kenv      =           1+(kv*18)               

  ga1       =           ga1*kenv
  ga2       =           ga2*kenv
  ga3       =           ga3*kenv
  ga4       =           ga4*kenv


            outs        ga2+ga3, ga1+ga4

            ;  uncomment below to generate 
            ;  the quadraphonic version files
 ;   fout "stria-FL.wav", 8, ga1        
  ;  fout "stria-FR.wav", 8, ga2         
  ;  fout "stria-RR.wav", 8, ga3
   ; fout "stria-RL.wav", 8, ga4

  ga1       =           0
  ga2       =           0
  ga3       =           0
  ga4       =           0


endin
</CsInstruments>
<CsScore>

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Stria
;;; Reconstruction - SCOre csound code
;;; Kevin Dahan 2007-2010
;;; kevin.dahan@wanadoo.fr
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The sections files were generated by the Stria Editor
;;; Scripts were used to get this unified score file
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; - Initial release : 2007
;;; - 11/2009: sco modifications for correcting END
;;; - 08/2010: orc modifications (butlp filters)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


f1      0       16385   10      1
f2      0       16385   7       0       4096    0.33    4096    1       4096    0.33    4096    0
f3      0       16385   7       1       2094    0.543   3152    0.367   7383    0.2037  1284    0.0845  2471    0
f4      0       16385   27      0       1       1500    0.4     2500    0.2     3220    0.15    4220    0.08    5464    0 16384 0
f5      0       16385   7       0.6904  2525    1       3465    0.71  4004    0.255   1351    0.15    5039    0
f6      0       16385  7       -0.5    3276    0.04     3276    0.08     3276    0.01    6552    0.03
f7      0       16385   27      0       0       3000    0.35    3010    0.85    3100    1       6034    0.857   7415    0.44 8967 0.214 11296 0.107 16384 0
f8      0       16385   27      0       0       2071    0.135   3279    0.270   3712    0.416   3889    0.827   4580    0.949 5270 0.998 6478 1 7253 0.916 8113 0.7 10093 0.365 11557 0.234 16384 0
f9      0       16385   7       0       16384   1

i999    0       958


        ;  HERE BEGINS T0

i99     0       166.5   1       1       -1      1 

i1 0 6.92408976486792 151.643578037035 2618.0 4235.924 0.0557108233095435 0.222843293238174 4235.924 0.0 1.02284329323817 1.38481795297358 2.30572189170102 0.00603328971269218 0.333333333333333 0.15 0.0 0.0 0.0 0.0 0.0 0.0824589821479948 0.996594459277753 0.0 0.0 0.0 0.0 2 6 2 4 
i1 6.11 11.4854240255147 262.383167925406 1306.50712934472 2113.92853527976 0.0888164664157662 0.355265865663065 2113.92853527976 0.0 1.15526586566306 2.29708480510293 3.82464620049638 0.012712535264081 0.333333333333333 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.795675476248549 0.605723151692788 0.0 0.0 0.0 2 6 2 4 
i1 7.52 16.0664467710903 253.198382335726 1378.26148199818 2230.02707787305 0.0861397115548856 0.344558846219542 2230.02707787305 0.0 1.14455884621954 3.21328935421807 5.35012677477308 0.0121378438838932 0.333333333333333 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.497406700782887 0.867517477643121 0.0 0.0 0.0 2 6 2 4 
i1 9.87 19.7842379027059 226.158364195146 1618.04697156984 2618.0 0.0781937666376515 0.312775066550606 2618.0 0.0 1.11277506655061 3.95684758054119 6.58815122160108 0.0104656246379764 0.333333333333333 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.918118019899393 0.396307079845942 0.0 0.0 2 6 2 4 
i1 19.74 18.8953661445148 280.959379480871 1174.01085761855 1899.54956762682 0.0941976167618449 0.37679046704738 1899.54956762682 0.0 1.17679046704738 3.77907322890297 6.29215692612344 0.0138846218935772 0.333333333333333 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.646311997023912 0.76307326155682 0.0 0.0 2 6 2 4 
i1 23.5 19.8905448259147 271.639586810663 1238.48841553191 2003.87425633064 0.091503213516639 0.366012854066556 2003.87425633064 0.0 1.16601285406656 3.97810896518294 6.62355142702959 0.0132949739666077 0.333333333333333 0.15 0.0 0.0 0.0 0.0 0.0 0.17021556146672 0.0 0.0 0.985406851323132 0.0 0.0 2 6 2 4 
i1 29.61 18.418359133736 208.645942239337 1800.65617813689 2913.46169622549 0.0729919712870603 0.291967885148241 2913.46169622549 0.0 1.09196788514824 3.6836718267472 6.13331359153409 0.00939929994978247 0.333333333333333 0.15 0.0 0.0 0.0 0.0 0.0 0.705284439812917 0.0 0.0 0.708924438115784 0.0 0.0 2 6 2 4 
i1 31.02 19.6168904622996 299.756989669625 1054.9513759619 1706.91132630635 0.0996004555869564 0.398401822347826 1706.91132630635 0.0 1.19840182234783 3.92337809245992 6.53242452394576 0.0150834117743569 0.333333333333333 0.15 0.0 0.0 0.0 0.0 0.0 0.993858377931494 0.0 0.0 0.110659498532117 0.0 0.0 2 6 2 4 
i1 33.37 19.6731896206745 244.09363506259 1453.95663758265 2352.50183960872 0.0834753561322195 0.333901424528878 2352.50183960872 0.0 1.13390142452888 3.9346379241349 6.5511721436846 0.0115714384197226 0.333333333333333 0.15 0.0 0.0 0.0 0.0 0.0 0.707106781186548 0.707106781186548 0.0 0.0 0.0 0.0 2 6 2 4 
i1 43.24 11.76 159.31543151211 2481.70300723024 4015.39546569853 0.0580713638780977 0.232285455512391 4015.39546569853 0.0 1.03228545551239 2.352 3.91608 0.00647590556338725 0.333333333333333 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.982764316668615 0.18486291646209 0.0 0.0 0.0 2 6 2 4 
i1 47.0 18.1049301931734 226.163179071595 1618.0 4235.924 0.0781951906102547 0.312780762441019 2617.924 0.0 1.11278076244102 3.62098603863469 6.02894175432676 0.0104659196776628 0.574349177498518 0.15 0.0 0.0 0.0 0.0 0.0 0.714233564695764 0.699907433209551 0.0 0.0 0.0 0.0 2 6 2 4 
i1 56.6637168141593 26.4813927740452 271.644630717956 1238.45246246867 3242.26854674297 0.0915046746259445 0.366018698503778 2003.8160842743 0.0 1.16601869850378 5.29627855480905 8.81830379375706 0.0132952922199101 0.329876977693224 0.15 0.0 0.0 0.0 0.0 0.0 0.417386554817328 0.908729037644182 0.0 0.0 0.0 0.0 2 6 2 4 
i1 58.8938053097345 34.2745034157637 280.964455586016 1173.97677632551 3073.47120042019 0.0941990814077735 0.376796325631094 1899.49442409468 0.0 1.17679632563109 6.85490068315275 11.4134096374493 0.0138849439155704 0.238494846850876 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.911463029196111 0.411381995727389 0.0 0.0 0.0 2 6 2 4 
i1 62.6106194690266 40.0898893261355 151.647696461915 2617.924 6853.725032 0.0557120937154946 0.222848374861978 4235.801032 0.0 1.02284837486198 8.0179778652271 13.3499331456031 0.00603352635463881 0.1894645708138 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.687734378306626 0.725962412866671 0.0 0.0 0.0 2 6 2 4 
i1 62.6106194690266 3.87206669176598 200.074273033913 1899.49442409468 4972.87640227986 0.0704288374299709 0.281715349719884 3073.38197818519 0.0 1.08171534971988 0.774413338353196 1.28939820835807 0.00888248972609565 0.574349177498518 0.18 0.0 0.0 0.0 0.0 0.0 0.652653788699936 0.757656275692097 0.0 0.0 0.0 0.0 2 6 2 4 
i1 63.6427527875971 5.93003789723267 191.629050784239 2003.8160842743 5245.99050863012 0.0678920100000773 0.271568040000309 3242.17442435582 0.0 1.07156804000031 1.18600757944653 1.97470261977848 0.00837675461761272 0.329876977693224 0.18 0.0 0.0 0.0 0.0 0.0 0.0636619779629336 0.997971518913164 0.0 0.0 0.0 0.0 2 6 2 4 
i1 64.2779117528713 7.58191097243329 208.650633017524 1800.60390545945 4713.98102449284 0.0729933707999995 0.291973483199998 2913.37711903339 0.0 1.0919734832 1.51638219448666 2.52477635382029 0.00939958371262867 0.238494846850876 0.18 0.0 0.0 0.0 0.0 0.0 0.0 0.750941460610668 0.660368777832445 0.0 0.0 0.0 2 6 2 4 
i1 65.9452040367161 8.3282182140776 217.349765352234 1706.86177502263 4468.56412700923 0.0755830195555152 0.302332078222061 2761.70235198661 0.0 1.10233207822206 1.66564364281552 2.77329666528784 0.00992755893618056 0.1894645708138 0.18 0.0 0.0 0.0 0.0 0.0 0.0 0.31433988174598 0.94931050702282 0.0 0.0 0.0 2 6 2 4 
i1 66.1833886486939 9.57834931228062 167.160926494354 2352.43354696555 6158.67102595582 0.0604733220576009 0.241893288230404 3806.23747899027 0.0 1.0418932882304 1.91566986245612 3.18959032098945 0.00693214235687275 0.158489319246111 0.18 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.779039120653999 0.626975317289799 0.0 0.0 2 6 2 4 
i1 66.5803630019903 10.5833398711496 159.319643707318 2481.63096390383 6496.90986350023 0.0580726566823344 0.232290626729337 4015.2788995964 0.0 1.03229062672934 2.11666797422992 3.52425217709282 0.00647614955139746 0.136979319126435 0.18 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.295906800943429 0.955216815783425 0.0 0.0 2 6 2 4 
i1 67.6124963205609 10.9235967789178 159.319643707318 2481.63096390383 6496.90986350023 0.0580726566823344 0.232290626729337 4015.2788995964 0.0 1.03229062672934 2.18471935578357 3.63755772737964 0.00647614955139746 0.121087014505174 0.18 0.0 0.0 0.0 0.0 0.0 0.677819728709998 0.0 0.0 0.735228138315928 0.0 0.0 2 6 2 4 
i1 68.2476552858351 11.4089969738856 167.160926494354 2352.43354696555 6158.67102595582 0.0604733220576009 0.241893288230404 3806.23747899027 0.0 1.0418932882304 2.28179939477711 3.79919599230389 0.00693214235687275 0.108818820412016 0.18 0.0 0.0 0.0 0.0 0.0 0.982764316668617 0.18486291646208 0.0 0.0 0.0 0.0 2 6 2 4 
i1 69.9149475696798 10.7222205719131 217.349765352234 1706.86177502263 4468.56412700923 0.0755830195555152 0.302332078222061 2761.70235198661 0.0 1.10233207822206 2.14444411438262 3.57049945044707 0.00992755893618056 0.0990334698870002 0.18 0.0 0.0 0.0 0.0 0.0 0.602774947395158 0.797911249947489 0.0 0.0 0.0 0.0 2 6 2 4 
i1 78.2212389380531 37.8782418572725 244.098555409736 1453.91442952136 3806.34797648691 0.0834767989876134 0.333907195950454 2352.43354696555 0.0 1.13390719595045 7.5756483714545 12.6134545384717 0.0115717436151763 0.158489319246111 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.704500884560253 0.709703109513986 0.0 0.0 0.0 2 6 2 4 
i1 84.1681415929204 39.143845455577 183.323155853709 2113.86716837041 5534.10424679373 0.0653854619159253 0.261541847663701 3420.23707842332 0.0 1.0615418476637 7.8287690911154 13.0349005367071 0.00788283480327883 0.136979319126435 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.324003541730447 0.946055867772156 0.0 0.0 0.0 2 6 2 4 
i1 93.8318584070797 36.5613111530691 175.164551797319 2229.96234064695 5838.04140781372 0.0629117345208969 0.251646938083588 3608.07906716677 0.0 1.05164693808359 7.31226223061383 12.174916613972 0.00740116241332872 0.121087014505174 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.834338455511919 0.551252520768827 0.0 0.0 2 6 2 4 
i1 96.0619469026549 38.3591083378155 226.163179071595 1618.0 4235.924 0.0781951906102547 0.312780762441019 2617.924 0.0 1.11278076244102 7.67182166756311 12.7735830764926 0.0104659196776628 0.108818820412016 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.519228164962198 0.854635660799377 0.0 0.0 2 6 2 4 
i1 99.778761061947 38.426053488985 200.074273033913 1899.49442409468 4972.87640227986 0.0704288374299709 0.281715349719884 3073.38197818519 0.0 1.08171534971988 7.685210697797 12.795875811832 0.00888248972609565 0.0990334698870002 0.15 0.0 0.0 0.0 0.0 0.0 0.417917193846515 0.0 0.0 0.908485123206459 0.0 0.0 2 6 2 4 
i1 115.389380530973 26.7640838311215 191.629050784239 2003.8160842743 5245.99050863012 0.0678920100000773 0.271568040000309 3242.17442435582 0.0 1.07156804000031 5.35281676622429 8.91243991576345 0.00837675461761272 0.091028210151304 0.15 0.0 0.0 0.0 0.0 0.0 0.797911249947489 0.0 0.0 0.602774947395158 0.0 0.0 2 6 2 4 
i1 121.336283185841 22.6637168141593 309.224472101786 1000.0 2618.0 0.102306118025447 0.409224472101786 1618.0 0.0 1.20922447210179 4.53274336283185 7.54701769911504 0.015691835407634 0.0843454880117311 0.15 0.0 0.0 0.0 0.0 0.0 0.93998278464313 0.34122187001209 0.0 0.0 0.0 0.0 2 6 2 4 
i1 131.0 7.16804107060211 226.163179071595 1618.0 4235.924 0.195487976525637 0.781951906102547 618.076 0.0 2.78195190610255 2.3869576765105 2.3869576765105 0.0104659196776628 0.574349177498518 0.15 0.0 0.0 0.0 0.0 0.0 0.892134229710651 0.0 0.0 0.451770424196387 0.0 0.0 2 6 3 4 
i1 136.712121212121 10.3835521140669 262.388175196419 1306.46920171224 3420.33637008265 0.222044806852523 0.888179227410093 499.071235054077 0.0 2.88817922741009 3.45772285398429 3.45772285398429 0.0127128494571601 0.329876977693224 0.15 0.0 0.0 0.0 0.0 0.0 0.794343163506279 0.60746929024506 0.0 0.0 0.0 0.0 2 6 3 4 
i1 138.030303030303 13.6928748410727 253.203348442892 1378.22147135164 3608.18381199859 0.215352904518709 0.861411618074834 526.480602056326 0.0 2.86141161807483 4.55972732207721 4.55972732207721 0.0121381537241887 0.238494846850876 0.15 0.0 0.0 0.0 0.0 0.0 0.128652611961004 0.991689722360584 0.0 0.0 0.0 0.0 2 6 3 4 
i1 140.227272727273 15.83227710448 309.224472101786 1000.0 2618.0 0.255765295063617 1.02306118025447 382.0 0.0 3.02306118025447 5.27214827579183 5.27214827579183 0.015691835407634 0.1894645708138 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.595478209559355 0.803371459500513 0.0 0.0 0.0 2 6 3 4 
i1 140.227272727273 2.28074034064612 253.203348442892 1378.22147135164 3608.18381199859 0.215352904518709 0.861411618074834 526.480602056326 0.0 2.86141161807483 0.759486533435159 0.759486533435159 0.0121381537241887 0.574349177498518 0.18 0.0 0.0 0.0 0.0 0.0 0.892134229710651 0.0 0.0 0.451770424196387 0.0 0.0 2 6 3 4 
i1 141.377584824075 3.54875775015584 262.388175196419 1306.46920171224 3420.33637008265 0.222044806852523 0.888179227410093 499.071235054077 0.0 2.88817922741009 1.18173633080189 1.18173633080189 0.0127128494571601 0.329876977693224 0.18 0.0 0.0 0.0 0.0 0.0 0.794343163506279 0.60746929024506 0.0 0.0 0.0 0.0 2 6 3 4 
i1 142.085469191338 4.54910406185185 244.098555409736 1453.91442952136 3806.34797648691 0.208691997469034 0.834767989876135 555.395312077158 0.0 2.83476798987613 1.51485165259667 1.51485165259667 0.0115717436151764 0.238494846850876 0.18 0.0 0.0 0.0 0.0 0.0 0.128652611961004 0.991689722360584 0.0 0.0 0.0 0.0 2 6 3 4 
i1 143.943665655403 4.53876104988217 235.082307238671 1533.7645017947 4015.39546569853 0.202068256271698 0.80827302508679 585.898039685576 0.0 2.80827302508679 1.51140742961076 1.51140742961076 0.011014155333197 0.1894645708138 0.18 0.0 0.0 0.0 0.0 0.0 0.0 0.595478209559355 0.803371459500513 0.0 0.0 0.0 2 6 3 4 
i1 144.209122293127 5.22300850642397 290.339572128172 1112.85779076604 2913.46169622548 0.242247217794351 0.968988871177404 425.111676072626 0.0 2.9689888711774 1.73926183263918 1.73926183263918 0.0144812696839037 0.158489319246111 0.18 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.802318780412055 0.596895782024058 0.0 0.0 2 6 3 4 
i1 144.651550022666 5.65208539970136 299.762117303771 1054.92075094105 2761.78252596368 0.249004809376694 0.996019237506777 402.979726859483 0.0 2.99601923750678 1.88214443810055 1.88214443810055 0.0150837404703623 0.136979319126435 0.18 0.0 0.0 0.0 0.0 0.0 0.341221870012101 0.0 0.0 0.939982784643126 0.0 0.0 2 6 3 4 
i1 145.801862119469 5.24359242598595 299.762117303771 1054.92075094105 2761.78252596368 0.249004809376694 0.996019237506777 402.979726859483 0.0 2.99601923750678 1.74611627785332 1.74611627785332 0.0150837404703623 0.121087014505174 0.18 0.0 0.0 0.0 0.0 0.0 0.962246181277055 0.0 0.0 0.272180613963824 0.0 0.0 2 6 3 4 
i1 149.454545454545 11.8768424837005 244.098555409736 1453.91442952136 3806.34797648691 0.208691997469034 0.834767989876134 555.395312077158 0.0 2.83476798987613 3.95498854707225 3.95498854707225 0.0115717436151763 0.158489319246111 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.913361963623495 0.407148527451387 0.0 0.0 2 6 3 4 
i1 152.969696969697 10.6345504330282 299.762117303771 1054.92075094105 2761.78252596368 0.249004809376694 0.996019237506777 402.979726859483 0.0 2.99601923750678 3.5413052941984 3.5413052941984 0.0150837404703623 0.136979319126435 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.272180613963824 0.962246181277055 0.0 0.0 2 6 3 4 
i1 158.681818181818 6.31818181818184 290.339572128172 1112.85779076604 2913.46169622548 0.242247217794351 0.968988871177404 425.111676072626 0.0 2.9689888711774 2.10395454545455 2.10395454545455 0.0144812696839037 0.121087014505174 0.15 0.0 0.0 0.0 0.0 0.0 0.857556448398586 0.0 0.0 0.514389869466734 0.0 0.0 2 6 3 4 

        ;  HERE BEGINS T286

i99     165.0   272.5   1       1.5       -1      2


i1 165.0 5.81377674149945 309.224472101786 1000.0 1618.0 0.102306118025447 0.409224472101786 618.0 0.0 2.30922447210179 0.3 2.75188837074973 0.015691835407634 0.722981180798466 0.05 0.0 0.0 0.0 0.0 0.0 0.679538707270587 0.0 0.0 0.733639656317064 0.0 0.0 7 6 2 4 
i1 165.26 8.05748347810903 347.32949375779 807.459333567517 1306.46920171224 0.113096606682433 0.452386426729732 499.009868144726 0.0 2.44846815319664 0.3 3.87374173905451 0.0181704420589385 0.415243646538506 0.05 0.0 0.0 0.0 0.0 0.0 0.795602827508137 0.605818570911339 0.0 0.0 0.0 0.0 7 6 2 4 
i1 165.32 9.82188576598201 337.778381656262 851.805606521408 1378.22147135164 0.110406445573558 0.44162578229423 526.41586483023 0.0 2.41472639441562 0.3 4.755942882991 0.0175448235763721 0.30021334189347 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.788501827979772 0.615032411562642 0.0 0.0 0.0 7 6 2 4 
i1 165.42 11.2518940627789 395.067899088516 618.046971569839 1000.0 0.126406195817568 0.505624783270272 381.95302843016 0.0 2.60620558272364 0.3 5.47094703138947 0.021338326118007 0.238494846850876 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.707106781186548 0.707106781186548 0.0 0.0 7 6 2 4 
i1 165.84 12.16 366.444441303383 725.572791301305 1173.97677632551 0.11845262050476 0.47381048201904 448.403985024206 0.0 2.51376525561652 0.3 5.925 0.0194308800440795 0.199503715965179 0.05 0.0 0.0 0.0 0.0 0.0 0.85599767270379 0.0 0.0 0.516979674963818 0.0 0.0 7 6 2 4 
i1 166.0 9.71467391304348 442.34841315922 473.066621669944 765.42179386197 0.348450253014605 1.39380101205842 180.711449477919 0.0 3.39380101205842 1.21351275706117 4.6853107976642 0.0245382316121305 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.979862881115132 0.19967156585942 0.0 0.0 0.0 2 6 3 4 
i1 173.77173913043478 11.4955799702211 375.997154128076 687.798387370852 1112.85779076604 0.302789345936031 1.21115738374412 262.738983975665 0.0 3.21115738374412 1.81811778029987 5.209442776107 0.0200648516068878 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.733639656317064 0.679538707270587 0.0 0.0 0.0 2 6 3 4 
i1 175.5652173913043 19.0437766884714 470.315227971341 402.960800596601 651.9905753653 0.367412453803356 1.46964981521342 153.931025827901 0.0 3.46964981521342 2.1405760557365 9.39767596054912 0.0264577897392984 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.313189040592021 0.949690804869169 0.0 0.0 0.0 2 6 3 4 
i1 178.554347826087 26.6388527066539 414.062967550319 555.369227495281 898.587410087365 0.329105539622232 1.31642215848893 212.151044903197 0.0 3.31642215848893 3.68800643240628 12.5292385472674 0.02261678037788 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.795602827508137 0.605818570911339 0.0 0.0 2 6 3 4 
i1 178.554347826087 1.16763259969718 404.57692639963 585.870522518875 947.93850543554 0.322578656780332 1.29031462712133 223.80253960221 0.0 3.29031462712133 0.388821655699162 0.467053039878874 0.0219771001463047 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.979862881115132 0.19967156585942 0.0 0.0 0.0 2 6 3 4 
i1 179.5738788214588 2.73076271324995 404.57692639963 585.870522518875 947.93850543554 0.322578656780332 1.29031462712133 223.80253960221 0.0 3.29031462712133 0.909343983512233 1.09230508529998 0.0219771001463047 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.733639656317064 0.679538707270587 0.0 0.0 0.0 2 6 3 4 
i1 180.2012825109184 4.47555334507082 395.067899088516 618.046971569839 1000.0 0.31601548954392 1.26406195817568 236.093943139679 0.0 3.26406195817568 1.49035926390858 1.79022133802833 0.021338326118007 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.313189040592021 0.949690804869169 0.0 0.0 0.0 2 6 3 4 
i1 181.8482171957499 5.93139269432422 337.778381656262 851.805606521409 1378.22147135164 0.276016113933894 1.10406445573558 325.389741691178 0.0 3.10406445573558 1.97515376720997 2.37255707772969 0.0175448235763721 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.795602827508137 0.605818570911339 0.0 0.0 2 6 3 4 
i1 182.0834935792973 7.81798468953082 347.32949375779 807.459333567518 1306.46920171224 0.282741516706083 1.13096606682433 308.449465422792 0.0 3.13096606682433 2.60338890161376 3.12719387581233 0.0181704420589385 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.375601183960091 0.926781393106151 0.0 0.0 2 6 3 4 
i1 182.4756208852096 9.6775365286959 366.444441303383 725.572791301305 1173.97677632551 0.2961315512619 1.1845262050476 277.168806277098 0.0 3.1845262050476 3.22261966405573 3.87101461147836 0.0194308800440794 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.615032411562642 0.0 0.0 0.788501827979772 0.0 0.0 2 6 3 4 
i1 183.4951518805814 11.0894687782312 356.886759307554 765.421793861969 1238.45246246867 0.289447848890405 1.15779139556162 292.391125255272 0.0 3.15779139556162 3.69279310315099 4.43578751129249 0.0187992720292845 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.961907109208383 0.0 0.0 0.27337650457633 0.0 0.0 2 6 3 4 
i1 184.1225555700411 12.6533547811611 328.239506008815 898.587410087365 1453.91442952136 0.269275481882427 1.07710192752971 343.260390653373 0.0 3.07710192752971 4.21356714212666 5.06134191246445 0.016922868075431 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.707106781186548 0.707106781186548 0.0 0.0 0.0 0.0 2 6 3 4 
i1 185.7694902548726 13.1000749625187 385.539866053671 651.990575365299 1054.92075094105 0.309418233690738 1.23767293476295 249.060399789544 0.0 3.23767293476295 4.36232496251874 5.24002998500749 0.0207007918651621 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.947371065153513 0.320137571849818 0.0 0.0 0.0 2 6 3 4 
i1 191.1086956521739 29.7568871356357 347.32949375779 807.459333567518 1306.46920171224 0.282741516706083 1.13096606682433 308.449465422792 0.0 3.13096606682433 5.18574499033073 13.0737767691953 0.0181704420589385 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.73388567534891 0.679273005144231 0.0 0.0 2 6 3 4 
i1 195.8913043478261 34.8925523807336 395.067899088516 618.046971569839 1000.0 0.31601548954392 1.26406195817568 236.093943139679 0.0 3.26406195817568 5.16602954410809 16.1179333570392 0.021338326118007 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.13873380200061 0.990329708825528 0.0 0.0 2 6 3 4 
i1 203.6630434782609 37.0290276477871 318.719287364986 947.93850543554 1533.7645017947 0.262523742570026 1.0500949702801 362.112509076376 0.0 3.0500949702801 7.09415690726342 15.7268488300778 0.0163050439963448 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.726466345851977 0.0 0.0 0.68720204332094 0.0 0.0 2 6 3 4 
i1 205.4565217391304 42.5097170557671 414.062967550319 555.369227495281 898.587410087365 0.329105539622232 1.31642215848893 212.151044903197 0.0 3.31642215848893 5.88524256910961 19.9938935596693 0.02261678037788 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.947371065153513 0.320137571849819 0.0 0.0 0.0 0.0 2 6 3 4 
i1 208.445652173913 46.554347826087 470.315227971341 402.960800596601 651.9905753653 0.367412453803356 1.46964981521342 153.931025827901 0.0 3.46964981521342 5.23284450753288 22.9735247677585 0.0264577897392984 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.543160998397533 0.839628566581554 0.0 0.0 0.0 0.0 2 6 3 4 
i1 233.0 9.71467391304348 461.045559003734 1112.8055180886 425.059403395186 0.722289818279313 1.44457963655863 687.746114693411 0.0 3.44457963655863 1.13135341228917 4.75862274650608 0.0258194447538013 0.222222222222222 0.04 0.0 0.0 0.0 0.0 0.0 0.868996625981625 0.494818011022792 0.0 0.0 0.0 0.0 2 6 3 4 
i1 240.7717391304348 11.4955799702211 525.09894804293 765.385840798723 292.355172192025 0.808240653788723 1.61648130757745 473.030668606697 0.0 3.61648130757745 1.0370787940788 5.90441350073792 0.0302704029791161 0.222222222222222 0.04 0.0 0.0 0.0 0.0 0.0 0.577278975454 0.816546988543084 0.0 0.0 0.0 0.0 2 6 3 4 
i1 242.5652173913043 19.0437766884714 534.063638813721 725.538710008265 277.134724984058 0.820151853887488 1.64030370777498 448.403985024207 0.0 3.64030370777498 1.65424031347557 9.83996638650759 0.0309004345888089 0.222222222222222 0.04 0.0 0.0 0.0 0.0 0.0 0.0 0.945045631346524 0.326938457011178 0.0 0.0 0.0 2 6 3 4 
i1 245.554347826087 26.6388527066539 479.569328975657 999.953028430161 381.953028430161 0.747305228471033 1.49461045694207 618.0 0.0 3.49461045694207 2.88880746095766 13.2406638258594 0.0270970856380866 0.222222222222222 0.04 0.0 0.0 0.0 0.0 0.0 0.0 0.654222996629699 0.756301706120552 0.0 0.0 0.0 2 6 3 4 
i1 245.554347826087 1.16763259969718 451.722644857788 1173.92163279337 448.403985024206 0.709647918702138 1.41929583740428 725.517647769166 0.0 3.41929583740428 0.388821655699162 0.467053039878874 0.0251795216065399 0.222222222222222 0.048 0.0 0.0 0.0 0.0 0.0 0.868996625981625 0.494818011022792 0.0 0.0 0.0 0.0 2 6 3 4 
i1 246.5738788214588 2.73076271324995 442.361745876421 1238.39429041233 473.030668606697 0.696918662261636 1.39383732452327 765.363621805636 0.0 3.39383732452327 0.909343983512233 1.09230508529998 0.024539142145765 0.222222222222222 0.048 0.0 0.0 0.0 0.0 0.0 0.577278975454 0.816546988543084 0.0 0.0 0.0 0.0 2 6 3 4 
i1 247.2012825109184 4.47555334507082 479.569328975657 999.953028430161 381.953028430161 0.747305228471033 1.49461045694207 618.0 0.0 3.49461045694207 1.49035926390858 1.79022133802833 0.0270970856380866 0.222222222222222 0.048 0.0 0.0 0.0 0.0 0.0 0.0 0.945045631346524 0.326938457011178 0.0 0.0 0.0 2 6 3 4 
i1 248.8482171957499 5.93139269432422 395.081430905728 1617.924 618.0 0.632049688024089 1.26409937604818 999.924 0.0 3.26409937604818 1.97515376720997 2.37255707772969 0.0213392333544138 0.222222222222222 0.048 0.0 0.0 0.0 0.0 0.0 0.0 0.654222996629699 0.756301706120552 0.0 0.0 0.0 2 6 3 4 
i1 249.0834935792973 7.81798468953082 432.965241176763 1306.40783480289 499.009868144726 0.684104119309227 1.36820823861845 807.397966658167 0.0 3.36820823861845 2.60338890161376 3.12719387581233 0.0238985390179608 0.222222222222222 0.048 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.967522671348027 0.252784256684585 0.0 0.0 2 6 3 4 
i1 249.4756208852096 9.6775365286959 423.535808051102 1378.15673412554 526.415864830231 0.671206780984075 1.34241356196815 851.740869295313 0.0 3.34241356196815 3.22261966405573 3.87101461147836 0.0232579643486208 0.222222222222222 0.048 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.645568743750533 0.763702165174591 0.0 0.0 2 6 3 4 
i1 250.4951518805814 11.0894687782312 479.569328975657 999.953028430161 381.953028430161 0.747305228471033 1.49461045694207 618.0 0.0 3.49461045694207 3.69279310315099 4.43578751129249 0.0270970856380866 0.222222222222222 0.048 0.0 0.0 0.0 0.0 0.0 0.360889756803138 0.0 0.0 0.932608483466976 0.0 0.0 2 6 3 4 
i1 251.1225555700411 12.6533547811611 451.722644857788 1173.92163279337 448.403985024206 0.709647918702138 1.41929583740428 725.517647769166 0.0 3.41929583740428 4.21356714212666 5.06134191246445 0.0251795216065399 0.222222222222222 0.048 0.0 0.0 0.0 0.0 0.0 0.839628566581558 0.0 0.0 0.543160998397527 0.0 0.0 2 6 3 4 
i1 252.7694902548726 13.1000749625187 442.361745876421 1238.39429041233 473.030668606697 0.696918662261636 1.39383732452327 765.363621805636 0.0 3.39383732452327 4.36232496251874 5.2400299850075 0.024539142145765 0.222222222222222 0.048 0.0 0.0 0.0 0.0 0.0 0.832187361878503 0.554494539855621 0.0 0.0 0.0 0.0 2 6 3 4 
i1 258.1086956521739 29.7568871356357 497.919480801851 898.545202026075 343.218182592084 0.771955847973845 1.54391169594769 555.327019433991 0.0 3.54391169594769 3.00096923101212 14.9950245999245 0.028370571241847 0.222222222222222 0.04 0.0 0.0 0.0 0.0 0.0 0.0 0.577591598504103 0.816325881825068 0.0 0.0 0.0 2 6 3 4 
i1 262.8913043478261 34.8925523807336 404.590428285151 1533.69245846829 585.825996359163 0.645175922333573 1.29035184466715 947.866462109127 0.0 3.29035184466715 4.99601007309841 16.2663419659384 0.0219780089027582 0.222222222222222 0.04 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.902369623822601 0.430962947365846 0.0 0.0 2 6 3 4 
i1 270.663043478261 37.0290276477871 461.045559003734 1112.8055180886 425.059403395186 0.722289818279313 1.44457963655863 687.746114693411 0.0 3.44457963655863 4.31233381151641 18.138248882361 0.0258194447538013 0.222222222222222 0.04 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.516982125923783 0.855996192442073 0.0 0.0 2 6 3 4 
i1 272.45652173913 42.5097170557671 551.848132400556 651.959950344454 249.029774768699 0.843702260883414 1.68740452176683 402.930175575755 0.0 3.68740452176683 3.4197083747458 22.2167130501744 0.0321550842070785 0.222222222222222 0.04 0.0 0.0 0.0 0.0 0.0 0.554494539855621 0.0 0.0 0.832187361878503 0.0 0.0 2 6 3 4 
i1 275.445652173913 46.554347826087 479.569328975657 999.953028430161 381.953028430161 0.747305228471033 1.49461045694207 618.0 0.0 3.49461045694207 5.0485112411176 23.1395276660462 0.0270970856380866 0.222222222222222 0.04 0.0 0.0 0.0 0.0 0.0 0.953914178340796 0.0 0.0 0.300079556718556 0.0 0.0 2 6 3 4 
i1 309.0 5.115342817721 604.028189151685 180.711449477919 292.391125255272 0.456116385813461 1.82446554325384 292.391125255272 0.0 3.82446554325384 0.323863033764286 2.7551817118486 0.0358702620751375 0.285714285714286 0.03 0.0 0.0 0.0 0.0 0.0 0.67068695667376 0.0 0.0 0.741740524811534 0.0 0.0 2 6 3 4 
i1 313.804347826087 11.9155309045005 612.563803130726 171.303341333188 277.168806277099 0.461684318619812 1.84673727447925 277.168806277099 0.0 3.84673727447925 0.723828039540941 6.44662389382305 0.0364824522352314 0.285714285714286 0.03 0.0 0.0 0.0 0.0 0.0 0.933662205681764 0.0 0.0 0.358154834787223 0.0 0.0 2 6 3 4 
i1 314.913043478261 19.9193526281712 479.548124351676 382.0 1000.076 0.373638334668349 1.4945533386734 618.076 0.0 3.4945533386734 2.16030082288839 9.90061995340637 0.0270956184925496 0.285714285714286 0.03 0.0 0.0 0.0 0.0 0.0 0.829539098239132 0.558448640872738 0.0 0.0 0.0 0.0 2 6 3 4 
i1 316.760869565217 28.3092258111092 586.818048222922 201.106144432125 325.389741691178 0.444859283991788 1.77943713596715 325.389741691178 0.0 3.77943713596715 1.9444464292013 15.1049586673153 0.0346395931544237 0.285714285714286 0.03 0.0 0.0 0.0 0.0 0.0 0.472262214769916 0.881458110462779 0.0 0.0 0.0 0.0 2 6 3 4 
i1 316.760869565217 1.16763259969718 551.827791666159 249.060399789544 402.979726859483 0.421837692204006 1.68735076881602 402.979726859483 0.0 3.68735076881602 0.388821655699162 0.467053039878874 0.0321536456854432 0.285714285714286 0.036 0.0 0.0 0.0 0.0 0.0 0.67068695667376 0.0 0.0 0.741740524811534 0.0 0.0 2 6 3 4 
i1 317.391125089629 2.78585372786682 569.418976524678 223.80253960221 362.112509076376 0.433435034240228 1.73374013696091 362.112509076376 0.0 3.73374013696091 0.927689291379651 1.11434149114673 0.0334006423698743 0.285714285714286 0.036 0.0 0.0 0.0 0.0 0.0 0.933662205681764 0.0 0.0 0.358154834787223 0.0 0.0 2 6 3 4 
i1 317.778974643113 4.626309603429 578.142364808991 212.151044903197 343.260390653373 0.439168443838704 1.75667377535481 343.260390653373 0.0 3.75667377535481 1.54056109794186 1.8505238413716 0.0340211414607042 0.285714285714286 0.036 0.0 0.0 0.0 0.0 0.0 0.829539098239132 0.558448640872738 0.0 0.0 0.0 0.0 2 6 3 4 
i1 318.797079721009 6.36964650733724 525.078274062478 292.391125255272 765.479965918303 0.40410657645942 1.61642630583768 473.088840663031 0.0 3.61642630583768 2.1210922869433 2.5478586029349 0.0302689519342413 0.285714285714286 0.036 0.0 0.0 0.0 0.0 0.0 0.472262214769916 0.881458110462779 0.0 0.0 0.0 0.0 2 6 3 4 
i1 318.942523303566 8.44556880620706 516.065549383694 308.449465422792 807.520700476869 0.398105066475659 1.59242026590264 499.071235054077 0.0 3.59242026590264 2.81237441246695 3.37822752248282 0.0296372244304749 0.285714285714286 0.036 0.0 0.0 0.0 0.0 0.0 0.0 0.85505788678467 0.518532554664927 0.0 0.0 0.0 2 6 3 4 
i1 319.184929274493 10.5613590299076 516.065549383694 308.449465422792 807.520700476869 0.398105066475659 1.59242026590264 499.071235054077 0.0 3.59242026590264 3.51693255695922 4.22454361196303 0.0296372244304749 0.285714285714286 0.036 0.0 0.0 0.0 0.0 0.0 0.0 0.460198732166751 0.88781593076049 0.0 0.0 0.0 2 6 3 4 
i1 319.815184798905 12.4501814389696 525.078274062478 292.391125255272 765.479965918303 0.40410657645942 1.61642630583768 473.088840663031 0.0 3.61642630583768 4.14591041917686 4.98007257558782 0.0302689519342413 0.285714285714286 0.036 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.815341924357393 0.578979746092369 0.0 0.0 2 6 3 4 
i1 320.203034352389 14.4775602611509 578.142364808991 212.151044903197 343.260390653373 0.439168443838704 1.75667377535481 343.260390653373 0.0 3.75667377535481 4.82102756696324 5.79102410446035 0.0340211414607042 0.285714285714286 0.036 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.300079556718619 0.953914178340776 0.0 0.0 2 6 3 4 
i1 321.221139430285 15.8549475262369 569.418976524678 223.80253960221 362.112509076376 0.433435034240228 1.73374013696091 362.112509076376 0.0 3.73374013696091 5.27969752623689 6.34197901049477 0.0334006423698743 0.285714285714286 0.036 0.0 0.0 0.0 0.0 0.0 0.715849372807894 0.0 0.0 0.698254735358483 0.0 0.0 2 6 3 4 
i1 324.521739130435 34.2219389310815 516.065549383694 308.449465422792 807.520700476869 0.398105066475659 1.59242026590264 499.071235054077 0.0 3.59242026590264 3.205561101899 17.4689719580637 0.0296372244304749 0.285714285714286 0.03 0.0 0.0 0.0 0.0 0.0 0.358658507277838 0.933468839949804 0.0 0.0 0.0 0.0 2 6 3 4 
i1 327.478260869565 41.6298050471128 507.005392853021 325.389741691178 851.870343747504 0.392057528291909 1.56823011316764 526.480602056326 0.0 3.56823011316764 4.04700380023606 21.1157059300242 0.0290039055329241 0.285714285714286 0.03 0.0 0.0 0.0 0.0 0.0 0.0 0.780573384236221 0.625064150165415 0.0 0.0 0.0 2 6 3 4 
i1 332.282608695652 47.4015458730724 560.6475324544 236.093943139679 382.0 0.427658336508217 1.71063334603287 382.0 0.0 3.71063334603287 3.66789587457888 24.9080207266517 0.032778129487174 0.285714285714286 0.03 0.0 0.0 0.0 0.0 0.0 0.0 0.249588438644338 0.968352007947049 0.0 0.0 0.0 2 6 3 4 
i1 333.391304347826 55.4361031547783 534.043075486827 277.168806277098 725.627934833444 0.410062281517837 1.64024912607135 448.459128556345 0.0 3.64024912607135 4.81588595896445 28.6435837533478 0.0308989875408837 0.285714285714286 0.03 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.698254735358483 0.715849372807894 0.0 0.0 2 6 3 4 
i1 335.239130434783 62.7608695652173 525.078274062478 292.391125255272 765.479965918303 0.40410657645942 1.61642630583768 473.088840663031 0.0 3.61642630583768 5.66248991421196 32.2350811743555 0.0302689519342413 0.285714285714286 0.03 0.0 0.0 0.0 0.0 0.0 0.339010898732406 0.0 0.0 0.940782445914382 0.0 0.0 2 6 3 4 
i1 345.0 10.5195057123088 395.081430905728 618.0 999.924 0.316024844012045 1.26409937604818 381.924 0.0 3.26409937604818 1.55739557199992 4.85934446344849 0.0213392333544138 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.979862881115132 0.19967156585942 0.0 0.0 0.0 0.0 2 6 3 4 
i1 352.771739130435 17.6227239746567 432.965241176763 499.009868144726 807.397966658166 0.342052059654614 1.36820823861846 308.38809851344 0.0 3.36820823861845 2.27867567826597 8.43069600441899 0.0238985390179608 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.733639656317064 0.679538707270587 0.0 0.0 0.0 0.0 2 6 3 4 
i1 354.565217391304 24.7164668104899 423.535808051102 526.41586483023 851.740869295313 0.335603390492037 1.34241356196815 325.325004465082 0.0 3.34241356196815 3.3073640213309 11.7258488759932 0.0232579643486208 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.31318904059202 0.949690804869169 0.0 0.0 0.0 0.0 2 6 3 4 
i1 357.554347826087 30.5800083501496 479.569328975657 381.95302843016 618.0 0.373652614235517 1.49461045694207 236.046971569839 0.0 3.49461045694207 3.3161997346828 15.1995889167993 0.0270970856380866 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.795602827508137 0.605818570911339 0.0 0.0 0.0 2 6 3 4 
i1 357.554347826087 2.40119152128788 423.535808051102 526.41586483023 851.740869295313 0.335603390492037 1.34241356196815 325.325004465082 0.0 3.34241356196815 0.799596776588865 0.960476608515153 0.0232579643486208 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.979862881115132 0.19967156585942 0.0 0.0 0.0 0.0 2 6 3 4 
i1 358.573878821459 4.21744646145737 432.965241176763 499.009868144725 807.397966658166 0.342052059654614 1.36820823861846 308.38809851344 0.0 3.36820823861845 1.4044096716653 1.68697858458295 0.0238985390179608 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.733639656317064 0.679538707270587 0.0 0.0 0.0 0.0 2 6 3 4 
i1 359.201282510918 5.84137624896715 414.076434089433 555.327019433991 898.519117444197 0.329114790987478 1.31645916394991 343.192098010206 0.0 3.31645916394991 1.94517829090606 2.33655049958686 0.0226176901949176 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.31318904059202 0.949690804869169 0.0 0.0 0.0 0.0 2 6 3 4 
i1 360.84821719575 6.77383081490628 404.590428285151 585.825996359163 947.866462109126 0.322587961166787 1.29035184466715 362.040465749963 0.0 3.29035184466715 2.25568566136379 2.70953232596251 0.0219780089027582 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.795602827508137 0.605818570911339 0.0 0.0 0.0 2 6 3 4 
i1 361.083493579297 8.14181660912297 461.045559003734 425.059403395186 687.746114693411 0.361144909139656 1.44457963655863 262.686711298225 0.0 3.44457963655863 2.71122493083795 3.25672664364919 0.0258194447538013 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.375601183960091 0.926781393106151 0.0 0.0 0.0 2 6 3 4 
i1 361.47562088521 9.32142690321748 470.328394438652 402.930175575755 651.941024081571 0.367421344005192 1.46968537602077 249.010848505816 0.0 3.46968537602077 3.10403515877142 3.72857076128699 0.0264586978851749 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.788501827979772 0.615032411562642 0.0 0.0 2 6 3 4 
i1 362.495151880581 9.89549516571722 470.328394438652 402.930175575755 651.941024081571 0.367421344005192 1.46968537602077 249.010848505816 0.0 3.46968537602077 3.29519989018383 3.95819806628689 0.0264586978851749 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.27337650457633 0.961907109208383 0.0 0.0 2 6 3 4 
i1 363.122555570041 10.5948289468131 461.045559003734 425.059403395186 687.746114693411 0.361144909139656 1.44457963655863 262.686711298225 0.0 3.44457963655863 3.52807803928875 4.23793157872522 0.0258194447538013 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.707106781186548 0.0 0.0 0.707106781186548 0.0 0.0 2 6 3 4 
i1 364.769490254873 10.1326836581709 404.590428285151 585.825996359163 947.866462109126 0.322587961166787 1.29035184466715 362.040465749963 0.0 3.29035184466715 3.37418365817093 4.05307346326838 0.0219780089027582 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.947371065153513 0.320137571849818 0.0 0.0 0.0 0.0 2 6 3 4 
i1 370.108695652174 29.9846046794495 461.045559003734 425.059403395186 687.746114693411 0.361144909139656 1.44457963655863 262.686711298225 0.0 3.44457963655863 3.49195301086634 14.6876182515034 0.0258194447538013 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.73388567534891 0.679273005144231 0.0 0.0 0.0 2 6 3 4 
i1 374.891304347826 32.0111077827232 442.361745876421 473.030668606697 765.363621805635 0.348459331130818 1.39383732452327 292.332953198939 0.0 3.39383732452327 3.99848421725848 15.4388808848799 0.024539142145765 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.13873380200061 0.990329708825528 0.0 0.0 0.0 2 6 3 4 
i1 382.663043478261 30.5764886156085 451.722644857788 448.403985024206 725.517647769166 0.354823959351069 1.41929583740428 277.113662744959 0.0 3.41929583740428 3.68838789825075 14.8635535927988 0.0251795216065399 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.68720204332094 0.726466345851977 0.0 0.0 2 6 3 4 
i1 384.45652173913 32.867949539765 479.569328975657 381.95302843016 618.0 0.373652614235517 1.49461045694207 236.046971569839 0.0 3.49461045694207 3.56431183063437 16.336794804704 0.0270970856380866 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.320137571849819 0.0 0.0 0.947371065153513 0.0 0.0 2 6 3 4 
i1 387.445652173913 33.554347826087 423.535808051102 526.41586483023 851.740869295313 0.335603390492037 1.34241356196815 325.325004465082 0.0 3.34241356196815 4.48998004488744 15.9186672900279 0.0232579643486208 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.839628566581554 0.0 0.0 0.543160998397533 0.0 0.0 2 6 3 4 
i1 403.0 6.85315417937716 432.965241176763 1306.40783480289 499.009868144726 0.684104119309227 1.36820823861845 807.397966658166 0.0 3.36820823861845 0.886135183778124 3.2785430697792 0.0238985390179608 0.333333333333333 0.04 0.0 0.0 0.0 0.0 0.0 0.816546988543084 0.0 0.0 0.577278975454 0.0 0.0 2 6 3 4 
i1 403.52 10.0873577421032 479.569328975657 999.953028430161 381.953028430161 0.747305228471033 1.49461045694207 618.0 0.0 3.49461045694207 1.09390725747953 5.01385379562566 0.0270970856380866 0.333333333333333 0.04 0.0 0.0 0.0 0.0 0.0 0.654222996629699 0.756301706120552 0.0 0.0 0.0 0.0 2 6 3 4 
i1 403.64 12.7773405801176 404.590428285151 1533.69245846829 585.825996359163 0.645175922333573 1.29035184466715 947.866462109127 0.0 3.29035184466715 1.82949420120164 5.95658893117307 0.0219780089027582 0.333333333333333 0.04 0.0 0.0 0.0 0.0 0.0 0.0 0.645568743750533 0.763702165174591 0.0 0.0 0.0 2 6 3 4 
i1 403.84 15.0096745510933 497.919480801851 898.545202026075 343.218182592084 0.771955847973845 1.54391169594769 555.327019433991 0.0 3.54391169594769 1.51371920355857 7.56364192613984 0.028370571241847 0.333333333333333 0.04 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.543160998397529 0.839628566581557 0.0 0.0 2 6 3 4 
i1 404.68 16.32 551.848132400556 651.959950344454 249.029774768699 0.843702260883414 1.68740452176683 402.930175575755 0.0 3.68740452176683 1.31286784625352 8.52926770844401 0.0321550842070785 0.333333333333333 0.04 0.0 0.0 0.0 0.0 0.0 0.96835331645743 0.0 0.0 0.249583361837075 0.0 0.0 2 6 3 4 
i1 405.0 5.65857866142481 328.253054101597 2352.32304946891 898.519117444198 0.538570145538911 1.07714029107782 1453.80393202471 0.0 3.07714029107782 1.0506129688637 2.43145882404407 0.0169237493829048 0.333333333333333 0.04 0.0 0.0 0.0 0.0 0.0 0.733083070829506 0.0 0.0 0.680139111699351 0.0 0.0 2 6 3 4 
i1 406.464788732394 6.62523910382093 347.343076706898 2113.76787671108 807.397966658166 0.565502128707892 1.13100425741578 1306.36991005291 0.0 3.13100425741578 1.15453071435435 2.91086313772198 0.0181713337835612 0.333333333333333 0.04 0.0 0.0 0.0 0.0 0.0 0.988481757015846 0.151340067552735 0.0 0.0 0.0 0.0 2 6 3 4 
i1 406.802816901408 7.5634734550978 337.791951621765 2229.85759581513 851.740869295313 0.552051372063029 1.10410274412606 1378.11672651982 0.0 3.10410274412606 1.36064708280938 3.28687947986947 0.017545710419483 0.333333333333333 0.04 0.0 0.0 0.0 0.0 0.0 0.681365263145279 0.73194356215419 0.0 0.0 0.0 0.0 2 6 3 4 
i1 407.366197183099 8.0589155472912 309.237947911611 2617.801032 999.924 0.51154980993464 1.02309961986928 1617.877032 0.0 3.02309961986928 1.59262650543716 3.3820149686308 0.0156927035906633 0.333333333333333 0.04 0.0 0.0 0.0 0.0 0.0 0.0 0.957873710064086 0.287189755332712 0.0 0.0 0.0 2 6 3 4 
i1 407.366197183099 1.67366411112564 337.791951621765 2229.85759581513 851.740869295313 0.552051372063029 1.10410274412606 1378.11672651982 0.0 3.10410274412606 0.557330149004839 0.334732822225129 0.017545710419483 0.333333333333333 0.048 0.0 0.0 0.0 0.0 0.0 0.733083070829506 0.0 0.0 0.680139111699351 0.0 0.0 2 6 3 4 
i1 407.630372409655 2.05668421051855 347.343076706898 2113.76787671108 807.397966658166 0.565502128707892 1.13100425741578 1306.36991005291 0.0 3.13100425741578 0.684875842102678 0.411336842103711 0.0181713337835612 0.333333333333333 0.048 0.0 0.0 0.0 0.0 0.0 0.988481757015846 0.151340067552735 0.0 0.0 0.0 0.0 2 6 3 4 
i1 407.792941779844 2.3090107946423 309.237947911611 2617.801032 999.924 0.51154980993464 1.02309961986928 1617.877032 0.0 3.02309961986928 0.768900594615886 0.46180215892846 0.0156927035906633 0.333333333333333 0.048 0.0 0.0 0.0 0.0 0.0 0.681365263145279 0.73194356215419 0.0 0.0 0.0 0.0 2 6 3 4 
i1 408.21968637659 2.2671946144616 395.081430905728 1617.924 618.0 0.632049688024089 1.26409937604818 999.924 0.0 3.26409937604818 0.754975806615714 0.453438922892321 0.0213392333544138 0.333333333333333 0.048 0.0 0.0 0.0 0.0 0.0 0.0 0.957873710064086 0.287189755332712 0.0 0.0 0.0 2 6 3 4 
i1 408.280649890411 2.42834941487713 356.900346837754 2003.72196188715 765.363621805636 0.578914733657398 1.1578294673148 1238.35834008152 0.0 3.1578294673148 0.808640355154086 0.485669882975427 0.0188001680062192 0.333333333333333 0.048 0.0 0.0 0.0 0.0 0.0 0.0 0.578987684438555 0.815336287226614 0.0 0.0 0.0 2 6 3 4 
i1 408.382255746779 2.52150174660491 366.458025508551 1899.40520185968 725.517647769166 0.592282069263508 1.18456413852702 1173.88755409051 0.0 3.18456413852702 0.839660081619434 0.504300349320981 0.0194317796704722 0.333333333333333 0.048 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.846679766162923 0.532102784779687 0.0 0.0 2 6 3 4 
i1 408.646430973336 2.43143648414349 309.237947911611 2617.801032 999.924 0.51154980993464 1.02309961986928 1617.877032 0.0 3.02309961986928 0.809668349219782 0.486287296828698 0.0156927035906633 0.333333333333333 0.048 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.24958336183706 0.968353316457434 0.0 0.0 2 6 3 4 
i1 408.809000343525 2.40226726210926 337.791951621765 2229.85759581513 851.740869295313 0.552051372063029 1.10410274412606 1378.11672651982 0.0 3.10410274412606 0.799954998282384 0.480453452421853 0.017545710419483 0.333333333333333 0.048 0.0 0.0 0.0 0.0 0.0 0.792799912988597 0.0 0.0 0.609481991502024 0.0 0.0 2 6 3 4 
i1 409.732394366197 6.85064967668511 356.900346837754 2003.72196188715 765.363621805636 0.578914733657398 1.1578294673148 1238.35834008152 0.0 3.1578294673148 1.15612446113827 3.04206894485958 0.0188001680062192 0.333333333333333 0.04 0.0 0.0 0.0 0.0 0.0 0.0 0.80274727168076 0.596319392447617 0.0 0.0 0.0 2 6 3 4 
i1 410.633802816901 6.5655006022269 376.010727604031 1800.51932826735 687.746114693411 0.605597580554072 1.21119516110814 1112.77321357394 0.0 3.21119516110814 1.03833803824561 2.97532437263611 0.0200657543073603 0.333333333333333 0.04 0.0 0.0 0.0 0.0 0.0 0.0 0.161378653759059 0.986892562597831 0.0 0.0 0.0 2 6 3 4 
i1 412.098591549296 5.59446930622569 385.553421899788 1706.78160104555 651.941024081572 0.618855269871713 1.23771053974343 1054.84057696398 0.0 3.23771053974343 0.856160701258549 2.56003298234494 0.0207016970926654 0.333333333333333 0.04 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.609481991502024 0.792799912988597 0.0 0.0 2 6 3 4 
i1 412.43661971831 5.56338028169014 328.253054101597 2352.32304946891 898.519117444198 0.538570145538911 1.07714029107782 1453.80393202471 0.0 3.07714029107782 1.03293774362633 2.39055262581119 0.0169237493829048 0.333333333333333 0.04 0.0 0.0 0.0 0.0 0.0 0.565115261318735 0.0 0.0 0.825011964413037 0.0 0.0 2 6 3 4 


        ; HERE BEGINS T466

i99     417       143   1.5       2.0     -1      1 ; was 145.5

i1 417.0 12.318894847309 309.224472101786 1000.0 2618.0 0.255765295063616 1.02306118025447 1618.0 0.0 3.02306118025447 2.43460324325138 5.16967395133329 0.015691835407634 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.979862881115132 0.19967156585942 0.0 0.0 0.0 0.0 2 6 3 4 
i1 424.77173913043478 20.9805028297928 347.32949375779 807.459333567517 2113.92853527976 0.282741516706083 1.13096606682433 1306.46920171224 0.0 3.13096606682433 3.65628087871878 9.21784625024491 0.0181704420589385 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.733639656317064 0.679538707270587 0.0 0.0 0.0 0.0 2 6 3 4 
i1 426.56521739130435 29.5530005646369 337.778381656262 851.805606521408 2230.02707787305 0.276016113933894 1.10406445573558 1378.22147135164 0.0 3.10406445573558 5.31673920291337 12.8427257833114 0.0175448235763721 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.31318904059202 0.949690804869169 0.0 0.0 0.0 0.0 2 6 3 4 
i1 429.554347826087 36.845845250403 395.067899088516 618.046971569839 1618.04697156984 0.31601548954392 1.26406195817568 1000.0 0.0 3.26406195817568 5.455225030953 17.0202188636018 0.021338326118007 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.795602827508137 0.605818570911339 0.0 0.0 0.0 2 6 3 4 
i1 429.554347826087 2.81192164992923 337.778381656262 851.805606521408 2230.02707787305 0.276016113933894 1.10406445573558 1378.22147135164 0.0 3.10406445573558 0.936369909426433 1.12476865997169 0.0175448235763721 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.979862881115132 0.19967156585942 0.0 0.0 0.0 0.0 2 6 3 4 
i1 430.5738788214588 4.98389598273843 347.32949375779 807.459333567517 2113.92853527976 0.282741516706083 1.13096606682433 1306.46920171224 0.0 3.13096606682433 1.6596373622519 1.99355839309537 0.0181704420589385 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.733639656317064 0.679538707270587 0.0 0.0 0.0 0.0 2 6 3 4 
i1 431.2012825109185 6.94536764937024 328.239506008815 898.587410087364 2352.50183960872 0.269275481882427 1.07710192752971 1453.91442952136 0.0 3.07710192752971 2.31280742724029 2.7781470597481 0.016922868075431 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.31318904059202 0.949690804869169 0.0 0.0 0.0 0.0 2 6 3 4 
i1 432.8482171957499 8.20407619431193 318.719287364986 947.938505435539 2481.70300723024 0.262523742570026 1.0500949702801 1533.7645017947 0.0 3.0500949702801 2.73195737270587 3.28163047772477 0.0163050439963448 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.795602827508137 0.605818570911339 0.0 0.0 0.0 2 6 3 4 
i1 433.0834935792973 9.89017138859535 375.997154128076 687.798387370851 1800.65617813689 0.302789345936031 1.21115738374412 1112.85779076604 0.0 3.21115738374412 3.29342707240225 3.95606855543814 0.0200648516068878 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.375601183960091 0.926781393106151 0.0 0.0 0.0 2 6 3 4 
i1 433.4756208852096 11.3815477011155 385.539866053671 651.990575365299 1706.91132630635 0.309418233690739 1.23767293476295 1054.92075094105 0.0 3.23767293476295 3.79005538447146 4.5526190804462 0.0207007918651621 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.788501827979772 0.615032411562642 0.0 0.0 2 6 3 4 
i1 434.4951518805814 12.2622038110422 385.539866053671 651.990575365299 1706.91132630635 0.309418233690739 1.23767293476295 1054.92075094105 0.0 3.23767293476295 4.08331386907704 4.90488152441686 0.0207007918651621 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.27337650457633 0.961907109208383 0.0 0.0 2 6 3 4 
i1 435.1225555700411 13.2637611967701 375.997154128076 687.798387370851 1800.65617813689 0.302789345936031 1.21115738374412 1112.85779076604 0.0 3.21115738374412 4.41683247852446 5.30550447870805 0.0200648516068878 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.707106781186548 0.0 0.0 0.707106781186548 0.0 0.0 2 6 3 4 
i1 436.7694902548726 13.1000749625187 318.719287364986 947.938505435539 2481.70300723024 0.262523742570026 1.0500949702801 1533.7645017947 0.0 3.0500949702801 4.36232496251874 5.2400299850075 0.0163050439963448 0.25 0.06 0.0 0.0 0.0 0.0 0.0 0.947371065153513 0.320137571849818 0.0 0.0 0.0 0.0 2 6 3 4 
i1 442.1086956521739 37.6440637133285 375.997154128076 687.798387370851 1800.65617813689 0.302789345936031 1.21115738374412 1112.85779076604 0.0 3.21115738374412 5.95370931586215 17.0591302294198 0.0200648516068878 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.73388567534891 0.679273005144231 0.0 0.0 0.0 2 6 3 4 
i1 446.8913043478261 41.0363988973241 356.886759307554 765.421793861969 2003.87425633063 0.289447848890405 1.15779139556162 1238.45246246867 0.0 3.15779139556162 6.92567258639775 18.2221690097282 0.0187992720292845 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.13873380200061 0.990329708825528 0.0 0.0 0.0 2 6 3 4 
i1 454.6630434782609 40.9449264903655 366.444441303383 725.572791301305 1899.54956762682 0.2961315512619 1.1845262050476 1173.97677632551 0.0 3.1845262050476 6.69035625193552 18.3701126921116 0.0194308800440795 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.68720204332094 0.726466345851977 0.0 0.0 2 6 3 4 
i1 456.4565217391304 44.5604146348152 395.067899088516 618.046971569839 1618.04697156984 0.31601548954392 1.26406195817568 1000.0 0.0 3.26406195817568 6.59740840937364 20.5838135774373 0.021338326118007 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.320137571849819 0.0 0.0 0.947371065153513 0.0 0.0 2 6 3 4 
i1 459.445652173913 46.554347826087 337.778381656262 851.805606521408 2230.02707787305 0.276016113933894 1.10406445573558 1378.22147135164 0.0 3.10406445573558 8.37537039975565 20.2309312668157 0.0175448235763721 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.839628566581554 0.0 0.0 0.543160998397533 0.0 0.0 2 6 3 4 
i1 472.0 15.346028453163 347.32949375779 2113.92853527976 807.459333567518 0.565483033412165 1.13096606682433 1306.46920171224 0.0 3.13096606682433 2.67435870592661 6.74232319314424 0.0181704420589385 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.494818011022792 0.0 0.0 0.868996625981625 0.0 0.0 2 6 3 4 
i1 476.804347826087 25.2766581120306 395.067899088516 1618.04697156984 618.046971569839 0.63203097908784 1.26406195817568 1000.0 0.0 3.26406195817568 3.74234481783485 11.676058732904 0.021338326118007 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.816546988543084 0.0 0.0 0.577278975454 0.0 0.0 2 6 3 4 
i1 477.9130434782609 34.5013308058732 318.719287364986 2481.70300723024 947.93850543554 0.525047485140052 1.0500949702801 1533.7645017947 0.0 3.0500949702801 6.6098914768801 14.6532936047242 0.0163050439963448 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.945045631346524 0.326938457011178 0.0 0.0 0.0 0.0 2 6 3 4 
i1 479.7608695652174 42.4638387166638 414.062967550319 1453.95663758265 555.369227495281 0.658211079244464 1.31642215848893 898.587410087365 0.0 3.31642215848893 5.87889095886631 19.9723152784608 0.02261678037788 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.654222996629699 0.756301706120552 0.0 0.0 0.0 0.0 2 6 3 4 
i1 479.7608695652174 3.50289779909155 337.778381656262 2230.02707787305 851.805606521409 0.552032227867788 1.10406445573558 1378.22147135164 0.0 3.10406445573558 1.16646496709749 1.40115911963662 0.0175448235763721 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.494818011022792 0.0 0.0 0.868996625981625 0.0 0.0 2 6 3 4 
i1 480.3911250896291 5.90968818710535 347.32949375779 2113.92853527976 807.459333567518 0.565483033412165 1.13096606682433 1306.46920171224 0.0 3.13096606682433 1.96792616630608 2.36387527484214 0.0181704420589385 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.816546988543084 0.0 0.0 0.577278975454 0.0 0.0 2 6 3 4 
i1 480.7789746431132 8.01300328468285 366.444441303383 1899.54956762682 725.572791301305 0.5922631025238 1.1845262050476 1173.97677632551 0.0 3.1845262050476 2.66833009379939 3.20520131387314 0.0194308800440794 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.945045631346524 0.326938457011178 0.0 0.0 0.0 0.0 2 6 3 4 
i1 481.7970797210091 9.55446976100585 356.886759307554 2003.87425633064 765.421793861969 0.57889569778081 1.15779139556162 1238.45246246867 0.0 3.15779139556162 3.18163843041495 3.82178790440234 0.0187992720292845 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.654222996629699 0.756301706120552 0.0 0.0 0.0 0.0 2 6 3 4 
i1 481.9425233035656 11.3309195755984 328.239506008815 2352.50183960872 898.587410087365 0.538550963764854 1.07710192752971 1453.91442952136 0.0 3.07710192752971 3.77319621867427 4.53236783023937 0.016922868075431 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.967522671348027 0.252784256684585 0.0 0.0 0.0 2 6 3 4 
i1 482.1849292744932 12.9349703068045 385.539866053671 1706.91132630635 651.990575365299 0.618836467381477 1.23767293476295 1054.92075094105 0.0 3.23767293476295 4.30734511216591 5.17398812272181 0.0207007918651621 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.645568743750533 0.763702165174591 0.0 0.0 0.0 2 6 3 4 
i1 482.8151847989049 14.1171787993481 375.997154128076 1800.65617813689 687.798387370852 0.605578691872061 1.21115738374412 1112.85779076604 0.0 3.21115738374412 4.70102054018293 5.64687151973926 0.0200648516068878 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.932608483466976 0.360889756803138 0.0 0.0 2 6 3 4 
i1 483.203034352389 15.355771553545 414.062967550319 1453.95663758265 555.369227495281 0.658211079244464 1.31642215848893 898.587410087365 0.0 3.31642215848893 5.11347192733047 6.14230862141798 0.02261678037788 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.543160998397529 0.839628566581557 0.0 0.0 2 6 3 4 
i1 484.2211394302849 15.8549475262369 328.239506008815 2352.50183960872 898.587410087365 0.538550963764854 1.07710192752971 1453.91442952136 0.0 3.07710192752971 5.27969752623687 6.34197901049474 0.016922868075431 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.554494539855621 0.0 0.0 0.832187361878503 0.0 0.0 2 6 3 4 
i1 487.5217391304348 45.9135490630469 356.886759307554 2003.87425633064 765.421793861969 0.57889569778081 1.15779139556162 1238.45246246867 0.0 3.15779139556162 7.74878441175564 20.3878623208783 0.0187992720292845 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.577591598504103 0.816325881825068 0.0 0.0 0.0 0.0 2 6 3 4 
i1 490.4782608695652 50.9858902284831 366.444441303383 1899.54956762682 725.572791301305 0.5922631025238 1.1845262050476 1173.97677632551 0.0 3.1845262050476 8.33103875594685 22.8750331112514 0.0194308800440794 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.902369623822601 0.430962947365846 0.0 0.0 0.0 2 6 3 4 
i1 495.2826086956522 53.7483009172156 395.067899088516 1618.04697156984 618.046971569839 0.63203097908784 1.26406195817568 1000.0 0.0 3.26406195817568 7.95772425743393 24.8279782683973 0.021338326118007 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.516982125923783 0.855996192442073 0.0 0.0 0.0 2 6 3 4 
i1 496.3913043478261 58.7988666949511 337.778381656262 2230.02707787305 851.805606521409 0.552032227867788 1.10406445573558 1378.22147135164 0.0 3.10406445573558 10.5782233164508 25.5519814199962 0.0175448235763721 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.832187361878503 0.554494539855621 0.0 0.0 2 6 3 4 
i1 498.2391304347826 62.7608695652174 347.32949375779 2113.92853527976 807.459333567518 0.565483033412165 1.13096606682433 1306.46920171224 0.0 3.13096606682433 10.9373626163627 27.5741745027358 0.0181704420589385 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.300079556718556 0.953914178340796 0.0 0.0 2 6 3 4 
i1 506.0 11.813890274583 366.444441303383 725.572791301305 1899.54956762682 0.2961315512619 1.1845262050476 1173.97677632551 0.0 3.1845262050476 1.93037676296317 5.30035133235364 0.0194308800440795 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.741740524811534 0.67068695667376 0.0 0.0 2 6 3 4 
i1 508.9673913043478 18.1562786968453 337.778381656262 851.805606521408 2230.02707787305 0.276016113933894 1.10406445573558 1378.22147135164 0.0 3.10406445573558 3.26640939607496 7.89009928243909 0.0175448235763721 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.358154834787223 0.933662205681764 0.0 0.0 2 6 3 4 
i1 509.6521739130435 23.7978204368564 507.013372378538 325.374459503564 851.83033498033 0.392062860990882 1.56825144396353 526.455875476766 0.0 3.56825144396353 2.31340843486878 12.0709339871828 0.0290044625378748 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.558448640872738 0.0 0.0 0.829539098239132 0.0 0.0 2 6 3 4 
i1 510.7934782608696 28.4598346299059 534.050929443477 277.155788824009 725.593855141254 0.410067493259931 1.64026997303972 448.438066317246 0.0 3.64026997303972 2.47230112403258 14.7051438031583 0.0308995402253298 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.881458110462779 0.0 0.0 0.472262214769916 0.0 0.0 2 6 3 4 
i1 510.7934782608696 2.69664886702438 461.0323342074 425.091710365173 1112.89009773602 0.361135955154663 1.44454382061865 687.798387370851 0.0 3.44454382061865 0.897984072719118 1.07865954680975 0.0258185355125504 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.741740524811534 0.67068695667376 0.0 0.0 2 6 3 4 
i1 511.1827537318297 4.2448850746441 470.315227971341 402.9608005966 1054.9513759619 0.367412453803356 1.46964981521342 651.990575365298 0.0 3.46964981521342 1.41354672985648 1.69795402985764 0.0264577897392985 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.358154834787223 0.933662205681764 0.0 0.0 2 6 3 4 
i1 511.4223078678052 5.52703712743767 525.086170281785 292.377392873883 765.444014543827 0.404111828308715 1.61644731323486 473.066621669943 0.0 3.61644731323486 1.84050336343675 2.21081485097507 0.0302695061452219 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.558448640872738 0.0 0.0 0.829539098239132 0.0 0.0 2 6 3 4 
i1 512.0511374747409 6.40358819198229 516.073487511781 308.434978848705 807.482774625909 0.398110358676628 1.59244143470651 499.047795777204 0.0 3.59244143470651 2.1323948679301 2.56143527679292 0.0296377800855718 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.881458110462779 0.0 0.0 0.472262214769916 0.0 0.0 2 6 3 4 
i1 512.1409702757317 7.42665125789485 497.906502341292 343.244269156539 898.613496651819 0.385969228971635 1.54387691588654 555.36922749528 0.0 3.54387691588654 2.47307486887898 2.97066050315794 0.0283696678745975 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.85505788678467 0.518532554664927 0.0 0.0 0.0 0.0 2 6 3 4 
i1 512.2906916107164 8.32489395711743 507.013372378538 325.374459503564 851.83033498033 0.392062860990882 1.56825144396353 526.455875476766 0.0 3.56825144396353 2.7721896877201 3.32995758284697 0.0290044625378748 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.460198732166751 0.88781593076049 0.0 0.0 0.0 0.0 2 6 3 4 
i1 512.6799670816766 8.9469732419555 534.050929443477 277.155788824009 725.593855141254 0.410067493259931 1.64026997303972 448.438066317246 0.0 3.64026997303972 2.97934208957118 3.5787892967822 0.0308995402253298 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.815341924357393 0.578979746092369 0.0 0.0 0.0 2 6 3 4 
i1 512.9195212176521 9.60300054423511 479.556223241403 381.982059066649 1000.02903063649 0.37364378861352 1.49457515445408 618.046971569839 0.0 3.49457515445408 3.19779918123029 3.84120021769404 0.027096178852588 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.300079556718619 0.953914178340776 0.0 0.0 0.0 2 6 3 4 
i1 513.5483508245877 9.7994752623688 488.753755168254 362.09550217483 947.966024693704 0.379829484431759 1.51931793772704 585.870522518874 0.0 3.51931793772704 3.26322526236881 3.91979010494752 0.0277335251434269 0.285714285714286 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.698254735358483 0.715849372807894 0.0 0.0 2 6 3 4 
i1 515.5869565217391 30.0946886578885 560.65525889718 236.082854800154 381.982059066649 0.427663430242165 1.71065372096866 381.982059066649 0.0 3.71065372096866 2.32862425125124 15.8138861842461 0.0327786772055172 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.933468839949804 0.0 0.0 0.358658507277838 0.0 0.0 2 6 3 4 
i1 517.413043478261 32.8165305158115 309.224472101786 1000.0 2618.0 0.255765295063616 1.02306118025447 1618.0 0.0 3.02306118025447 6.48558434959815 13.7715895040523 0.015691835407634 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.780573384236221 0.625064150165415 0.0 0.0 0.0 0.0 2 6 3 4 
i1 520.380434782609 34.0670197197014 423.522381795836 526.455875476766 1378.26148199817 0.335594194735217 1.34237677894087 851.805606521408 0.0 3.34237677894087 4.55880295513434 16.1616911725569 0.0232570539011493 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.249588438644338 0.968352007947049 0.0 0.0 0.0 0.0 2 6 3 4 
i1 521.065217391304 36.7743122138692 395.067899088516 618.046971569839 1618.04697156984 0.31601548954392 1.26406195817568 1000.0 0.0 3.26406195817568 5.44463418118996 16.9871755739307 0.021338326118007 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.698254735358483 0.715849372807894 0.0 0.0 0.0 2 6 3 4 
i1 522.20652173913 38.7934782608695 560.65525889718 236.082854800154 381.982059066649 0.427663430242165 1.71065372096866 381.982059066649 0.0 3.71065372096866 3.00170688906495 20.3848478674196 0.0327786772055172 0.285714285714286 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.940782445914382 0.339010898732406 0.0 0.0 2 6 3 4 
i1 527.0 7.30313216974222 423.522381795836 1378.26148199817 526.455875476766 0.671188389470434 1.34237677894087 851.805606521408 0.0 6.73022244351515 0.977295366342347 3.46466957458801 0.0232570539011493 0.3125 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.587539680641157 0.809195355691125 0.0 0.0 0.0 7 6 3 4 
i1 528.836956521739 11.2229848890673 404.576926399631 1533.80902795441 585.870522518874 0.645157313560665 1.29031462712133 947.938505435539 0.0 6.58888853844414 1.60701400400662 5.23190646401365 0.0219771001463047 0.3125 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.96088436133683 0.276949894634956 0.0 0.0 7 6 3 4 
i1 529.260869565217 14.7099144105886 604.035707395738 473.080355095071 180.702962221188 0.912242588891413 1.82448517778283 292.377392873883 0.0 7.79800745435897 0.931281726635651 7.92295855291605 0.0358708007758759 0.3125 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.695096385897394 0.718916555875841 0.0 0.0 7 6 3 4 
i1 529.967391304348 17.5909997550079 461.0323342074 1112.89009773602 425.091710365173 0.722271910309325 1.44454382061865 687.79838737085 0.0 6.99184053752153 2.04871902868347 8.61665938501661 0.0258185355125504 0.3125 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.134370642923261 0.990931143077252 0.0 0.0 7 6 3 4 
i1 529.967391304348 1.66701929961507 442.348413159221 1238.48841553191 473.066621669943 0.69690050602921 1.39380101205842 765.421793861968 0.0 6.86447061610543 0.555117426771819 0.833509649807535 0.0245382316121305 0.3125 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.587539680641157 0.809195355691125 0.0 0.0 0.0 7 6 3 4 
i1 530.208371357799 2.6239931682786 451.709364512829 1174.01085761855 448.438066317246 0.709629885273221 1.41925977054644 725.572791301304 0.0 6.92900059656946 0.873789725036775 1.3119965841393 0.0251786115605311 0.3125 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.96088436133683 0.276949894634956 0.0 0.0 7 6 3 4 
i1 530.356666775308 3.41646153220665 451.709364512829 1174.01085761855 448.438066317246 0.709629885273221 1.41925977054644 725.572791301304 0.0 6.92900059656946 1.13768169022481 1.70823076610333 0.0251786115605311 0.3125 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.695096385897394 0.718916555875841 0.0 0.0 7 6 3 4 
i1 530.745942246268 3.95796455259058 442.348413159221 1238.48841553191 473.066621669943 0.69690050602921 1.39380101205842 765.421793861968 0.0 6.86447061610543 1.31800219601266 1.97898227629529 0.0245382316121305 0.3125 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.134370642923261 0.990931143077252 0.0 0.0 7 6 3 4 
i1 530.801553027834 4.59024764594002 385.539866053672 1706.91132630635 651.990575365298 0.618836467381477 1.23767293476295 1054.92075094105 0.0 6.44031505770969 1.52855246609803 2.29512382297001 0.0207007918651621 0.3125 0.06 0.0 0.0 0.0 0.0 0.0 0.688369188783976 0.0 0.0 0.725360503427703 0.0 0.0 7 6 3 4 
i1 530.894237663777 5.14532210953212 395.067899088516 1618.04697156984 618.046971569838 0.632030979087841 1.26406195817568 999.999999999999 0.0 6.5155139568091 1.7133922624742 2.57266105476606 0.021338326118007 0.3125 0.06 0.0 0.0 0.0 0.0 0.0 0.996590817101929 0.0 0.0 0.0825029894495307 0.0 0.0 7 6 3 4 
i1 531.135217717228 5.52948634190051 414.062967550319 1453.95663758264 555.36922749528 0.658211079244465 1.31642215848893 898.587410087363 0.0 6.66045221113843 1.84131895185287 2.76474317095026 0.02261678037788 0.3125 0.06 0.0 0.0 0.0 0.0 0.0 0.678090203287911 0.734978690986997 0.0 0.0 0.0 0.0 7 6 3 4 
i1 531.283513134737 5.93470528342363 404.576926399631 1533.80902795441 585.870522518874 0.645157313560665 1.29031462712133 947.938505435538 0.0 6.58888853844414 1.97625685938007 2.96735264171181 0.0219771001463047 0.3125 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.940782445914392 0.339010898732376 0.0 0.0 0.0 7 6 3 4 
i1 531.672788605697 6.05547226386807 375.997154128077 1800.65617813689 687.79838737085 0.605578691872062 1.21115738374412 1112.85779076604 0.0 6.36328285379882 2.01647226386807 3.02773613193403 0.0200648516068878 0.3125 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.5315858779452 0.847004400442661 0.0 0.0 0.0 7 6 3 4 
i1 532.934782608696 18.5984887780441 534.050929443477 725.593855141254 277.155788824008 0.820134986519862 1.64026997303972 448.438066317246 0.0 7.43798031222932 1.61564764199115 9.60980467944019 0.0308995402253298 0.3125 0.05 0.0 0.0 0.0 0.0 0.0 0.276297312648905 0.0 0.0 0.961072211138681 0.0 0.0 7 6 3 4 
i1 534.065217391304 20.2791427975514 551.835560606268 652.009503066686 249.048702470086 0.843685649624714 1.68737129924943 402.960800596599 0.0 7.53523685619084 1.63145229778179 10.5983382398258 0.0321541951134574 0.3125 0.05 0.0 0.0 0.0 0.0 0.0 0.771803939897814 0.0 0.0 0.635860580912366 0.0 0.0 7 6 3 4 
i1 535.902173913043 21.0491700649693 309.224472101786 2618.0 1000.0 0.511530590127233 1.02306118025447 1618.0 0.0 5.77306118025447 4.1599817469924 8.83336918861898 0.015691835407634 0.3125 0.05 0.0 0.0 0.0 0.0 0.0 0.925914822694368 0.377732367046905 0.0 0.0 0.0 0.0 7 6 3 4 
i1 536.326086956522 22.7211999797178 497.906502341292 898.613496651819 343.244269156539 0.771938457943271 1.54387691588654 555.36922749528 0.0 7.22697945651947 2.29154253621874 11.4495083365409 0.0283696678745975 0.3125 0.05 0.0 0.0 0.0 0.0 0.0 0.5315858779452 0.847004400442661 0.0 0.0 0.0 0.0 7 6 3 4 
i1 537.032608695652 23.9673913043478 347.32949375779 2113.92853527976 807.459333567517 0.565483033412165 1.13096606682433 1306.46920171224 0.0 6.1211703829916 4.17680716471766 10.5301445754299 0.0181704420589385 0.3125 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.824679016782209 0.565601024821499 0.0 0.0 0.0 7 6 3 4 
i1 540.0 13.2501042340841 542.980086809307 262.706677005677 687.766080400863 0.415986052703258 1.66394421081303 100.353950616169 0.0 7.48733009281855 1.10782838259425 6.88611672213454 0.0315286866970051 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.432313502516143 0.901723369743862 0.0 0.0 0.0 0.0 7 6 3 4 
i1 542.6 13.3359458116696 679.301430634373 111.674430652694 180.68922879606 0.504905989611254 2.01962395844502 42.6596325093293 0.0 8.12566121376759 0.572368634803272 7.44114115691695 0.0413064958418055 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.901773222170767 0.432209504494929 0.0 0.0 0.0 7 6 3 4 
i1 543.2 13.9908549236199 488.766798121653 362.067982916664 947.893979275827 0.379838244917218 1.51935297966887 138.309969474166 0.0 7.17063668259897 1.46337066484931 7.00272270786223 0.0277344303281817 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.653841652622872 0.756631411782112 0.0 0.0 0.0 7 6 3 4 
i1 544.2 13.9868938843515 507.02628494957 325.349731044641 851.765595874871 0.392071490408751 1.568285961635 124.283597259053 0.0 7.28197069759547 1.35960761474257 7.09461704577191 0.0290053638933855 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.151776741251332 0.988414802001228 0.0 0.0 0.0 7 6 3 4 
i1 544.2 2.84177760604969 423.535808051102 526.41586483023 1378.15673412554 0.335603390492038 1.34241356196815 201.090860365148 0.0 6.73032035693565 0.946311942814547 1.13671104241988 0.0232579643486208 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.37446861885629 0.927239587966272 0.0 0.0 0.0 0.0 7 6 3 4 
i1 544.513793103448 3.03207110481027 479.569328975657 381.95302843016 999.95302843016 0.373652614235517 1.49461045694207 145.906056860321 0.0 7.11266601249762 1.00967967790182 1.21282844192411 0.0270970856380866 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.847539159002055 0.530732864968893 0.0 0.0 0.0 7 6 3 4 
i1 544.706896551724 3.1331833577807 470.328394438652 402.930175575755 1054.87119965733 0.367421344005192 1.46968537602077 153.919327069938 0.0 7.05310878457934 1.04335005814097 1.25327334311228 0.0264586978851749 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.527430427514229 0.849598225123003 0.0 0.0 0.0 7 6 3 4 
i1 545.213793103448 2.88773699003756 507.02628494957 325.349731044641 851.765595874871 0.392071490408751 1.568285961635 124.283597259053 0.0 7.28197069759547 0.961616417682508 1.15509479601502 0.0290053638933855 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.901709121535229 0.432343220300915 0.0 0.0 7 6 3 4 
i1 545.286206896552 2.95514966854424 423.535808051102 526.41586483023 1378.15673412554 0.335603390492038 1.34241356196815 201.090860365148 0.0 6.73032035693565 0.984064839625231 1.1820598674177 0.0232579643486208 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.566720151497293 0.82391035306451 0.0 0.0 7 6 3 4 
i1 545.406896551724 2.95360703094958 461.045559003734 425.059403395186 1112.8055180886 0.361144909139656 1.44457963655863 162.372692096961 0.0 6.99192867849516 0.983551141306211 1.18144281237983 0.0258194447538013 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.445162202519112 0.0 0.0 0.895449950275465 0.0 0.0 7 6 3 4 
i1 545.720689655172 2.74767459732217 451.722644857788 448.403985024206 1173.92163279337 0.354823959351069 1.41929583740428 171.290322279247 0.0 6.92909111734061 0.914975640908284 1.09906983892887 0.0251795216065399 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.863232185466191 0.0 0.0 0.50480708590041 0.0 0.0 7 6 3 4 
i1 545.913793103448 2.63343565141745 507.02628494957 325.349731044641 851.765595874871 0.392071490408751 1.568285961635 124.283597259053 0.0 7.28197069759547 0.876934071922012 1.05337426056698 0.0290053638933855 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.824679016782221 0.565601024821481 0.0 0.0 0.0 0.0 7 6 3 4 
i1 546.420689655172 2.18931034482762 479.569328975657 381.95302843016 999.95302843016 0.373652614235517 1.49461045694207 145.906056860321 0.0 7.11266601249762 0.729040344827597 0.875724137931047 0.0270970856380866 0.333333333333333 0.06 0.0 0.0 0.0 0.0 0.0 0.278581075830704 0.960412715549418 0.0 0.0 0.0 0.0 7 6 3 4 
i1 548.4 10.9689370975312 629.518920947043 153.912098126513 249.029774768698 0.472715960875905 1.89086384350362 58.7944214843281 0.0 7.91512812508787 0.612558754964729 5.98529637960171 0.0377019228369478 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.997660570188092 0.0683621729611622 0.0 0.0 7 6 3 4 
i1 550.0 9.9316849659218 432.965241176763 499.009868144726 1306.40783480289 0.342052059654614 1.36820823861846 190.621769631285 0.0 6.79831581647286 1.28419925367904 4.75130955235746 0.0238985390179608 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.740698372109432 0.671837719657386 0.0 0.0 7 6 3 4 
i1 552.6 7.82165928679667 578.162373265378 212.124958338741 343.218182592083 0.439181581198788 1.75672632479515 81.0317340853991 0.0 7.6718137657976 0.559179283528587 4.1529001392491 0.0340225662459521 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.283162982695075 0.95907180400178 0.0 0.0 7 6 3 4 
i1 553.2 7.45954949836233 679.301430634373 111.674430652694 180.68922879606 0.504905989611254 2.01962395844502 42.6596325093293 0.0 8.12566121376759 0.320158181723336 4.16225152442891 0.0413064958418055 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.640427247682067 0.0 0.0 0.768018841192306 0.0 0.0 7 6 3 4 
i1 554.2 6.65820886405468 542.980086809307 262.706677005677 687.766080400863 0.415986052703258 1.66394421081303 100.353950616169 0.0 7.48733009281855 0.556686394803313 3.46029001645818 0.0315286866970051 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.960412715549418 0.0 0.0 0.278581075830704 0.0 0.0 7 6 3 4 
i1 558.4 2.60000000000005 711.711039811068 90.1725613513566 145.899204266495 0.525721030789763 2.10288412315905 34.4459184362182 0.0 8.25140807215534 0.0926825424275219 1.46893115368133 0.0436701322768886 0.333333333333333 0.05 0.0 0.0 0.0 0.0 0.0 0.737179162706139 0.675697330224025 0.0 0.0 0.0 0.0 7 6 3 4 



        ; HERE BEGINS T610

i99     560       145.5   2.0     2.5     -1      2 ; added 2 seconds


i1 560.0 2.24155471787774 711.998748177312 90.0 145.62 0.525905366478134 2.10362146591254 145.62 0.0 4.10362146591254 0.0797690826980116 1.26655029990773 0.0436911682492207 0.415243646538506 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.979862881115132 0.19967156585942 0.0 0.0 0.0 2 6 3 4 
i1 560.105978260869565 3.87095735675139 604.354467266373 180.343447584687 291.795698192024 0.456329404406116 1.82531761762446 291.795698192024 0.0 3.82531761762446 0.244694090780623 2.08530301215215 0.035893641561222 0.238494846850876 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.733639656317064 0.679538707270587 0.0 0.0 0.0 2 6 3 4 
i1 560.130434782608696 5.34400519023468 612.888336845481 170.954498168521 276.604378036667 0.461895824654044 1.84758329861618 276.604378036667 0.0 3.84758329861618 0.324115835171845 2.89173597613485 0.0365057515683368 0.172427285990596 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.313189040592021 0.949690804869169 0.0 0.0 0.0 2 6 3 4 
i1 560.171195652173913 6.7056389678007 638.220701932647 145.62 235.61316 0.478363526986209 1.91345410794484 235.61316 0.0 3.91345410794484 0.358273906482056 3.67435272622558 0.038329482051552 0.136979319126435 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.795602827508137 0.605818570911339 0.0 0.0 2 6 3 4 
i1 560.342391304347826 7.90922010117131 587.147887281498 200.696610658226 324.727116045009 0.445075426156271 1.78030170462508 324.727116045009 0.0 3.78030170462508 0.542417701046081 4.22090506821631 0.0346631319534721 0.114584795172499 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.375601183960091 0.926781393106151 0.0 0.0 2 6 3 4 
i1 560.407608695652174 9.10406193429372 595.774524263279 190.248045153337 307.821337058099 0.450722890277742 1.80289156111097 307.821337058099 0.0 3.80289156111097 0.59955356884302 4.88179950020151 0.0352794318061628 0.0990334698870002 0.1 0.0 0.0 0.0 0.0 0.0 0.615032411562642 0.0 0.0 0.788501827979772 0.0 0.0 2 6 3 4 
i1 560.513586956521739 10.2122660732139 654.89270206233 130.852298656922 211.7190192269 0.489158399989967 1.95663359995987 211.7190192269 0.0 3.95663359995987 0.500262049203254 5.63896460465497 0.0395348973105535 0.0875436327263116 0.1 0.0 0.0 0.0 0.0 0.0 0.961907109208383 0.0 0.0 0.27337650457633 0.0 0.0 2 6 3 4 
i1 560.53804347826087 11.3413359128132 569.752452051813 223.346786751345 361.375100963676 0.43365442107359 1.73461768429436 361.375100963676 0.0 3.73461768429436 0.842466622797122 5.99215726842411 0.0334243372789412 0.0786739592745751 0.1 0.0 0.0 0.0 0.0 0.0 0.707106781186548 0.707106781186548 0.0 0.0 0.0 0.0 2 6 3 4 
i1 560.578804347826087 12.4211956521739 621.376823037393 162.05435149135 262.203940713005 0.467423039013765 1.86969215605506 262.203940713005 0.0 3.86969215605506 0.722498909598584 6.75045028523334 0.0371157587739571 0.0715993349974727 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.947371065153513 0.320137571849818 0.0 0.0 0.0 2 6 3 4 
i1 561.0 3.78929141627599 620.964100815747 162.477237451842 262.88817019708 0.467154515396837 1.86861806158735 100.410932745238 0.0 3.86861806158735 0.220862196158137 2.05890956715411 0.0370860732747416 0.367067187749554 0.1 0.0 0.0 0.0 0.0 0.0 0.545719059450368 0.83796820235174 0.0 0.0 0.0 0.0 2 6 3 4 
i1 562.28169014084507 6.1747394838633 479.450237058961 382.216904 1000.643854672 0.373572414519151 1.4942896580766 236.210046672 0.0 3.4942896580766 0.669920862656183 3.06883228444298 0.0270888458165461 0.21082473737065 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.90128589500632 0.433224809380368 0.0 0.0 0.0 2 6 3 4 
i1 562.57746478873239 8.40571013235542 569.326102108582 223.929617262027 362.318120729959 0.433373931013169 1.73349572405268 138.388503467932 0.0 3.73349572405268 0.625604317508352 4.44000814811341 0.033394043594707 0.152422317565759 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.547246473177531 0.836971503454421 0.0 0.0 0.0 2 6 3 4 
i1 563.07042253521127 10.2978380697974 586.726186652032 201.220334817339 325.574501734455 0.444799084684512 1.77919633873805 124.354166917116 0.0 3.77919633873805 0.707619777021497 5.49433591011579 0.0346330378356634 0.121087014505174 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.867607125959757 0.497250314211917 0.0 0.0 2 6 3 4 
i1 565.14084507042254 10.8889011598828 309.115498844327 1000.6148061873 2619.60956259834 0.255687581907311 1.02275032762924 618.379950223749 0.0 3.02275032762924 2.15275725844062 4.56893175462845 0.0156848149977717 0.101290697337442 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.412852054997587 0.910798100944589 0.0 0.0 2 6 3 4 
i1 565.92957746478873 11.9722131329813 533.948148207867 277.326185917823 726.03995473286 0.409999288688799 1.6399971547552 171.387582897214 0.0 3.6399971547552 1.0404788360532 6.18560201969129 0.0308923075885241 0.0875436327263116 0.1 0.0 0.0 0.0 0.0 0.0 0.669263246403153 0.0 0.0 0.743025374407841 0.0 0.0 2 6 3 4 
i1 567.2112676056338 12.3916969979284 551.73389190187 249.201819153303 403.208543390045 0.421775655856973 1.68710262342789 154.006724236741 0.0 3.68710262342789 0.997353388590166 6.47576967018674 0.0321470050824437 0.0773868434546829 0.1 0.0 0.0 0.0 0.0 0.0 0.947371065153512 0.320137571849823 0.0 0.0 0.0 0.0 2 6 3 4 
i1 567.50704225352113 13.4929577464789 347.21965213663 807.955764561784 2115.22819162275 0.282664305732981 1.13065722293192 499.316662499183 0.0 3.13065722293192 2.35228703710703 5.92743554906711 0.0181632311325367 0.0695462271867977 0.1 0.0 0.0 0.0 0.0 0.0 0.454629935826364 0.890680426107207 0.0 0.0 0.0 0.0 2 6 3 4 
i1 568.0 3.97875598708979 578.474014398118 211.7190192269 342.561373109124 0.439386194093824 1.7575447763753 130.842353882224 0.0 3.75754477637529 1.3249257437009 1.3249257437009 0.0340447588684588 0.367067187749554 0.1 0.0 0.0 0.0 0.0 0.0 0.779092892604458 0.626908497863299 0.0 0.0 0.0 0.0 2 6 3 4 
i1 569.46478873239437 6.44421645155635 679.594340609654 111.46072162218 180.343447584687 0.50509457663439 2.02037830653756 68.8827259625072 0.0 4.02037830653756 2.14592407836827 2.14592407836827 0.0413278018953212 0.21082473737065 0.1 0.0 0.0 0.0 0.0 0.0 0.348558041073124 0.937287198249964 0.0 0.0 0.0 0.0 2 6 3 4 
i1 569.80281690140845 8.75916124648352 543.298638576031 262.203940713005 686.449916786647 0.416196955958848 1.66478782383539 162.042035360637 0.0 3.66478782383539 2.91680069507901 2.91680069507901 0.0315511610713428 0.152422317565759 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.78016353789743 0.625575618239207 0.0 0.0 0.0 2 6 3 4 
i1 570.3661971830986 10.7023093215569 711.998748177312 90.0 145.62 0.525905366478134 2.10362146591254 55.62 0.0 4.10362146591254 3.56386900407844 3.56386900407844 0.0436911682492207 0.121087014505174 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.248834419796655 0.968546039961169 0.0 0.0 0.0 2 6 3 4 
i1 572.7323943661972 11.1693435521001 489.095491794136 361.375100963676 946.080014322903 0.380059006120067 1.52023602448027 223.329812395552 0.0 3.52023602448027 3.71939140284932 3.71939140284932 0.0277572430347123 0.101290697337442 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.692548382984986 0.721371428062466 0.0 0.0 2 6 3 4 
i1 573.6338028169014 12.2071818019463 507.351691265742 324.727116045009 850.135589805834 0.392288948176314 1.56915579270526 200.681357715816 0.0 3.56915579270526 4.06499154004813 4.06499154004813 0.0290280799087036 0.0875436327263116 0.1 0.0 0.0 0.0 0.0 0.0 0.372473958185936 0.0 0.0 0.928042644749314 0.0 0.0 2 6 3 4 
i1 575.0985915492958 12.4929570346837 560.982845353137 235.61316 381.22209288 0.427879386267326 1.7115175450693 145.60893288 0.0 3.7115175450693 4.16015469254967 4.16015469254967 0.0328019004508914 0.0773868434546829 0.1 0.0 0.0 0.0 0.0 0.0 0.890680426107204 0.0 0.0 0.45462993582637 0.0 0.0 2 6 3 4 
i1 575.4366197183099 13.5633802816901 452.057326073969 447.545883663327 1171.67512343059 0.355051179841929 1.42020471936772 276.583356103936 0.0 3.42020471936772 4.51660563380282 4.51660563380282 0.0252024573300638 0.0695462271867977 0.1 0.0 0.0 0.0 0.0 0.0 0.718237302017147 0.695798230804828 0.0 0.0 0.0 0.0 2 6 3 4 
i1 581.0 3.97875598708979 433.013661344173 498.872651735417 807.175950507904 0.342085124289085 1.36834049715634 1306.04860224332 0.0 3.36834049715634 1.3249257437009 1.3249257437009 0.0239018342869357 0.367067187749554 0.1 0.0 0.0 0.0 0.0 0.0 0.957163611283976 0.289547614795595 0.0 0.0 0.0 0.0 2 6 3 4 
i1 582.4647887323944 6.44421645155635 497.966442365893 343.12380536704 555.174317083871 0.386009385973193 1.54403754389277 898.298122450911 0.0 3.54403754389277 2.14592407836827 2.14592407836827 0.0283738400381008 0.21082473737065 0.1 0.0 0.0 0.0 0.0 0.0 0.656253877288457 0.754540157012115 0.0 0.0 0.0 0.0 2 6 3 4 
i1 582.8028169014085 8.75916124648351 404.639284239736 585.664907481304 947.605820304749 0.322621628317973 1.29048651327189 1533.27072778605 0.0 3.29048651327189 2.91680069507901 2.91680069507901 0.0219812972378036 0.152422317565759 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.958035275615692 0.286650328232788 0.0 0.0 0.0 2 6 3 4 
i1 583.3661971830986 10.7023093215569 461.093412027422 424.94252168843 687.55700009188 0.361177308230308 1.44470923292123 1112.49952178031 0.0 3.44470923292123 3.56386900407844 3.56386900407844 0.0258227348164763 0.121087014505174 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.609175682324023 0.79303530064245 0.0 0.0 0.0 2 6 3 4 
i1 585.7323943661972 11.1693435521001 551.893622406894 248.961297222089 402.81937890534 0.421881183468316 1.68752473387327 651.780676127428 0.0 3.68752473387327 3.71939140284932 3.71939140284932 0.032158301344836 0.101290697337442 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.888143967065316 0.459565331335473 0.0 0.0 2 6 3 4 
i1 586.6338028169014 12.2071818019463 479.616751118098 381.848 617.830064 0.373684548827896 1.49473819531158 999.678064 0.0 3.49473819531158 4.06499154004813 4.06499154004813 0.0271003668083671 0.0875436327263116 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.412843304333135 0.910802067447861 0.0 0.0 2 6 3 4 
i1 588.0985915492958 12.4929570346837 525.145183345083 292.274781142605 472.900595888735 0.404151078108574 1.6166043124343 765.17537703134 0.0 3.6166043124343 4.16015469254967 4.16015469254967 0.0302736481287335 0.0773868434546829 0.1 0.0 0.0 0.0 0.0 0.0 0.695798230804816 0.0 0.0 0.71823730201716 0.0 0.0 2 6 3 4 
i1 588.4366197183099 13.5633802816901 534.109626639204 277.058519212821 448.280684086344 0.410106443317365 1.64042577326946 725.339203299164 0.0 3.64042577326946 4.51660563380282 4.51660563380282 0.0309036707977969 0.0695462271867977 0.1 0.0 0.0 0.0 0.0 0.0 0.908317821837858 0.418280688690895 0.0 0.0 0.0 0.0 2 6 3 4 
i1 594.0 3.97875598708979 309.115498844327 1000.6148061873 2619.60956259834 0.255687581907311 1.02275032762924 1618.99475641104 0.0 3.02275032762924 1.3249257437009 1.3249257437009 0.0156848149977717 0.367067187749554 0.1 0.0 0.0 0.0 0.0 0.0 0.880148497569861 0.0 0.0 0.474698453995287 0.0 0.0 2 6 3 4 
i1 597.2957746478873 5.84021635155467 533.948148207867 277.326185917823 726.03995473286 0.409999288688799 1.6399971547552 448.713768815037 0.0 3.6399971547552 1.94479204506771 1.94479204506771 0.0308923075885241 0.21082473737065 0.1 0.0 0.0 0.0 0.0 0.0 0.860142775889833 0.510053335529269 0.0 0.0 0.0 0.0 2 6 3 4 
i1 598.056338028169 7.73093982356542 551.73389190187 249.201819153303 403.208543390045 0.421775655856973 1.68710262342789 403.208543390045 0.0 3.68710262342789 2.57440296124728 2.57440296124728 0.0321470050824437 0.152422317565759 0.1 0.0 0.0 0.0 0.0 0.0 0.476453599822028 0.879199617388811 0.0 0.0 0.0 0.0 2 6 3 4 
i1 599.3239436619718 9.0035300641669 347.21965213663 807.955764561784 2115.22819162275 0.282664305732981 1.13065722293192 1307.27242706097 0.0 3.13065722293192 2.99817551136758 2.99817551136758 0.0181632311325367 0.121087014505174 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.824785702709663 0.565445439105956 0.0 0.0 0.0 2 6 3 4 
i1 604.6478873239437 7.10776407860912 497.801545211789 343.455297856971 899.16596978955 0.385898911027562 1.54359564411025 555.710671932579 0.0 3.54359564411025 2.36688543817684 2.36688543817684 0.0283623624584608 0.101290697337442 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.313011421027813 0.949749361835084 0.0 0.0 0.0 2 6 3 4 
i1 606.6760563380282 6.61268968373079 603.937319486719 180.814059520425 292.557148304048 0.456057056751216 1.82422822700486 292.557148304048 0.0 3.82422822700486 2.20202566468235 2.20202566468235 0.0358637511128619 0.0875436327263116 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.69254316644671 0.721376436133011 0.0 0.0 2 6 3 4 
i1 609.9718309859155 4.51872914020474 460.925385449698 425.353059378875 1113.57430945389 0.361063543102754 1.44425417241101 688.221250075019 0.0 3.44425417241102 1.50473680368818 1.50473680368818 0.0258111826451242 0.0773868434546829 0.1 0.0 0.0 0.0 0.0 0.0 0.418280688690953 0.0 0.0 0.908317821837831 0.0 0.0 2 6 3 4 
i1 610.7323943661972 4.26760563380282 637.812254073956 146.0 236.228 0.47809864735312 1.91239458941248 236.228 0.0 3.91239458941248 1.42111267605634 1.42111267605634 0.038300000428719 0.0695462271867977 0.1 0.0 0.0 0.0 0.0 0.0 0.930474229128564 0.0 0.0 0.366357351403796 0.0 0.0 2 6 3 4 
i1 612.0 4.2812883293879 404.467738156478 1534.75202323493 586.230719341074 0.645006823452219 1.29001364690444 223.94013478829 0.0 3.29001364690444 0.642193249408185 3.21096624704092 0.0219697513163385 0.30021334189347 0.15 0.0 0.0 0.0 0.0 0.0 0.636907391451222 0.0 0.0 0.77094031851681 0.0 0.0 2 6 3 4 
i1 612.7065217391304 6.20267122495464 423.413804640485 1379.10884568502 526.779543806348 0.671039655744937 1.34207931148987 201.229785734025 0.0 3.34207931148987 1.08664910993415 4.32804564499288 0.0232496913513765 0.172427285990596 0.15 0.0 0.0 0.0 0.0 0.0 0.909700580274315 0.0 0.0 0.415264800155965 0.0 0.0 2 6 3 4 
i1 612.8695652173913 7.82669941626877 479.450237058961 1000.643854672 382.216904 0.747144829038301 1.4942896580766 146.006857328 0.0 3.4942896580766 1.42117488380732 5.37102937060712 0.0270888458165461 0.124661682827355 0.15 0.0 0.0 0.0 0.0 0.0 0.855748259755463 0.517392419663738 0.0 0.0 0.0 0.0 2 6 3 4 
i1 613.1413043478261 9.13421387677914 366.334588698751 1900.71742245407 726.01887794273 0.592109719164062 1.18421943832812 277.339211374123 0.0 3.18421943832812 1.76063993322179 6.0966750964216 0.0194236051549689 0.0990334698870002 0.15 0.0 0.0 0.0 0.0 0.0 0.516915436088436 0.856036466474123 0.0 0.0 0.0 0.0 2 6 3 4 
i1 614.2826086956522 9.64068792037229 385.430242060887 1707.96074595093 652.391423205093 0.618684411418004 1.23736882283601 249.213523664345 0.0 3.23736882283601 2.38789655252241 5.72651642734431 0.0206934716240528 0.0828426505153634 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.880507784360693 0.474031688476861 0.0 0.0 0.0 2 6 3 4 
i1 614.7173913043478 10.4142649675736 515.969604842962 807.979220031885 308.62460658208 0.796082202344728 1.59216440468946 117.894599714354 0.0 3.59216440468946 2.83808182131301 5.91724993970965 0.0296305085857606 0.0715993349974727 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.505917821049028 0.862581682129295 0.0 0.0 0.0 2 6 3 4 
i1 615.4239130434783 10.8158050311945 328.129947191086 2353.94817229534 899.139867186912 0.538395843671782 1.07679168734356 343.471429265401 0.0 3.07679168734356 3.44250394389821 5.71744437230292 0.0169157414583561 0.063292398959856 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.841993124783052 0.539488255495959 0.0 0.0 2 6 3 4 
i1 615.5869565217391 11.5660952121325 442.240592003287 1239.24984587268 473.35746595595 0.696753674564038 1.39350734912808 180.822551995173 0.0 3.39350734912808 3.81558085847421 6.01306173420106 0.0245308683266507 0.0568797919744227 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.366357351403727 0.930474229128591 0.0 0.0 2 6 3 4 
i1 615.8586956521739 12.1413043478261 620.964100815747 425.365407648921 162.477237451842 0.934309030793675 1.86861806158735 62.0663047066035 0.0 3.86861806158735 4.25176984120156 6.13927727072198 0.0370860732747416 0.0517649717608577 0.15 0.0 0.0 0.0 0.0 0.0 0.68430282476572 0.0 0.0 0.729197945703124 0.0 0.0 2 6 3 4 
i1 628.0 3.97875598708979 534.109626639204 725.339203299164 277.058519212821 0.820212886634729 1.64042577326946 105.836354339297 0.0 3.64042577326946 0.596813398063469 2.98406699031735 0.0309036707977969 0.367067187749554 0.15 0.0 0.0 0.0 0.0 0.0 0.260716319445175 0.0 0.0 0.965415455011448 0.0 0.0 2 6 3 4 
i1 629.4647887323944 6.44421645155635 507.073008078686 851.531379631668 325.260267238987 0.784205430063062 1.56841086012612 124.249422085293 0.0 3.56841086012612 1.18201124468153 4.40160624366877 0.0290086254080192 0.21082473737065 0.15 0.0 0.0 0.0 0.0 0.0 0.743952973335741 0.0 0.0 0.668231975787533 0.0 0.0 2 6 3 4 
i1 629.8028169014084 8.75916124648352 337.841054517244 2229.24443549085 851.506659851357 0.552120644492805 1.10424128898561 325.275544063219 0.0 3.10424128898561 1.68296104306452 5.85503776030278 0.0175489195080182 0.152422317565759 0.15 0.0 0.0 0.0 0.0 0.0 0.966279675525058 0.257494832311617 0.0 0.0 0.0 0.0 2 6 3 4 
i1 630.3661971830986 10.7023093215569 366.50717963952 1898.88290845776 725.318146851704 0.592350699212918 1.18470139842584 277.071532097351 0.0 3.18470139842584 2.22171900002489 6.90115094400948 0.019435034993153 0.121087014505174 0.15 0.0 0.0 0.0 0.0 0.0 0.622060956774908 0.782968815506905 0.0 0.0 0.0 0.0 2 6 3 4 
i1 632.7323943661972 11.1693435521001 423.584390221598 1377.77777224404 526.271112392681 0.671273329014532 1.34254665802906 201.035564934004 0.0 3.34254665802906 3.20892562007801 6.19233497010741 0.0232612587923678 0.101290697337442 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.897030951664042 0.441967727053348 0.0 0.0 0.0 2 6 3 4 
i1 633.6338028169014 12.2071818019463 395.130395234815 1617.479107552 617.830064 0.632117384839913 1.26423476967983 236.011084448 0.0 3.26423476967983 3.96924179077221 6.38918056842846 0.0213425161948275 0.0875436327263116 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.431629952553665 0.902050765787891 0.0 0.0 0.0 2 6 3 4 
i1 635.0985915492958 12.4929570346837 309.286710447877 2617.08119601914 999.649043552 0.5116193564112 1.0232387128224 381.865934636864 0.0 3.0232387128224 4.96726830381399 5.9549045184734 0.0156958451825096 0.0773868434546829 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.729197945703131 0.684302824765713 0.0 0.0 2 6 3 4 
i1 635.4366197183099 13.5633802816901 479.616751118097 999.678064 381.848 0.747369097655792 1.49473819531158 145.865936 0.0 3.49473819531158 5.64911432343633 6.32708404748206 0.0271003668083671 0.0695462271867977 0.15 0.0 0.0 0.0 0.0 0.0 0.398865782592277 0.0 0.0 0.917009317006676 0.0 0.0 2 6 3 4 
i1 636.0 6.8 442.340174010594 1238.54658485581 473.08884066303 0.696889286081252 1.3937785721625 180.719937133278 0.0 3.3937785721625 1.02 5.1 0.024537668936714 0.480449773592572 0.15 0.0 0.0 0.0 0.0 0.0 0.347658981189873 0.0 0.0 0.937621049677331 0.0 0.0 2 6 3 4 
i1 639.38 12.248 395.05953692041 1618.122968 618.076 0.632019417607193 1.26403883521439 236.105032 0.0 3.26403883521439 2.44460087556343 8.04351296513682 0.0213377654816299 0.275945932292243 0.15 0.0 0.0 0.0 0.0 0.0 0.986858625445379 0.161586055660928 0.0 0.0 0.0 0.0 2 6 3 4 
i1 640.16 17.904 470.307091552473 1055.00092491813 402.979726859483 0.734813919901555 1.46962783980311 153.938255660322 0.0 3.46962783980311 3.81698215669039 11.4030159737606 0.0264572285387776 0.199503715965179 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.981142813358199 0.193284194375944 0.0 0.0 0.0 2 6 3 4 
i1 641.46 22.832 375.988766225546 1800.74075135626 687.83069188551 0.605567019325829 1.21113403865166 262.751324300265 0.0 3.21113403865166 5.43283032745067 13.8174768083917 0.0200642937742821 0.158489319246111 0.15 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.917009317006648 0.398865782592341 0.0 0.0 2 6 3 4 
i1 646.92 23.08 318.710934485571 2481.81956785709 947.983028211263 0.525035615783064 1.05007123156613 362.129516776702 0.0 3.05007123156613 8.71182047893266 11.2705242607332 0.0163045032258519 0.132578160693599 0.15 0.0 0.0 0.0 0.0 0.0 0.62596000526975 0.0 0.0 0.779855160784806 0.0 0.0 2 6 3 4 
i1 649.0 6.71487603305785 328.253054101597 2352.32304946891 898.519117444198 0.538570145538911 1.07714029107782 343.234302863684 0.0 3.07714029107782 1.00723140495868 5.03615702479339 0.0169237493829048 0.574349177498518 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.45740785963838 0.889257021305447 0.0 0.0 2 6 3 4 
i1 654.3719008264463 5.25087419794245 347.343076706898 2113.76787671108 807.397966658166 0.565502128707892 1.13100425741578 308.42602326342 0.0 3.13100425741578 0.88630629471652 3.72784534918098 0.0181713337835612 0.329876977693224 0.05 0.0 0.0 0.0 0.0 0.0 0.267015069694941 0.0 0.0 0.963692353687527 0.0 0.0 2 6 3 4 
i1 655.6115702479339 8.32827413370918 337.791951621765 2229.85759581513 851.740869295313 0.552051372063029 1.10410274412606 325.36501207081 0.0 3.10410274412606 1.44456365836301 5.83822601133459 0.017545710419483 0.238494846850876 0.05 0.0 0.0 0.0 0.0 0.0 0.594641726484373 0.0 0.0 0.803990806616397 0.0 0.0 2 6 3 4 
i1 657.6776859504132 11.2597879940768 309.237947911611 2617.801032 999.924 0.51154980993464 1.02309961986928 381.970968 0.0 3.02309961986928 2.04374939136473 7.72838593180046 0.0156927035906633 0.1894645708138 0.05 0.0 0.0 0.0 0.0 0.0 0.802753076738805 0.0 0.0 0.596311577773216 0.0 0.0 2 6 3 4 
i1 666.355371900826 11.9601050277024 366.458025508551 1899.40520185968 725.517647769166 0.592282069263508 1.18456413852702 277.147741447821 0.0 3.18456413852702 2.62687004911846 7.51261106721877 0.0194317796704722 0.158489319246111 0.05 0.0 0.0 0.0 0.0 0.0 0.972556783944559 0.0 0.0 0.232665644226682 0.0 0.0 2 6 3 4 
i1 669.661157024793 13.5779790889887 356.900346837754 2003.72196188715 765.363621805636 0.578914733657398 1.1578294673148 292.368903529753 0.0 3.1578294673148 3.20688907283563 8.24562086240085 0.0188001680062192 0.136979319126435 0.05 0.0 0.0 0.0 0.0 0.0 0.860905297313014 0.508765239632575 0.0 0.0 0.0 0.0 2 6 3 4 
i1 675.03305785124 13.7812394041158 395.081430905728 1617.924 618.0 0.632049688024089 1.26409937604818 236.076 0.0 3.26409937604818 3.66267210453402 7.92212177653411 0.0213392333544138 0.121087014505174 0.05 0.0 0.0 0.0 0.0 0.0 0.645173504823748 0.764036091211299 0.0 0.0 0.0 0.0 2 6 3 4 
i1 676.272727272727 15.4839983301374 309.237947911611 2617.801032 999.924 0.51154980993464 1.02309961986928 381.970968 0.0 3.02309961986928 4.22885049920802 8.78892928767216 0.0156927035906633 0.108818820412016 0.05 0.0 0.0 0.0 0.0 0.0 0.281426250440919 0.959582860186011 0.0 0.0 0.0 0.0 2 6 3 4 
i1 678.338842975207 16.5057484744096 347.343076706898 2113.76787671108 807.397966658166 0.565502128707892 1.13100425741578 308.42602326342 0.0 3.13100425741578 4.71726412161003 9.17319812401979 0.0181713337835612 0.0990334698870002 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.8543472388497 0.519702602908522 0.0 0.0 0.0 2 6 3 4 
i1 687.01652892562 12.3963672251272 337.791951621765 2229.85759581513 851.740869295313 0.552051372063029 1.10410274412606 325.36501207081 0.0 3.10410274412606 4.28702061398075 6.30488701583471 0.017545710419483 0.091028210151304 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.606895264258263 0.794781817998432 0.0 0.0 0.0 2 6 3 4 
i1 690.322314049587 11.1931372014056 395.081430905728 1617.924 618.0 0.632049688024089 1.26409937604818 236.076 0.0 3.26409937604818 4.1625376318664 5.50385541478638 0.0213392333544138 0.0843454880117311 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.997202943377681 0.0747414859290971 0.0 0.0 2 6 3 4 
i1 695.694214876033 7.54512021897668 366.458025508551 1899.40520185968 725.517647769166 0.592282069263508 1.18456413852702 277.147741447821 0.0 3.18456413852702 3.15742810773312 3.51193414590182 0.0194317796704722 0.0786739592745751 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.779855160784786 0.625960005269774 0.0 0.0 2 6 3 4 
i1 696.933884297521 7.06611570247935 356.900346837754 2003.72196188715 765.363621805636 0.578914733657398 1.1578294673148 292.368903529753 0.0 3.1578294673148 3.03862777926233 3.24758526231399 0.0188001680062192 0.0737940458317425 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.457820181232977 0.889044814199939 0.0 0.0 2 6 3 4 


        ; HERE BEGINS T754G

i99     703       112.5   2.5     1.25       -1      1


i1 703.0 6.825 395.081430905728 618.0 1617.924 0.316024844012045 1.26409937604818 999.924 0.0 3.26409937604818 2.0475 4.43625 0.0213392333544138 0.574349177498518 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0824589821479948 0.996594459277753 0.0 0.0 0.0 2 6 3 4 
i1 708.46 3.77228064495938 356.900346837754 765.363621805636 2003.72196188715 0.289457366828699 1.1578294673148 1238.35834008152 0.0 3.1578294673148 1.15459143818038 2.33752488159789 0.0188001680062192 0.329876977693224 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.795675476248549 0.605723151692789 0.0 0.0 2 6 3 4 
i1 709.72 7.03333444104067 366.458025508551 725.517647769166 1899.40520185968 0.296141034631754 1.18456413852702 1173.88755409051 0.0 3.18456413852702 2.16268869485647 4.31044879901042 0.0194317796704722 0.238494846850876 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.497406700782887 0.867517477643121 0.0 0.0 2 6 3 4 
i1 711.82 10.6598210647672 309.237947911611 999.924 2617.801032 0.25577490496732 1.02309961986928 1617.877032 0.0 3.02309961986928 3.30316292435052 6.41395774302652 0.0156927035906633 0.1894645708138 0.05 0.0 0.0 0.0 0.0 0.0 0.396307079845943 0.0 0.0 0.918118019899393 0.0 0.0 2 6 3 4 
i1 711.82 0.823706896551724 366.458025508551 725.517647769166 1899.40520185968 0.296141034631754 1.18456413852702 1173.88755409051 0.0 3.18456413852702 0.247112068965517 0.53540948275862 0.0194317796704722 0.574349177498518 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.979862881115132 0.19967156585942 0.0 0.0 2 6 3 4 
i1 712.4789655172414 0.981587707502171 356.900346837754 765.363621805636 2003.72196188715 0.289457366828699 1.1578294673148 1238.35834008152 0.0 3.1578294673148 0.297887402423391 0.62074152027081 0.0188001680062192 0.329876977693224 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.733639656317064 0.679538707270587 0.0 0.0 2 6 3 4 
i1 712.8844827586207 1.80798928013863 376.010727604031 687.746114693411 1800.51932826735 0.302798790277036 1.21119516110814 1112.77321357394 0.0 3.21119516110814 0.552582199595858 1.12417770535151 0.0200657543073603 0.238494846850876 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.313189040592021 0.949690804869169 0.0 0.0 2 6 3 4 
i1 713.9489655172414 2.57398827582041 385.553421899788 651.941024081572 1706.78160104555 0.309427634935857 1.23771053974343 1054.84057696398 0.0 3.23771053974343 0.801470218182062 1.53098678404231 0.0207016970926654 0.1894645708138 0.06 0.0 0.0 0.0 0.0 0.0 0.605818570911339 0.0 0.0 0.795602827508137 0.0 0.0 2 6 3 4 
i1 714.1010344827586 3.61905562531709 328.253054101597 898.519117444198 2352.32304946891 0.269285072769456 1.07714029107782 1453.80393202471 0.0 3.07714029107782 1.12987484010518 2.13897974887187 0.0169237493829048 0.158489319246111 0.06 0.0 0.0 0.0 0.0 0.0 0.926781393106151 0.0 0.0 0.375601183960091 0.0 0.0 2 6 3 4 
i1 714.3544827586207 4.71242697990921 318.73280422363 947.866462109127 2481.51439780169 0.262533346189114 1.05013338475646 1533.64793569257 0.0 3.05013338475646 1.47775851923924 2.75592213904216 0.0163059190908507 0.136979319126435 0.06 0.0 0.0 0.0 0.0 0.0 0.788501827979772 0.615032411562642 0.0 0.0 0.0 0.0 2 6 3 4 
i1 715.0134482758621 5.58979594860281 318.73280422363 947.866462109127 2481.51439780169 0.262533346189114 1.05013338475646 1533.64793569257 0.0 3.05013338475646 1.77319527005132 3.18043549885219 0.0163059190908507 0.121087014505174 0.06 0.0 0.0 0.0 0.0 0.0 0.27337650457633 0.961907109208383 0.0 0.0 0.0 0.0 2 6 3 4 
i1 715.4189655172414 6.58536120751369 328.253054101597 898.519117444198 2352.32304946891 0.269285072769456 1.07714029107782 1453.80393202471 0.0 3.07714029107782 2.10386672071083 3.68406828395976 0.0169237493829048 0.108818820412016 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.707106781186548 0.707106781186548 0.0 0.0 0.0 2 6 3 4 
i1 716.4834482758621 6.88655172413793 385.553421899788 651.941024081572 1706.78160104555 0.309427634935857 1.23771053974343 1054.84057696398 0.0 3.23771053974343 2.24140440767836 3.68532373583618 0.0207016970926654 0.0990334698870002 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.947371065153513 0.320137571849819 0.0 0.0 2 6 3 4 
i1 720.64 12.3242038866188 328.253054101597 898.519117444198 2352.32304946891 0.269285072769456 1.07714029107782 1453.80393202471 0.0 3.07714029107782 3.9445528649899 6.86432562582079 0.0169237493829048 0.158489319246111 0.05 0.0 0.0 0.0 0.0 0.0 0.429847493202951 0.0 0.0 0.902901507689038 0.0 0.0 2 6 3 4 
i1 724.0 15.0148472254838 347.343076706898 807.397966658166 2113.76787671108 0.282751064353946 1.13100425741578 1306.36991005291 0.0 3.13100425741578 4.86536657472846 8.12052023471101 0.0181713337835612 0.136979319126435 0.05 0.0 0.0 0.0 0.0 0.0 0.794645456965135 0.0 0.0 0.60707379924081 0.0 0.0 2 6 3 4 
i1 729.46 16.1291259326861 337.791951621765 851.740869295313 2229.85759581513 0.276025686031514 1.10410274412606 1378.11672651982 0.0 3.10410274412606 5.33222620634296 8.31596510763032 0.017545710419483 0.121087014505174 0.05 0.0 0.0 0.0 0.0 0.0 0.948728514406457 0.316092084608454 0.0 0.0 0.0 0.0 2 6 3 4 
i1 730.72 19.0892271213905 309.237947911611 999.924 2617.801032 0.25577490496732 1.02309961986928 1617.877032 0.0 3.02309961986928 6.34007625026557 9.7341749068151 0.0156927035906633 0.108818820412016 0.05 0.0 0.0 0.0 0.0 0.0 0.64012300357469 0.768272438848692 0.0 0.0 0.0 0.0 2 6 3 4 
i1 732.82 21.2737347943146 366.458025508551 725.517647769166 1899.40520185968 0.296141034631754 1.18456413852702 1173.88755409051 0.0 3.18456413852702 7.12028235981609 10.6504877963664 0.0194317796704722 0.0990334698870002 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.947371065153513 0.320137571849819 0.0 0.0 0.0 2 6 3 4 
i1 741.64 16.36 356.900346837754 765.363621805636 2003.72196188715 0.289457366828699 1.1578294673148 1238.35834008152 0.0 3.1578294673148 5.65582027607708 7.58179225811375 0.0188001680062192 0.091028210151304 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.602774947395155 0.797911249947491 0.0 0.0 0.0 2 6 3 4 
i1 745.0 4.88938053097345 309.237947911611 999.924 2617.801032 0.25577490496732 1.02309961986928 2617.801032 0.0 3.02309961986928 1.95575221238938 1.95575221238938 0.0156927035906633 0.415243646538506 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.952702220018468 0.303905379965348 0.0 0.0 0.0 2 6 3 4 
i1 748.9115044247788 4.18986252876466 385.553421899788 651.941024081572 1706.78160104555 0.309427634935857 1.23771053974343 1706.78160104555 0.0 3.23771053974343 1.64096920181155 1.64096920181155 0.0207016970926654 0.238494846850876 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.756123978744478 0.65442839850332 0.0 0.0 0.0 2 6 3 4 
i1 749.8141592920354 7.90288167551043 290.352934708156 1112.77321357394 2913.24027313657 0.242256819420665 0.96902727768266 2913.24027313657 0.0 2.96902727768266 3.08015408922961 3.08015408922961 0.0144821218757436 0.172427285990596 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.477783202594493 0.87847778077681 0.0 0.0 0.0 2 6 3 4 
i1 751.3185840707965 12.2242444082742 235.09505718845 1533.64793569257 4015.09029564314 0.202077642759497 0.808310571037988 4015.09029564314 0.0 2.80831057103799 4.72591783842763 4.72591783842763 0.0110149414471278 0.136979319126435 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.933000809321676 0.359874269440173 0.0 0.0 2 6 3 4 
i1 751.3185840707965 0.522210309991058 299.775541820801 1054.84057696398 2761.57263049171 0.249014418737944 0.996057674951777 2761.57263049171 0.0 2.99605767495178 0.208884123996423 0.208884123996423 0.0150846010245668 0.415243646538506 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.907451873651976 0.420156038877842 0.0 0.0 0.0 2 6 3 4 
i1 751.7363523187893 1.10131069253332 280.977745218576 1173.88755409051 3073.23761660896 0.235507289870998 0.942029159483991 3073.23761660896 0.0 2.94202915948399 0.435217010520854 0.435217010520854 0.0138857869982667 0.238494846850876 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.633691393762179 0.773585947049031 0.0 0.0 0.0 2 6 3 4 
i1 751.9934404714003 2.06262894767218 290.352934708156 1112.77321357394 2913.24027313657 0.242256819420665 0.96902727768266 2913.24027313657 0.0 2.96902727768266 0.809054426702819 0.809054426702819 0.0144821218757436 0.172427285990596 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.980522826024047 0.196405161963264 0.0 0.0 2 6 3 4 
i1 752.6682968720041 3.08392647996027 318.73280422363 947.866462109126 2481.51439780169 0.262533346189114 1.05013338475646 2481.51439780169 0.0 3.05013338475646 1.18619826534535 1.18619826534535 0.0163059190908508 0.136979319126435 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.704500884560251 0.709703109513988 0.0 0.0 2 6 3 4 
i1 752.7647049292332 4.36952997051926 262.401284639812 1306.36991005291 3420.07642451853 0.222054338759956 0.888217355039825 3420.07642451853 0.0 2.88821735503983 1.67599695466909 1.67599695466909 0.012713672044777 0.114584795172499 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0664370875299003 0.997790616011468 0.0 0.0 2 6 3 4 
i1 752.9253850246151 5.76559264901591 271.657836065845 1238.35834008152 3242.02213433342 0.228771249776561 0.915084999106242 3242.02213433341 0.0 2.91508499910624 2.20119160669144 2.20119160669144 0.0132961254366895 0.0990334698870002 0.06 0.0 0.0 0.0 0.0 0.0 0.717584301713272 0.0 0.0 0.696471657667903 0.0 0.0 2 6 3 4 
i1 753.343153272608 7.09889252362122 235.09505718845 1533.64793569257 4015.09029564314 0.202077642759497 0.808310571037988 4015.09029564314 0.0 2.80831057103799 2.67756799497534 2.67756799497534 0.0110149414471278 0.0875436327263116 0.06 0.0 0.0 0.0 0.0 0.0 0.968541351962634 0.248852666327674 0.0 0.0 0.0 0.0 2 6 3 4 
i1 753.6002414252189 8.57684357547417 318.73280422363 947.866462109126 2481.51439780169 0.262533346189114 1.05013338475646 2481.51439780169 0.0 3.05013338475646 3.21098310823184 3.21098310823184 0.0163059190908508 0.0786739592745751 0.06 0.0 0.0 0.0 0.0 0.0 0.602774947395156 0.79791124994749 0.0 0.0 0.0 0.0 2 6 3 4 
i1 754.2750978258228 9.68065438656661 280.977745218576 1173.88755409051 3073.23761660896 0.235507289870998 0.942029159483991 3073.23761660896 0.0 2.94202915948399 3.55395468099363 3.55395468099363 0.0138857869982667 0.0715993349974727 0.06 0.0 0.0 0.0 0.0 0.0 0.0 0.872266915741584 0.489030088749828 0.0 0.0 0.0 2 6 3 4 
i1 757.6371681415929 15.6798537377631 337.791951621765 851.740869295313 2229.85759581513 0.276025686031514 1.10410274412606 2229.85759581513 0.0 3.10410274412606 5.85882196368395 5.85882196368395 0.017545710419483 0.114584795172499 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.94542764473876 0.32583211714581 0.0 0.0 2 6 3 4 
i1 760.0442477876106 20.0782956900828 309.237947911611 999.924 2617.801032 0.25577490496732 1.02309961986928 2617.801032 0.0 3.02309961986928 7.40557228906117 7.40557228906117 0.0156927035906633 0.0990334698870002 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.708865452779279 0.705343724616607 0.0 0.0 2 6 3 4 
i1 763.9557522123894 23.7966950769393 366.458025508551 725.517647769166 1899.40520185968 0.296141034631754 1.18456413852702 1899.40520185968 0.0 3.18456413852702 8.59387615145561 8.59387615145561 0.0194317796704722 0.0875436327263116 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.305994433668514 0.952033301184305 0.0 0.0 2 6 3 4 
i1 764.858407079646 28.9225206051797 356.900346837754 765.363621805636 2003.72196188715 0.289457366828699 1.1578294673148 2003.72196188715 0.0 3.1578294673148 10.394291482742 10.394291482742 0.0188001680062192 0.0786739592745751 0.05 0.0 0.0 0.0 0.0 0.0 0.576966357442 0.0 0.0 0.816767912188102 0.0 0.0 2 6 3 4 
i1 766.3628318584071 33.8292126934162 290.352934708156 1112.77321357394 2913.24027313657 0.242256819420665 0.96902727768266 2913.24027313657 0.0 2.96902727768266 12.0594588985974 12.0594588985974 0.0144821218757436 0.0715993349974727 0.05 0.0 0.0 0.0 0.0 0.0 0.881557057610253 0.0 0.0 0.472077487471658 0.0 0.0 2 6 3 4 
i1 772.6814159292035 34.6160074509296 385.553421899788 651.941024081572 1706.78160104555 0.309427634935857 1.23771053974343 1706.78160104555 0.0 3.23771053974343 11.926611096112 11.926611096112 0.0207016970926654 0.0658116828611607 0.05 0.0 0.0 0.0 0.0 0.0 0.872266915741584 0.489030088749828 0.0 0.0 0.0 0.0 2 6 3 4 
i1 775.0884955752212 37.9115044247788 328.253054101597 898.519117444198 2352.32304946891 0.269285072769456 1.07714029107782 2352.32304946891 0.0 3.07714029107782 12.8936117047168 12.8936117047168 0.0169237493829048 0.0609802005177442 0.05 0.0 0.0 0.0 0.0 0.0 0.530169379081395 0.847891755759217 0.0 0.0 0.0 0.0 2 6 3 4 
i1 779.0 6.40845070422536 269.236240663787 1255.7543481994 3287.56488358602 0.227016642559474 0.908066570237894 3287.56488358602 0.0 2.90806657023789 2.11478873239437 1.92253521126761 0.0131434389924313 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.825455587704661 0.564467069656993 0.0 0.0 0.0 0.0 2 6 3 4 
i1 784.1267605633803 3.93761603654939 269.236240663787 1255.7543481994 3287.56488358602 0.227016642559474 0.908066570237894 3287.56488358602 0.0 2.90806657023789 1.2994132920613 1.18128481096482 0.0131434389924313 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.442587731374017 0.896725208766432 0.0 0.0 0.0 0.0 2 6 3 4 
i1 785.3098591549296 6.33983331580109 278.540405746341 1190.37790002631 3116.40934226889 0.233748243877657 0.934992975510626 3116.40934226889 0.0 2.93499297551063 2.09214499421436 1.90194999474033 0.0137312715966323 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.826466174644009 0.56298637831594 0.0 0.0 0.0 2 6 3 4 
i1 787.2816901408451 8.41424841577481 335.301695822939 863.705815625479 2261.1818253075 0.274268279122607 1.09707311649043 2261.1818253075 0.0 3.09707311649043 2.77670197720569 2.52427452473244 0.017383060878728 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.369201517388004 0.929349363564852 0.0 0.0 0.0 2 6 3 4 
i1 795.5633802816901 6.75066221192774 325.767031261819 911.141187611786 2385.36762916766 0.267524357538657 1.07009743015463 2385.36762916766 0.0 3.07009743015463 2.22771852993615 2.02519866357832 0.016762131784634 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.744321472712687 0.667821492061177 0.0 0.0 2 6 3 4 
i1 798.7183098591549 6.38567348566207 306.765661361455 1013.9705691216 2654.57494996034 0.25401100796421 1.01604403185684 2654.57494996034 0.0 3.01604403185684 2.10727225026848 1.91570204569862 0.015533528248513 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.253664458607493 0.0 0.0 0.96729227353441 0.0 0.0 2 6 3 4 
i1 803.845070422535 3.49280336033048 316.252743576057 961.181745848749 2516.37381063202 0.260770443798132 1.04308177519253 2516.37381063202 0.0 3.04308177519253 1.15262510890906 1.04784100809914 0.0161454582806326 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.847891755759216 0.0 0.0 0.530169379081397 0.0 0.0 2 6 3 4 
i1 805.028169014085 2.97183098591549 344.850230899782 818.74 2143.46132 0.280998014192219 1.12399205676888 2143.46132 0.0 3.12399205676888 0.980704225352111 0.891549295774647 0.018007772931901 0.25 0.05 0.0 0.0 0.0 0.0 0.0 0.768281207615373 0.640112479198042 0.0 0.0 0.0 0.0 2 6 3 4 


        ; HERE BEGINS END

i99    805     146.5   1.25       1       -1      1

i1 805.0 9.69651898734177 395.081430905728 618.0 1617.877032 0.1 0.849505677872391 236.06491250319 0.0 1.34950567787239 3.23217299578059 1.93930379746835 0.02 0.415243646538506 0.1 0.0 0.0 0.0 0.0 0.0 0.767484305656071 0.0 0.0 0.641067734776613 0.0 0.0 2 6 5 4 
i1 812.75721518987342 4.94899162983368 280.977745218576 1173.88755409051 3073.14840115485 0.1 0.582651964827666 448.403985024206 0.0 1.08265196482767 1.64966387661123 0.989798325966736 0.02 0.238494846850876 0.1 0.0 0.0 0.0 0.0 0.0 0.843100534146369 0.0 0.0 0.537755975626592 0.0 0.0 2 6 5 4 
i1 814.5473417721519 8.74736815441072 309.237947911611 999.924 2617.725037776 0.1 0.648092494733902 381.953028430161 0.0 1.1480924947339 2.91578938480357 1.74947363088214 0.02 0.172427285990596 0.1 0.0 0.0 0.0 0.0 0.0 0.953140140100478 0.0 0.0 0.302529128067433 0.0 0.0 2 6 5 4 
i1 817.5308860759494 12.5834411626817 151.658478997159 2617.725037776 6853.0052017947 0.1 0.290142197361565 999.924 0.0 0.790142197361565 4.19448038756056 2.51668823253633 0.02 0.136979319126435 0.1 0.0 0.0 0.0 0.0 0.0 0.886901749280453 0.46195810104735 0.0 0.0 0.0 0.0 2 6 5 4 
i1 822.3045569620253 15.6091801990523 226.175784861801 1617.877032 4235.47911112157 0.1 0.457164599802126 618.0 0.0 0.957164599802126 5.20306006635078 3.12183603981047 0.02 0.114584795172499 0.1 0.0 0.0 0.0 0.0 0.0 0.577942399110452 0.81607755961701 0.0 0.0 0.0 0.0 2 6 5 4 
i1 834.8354430379747 13.6978498133698 253.216350128539 1378.11672651982 3607.80485315766 0.1 0.518836519605723 526.415864830231 0.0 1.01883651960572 4.56594993778993 2.73956996267396 0.02 0.0990334698870002 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.82586708367664 0.563864842049442 0.0 0.0 0.0 2 6 5 4 
i1 842.5926582278481 11.9403141189164 200.086373453748 1899.35006251845 4972.35411306854 0.1 0.398161580787621 725.517647769166 0.0 0.898161580787621 3.98010470630546 2.38806282378328 0.02 0.0875436327263116 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.874634887042333 0.48478223396536 0.0 0.0 2 6 5 4 
i1 844.3827848101266 13.0880459425292 175.176041266161 2229.79286350906 5837.4282524091 0.1 0.342334022188705 851.740869295313 0.0 0.842334022188705 4.36268198084308 2.61760918850585 0.02 0.0786739592745751 0.1 0.0 0.0 0.0 0.0 0.0 0.707106781186548 0.0 0.0 0.707106781186548 0.0 0.0 2 6 5 4 
i1 847.366329113924 12.633670886076 337.791951621765 851.740869295313 2229.79286350906 0.1 0.71466844651859 325.349731044642 0.0 1.21466844651859 4.21122362869199 2.52673417721519 0.02 0.0715993349974727 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.885188571198883 0.465232407962817 0.0 0.0 0.0 2 6 5 4 
i1 852.14 13.612625 366.458025508551 725.517647769166 1899.35006251845 0.1 0.781935526393559 277.134724984058 0.0 1.28193552639356 4.53754166666667 2.722525 0.02 0.415243646538506 0.1 0.0 0.0 0.0 0.0 0.0 0.760948141093145 0.0 0.0 0.648812705306306 0.0 0.0 2 6 5 4 
i1 863.0301 7.68938161675437 395.081430905728 618.0 1617.877032 0.1 0.849505677872391 236.06491250319 0.0 1.34950567787239 2.56312720558479 1.53787632335087 0.02 0.238494846850876 0.1 0.0 0.0 0.0 0.0 0.0 0.823504666134479 0.0 0.0 0.567309496531425 0.0 0.0 2 6 5 4 
i1 865.5432 13.7133515811591 280.977745218576 1173.88755409051 3073.14840115485 0.1 0.582651964827666 448.403985024206 0.0 1.08265196482767 4.57111719371971 2.74267031623183 0.02 0.172427285990596 0.1 0.0 0.0 0.0 0.0 0.0 0.9123505234866 0.0 0.0 0.409409968483582 0.0 0.0 2 6 5 4 
i1 869.7317 20.053469939962 309.237947911611 999.924 2617.725037776 0.1 0.648092494733902 381.953028430161 0.0 1.1480924947339 6.68448997998734 4.0106939879924 0.02 0.136979319126435 0.1 0.0 0.0 0.0 0.0 0.0 0.96835507767838 0.249576528412628 0.0 0.0 0.0 0.0 2 6 5 4 
i1 876.4333 25.6562028291649 151.658478997159 2617.725037776 6853.0052017947 0.1 0.290142197361565 999.924 0.0 0.790142197361565 8.55206760972164 5.13124056583298 0.02 0.114584795172499 0.1 0.0 0.0 0.0 0.0 0.0 0.778756897678438 0.627325827874362 0.0 0.0 0.0 0.0 2 6 5 4 
i1 876.4333 2.65392025862068 200.086373453748 1899.35006251845 4972.35411306854 0.1 0.398161580787621 725.517647769166 0.0 0.898161580787621 0.884640086206894 0.530784051724137 0.02 0.415243646538506 0.1 0.0 0.0 0.0 0.0 0.0 0.767484305656071 0.0 0.0 0.641067734776613 0.0 0.0 2 6 5 4 
i1 878.5564362068965 1.90839884209242 191.640958927981 2003.6637942519 5245.4395349031 0.1 0.379175619550752 765.363621805636 0.0 0.879175619550752 0.636132947364141 0.381679768418485 0.02 0.238494846850876 0.1 0.0 0.0 0.0 0.0 0.0 0.843100534146369 0.0 0.0 0.537755975626592 0.0 0.0 2 6 5 4 
i1 879.36525 3.35029625457599 208.662913934677 1800.46705956263 4713.48592643845 0.1 0.417500753025065 687.746114693411 0.0 0.917500753025065 1.116765418192 0.670059250915198 0.02 0.172427285990596 0.1 0.0 0.0 0.0 0.0 0.0 0.953140140100478 0.0 0.0 0.302529128067433 0.0 0.0 2 6 5 4 
i1 879.6685551724138 5.0682503192848 217.362214773843 1706.73205352772 4468.09480449951 0.1 0.437174718117283 651.941024081571 0.0 0.937174718117283 1.68941677309493 1.01365006385696 0.02 0.136979319126435 0.1 0.0 0.0 0.0 0.0 0.0 0.886901749280453 0.46195810104735 0.0 0.0 0.0 0.0 2 6 5 4 
i1 880.1740637931034 6.87377077295981 167.172190347767 2352.25476201598 6158.02419559593 0.1 0.324511903280457 898.519117444198 0.0 0.824511903280457 2.29125692431994 1.37475415459196 0.02 0.114584795172499 0.1 0.0 0.0 0.0 0.0 0.0 0.577942399110452 0.81607755961701 0.0 0.0 0.0 0.0 2 6 5 4 
i1 881.4883862068965 8.32037983319504 159.330671729858 2481.44235995057 6496.22750873125 0.1 0.307109812090359 947.866462109126 0.0 0.807109812090359 2.77345994439835 1.66407596663901 0.02 0.0990334698870002 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.82586708367664 0.563864842049442 0.0 0.0 0.0 2 6 5 4 
i1 883.6115224137931 9.02854238103847 151.658478997159 2617.725037776 6853.0052017947 0.1 0.290142197361565 999.924 0.0 0.790142197361565 3.00951412701282 1.80570847620769 0.02 0.0875436327263116 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.874634887042333 0.48478223396536 0.0 0.0 2 6 5 4 
i1 884.4203362068966 10.3529347910211 183.334860228201 2113.70651446561 5533.52301317588 0.1 0.360560714127464 807.397966658166 0.0 0.860560714127464 3.4509782636737 2.07058695820422 0.02 0.0786739592745751 0.1 0.0 0.0 0.0 0.0 0.0 0.707106781186548 0.0 0.0 0.707106781186548 0.0 0.0 2 6 5 4 
i1 884.7236413793103 12.0502586206897 175.176041266161 2229.79286350906 5837.4282524091 0.1 0.342334022188705 851.740869295313 0.0 0.842334022188705 4.01675287356322 2.41005172413793 0.02 0.0715993349974727 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.885188571198883 0.465232407962817 0.0 0.0 0.0 2 6 5 4 
i1 894.025 25.5500711349303 151.658478997159 2617.725037776 6853.0052017947 0.1 0.290142197361565 999.924 0.0 0.790142197361565 8.51669037831011 5.11001422698606 0.02 0.0990334698870002 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.652180950197413 0.758063327301618 0.0 0.0 0.0 2 6 5 4 
i1 904.9151 25.8188515226264 226.175784861801 1617.877032 4235.47911112157 0.1 0.457164599802126 618.0 0.0 0.957164599802126 8.60628384087548 5.16377030452529 0.02 0.0875436327263116 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.887331537747867 0.461132022438266 0.0 0.0 2 6 5 4 
i1 911.6167 31.9184211024106 200.086373453748 1899.35006251845 4972.35411306854 0.1 0.398161580787621 725.517647769166 0.0 0.898161580787621 10.6394737008035 6.38368422048212 0.02 0.0715993349974727 0.1 0.0 0.0 0.0 0.0 0.0 0.885188571198883 0.465232407962817 0.0 0.0 0.0 0.0 2 6 5 4 
i1 918.3183 30.6817 175.176041266161 2229.79286350906 5837.4282524091 0.1 0.342334022188705 851.740869295313 0.0 0.842334022188705 10.2272333333333 6.13634 0.02 0.0658116828611607 0.1 0.0 0.0 0.0 0.0 0.0 0.0 0.532808724475686 0.84623570187188 0.0 0.0 0.0 2 6 5 4 

e

</CsScore>

</CsoundSynthesizer>


