/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * Copyright (c) Andrew St. Jean <andrew@arda.homeunix.net> 2003
 *
 * */

#if HAVE_CONFIG_H
#include        <config.h>
#endif

#include        "courierpassd.h"


void *
xmalloc(size_t num){
	void *new = malloc(num);
	if (!new){
		end_logging();
		exit(1);
	}

	return(new);
}

void *
xcalloc(size_t num, size_t size){
	void *new = xmalloc(num * size);
	memset(new, 0x00, num * size);
	return(new);
}

void *
xrealloc(void *p, size_t num){
	void *new;
	if (!p)
		return(xmalloc(num));
	
	new = realloc(p, num);
	if (!new){
		end_logging();
		exit(1);
	}

	return(new);
}
				
