/****************************************************************************
 *    lib/c/Type.cpp - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "Type.h"

using namespace C;

Type::Type(string* name, Arguments* args, bool sign) : Identifier(name, args) {
	sign_ = sign;
}

Type::~Type() { }

void Type::setMin(int number) {
	args_->setMin(number);
}

void Type::setMax(int number) {
	args_->setMax(number);
}

int Type::getMin() {
	return args_->getMin();
}

int Type::getMax() {
	return args_->getMax();
}

bool Type::isTrue() {
	return sign_;
}

string Type::print(Printer* p) {
	return getName() + "(" + args_->print(p) + ")";
}
