//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Tool/mainwindow_constants.h
//! @brief     Defines namespace GUI::Constants
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_TOOL_MAINWINDOW_CONSTANTS_H
#define BORNAGAIN_GUI_VIEW_TOOL_MAINWINDOW_CONSTANTS_H

#include <QString>

namespace GUI::Constants {

// Settings groups
const char S_MAIN_WINDOW[] = "MainWindow";
const char S_JOB_MESSAGE_PANEL[] = "JobMessagePanel";
const char S_JOB_SELECTOR_PANEL[] = "JobSelectorPanel";
const char S_FIT_ACTIVITY_PANEL[] = "FitActivityPanel";
const char S_FIT_SESSION_WIDGET[] = "FitSessionWidget";
const char S_JOB_PROPERTIES_WIDGET[] = "JobPropertiesWidget";

// Settings keys
const char S_WINDOW_SIZE[] = "size";
const char S_WINDOW_POSITION[] = "pos";

const char S_JOB_MESSAGE_PANEL_HEIHGT[] = "height";
const char S_JOB_SELECTOR_PANEL_WIDTH[] = "width";
const char S_JOB_SELECTOR_SPLITTER_SIZES[] = "splitter_sizes";
const char S_FIT_ACTIVITY_PANEL_SIZE[] = "size";
const char S_FIT_SESSION_WIDGET_CURRENT_TAB[] = "current_tab";
const char S_JOB_PROPERTIES_WIDGET_CURRENT_TAB[] = "current_tab";

const int MAX_RECENT_PROJECTS = 10;

// Hints

const unsigned int FIT_ACTIVITY_PANEL_WIDTH = 480;
const unsigned int FIT_ACTIVITY_PANEL_HEIGHT = 380;
const unsigned int JOB_MESSAGE_PANEL_HEIGHT = 400;
const unsigned int JOB_SELECTOR_PANEL_WIDTH = 231;
const unsigned int RUN_FIT_CONTROL_WIDGET_HEIGHT = 50;
const unsigned int ITEM_SELECTOR_WIDGET_WIDTH = 96;

// Widget names

const QString JobRealTimeWidgetName = "Job Real Time";
const QString JobPropertiesWidgetName = "Job Properties";
const QString JobFitPanelName = "Fit Panel";
const QString JobSelectorWidgetName = "Job Selector";

const QString JobViewActivityName = "Job View Activity";
const QString JobRealTimeActivityName = "Real Time Activity";
const QString JobFittingActivityName = "Fitting Activity";

const int toolbar_icon_size = 32;

} // namespace GUI::Constants

#endif // BORNAGAIN_GUI_VIEW_TOOL_MAINWINDOW_CONSTANTS_H
