//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/PlotComparison/FitFlowWidget.cpp
//! @brief     Implement class FitFlowWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/PlotComparison/FitFlowWidget.h"
#include "Base/Util/Assert.h"
#include "GUI/Model/Job/FitSuiteItem.h"
#include "GUI/View/PlotComparison/HistogramPlot.h"
#include <QVBoxLayout>

FitFlowWidget::FitFlowWidget(QWidget* parent)
    : DataAccessWidget(parent)
    , m_histPlot(new HistogramPlot)
{
    setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum);

    auto* layout = new QVBoxLayout;
    layout->setContentsMargins(0, 0, 0, 0);
    layout->addWidget(m_histPlot);

    setStyleSheet("background-color:white;");
    setLayout(layout);
}

void FitFlowWidget::setJobOrRealItem(QObject* job_item)
{
    DataAccessWidget::setJobOrRealItem(job_item);
    ASSERT(jobItem());

    connect(jobItem()->fitSuiteItem(), &FitSuiteItem::iterationCountChanged, this,
            &FitFlowWidget::onIterationCountChanged, Qt::UniqueConnection);
}

void FitFlowWidget::onIterationCountChanged(int iter)
{
    double chi = jobItem()->fitSuiteItem()->chi2();
    if (iter == 1)
        m_histPlot->clearData();
    m_histPlot->addData(static_cast<double>(iter), chi);
}
