//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/OffspecDetectorEditor.h
//! @brief     Defines class DetectorEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_INSTRUMENT_OFFSPECDETECTOREDITOR_H
#define BORNAGAIN_GUI_VIEW_INSTRUMENT_OFFSPECDETECTOREDITOR_H

#include <QGroupBox>

class OffspecInstrumentItem;
class QFormLayout;

//! Contains stack of detector editors and the logic to show proper editor for certain type
//! of detector item (SphericalDetectorForm or RectangularDetectorForm).

class OffspecDetectorEditor : public QGroupBox {
    Q_OBJECT

public:
    OffspecDetectorEditor(QWidget* parent, OffspecInstrumentItem* item);

signals:
    void dataChanged();

private:
    OffspecInstrumentItem* m_instrument;
    QFormLayout* m_formLayout;
};

#endif // BORNAGAIN_GUI_VIEW_INSTRUMENT_OFFSPECDETECTOREDITOR_H
