//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Fit/MinimizerSettingsWidget.h
//! @brief     Defines class MinimizerSettingsWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_FIT_MINIMIZERSETTINGSWIDGET_H
#define BORNAGAIN_GUI_VIEW_FIT_MINIMIZERSETTINGSWIDGET_H

#include "GUI/Model/Job/MinimizerItem.h"
#include <QWidget>

class JobItem;
class QFormLayout;

//! The MinimizerSettingsWidget contains editor for all minimizer settings and related fit
//! options. Part of FitSuiteWidget.

class MinimizerSettingsWidget : public QWidget {
    Q_OBJECT

public:
    MinimizerSettingsWidget(QWidget* parent = nullptr);

public slots:
    void setJobItem(JobItem* jobItem);
    void setMinContainerItem(MinimizerContainerItem* containerItem);

private:
    void createGroupedAlgorithmsCombo();
    void createMimimizerEdits();
    void createMinuitEdits();
    void createGSLMultiMinEdits();
    void createTMVAGeneticEdits();
    void createGSLSimulatedAnnealingEdits();
    void createGSLLevMarEdits();

    void updateUIValues();

private:
    MinimizerContainerItem* m_containerItem;
    QFormLayout* m_mainLayout;
    QFormLayout* m_minimizerLayout;
    QList<std::function<void()>> m_updaters;
};

#endif // BORNAGAIN_GUI_VIEW_FIT_MINIMIZERSETTINGSWIDGET_H
