package test.beast;


import java.util.ArrayList;
import java.util.List;

import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.Sequence;
import beast.evolution.tree.Tree;
import beast.util.TreeParser;
import junit.framework.TestCase;


public class BEASTTestCase extends TestCase {
    public static final double PRECISION = 1e-6;

    public Alignment getFourTaxaNoData() throws Exception {
        Sequence a = new Sequence("A", "A");
        Sequence b = new Sequence("B", "A");
        Sequence c = new Sequence("C", "A");
        Sequence d = new Sequence("D", "A");

        Alignment data = new Alignment();
        data.initByName("sequence", a, "sequence", b, "sequence", c, "sequence", d, "dataType", "nucleotide");
        return data;
    }

    static public Tree getTree(Alignment data, String tree) throws Exception {
        TreeParser t = new TreeParser();
        t.initByName("taxa", data,
                "newick", tree,
                "IsLabelledNewick", true);
        return t;
    }

    static public Alignment getAlignment() throws Exception {
        Sequence human = new Sequence("human", "AGAAATATGTCTGATAAAAGAGTTACTTTGATAGAGTAAATAATAGGAGCTTAAACCCCCTTATTTCTACTAGGACTATGAGAATCGAACCCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTATCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTATACCCTTCCCGTACTAAGAAATTTAGGTTAAATACAGACCAAGAGCCTTCAAAGCCCTCAGTAAGTTG-CAATACTTAATTTCTGTAAGGACTGCAAAACCCCACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGACCAATGGGACTTAAACCCACAAACACTTAGTTAACAGCTAAGCACCCTAATCAAC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTCGAATTTGCAATTCAATATGAAAA-TCACCTCGGAGCTTGGTAAAAAGAGGCCTAACCCCTGTCTTTAGATTTACAGTCCAATGCTTCA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCCAAAGCTGGTTTCAAGCCAACCCCATGGCCTCCATGACTTTTTCAAAAGGTATTAGAAAAACCATTTCATAACTTTGTCAAAGTTAAATTATAGGCT-AAATCCTATATATCTTA-CACTGTAAAGCTAACTTAGCATTAACCTTTTAAGTTAAAGATTAAGAGAACCAACACCTCTTTACAGTGA");
        Sequence chimp = new Sequence("chimp", "AGAAATATGTCTGATAAAAGAATTACTTTGATAGAGTAAATAATAGGAGTTCAAATCCCCTTATTTCTACTAGGACTATAAGAATCGAACTCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTATCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTACACCCTTCCCGTACTAAGAAATTTAGGTTAAGCACAGACCAAGAGCCTTCAAAGCCCTCAGCAAGTTA-CAATACTTAATTTCTGTAAGGACTGCAAAACCCCACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGATTAATGGGACTTAAACCCACAAACATTTAGTTAACAGCTAAACACCCTAATCAAC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTCGAATTTGCAATTCAATATGAAAA-TCACCTCAGAGCTTGGTAAAAAGAGGCTTAACCCCTGTCTTTAGATTTACAGTCCAATGCTTCA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCTAAAGCTGGTTTCAAGCCAACCCCATGACCTCCATGACTTTTTCAAAAGATATTAGAAAAACTATTTCATAACTTTGTCAAAGTTAAATTACAGGTT-AACCCCCGTATATCTTA-CACTGTAAAGCTAACCTAGCATTAACCTTTTAAGTTAAAGATTAAGAGGACCGACACCTCTTTACAGTGA");
        Sequence bonobo = new Sequence("bonobo", "AGAAATATGTCTGATAAAAGAATTACTTTGATAGAGTAAATAATAGGAGTTTAAATCCCCTTATTTCTACTAGGACTATGAGAGTCGAACCCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTATCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTATACCCTTCCCGTACTAAGAAATTTAGGTTAAACACAGACCAAGAGCCTTCAAAGCTCTCAGTAAGTTA-CAATACTTAATTTCTGTAAGGACTGCAAAACCCCACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGATTAATGGGACTTAAACCCACAAACATTTAGTTAACAGCTAAACACCCTAATCAGC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTTGAATTTGCAATTCAATATGAAAA-TCACCTCAGAGCTTGGTAAAAAGAGGCTTAACCCCTGTCTTTAGATTTACAGTCCAATGCTTCA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCTAAAGCTGGTTTCAAGCCAACCCCATGACCCCCATGACTTTTTCAAAAGATATTAGAAAAACTATTTCATAACTTTGTCAAAGTTAAATTACAGGTT-AAACCCCGTATATCTTA-CACTGTAAAGCTAACCTAGCATTAACCTTTTAAGTTAAAGATTAAGAGGACCAACACCTCTTTACAGTGA");
        Sequence gorilla = new Sequence("gorilla", "AGAAATATGTCTGATAAAAGAGTTACTTTGATAGAGTAAATAATAGAGGTTTAAACCCCCTTATTTCTACTAGGACTATGAGAATTGAACCCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTGTCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTCACATCCTTCCCGTACTAAGAAATTTAGGTTAAACATAGACCAAGAGCCTTCAAAGCCCTTAGTAAGTTA-CAACACTTAATTTCTGTAAGGACTGCAAAACCCTACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGATCAATGGGACTCAAACCCACAAACATTTAGTTAACAGCTAAACACCCTAGTCAAC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTCGAATTTGCAATTCAATATGAAAT-TCACCTCGGAGCTTGGTAAAAAGAGGCCCAGCCTCTGTCTTTAGATTTACAGTCCAATGCCTTA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCCAAAGCTGGTTTCAAGCCAACCCCATGACCTTCATGACTTTTTCAAAAGATATTAGAAAAACTATTTCATAACTTTGTCAAGGTTAAATTACGGGTT-AAACCCCGTATATCTTA-CACTGTAAAGCTAACCTAGCGTTAACCTTTTAAGTTAAAGATTAAGAGTATCGGCACCTCTTTGCAGTGA");
        Sequence orangutan = new Sequence("orangutan", "AGAAATATGTCTGACAAAAGAGTTACTTTGATAGAGTAAAAAATAGAGGTCTAAATCCCCTTATTTCTACTAGGACTATGGGAATTGAACCCACCCCTGAGAATCCAAAATTCTCCGTGCCACCCATCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTACACCCTTCCCGTACTAAGAAATTTAGGTTA--CACAGACCAAGAGCCTTCAAAGCCCTCAGCAAGTCA-CAGCACTTAATTTCTGTAAGGACTGCAAAACCCCACTTTGCATCAACTGAGCGCAAATCAGCCACTTTAATTAAGCTAAGCCCTCCTAGACCGATGGGACTTAAACCCACAAACATTTAGTTAACAGCTAAACACCCTAGTCAAT-TGGCTTCAGTCCAAAGCCCCGGCAGGCCTTAAAGCTGCTCCTTCGAATTTGCAATTCAACATGACAA-TCACCTCAGGGCTTGGTAAAAAGAGGTCTGACCCCTGTTCTTAGATTTACAGCCTAATGCCTTAACTCGGCCATTTTACCGCAAAAAAGGAAGGAATCGAACCTCCTAAAGCTGGTTTCAAGCCAACCCCATAACCCCCATGACTTTTTCAAAAGGTACTAGAAAAACCATTTCGTAACTTTGTCAAAGTTAAATTACAGGTC-AGACCCTGTGTATCTTA-CATTGCAAAGCTAACCTAGCATTAACCTTTTAAGTTAAAGACTAAGAGAACCAGCCTCTCTTTGCAATGA");
        Sequence siamang = new Sequence("siamang", "AGAAATACGTCTGACGAAAGAGTTACTTTGATAGAGTAAATAACAGGGGTTTAAATCCCCTTATTTCTACTAGAACCATAGGAGTCGAACCCATCCTTGAGAATCCAAAACTCTCCGTGCCACCCGTCGCACCCTGTTCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTATACCCTTCCCATACTAAGAAATTTAGGTTAAACACAGACCAAGAGCCTTCAAAGCCCTCAGTAAGTTAACAAAACTTAATTTCTGCAAGGGCTGCAAAACCCTACTTTGCATCAACCGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGATCGATGGGACTTAAACCCATAAAAATTTAGTTAACAGCTAAACACCCTAAACAACCTGGCTTCAATCTAAAGCCCCGGCAGA-GTTGAAGCTGCTTCTTTGAACTTGCAATTCAACGTGAAAAATCACTTCGGAGCTTGGCAAAAAGAGGTTTCACCTCTGTCCTTAGATTTACAGTCTAATGCTTTA-CTCAGCCACTTTACCACAAAAAAGGAAGGAATCGAACCCTCTAAAACCGGTTTCAAGCCAGCCCCATAACCTTTATGACTTTTTCAAAAGATATTAGAAAAACTATTTCATAACTTTGTCAAAGTTAAATCACAGGTCCAAACCCCGTATATCTTATCACTGTAGAGCTAGACCAGCATTAACCTTTTAAGTTAAAGACTAAGAGAACTACCGCCTCTTTACAGTGA");

        Alignment data = new Alignment();
        data.initByName("sequence", human, "sequence", chimp, "sequence", bonobo, "sequence", gorilla, "sequence", orangutan, "sequence", siamang,
                "dataType", "nucleotide"
        );
        return data;
    }

    static public Sequence German_ST;
    static public Sequence Dutch_List;
    static public Sequence English_ST;
    static public Sequence French;
    static public Sequence Italian;
    static public Sequence Spanish;

    static {
        try {
            German_ST = new Sequence("German_ST", "              1000000010000000000000000000000001000000000000000000000000100000000000000000100000000000000000000000000000000000000001000000000000000000000000000000010000000000000000000001000000000000000000000000000000000000000000000000000000000001010000000000000000000000000000000000000100000000000000000000000000000000000000000000000001000000000000000000000000000000001000000000000000000000001000000000000000000100000000000000000000000000000010000000000000000000000010000000000000000000010000000000000000000000010000000???????????????????100000000000000000000000100000000000000000000001000000000000000000000000000000000000000000000100000000000000000000000000000010000000000000000000000010000000000000000000000000000010000000000000000000000001000000000000000000000000000000000010000000000000100000000000000000000010000000000000000000000000000000010000000000000000000000000000000000000000000001000000000000000001000000000000100000000000000001000000000000000000000000000000000100000000000000000000000000000100001000000000000000000000000000000100000000000000001000000000000000100000000001000000000000000000000000000000001000000000000000001000000000000000000000000000000000001000000000000000000001000000000000000001000000000000100000000000000000000000000000000000100000000000000000000000000000000000000000010000100000000000000000000000100000000010000000010000000000000000000000010000000000000000000000100000000000010000000000000000000000000000010000000000000000000000100000000000000000101000000000000000000000000000000000000000000000010000010000000000010000000000000000000000000000000000100000000000000000000001000000000000000000001000000000010000000000000000000000000010000000000000000000000000000000001000000000000001000000000000000001000000000000000000001000000000000000000000100000000000000001000000000000000000000000100000000000000000000000000000000000000000000000000001100000000000000000000000000000010000000000000000000000000000000001000000000100000000010000000000000000000000010000000000000000001000000000000000000000000010000000000000000000000000000000000000001000000000000000000000001000000000000000000000000000000000010000000000000001000000000000010000000000000000100000000000000000000100000000000000010000000000000000010000000000000000000000000000100000000000000000000000000100000000000000000000000000000000000000100000000000001000000000000000000000010000000000000010000000000000000100000000000000000100000000000000000000000000000000000000000100000000000000???????????1000000000010000000000000000000000001000000000000000000010000100000000000000000000100000000000000000000000000000000000000000000000000100000000010000000000000000000000010000001000001000000000000001000001000000000000000001000001000000000000000100000000000000000000000000000000000000010000000000000000000000000000000000000100000000000000000000000000000000000000000010000000000000000000000000000000001000000000000000000000000001000000000000000000001000000000000000000000000000000010000000000000000000000000000000000010000000100000000000001000000000000000000000000000000100000000000000000000000000000000000001000000000000000000000000001000000000000000000000000000000000000010000000000000000000000000000010000000010000000000000000000000010000000000000000000000000000000000000000100000000000000000000000000000010000001000000000010000000000000000000000010000000000000000100000000000000100000000000000000000000010000000000000000000000001000000000000000000000100000000000000001000000000000000000010000000000000000000000010000000000000000000100000000000000000000000000000000000010000000000000000000000000000000000100000000000000100000000000000000000000000000000000000000100000000000000000000001000000000000000000000000000000000000010000000000000000000100000000000000000000000000000000000010000000000000000000000000000000000000010000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000001000000000000000000000000010000000001000000000000000000000000000000000000000000000000001000000000000000000000000000000000000100000000000000000100000000000000000000000001000000001000000000000000000000000000001000000000000000000000000000000000000001000000000000000000000000010000100000000000000000001000000000000000000000000000001000000000000000000000001000000000000000000000000000001000000000000000000000000000100000000000000000000000000000000010000000000000000001000001010000000000000000000000000000000000000000000000000100000000000000000000000000001000000010000000001000000000000000000000000000000000000000000000010000000000000000101000000000000000000000000000000000001000000000000000000000000000000000000000010000000000000000000010000000000000000000000000000010000000000010001000000000000000000000000000000100001000000001000000000000000010000000000000000000000001000000000000000100000000000000000000000000010100000000000000000001000000000000000010000000000000000000000000000000000000000100000000000000000000000010000000000000000000000000001000001000000000000000000000000000000100000000000000001000000000000000000000000010000000000000000000010000000000000000000001000000000000");
            Dutch_List = new Sequence("Dutch_List", "          1000000010000000000000000000000001000000000000000000000000100000000000000000100000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000001000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000100000000000000000010000000000000000000000000000000000000001000000000000000000000000000000001000000000000000000000001000000000000000000100000000000000000000000000000010000000000000000000000010000000000000000100010000000000000000001000000000000???????????????????1000000000000000000000001000000000000000000000010000000000000000000000000000000000000000000001000000000000000000000000000000100000000000000000000000100000000000000000000000000000000000000000001000000000010000000000000000000000000000000000100000000000001000000000000000000000001000000000000000000010000000000000000000000000000000000000000000000000000000010000000000000000010000000000001000000000000000010000000000000000000000000000000001000000000000000000000000000001000010000000000000000000000000000001000000000000000010000000000000001000000000010000000000000000000000000001000000000000000000000010000000000000000000000000000000000010000000000000100000000000000000000000010000000000001000000000000000000000000000001000000000000000000000000000000000000000000000000100001000000000000000000000001000000000110000000000000000000000000000000100000100000000000000001000000000000100000000000000000000010000000100000000000000000000001000000000000000001010000000000000000000000000000000000000000000000??????10000000000010000000000000000000000000000000000100000000000000000000001000000000000000000001000000000000000000000000000000000000010000000000000000000000000000000001000000000100000000000000000000001000000000000000000001000000000000000000000100000000000000001000000000000000000000000100000000000000000000000000000000010000000000000100000000000000000000000000000000000010000000000000000000000000000000001000000000100000000010000000000000000000000000000000000000000001000000000000000000000000010000000000000000000000100000000000000000000000000000000000000011000001011000000000000000000000000110000000000000001000000000000010000000000010000000000000000000000000100000000000000010000000000000000010000000000000000000000000000100000000000001000000000000100000000000000000000000000000000000000100000000000001000000000000000000000010000000000000010000000000000000100000000000000000100000000000000000000000000000000000000000100000000000000???????????100000000001000000000000000000000000100000000000000000001000010000000010000000000010000000000000000000000000000000000000000000000000010000000001000000000000000000000001000000100000100000000000000100000100000000000000000100000100000000000100010000000000000000000000000000000000000001000000000000000000000000000001000000000000000000000000000000000000000000001000001000000000000000000000000000000000100000000000000000000000000100000000000000000000100000000000000000000000000000001000000000000000000000000000000000000000000010000000000000000000000000000000000000000000010000000000000000010000000000000000000000000000000000000100000000000000000000000000000000000000000000001000000000000000000000000000001000000001000000000000000000000001000000000000000000000000000000000000000100000000000000000000000000000000000000100000000001000000000000000000000001000000000000000010000000000000010000000000000000000000001000000000000000000000000100000000000000000000010000000000000000000100000000000000001000000000000000000000001000000000000000000010000000000000000000000000000000000001000000000000000000000000000000000010000000000000010000000000000000000000000000000000000000010000000000000000000000100000000000000000000000000110000000000000000000000000000010000000000000000000000010000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000100000000000000000000000001000000000100000000000000000000000000000000000000000000000000100000000000000000000000000001000000000000000000000000010000000000000000000000000100000000100000000000000000000000000000100000000000000000000000000100000000000000000000000000000000000001000000000000000000000000100000000000000000000000000000100000000000000000000000100000000000000000000000000000100000000000000000000000000010000000000000000000000000000000001000000000000000000010000101000000000010000000000000000000000000000000000000010000000000001000000000000000100000001000000000100000000000000000000000000000000000000000000001000000000000000010100000000000000000000000000000000000000000000000000000001000000000000000000001000000000000000000001000000000000000000000000000001000000000001000100000000000000000000000000000010000100000000100000000000000001000000000000000000000000100100000000000000000000000000000000000000001100000000000000000000100000000000000001000000000000000000000010000000000000000000000000000000000000000001000000000000000000000000000100000000000000000000000010000000000000000000000000000100000000000000000000000001000000000000000000001000000000000000000000?????????????");
            English_ST = new Sequence("English_ST", "             1000000010000000000000000000000001000000000000000000000000000000000000000000100000000000000000000000000000000000000100000000000000000000001000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000100000100000000000000000000000000000000000001000000000000000010000000000000000100000000000000000000001000000000000???????????????????0000000000000100000000001000000000000000000000000000000000000000001000000000000000000000000000000000000000000000010000000000100000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000100000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000010000000000001000000000000000100000000000000000000000000000000000000000000010000000000000000001000010000000000000000000000000000001000000000000000010000000000000001000000000010000000000000000000000000001000000000000000000000010000000000000000000000000000000000010000000000000100000000000000000000000010000000000000000100000000000000000000000001000000000000000000000000000000000000000000000000100001000000000000000000000001000000000100010000000000000000000000000000100000000000000000000000000000000000100000000000000000000000000000000000000000100000000001000000000000000001010000000000000000000000000000000000000000000000??????1000000000001000000000000000000000000000000000010000000000000000000000100000000000000000000000000000000010000000000000000000000001000000000000000000000000000000000100000000010000000000000000000000100000000000000000000100000000000000000000010000000000000000000000010000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000?????????0100000000000000010000000000000000000000000000000000000000100000000000000000000010000000000000000000000000000000000001000000000000000000000000001000000000000000000000000100000000000000000000000001000000000100000000000000000000000000000000000000000100000000000000000000001000000000000000000000000000000000010000000000000000000000000000000100000000000000000000000000000000000000100000000000001000000000000000000000010000000000000010000000000000000100000000000000000000000100000000000000000000000000000000000000001000000000???????????1000000000000000000000000000000000001000000000000000000010000000000000010000000000100000000000000000000000000000000000000000000000000000000000010000000000000000000000010000001000001000000000000001000001000000000000000001000001000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000001000000000000000000000000001000000000000000000001000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000010000000010000000000000000000000010000000000000000000000000000000000000000100000000000000000000000000000000000001000000000010000000000000000000000010000000000000000000010000000000100000000000000000000000000100000000000000000000001000000000000000000000100000000000000000000000000000000000000000000000000000000000010000000000000000000000000100000000000000000000000000000000000000000000000000001000000000000001000000000000000000000000001000000000000000000000000000000000001000000000000001000000000000000000000000001000000000000000000000000000000100000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000010000000000000000000000000000000001000000000000000000000000010000000001000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000010000000100000000000000000000000001000000001000000000000000000000000000001000000000000000000000000000000000000100000000000000000000000000010000000000000000000000001000000000000000000000000000000000000000000000000000001000000000000000000000000000001000000000000000000000000000100000000000000000000000000000000010000000000000000001000001000000000000000001000000000000000000000000000000000000000100000000000000000000001000000010000000000100000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000100000000000000000000000000000000000000010000000000000000000010000000000000000000000000000010000000000010000000000100000000000000000000000100001000000001000000000000000010000000000000000000000001001000000000000000000000000000100000000000000000000000000000000001000000000000000000000000000000000000000000000000000000001000000000000000000000000000001000000000000000000000000000001000000000000000000000000000001000000000000000001000000000000000000000000010000000000000000000010000000000000000000001000000000000");
            French = new Sequence("French", "              10000000001000000000000000000000000001000000000000000000000000100000000000000000100000000000000000000000000000000001000000000000000000000000100000000000000000000000000000000100000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000010000000000000000000000000000000010000000000000000000000001000000000000000000100000000000000000000000000000010000000000000000000000001000000000001000000000000000000000000100000000001000000100001000000000000000001000000000000000000000000000100000000000000000010000000000000000000000000000000000000010000000000000000000000000000010000000000000000000010000000000000000000000000000000010000000000000000000000000001000000000000000000000000000001000000001000000000000000000000000000000000001000000000000000000000100000000000000000000000000000000000000000000001000000000000000000100000000000000010000000000000100000000000000000000000000000000000100000000000000000000000000100000000100000000000000000000000000000010000000000001000000000000000100000000000000000000000000000000000000000000000010000000000000000000100000000000000000000000000001000000000000000100000100000000000000000010000000000000010000000000000000000000000000000000000000000000100000000000000000000000000010000000010000000000000000000100000000010001000000000000000000000000000000010000000000000000000100000000000000010000000000000000000000100000000000000000000000000100000000000000000100000010000000000000000000010000000000000000000010000001000000000000001000000000000000000000000000000000010000000000000000000000010000000000000000000010000000000000000000000000000000000000100000000000000000000000000000001000000001000000000000000000000000000000100000000000000000010000000000000100000000000000000000000000000100000000000100010000000010000000000000000000000000000000000000000000000001000000000000000000000000000100000000000000000000000000001000000000100000000000010000000000000000000000010000000000000000000000000000000000000000000001000000000000000000000001000000000000000000000000000000000001000000100000000000000000010000000000000000000000001000000000001000000000000000010000000000000000000000000010000000000010000000000000000000000000001000000000000000000000000100000000000000000000000000000010000000000000000000000000001000000000000000001000000000000000000010000000000000000001000000000000010000000000000000000000010000000000000000000000000000000000000000000010000001000000001000000000000001000000000000000000000000010000000000000010000000000010000000000000000000010000000000000000000000000000000000000000000100000000000000000000000000000000010000001000001000000000000001000000000100000000000001000000010000000000000000100000000000000000000000000000000000000001000000000000000000000000000000001000000000000000000000000000000000000001000000000000000000000000000000000000000010000000000000000000000001000000000000000000000000000000001000000000000000000010000000000000000000000001000000000000000000000000100000000000000000000000000000000000000100000000000000000000010000000000000000000000000000000000000000001000000000000000000001000000000000000000001000000000000000000000000010000000010000000000000000000000000001000000000000000000000000000000000000000010000000000000000000000000010000000000000000000100000000000000000000010000000000000000000010000000000000000010000000000000000000100000000000000000000000010000000000000000000100000000000000001000000000000000000000010000000000000000000000100000000000000000000000010000000000000000000000000000000000000000100000000000000000000001000000000000000001000000000000000000000000000000000000000000100000000000000000001000000000000000000010000000000000000000000000000000000000001000000000000000000000000100000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000001000000000000000000000010000000000000000100000000000000000000000000000000000000000000000100000000000000000000000010000000000000000000000000100000000000000000000000001000000000000000000000000000010000000000010000000000000000000000000000100000000000000000000000000000000000110000000000000000000000100000000000000000000000001000000000000000000000000000000000000000000100000000000000000100000000000000000000000001000000000000000000000000000000010010100000000000001000001000000001000000000000000000000000000000000000000000010000000000000000000000000001000000010000000000001000000000000000000000000000000100000000000000000000000000000100001000000000000000000000000000000000010000000000000000000000000000000000000000010000000000000000000000100000000000000000000000000010000000010000000100000000000000000000000000100001000000001000000000000000000000100000000000000000001000000100000000000000000000000000000000000000011000000000000000001000000000000000000001000000000000000000000000000000000000010000000000000000000000000010000000000000000000000000000010000000000000000000100000000000000000000000000001000000000000000000000000000001000000000000000000000100000000000000001000000000000");
            Italian = new Sequence("Italian", "             10000000001000000000000000000000000001000000000000000000000000100000000000000000100000000000000000000000000000000001000000000000000000000000100000000000000000000000000000000000000000000000001000000000000000000000000000000000001000000000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000010000000000000000000000000000000010000000000000000000000001000000000000000000100000000000000000000000000000010000000000000000000000001000000000001000000000000000000000000100000000001100000000001000000000000000001000000000000000000010000000100000000000000000010000000000000000000000000000000000000010000000000000000000000000000010000000000000000000010000000000000000000000000000000010000000000000000000000000000000000000010000000000000000001000000001000000000000000000001000000000000000000000000000001000000000000000000000000000000000000000000000000000001000000000000000000100000000000000000010000000000000000000000010000000000000000000000100000000000000000000000000100000000100000000000000000000000000000010000000000001000000000000000100000000000001000000000000000000000000000000000010000000000000000000100000000000000000000000000001000000000000000001000000000000000000000010000000000000010000000000000000000000000000000000000000000000100000000000000000000000000010000000010000000000000000000100000000010000010000000000000000000000000000010100010000000000000100000000000000010000000000000000000000000010000000000000000000000100000000000000000100000010000000000000000000010000000000000000000010000001000000000000001000000000000000000000000000000000010000000000000000000000010000000000000000000000100000000000000000000000000000000000100000000010000000000000000000001000000001000000000000000000000000000000100000000000000010100000000000000100000000000000000000100000010000000000000100010000000010000000000000000000000000100000000000000001000000000000000000000000000000000100000000000000000000000000001000000000100000000000010000000000000000000000010000000000010000000000000000000000000000000001000000000000000000000001000000000000000000000000000000000001000000000000000000000000000001100000000000000000001010000000001000000000000000010000000000000000000000000010000000000010000000000000000000000010000000000000000000000000000100000000000000000000000100000000000000000000000000000000001000000000000000001000000000000000000010000000000000000001000000000000010000000000000000000001000000000000000000000000000000000000001000000000000???????????1000000000000001000000000000000000000000010000000000000010000000000010000000000000000000000000000000001000000000000000000000000000000100000000000000000000000000000000010000001000001000000000000001000000000100000000000001000000010000000000000000100000000000000000000000000000000000000001000000000000000000000000000000001000000000000000000000000000000000000000100000000000000000000000000000000000000010000000000000000000000001000000000000000000000000000000001000000000000000000000100000000000000000000000000000000100000000000000000000001000000000000000000000000000000100000000000000000000010000000000000000000000000000000000000000000000010000000000000001000000000000000000001000000000000000000000000010000000010001000000000000000000000001000000000000000000000000000000000000000010000000000000000000000000010000000000000000000100000000000000000000010000000000000000000010000000000000001000000000000000000000100000000000000000000000010000000000000000000100000000000000001000000000000000000000010000000000000000000000100000000000000000000000000001000000000000000000000000000100000000100000000000000000000001000000000000000001000000000000010000000000000000000000000000100000000000000000001000000000000000000010000000100000000000000000000000000000100000000000000000000000000100000000000001000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000001000001000000000000000000000000010000000000000000100000000000000000000000000000000000000000000000100000000000000000000000010000000000000000000000000100000000000000000000000001000000000000000000000000000010000000000010000000000000000000000000000100000000000000000000000000000000000110000000000000000000000100000000000000000000000000001000000010000000000000000001000000000000000000000000000000001000000000000000000000001000000000000000000000000000000010010100000000000001000001000000001000000000000000000000000000000000000000000010000000000000000000000000001000000010000000000001000000000000000000000000000000000000000010000000000000000000100001000000000000000000000000000000000000000000000100000000000000000000000000000010000000000000000000000100000000000000000000000000010000000010000000000000000000010000000000000100001000000001000000000000000000000100000000000000000001000000100000000000000000000010000000000000000010000000000000000001000000000000000000001000000000000000000000000000000000000000000000001000000000000000100000000000000000000000000000000010000000000000000100000000000000000000000000001000000000000000000000000000001000000000000000000000100000000000000001000000000000");
            Spanish = new Sequence("Spanish", "             10000000001000000000000000000000000001000000000000000000000000100000000000000000100000000000000000000000000000000001000000000000000000000000100000000010000000000000000000000100000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000010000000000000000000000000000000010000000000000000000000001000000000000000000100000000000000000000000000000010000000000000000000000001000000000001000000000000000000000000100000000000000000000001000000000000000001000000000000000000010010000000000000000000001000000000000000000000000000000000000000010000000000000000000000000000010000000000000000000010000000000000000000000000000000010000000000000000000000001000000000000000000000000000000001000000001000000000000000000001000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000001000100000000000000010100000000100000000000000000000000000000000000000100000000000000000000000000100000000100000000000000000000000000001000000000000001000000000000000100000000000001000000000000000000000000000000000001000000000000000000100000000000000000000000000001000000000000000001000000000000000000000010000000000000010000000000000000000000000000000000000000000000100000000000000000000000000010000000010000000000000000000100000000010001000000000000000000000000000000000000010000000000000100000000000000010000000000000000000000000010000000000000000000000100000000000000000100000010000000000000000000010000000000000000000010000001000000000000001000000000000000000000000000000000010000000000000000000000010000000000000000000000100000000000000000000000000000000000100000000010000000000000000000001000000001000000000000000000001000000000000000000000000010000000000000000100000000000000000000100000010000000000000100010000000010000000000000000000000000100000000000000000000000000000000000000000000000000100000000000000000000000000001001000000100000000000010000000000000000000000010000000000010000000000000000000000000000000001000000000000000000000001000000000000000000000000000000000001000000000000000000000100000000000000000000000000000010000000001000000000000000010000000000000000000000000010000000000010000000000000000000000000000000000000100000000010000000000000000000000000000100000000000000000000000000000000001000000000000000001000000000000000000000000100000000000001000000000000010000000000000000000001000000000000000000000000000000000000001000000000000001000000001000000000000001000000000000000000000000010000000000000010000100000010000000000000000000000000000000000000000000000100000000000000100100000000000000000000000000000000010000001000001000000000000001000000000100000000000001000000010000000000000000110000000000000000000000000000000000000001000000000000000000000000000000001000000000000000000000000000000000000001000000000000000000000000000000000000000010000000000000000000000001000000000000000000001000000000000100000000000000000010000000000000000000000000010000000000000000000000100000000000000000000000000000000000000100000000000000000000010000000000000000000000000000000000000000001000000000000000000001000000000000000000000000000000000000000000000010000000000000000001000000000000000001000000000000000000000000000000000000000000000000001000000000000000010000000000000000000100000000000000000000010000000000000000000010000000000010000000000000000000000000100000000000000000000000010000000000000000000100000000000000001001000000000000000000010000000000000000000000100000000000000000000010000000000000000000000000000000000100000000000000000000000000000001000000000000000001000000000000000000000000000000000000000000110000000000000000001000000000000000000010000000100000000000000000000000000000100000000000000000000000000100000000000010000000000000000000000000000100100000000000000000000100000000000000000000000000000100000000000000000000000000000000000000000000000000000010000000000000000000010000000000000000000100000000000000000000000000000000000000000000100000000000000000000000010000000000000000000000000000000000010000000000000001000000000000000000000000000010000000000010000000000000000000000000000100000000000001000000000000000000000110000000000000000000000100000000000000000000000001000000000000000000000000000000000000000000100000000000000001000000000000000000000000001000000000000000000000000000000010010100000000000001000001000000001000000000001000000000000000000000000000000000000000000000100000000000001000000010000000000001000000000000000000000000000001000000000010000000000000000000100001000000000000000000000000000001000000000000000100000000000000000000000000000010000000000000000000000100000000000000000000000000010000000010000000100000000000000000000000000100001000000001000000000000000000000100000000000000000001000000001000000000000000000010000000000000000010000000000000000001000000000000000000001000000000000000000000100000000000000000000000000000000000000000100000000000000000000000000001000000000000000000000100000000000000000000000000000000010000000000000000000000001000000000000000000100000000000000000001000000000000");
        } catch (Exception e) {
            // ignore: handle exception
        }
    }

    static public Alignment getBinaryAlignment() throws Exception {
        Alignment data = new Alignment();
        data.initByName("sequence", German_ST, "sequence", Dutch_List, "sequence", English_ST, "sequence", French, "sequence", Italian, "sequence", Spanish,
                "dataType", "binary"
        );
        return data;
    }

    static public Alignment getCovarionAlignment() throws Exception {
        Alignment data = new Alignment();
        data.initByName("sequence", German_ST, "sequence", Dutch_List, "sequence", English_ST, "sequence", French, "sequence", Italian, "sequence", Spanish,
                "dataType", "twoStateCovarion", "strip", true
        );
        return data;
    }


    static public Alignment getAminoAcidAlignment() throws Exception {
        Sequence Struthio_camelus = new Sequence("Struthio_camelus", "VKYPNTNEEGKEVVLPKILSPIGSDGVYSNELANIEYTNVSKAAAAAFATVDDYKPVPLDYMLDSKTSNKNNVVESSGTLRHFGK");
        Sequence Rhea_americana = new Sequence("Rhea_americana", "VKYPNTNEEGKEVLLPEILNPVGTDGVYSNELANIEYTNVAKDAAAAFATVDDHKPVSLEYMLDSKTSNKDNVVESNGTLSHFGK");
        Sequence Pterocnemia_pennata = new Sequence("Pterocnemia_pennata", "VKYPNTNEEGKEVLLPEILNPVGADGVYSNELANIEYTNVSKDHDEVFATVDDHKPVSLEYMLDSKTSNKDNVVESNGTLSHFGK");
        Alignment data = new Alignment();
        data.initByName("sequence", Struthio_camelus, "sequence", Rhea_americana, "sequence", Pterocnemia_pennata,
                "dataType", "aminoacid"
        );
        return data;
    }

    static public Alignment getAscertainedAlignment() throws Exception {
        // same as getAlignment, but with first four sites the constant sites ACTG
        List<Sequence> sequences = new ArrayList<Sequence>();
        sequences.add(new Sequence("human", "ACTGAGAAATATGTCTGATAAAAGAGTTACTTTGATAGAGTAAATAATAGGAGCTTAAACCCCCTTATTTCTACTAGGACTATGAGAATCGAACCCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTATCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTATACCCTTCCCGTACTAAGAAATTTAGGTTAAATACAGACCAAGAGCCTTCAAAGCCCTCAGTAAGTTG-CAATACTTAATTTCTGTAAGGACTGCAAAACCCCACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGACCAATGGGACTTAAACCCACAAACACTTAGTTAACAGCTAAGCACCCTAATCAAC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTCGAATTTGCAATTCAATATGAAAA-TCACCTCGGAGCTTGGTAAAAAGAGGCCTAACCCCTGTCTTTAGATTTACAGTCCAATGCTTCA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCCAAAGCTGGTTTCAAGCCAACCCCATGGCCTCCATGACTTTTTCAAAAGGTATTAGAAAAACCATTTCATAACTTTGTCAAAGTTAAATTATAGGCT-AAATCCTATATATCTTA-CACTGTAAAGCTAACTTAGCATTAACCTTTTAAGTTAAAGATTAAGAGAACCAACACCTCTTTACAGTGA"));
        sequences.add(new Sequence("chimp", "ACTGAGAAATATGTCTGATAAAAGAATTACTTTGATAGAGTAAATAATAGGAGTTCAAATCCCCTTATTTCTACTAGGACTATAAGAATCGAACTCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTATCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTACACCCTTCCCGTACTAAGAAATTTAGGTTAAGCACAGACCAAGAGCCTTCAAAGCCCTCAGCAAGTTA-CAATACTTAATTTCTGTAAGGACTGCAAAACCCCACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGATTAATGGGACTTAAACCCACAAACATTTAGTTAACAGCTAAACACCCTAATCAAC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTCGAATTTGCAATTCAATATGAAAA-TCACCTCAGAGCTTGGTAAAAAGAGGCTTAACCCCTGTCTTTAGATTTACAGTCCAATGCTTCA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCTAAAGCTGGTTTCAAGCCAACCCCATGACCTCCATGACTTTTTCAAAAGATATTAGAAAAACTATTTCATAACTTTGTCAAAGTTAAATTACAGGTT-AACCCCCGTATATCTTA-CACTGTAAAGCTAACCTAGCATTAACCTTTTAAGTTAAAGATTAAGAGGACCGACACCTCTTTACAGTGA"));
        sequences.add(new Sequence("bonobo", "ACTGAGAAATATGTCTGATAAAAGAATTACTTTGATAGAGTAAATAATAGGAGTTTAAATCCCCTTATTTCTACTAGGACTATGAGAGTCGAACCCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTATCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTATACCCTTCCCGTACTAAGAAATTTAGGTTAAACACAGACCAAGAGCCTTCAAAGCTCTCAGTAAGTTA-CAATACTTAATTTCTGTAAGGACTGCAAAACCCCACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGATTAATGGGACTTAAACCCACAAACATTTAGTTAACAGCTAAACACCCTAATCAGC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTTGAATTTGCAATTCAATATGAAAA-TCACCTCAGAGCTTGGTAAAAAGAGGCTTAACCCCTGTCTTTAGATTTACAGTCCAATGCTTCA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCTAAAGCTGGTTTCAAGCCAACCCCATGACCCCCATGACTTTTTCAAAAGATATTAGAAAAACTATTTCATAACTTTGTCAAAGTTAAATTACAGGTT-AAACCCCGTATATCTTA-CACTGTAAAGCTAACCTAGCATTAACCTTTTAAGTTAAAGATTAAGAGGACCAACACCTCTTTACAGTGA"));
        sequences.add(new Sequence("gorilla", "ACTGAGAAATATGTCTGATAAAAGAGTTACTTTGATAGAGTAAATAATAGAGGTTTAAACCCCCTTATTTCTACTAGGACTATGAGAATTGAACCCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTGTCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTCACATCCTTCCCGTACTAAGAAATTTAGGTTAAACATAGACCAAGAGCCTTCAAAGCCCTTAGTAAGTTA-CAACACTTAATTTCTGTAAGGACTGCAAAACCCTACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGATCAATGGGACTCAAACCCACAAACATTTAGTTAACAGCTAAACACCCTAGTCAAC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTCGAATTTGCAATTCAATATGAAAT-TCACCTCGGAGCTTGGTAAAAAGAGGCCCAGCCTCTGTCTTTAGATTTACAGTCCAATGCCTTA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCCAAAGCTGGTTTCAAGCCAACCCCATGACCTTCATGACTTTTTCAAAAGATATTAGAAAAACTATTTCATAACTTTGTCAAGGTTAAATTACGGGTT-AAACCCCGTATATCTTA-CACTGTAAAGCTAACCTAGCGTTAACCTTTTAAGTTAAAGATTAAGAGTATCGGCACCTCTTTGCAGTGA"));
        sequences.add(new Sequence("orangutan", "ACTGAGAAATATGTCTGACAAAAGAGTTACTTTGATAGAGTAAAAAATAGAGGTCTAAATCCCCTTATTTCTACTAGGACTATGGGAATTGAACCCACCCCTGAGAATCCAAAATTCTCCGTGCCACCCATCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTACACCCTTCCCGTACTAAGAAATTTAGGTTA--CACAGACCAAGAGCCTTCAAAGCCCTCAGCAAGTCA-CAGCACTTAATTTCTGTAAGGACTGCAAAACCCCACTTTGCATCAACTGAGCGCAAATCAGCCACTTTAATTAAGCTAAGCCCTCCTAGACCGATGGGACTTAAACCCACAAACATTTAGTTAACAGCTAAACACCCTAGTCAAT-TGGCTTCAGTCCAAAGCCCCGGCAGGCCTTAAAGCTGCTCCTTCGAATTTGCAATTCAACATGACAA-TCACCTCAGGGCTTGGTAAAAAGAGGTCTGACCCCTGTTCTTAGATTTACAGCCTAATGCCTTAACTCGGCCATTTTACCGCAAAAAAGGAAGGAATCGAACCTCCTAAAGCTGGTTTCAAGCCAACCCCATAACCCCCATGACTTTTTCAAAAGGTACTAGAAAAACCATTTCGTAACTTTGTCAAAGTTAAATTACAGGTC-AGACCCTGTGTATCTTA-CATTGCAAAGCTAACCTAGCATTAACCTTTTAAGTTAAAGACTAAGAGAACCAGCCTCTCTTTGCAATGA"));
        sequences.add(new Sequence("siamang", "ACTGAGAAATACGTCTGACGAAAGAGTTACTTTGATAGAGTAAATAACAGGGGTTTAAATCCCCTTATTTCTACTAGAACCATAGGAGTCGAACCCATCCTTGAGAATCCAAAACTCTCCGTGCCACCCGTCGCACCCTGTTCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTATACCCTTCCCATACTAAGAAATTTAGGTTAAACACAGACCAAGAGCCTTCAAAGCCCTCAGTAAGTTAACAAAACTTAATTTCTGCAAGGGCTGCAAAACCCTACTTTGCATCAACCGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGATCGATGGGACTTAAACCCATAAAAATTTAGTTAACAGCTAAACACCCTAAACAACCTGGCTTCAATCTAAAGCCCCGGCAGA-GTTGAAGCTGCTTCTTTGAACTTGCAATTCAACGTGAAAAATCACTTCGGAGCTTGGCAAAAAGAGGTTTCACCTCTGTCCTTAGATTTACAGTCTAATGCTTTA-CTCAGCCACTTTACCACAAAAAAGGAAGGAATCGAACCCTCTAAAACCGGTTTCAAGCCAGCCCCATAACCTTTATGACTTTTTCAAAAGATATTAGAAAAACTATTTCATAACTTTGTCAAAGTTAAATCACAGGTCCAAACCCCGTATATCTTATCACTGTAGAGCTAGACCAGCATTAACCTTTTAAGTTAAAGACTAAGAGAACTACCGCCTCTTTACAGTGA"));
        Alignment data = null;
        data = new Alignment();
        for (Sequence sequence : sequences) {
            data.sequenceInput.setValue(sequence, data);
        }
        //data.m_nStateCount.setValue(4, data);
        data.dataTypeInput.setValue("nucleotide", data);
        data.excludefromInput.setValue(0, data);
        data.excludetoInput.setValue(4, data);
        data.excludeeveryInput.setValue(1, data);
        data.isAscertainedInput.setValue(true, data);
        data.initAndValidate();

        return data;
    }

    static public Tree getTree(Alignment data) throws Exception {
        TreeParser tree = new TreeParser();
        tree.initByName("taxa", data,
                "newick", "((((human:0.024003,(chimp:0.010772,bonobo:0.010772):0.013231):0.012035,gorilla:0.036038):0.033087000000000005,orangutan:0.069125):0.030456999999999998,siamang:0.099582);",
                "IsLabelledNewick", true);
        return tree;
    }

    static public Tree getAminoAcidTree(Alignment data) throws Exception {
        TreeParser tree = new TreeParser();
        tree.initByName("taxa", data,
                "newick", "(Struthio_camelus:0.09413496891819266,(Rhea_americana:0.03667415617018579,Pterocnemia_pennata:0.03667415617018579):0.05746081274800687);",
                "IsLabelledNewick", true);
        return tree;
    }
}