/****************************************************************
**
** Attal : Lords of Doom
**
** tavern.h
** Manage tavern building
**
** Version : $Id: tavern.h,v 1.8 2007/05/30 22:06:19 lusum Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo
**
** Date : 04/02/2005
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef TAVERN_H
#define TAVERN_H
 
 
// generic include files
// include files for QT
#include <QDialog>
#include <QList>

// application specific include files

class QLabel;
class QScrollArea;
class QSignalMapper;

class AttalSocket;
class GenericBase;
class GenericLord;
class GenericPlayer;
class Icon;
class TavernLord;
 
/*              ------------------------------
 *                         Tavern
 *              ------------------------------ */

class Tavern : public QDialog
{
	Q_OBJECT
public:
	/** Constructor */
	Tavern( QWidget * parent = 0 );

	~Tavern();
	
	void start( GenericBase * base );

	void restart();
	
	void initSocket( AttalSocket * socket );
	
	void initPlayer( GenericPlayer * player );
	
	void handleSocket();
	
public slots:
	void slot_buy( int numLord );
	
protected:
	void handleTavernInfo();
	
	void handleTavernLord();
	
	AttalSocket * _socket;
	QScrollArea * _scroll;
	uchar _nbLord, _nbLordRead;
	GenericBase * _base;
	GenericPlayer * _player;
	QList<TavernLord *> _lords;
	QSignalMapper * _signalMapper;
};

class TavernLord : public QWidget
{
	Q_OBJECT
public:
	TavernLord( QWidget * parent );
	
	~TavernLord();
	
	void init( GenericLord * lord );
	
	GenericLord * getLord() { return _lord; }
	
	void initPlayer( GenericPlayer * player );
	
signals:
	void sig_buy();
	
protected:
	Icon * _photo;
	QLabel * _info, * _price;
	GenericLord * _lord;
	GenericPlayer * _player;
	QPushButton * _pbBuy;
};
 
#endif // TAVERN_H   
