/****************************************************************
**
** Attal : Lords of Doom
**
** optionsDialog.cpp
**
** Author(s) : Nickolay Semenov
**
** Date : 23/08/2004
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "optionsDialog.h"

// generic include files
// include files for QT
#include <QCheckBox>
#include <QPushButton>
#include <QLayout>

// application specific includes
#include "libCommon/attalSettings.h"
#include "libCommon/log.h"

#include "libClient/askWidget.h"
#include "libClient/attalButton.h"
#include "libClient/gui.h"
 
OptionsDialog::OptionsDialog ( QWidget* parent, const char * /* name */ )
	: QDialog ( parent, Qt::Dialog | Qt::CustomizeWindowHint )
{
	_animationCheckBox = new QCheckBox ( tr( "Enable animation" ), this );
	FIXEDSIZE( _animationCheckBox );
#ifdef WITH_SOUND
	_musicCheckBox = new QCheckBox ( tr( "Enable music" ), this );
	FIXEDSIZE( _musicCheckBox );
	_soundCheckBox = new QCheckBox ( tr( "Enable sound" ), this );
	FIXEDSIZE( _musicCheckBox );
#endif

	_dispositionMode = new AskCombo( tr( "Disposition: " ), this );
	_dispositionMode->insertItem( tr( "Extra compact" ) ); // DM_VERYCOMPACT
	_dispositionMode->insertItem( tr( "Compact" ) ); // DM_COMPACT
	_dispositionMode->insertItem( tr( "Normal" ) ); // DM_FULL
	FIXEDSIZE( _dispositionMode );

	QVBoxLayout * vlayout = new QVBoxLayout();
	vlayout->setMargin( 5 );
	vlayout->setSpacing( 5 );
	vlayout->addWidget( _animationCheckBox );
#ifdef WITH_SOUND
	vlayout->addWidget( _musicCheckBox );
	vlayout->addWidget( _soundCheckBox );
#endif
	vlayout->addWidget( _dispositionMode );
	
	AttalButton * pbOk = new AttalButton ( this, AttalButton::BT_OK );	
	AttalButton * pbCancel = new AttalButton ( this, AttalButton::BT_CANCEL );

	QHBoxLayout * hlayout = new QHBoxLayout();
	hlayout->setMargin( 5 );
	hlayout->addStretch( 1 );
	hlayout->addWidget( pbCancel );
	hlayout->addStretch( 1 );
	hlayout->addWidget( pbOk );
	hlayout->addStretch( 1 );
	
	QVBoxLayout * mainlayout = new QVBoxLayout( this );
	mainlayout->addLayout( vlayout );
	mainlayout->addLayout( hlayout );
	mainlayout->activate();

	connect( pbOk, SIGNAL( clicked () ), this, SLOT( accept () ) );
	connect( pbCancel, SIGNAL( clicked () ), this, SLOT( reject () ) );
	connect( _animationCheckBox, SIGNAL( stateChanged( int ) ), this, SIGNAL( sig_animation( int ) ) );
#ifdef WITH_SOUND
	connect( _musicCheckBox, SIGNAL( stateChanged( int ) ), this, SIGNAL( sig_music( int ) ) );
	connect( _soundCheckBox, SIGNAL( stateChanged( int ) ), this, SIGNAL( sig_sound( int ) ) );
#endif
	
	FIXEDSIZE ( this );

	init();
}

void OptionsDialog::init()
{
	_animationCheckBox->setChecked( AttalSettings::getInstance()->getStrategyModeSettings().isAnimationEnabled );
#ifdef WITH_SOUND
	_musicCheckBox->setChecked( AttalSettings::getInstance()->getStrategyModeSettings().isMusicOn );
	_soundCheckBox->setChecked( AttalSettings::getInstance()->getStrategyModeSettings().isSoundOn );
#endif

	_dispositionMode->setCurrentItem( (int) AttalSettings::getInstance()->getDispositionMode() );
}

void OptionsDialog::accept()
{
	if( AttalSettings::getInstance()->getDispositionMode() != (AttalSettings::DispositionMode) _dispositionMode->currentItem() ) {
		AttalSettings::getInstance()->setDispositionMode( (AttalSettings::DispositionMode) _dispositionMode->currentItem() );
		emit sig_dispositions();
	}
	
	QDialog::accept ();
}


